VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SvrAssistPuntsLlum"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

Private Const ctStrNomClasse = "SvrAssistPuntsLlum" 'Nom de la classe
Private Const ctStrNomClasseEntitatPrincipal = "MngPuntsLLum"
Private objFuncionsComuns As clsFuncionsSubCapaSuport

'Serveix per cridar a les propietats i mtodes de les classes
'MngPuntsLlum, unes altres classes entitats IVisorXML i IMantXML respectivament
Private objMPuntsLlum As Object
Private objMPatronsPuntLlum As Object
Private objMPatronsPLluminaria As Object
Private objMPatronsSuport As Object
Private objMPatronsTerra As Object
Private objMPatronsCaixa As Object
Private objMPatronsLluminaria As Object
Private objMPropietatsSuport As Object
Private objMPatroPuntLlum As Object
Private objMCaractSuport As Object
Private objMLluminaries As Object
Private objMEscomeses As Object
Private objMCarrers As Object
Private objMPLlumPunts As Object
Private IVisorXMLActual As Object
Private IMantXMLActual As Object
Private AuxIdTransaccio As ADODB.Connection 'S'utilitza per implementar la variable pblica d'identificador de sessi
'----------------------------------------------------------------------------------------------
'-- Property Let i Get IdTransaccio()
'----------------------------------------------------------------------------------------------
' Implementa la variable IdTransaccio que indica el identificador de la transacci
'----------------------------------------------------------------------------------------------
Public Property Get IdTransaccio() As ADODB.Connection
   Set IdTransaccio = AuxIdTransaccio
End Property

Public Property Set IdTransaccio(connValor As ADODB.Connection)
   Set AuxIdTransaccio = connValor
End Property

'----------------------------------------------------------------------------------------------
'-- Class_Initialize()
'----------------------------------------------------------------------------------------------
' Du a terme les accions d'inicialitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Initialize()
   Set objFuncionsComuns = New clsFuncionsSubCapaSuport
End Sub
'----------------------------------------------------------------------------------------------
'-- Class_Terminate()
'----------------------------------------------------------------------------------------------
' Du a terme les accions de finalitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Terminate()
   Set objFuncionsComuns = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- GetPuntsLlum()
'----------------------------------------------------------------------------------------------
' Consulta tots els punts de llum definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPuntsLlum(lngEscomesa As Long) As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPuntsLlum = objFuncionsComuns.CreaObjecteEntitat("MngPuntsLlum", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPuntsLlum.GetIV
   strResultat = IVisorXMLActual.GetList("NumEscomesa = " & lngEscomesa)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsPuntllum
   Set objMPuntsLlum = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPuntsLlum = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPuntsLlum"
   GetPuntsLlum = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetPatronsPuntsLlum()
'----------------------------------------------------------------------------------------------
' Consulta tots els patrons definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPatronsPuntLlum() As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsPuntLlum = objFuncionsComuns.CreaObjecteEntitat("MngPatronsPuntLlum", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsPuntLlum.GetIV
   strResultat = IVisorXMLActual.GetList(objParametre)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsPuntllum
   Set objMPatronsPuntLlum = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPatronsPuntLlum = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPatronsPuntLlum"
   GetPatronsPuntLlum = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetPatronsPLluminaria()
'----------------------------------------------------------------------------------------------
' Consulta tots els patrons de lluminria definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPatronsPLluminaria() As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsPLluminaria = objFuncionsComuns.CreaObjecteEntitat("MngPatronsPLluminaria", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsPLluminaria.GetIV
   strResultat = IVisorXMLActual.GetList(objParametre)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsPLluminaria
   Set objMPatronsPLluminaria = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPatronsPLluminaria = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPatronsPLluminaria"
   GetPatronsPLluminaria = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetPatronsSuport()
'----------------------------------------------------------------------------------------------
' Consulta tots els patrons de suport definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPatronsSuport() As String
   Dim strResultat As String
         
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsSuport = objFuncionsComuns.CreaObjecteEntitat("MngPatronsSuport", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsSuport.GetIV
   strResultat = IVisorXMLActual.GetList("")
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsSuport
   Set objMPatronsSuport = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPatronsSuport = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPatronsSuport"
   GetPatronsSuport = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetPatronsTerra()
'----------------------------------------------------------------------------------------------
' Consulta tots els patrons de terra definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPatronsTerra() As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsTerra = objFuncionsComuns.CreaObjecteEntitat("MngPatronsTerra", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsTerra.GetIV
   strResultat = IVisorXMLActual.GetList("True")
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsTerra
   Set objMPatronsTerra = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPatronsTerra = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPatronsTerra"
   GetPatronsTerra = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetPatronsLluminaria()
'----------------------------------------------------------------------------------------------
' Consulta tots els patrons de lluminria definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPatronsLluminaria() As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsLluminaria = objFuncionsComuns.CreaObjecteEntitat("MngPatronsLluminaria", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsLluminaria.GetIV
   strResultat = IVisorXMLActual.GetList("True")
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatrons
   Set objMPatronsLluminaria = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPatronsLluminaria = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPatronsLluminaria"
   GetPatronsLluminaria = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetPatronsCaixa()
'----------------------------------------------------------------------------------------------
' Consulta tots els patrons de caixa definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPatronsCaixa() As String
   Dim strResultat As String
      
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsCaixa = objFuncionsComuns.CreaObjecteEntitat("MngPatronsCaixa", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsCaixa.GetIV
   strResultat = IVisorXMLActual.GetList("True")
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatrons
   Set objMPatronsCaixa = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPatronsCaixa = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPatronsCaixa"
   GetPatronsCaixa = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetPropietatsSuport()
'----------------------------------------------------------------------------------------------
' Consulta totes les propietats de suport definides a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPropietatsSuport(lngPatroSuport As Long) As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPropietatsSuport = objFuncionsComuns.CreaObjecteEntitat("MngPropietatsSuport", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPropietatsSuport.GetIV
   strResultat = IVisorXMLActual.GetList(lngPatroSuport)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatrons
   Set objMPropietatsSuport = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPropietatsSuport = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPropietatsSuport"
   GetPropietatsSuport = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- SavePatroPuntLlum()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SavePatroPuntLlum(strXMLPatroPuntLlum As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatroPuntLlum = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava el patr mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPatroPuntLlum.GetIM
   bolResultat = IMantXMLActual.Save(strXMLPatroPuntLlum)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatrons
   Set objMPatroPuntLlum = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SavePatroPuntLlum = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SavePatroPuntLlum"
   SavePatroPuntLlum = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetEmptyRstPLluminaria()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent a un recordset buit de punts de lluminria
' per tal de poder inserir-hi un nou punt.
'----------------------------------------------------------------------------------------------
Public Function GetEmptyRstPLluminaria() As String
   
   Dim strResultat As String
   Dim objParametre As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsPLluminaria = objFuncionsComuns.CreaObjecteEntitat("MngPatronsPLluminaria", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els punts mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPatronsPLluminaria.GetIM
   strResultat = IMantXMLActual.GetEmpty(objParametre)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsPLluminaria
   Set objMPatronsPLluminaria = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEmptyRstPLluminaria = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEmptyRstPLluminaria"
   GetEmptyRstPLluminaria = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- SavePatroPLluminaria()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SavePatroPLluminaria(strXMLPatroPLluminaria As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsPLluminaria = objFuncionsComuns.CreaObjecteEntitat("MngPatronsPLluminaria", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava el patr mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPatronsPLluminaria.GetIM
   bolResultat = IMantXMLActual.Save(strXMLPatroPLluminaria)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatroPLluminaria
   Set objMPatronsPLluminaria = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SavePatroPLluminaria = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SavePatroPLluminaria"
   SavePatroPLluminaria = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- DeletePatroPLluminaria()
'----------------------------------------------------------------------------------------------
' Esborra un registre de la taula T_PatroPlluminaria l'identificador del qual
'es passa com a parmetre
'----------------------------------------------------------------------------------------------
Public Function DeletePatroPLluminaria(lngPatroPLluminaria As Long) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsPLluminaria = objFuncionsComuns.CreaObjecteEntitat("MngPatroPLluminaria", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'S'esborra el patr mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPatronsPLluminaria.GetIM
   bolResultat = IMantXMLActual.Delete(lngPatroPLluminaria)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatroPlluminaria
   Set objMPatronsPLluminaria = Nothing
    
   'Si no hi ha hagut errors, retorna True
   DeletePatroPLluminaria = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - DeletePatroPLluminaria"
   DeletePatroPLluminaria = False
   Exit Function
End Function


'----------------------------------------------------------------------------------------------
'-- GetEmptyRstPuntLlum()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent a un recordset buit de punts de llum
' per tal de poder inserir-hi un nou punt.
'----------------------------------------------------------------------------------------------
Public Function GetEmptyRstPuntLlum() As String
   
   Dim strResultat As String
   Dim objParametre As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPuntsLlum = objFuncionsComuns.CreaObjecteEntitat("MngPuntsLlum", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els punts mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPuntsLlum.GetIM
   strResultat = IMantXMLActual.GetEmpty(objParametre)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPuntsLLum
   Set objMPuntsLlum = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEmptyRstPuntLlum = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEmptyRstPuntLlum"
   GetEmptyRstPuntLlum = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- SavePuntLlum()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SavePuntLlum(strXMLPuntLlum As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPuntsLlum = objFuncionsComuns.CreaObjecteEntitat("MngPuntsLlum", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava el punt mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPuntsLlum.GetIM
   bolResultat = IMantXMLActual.Save(strXMLPuntLlum)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPuntsLlum
   Set objMPuntsLlum = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SavePuntLlum = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SavePuntLlum"
   SavePuntLlum = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetEmptyRstCaractSuport()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent a un recordset buit de caracterstiques de suport
' per tal de poder inserir-hi una nova caracterstica .
'----------------------------------------------------------------------------------------------
Public Function GetEmptyRstCaractSuport() As String
   
   Dim strResultat As String
   Dim objParametre As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMCaractSuport = objFuncionsComuns.CreaObjecteEntitat("MngCaractSuport", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen les caracterstiques mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMCaractSuport.GetIM
   strResultat = IMantXMLActual.GetEmpty(objParametre)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngCaractSuport
   Set objMCaractSuport = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEmptyRstCaractSuport = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEmptyRstCaractSuport"
   GetEmptyRstCaractSuport = ""
   Exit Function
End Function


'----------------------------------------------------------------------------------------------
'-- SaveCaractSuport()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SaveCaractSuport(strXMLCaractSuport As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMCaractSuport = objFuncionsComuns.CreaObjecteEntitat("MngCaractSuport", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava la caracterstica mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMCaractSuport.GetIM
   bolResultat = IMantXMLActual.Save(strXMLCaractSuport)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngCaractSuport
   Set objMCaractSuport = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SaveCaractSuport = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SaveCaractSuport"
   SaveCaractSuport = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetEmptyRstPropietatsSuport()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent a un recordset buit de propietats de suport
' per tal de poder inserir-hi una nova propietat .
'----------------------------------------------------------------------------------------------
Public Function GetEmptyRstPropietatsSuport() As String
   
   Dim strResultat As String
   Dim objParametre As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPropietatsSuport = objFuncionsComuns.CreaObjecteEntitat("MngPropietatsSuport", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen les propietats mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPropietatsSuport.GetIM
   strResultat = IMantXMLActual.GetEmpty(objParametre)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPropietatsSuport
   Set objMPropietatsSuport = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEmptyRstPropietatsSuport = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEmptyRstPropietatsSuport"
   GetEmptyRstPropietatsSuport = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- SavePropietatSuport()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SavePropietatSuport(strXMLCaractSuport As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPropietatsSuport = objFuncionsComuns.CreaObjecteEntitat("MngPropietatsSuport", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava la caracterstica mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPropietatsSuport.GetIM
   bolResultat = IMantXMLActual.Save(strXMLCaractSuport)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPropietatsSuport
   Set objMPropietatsSuport = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SavePropietatSuport = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SavePropietatSuport"
   SavePropietatSuport = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetEmptyRstLluminaria()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent a un recordset buit de lluminries
' per tal de poder inserir-hi una nova lluminria
'----------------------------------------------------------------------------------------------
Public Function GetEmptyRstLluminaria() As String
   
   Dim strResultat As String
   Dim objParametre As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMLluminaries = objFuncionsComuns.CreaObjecteEntitat("MngLluminaries", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen les lluminries mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMLluminaries.GetIM
   strResultat = IMantXMLActual.GetEmpty(objParametre)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngLluminaries
   Set objMLluminaries = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEmptyRstLluminaria = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEmptyRstLluminaria"
   GetEmptyRstLluminaria = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- SaveLluminaria()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SaveLluminaria(strXMLLluminaria As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMLluminaries = objFuncionsComuns.CreaObjecteEntitat("MngLluminaries", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava la lluminria mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMLluminaries.GetIM
   bolResultat = IMantXMLActual.Save(strXMLLluminaria)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngLluminaries
   Set objMLluminaries = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SaveLluminaria = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SaveLluminaria"
   SaveLluminaria = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetEscomeses()
'----------------------------------------------------------------------------------------------
' Consulta totes les escomeses definides a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetEscomeses(lngProjecte As Long) As String
   Dim strResultat As String
   Dim objParametre As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea el parmetre per passar a el GetList de MngEscomeses
   Set objParametre = objFuncionsComuns.CreaObjecteEntitat("paramListEscomeses")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Se li passa l'identificador del projecte en el parmetre
   objParametre.lngIdentificador = lngProjecte
   objParametre.lngTipusIdentificador = 2 '2 vol dir que estem passant un projecte
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMEscomeses = objFuncionsComuns.CreaObjecteEntitat("MngEscomeses", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen les escomeses mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMEscomeses.GetIV
   strResultat = IVisorXMLActual.GetList(objParametre)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngEscomeses
   Set objMEscomeses = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEscomeses = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEscomeses"
   GetEscomeses = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetCarrers()
'----------------------------------------------------------------------------------------------
' Consulta tots els carrers definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetCarrers(lngProjecte As Long) As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMCarrers = objFuncionsComuns.CreaObjecteEntitat("MngCarrers", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els carrers mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMCarrers.GetIV
   strResultat = IVisorXMLActual.GetList(lngProjecte)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngCarrers
   Set objMCarrers = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetCarrers = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetCarrers"
   GetCarrers = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetTextIdioma()
'----------------------------------------------------------------------------------------------
' Recupera tots els textos d'un formulari en un idioma determinat.
' Els retorna en format XML
'----------------------------------------------------------------------------------------------
Public Function GetTextIdioma(lngIdioma As Long, strNomForm As String) As String
   Dim strResultat As String
     
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
        
   'Es crida a la funci de la classe clsFuncionsSubCapaSuport
   'per recuperar els textos de l'idioma
   strResultat = objFuncionsComuns.GetTextIdiomaForm(lngIdioma, strNomForm)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetTextIdioma = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetTextIdioma"
   GetTextIdioma = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetEmptyRstPLlumPunts()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent a un recordset buit
' per tal de poder inserir-hi un nou registre.
'----------------------------------------------------------------------------------------------
Public Function GetEmptyRstPLlumPunts() As String
   
   Dim strResultat As String
   Dim objParametre As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPLlumPunts = objFuncionsComuns.CreaObjecteEntitat("MngPLlumPunts", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els registres mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPLlumPunts.GetIM
   strResultat = IMantXMLActual.GetEmpty(objParametre)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPLlumPunts
   Set objMPLlumPunts = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEmptyRstPLlumPunts = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEmptyRstPLlumPunts"
   GetEmptyRstPLlumPunts = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- SavePLlumPunt()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SavePLlumPunt(strXMLPuntLlum As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPLlumPunts = objFuncionsComuns.CreaObjecteEntitat("MngPLlumPunts", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava el punt mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPLlumPunts.GetIM
   bolResultat = IMantXMLActual.Save(strXMLPuntLlum)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPuntsLlum
   Set objMPLlumPunts = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SavePLlumPunt = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SavePLlumPunt"
   SavePLlumPunt = False
   Exit Function
End Function


'----------------------------------------------------------------------------------------------
'-- DeletePLlumPunts()
'----------------------------------------------------------------------------------------------
' Esborra el registre l'identificador del qual
'es passa com a parmetre
'----------------------------------------------------------------------------------------------
Public Function DeletePLlumPunts(lngPLlumPunts As Long) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPLlumPunts = objFuncionsComuns.CreaObjecteEntitat("MngPLlumPunts", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'S'esborra el registre mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPLlumPunts.GetIM
   bolResultat = IMantXMLActual.Delete(lngPLlumPunts)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPLlumPunts
   Set objMPLlumPunts = Nothing
    
   'Si no hi ha hagut errors, retorna True
   DeletePLlumPunts = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - DeletePLlumPunts"
   DeletePLlumPunts = False
   Exit Function

End Function

