VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SvrCarrers"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

Private Const ctStrNomClasse = "SvrCarrers" 'Nom de la classe
Private Const ctStrNomClasseEntitatPrincipal = "MngCarrers"
Private objFuncionsComuns As clsFuncionsSubCapaSuport

'Serveix per cridar a les propietats i mtodes de les classes
'MngCarrers, MngIdioma, IVisorXML i IMantXML respectivament
Private objMCarrers As Object
Private objMCarrerPunts As Object
Private objMIdioma As Object
Private IVisorXMLActual As Object
Private IMantXMLActual As Object
Private AuxIdTransaccio As ADODB.Connection 'S'utilitza per implementar la variable pblica d'identificador de sessi
'----------------------------------------------------------------------------------------------
'-- Property Let i Get IdTransaccio()
'----------------------------------------------------------------------------------------------
' Implementa la variable IdTransaccio que indica el identificador de la transacci
'----------------------------------------------------------------------------------------------
Public Property Get IdTransaccio() As ADODB.Connection
   Set IdTransaccio = AuxIdTransaccio
End Property

Public Property Set IdTransaccio(connValor As ADODB.Connection)
   Set AuxIdTransaccio = connValor
End Property

'----------------------------------------------------------------------------------------------
'-- Class_Initialize()
'----------------------------------------------------------------------------------------------
' Du a terme les accions d'inicialitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Initialize()
   Set objFuncionsComuns = New clsFuncionsSubCapaSuport
End Sub
'----------------------------------------------------------------------------------------------
'-- Class_Terminate()
'----------------------------------------------------------------------------------------------
' Du a terme les accions de finalitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Terminate()
   Set objFuncionsComuns = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- GetCarrers()
'----------------------------------------------------------------------------------------------
' Consulta tots els carrers definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetCarrers(lngCarrer As Long) As String
   Dim strResultat As String
      
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMCarrers = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els carrers mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMCarrers.GetIV
   strResultat = IVisorXMLActual.GetList(lngCarrer)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngCarrers
   Set objMCarrers = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetCarrers = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetCarrers"
   GetCarrers = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetCarrerById()
'----------------------------------------------------------------------------------------------
' Recupera com a XML la informaci sobre el carrer l'identificador del qual es passa
' com a parmetre a aquesta funci
'----------------------------------------------------------------------------------------------
Public Function GetCarrerById(lngCarrer As Long) As String
   Dim strResultat As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMCarrers = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els carrers mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMCarrers.GetIV
   strResultat = IVisorXMLActual.GetById(lngCarrer)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngCarrers
   Set objMCarrers = Nothing
           
   'Si no hi ha hagut errors, retorna el resultat de la funci ConsultaXML
   GetCarrerById = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetCarrerById"
   GetCarrerById = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- SaveCarrer()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SaveCarrer(strXMLCarrer As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMCarrers = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava el carrer mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMCarrers.GetIM
   bolResultat = IMantXMLActual.Save(strXMLCarrer)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngCarrers
   Set objMCarrers = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SaveCarrer = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SaveCarrer"
   SaveCarrer = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- DeleteCarrer()
'----------------------------------------------------------------------------------------------
' Esborra el carrer l'identificador del qual
'es passa com a parmetre
'----------------------------------------------------------------------------------------------
Public Function DeleteCarrer(lngCarrer As Long) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMCarrers = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'S'esborra el carrer mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMCarrers.GetIM
   bolResultat = IMantXMLActual.Delete(lngCarrer)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngCarrers
   Set objMCarrers = Nothing
    
   'Si no hi ha hagut errors, retorna True
   DeleteCarrer = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - DeleteCarrer"
   DeleteCarrer = False
   Exit Function

End Function

'----------------------------------------------------------------------------------------------
'-- GetEmptyRecordset()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent a un recordset buit de carrers
' per tal de poder inserir-hi un nou carrer.
'----------------------------------------------------------------------------------------------
Public Function GetEmptyRecordset() As String
   
   Dim strResultat As String
   Dim objParametre As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMCarrers = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els carrers mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMCarrers.GetIM
   strResultat = IMantXMLActual.GetEmpty(objParametre)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngCarrers
   Set objMCarrers = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEmptyRecordset = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEmptyRecordset"
   GetEmptyRecordset = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- GetTextIdioma()
'----------------------------------------------------------------------------------------------
' Recupera tots els textos d'un formulari en un idioma determinat.
' Els retorna en format XML
'----------------------------------------------------------------------------------------------
Public Function GetTextIdioma(lngIdioma As Long, strNomForm As String) As String
   Dim strResultat As String
     
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
        
   'Es crida a la funci de la classe clsFuncionsSubCapaSuport
   'per recuperar els textos de l'idioma
   strResultat = objFuncionsComuns.GetTextIdiomaForm(lngIdioma, strNomForm)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetTextIdioma = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetTextIdioma"
   GetTextIdioma = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetCarrerPunts()
'----------------------------------------------------------------------------------------------
' Consulta tots els punts corresponents a un determinat carrer
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetCarrerPunts(lngCarrer As Long) As String
   Dim strResultat As String
      
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat MngCarrerPunts
   Set objMCarrerPunts = objFuncionsComuns.CreaObjecteEntitat("MngCarrerPunts", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els punts mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMCarrerPunts.GetIV
   strResultat = IVisorXMLActual.GetList(lngCarrer)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngCarrerPunts
   Set objMCarrerPunts = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetCarrerPunts = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetCarrerPunts"
   GetCarrerPunts = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- SaveCarrerPunt()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SaveCarrerPunt(strXMLCarrerPunts As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat MngCarrerPunts
   Set objMCarrerPunts = objFuncionsComuns.CreaObjecteEntitat("MngCarrerPunts", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava el punt mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMCarrerPunts.GetIM
   bolResultat = IMantXMLActual.Save(strXMLCarrerPunts)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngCarrerPunts
   Set objMCarrerPunts = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SaveCarrerPunt = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SaveCarrerPunt"
   SaveCarrerPunt = False
   Exit Function
End Function


'----------------------------------------------------------------------------------------------
'-- DeleteCarrerPunts()
'----------------------------------------------------------------------------------------------
' Esborra el carrer l'identificador del qual
' es passa com a parmetre
'----------------------------------------------------------------------------------------------
Public Function DeleteCarrerPunts(lngCarrer As Long) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es crea un objecte de classe de l'entitat MngCarrerPunts
   Set objMCarrerPunts = objFuncionsComuns.CreaObjecteEntitat("MngCarrerPunts", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'S'esborra el carrer mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMCarrerPunts.GetIM
   bolResultat = IMantXMLActual.Delete(lngCarrer)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngCarrerPunts
   Set objMCarrerPunts = Nothing
    
   'Si no hi ha hagut errors, retorna True
   DeleteCarrerPunts = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - DeleteCarrerPunts"
   DeleteCarrerPunts = False
   Exit Function

End Function

'----------------------------------------------------------------------------------------------
'-- GetEmptyRstCarrerPunts()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent a un recordset buit de punts de carrers
' per tal de poder inserir-hi un nou punt.
'----------------------------------------------------------------------------------------------
Public Function GetEmptyRstCarrerPunts() As String
   
   Dim strResultat As String
   Dim objParametre As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat MngCarrerPunts
   Set objMCarrerPunts = objFuncionsComuns.CreaObjecteEntitat("MngCarrerPunts", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els punts mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMCarrerPunts.GetIM
   strResultat = IMantXMLActual.GetEmpty(objParametre)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngCarrerPunts
   Set objMCarrerPunts = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEmptyRstCarrerPunts = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEmptyRstCarrerPunts"
   GetEmptyRstCarrerPunts = ""
   Exit Function
End Function


