VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SvrClients"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

Private Const ctStrNomClasse = "SvrClients" 'Nom de la classe
Private Const ctStrNomClasseEntitatPrincipal = "MngClients"
Private objFuncionsComuns As clsFuncionsSubCapaSuport

'Serveix per cridar a les propietats i mtodes de les classes
'MngClients, MngProjectes, IVisorXML i IMantXML respectivament
Private objMClients As Object
Private objMProjectes As Object
Private IVisorXMLActual As Object
Private IMantXMLActual As Object
Private AuxIdTransaccio As ADODB.Connection 'S'utilitza per implementar la variable pblica d'identificador de sessi
'----------------------------------------------------------------------------------------------
'-- Property Let i Get IdTransaccio()
'----------------------------------------------------------------------------------------------
' Implementa la variable IdTransaccio que indica el identificador de la transacci
'----------------------------------------------------------------------------------------------
Public Property Get IdTransaccio() As ADODB.Connection
   Set IdTransaccio = AuxIdTransaccio
End Property

Public Property Set IdTransaccio(connValor As ADODB.Connection)
   Set AuxIdTransaccio = connValor
End Property

'----------------------------------------------------------------------------------------------
'-- Class_Initialize()
'----------------------------------------------------------------------------------------------
' Du a terme les accions d'inicialitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Initialize()
   Set objFuncionsComuns = New clsFuncionsSubCapaSuport
End Sub
'----------------------------------------------------------------------------------------------
'-- Class_Terminate()
'----------------------------------------------------------------------------------------------
' Du a terme les accions de finalitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Terminate()
   Set objFuncionsComuns = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- GetClients()
'----------------------------------------------------------------------------------------------
' Consulta tots els clients definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetClients() As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMClients = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els clients mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMClients.GetIV
   strResultat = IVisorXMLActual.GetList(objParametre)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngClients
   Set objMClients = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetClients = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetClients"
   GetClients = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetClientById()
'----------------------------------------------------------------------------------------------
' Recupera com a XML la informaci sobre el client l'identificador del qual es passa
' com a parmetre a aquesta funci
'----------------------------------------------------------------------------------------------
Public Function GetClientById(lngClient As Long) As String
   Dim strResultat As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMClients = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els clients mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMClients.GetIV
   strResultat = IVisorXMLActual.GetById(lngClient)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngClients
   Set objMClients = Nothing
           
   'Si no hi ha hagut errors, retorna el resultat de la funci ConsultaXML
   GetClientById = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetClientById"
   GetClientById = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- SaveClient()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SaveClient(strXMLClient As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMClients = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava el client mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMClients.GetIM
   bolResultat = IMantXMLActual.Save(strXMLClient)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngClients
   Set objMClients = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SaveClient = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SaveClient"
   SaveClient = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- DeleteClient()
'----------------------------------------------------------------------------------------------
' Esborra el client l'identificador del qual
'es passa com a parmetre
'----------------------------------------------------------------------------------------------
Public Function DeleteClient(lngClient As Long) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMClients = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'S'esborra el client mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMClients.GetIM
   bolResultat = IMantXMLActual.Delete(lngClient)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngClients
   Set objMClients = Nothing
    
   'Si no hi ha hagut errors, retorna True
   DeleteClient = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - DeleteClient"
   DeleteClient = False
   Exit Function

End Function

'----------------------------------------------------------------------------------------------
'-- GetEmptyRecordset()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent a un recordset buit de clients
' per tal de poder inserir-hi un nou client.
'----------------------------------------------------------------------------------------------
Public Function GetEmptyRecordset() As String
   
   Dim strResultat As String
   Dim objParametre As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMClients = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els clients mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMClients.GetIM
   strResultat = IMantXMLActual.GetEmpty(objParametre)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngClients
   Set objMClients = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEmptyRecordset = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEmptyRecordset"
   GetEmptyRecordset = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- GetTextIdioma()
'----------------------------------------------------------------------------------------------
' Recupera tots els textos d'un formulari en un idioma determinat.
' Els retorna en format XML
'----------------------------------------------------------------------------------------------
Public Function GetTextIdioma(lngIdioma As Long, strNomForm As String) As String
   Dim strResultat As String
     
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
        
   'Es crida a la funci de la classe clsFuncionsSubCapaSuport
   'per recuperar els textos de l'idioma
   strResultat = objFuncionsComuns.GetTextIdiomaForm(lngIdioma, strNomForm)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetTextIdioma = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetTextIdioma"
   GetTextIdioma = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetProjectes()
'----------------------------------------------------------------------------------------------
' Consulta tots els projectes definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetProjectes() As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMProjectes = objFuncionsComuns.CreaObjecteEntitat("MngProjectes", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els clients mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMProjectes.GetIV
   strResultat = IVisorXMLActual.GetList(objParametre)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngClients
   Set objMProjectes = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetProjectes = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetProjectes"
   GetProjectes = ""
   Exit Function
End Function


