VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SvrIdiomes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

Private Const ctStrNomClasse = "SvrIdiomes" 'Nom de la classe
Private Const ctStrNomClasseEntitatPrincipal = "MngIdioma"
Private objFuncionsComuns As clsFuncionsSubCapaSuport

Private objMIdioma As Object 'Per cridar la classe MngIdioma
Private objMUsuari As Object 'Per cridar la classe MngUsuaris amb interfcie Visor
Private objMUsuaris As Object 'Per cridar la classe MngUsuaris amb interfcie Mant
Private objMTaulesAuxiliars As Object 'Per cridar la classe taules Auxiliars

'Serveix per cridar a les propietats i mtodes de les classes
'IVisorXML i IMantXML respectivament

Private IVisorXMLActual As Object
Private IMantXMLActual As Object
Private AuxIdTransaccio As ADODB.Connection 'S'utilitza per implementar la variable pblica d'identificador de sessi
'----------------------------------------------------------------------------------------------
'-- Property Let i Get IdTransaccio()
'----------------------------------------------------------------------------------------------
' Implementa la variable IdTransaccio que indica el identificador de la transacci
'----------------------------------------------------------------------------------------------
Public Property Get IdTransaccio() As ADODB.Connection
   Set IdTransaccio = AuxIdTransaccio
End Property

Public Property Set IdTransaccio(connValor As ADODB.Connection)
   Set AuxIdTransaccio = connValor
End Property

'----------------------------------------------------------------------------------------------
'-- Class_Initialize()
'----------------------------------------------------------------------------------------------
' Du a terme les accions d'inicialitzaci de la classe
'----------------------------------------------------------------------------------------------

Private Sub Class_Initialize()
   Set objFuncionsComuns = New clsFuncionsSubCapaSuport
End Sub

'----------------------------------------------------------------------------------------------
'-- Class_Terminate()
'----------------------------------------------------------------------------------------------
' Du a terme les accions de finalitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Terminate()
   Set objFuncionsComuns = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- GetIdiomes()
'----------------------------------------------------------------------------------------------
' Consulta tots els idiomes definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetIdiomes() As String
   Dim strResultat As String
   Dim objparamListIdioma As Object
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
        
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMTaulesAuxiliars = objFuncionsComuns.CreaObjecteEntitat("MngTaulesAuxiliars", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es crea un objecte de classe paramListTaulaAuxiliar
   Set objparamListIdioma = objFuncionsComuns.CreaObjecteEntitat("paramListTaulaAuxiliar")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es passen els parmetres mitjanant l'objecte objparamListIdioma
   objparamListIdioma.strNomTaula = "TTI_Idioma"
   objparamListIdioma.strNomCampOrdre = "CodIdioma"

   'Es recuperen els idiomes mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMTaulesAuxiliars.GetIV
   strResultat = IVisorXMLActual.GetList(objparamListIdioma)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngTaulesAuxiliars
   Set objMTaulesAuxiliars = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetIdiomes = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetIdiomes"
   GetIdiomes = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetUsuariById()
'----------------------------------------------------------------------------------------------
' Recupera com a XML la informaci sobre l'usuari l'identificador del qual es passa
' com a parmetre a aquesta funci
'----------------------------------------------------------------------------------------------
Public Function GetUsuariById(lngUsuari As Long) As String
   Dim strResultat As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMUsuaris = objFuncionsComuns.CreaObjecteEntitat("MngUsuaris", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recupera l'usuari mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMUsuaris.GetIV
   strResultat = IVisorXMLActual.GetById(lngUsuari)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngUsuari
   Set objMUsuaris = Nothing
           
   'Si no hi ha hagut errors, retorna el resultat de la funci ConsultaXML
   GetUsuariById = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetUsuariById"
   GetUsuariById = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- SaveUsuari()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SaveUsuari(strXMLUsuari As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMUsuari = objFuncionsComuns.CreaObjecteEntitat("MngUsuaris", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava l'usuari mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMUsuari.GetIM
   bolResultat = IMantXMLActual.Save(strXMLUsuari)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngUsuaris
   Set objMUsuari = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SaveUsuari = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SaveUsuari"
   SaveUsuari = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetTextIdioma()
'----------------------------------------------------------------------------------------------
' Recupera tots els textos d'un formulari en un idioma determinat.
' Els retorna en format XML
'----------------------------------------------------------------------------------------------
Public Function GetTextIdioma(lngIdioma As Long, strNomForm As String) As String
   Dim strResultat As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
 
   'Es crida a la funci de la classe clsFuncionsSubCapaSuport
   'per recuperar els textos de l'idioma
   strResultat = objFuncionsComuns.GetTextIdiomaForm(lngIdioma, strNomForm)
 
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
 
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   
   GetTextIdioma = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetTextIdioma"
   GetTextIdioma = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetTextIdiomaById()
'----------------------------------------------------------------------------------------------
' Recupera tots un determinat text en un idioma determinat.
' Els retorna en format XML
'----------------------------------------------------------------------------------------------
Public Function GetTextIdiomaById(strCodiTextIdioma As String, lngIdioma As Long) As String
   Dim strResultat As String
   Dim objparamTextIdioma As Object
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
 
   'Es crida a la funci de la classe clsFuncionsSubCapaSuport
   'per crear un objecte de classe MngIdioma
   Set objMIdioma = objFuncionsComuns.CreaObjecteEntitat("MngIdioma")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es crida a la funci de la classe clsFuncionsSubCapaSuport
   'per crear un objecte de classe paramTextIdioma
   Set objparamTextIdioma = objFuncionsComuns.CreaObjecteEntitat("paramTextIdioma")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'S'omplen les dades de l'objecte paramTextIdioma
   objparamTextIdioma.lngNumIdioma = lngIdioma
   objparamTextIdioma.strCodiText = strCodiTextIdioma
   
   'Es recuperen els idiomes mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMIdioma.GetIV
   strResultat = IVisorXMLActual.GetById(objparamTextIdioma)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
  
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   
   GetTextIdiomaById = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetTextIdiomaById"
   'Si no s'ha pogut traduir l'error, es retorna el seu codi
   GetTextIdiomaById = strCodiTextIdioma
   Exit Function
End Function



