VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SvrPatronsLluminaria"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

Private Const ctStrNomClasse = "SvrPatronsLluminaria" 'Nom de la classe
Private Const ctStrNomClasseEntitatPrincipal = "MngPatronsLluminaria"
Private objFuncionsComuns As clsFuncionsSubCapaSuport

'Serveix per cridar a les propietats i mtodes de les classes
'MngPatronsLluminaria, MngTaulesAuxiliars, IVisorXML i IMantXML respectivament
Private objMPatronsLluminaria As Object
Private objMAuxiliar As Object
Private IVisorXMLActual As Object
Private IMantXMLActual As Object
Private AuxIdTransaccio As ADODB.Connection 'S'utilitza per implementar la variable pblica d'identificador de sessi
'----------------------------------------------------------------------------------------------
'-- Property Let i Get IdTransaccio()
'----------------------------------------------------------------------------------------------
' Implementa la variable IdTransaccio que indica el identificador de la transacci
'----------------------------------------------------------------------------------------------
Public Property Get IdTransaccio() As ADODB.Connection
   Set IdTransaccio = AuxIdTransaccio
End Property

Public Property Set IdTransaccio(connValor As ADODB.Connection)
   Set AuxIdTransaccio = connValor
End Property

'----------------------------------------------------------------------------------------------
'-- Class_Initialize()
'----------------------------------------------------------------------------------------------
' Du a terme les accions d'inicialitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Initialize()
   Set objFuncionsComuns = New clsFuncionsSubCapaSuport
End Sub
'----------------------------------------------------------------------------------------------
'-- Class_Terminate()
'----------------------------------------------------------------------------------------------
' Du a terme les accions de finalitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Terminate()
   Set objFuncionsComuns = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- GetPatronsLluminaria()
'----------------------------------------------------------------------------------------------
' Consulta tots els patrons de lluminria definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPatronsLluminaria(strCondicions As String) As String
   Dim strResultat As String
      
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsLluminaria = _
    objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons de lluminria mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsLluminaria.GetIV
   strResultat = IVisorXMLActual.GetList(strCondicions)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsLluminaria
   Set objMPatronsLluminaria = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPatronsLluminaria = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPatronsLluminaria"
   GetPatronsLluminaria = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- SavePatroLluminaria()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SavePatroLluminaria(strXMLPatroLluminaria As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsLluminaria = _
    objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava el patr de lluminria mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPatronsLluminaria.GetIM
   bolResultat = IMantXMLActual.Save(strXMLPatroLluminaria)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsLLuminaria
   Set objMPatronsLluminaria = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SavePatroLluminaria = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SavePatroLluminaria"
   SavePatroLluminaria = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- DeletePatroLluminaria()
'----------------------------------------------------------------------------------------------
' Esborra el patr de lluminria l'identificador del qual
'es passa com a parmetre
'----------------------------------------------------------------------------------------------
Public Function DeletePatroLluminaria(lngPatroLluminaria As Long) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsLluminaria = _
    objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'S'esborra el patr de lluminria mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPatronsLluminaria.GetIM
   bolResultat = IMantXMLActual.Delete(lngPatroLluminaria)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsLluminaria
   Set objMPatronsLluminaria = Nothing
    
   'Si no hi ha hagut errors, retorna True
   DeletePatroLluminaria = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - DeletePatroLluminaria"
   DeletePatroLluminaria = False
   Exit Function

End Function

'----------------------------------------------------------------------------------------------
'-- GetEmptyRecordset()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent a un recordset buit de patrons
' per tal de poder inserir-hi un nou patr.
'----------------------------------------------------------------------------------------------
Public Function GetEmptyRecordset() As String
   
   Dim strResultat As String
   Dim objParametre As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsLluminaria = _
    objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons de lluminria mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPatronsLluminaria.GetIM
   strResultat = IMantXMLActual.GetEmpty(objParametre)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsLluminaria
   Set objMPatronsLluminaria = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEmptyRecordset = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEmptyRecordset"
   GetEmptyRecordset = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- GetTextIdioma()
'----------------------------------------------------------------------------------------------
' Recupera tots els textos d'un formulari en un idioma determinat.
' Els retorna en format XML
'----------------------------------------------------------------------------------------------
Public Function GetTextIdioma(lngIdioma As Long, strNomForm As String) As String
   Dim strResultat As String
     
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
        
   'Es crida a la funci de la classe clsFuncionsSubCapaSuport
   'per recuperar els textos de l'idioma
   strResultat = objFuncionsComuns.GetTextIdiomaForm(lngIdioma, strNomForm)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetTextIdioma = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetTextIdioma"
   GetTextIdioma = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- GetListAuxiliar()
'----------------------------------------------------------------------------------------------
' Consulta totes els elements d'una taula auxiliar definida a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetListAuxiliar(strTaula As String, strCampOrdre As String) As String
   Dim strResultat As String
   Dim objParametre As GIMEntitats.paramListTaulaAuxiliar 'Object 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMAuxiliar = objFuncionsComuns.CreaObjecteEntitat("MngTaulesAuxiliars", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es crea un objecte de classe de l'entitat paramListTaulaAuxiliar
   Set objParametre = objFuncionsComuns.CreaObjecteEntitat("paramListTaulaAuxiliar")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If

   objParametre.strNomTaula = strTaula
   objParametre.strNomCampOrdre = strCampOrdre
   
   'Es recuperen els registres mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMAuxiliar.GetIV
   strResultat = IVisorXMLActual.GetList(objParametre)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngTaulesAuxiliars
   Set objMAuxiliar = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetListAuxiliar = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetListAuxiliar"
   GetListAuxiliar = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- SaveTaulaAuxiliar()
'----------------------------------------------------------------------------------------------
' Grava els canvis dels registres d'una taula auxiliar definida a la Base de Dades
'----------------------------------------------------------------------------------------------
Public Function SaveTaulaAuxiliar(strXMLAuxiliar As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMAuxiliar = objFuncionsComuns.CreaObjecteEntitat("MngTaulesAuxiliars", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava la lluminria mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMAuxiliar.GetIM
   bolResultat = IMantXMLActual.Save(strXMLAuxiliar)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngLluminaries
   Set objMAuxiliar = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SaveTaulaAuxiliar = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SaveTaulaAuxiliar"
   SaveTaulaAuxiliar = False
   Exit Function
End Function


