VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SvrPatronsPuntsLlum"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

Private Const ctStrNomClasse = "SvrPatronsPuntsLlum" 'Nom de la classe
Private Const ctStrNomClasseEntitatPrincipal = "MngPatronsPuntLlum"
Private objFuncionsComuns As clsFuncionsSubCapaSuport

'Serveix per cridar a les propietats i mtodes de les classes
'MngPatronsPuntLlum, MngPatronsPLluminaria, IVisorXML i IMantXML respectivament
Private objMPatronsPuntLlum As Object
Private objMPatronsPLluminaria As Object
Private objMPatronsSuport As Object
Private objMPatronsTerra As Object
Private objMPatronsLluminaria As Object
Private objMPatronsCaixa As Object
Private IVisorXMLActual As Object
Private IMantXMLActual As Object
Private AuxIdTransaccio As ADODB.Connection 'S'utilitza per implementar la variable pblica d'identificador de sessi
'----------------------------------------------------------------------------------------------
'-- Property Let i Get IdTransaccio()
'----------------------------------------------------------------------------------------------
' Implementa la variable IdTransaccio que indica el identificador de la transacci
'----------------------------------------------------------------------------------------------
Public Property Get IdTransaccio() As ADODB.Connection
   Set IdTransaccio = AuxIdTransaccio
End Property

Public Property Set IdTransaccio(connValor As ADODB.Connection)
   Set AuxIdTransaccio = connValor
End Property

'----------------------------------------------------------------------------------------------
'-- Class_Initialize()
'----------------------------------------------------------------------------------------------
' Du a terme les accions d'inicialitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Initialize()
   Set objFuncionsComuns = New clsFuncionsSubCapaSuport
End Sub
'----------------------------------------------------------------------------------------------
'-- Class_Terminate()
'----------------------------------------------------------------------------------------------
' Du a terme les accions de finalitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Terminate()
   Set objFuncionsComuns = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- GetPatronsPuntsLlum()
'----------------------------------------------------------------------------------------------
' Consulta tots els patrons definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPatronsPuntLlum() As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsPuntLlum = objFuncionsComuns.CreaObjecteEntitat("MngPatronsPuntLlum", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsPuntLlum.GetIV
   strResultat = IVisorXMLActual.GetList(objParametre)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsPuntllum
   Set objMPatronsPuntLlum = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPatronsPuntLlum = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPatronsPuntLlum"
   GetPatronsPuntLlum = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- SavePatroPuntLlum()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SavePatroPuntLlum(strXMLPatroPuntLlum As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsPuntLlum = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava el patr mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPatronsPuntLlum.GetIM
   bolResultat = IMantXMLActual.Save(strXMLPatroPuntLlum)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatrons
   Set objMPatronsPuntLlum = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SavePatroPuntLlum = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SavePatroPuntLlum"
   SavePatroPuntLlum = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- DeletePatroPuntLlum()
'----------------------------------------------------------------------------------------------
' Esborra el patr de llum l'identificador del qual
'es passa com a parmetre
'----------------------------------------------------------------------------------------------
Public Function DeletePatroPuntLlum(lngPatroPuntLlum As Long) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsPuntLlum = objFuncionsComuns.CreaObjecteEntitat("MngPatronsPuntLlum", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'S'esborra el % mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPatronsPuntLlum.GetIM
   bolResultat = IMantXMLActual.Delete(lngPatroPuntLlum)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsPuntLlum
   Set objMPatronsPuntLlum = Nothing
    
   'Si no hi ha hagut errors, retorna True
   DeletePatroPuntLlum = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - DeletePatroPuntLlum"
   DeletePatroPuntLlum = False
   Exit Function

End Function

'----------------------------------------------------------------------------------------------
'-- GetTextIdioma()
'----------------------------------------------------------------------------------------------
' Recupera tots els textos d'un formulari en un idioma determinat.
' Els retorna en format XML
'----------------------------------------------------------------------------------------------
Public Function GetTextIdioma(lngIdioma As Long, strNomForm As String) As String
   Dim strResultat As String
     
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
        
   'Es crida a la funci de la classe clsFuncionsSubCapaSuport
   'per recuperar els textos de l'idioma
   strResultat = objFuncionsComuns.GetTextIdiomaForm(lngIdioma, strNomForm)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetTextIdioma = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetTextIdioma"
   GetTextIdioma = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetPatronsPLluminaria()
'----------------------------------------------------------------------------------------------
' Consulta tots els patrons de lluminria definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPatronsPLluminaria() As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsPLluminaria = objFuncionsComuns.CreaObjecteEntitat("MngPatronsPLluminaria", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsPLluminaria.GetIV
   strResultat = IVisorXMLActual.GetList(objParametre)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsPLluminaria
   Set objMPatronsPLluminaria = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPatronsPLluminaria = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPatronsPLluminaria"
   GetPatronsPLluminaria = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetPatronsSuport()
'----------------------------------------------------------------------------------------------
' Consulta tots els patrons de suport definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPatronsSuport() As String
   Dim strResultat As String
         
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsSuport = objFuncionsComuns.CreaObjecteEntitat("MngPatronsSuport", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsSuport.GetIV
   strResultat = IVisorXMLActual.GetList("")
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsSuport
   Set objMPatronsSuport = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPatronsSuport = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPatronsSuport"
   GetPatronsSuport = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetPatronsTerra()
'----------------------------------------------------------------------------------------------
' Consulta tots els patrons de terra definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPatronsTerra() As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsTerra = objFuncionsComuns.CreaObjecteEntitat("MngPatronsTerra", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsTerra.GetIV
   strResultat = IVisorXMLActual.GetList("True")
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsTerra
   Set objMPatronsTerra = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPatronsTerra = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPatronsTerra"
   GetPatronsTerra = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetPatronsLluminaria()
'----------------------------------------------------------------------------------------------
' Consulta tots els patrons de lluminria definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPatronsLluminaria() As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsLluminaria = objFuncionsComuns.CreaObjecteEntitat("MngPatronsLluminaria", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsLluminaria.GetIV
   strResultat = IVisorXMLActual.GetList("True")
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatrons
   Set objMPatronsLluminaria = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPatronsLluminaria = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPatronsLluminaria"
   GetPatronsLluminaria = ""
   Exit Function
End Function


'----------------------------------------------------------------------------------------------
'-- GetPatronsCaixa()
'----------------------------------------------------------------------------------------------
' Consulta tots els patrons de caixa definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPatronsCaixa() As String
   Dim strResultat As String
      
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsCaixa = objFuncionsComuns.CreaObjecteEntitat("MngPatronsCaixa", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els patrons mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsCaixa.GetIV
   strResultat = IVisorXMLActual.GetList("True")
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatrons
   Set objMPatronsCaixa = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPatronsCaixa = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPatronsCaixa"
   GetPatronsCaixa = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetEmptyRstPLluminaria()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent a un recordset buit de punts de lluminria
' per tal de poder inserir-hi un nou punt.
'----------------------------------------------------------------------------------------------
Public Function GetEmptyRstPLluminaria() As String
   
   Dim strResultat As String
   Dim objParametre As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsPLluminaria = objFuncionsComuns.CreaObjecteEntitat("MngPatronsPLluminaria", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els punts mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPatronsPLluminaria.GetIM
   strResultat = IMantXMLActual.GetEmpty(objParametre)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatronsPLluminaria
   Set objMPatronsPLluminaria = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEmptyRstPLluminaria = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEmptyRstPLluminaria"
   GetEmptyRstPLluminaria = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- SavePatroPLluminaria()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SavePatroPLluminaria(strXMLPatroPLluminaria As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsPLluminaria = objFuncionsComuns.CreaObjecteEntitat("MngPatronsPLluminaria", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava el patr mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPatronsPLluminaria.GetIM
   bolResultat = IMantXMLActual.Save(strXMLPatroPLluminaria)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatroPLluminaria
   Set objMPatronsPLluminaria = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SavePatroPLluminaria = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SavePatroPLluminaria"
   SavePatroPLluminaria = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- DeletePatroPLluminaria()
'----------------------------------------------------------------------------------------------
' Esborra un registre de la taula T_PatroPlluminaria l'identificador del qual
'es passa com a parmetre
'----------------------------------------------------------------------------------------------
Public Function DeletePatroPLluminaria(lngPatroPLluminaria As Long) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsPLluminaria = objFuncionsComuns.CreaObjecteEntitat("MngPatroPLluminaria", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'S'esborra el patr mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMPatronsPLluminaria.GetIM
   bolResultat = IMantXMLActual.Delete(lngPatroPLluminaria)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPatroPlluminaria
   Set objMPatronsPLluminaria = Nothing
    
   'Si no hi ha hagut errors, retorna True
   DeletePatroPLluminaria = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - DeletePatroPLluminaria"
   DeletePatroPLluminaria = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetPuntsLlum()
'----------------------------------------------------------------------------------------------
' Consulta tots els punts de llum definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetPuntsLlum(lngPatroPLL As Long) As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMPatronsPuntLlum = objFuncionsComuns.CreaObjecteEntitat("MngPuntsLlum", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els punts de llum mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMPatronsPuntLlum.GetIV
   strResultat = IVisorXMLActual.GetList("NumPatroPLL = " & lngPatroPLL)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngPuntsLlum
   Set objMPatronsPuntLlum = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPuntsLlum = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPuntsLlum"
   GetPuntsLlum = ""
   Exit Function
End Function




