VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SvrProjectes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

Private Const ctStrNomClasse = "SvrProjectes" 'Nom de la classe
Private Const ctStrNomClasseEntitatPrincipal = "MngProjectes"
Private objFuncionsComuns As clsFuncionsSubCapaSuport

'Serveix per cridar a les propietats i mtodes de les classes
'MngProjecte, MngManteniments IVisorXML i IMantXML respectivament
Private objMProjectes As Object
Private objMClients As Object
Private objMManteniments As Object
Private objMZones As Object
Private IVisorXMLActual As Object
Private IMantXMLActual As Object
Private AuxIdTransaccio As ADODB.Connection 'S'utilitza per implementar la variable pblica d'identificador de sessi
'----------------------------------------------------------------------------------------------
'-- Property Let i Get IdTransaccio()
'----------------------------------------------------------------------------------------------
' Implementa la variable IdTransaccio que indica el identificador de la transacci
'----------------------------------------------------------------------------------------------
Public Property Get IdTransaccio() As ADODB.Connection
   Set IdTransaccio = AuxIdTransaccio
End Property

Public Property Set IdTransaccio(connValor As ADODB.Connection)
   Set AuxIdTransaccio = connValor
End Property

'----------------------------------------------------------------------------------------------
'-- Class_Initialize()
'----------------------------------------------------------------------------------------------
' Du a terme les accions d'inicialitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Initialize()
   Set objFuncionsComuns = New clsFuncionsSubCapaSuport
End Sub
'----------------------------------------------------------------------------------------------
'-- Class_Terminate()
'----------------------------------------------------------------------------------------------
' Du a terme les accions de finalitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Terminate()
   Set objFuncionsComuns = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- GetProjectes()
'----------------------------------------------------------------------------------------------
' Consulta tots els projectes definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetProjectes() As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMProjectes = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
      
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els projectes mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMProjectes.GetIV
   Set IVisorXMLActual.IdTransaccio = Me.IdTransaccio
   
   strResultat = IVisorXMLActual.GetList(objParametre)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngProjectes
   Set objMProjectes = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetProjectes = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetProjectes"
   GetProjectes = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetProjecteById()
'----------------------------------------------------------------------------------------------
' Recupera com a XML la informaci sobre el projecte l'identificador del qual es passa
' com a parmetre a aquesta funci
'----------------------------------------------------------------------------------------------
Public Function GetProjecteById(lngProjecte As Long) As String
   Dim strResultat As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMProjectes = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
  
   
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els projectes mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMProjectes.GetIV
   Set IVisorXMLActual.IdTransaccio = Me.IdTransaccio
   
   strResultat = IVisorXMLActual.GetById(lngProjecte)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngProjectes
   Set objMProjectes = Nothing
           
   'Si no hi ha hagut errors, retorna el resultat de la funci ConsultaXML
   GetProjecteById = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetProjecteById"
   GetProjecteById = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- SaveProjecte()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Public Function SaveProjecte(strXMLProjecte As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMProjectes = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
      
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es grava el projecte mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMProjectes.GetIM
   Set IMantXMLActual.IdTransaccio = Me.IdTransaccio
   
   bolResultat = IMantXMLActual.Save(strXMLProjecte)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngProjectes
   Set objMProjectes = Nothing
           
   'Si no hi ha hagut errors, retorna True
   SaveProjecte = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SaveProjecte"
   SaveProjecte = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- DeleteProjecte()
'----------------------------------------------------------------------------------------------
' Esborra el projecte l'identificador del qual
'es passa com a parmetre
'----------------------------------------------------------------------------------------------
Public Function DeleteProjecte(lngProjecte As Long) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMProjectes = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
      
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'S'esborra el projecte mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMProjectes.GetIM
   Set IMantXMLActual.IdTransaccio = Me.IdTransaccio
   
   bolResultat = IMantXMLActual.Delete(lngProjecte)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngProjectes
   Set objMProjectes = Nothing
    
   'Si no hi ha hagut errors, retorna True
   DeleteProjecte = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - DeleteProjecte"
   DeleteProjecte = False
   Exit Function

End Function

'----------------------------------------------------------------------------------------------
'-- GetEmptyRecordset()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent a un recordset buit de projectes
' per tal de poder inserir-hi un nou projecte.
'----------------------------------------------------------------------------------------------
Public Function GetEmptyRecordset() As String
   
   Dim strResultat As String
   Dim objParametre As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMProjectes = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
      
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els projectes mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMProjectes.GetIM
   Set IMantXMLActual.IdTransaccio = Me.IdTransaccio
   
   strResultat = IMantXMLActual.GetEmpty(objParametre)
      
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngProjectes
   Set objMProjectes = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEmptyRecordset = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEmptyRecordset"
   GetEmptyRecordset = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetClients()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent als clients
' definits a la base de dades.
'----------------------------------------------------------------------------------------------

Public Function GetClients() As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMClients = objFuncionsComuns.CreaObjecteEntitat("MngClients", Me)
      
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els clients mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMClients.GetIV
   Set IVisorXMLActual.IdTransaccio = Me.IdTransaccio
   
   strResultat = IVisorXMLActual.GetList(objParametre)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngClients
   Set objMClients = Nothing
  
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetClients = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetClients"
   GetClients = ""
   Exit Function
  
End Function

'----------------------------------------------------------------------------------------------
'-- GetTipusManteniment()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent als tipus de manteniment
' definits a la base de dades.
'----------------------------------------------------------------------------------------------

Public Function GetTipusManteniment() As String
   Dim strResultat As String
   Dim objParametre As Variant 'Parmetre de GetList el valor del qual no ens interessa
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMManteniments = objFuncionsComuns.CreaObjecteEntitat("MngManteniments", Me)
      
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen els tipus de manteniments mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMManteniments.GetIV
   Set IVisorXMLActual.IdTransaccio = Me.IdTransaccio
   
   strResultat = IVisorXMLActual.GetList(objParametre)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngManteniments
   Set objMManteniments = Nothing
  
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetTipusManteniment = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetManteniment"
   GetTipusManteniment = ""
   Exit Function

End Function

'----------------------------------------------------------------------------------------------
'-- GetTextIdioma()
'----------------------------------------------------------------------------------------------
' Recupera tots els textos d'un formulari en un idioma determinat.
' Els retorna en format XML
'----------------------------------------------------------------------------------------------
Public Function GetTextIdioma(lngIdioma As Long, strNomForm As String) As String
   Dim strResultat As String
     
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
        
   'Es crida a la funci de la classe clsFuncionsSubCapaSuport
   'per recuperar els textos de l'idioma
   strResultat = objFuncionsComuns.GetTextIdiomaForm(lngIdioma, strNomForm)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetTextIdioma = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetTextIdioma"
   GetTextIdioma = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetZones()
'----------------------------------------------------------------------------------------------
' Consulta totes les zones definides a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Public Function GetZones(lngProjecte As Long) As String
   Dim strResultat As String
      
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMZones = objFuncionsComuns.CreaObjecteEntitat("MngZones", Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Es recuperen les zones mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMZones.GetIV
   strResultat = IVisorXMLActual.GetList(lngProjecte)
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe MngZones
   Set objMZones = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetZones = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetZones"
   GetZones = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- BeginTransaction()
'----------------------------------------------------------------------------------------------
' Augmenta un nivell de transacci
'----------------------------------------------------------------------------------------------
Private Function BeginTransaction() As ADODB.Connection
   Dim cntSeccio As ADODB.Connection
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMProjectes = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If

    
   'Es fa l'operaci mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMProjectes.GetIM
   Set IMantXMLActual.IdTransaccio = Me.IdTransaccio
   
   Set cntSeccio = IMantXMLActual.BeginTransaction
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   Set BeginTransaction = cntSeccio
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - BeginTransaction"
   Set BeginTransaction = Nothing
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- CommitTransaction()
'----------------------------------------------------------------------------------------------
' Acaba un nivell de transacci guardant els canvis
'----------------------------------------------------------------------------------------------
Private Function CommitTransaction() As ADODB.Connection
   Dim cntSeccio As ADODB.Connection
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMProjectes = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
       
   'Es fa l'operaci mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMProjectes.GetIM
   Set IMantXMLActual.IdTransaccio = Me.IdTransaccio
   
   Set cntSeccio = IMantXMLActual.BeginTransaction
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   Set CommitTransaction = cntSeccio
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - CommitTransaction"
   Set CommitTransaction = Nothing
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- RollbackTransaction()
'----------------------------------------------------------------------------------------------
' Acaba un nivell de transacci sense guardar els canvis
'----------------------------------------------------------------------------------------------
Private Function RollBackTransaction() As ADODB.Connection
   Dim cntSeccio As ADODB.Connection
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMProjectes = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   Set objMProjectes.IdTransaccio = Me.IdTransaccio
    
   'Es fa l'operaci mitjanant la interfcie IMantXML
   Set IMantXMLActual = objMProjectes.GetIM
   Set IMantXMLActual.IdTransaccio = Me.IdTransaccio
   
   Set cntSeccio = IMantXMLActual.BeginTransaction
   
   'Si aquesta darrera funci ha donat error, genera un error
   If IMantXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IMantXMLActual.UbicacioError
      Err.Raise IMantXMLActual.NumError
   End If
    
   Set RollBackTransaction = cntSeccio
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - RollBackTransaction"
   Set RollBackTransaction = Nothing
   Exit Function
End Function




