VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SVrTransaccions"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

Private Const ctStrNomClasse = "SvrTransaccions" 'Nom de la classe
Private Const ctStrNomClasseEntitatPrincipal = "MngTransaccions"
Private objFuncionsComuns As clsFuncionsSubCapaSuport

'Serveix per cridar a les propietats i mtodes de les classes
'MngProjecte, MngManteniments IVisorXML i IMantXML respectivament
Private objMTransaccions As Object
Private ITransaccionsActual As Object
Private AuxIdTransaccio As ADODB.Connection 'S'utilitza per implementar la variable pblica d'identificador de sessi

'----------------------------------------------------------------------------------------------
'-- Property Let i Get IdTransaccio()
'----------------------------------------------------------------------------------------------
' Implementa la variable IdTransaccio que indica el identificador de la transacci
'----------------------------------------------------------------------------------------------
Public Property Get IdTransaccio() As ADODB.Connection
   Set IdTransaccio = AuxIdTransaccio
End Property

Public Property Set IdTransaccio(connValor As ADODB.Connection)
   Set AuxIdTransaccio = connValor
End Property

'----------------------------------------------------------------------------------------------
'-- Class_Initialize()
'----------------------------------------------------------------------------------------------
' Du a terme les accions d'inicialitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Initialize()
   Set objFuncionsComuns = New clsFuncionsSubCapaSuport
   Set Me.IdTransaccio = Nothing
End Sub
'----------------------------------------------------------------------------------------------
'-- Class_Terminate()
'----------------------------------------------------------------------------------------------
' Du a terme les accions de finalitzaci de la classe
'----------------------------------------------------------------------------------------------
Private Sub Class_Terminate()
   Set objFuncionsComuns = Nothing
   Set Me.IdTransaccio = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- BeginTransaction()
'----------------------------------------------------------------------------------------------
' Augmenta un nivell de transacci
'----------------------------------------------------------------------------------------------
Public Sub BeginTransaction()
   Dim cntSeccio As ADODB.Connection
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe MngTransaccions
   Set objMTransaccions = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es recupera la interfcie ITransaccions i se li passa l'identificador de sessio
   Set ITransaccionsActual = objMTransaccions.GetIT
   Set ITransaccionsActual.IdTransaccio = Me.IdTransaccio
   
   'Es crida a la funci BeginTransaccions de la interfcie
   Set Me.IdTransaccio = ITransaccionsActual.BeginTransaction
   
   'Si aquesta darrera funci ha donat error, genera un error
   If ITransaccionsActual.NumError <> ctintErrorOK Then
      UbicacioError = ITransaccionsActual.UbicacioError
      Err.Raise ITransaccionsActual.NumError
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - BeginTransaction"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- CommitTransaction()
'----------------------------------------------------------------------------------------------
' Acaba un nivell de transacci guardant els canvis
'----------------------------------------------------------------------------------------------
Public Sub CommitTransaction()
   Dim cntSeccio As ADODB.Connection
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
  'Es crea un objecte de classe MngTransaccions
   Set objMTransaccions = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es recupera la interfcie ITransaccions i se li passa l'identificador de sessio
   Set ITransaccionsActual = objMTransaccions.GetIT
   Set ITransaccionsActual.IdTransaccio = Me.IdTransaccio
   
   Set Me.IdTransaccio = ITransaccionsActual.CommitTransaction
   
   'Es crida a la funci CommitTransaccions de la interfcie
   If ITransaccionsActual.NumError <> ctintErrorOK Then
      UbicacioError = ITransaccionsActual.UbicacioError
      Err.Raise ITransaccionsActual.NumError
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - CommitTransaction"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- RollBackTransaction()
'----------------------------------------------------------------------------------------------
' Acaba un nivell de transacci sense guardar els canvis
'----------------------------------------------------------------------------------------------
Public Sub RollBackTransaction()
   Dim cntSeccio As ADODB.Connection
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crea un objecte de classe MngTransaccions
   Set objMTransaccions = objFuncionsComuns.CreaObjecteEntitat(ctStrNomClasseEntitatPrincipal, Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If

    
   'Es recupera la interfcie ITransaccions i se li passa l'identificador de sessio
   Set ITransaccionsActual = objMTransaccions.GetIT
   Set ITransaccionsActual.IdTransaccio = Me.IdTransaccio
   
   Set Me.IdTransaccio = ITransaccionsActual.RollBackTransaction
   
   'Es crida a la funci RollBackTransaccions de la interfcie
   If ITransaccionsActual.NumError <> ctintErrorOK Then
      UbicacioError = ITransaccionsActual.UbicacioError
      Err.Raise ITransaccionsActual.NumError
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - RollBackTransaction"
   Exit Sub
End Sub

