VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsFuncionsSubCapaSuport"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font
Private Const ctStrNomClasse = "clsFuncionsSubCapaSuport"

'----------------------------------------------------------------------------------------------
'-- Property Get RutaArxiuIni
'----------------------------------------------------------------------------------------------
' Propietat que retorna la ruta completa de l'arxiu Ini de l'aplicaci
' Aquest arxiu es troba a la mateixa carpeta que la de l'arxiu GIMSuport.DLL
'----------------------------------------------------------------------------------------------
Public Property Get RutaArxiuIni() As String
   RutaArxiuIni = App.Path & "\" & ctStrNomArxiuIni
End Property

'**********************************************************************************************
'-- Funcions per crear objectes entitat a mquines locals i remotes
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- CreaObjecteEntitat()
'----------------------------------------------------------------------------------------------
' Crea un objecte d'una classe continguda a GIMEntitats.dll
' Aquesta DLL pot estar a la mquina local o a una mquina remota
'----------------------------------------------------------------------------------------------
 
Public Function CreaObjecteEntitat(strNomClasse As String, Optional objObjecteQueCrida As Variant) As Object
   Dim strRutaDLLEntitats As String
   Dim strNomPCEntitats As String
   Dim objResultat As Object
   Dim IVisorActual As Object
  
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   strRutaDLLEntitats = GIMEntitats_DLL
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   strNomPCEntitats = GIMEntitats_PC
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
  
   Set objResultat = CreateObject(strRutaDLLEntitats & strNomClasse, strNomPCEntitats)
         
   If Not IsMissing(objObjecteQueCrida) Then
      If TypeName(objResultat) = "MngTransaccions" Then
         Set IVisorActual = objResultat.GetIT
      Else
         Set IVisorActual = objResultat.GetIV
      End If
      Set IVisorActual.IdTransaccio = objObjecteQueCrida.IdTransaccio
   End If
   Set CreaObjecteEntitat = objResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - CreaObjecteEntitat"
   Set CreaObjecteEntitat = Nothing
   Exit Function
End Function
   
'------------------------------------------------
'-- GIMEntitats_DLL()
'------------------------------------------------
' Consulta el nom de la DLL amb les Entitats
'------------------------------------------------
Private Property Get GIMEntitats_DLL() As String
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   '-- Consulta el nom de la DLL amb les Entitats a l'arxiu de configuracio
   GIMEntitats_DLL = ConsultaArxiuIniSuport("General", "DLL_GIMEntitats")
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   Exit Property
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - GIMEntitats_DLL"
   GIMEntitats_DLL = ""
   Exit Property
End Property
'------------------------------------------------
'-- GIMEntitats_PC()
'------------------------------------------------
' Consulta el nom del PC on es troba la DLL
' amb les Entitats
'------------------------------------------------
Private Property Get GIMEntitats_PC() As String
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   '-- Consulta el nom del PC a l'arxiu de configuracio
   GIMEntitats_PC = ConsultaArxiuIniSuport("General", "PC_GIMEntitats")
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   Exit Property
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - GIMEntitats_PC"
   GIMEntitats_PC = ""
   Exit Property
End Property

'**********************************************************************************************
'-- Funcions per consulta d'arxius ini
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- ConsultaArxiuIniSuport()
'----------------------------------------------------------------------------------------------
' Consulta el valor d'una clau de l'arxiu INI del mdul de suport
' Retorna la cadena buida si s'ha produt algun error i el valor altrament
'----------------------------------------------------------------------------------------------

Public Function ConsultaArxiuIniSuport(strSeccio As String, strClau As String) As String

   Dim strText As String
   
    'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Consulta l'arxiu INI amb la funci auxiliar ConsultaArxiuIni
   strText = ConsultaArxiuIni(RutaArxiuIni, strSeccio, strClau)
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   ConsultaArxiuIniSuport = StrTran(strText, "{mod}", App.Path)
   Exit Function
   
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - ConsultaArxiuIniSuport"
   ConsultaArxiuIniSuport = ""
   Exit Function
   
End Function
'----------------------------------------------------------------------------------------------
'-- ConsultaArxiuIni()
'----------------------------------------------------------------------------------------------
' Consulta el valor d'una clau de l'arxiu INI.
' Retorna la cadena buida si s'ha produt algun error i el valor altrament
'----------------------------------------------------------------------------------------------
Private Function ConsultaArxiuIni(strRutaArxiuIni As String, strSeccio As String, _
   strClau As String) As String
   Dim strBufferCaracters As String * 256
   Dim intLlargada As Integer
   Dim strResultat As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Comprova que cap parmetre no sigui buit i que l'arxiu Ini existeixi
   If strRutaArxiuIni = "" Or strSeccio = "" Or strClau = "" Then
      Err.Raise ctintErrorParametresBuits
   End If
    
   If Dir(strRutaArxiuIni) = "" Then
      Err.Raise ctIntErrorUbicacioIni
   End If
    
   'Crida a la funci API que serveix per consultar els arxius INI
   strBufferCaracters = Space$(256)
   intLlargada = GetPrivateProfileString(strSeccio, strClau, "@#&", strBufferCaracters, _
    255, strRutaArxiuIni)
   strResultat = Left$(strBufferCaracters, intLlargada)
    
   'Si no es troba la clau, es genera un error
   If strResultat = "@#&" Then
      Err.Raise ctintErrorConsultaIni
   End If
    
   'Si no s'ha produt l'error es retorna el valor recuperat de la clau
   ConsultaArxiuIni = strResultat
   Exit Function
    
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - ConsultaArxiuIni"
   ConsultaArxiuIni = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- StrTran()
'----------------------------------------------------------------------------------------------
'Busca en una cadena de carcters les aparicions d'una segona cadena i, desprs, remplaa cada
'aparici amb una tercera cadena
'----------------------------------------------------------------------------------------------
Public Function StrTran(strStringbase As String, strStringARemplacar As String, strStringRemplacable As String) As String
   Dim strTemp As String
   Dim lngPosicioString As Long
   Dim lngLlargadaStringARemplacar As Long
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   lngLlargadaStringARemplacar = Len(strStringARemplacar)
   strTemp = strStringbase
   lngPosicioString = InStr(strTemp, strStringARemplacar)
   Do While lngPosicioString <> 0
      strTemp = Mid$(strTemp, 1, lngPosicioString - 1) + _
       strStringRemplacable + _
       Mid$(strTemp, lngPosicioString + lngLlargadaStringARemplacar)
      lngPosicioString = InStr(strTemp, strStringARemplacar)
   Loop
   StrTran = strTemp
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - StrTran"
   StrTran = ""
   Exit Function
End Function


'**********************************************************************************************
'-- Funcions per retornar els textos d'un formulari en un idioma
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- GetTextIdiomaForm()
'----------------------------------------------------------------------------------------------
' Recupera tots els textos d'un formulari en un idioma determinat.
' Els retorna en format XML
'----------------------------------------------------------------------------------------------
Public Function GetTextIdiomaForm(lngIdioma As Long, Optional strNomForm As String) As String
   Dim strResultat As String
   Dim objparamIdioma As Object 'Parmetre de GetList
   Dim IVisorXMLActual As GIMEntitats.IVisorXML
   Dim objMIdioma As Object
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es crea un objecte de classe de l'entitat corresponent a aquesta classe
   Set objMIdioma = CreaObjecteEntitat("MngIdioma")
   
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
  
   'Es recuperen els idiomes mitjanant la interfcie IVisorXML
   Set IVisorXMLActual = objMIdioma.GetIV
   Set IVisorXMLActual.IdTransaccio = Nothing
   
   'Es crea un objecte per passar les dades al mtode GetList
   Set objparamIdioma = CreaObjecteEntitat("paramIdioma")
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   'Es crida al mtode GetList
   objparamIdioma.lngNumIdioma = lngIdioma
   objparamIdioma.strNomFormulari = strNomForm
   strResultat = IVisorXMLActual.GetList(objparamIdioma)
  
   'Si aquesta darrera funci ha donat error, genera un error
   If IVisorXMLActual.NumError <> ctintErrorOK Then
      UbicacioError = IVisorXMLActual.UbicacioError
      Err.Raise IVisorXMLActual.NumError
   End If
    
   'Allibera la instncia de la classe Mng%%%
   Set objMIdioma = Nothing
   
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetTextIdiomaForm = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetTextIdiomaForm"
   GetTextIdiomaForm = ""
   Exit Function
End Function


