VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "MngPLlumPunts"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Implements IVisorXML
Implements IMantXML

Private Const ctStrNomClasse = "MngPLlumPunts" 'Nom de la classe
Private Const ctStrTaula = "CapaPuntLlum" ' Taula de la BD a la qual fa referncia la classe
Private Const ctStrCampIdentificador = "NumPunt" 'Camp identificador d'aquesta taula
Private Const ctStrCampOrdre = "CoordenadaX" 'Camp pel qual s'ordena el recordset

Private AuxNumError As Long 'Variable privada que cont el nmero d'error
Private AuxUbicacioError As String 'Variable privada que cont la ubicaci de l'error
Private AuxIdTransaccio As ADODB.Connection 'Variable privada amb identificador de transacci

Private objFuncionsComuns As New GIMEntitats.clsFuncionsSubCapaEntitats

Private objDB As GIMBD.clsBD 'Serveix per cridar a les propietats i mtodes de la classe clsBD

'----------------------------------------------------------------------------------------------
'-- GetPllumPunts()
'----------------------------------------------------------------------------------------------
' Consulta tots els punts definits a la Base de Dades
' Retorna una cadena XML amb aquesta informaci
'----------------------------------------------------------------------------------------------
Private Function GetPllumPunts(lngPuntLlum As Long) As String
   Dim strResultat As String
  
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   AuxNumError = ctintErrorOK
   AuxUbicacioError = ""
    
   'Es recuperen els punts mitjanant la funci ConsultaXML de la classe clsBD
   Set objDB = objFuncionsComuns.CreaObjecteDades(Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      AuxUbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   strResultat = objDB.ConsultaXML("Select * From " & ctStrTaula & _
   " Where NumPuntLlum = " & Str(lngPuntLlum) & " Order By " & _
    ctStrTaula & "." & ctStrCampOrdre)
   
   'Si aquesta funci ha donat error, genera un error
   If objDB.NumError <> ctintErrorOK Then
      AuxUbicacioError = objDB.UbicacioError
      Err.Raise objDB.NumError
   End If
    
   'Allibera la instncia de la classe clsBD
   Set objDB = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetPllumPunts = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   AuxNumError = Err.Number
   AuxUbicacioError = AuxUbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPllumPunts"
   GetPllumPunts = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- GetPllumPuntById()
'----------------------------------------------------------------------------------------------
' Recupera com a XML la informaci sobre el punt l'identificador del qual es passa
' com a parmetre a aquesta funci
'----------------------------------------------------------------------------------------------
Private Function GetPllumPuntById(lngPllumPunt As Long) As String
   Dim strResultat As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   AuxNumError = ctintErrorOK
   AuxUbicacioError = ""
    
   'Es recupera el punt determinat mitjanant la funci ConsultaXML de la classe clsBD
   Set objDB = objFuncionsComuns.CreaObjecteDades(Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      AuxUbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   strResultat = objDB.ConsultaXML("Select * From " & ctStrTaula & " Where " _
    & ctStrCampIdentificador & " = " & Str(lngPllumPunt))
    
   'Si aquesta funci ha donat error, genera un error
   If objDB.NumError <> ctintErrorOK Then
      AuxUbicacioError = objDB.UbicacioError
      Err.Raise objDB.NumError
   End If
    
   'Allibera la instncia de la classe clsBD
   Set objDB = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci ConsultaXML
   GetPllumPuntById = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   AuxNumError = Err.Number
   AuxUbicacioError = AuxUbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetPllumPuntById"
   GetPllumPuntById = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- SavePllumPunt()
'----------------------------------------------------------------------------------------------
' Se li passa una cadena XML amb els canvis efectuats en el recordset
' i actualitza la taula de la base de dades amb aquests canvis
'----------------------------------------------------------------------------------------------
Private Function SavePllumPunt(strXMLPllumPunts As String) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   AuxNumError = ctintErrorOK
   AuxUbicacioError = ""
    
   'Es graven els canvis mitjanant la funci UpdateXML de la classe clsBD
   Set objDB = objFuncionsComuns.CreaObjecteDades(Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      AuxUbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   bolResultat = objDB.UpdateXML(strXMLPllumPunts)
    
   'Si aquesta funci ha donat error, genera un error
   If objDB.NumError <> ctintErrorOK Then
      AuxUbicacioError = objDB.UbicacioError
      Err.Raise objDB.NumError
   End If
    
   'Allibera la instncia de la classe clsBD
   Set objDB = Nothing
    
   'Si no hi ha hagut errors, retorna True
   SavePllumPunt = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   AuxNumError = Err.Number
   AuxUbicacioError = AuxUbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - SavePllumPunt"
   SavePllumPunt = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- DeletePllumPunt()
'----------------------------------------------------------------------------------------------
' Esborra el punt l'identificador del qual
'es passa com a parmetre
'----------------------------------------------------------------------------------------------
Private Function DeletePllumPunt(lngPllumPunt As Long) As Boolean
   Dim bolResultat As Boolean
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   AuxNumError = ctintErrorOK
   AuxUbicacioError = ""
    
   'S'esborra el punt mitjanant la funci ExecutaSQL de la classe clsBD
   Set objDB = objFuncionsComuns.CreaObjecteDades(Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      AuxUbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   bolResultat = objDB.ExecutaSQL("Delete * From " & ctStrTaula & " Where " & _
    ctStrCampIdentificador & " = " & lngPllumPunt)
    
   'Si aquesta funci ha donat error, genera un error
   If objDB.NumError <> ctintErrorOK Then
      AuxUbicacioError = objDB.UbicacioError
      Err.Raise objDB.NumError
   End If
    
   'Allibera la instncia de la classe clsBD
   Set objDB = Nothing
    
   'Si no hi ha hagut errors, retorna True
   DeletePllumPunt = True
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   AuxNumError = Err.Number
   AuxUbicacioError = AuxUbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - DeletePllumPunt"
   DeletePllumPunt = False
   Exit Function

End Function

'----------------------------------------------------------------------------------------------
'-- GetEmptyRecordset()
'----------------------------------------------------------------------------------------------
' Retorna una cadena XML corresponent a un recordset buit de punts
' per tal de poder inserir-hi un nou punt.
'----------------------------------------------------------------------------------------------
Private Function GetEmptyRecordset() As String
   
   Dim strResultat As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   AuxNumError = ctintErrorOK
   AuxUbicacioError = ""
    
   'Es recupera un recordset buit de punts en format XML
   'mitjanant la funci ConsultaXML de la classe clsBD
   Set objDB = objFuncionsComuns.CreaObjecteDades(Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      AuxUbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   strResultat = objDB.ConsultaXML("Select * From " & ctStrTaula & " Where False")
    
   'Si aquesta funci ha donat error, genera un error
   If objDB.NumError <> ctintErrorOK Then
      AuxUbicacioError = objDB.UbicacioError
      Err.Raise objDB.NumError
   End If
    
   'Allibera la instncia de la classe clsBD
   Set objDB = Nothing
    
   'Si no hi ha hagut errors, retorna el resultat de la funci Consulta XML
   GetEmptyRecordset = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   AuxNumError = Err.Number
   AuxUbicacioError = AuxUbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - GetEmptyRecordset"
   GetEmptyRecordset = ""
   Exit Function
End Function


'----------------------------------------------------------------------------------------------
'-- Property Let i Property Get IVisorXML_NumError
'----------------------------------------------------------------------------------------------
' Funcions que implementen la propietat NumError de la interfcie IVisorXML
' a partir de la variable privada AuxNumError
'----------------------------------------------------------------------------------------------
Private Property Let IVisorXML_NumError(RHS As Variant)
   AuxNumError = RHS
End Property

Private Property Get IVisorXML_NumError() As Variant
   IVisorXML_NumError = AuxNumError
End Property

Private Property Set IVisorXML_NumError(RHS As Variant)
   'No s'usa. La variable sempre s'assigna amb Get
End Property

'----------------------------------------------------------------------------------------------
'-- Property Let i Property Get IVisorXML_UbicacioError
'----------------------------------------------------------------------------------------------
' Funcions que implementen la propietat UbicacioError de la interfcie IVisorXML
' a partir de la variable privada AuxUbicacioError
'----------------------------------------------------------------------------------------------
Private Property Let IVisorXML_UbicacioError(RHS As Variant)
   AuxUbicacioError = RHS
End Property
Private Property Get IVisorXML_UbicacioError() As Variant
   IVisorXML_UbicacioError = AuxUbicacioError
End Property
Private Property Set IVisorXML_UbicacioError(RHS As Variant)
   'No s'usa. La variable sempre s'assigna amb Get
End Property

'----------------------------------------------------------------------------------------------
'-- Property Let i Property Set IVisorXML_IdTransaccio
'----------------------------------------------------------------------------------------------
' Funcions que implementen la propietat IdTransaccio de la interfcie IMantXML
' a partir de la variable privada IdTransaccio
'---------------------------------------------------------------------------------------------
Private Property Set IVisorXML_IdTransaccio(ByVal RHS As ADODB.Connection)
   Set AuxIdTransaccio = RHS
End Property

Private Property Get IVisorXML_IdTransaccio() As ADODB.Connection
   Set IVisorXML_IdTransaccio = AuxIdTransaccio
End Property

'----------------------------------------------------------------------------------------------
'-- IVisorXML_GetbyId()
'----------------------------------------------------------------------------------------------
' Implementa el mtode GetbyId de la interfcie IVisorXML
' cridant a la funci GetPllumPuntById
'----------------------------------------------------------------------------------------------
Private Function IVisorXML_GetByID(objID As Variant) As String
   IVisorXML_GetByID = GetPllumPuntById((objID))
End Function

'----------------------------------------------------------------------------------------------
'-- IVisorXML_GetList()
'----------------------------------------------------------------------------------------------
' Implementa el mtode GetList de la interfcie IVisorXML
' cridant a la funci GetPllumPunts
'----------------------------------------------------------------------------------------------
Private Function IVisorXML_GetList(objCondicions As Variant) As String
   'Es rebutja el parmetre que passem perqu, en aquest cas, no cal
   IVisorXML_GetList = GetPllumPunts((objCondicions))
End Function

'----------------------------------------------------------------------------------------------
'-- Property Let i Property Get IMantXML_NumError
'----------------------------------------------------------------------------------------------
' Funcions que implementen la propietat NumError de la interfcie IMantXML
' a partir de la variable privada AuxNumError
'----------------------------------------------------------------------------------------------
Private Property Let IMantXML_NumError(RHS As Variant)
   AuxNumError = RHS
End Property

Private Property Get IMantXML_NumError() As Variant
   IMantXML_NumError = AuxNumError
End Property
Private Property Set IMantXML_NumError(RHS As Variant)
   'No s'usa. La variable sempre s'assigna amb Get
End Property

'----------------------------------------------------------------------------------------------
'-- Property Let i Property Get IMantXML_UbicacioError
'----------------------------------------------------------------------------------------------
' Funcions que implementen la propietat UbicacioError de la interfcie IMantXML
' a partir de la variable privada AuxUbicacioError
'----------------------------------------------------------------------------------------------
Private Property Let IMantXML_UbicacioError(RHS As Variant)
   AuxUbicacioError = RHS
End Property
Private Property Get IMantXML_UbicacioError() As Variant
   IMantXML_UbicacioError = AuxUbicacioError
End Property
Private Property Set IMantXML_UbicacioError(RHS As Variant)
   'No s'usa. La variable sempre s'assigna amb Get
End Property

'----------------------------------------------------------------------------------------------
'-- Property Let i Property Set IMantXML_IdTransaccio
'----------------------------------------------------------------------------------------------
' Funcions que implementen la propietat IdTransaccio de la interfcie IMantXML
' a partir de la variable privada IdTransaccio
'---------------------------------------------------------------------------------------------
Private Property Set IMantXML_IdTransaccio(ByVal RHS As ADODB.Connection)
   Set AuxIdTransaccio = RHS
End Property

Private Property Get IMantXML_IdTransaccio() As ADODB.Connection
   Set IMantXML_IdTransaccio = AuxIdTransaccio
End Property

'----------------------------------------------------------------------------------------------
'-- IMantXML_GetbyId()
'----------------------------------------------------------------------------------------------
' Implementa el mtode GetbyId de la interfcie IMantXML
' cridant a la funci GetPllumPuntById
'----------------------------------------------------------------------------------------------
Private Function IMantXML_GetByID(objID As Variant) As String
   IMantXML_GetByID = GetPllumPuntById((objID))
End Function

'----------------------------------------------------------------------------------------------
'-- IMantXML_GetEmpty()
'----------------------------------------------------------------------------------------------
' Implementa el mtode GetEmpty de la interfcie IMantXML
' cridant a la funci GetEmptyRecordset
'----------------------------------------------------------------------------------------------
Private Function IMantXML_GetEmpty(objCondicions As Variant) As String
   IMantXML_GetEmpty = GetEmptyRecordset()
End Function

'----------------------------------------------------------------------------------------------
'-- IMantXML_Save()
'----------------------------------------------------------------------------------------------
' Implementa el mtode Save de la interfcie IMantXML
' cridant a la funci SavePllumPunt
'----------------------------------------------------------------------------------------------
Private Function IMantXML_Save(strXML As String) As Boolean
   IMantXML_Save = SavePllumPunt(strXML)
End Function

'----------------------------------------------------------------------------------------------
'-- IMantXML_Delete()
'----------------------------------------------------------------------------------------------
' Implementa el mtode Delete de la interfcie IMantXML
' cridant a la funci DeletePllumPunt
'----------------------------------------------------------------------------------------------
Private Function IMantXML_Delete(objID As Variant) As Boolean
   IMantXML_Delete = DeletePllumPunt((objID))
End Function

'----------------------------------------------------------------------------------------------
'-- GetIV()
'----------------------------------------------------------------------------------------------
' Per tal de poder tenir clients d'aquesta classe que no es trobin a la mateixa maquina,
' o clients tipus script, aquesta funcio em permet retornar l'interfcie de Visor
'----------------------------------------------------------------------------------------------
Public Function GetIV() As IVisorXML
   'Retorno aquest objecte amb l'interficie IVisorXML
   Set GetIV = Me
End Function

'----------------------------------------------------------------------------------------------
'-- GetIM()
'----------------------------------------------------------------------------------------------
' Per tal de poder tenir clients d'aquesta classe que no es trobin a la mateixa maquina,
' o clients tipus script, aquesta funcio em permet retornar l'interfcie de Manteniment
'----------------------------------------------------------------------------------------------
Public Function GetIM() As IMantXML
   'Retorno aquest objecte amb l'interficie IMantXML
   Set GetIM = Me
End Function

