VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "MngTransaccions"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Implements ITransaccions

Private Const ctStrNomClasse = "MngTransaccions" 'Nom de la classe

Private AuxNumError As Long 'Variable privada que cont el nmero d'error
Private AuxUbicacioError As String 'Variable privada que cont la ubicaci de l'error
Private AuxIdTransaccio As ADODB.Connection 'Variable privada amb identificador de transacci

Private objFuncionsComuns As New GIMEntitats.clsFuncionsSubCapaEntitats

Private objDB As GIMBD.clsBD 'Serveix per cridar a les propietats i mtodes de la classe clsBD

'----------------------------------------------------------------------------------------------
'-- AuxBeginTransaction()
'----------------------------------------------------------------------------------------------
' Augmenta un nivell de transacci
'----------------------------------------------------------------------------------------------
Private Function AuxBeginTransaction() As ADODB.Connection
   Dim cntSeccio As ADODB.Connection
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   AuxNumError = ctintErrorOK
   AuxUbicacioError = ""
    
   'Es crea un objecte de la classe clsBD i se li passa l'identificador de sessi
   Set objDB = objFuncionsComuns.CreaObjecteDades(Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      AuxUbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   Set objDB.IdTransaccio = AuxIdTransaccio
   
   'Es crida al mtode BeginTransaction de la base de dades
   Set AuxIdTransaccio = objDB.BeginTransaction
       
   'Si aquesta funci ha donat error, genera un error
   If objDB.NumError <> ctintErrorOK Then
      AuxUbicacioError = objDB.UbicacioError
      Err.Raise objDB.NumError
   End If
    
   'Allibera la instncia de la classe clsBD
   Set objDB = Nothing
   
   'Retorna el resultat de BeginTransaction
   Set AuxBeginTransaction = AuxIdTransaccio
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   AuxNumError = Err.Number
   AuxUbicacioError = AuxUbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - AuxBeginTransaction"
   Set AuxBeginTransaction = Nothing
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- AuxCommitTransaction()
'----------------------------------------------------------------------------------------------
' Acaba un nivell de transacci guardant els canvis
'----------------------------------------------------------------------------------------------
Private Function AuxCommitTransaction() As ADODB.Connection
   Dim cntSeccio As ADODB.Connection
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   AuxNumError = ctintErrorOK
   AuxUbicacioError = ""
    
   'Es crea un objecte de la classe clsBD i se li passa l'identificador de sessi
   Set objDB = objFuncionsComuns.CreaObjecteDades(Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      AuxUbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   Set objDB.IdTransaccio = AuxIdTransaccio
   
   'Es crida al mtode CommitTransaction de la base de dades
   Set AuxIdTransaccio = objDB.CommitTransaction
       
   'Si aquesta funci ha donat error, genera un error
   If objDB.NumError <> ctintErrorOK Then
      AuxUbicacioError = objDB.UbicacioError
      Err.Raise objDB.NumError
   End If
    
   'Allibera la instncia de la classe clsBD
   Set objDB = Nothing
    
   'Retorna el resultat de CommitTransaction
   Set AuxCommitTransaction = AuxIdTransaccio
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   AuxNumError = Err.Number
   AuxUbicacioError = AuxUbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - AuxCommitTransaction"
   Set AuxCommitTransaction = Nothing
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- AuxRollBackTransaction()
'----------------------------------------------------------------------------------------------
' Acaba un nivell de transacci sense guardar els canvis
'----------------------------------------------------------------------------------------------
Private Function AuxRollBackTransaction() As ADODB.Connection
   Dim cntSeccio As ADODB.Connection
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   AuxNumError = ctintErrorOK
   AuxUbicacioError = ""
    
   'S'esborra el projecte mitjanant la funci ExecutaSQL de la classe clsBD
   Set objDB = objFuncionsComuns.CreaObjecteDades(Me)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      AuxUbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   Set objDB.IdTransaccio = AuxIdTransaccio
   
   'Es crida al mtode RollBackTransaction de la base de dades
   Set AuxIdTransaccio = objDB.RollBackTransaction
       
   'Si aquesta funci ha donat error, genera un error
   If objDB.NumError <> ctintErrorOK Then
      AuxUbicacioError = objDB.UbicacioError
      Err.Raise objDB.NumError
   End If
    
   'Allibera la instncia de la classe clsBD
   Set objDB = Nothing
    
   'Retorna el resultat de RollBackTransaction
   Set AuxRollBackTransaction = AuxIdTransaccio
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False
   AuxNumError = Err.Number
   AuxUbicacioError = AuxUbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - AuxRollBackTransaction"
   Set AuxRollBackTransaction = Nothing
   Exit Function
End Function


'----------------------------------------------------------------------------------------------
'-- Property Let i Property Get ITransaccions_NumError
'----------------------------------------------------------------------------------------------
' Funcions que implementen la propietat NumError de la interfcie ITransaccions
' a partir de la variable privada AuxNumError
'----------------------------------------------------------------------------------------------
Private Property Let ITransaccions_NumError(RHS As Variant)
   AuxNumError = RHS
End Property

Private Property Get ITransaccions_NumError() As Variant
   ITransaccions_NumError = AuxNumError
End Property
Private Property Set ITransaccions_NumError(RHS As Variant)
   'No s'usa. La variable sempre s'assigna amb Get
End Property

'----------------------------------------------------------------------------------------------
'-- Property Let i Property Get ITransaccions_UbicacioError
'----------------------------------------------------------------------------------------------
' Funcions que implementen la propietat UbicacioError de la interfcie ITransaccions
' a partir de la variable privada AuxUbicacioError
'----------------------------------------------------------------------------------------------
Private Property Let ITransaccions_UbicacioError(RHS As Variant)
   AuxUbicacioError = RHS
End Property
Private Property Get ITransaccions_UbicacioError() As Variant
   ITransaccions_UbicacioError = AuxUbicacioError
End Property
Private Property Set ITransaccions_UbicacioError(RHS As Variant)
   'No s'usa. La variable sempre s'assigna amb Get
End Property

'----------------------------------------------------------------------------------------------
'-- Property Let i Property Set ITransaccions_IdTransaccio
'----------------------------------------------------------------------------------------------
' Funcions que implementen la propietat IdTransaccio de la interfcie ITransaccions
' a partir de la variable privada IdTransaccio
'---------------------------------------------------------------------------------------------
Private Property Set ITransaccions_IdTransaccio(ByVal RHS As ADODB.Connection)
   Set AuxIdTransaccio = RHS
End Property

Private Property Get ITransaccions_IdTransaccio() As ADODB.Connection
   Set ITransaccions_IdTransaccio = AuxIdTransaccio
End Property

'----------------------------------------------------------------------------------------------
'-- ITransaccions_BeginTransaction()
'----------------------------------------------------------------------------------------------
' Implementa el mtode BeginTransaction de la interfcie ITransaccions
' cridant a la funci BeginTransaction
'----------------------------------------------------------------------------------------------
Private Function ITransaccions_BeginTransaction() As ADODB.Connection
   Set ITransaccions_BeginTransaction = AuxBeginTransaction
End Function

'----------------------------------------------------------------------------------------------
'-- ITransaccions_CommitTransaction()
'----------------------------------------------------------------------------------------------
' Implementa el mtode CommitTransaction de la interfcie ITransaccions
' cridant a la funci CommitTransaction
'----------------------------------------------------------------------------------------------
Private Function ITransaccions_CommitTransaction() As ADODB.Connection
   Set ITransaccions_CommitTransaction = AuxCommitTransaction
End Function

'----------------------------------------------------------------------------------------------
'-- ITransaccions_RollBackTransaction()
'----------------------------------------------------------------------------------------------
' Implementa el mtode RollBack de la interfcie ITransaccions
' cridant a la funci RollBack
'----------------------------------------------------------------------------------------------
Private Function ITransaccions_RollBackTransaction() As ADODB.Connection
   Set ITransaccions_RollBackTransaction = AuxRollBackTransaction
End Function

'----------------------------------------------------------------------------------------------
'-- GetIT()
'----------------------------------------------------------------------------------------------
' Per tal de poder tenir clients d'aquesta classe que no es trobin a la mateixa maquina,
' o clients tipus script, aquesta funcio em permet retornar l'interfcie de Transaccions
'----------------------------------------------------------------------------------------------
Public Function GetIT() As ITransaccions
   'Retorno aquest objecte amb l'interficie IMantXML
   Set GetIT = Me
End Function



