VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsBD"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Const ctStrNomClasse = "clsBD"

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

Private AuxIdTransaccio As ADODB.Connection 'S'utilitza per implementar la variable pblica d'identificador de sessi
'----------------------------------------------------------------------------------------------
'-- Property Let i Get IdTransaccio()
'----------------------------------------------------------------------------------------------
' Implementa la variable IdTransaccio que indica el identificador de la transacci
'----------------------------------------------------------------------------------------------
Public Property Get IdTransaccio() As ADODB.Connection
   Set IdTransaccio = AuxIdTransaccio
End Property

Public Property Set IdTransaccio(connValor As ADODB.Connection)
   Set AuxIdTransaccio = connValor
End Property

'----------------------------------------------------------------------------------------------
'-- Property Get RutaArxiuIni
'----------------------------------------------------------------------------------------------
' Propietat que retorna la ruta completa de l'arxiu Ini de l'aplicaci
' Aquest arxiu es troba a la mateixa carpeta que la de l'arxiu GIMBD.DLL
'----------------------------------------------------------------------------------------------
Public Property Get RutaArxiuIni() As String
   RutaArxiuIni = App.Path & "\GIMBD.INI"
End Property

'----------------------------------------------------------------------------------------------
'-- Consulta XML()
'----------------------------------------------------------------------------------------------
' Executa sobre la BD la consulta que es passa com a parmetre.
' El resultat de la consulta el retorna com a cadena XML
'----------------------------------------------------------------------------------------------
Public Function ConsultaXML(strSQL As String) As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
   If TypeName(Me.IdTransaccio) = "Nothing" Then
      strResultat = ConsultaXMLSenseTransaccio(strSQL)
   Else
      strResultat = ConsultaXMLAmbTransaccio(Me.IdTransaccio, strSQL)
   End If
   
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   ConsultaXML = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - ConsultaXML"
   ConsultaXML = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- ExecutaSQL()
'----------------------------------------------------------------------------------------------
' Executa sobre la BD la instrucci SQL que se li passa com a parmetre
' Retorna False si hi ha hagut un error i True altrament
'----------------------------------------------------------------------------------------------
Public Function ExecutaSQL(strSQL As String) As Boolean
   Dim bolResultat As Boolean
       
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   If TypeName(Me.IdTransaccio) = "Nothing" Then
      bolResultat = ExecutaSQLSenseTransaccio(strSQL)
   Else
      bolResultat = ExecutaSQLAmbTransaccio(Me.IdTransaccio, strSQL)
   End If
   
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   ExecutaSQL = bolResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - ExecutaSQL"
   ExecutaSQL = False
   Exit Function
    
End Function

'----------------------------------------------------------------------------------------------
'-- UpdateXML()
'----------------------------------------------------------------------------------------------
' Transforma la cadena XML en un recordset desconnectat i s 'actualitza
' la BD amb aquest recordset mitjanant UpdateBatch
'----------------------------------------------------------------------------------------------
Public Function UpdateXML(strXML As String) As Boolean
   Dim bolResultat As Boolean
       
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
     
   If TypeName(Me.IdTransaccio) = "Nothing" Then
      bolResultat = UpdateXMLSenseTransaccio(strXML)
   Else
      bolResultat = UpdateXMLAmbTransaccio(Me.IdTransaccio, strXML)
   End If
     
   
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   UpdateXML = bolResultat
   
   Exit Function
    
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - UpdateXML"
   UpdateXML = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- ConsultaXMLSenseTransaccio()
'----------------------------------------------------------------------------------------------
' Fa la ConsultaXML sense transacci
'----------------------------------------------------------------------------------------------
Public Function ConsultaXMLSenseTransaccio(strSQL As String) As String
    
   Dim strConnexioBD As String
   Dim rstADO As ADODB.Recordset
   Dim steADO As ADODB.Stream
      
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Comprova que el parmetre no sigui buit
   If strSQL = "" Then
      Err.Raise ctintErrorParametresBuits
   End If

   'Es recupera la cadena de connexi de l'arxiu INI mitjanant la funci Consulta ArxiuIni
   strConnexioBD = ConsultaArxiuIniBD("General", "CadenaConnexioBD")
   
   'Si hi ha hagut error en la funci ConsultaArxiuIni, produeix un missatge d'error
  
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
  
   'Es crea un recordset amb la sentncia SQL que s'ha passat com a parmetre
   Set rstADO = CreateObject("ADODB.Recordset")
   rstADO.CursorLocation = adUseClient
   
   rstADO.Open strSQL, strConnexioBD, adOpenStatic, adLockBatchOptimistic
   
   'Es guarda el contingut del recordset en un objecte Stream com a XML
   Set steADO = CreateObject("ADODB.Stream")
   rstADO.Save steADO, adPersistXML
       
   ConsultaXMLSenseTransaccio = steADO.ReadText
   
   'S'alliberen els recursos
   Set rstADO = Nothing
   Set steADO = Nothing
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - ConsultaXMLSenseTransaccio"
   ConsultaXMLSenseTransaccio = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- ConsultaXMLAmbTransaccio()
'----------------------------------------------------------------------------------------------
' Fa la ConsultaXML amb transacci
'----------------------------------------------------------------------------------------------
Public Function ConsultaXMLAmbTransaccio(cntSeccio As ADODB.Connection, strSQL As String) As String
      
   Dim rstADO As ADODB.Recordset
   Dim steADO As ADODB.Stream
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Comprova que el parmetre no sigui buit
   If strSQL = "" Then
      Err.Raise ctintErrorParametresBuits
   End If
   
   'Es crea un recordset amb la sentncia SQL que s'ha passat com a parmetre
   Set rstADO = CreateObject("ADODB.Recordset")
   rstADO.CursorLocation = adUseClient
   
   rstADO.Open strSQL, cntSeccio, adOpenStatic, adLockBatchOptimistic
   
   'Es guarda el contingut del recordset en un objecte Stream com a XML
   Set steADO = CreateObject("ADODB.Stream")
   rstADO.Save steADO, adPersistXML
   
   ConsultaXMLAmbTransaccio = steADO.ReadText
         
   'S'alliberen els recursos
   Set rstADO = Nothing
   Set steADO = Nothing
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - ConsultaXMLAmbTransaccio"
   ConsultaXMLAmbTransaccio = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- ExecutaSQLSenseTransaccio()
'----------------------------------------------------------------------------------------------
' Fa ExecutaSQL sense transacci
'----------------------------------------------------------------------------------------------
Public Function ExecutaSQLSenseTransaccio(strSQL As String) As Boolean

   Dim cntADO As ADODB.Connection
   Dim strConnexioBD As String
  
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Comprova que el parmetre no sigui buit
   If strSQL = "" Then
      Err.Raise ctintErrorParametresBuits
   End If
    
   'Es recupera la cadena de connexi de l'arxiu INI
   strConnexioBD = ConsultaArxiuIniBD("General", "CadenaConnexioBD")
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
        
   'S'obre la connexi i s'executa la instrucci SQL
   Set cntADO = New ADODB.Connection
   cntADO.Open strConnexioBD
   cntADO.Execute strSQL
   cntADO.Close
 
   ExecutaSQLSenseTransaccio = True
    
   'S'allibera la connexi
   Set cntADO = Nothing
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - ExecutaSQLSenseTransaccio"
   ExecutaSQLSenseTransaccio = False
   Exit Function
    
End Function

'----------------------------------------------------------------------------------------------
'-- ExecutaSQLAmbTransaccio()
'----------------------------------------------------------------------------------------------
' Fa ExecutaSQL amb transacci
'----------------------------------------------------------------------------------------------
Public Function ExecutaSQLAmbTransaccio(cntSeccio As ADODB.Connection, strSQL As String) As Boolean
     
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Comprova que el parmetre no sigui buit
   If strSQL = "" Then
      Err.Raise ctintErrorParametresBuits
   End If
    
   cntSeccio.Execute strSQL
    
   ExecutaSQLAmbTransaccio = True

   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - ExecutaSQLAmbTransaccio"
   ExecutaSQLAmbTransaccio = False
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- UpdateXMLSenseTransaccio()
'----------------------------------------------------------------------------------------------
' Fa un UpdateXML sense transacci
'----------------------------------------------------------------------------------------------
Public Function UpdateXMLSenseTransaccio(strXML As String) As Boolean

   Dim rstADO As ADODB.Recordset
   Dim steADO As ADODB.Stream
   Dim strConnexioBD As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
   'Comprova que el parmetre no sigui buit
   If strXML = "" Then
      Err.Raise ctintErrorParametresBuits
   End If
  
     
   '-- Es crea un nou objecte Stream i s'hi escriu la cadena XML
   Set steADO = CreateObject("ADODB.Stream")
   steADO.Open
   steADO.WriteText strXML
   steADO.Position = 0
        
   '-- Es crea un nou recordset i es recupera la cadena XML mitjanant l'Stream
   Set rstADO = CreateObject("ADODB.Recordset")
   rstADO.Open steADO
                
   'Es recupera la cadena de connexi de l'arxiu INI
   strConnexioBD = ConsultaArxiuIniBD("General", "CadenaConnexioBD")
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
        
   'Es fa un UpdateBatch dels registres modificats
   rstADO.ActiveConnection = strConnexioBD
   rstADO.MarshalOptions = adMarshalModifiedOnly
   rstADO.UpdateBatch
   
   'Si no hi ha hagut error es retorna True
   UpdateXMLSenseTransaccio = True
    
   'S'alliberen els recursos
   Set rstADO = Nothing
   Set steADO = Nothing
    
   Exit Function
    
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - UpdateXMLSenseTransaccio"
   UpdateXMLSenseTransaccio = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- UpdateXMLAmbTransaccio()
'----------------------------------------------------------------------------------------------
' Fa un UpdateXML amb transacci
'----------------------------------------------------------------------------------------------
Public Function UpdateXMLAmbTransaccio(cntSeccio As ADODB.Connection, strXML As String) As Boolean

   Dim rstADO As ADODB.Recordset
   Dim steADO As ADODB.Stream
   Dim ADOfem As ADODB.Recordset
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Comprova que el parmetre no sigui buit
   If strXML = "" Then
      Err.Raise ctintErrorParametresBuits
   End If
    
   '-- Es crea un nou objecte Stream i s'hi escriu la cadena XML
   Set steADO = CreateObject("ADODB.Stream")
   steADO.Open
   steADO.WriteText strXML
   steADO.Position = 0
      
   '-- Es crea un nou recordset i es recupera la cadena XML mitjanant l'Stream
   Set rstADO = CreateObject("ADODB.Recordset")
   rstADO.Open steADO
   'Es fa un UpdateBatch dels registres modificats
   rstADO.ActiveConnection = cntSeccio
   rstADO.MarshalOptions = adMarshalModifiedOnly
   rstADO.UpdateBatch
   
   'Si no hi ha hagut error es retorna True
   UpdateXMLAmbTransaccio = True
    
   'S'alliberen els recursos
   Set rstADO = Nothing
   Set steADO = Nothing
    
   Exit Function
    
TractaError:

   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - UpdateXMLAmbTransaccio"
   UpdateXMLAmbTransaccio = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- BeginTransaction()
'----------------------------------------------------------------------------------------------
' Augmenta un nivell de transacci
'----------------------------------------------------------------------------------------------
Public Function BeginTransaction() As ADODB.Connection
   Dim strConnexioBD As String
   Dim cntADO As ADODB.Connection
   Dim clsRecoleccioDeixalla As GIMDeixalla.clsDeixalla
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Si no hi havia una transaccio anterior, es crea la connexi
   If TypeName(Me.IdTransaccio) = "Nothing" Then
   
      'Es recupera la cadena de connexi de l'arxiu INI
      strConnexioBD = ConsultaArxiuIniBD("General", "CadenaConnexioBD")
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
        
      'S'obre la connexi i s'executa BeginsTrans
      Set cntADO = New ADODB.Connection
      cntADO.Open strConnexioBD
      'cntADO.IsolationLevel = adXactRepeatableRead
      cntADO.BeginTrans
      
      'S'inclou la connexi dintre el procs de recollecci de
      'deixalles
      Set clsRecoleccioDeixalla = New GIMDeixalla.clsDeixalla
      
      clsRecoleccioDeixalla.AfegeixConnexio cntADO
      'Si aquesta funci ha donat error, genera un error
      If clsRecoleccioDeixalla.NumError <> ctintErrorOK Then
         UbicacioError = clsRecoleccioDeixalla.UbicacioError
         Err.Raise clsRecoleccioDeixalla.NumError
      End If
      Set clsRecoleccioDeixalla = Nothing
      
      'Es retorna la connexi acabada de crear
      Set BeginTransaction = cntADO
      Set cntADO = Nothing
   Else
      'S'executa BeginTrans sobre la connexi existent i es retorna la connexi
      Me.IdTransaccio.BeginTrans
      Set BeginTransaction = Me.IdTransaccio
   End If
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - BeginTransaction"
   Set BeginTransaction = Nothing
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- CommitTransaction()
'----------------------------------------------------------------------------------------------
' Augmenta un nivell de transacci
'----------------------------------------------------------------------------------------------
Public Function CommitTransaction() As ADODB.Connection

   Dim lngNivellTransaccio As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   
   If TypeName(Me.IdTransaccio) = "Nothing" Then
      Set CommitTransaction = Nothing
   Else
      'S'esbrina quin s el nivell de transacci
      lngNivellTransaccio = Me.IdTransaccio.BeginTrans()
      Me.IdTransaccio.RollbackTrans
      lngNivellTransaccio = lngNivellTransaccio - 1
      
      'Es fa un CommitTrans
      Me.IdTransaccio.CommitTrans
      
      'Si s el primer nivell de transacci, es tanca la connexi i s'alliberen registres
      If lngNivellTransaccio <= 1 Then
         Me.IdTransaccio.Close
         Set Me.IdTransaccio = Nothing
         Set CommitTransaction = Nothing
      Else
         Set CommitTransaction = Me.IdTransaccio
      End If
   End If
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - CommitTransaction"
   Set CommitTransaction = Nothing
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- RollBackTransaction()
'----------------------------------------------------------------------------------------------
' Augmenta un nivell de transacci
'----------------------------------------------------------------------------------------------
Public Function RollBackTransaction() As ADODB.Connection

   Dim lngNivellTransaccio As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   
   If TypeName(Me.IdTransaccio) = "Nothing" Then
      Set RollBackTransaction = Nothing
   Else
      'S'esbrina quin s el nivell de transacci
      lngNivellTransaccio = Me.IdTransaccio.BeginTrans()
      Me.IdTransaccio.RollbackTrans
      lngNivellTransaccio = lngNivellTransaccio - 1
      
      'Es fa un RollbackTrans
      Me.IdTransaccio.RollbackTrans
      
      'Si s el primer nivell de transacci, es tanca la connexi i s'alliberen registres
      If lngNivellTransaccio <= 1 Then
         Me.IdTransaccio.Close
         Set Me.IdTransaccio = Nothing
         Set RollBackTransaction = Nothing
      Else
         Set RollBackTransaction = Me.IdTransaccio
      End If
   End If
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna False i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - RollBackTransaction"
   Set RollBackTransaction = Nothing
   Exit Function
End Function

'**********************************************************************************************
'-- Funcions per consulta d'arxius ini
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- ConsultaArxiuIniBD()
'----------------------------------------------------------------------------------------------
' Consulta el valor d'una clau de l'arxiu INI de la base de dades
' Retorna la cadena buida si s'ha produt algun error i el valor altrament
'----------------------------------------------------------------------------------------------

Public Function ConsultaArxiuIniBD(strSeccio As String, strClau As String) As String
   Dim strText As String
   
    'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Consulta l'arxiu INI amb la funci auxiliar ConsultaArxiuIni
   strText = ConsultaArxiuIni(RutaArxiuIni, strSeccio, strClau)
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   ConsultaArxiuIniBD = StrTran(strText, "{mod}", App.Path)
   Exit Function
    
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - ConsultaArxiuIniBD"
   ConsultaArxiuIniBD = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- ConsultaArxiuIni()
'----------------------------------------------------------------------------------------------
' Consulta el valor d'una clau d'un arxiu INI qualsevol.
' Retorna la cadena buida si s'ha produt algun error i el valor altrament
'----------------------------------------------------------------------------------------------
Public Function ConsultaArxiuIni(strRutaArxiuIni As String, strSeccio As String, _
   strClau As String) As String
   Dim strBufferCaracters As String * 256
   Dim intLlargada As Integer
   Dim strResultat As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Comprova que cap parmetre no sigui buit i que l'arxiu Ini existeixi
   If strRutaArxiuIni = "" Or strSeccio = "" Or strClau = "" Then
      Err.Raise ctintErrorParametresBuits
   End If
  
 
   If Dir(strRutaArxiuIni) = "" Then
      Err.Raise ctIntErrorUbicacioIni
   End If
    
   'Crida a la funci API que serveix per consultar els arxius INI
   strBufferCaracters = Space$(256)
   intLlargada = GetPrivateProfileString(strSeccio, strClau, "@#&", strBufferCaracters, _
    255, strRutaArxiuIni)
   strResultat = Left$(strBufferCaracters, intLlargada)
    
   'Si no es troba la clau, es genera un error
   If strResultat = "@#&" Then
      Err.Raise ctintErrorConsultaIni
   End If
    
   'Si no s'ha produt l'error es retorna el valor recuperat de la clau
   ConsultaArxiuIni = strResultat
   Exit Function
    
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - ConsultaArxiuIni"
   ConsultaArxiuIni = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- StrTran()
'----------------------------------------------------------------------------------------------
'Busca en una cadena de carcters les aparicions d'una segona cadena i, desprs, remplaa cada
'aparici amb una tercera cadena
'----------------------------------------------------------------------------------------------
Public Function StrTran(strStringbase As String, strStringARemplacar As String, strStringRemplacable As String) As String
   Dim strTemp As String
   Dim lngPosicioString As Long
   Dim lngLlargadaStringARemplacar As Long
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   lngLlargadaStringARemplacar = Len(strStringARemplacar)
   strTemp = strStringbase
   lngPosicioString = InStr(strTemp, strStringARemplacar)
   Do While lngPosicioString <> 0
      strTemp = Mid$(strTemp, 1, lngPosicioString - 1) + _
       strStringRemplacable + _
       Mid$(strTemp, lngPosicioString + lngLlargadaStringARemplacar)
      lngPosicioString = InStr(strTemp, strStringARemplacar)
   Loop
   StrTran = strTemp
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - StrTran"
   StrTran = ""
   Exit Function
End Function
