Attribute VB_Name = "ModulPublic"
Option Explicit

'Defineix el tipus CRITICAL_SECTION de l'API
Public Type CRITICAL_SECTION
   Reserved1 As Long
   Reserved2 As Long
   Reserved3 As Long
   Reserved4 As Long
   Reserved5 As Long
   Reserved6 As Long
End Type

'Donat que ens trobem en un Exe ActiveX single-threaded, aquestes variables sn globals a totes
'les instncies de la classe clsDeixalla i al procs recollector de deixalles.
   
Public lngTimerRecollidor As Long 'Timer que activa peridicament la recollecci de deixalles
Public colConnexionsObertes(1 To 2) As Collection 'Dues colleccions amb les connexions obertes
Public lngDarreraClau As Long 'Darrera clau emprada en afegir una connexi
Public lngClientsConnectats As Long 'Nombre de classes clients connectades
Public lngColeccioDeTreball As Long 'ndex de la collecci a la qual s'estan afegint connexions
Public clsReferenciaBloqueig As clsDeixalla 'Serveix per aplicar un bloqueig per tal que la classe
                                            'no s'alliberi abans de temps
Public csBloqueigColleccioTreball As CRITICAL_SECTION 'Critical section per accedir a la collecci de
                                                      'treball
Public lngPeriodicitatProcesRecollector As Long 'Periodicitat amb qu s'engega el procs recollector
Public lngMaximTempsPerTransaccio As Long 'Temps a partir del qual es considera que 1 transacci es troba inactiva

'Declaracions globals de funcions API
'Funcions de critical sections
Public Declare Sub InitializeCriticalSection Lib "kernel32" (lpCriticalSection As CRITICAL_SECTION)
Public Declare Sub EnterCriticalSection Lib "kernel32" (lpCriticalSection As CRITICAL_SECTION)
Public Declare Sub LeaveCriticalSection Lib "kernel32" (lpCriticalSection As CRITICAL_SECTION)
Public Declare Sub DeleteCriticalSection Lib "kernel32" (lpCriticalSection As CRITICAL_SECTION)

'Funcions de Timer i comptatge de temps
Public Declare Function GetTickCount Lib "kernel32.dll" () As Long
Public Declare Function KillTimer Lib "user32" (ByVal hWnd As Long, _
 ByVal lIDEvent As Long) As Long
Public Declare Function SetTimer Lib "user32" (ByVal hWnd As Long, _
 ByVal lIDEvent As Long, ByVal lElapse As Long, _
 ByVal lTimerFunc As Long) As Long

'Funci per bloquejar un objecte per tal que no s'alliberi abans de temps
Public Declare Function CoLockObjectExternal Lib "ole32" (ByVal pUnk As IUnknown, _
 ByVal fLock As Long, ByVal fLastUnlockReleases As Long) As Long

'Funci per accedir els arxius INI
Declare Function GetPrivateProfileString Lib "kernel32" Alias _
 "GetPrivateProfileStringA" (ByVal lpApplicationName As String, _
 ByVal lpKeyName As Any, ByVal lpDefault As String, _
 ByVal lpReturnedString As String, ByVal nSize As Long, _
 ByVal lpFileName As String) As Long
 
Public Const ctStrNomModul = "GIMDeixalla"

'Codis d'error. Per al significat, veure uns altres projectes
Public Const ctintErrorOK = 0 'No hi ha hagut error
Public Const ctintErrorConsultaIni = 513
Public Const ctintErrorParametresBuits = 514
Public Const ctIntErrorUbicacioIni = 515
Public Const ctIntErrorFuncioNoImplementada = 518
   
'----------------------------------------------------------------------------------------------
'-- RecollectorDeixalla
'----------------------------------------------------------------------------------------------
' Recorre alternativament i peridica les 2 colleccions i tanca les connexions massa antigues
' Si ja no queden connexions, tanca i allibera el procs de recollecci de deixalles
'----------------------------------------------------------------------------------------------

Public Sub RecollectorDeixalla(ByVal hWnd As Long, ByVal lngMsg As Long, ByVal lngID As Long, _
   ByVal lngTemps As Long)
   Dim lngColeccioRecolector As Long 'Collecci que recorrerem per alliberar-ne
                                     'les connexions antigues
   Dim lngNumeroConnexioActual As Long 'ndex per recrrer aquesta collecci
   Dim lngTotalConnexions As Long 'Total de membres d'aquesta collecci
   Dim clsInfoConnexioActual As InfoConnexio 'Connexi actual que estem examinant
   Dim lngNivellTransaccio As Long 'Nivell de transacci en qu es troba la connexi actual
   Dim lngComptadorTransaccio As Long 'Connexi per desfer tots els nivells de transacci de
                                      'la connexi actual.
         
   'Fa que la collecci que s'estigui afegint no sigui la mateixa que est examinant
   'en aquest procediment
   EnterCriticalSection csBloqueigColleccioTreball
   lngColeccioRecolector = lngColeccioDeTreball
   If lngColeccioDeTreball = 1 Then
      lngColeccioDeTreball = 2
   Else
      lngColeccioDeTreball = 1
   End If
   LeaveCriticalSection csBloqueigColleccioTreball
      
   'Recorre totes les connexions de la collecci que estem examinant
   lngNumeroConnexioActual = 1
   lngTotalConnexions = colConnexionsObertes(lngColeccioRecolector).Count
   
   Do While lngNumeroConnexioActual <= lngTotalConnexions
      Set clsInfoConnexioActual = colConnexionsObertes(lngColeccioRecolector) _
       .Item(lngNumeroConnexioActual)
         
      'Si la connexi s molt antiga, tanca i elimina la connexi
      If (GetTickCount - clsInfoConnexioActual.lngTempsIniciConnexio > _
       lngMaximTempsPerTransaccio) Then
   
         'Si la connexi est oberta, desfa tots els nivells de transaccions i la tanca
         If Not (clsInfoConnexioActual.cntConnexio Is Nothing) Then
            If clsInfoConnexioActual.cntConnexio.State = adStateOpen Then
               lngNivellTransaccio = clsInfoConnexioActual.cntConnexio.BeginTrans
               For lngComptadorTransaccio = 1 To lngNivellTransaccio
                  clsInfoConnexioActual.cntConnexio.RollbackTrans
               Next lngComptadorTransaccio
               clsInfoConnexioActual.cntConnexio.Close
            End If
         End If
   
         'Allibera la referncia a la connexi i elimina l'element de la collecci
         Set clsInfoConnexioActual.cntConnexio = Nothing
         colConnexionsObertes(lngColeccioRecolector).Remove lngNumeroConnexioActual
         
         'Lgicament, el nombre d'elements ha disminut en 1
         lngTotalConnexions = lngTotalConnexions - 1
      Else
         lngNumeroConnexioActual = lngNumeroConnexioActual + 1
      End If
   Loop
   
   'En cas que no hi hagi cap connexi, acaba amb el procs i allibera recursos
   If colConnexionsObertes(1).Count = 0 And colConnexionsObertes(2).Count = 0 Then
      EnterCriticalSection csBloqueigColleccioTreball
      Set colConnexionsObertes(1) = Nothing
      Set colConnexionsObertes(2) = Nothing
      KillTimer 0, lngTimerRecollidor
      CoLockObjectExternal clsReferenciaBloqueig, 0, 1
      LeaveCriticalSection csBloqueigColleccioTreball
      DeleteCriticalSection csBloqueigColleccioTreball
   End If
  
End Sub
