VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDeixalla"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public NumError As Long
Public UbicacioError As String

Private Const ctStrNomClasse = "clsDeixalla"
'----------------------------------------------------------------------------------------------
'-- Property Get RutaArxiuIni
'----------------------------------------------------------------------------------------------
' Propietat que retorna la ruta completa de l'arxiu Ini de l'aplicaci
' Aquest arxiu es troba a la mateixa carpeta que la de l'arxiu GIMBD.DLL
'----------------------------------------------------------------------------------------------
Public Property Get RutaArxiuIni() As String
   RutaArxiuIni = Mid$(App.Path, 1, InStrRev(App.Path, "\")) & "GIMBD\GIMBD.INI"
End Property

'----------------------------------------------------------------------------------------------
'-- AfegeixConnexio
'----------------------------------------------------------------------------------------------
' Afegeix una connexi al procs recollector de deixalles collocant-lo en una collecci
' Si les variables no estan inicialitzades (perqu s la 1a. connexi), s'inicialitzen
'----------------------------------------------------------------------------------------------

Public Sub AfegeixConnexio(ByVal cntConnexio As Variant)
   Dim clsInfoConnexioActual As InfoConnexio
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Si no estan inicialitzades les variables s que s la primera connexi. S'inicialitza tot
   If colConnexionsObertes(1) Is Nothing And colConnexionsObertes(2) Is Nothing Then
      
      InitializeCriticalSection csBloqueigColleccioTreball
                    
      'Es recupera la periodicitat del procs recollector
     
      lngPeriodicitatProcesRecollector = Val(ConsultaArxiuIni(RutaArxiuIni, "General", _
       "PeriodicitatRecolectorDeixalla"))
      lngMaximTempsPerTransaccio = Val(ConsultaArxiuIni(RutaArxiuIni, "General", _
       "MaximTempsDeTransaccio"))
     
      'S'inicialitzen les colleccions que contindran informaci sobre les connexions
      EnterCriticalSection csBloqueigColleccioTreball
      lngDarreraClau = 0 'Com estem a la primera connexi, la darrera clau usada s 0
      lngColeccioDeTreball = 1
      Set colConnexionsObertes(1) = New Collection
      Set colConnexionsObertes(2) = New Collection
      LeaveCriticalSection csBloqueigColleccioTreball
      
      'S'activa el timer per tal que el recollector de deixalla s'activi peridicament
      lngTimerRecollidor = SetTimer(0, 0, lngPeriodicitatProcesRecollector, _
       AddressOf RecollectorDeixalla)
      
      'Bloqueja l'objecte actual perqu no s'alliberi
      'abans que s'hagin alliberat totes les connexions
      Set clsReferenciaBloqueig = Me
      CoLockObjectExternal clsReferenciaBloqueig, 1, 1
   End If
   
   'Crea l'objecte Infoconnexi i posa una referncia a la connexi i el temps actual
   Set clsInfoConnexioActual = New InfoConnexio
   Set clsInfoConnexioActual.cntConnexio = cntConnexio
   clsInfoConnexioActual.lngTempsIniciConnexio = GetTickCount
   
   
   'Afegim l'objecte a la collecci
   EnterCriticalSection csBloqueigColleccioTreball
   lngDarreraClau = lngDarreraClau + 1
   clsInfoConnexioActual.lngClau = lngDarreraClau
   colConnexionsObertes(lngColeccioDeTreball).Add clsInfoConnexioActual, _
    "Clau" & Trim(Str(lngDarreraClau))
   LeaveCriticalSection csBloqueigColleccioTreball
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctStrNomModul & " - " & ctStrNomClasse & _
      " - AfegeixConnexio"
   Exit Sub
End Sub

Private Sub Class_Initialize()
   'Incrementa el nombre de classes clients connectades
   lngClientsConnectats = lngClientsConnectats + 1
End Sub

Private Sub Class_Terminate()
   'Decrementa el nombre de classes clients connectades
   lngClientsConnectats = lngClientsConnectats - 1
End Sub

Public Sub InfoClasseDeixalla()
   If (colConnexionsObertes(1) Is Nothing) And (colConnexionsObertes(2) Is Nothing) Then
      lngDarreraClau = 0
      Set colConnexionsObertes(1) = New Collection
      Set colConnexionsObertes(2) = New Collection
   End If
End Sub


'----------------------------------------------------------------------------------------------
'-- ConsultaArxiuIni()
'----------------------------------------------------------------------------------------------
' Consulta el valor d'una clau d'un arxiu INI qualsevol.
' Retorna la cadena buida si s'ha produt algun error i el valor altrament
'----------------------------------------------------------------------------------------------
Public Function ConsultaArxiuIni(strRutaArxiuIni As String, strSeccio As String, _
   strClau As String) As String
   Dim strBufferCaracters As String * 256
   Dim intLlargada As Integer
   Dim strResultat As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Comprova que cap parmetre no sigui buit i que l'arxiu Ini existeixi
   If strRutaArxiuIni = "" Or strSeccio = "" Or strClau = "" Then
      Err.Raise ctintErrorParametresBuits
   End If
  
 
   If Dir(strRutaArxiuIni) = "" Then
      Err.Raise ctIntErrorUbicacioIni
   End If
    
   'Crida a la funci API que serveix per consultar els arxius INI
   strBufferCaracters = Space$(256)
   intLlargada = GetPrivateProfileString(strSeccio, strClau, "@#&", strBufferCaracters, _
    255, strRutaArxiuIni)
   strResultat = Left$(strBufferCaracters, intLlargada)
    
   'Si no es troba la clau, es genera un error
   If strResultat = "@#&" Then
      Err.Raise ctintErrorConsultaIni
   End If
    
   'Si no s'ha produt l'error es retorna el valor recuperat de la clau
   ConsultaArxiuIni = strResultat
   Exit Function
    
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctStrNomModul & " - " & ctStrNomClasse & _
      " - ConsultaArxiuIni"
   ConsultaArxiuIni = ""
   Exit Function
End Function

