VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsFuncionsCapaInterficie"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const ctStrNomClasse = "FuncionsCapaInterficie"

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

'----------------------------------------------------------------------------------------------
'-- Property Get RutaArxiuIni
'----------------------------------------------------------------------------------------------
' Propietat que retorna la ruta completa de l'arxiu Ini de l'aplicaci
' Aquest arxiu es troba a la mateixa carpeta que la de l'arxiu GIMSuport.DLL
'----------------------------------------------------------------------------------------------
Public Property Get RutaArxiuIni() As String
   RutaArxiuIni = App.Path & "\" & ctStrNomArxiuIni
End Property

'**********************************************************************************************
'-- Funcions de cadenes
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- OcurrenciesCadena()
'----------------------------------------------------------------------------------------------
' Indica el nombre de vegades que una cadena
' apareix en una altra
'----------------------------------------------------------------------------------------------
Public Function OcurrenciesCadena(strCadena1 As String, strCadena2 As String) As Long
   Dim lngOcurrencies As Long
   Dim lngPosicio As Long
   Dim lngLongitudCadena1 As Long
   Dim lngLongitudCadena2 As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   If strCadena2 = "" Then
      OcurrenciesCadena = 0
   Else
      lngLongitudCadena1 = Len(strCadena1)
      lngLongitudCadena2 = Len(strCadena2)
      
      lngOcurrencies = 0
      lngPosicio = InStr(strCadena1, strCadena2)
      Do While lngPosicio <> 0
         lngOcurrencies = lngOcurrencies + 1
         'Troba la segent posici per buscar
         lngPosicio = lngPosicio + lngLongitudCadena2
         If lngPosicio > lngLongitudCadena1 Then
            lngPosicio = 0
         Else
            'Busca en aquesta posici
         lngPosicio = InStr(lngPosicio, strCadena1, strCadena2)
         End If
      Loop
      OcurrenciesCadena = lngOcurrencies
   End If
   Exit Function
TractaError:
   'Si hi ha hagut error, fixa les variables corresponents
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - OcurrenciesCadena"
   OcurrenciesCadena = 0
   Exit Function
End Function

'**********************************************************************************************
'-- Funcions per convertir entre recordsets ADO i cadenes XML
'**********************************************************************************************

'----------------------------------------------------------------------------------------------
'-- PassaXMLARecordset()
'----------------------------------------------------------------------------------------------
' A partir del recordset recuperat en format XML
' es genera un recordset ADO
'----------------------------------------------------------------------------------------------
Public Function PassaXMLARecordset(strRecordsetXML)
   Dim steADO As ADODB.Stream
   Dim rstResultat As ADODB.Recordset
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es guarda la cadena XML en un nou objecte Stream
   Set steADO = CreateObject("ADODB.Stream")
   steADO.Open
   steADO.WriteText strRecordsetXML
   steADO.Position = 0
      
   'Es crea un nou recordset i s'obre des de l'objecte Stream
   Set rstResultat = CreateObject("ADODB.Recordset")
   rstResultat.Open steADO
   
   Set PassaXMLARecordset = rstResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, fixa les variables corresponents
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - PassaXMLARecordset"
   Set PassaXMLARecordset = Nothing
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- PassaRecordsetAXML()
'----------------------------------------------------------------------------------------------
' A partir del recordset ADO
' es genera un recordset en format XML
'----------------------------------------------------------------------------------------------
Public Function PassaRecordsetAXML(strRecordsetXML) As String

   Dim steStreamADO As Stream
      
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   ' Creo un nou objecte Stream
   Set steStreamADO = CreateObject("ADODB.Stream")
   ' Guardo el contingut del recordset en un objecte Stream com a XML
   strRecordsetXML.Save steStreamADO, adPersistXML
   ' Retorno la cadena de texte
   PassaRecordsetAXML = steStreamADO.ReadText
   Set steStreamADO = Nothing
   Exit Function
TractaError:
   'Si hi ha hagut error, fixa les variables corresponents
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - PassaRecordsetAXML"
   PassaRecordsetAXML = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- CopiaRecordset()
'----------------------------------------------------------------------------------------------
' Crea un recordset que s cpia d'aquell que se li passa com a parmetre
' Si el recordset original tenia filtre, la cpia noms cont els registres que contenen
' el filtre
'----------------------------------------------------------------------------------------------
Public Function CopiaRecordset(rstRecordset As ADODB.Recordset) As ADODB.Recordset
   Dim strXML As String
   Dim rstTemp As ADODB.Recordset
   
   'Desenllaa els controls del formulari actual
   'per tal que el recordset es copi b
   If Not (Screen.ActiveForm Is Nothing) Then
      DeslinkControls Screen.ActiveForm
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
   End If
             
   'Obt la cadena XML corresponent al recordset original
   strXML = PurgaActualitzacionsRecordset(rstRecordset)
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   'Passa aquest XML a un recordset nou
   Set rstTemp = PassaXMLARecordset(strXML)
        
   'Torna a enllaar els controls
   If Not (Screen.ActiveForm Is Nothing) Then
      LinkControls Screen.ActiveForm
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
   End If
   
   Set CopiaRecordset = rstTemp
Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - CopiaRecordset"
   Exit Function
End Function

'**********************************************************************************************
'-- Funcions per comprovar condicions de recordset
'**********************************************************************************************

'----------------------------------------------------------------------------------------------
'-- FiltreRegistreActual()
'----------------------------------------------------------------------------------------------
' Crea un filtre d'ADO que inclou tots els valors dels camps del registre actual
'----------------------------------------------------------------------------------------------
Public Function FiltreRegistreActual(rstRecordset As ADODB.Recordset) As String
   Dim lngDarrerCamp As Long
   Dim lngComptador As Long
   Dim strStringCamp As String
   Dim strFiltre As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   If rstRecordset.BOF Or rstRecordset.EOF Then
      FiltreRegistreActual = "False"
   Else
      
      strFiltre = ""
      lngDarrerCamp = rstRecordset.Fields.Count - 1
      'Recorre tots els camps. Per a cada camp, produeix una cadena de l'estil
      'NomCamp = ValorCampEnRegistreActual. Les diferents cadenes les uneix
      'amb "And"
      For lngComptador = 0 To lngDarrerCamp
         strStringCamp = FormatFiltre(rstRecordset.Fields(lngComptador).Value)
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
         strFiltre = strFiltre & rstRecordset.Fields(lngComptador).Name & _
          " = " & strStringCamp & " And "
      Next lngComptador
      
      'Treu el darrer And
      FiltreRegistreActual = Mid$(strFiltre, 1, Len(strFiltre) - 5)
   End If
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - FiltreRegistreActual"
    FiltreRegistreActual = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- RegistreActualCompleixCondicio()
'----------------------------------------------------------------------------------------------
' Comprova si el registre actual compleix una determinada condici
' La condici deu ser expressada en format de filtre d'ADO
'----------------------------------------------------------------------------------------------
Public Function RegistreActualCompleixCondicio(rstRecordset As ADODB.Recordset, strCondicio As String) As Boolean
   Dim strFiltreRegistreActual As String
   Dim strFiltreActual As String
   Dim objMarcador As Variant
   Dim bolCompleix As Boolean
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Si no hi ha registre actual, s obvi que no ho compleix
   If rstRecordset.BOF Or rstRecordset.EOF Then
      RegistreActualCompleixCondicio = False
   Else 'Altrament
      'Guarda el filtre i la posici actual
      objMarcador = rstRecordset.Bookmark
      strFiltreActual = rstRecordset.Filter
      If strFiltreActual = "0" Then
         strFiltreActual = ""
      End If
      
      'Fa que el filtre del recordset sigui el "And" de la condici que volem
      'comprovar i del filtre del registre actual. D'aquesta manera, si
      'hi ha un registre que compleix aquest filtre, voldr dir que
      'el registre actual compleix la condici
      
      strFiltreRegistreActual = FiltreRegistreActual(rstRecordset)
      rstRecordset.Filter = "(" & strFiltreRegistreActual & ") And (" & strCondicions & ")"
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
         
      'Veu si el recordsetfiltrat t un registre com a mnim. Si s aix es compleix
      'la condici
      bolCompleix = (Not rstRecordset.EOF) And (Not rstRecordset.BOF)
      
      'Recupera el filtre i la posici actual
      rstRecordset.Filter = strFiltreActual
      rstRecordset.Bookmark = objMarcador
      RegistreActualCompleixCondicio = bolCompleix
   End If
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - RegistreActualCompleixCondicio"
    RegistreActualCompleixCondicio = False
   Exit Function
End Function


'**********************************************************************************************
'-- Funcions per obtenir noms actualitzacions d'una cadena XML
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- ObteActualitzacionsDeXML ()
'----------------------------------------------------------------------------------------------
' Donada una cadena XML obtinguda a partir d'un Recordset ADO, obt
' noms la informaci de les actualitzacions fetes sobre el Recordset
'----------------------------------------------------------------------------------------------

Public Function ObteActualitzacionsDeXML(strXML As String) As String
   Dim lngPosIniciData As Long 'Posici d'inici de la part <rs:data> del string XML
   Dim lngPosFinalData As Long 'Posici final de la mateixa part
   Dim lngPosInicialActualitzacio As Long 'Posici inici de cada actualitz. de dades al XML
   Dim lngPosFinalActualitzacio As Long 'Posici final de cada actualitzaci de dades
   Dim strMitjaCadenaXML As String 'Part de la part <rs:data> que estem tractant
   Dim strActualitzacions As String 'Cadena XML que representa les act. del recordset
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es calculen les posicions inici i final de la part <rs:data> de la cadena XML
   lngPosIniciData = InStr(strXML, "<rs:data>") + 9
   lngPosFinalData = InStr(strXML, "</rs:data>") - 1
    
   'Cadena XML que hi ha entre <rs:data> i </rs:data>
   strMitjaCadenaXML = Mid$(strXML, lngPosIniciData, lngPosFinalData - lngPosIniciData + 1)
        
   'El substring de la cadena XML que hi ha abans d'aquesta part
   'cont l'esquema i, per tant, s part de la cadena de'actualitzacions
   strActualitzacions = Mid$(strXML, 1, lngPosIniciData - 1) + Chr(13) + Chr(10)
    
   'Es troba la posici de la primera actualitzaci dins de la cadena XML
   TrobaPosicioActualitzacioXML strMitjaCadenaXML, lngPosInicialActualitzacio, _
    lngPosFinalActualitzacio
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
      
   Do While lngPosInicialActualitzacio > 0 'Mentre que hi hagi una actualitzaci
      'L'string d'actualitzaci en cont la subcadena d'actualitzaci
      strActualitzacions = strActualitzacions + Mid$(strMitjaCadenaXML, _
       lngPosInicialActualitzacio, lngPosFinalActualitzacio - _
       lngPosInicialActualitzacio + 1)
      'Com ja hem tractat aquesta part de la cadena XML, la treiem de strMitjaCadenaXML
      strMitjaCadenaXML = Mid$(strMitjaCadenaXML, lngPosFinalActualitzacio + 1)
      
      'Es troba la posici de la segent actualitzaci i controlla el possible error
      TrobaPosicioActualitzacioXML strMitjaCadenaXML, lngPosInicialActualitzacio, _
       lngPosFinalActualitzacio
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
   Loop
      
   'El substring de la cadena XML que hi ha desprs de la part
   '<rs:data> tamb s'inclou a la cadena d'actualitzacions
 
   ObteActualitzacionsDeXML = strActualitzacions & Chr(13) & Chr(10) & _
    Mid$(strXML, lngPosFinalData + 1)
   Exit Function
   
TractaError:
   'Si hi ha hagut error, fixa les variables corresponents
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - ObteActualitzacionsDeXML"
   ObteActualitzacionsDeXML = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- TrobaPosicioActualitzacioXML ()
'----------------------------------------------------------------------------------------------
' Dintre de una cadena XML obtinguda a partir d'un Recordset ADO, obt dues
' la posici de la primera actualitzaci, s decir, de la primera secci
' marcada com a <rs:insert>, <Rs:delete> o <rs:update>
'----------------------------------------------------------------------------------------------
Private Sub TrobaPosicioActualitzacioXML(strXML As String, lngPosInicial As Long, _
 lngPosfinal As Long)
   Dim lngPosIniInsert As Long 'Posici d'inici de la primera secci <rs:insert>
   Dim lngPosIniUpdate As Long 'Posici d'inici de la primera secci <rs:delete>
   Dim lngPosIniDelete As Long 'Posici d'inici de la primera secci <rs:update>
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Ompli aquestes variables amb els seus valors respectius
   lngPosIniInsert = InStr(strXML, "<rs:insert>")
   lngPosIniUpdate = InStr(strXML, "<rs:update>")
   lngPosIniDelete = InStr(strXML, "<rs:delete>")
    
   'Mira quina de les tres seccions comena abans
   lngPosInicial = MinimNoNul3numeros(lngPosIniInsert, lngPosIniUpdate, lngPosIniDelete)
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   'En el cas que existeixi alguna d'aquestes seccions d'actualitzaci
   If lngPosInicial > 0 Then
      'Calcula la posici final de la primera secci d'actualitzaci
      Select Case lngPosInicial
         Case lngPosIniInsert
            lngPosfinal = InStr(lngPosInicial, strXML, "</rs:insert>") + 11
         Case lngPosIniUpdate
            lngPosfinal = InStr(lngPosInicial, strXML, "</rs:update>") + 11
         Case lngPosIniDelete
            lngPosfinal = InStr(lngPosInicial, strXML, "</rs:delete>") + 11
      End Select
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, fixa les variables corresponents
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - TrobaPosicioActualitzacioXML"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- MinimNoNul3numeros ()
'----------------------------------------------------------------------------------------------
' Troba el valor mnim no nul de tres nmeros
'----------------------------------------------------------------------------------------------
Private Function MinimNoNul3numeros(lngNumero1 As Long, lngNumero2 As Long, _
 lngNumero3 As Long) As Long
 
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   If MinimNoNul(lngNumero1, lngNumero2) = lngNumero1 And _
    MinimNoNul(lngNumero1, lngNumero3) = lngNumero1 Then
      MinimNoNul3numeros = lngNumero1
   Else
      If MinimNoNul(lngNumero2, lngNumero3) = lngNumero2 Then
         MinimNoNul3numeros = lngNumero2
      Else
         MinimNoNul3numeros = lngNumero3
      End If
   End If
   Exit Function
TractaError:
   'Si hi ha hagut error, fixa les variables corresponents
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - MinimNoNul3numeros"
   MinimNoNul3numeros = 0
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- MinimNoNul ()
'----------------------------------------------------------------------------------------------
' Troba el valor mnim no nul de dos nmeros
'----------------------------------------------------------------------------------------------
Private Function MinimNoNul(lngNumero1 As Long, lngNumero2 As Long) As Long
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
  
   If (lngNumero1 = 0) Or ((lngNumero1 > lngNumero2) And (lngNumero2 <> 0)) Then
      MinimNoNul = lngNumero2
   Else
      MinimNoNul = lngNumero1
   End If
   Exit Function
End Function

'**********************************************************************************************
'-- Funcions per purgar les actualitzacions del recordset
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- PurgaActualitzacionsRecordset()
'----------------------------------------------------------------------------------------------
' Purga les actualitzacions del recordset de forma que queda com si no hi haguesin
' actualitzacions pendents
'----------------------------------------------------------------------------------------------

Public Function PurgaActualitzacionsRecordset(rstRecordset As ADODB.Recordset) _
  As String
  
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   Dim rstTemp As ADODB.Recordset
   Dim StrCadenaXML As String
   Dim strCadenaRow As String
   Dim lngNumCamp As Long
   Dim lngTotalCamps As Long
   Dim bolAlgunCampTractat As Boolean
         
   'Treu la cadena XML del recordset
   StrCadenaXML = PassaRecordsetAXML(rstRecordset)
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   'Treu la part d'encapalament de la cadena XML
   StrCadenaXML = Mid$(StrCadenaXML, 1, InStr(StrCadenaXML, "<rs:data>") + 8) & _
      Chr(13) & Chr(10)
        
   lngTotalCamps = rstRecordset.Fields.Count 'Nombre de Camps del Recorset
    
   If rstRecordset.RecordCount <> 0 Then
      'Recorre tot el recordset construint les cadenes de cada registre
      rstRecordset.MoveFirst
      Do While Not rstRecordset.EOF
         strCadenaRow = ""
         bolAlgunCampTractat = False
         For lngNumCamp = 0 To lngTotalCamps - 1
            If Not IsNull(rstRecordset.Fields(lngNumCamp).Value) Then
               bolAlgunCampTractat = True
               strCadenaRow = strCadenaRow & _
               rstRecordset.Fields(lngNumCamp).Name & "=" & "'" & _
               FormatXML(rstRecordset.Fields(lngNumCamp).Value) & "'" & " "
            End If
         Next lngNumCamp
         If bolAlgunCampTractat Then
            StrCadenaXML = StrCadenaXML & "<z:row " & Trim(strCadenaRow) & _
             " />" & Chr(13) & Chr(10)
         End If
         rstRecordset.MoveNext
      Loop
   End If
   StrCadenaXML = StrCadenaXML & _
    Chr(13) & Chr(10) & "</rs:data>" & Chr(13) & Chr(10) & "</xml>"
   PurgaActualitzacionsRecordset = StrCadenaXML
   Exit Function
TractaError:
   'Si hi ha hagut error, fixa les variables corresponents
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - PurgaActualitzacionsRecordset"
   PurgaActualitzacionsRecordset = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- FormatXML()
'----------------------------------------------------------------------------------------------
' Converteix una dada en tipus string, convertint els carcters especials de XML en les
' entitats corresponents.
'----------------------------------------------------------------------------------------------
Public Function FormatXML(objDades As Variant) As String
Dim strTemp As String
   
   Select Case TypeName(objDades)
      Case "String"
         strTemp = StrTran((objDades), "&", "&#x26;")
         strTemp = StrTran(strTemp, "<", "&#60;")
         strTemp = StrTran(strTemp, ">", "&#62;")
         strTemp = StrTran(strTemp, "'", "&#39;")
      
         FormatXML = StrTran(strTemp, """", "&#34;")
         
      Case "Boolean"
         strTemp = IIf(UCase(objDades) = "VERDADERO", "True", "False")
         FormatXML = strTemp
         
      Case "Date"
         strTemp = Format(objDades, "yyyy-mm-dd") & "T" & Format(objDades, "hh:mm:ss")
         FormatXML = strTemp
         
      Case Else
         FormatXML = CStr((objDades))
   End Select
   
End Function

'----------------------------------------------------------------------------------------------
'-- FormatFiltre()
'----------------------------------------------------------------------------------------------
' Converteix una dada en un string especialment formatejat per entrar en un filtre d'un recordset
'----------------------------------------------------------------------------------------------
Public Function FormatFiltre(objDades As Variant) As String
Dim strTemp As String

   Select Case TypeName(objDades)
      Case "Null"
         FormatFiltre = "Null"
         
      Case "String"
         FormatFiltre = "'" & CStr((objDades)) & "'"
         
      Case "Boolean"
         FormatFiltre = IIf(objDades = True, "True", "False")
         
      Case "Date"
         FormatFiltre = "#" & _
          Format(objDades, "mm/dd/yyyy") & "#"
         
      Case Else
         FormatFiltre = CStr((objDades))
   End Select
   
End Function
'**********************************************************************************************
'-- Funcions per enllaar i desenllaar els controls d'un formulari a un recordsource
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- LinkControls
'----------------------------------------------------------------------------------------------
' Enllaa els datasource dels controls de dades amb
' el recordset rstRecordset
'----------------------------------------------------------------------------------------------
Public Sub LinkControls(frmFormulari As Form)
   Dim ctrDades As Control
   Dim strRecordsetAEnllacar As String
   Dim rstRecordsetAEnllacar As ADODB.Recordset
   Dim frmFormulariRecordset As Form
   Dim lngPosPunt As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""

   'Recorre tots els controls i, si sn de text o combos, assigna la seva propietat DataSource
   For Each ctrDades In frmFormulari.Controls
      If TypeName(ctrDades) = "TextBox" Or TypeName(ctrDades) = "ComboBox" _
          Or TypeName(ctrDades) = "DataCombo" Or TypeName(ctrDades) = "CheckBox" Then
         If Trim(ctrDades.DataField) <> "" Then
         
            'Troba quin s el recordset a enllaar i els camps a enllacar
            
            Set frmFormulariRecordset = frmFormulari
            strRecordsetAEnllacar = ctrDades.Tag
            lngPosPunt = InStr(strRecordsetAEnllacar, ".")
            Do While lngPosPunt <> 0
               Set frmFormulariRecordset = CallByName(frmFormulariRecordset, _
                Mid$(strRecordsetAEnllacar, 1, lngPosPunt - 1), VbGet)
               strRecordsetAEnllacar = Mid$(strRecordsetAEnllacar, lngPosPunt + 1)
               lngPosPunt = InStr(strRecordsetAEnllacar, ".")
            Loop
            
            If strRecordsetAEnllacar = "" Then
               strRecordsetAEnllacar = "rstRecordsetActual"
            End If
         
            'Mira que existeixi el recordset a enllaar
            If Not ExisteixPropietat(frmFormulariRecordset, strRecordsetAEnllacar) Then
               Err.Raise ctIntErrorRecordsetNoEsPropietat
            End If
            
            Set rstRecordsetAEnllacar = CallByName(frmFormulariRecordset, strRecordsetAEnllacar, VbGet)
            
            'Fixa la mxima longitud dels quadres de text segons la mida del camp corresponent
            
            If TypeName(ctrDades) = "TextBox" Then
               ctrDades.MaxLength = rstRecordsetAEnllacar(ctrDades.DataField).DefinedSize
            End If
      
            'Enllaa els textbox i combos amb el seu datsource
            Set ctrDades.DataSource = rstRecordsetAEnllacar
            
            'Allibera la referncia al recordset
            Set rstRecordsetAEnllacar = Nothing
         End If
      End If
   Next ctrDades
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " -  LinkControls"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- DeslinkControls
'----------------------------------------------------------------------------------------------
' Desenllaa els datasource dels controls de dades
'----------------------------------------------------------------------------------------------
Public Sub DeslinkControls(frmFormulari As Form)
   Dim ctrDades As Control
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   
   'Recorre tots els controls i, si sn de text o combos, assigna la seva propietat DataSource
   For Each ctrDades In frmFormulari.Controls
      If TypeName(ctrDades) = "TextBox" Or TypeName(ctrDades) = "ComboBox" _
       Or TypeName(ctrDades) = "DataCombo" Or TypeName(ctrDades) = "CheckBox" Then
         If Trim(ctrDades.DataField) <> "" Then
            Set ctrDades.DataSource = Nothing
         End If
      End If
   Next ctrDades
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " -  DeslinkControls"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- ControlsAreLinked
'----------------------------------------------------------------------------------------------
' Diu si els controls estan enllaats o desenllaats
'----------------------------------------------------------------------------------------------
Public Function ControlsAreLinked(frmFormulari As Form) As Boolean
   Dim ctrDades As Control
   Dim lngNombreControls As Long
   Dim lngComptador As Long
   Dim bolControlLinked As Boolean
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
   'Recorre tots els controls i, si sn de text o combos, assigna la seva propietat DataSource
      
   lngComptador = 0
   lngNombreControls = frmFormulari.Controls.Count
   bolControlLinked = False
   
   Do While lngComptador <= lngNombreControls - 1 And (Not bolControlLinked)
      Set ctrDades = frmFormulari.Controls(lngComptador)
      If TypeName(ctrDades) = "TextBox" Or TypeName(ctrDades) = "ComboBox" _
       Or TypeName(ctrDades) = "DataCombo" Or TypeName(ctrDades) = "CheckBox" Then
         If Trim(ctrDades.DataField) <> "" And Not (ctrDades.DataSource Is Nothing) Then
            bolControlLinked = True
         End If
      End If
      lngComptador = lngComptador + 1
   Loop
   
   ControlsAreLinked = bolControlLinked
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " -  ControlsAreLinked"
   Exit Function
End Function



'----------------------------------------------------------------------------------------------
'-- PosaCampsANul
'----------------------------------------------------------------------------------------------
' Posa tots els camps del registre actual d'un recordset a nul
'----------------------------------------------------------------------------------------------
Public Sub PosaCampsANul(rstRecordset As ADODB.Recordset)
   Dim lngTotalCampsRs As Long
   Dim lngComptadorCampsRs As Long
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   lngTotalCampsRs = rstRecordset.Fields.Count
   'Recorre tots els controls i, si sn de text o combos, assigna la seva propietat DataSource
   For lngComptadorCampsRs = 0 To lngTotalCampsRs - 1
      rstRecordset.Fields(lngComptadorCampsRs) = Null
   Next lngComptadorCampsRs
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " -  PosaCampsANul"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- CancelaRecordsetEnllacat
'----------------------------------------------------------------------------------------------
' Cancella els canvis d'un recordset enllaat sense que doni errors
' en els camps que no sn de tipus carcter
'----------------------------------------------------------------------------------------------
Public Sub CancelaRecordsetEnllacat(rstRecordset As ADODB.Recordset)
   Dim lngComptador As Long
   Dim lngDarrerIndexCamp As Long
      
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   If (Not rstRecordset.EOF) And (Not rstRecordset.BOF) Then
      lngDarrerIndexCamp = rstRecordset.Fields.Count - 1
      For lngComptador = 0 To lngDarrerIndexCamp
         rstRecordset.Fields(lngComptador).Value = _
          rstRecordset.Fields(lngComptador).Value
      Next lngComptador
      rstRecordset.CancelUpdate
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " -  CancelaRecordsetEnllacat"
   Exit Sub
End Sub

'**********************************************************************************************
'-- Funcions per manipular dades d'un recordset
'**********************************************************************************************

'----------------------------------------------------------------------------------------------
'-- BuscaRecordset
'----------------------------------------------------------------------------------------------
' Busca un valor en el recordset que compleixi unes certes condicions
'----------------------------------------------------------------------------------------------
Public Function BuscaRecordset(rstRecordset As ADODB.Recordset, strCondicions As String) As _
 Boolean
   Dim objMarcador As Variant
   Dim bolTrobat As Boolean
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Es busca el registre mitjanant la propietat Filtre
   rstRecordset.Filter = strCondicions
   bolTrobat = (Not rstRecordset.EOF)
   
   If bolTrobat Then
      objMarcador = rstRecordset.Bookmark
   End If
   
   'Es recupera el filtre i el marcador
   rstRecordset.Filter = ""
   If bolTrobat Then
      rstRecordset.Bookmark = objMarcador
   End If
   BuscaRecordset = bolTrobat
   Exit Function
      
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - BuscaRecordset"
   BuscaRecordset = False
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- ValorCampRepetit
'----------------------------------------------------------------------------------------------
' Donat un recordsource i el nom d'un camp ens retorna un boole que indica si hi ha un altre
' registre que tingui el mateix valor en aquest camp que el registre actual
'----------------------------------------------------------------------------------------------
Public Function ValorCampRepetit(rstRecordset As ADODB.Recordset, strNomCamp As String) _
 As Boolean
   Dim objValorCamp As Variant
   Dim lngAparicions As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""

   'Obt el valor del camp que se li ha passat
   objValorCamp = rstRecordset.Fields(strNomCamp)

   'Compta el nombre de registres que tenen el matexi valor del camp
   lngAparicions = ComptaAparicionsValorEnRecordset(rstRecordset, strNomCamp, objValorCamp)
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If

   'Si est repetit, el nombre d'aparicions ser ms gran que u.
   ValorCampRepetit = (lngAparicions > 1)
   Exit Function
   
TractaError:
   'Si hi ha hagut error, fixa les variables corresponents
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - ValorCampRepetit"
   ValorCampRepetit = False
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- ComptaAparicionsValorEnRecordset
'----------------------------------------------------------------------------------------------
' Ens retorna el nombre de registres d'un recordset que tenen un determinat valor en un
' determinat camp
'----------------------------------------------------------------------------------------------
Public Function ComptaAparicionsValorEnRecordset(rstRecordset As ADODB.Recordset, strNomCamp _
 As String, objValorCamp As Variant) As Long
   Dim strFiltreCamp As String
   Dim strTipusCamp As String
   Dim lngAparicions As Long
   Dim objVarAuxiliar As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Obt el tipus del camp que se li ha passat
   objVarAuxiliar = objValorCamp 'Aix s per tal que no em doni valors com "Field"
   strTipusCamp = TypeName(objVarAuxiliar)
   
   'Construeix el filtre que indica els registres que tenen el mateix valor
   'del camp que l'actual
   Select Case strTipusCamp
      Case "Integer", "Long", "Single", "Double", "Currency", "Decimal", "Boolean"
         strFiltreCamp = strNomCamp & " = " & Str(objValorCamp)
      Case "String"
         strFiltreCamp = strNomCamp & " = " & "'" & objValorCamp & "'"
      Case "Date"
         strFiltreCamp = strNomCamp & " = " & "#" & CStr(objValorCamp) & "#"
   End Select
  
   'Compta les aparicions de registres amb el mateix camp
   
   lngAparicions = ComptaAparicionsEnRecordset(rstRecordset, strFiltreCamp)
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   'Si est repetit, el nombre d'aparicions ser ms gran que u.
   ComptaAparicionsValorEnRecordset = lngAparicions
   Exit Function
   
TractaError:
   'Si hi ha hagut error, fixa les variables corresponents
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - ComptaAparicionsValorEnRecordset"
   ComptaAparicionsValorEnRecordset = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- ComptaAparicionsEnRecordset
'----------------------------------------------------------------------------------------------
' Retorna el nombre de registres d'un recordset que compleixen una determinada condici
'----------------------------------------------------------------------------------------------
Public Function ComptaAparicionsEnRecordset(rstRecordset As ADODB.Recordset, strFiltre _
 As String) As Long
   Dim lngResultat As Long
   Dim strFiltreActual As String
   Dim strTipusCamp As String
   Dim objBookmark As Variant
   Dim bolEstanEnllacats As Boolean
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Obt el registre actual
   If rstRecordset.RecordCount > 0 Then
      objBookmark = rstRecordset.Bookmark
   Else
      objBookmark = Empty
   End If
  
   'Recull el valor del filtre actual
   strFiltreActual = IIf(rstRecordset.Filter = 0, "", rstRecordset.Filter)
   
   
   'Desenllaa els controls del formulari actiu perqu els canvis en el recordset
   'no li afectin
   bolEstanEnllacats = ControlsAreLinked(Screen.ActiveForm)
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If bolEstanEnllacats Then
      If TypeName(Screen.ActiveForm) <> "Nothing" Then
         DeslinkControls Screen.ActiveForm
      End If
   End If
   
   'Fixa com a filtre el que han passat de parmetre
   rstRecordset.Filter = strFiltre
   
   'Si est repetit, el nombre de registres amb aquest filtre ser ms gran que u.
   lngResultat = rstRecordset.RecordCount
   
   'Restaura el valor del filtre abans d'entrar a la funci
   rstRecordset.Filter = strFiltreActual
   
   If Not IsEmpty(objBookmark) Then
      rstRecordset.Bookmark = objBookmark
   End If
   
   'Torna a enllaar els controls
   If bolEstanEnllacats Then
      If TypeName(Screen.ActiveForm) <> "Nothing" Then
         LinkControls Screen.ActiveForm
      End If
   End If
   
   ComptaAparicionsEnRecordset = lngResultat
   Exit Function
   
TractaError:
   'Si hi ha hagut error, fixa les variables corresponents
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - ComptaAparicionsEnRecordset"
   ComptaAparicionsEnRecordset = 0
   Exit Function

End Function


'**********************************************************************************************
'-- Funcions per consulta d'arxius ini
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- ConsultaArxiuIniInterficie()
'----------------------------------------------------------------------------------------------
' Consulta el valor d'una clau de l'arxiu INI del mdul d'interfcie
' Retorna la cadena buida si s'ha produt algun error i el valor altrament
'----------------------------------------------------------------------------------------------

Public Function ConsultaArxiuIniInterficie(strSeccio As String, strClau As String) As String

   Dim strText As String
   
    'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Consulta l'arxiu INI amb la funci auxiliar ConsultaArxiuIni
   strText = ConsultaArxiuIni(RutaArxiuIni, strSeccio, strClau)
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   ConsultaArxiuIniInterficie = StrTran(strText, "{mod}", App.Path)
   Exit Function
   
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - ConsultaArxiuIniInterficie"
   ConsultaArxiuIniInterficie = ""
   Exit Function
End Function
'----------------------------------------------------------------------------------------------
'-- ConsultaArxiuIni()
'----------------------------------------------------------------------------------------------
' Consulta el valor d'una clau de l'arxiu INI.
' Retorna la cadena buida si s'ha produt algun error i el valor altrament
'----------------------------------------------------------------------------------------------
Private Function ConsultaArxiuIni(strRutaArxiuIni As String, strSeccio As String, _
   strClau As String) As String
   Dim strBufferCaracters As String * 256
   Dim intLlargada As Integer
   Dim strResultat As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Comprova que cap parmetre no sigui buit i que l'arxiu Ini existeixi
   If strRutaArxiuIni = "" Or strSeccio = "" Or strClau = "" Then
      Err.Raise ctintErrorParametresBuits
   End If
    
   If Dir(strRutaArxiuIni) = "" Then
      Err.Raise ctIntErrorUbicacioIni
   End If
    
   'Crida a la funci API que serveix per consultar els arxius INI
   strBufferCaracters = Space$(256)
   intLlargada = GetPrivateProfileString(strSeccio, strClau, "@#&", strBufferCaracters, _
    255, strRutaArxiuIni)
   strResultat = Left$(strBufferCaracters, intLlargada)
    
   'Si no es troba la clau, es genera un error
   If strResultat = "@#&" Then
      Err.Raise ctintErrorConsultaIni
   End If
    
   'Si no s'ha produt l'error es retorna el valor recuperat de la clau
   ConsultaArxiuIni = strResultat
   Exit Function
    
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - ConsultaArxiuIni"
   ConsultaArxiuIni = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- StrTran()
'----------------------------------------------------------------------------------------------
'Busca en una cadena de carcters les aparicions d'una segona cadena i, desprs, remplaa cada
'aparici amb una tercera cadena
'----------------------------------------------------------------------------------------------
Public Function StrTran(strStringbase As String, strStringARemplacar As String, _
 strStringRemplacable As String) As String
   Dim strTemp As String
   Dim lngPosicioString As Long
   Dim lngLlargadaStringARemplacar As Long
   Dim lngLlargadaStringRemplacable As Long
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   lngLlargadaStringARemplacar = Len(strStringARemplacar)
   lngLlargadaStringRemplacable = Len(strStringRemplacable)
   
   strTemp = strStringbase
   lngPosicioString = InStr(strTemp, strStringARemplacar)
   Do While lngPosicioString <> 0
      strTemp = Mid$(strTemp, 1, lngPosicioString - 1) + _
       strStringRemplacable + _
       Mid$(strTemp, lngPosicioString + lngLlargadaStringARemplacar)
      lngPosicioString = InStr(lngPosicioString + lngLlargadaStringRemplacable + 1, strTemp, strStringARemplacar)
   Loop
   StrTran = strTemp
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - StrTran"
   StrTran = ""
   Exit Function
End Function
'**********************************************************************************************
'-- Funcions que implementen l'emissi d'errors a l'usuari
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- EmetError ()
'----------------------------------------------------------------------------------------------
' Emet un missatge d'error a l'usuari
'----------------------------------------------------------------------------------------------
Public Sub EmetError(lngNumError As Long, strUbicacioError As String, lngIdioma As Long)
   MsgBox ("Error: " & TextError(lngNumError, lngIdioma) & Chr(13) & Chr(13) & " (" & _
    Mid$(strUbicacioError, 2) & ")")
End Sub

'----------------------------------------------------------------------------------------------
'-- TextError ()
'----------------------------------------------------------------------------------------------
' Tradueix un missatge d'error a un determinat idioma
'----------------------------------------------------------------------------------------------
Private Function TextError(lngNumError As Long, lngIdioma As Long) As String
   Dim objMIdioma As New GIMSuport.SvrIdiomes
   Dim StrCadenaXML As String
   Dim strResultat As String
   Dim rstRecordsetTemporal As ADODB.Recordset
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   StrCadenaXML = objMIdioma.GetTextIdiomaById("Error" + Trim(Str(lngNumError)), lngIdioma)
   Set rstRecordsetTemporal = PassaXMLARecordset(StrCadenaXML)
   rstRecordsetTemporal.MoveFirst
   strResultat = rstRecordsetTemporal!TextTraduit
   Set objMIdioma = Nothing
   TextError = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   TextError = Str(lngNumError)
   Exit Function
End Function

'**********************************************************************************************
'-- Funcions que implementen la traducci de textos d'un formulari
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- TradueixFormulariIdioma ()
'----------------------------------------------------------------------------------------------
' Tradueix tots els textos dels controls d'un formulari a un idioma determinat i reflecteix
' aquesta informaci sobre el formulari. A ms retorna un recordset amb informaci dels textos
' (tant dels controls com els dels missatges de validaci) del formulari traduts a aquest
' idioma.
'----------------------------------------------------------------------------------------------

Public Function TradueixFormulariIdioma(frmFormulari As Form, lngIdioma As Long) _
 As ADODB.Recordset
   Dim StrCadenaXML As String
   Dim rstRecordsetIdioma As ADODB.Recordset
   Dim objMIdioma As GIMSuport.SvrIdiomes
   Dim strCodiText As String
   
   'Refresca tots els textos del formulari a l'idioma indicat
   'Activa la rutina de tractament de errors
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Recupera tots els textos de l'idioma en el formulari en format XML
   Set objMIdioma = New GIMSuport.SvrIdiomes
   StrCadenaXML = objMIdioma.GetTextIdioma(lngIdioma, frmFormulari.Name)
   If objMIdioma.NumError <> ctintErrorOK Then
      UbicacioError = objMIdioma.UbicacioError
      Err.Raise objMIdioma.NumError
   End If
   
   'Passa el recordset a ADO
   Set rstRecordsetIdioma = PassaXMLARecordset(StrCadenaXML)
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
      
   'Posa els textos de l'idioma com a propietat Caption dels controls
   rstRecordsetIdioma.Filter = "EsControl = True"
   If rstRecordsetIdioma.RecordCount > 0 Then
      rstRecordsetIdioma.MoveFirst
      Do While Not rstRecordsetIdioma.EOF
         strCodiText = rstRecordsetIdioma!CodTextIdioma
        
         If strCodiText = "Formulari" Then
            frmFormulari.Caption = rstRecordsetIdioma!TextTraduit
         Else
            frmFormulari.Controls(strCodiText).Caption = rstRecordsetIdioma!TextTraduit
         End If
         rstRecordsetIdioma.MoveNext
      Loop
   End If
   rstRecordsetIdioma.Filter = ""
   
   'Alliberem recursos i retornem el recordset
   Set objMIdioma = Nothing
   Set TradueixFormulariIdioma = rstRecordsetIdioma
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - TradueixFormulariIdioma"
   Set TradueixFormulariIdioma = Nothing
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- TradueixDefecteMissatgeFormulariIdioma ()
'----------------------------------------------------------------------------------------------
' Tradueix un text d'un formulari a l'idioma determinat. Se li ha de passar un recordset
' amb els textos del formulari en aquest idioma. til per a missatges de validaci.
' Si no troba el text a traduir en el recordset, retorna la cadena Per defecte
'----------------------------------------------------------------------------------------------

Function TradueixDefecteMissatgeFormulariIdioma(rstRecordsetIdioma As ADODB.Recordset, _
 strCodiMissatge As String, strTraduccioPerDefecte As String) As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Crida a la funci TradueixMissatgeFormulariIdioma
   strResultat = TradueixMissatgeFormulariIdioma(rstRecordsetIdioma, strCodiMissatge)
   
   'Si dna l'error que no hi ha traducci retorna el missatge que ens han passat
   If NumError = ctIntErrorNoHiHaTraduccio Then
      NumError = ctintErrorOK
      strResultat = strTraduccioPerDefecte
   End If
   
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   TradueixDefecteMissatgeFormulariIdioma = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - TradueixDefecteMissatgeFormulariIdioma"
   TradueixDefecteMissatgeFormulariIdioma = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- TradueixMissatgeFormulariIdioma ()
'----------------------------------------------------------------------------------------------
' Tradueix un text d'un formulari a l'idioma determinat. Se li ha de passar un recordset
' amb els textos del formulari en aquest idioma. til per a missatges de validaci.
'----------------------------------------------------------------------------------------------

Function TradueixMissatgeFormulariIdioma(rstRecordsetIdioma As ADODB.Recordset, _
 strCodiMissatge As String) As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Si el codi s una cadena buida, retorna la cadena buida
   If Trim(strCodiMissatge) = "" Then
      strResultat = ""
   Else 'Altrament
      'Troba el registre que cont la traducci del text
      rstRecordsetIdioma.Filter = "CodTextIdioma = '" & strCodiMissatge & "'"
      
      If rstRecordsetIdioma.EOF Then
         Err.Raise ctIntErrorNoHiHaTraduccio
      End If
      strResultat = rstRecordsetIdioma!TextTraduit
         
      'Treu el filtre del Recordset d'idioma
      rstRecordsetIdioma.Filter = ""
   End If
   TradueixMissatgeFormulariIdioma = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - TradueixMissatgeFormulariIdioma"
   TradueixMissatgeFormulariIdioma = ""
   Exit Function
End Function

'**********************************************************************************************
'-- Funcions de taules auxiliars
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- ObrirFormulariAuxiliar ()
'----------------------------------------------------------------------------------------------
' Obre els formularis de taules auxiliars
'----------------------------------------------------------------------------------------------

Public Sub ObrirFormulariAuxiliar(ctrCombo As Variant, strNomTaula As String, _
   strCampIntegritat As String, strCampLlista As String, Optional strCadenaIntegritat As String = "", _
   Optional strNomCampFiltre As String = "", Optional lngValorCampFiltre As Long = 0, _
   Optional strCampOrdre As String = "", Optional strRecordsetActualitzar As String = "")
   
   Dim frmTaulesAuxiliars As GIM.frmTaulesAuxiliars
   Dim colIntegritat As Collection
   Dim lngPosPrimeraComa As Long
   Dim lngPosSegonaComa As Long
   Dim objIntegritat As GIM.clsINtegritatReferencial
   Dim bolExisteixRecordsetActual As Boolean
   Dim cmbComboBox As ComboBox
   Dim rstTemp As ADODB.Recordset
   
   'Activa la rutina de tractament de errors
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
  
   'Mira si el formulari que crida al de taules auxiliars
   bolExisteixRecordsetActual = ExisteixPropietat(Screen.ActiveForm, "rstRecordsetActual")
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
  
   'Es crea un formulari de taules auxiliars
   Set frmTaulesAuxiliars = New GIM.frmTaulesAuxiliars
      
   'Es passen els parmetres
   frmTaulesAuxiliars.strNomTaula = strNomTaula
   frmTaulesAuxiliars.strNomCampFiltre = strNomCampFiltre
   frmTaulesAuxiliars.lngValorCampFiltre = lngValorCampFiltre
   frmTaulesAuxiliars.strCampLlista = strCampLlista
   frmTaulesAuxiliars.strCampIntegritat = strCampIntegritat
   Set frmTaulesAuxiliars.frmFormulariQueCrida = Screen.ActiveForm
   Set frmTaulesAuxiliars.ctrCombo = ctrCombo
   
   If strCampOrdre = "" Then
      frmTaulesAuxiliars.strCampOrdre = strCampLlista
   Else
      frmTaulesAuxiliars.strCampOrdre = strCampOrdre
   End If
                           
   'Passem el parmetre del recordset que s'ha d'actualitzar
   frmTaulesAuxiliars.strRecordsetActualitzar = strRecordsetActualitzar
                           
   'Passem el parmetre de les regles d'integritat que cal comprovar
   strCadenaIntegritat = Trim(strCadenaIntegritat)
   Set frmTaulesAuxiliars.colIntegritatReferencial = New Collection
   
   If strCadenaIntegritat <> "" Then
      strCadenaIntegritat = strCadenaIntegritat + ","
      
      lngPosPrimeraComa = InStr(strCadenaIntegritat, ",")
      If lngPosPrimeraComa = 0 Then
         lngPosSegonaComa = 0
      Else
         lngPosSegonaComa = InStr(lngPosPrimeraComa + 1, strCadenaIntegritat, ",")
      End If
  
      Do While lngPosSegonaComa <> 0
         Set objIntegritat = New GIM.clsINtegritatReferencial
   
         objIntegritat.strNomTaulaFill = Trim(Mid$(strCadenaIntegritat, 1, lngPosPrimeraComa - 1))
         objIntegritat.strClauTaulaFill = Trim(Mid$(strCadenaIntegritat, lngPosPrimeraComa + 1, lngPosSegonaComa - lngPosPrimeraComa - 1))
         frmTaulesAuxiliars.colIntegritatReferencial.Add objIntegritat
         Set objIntegritat = Nothing
         strCadenaIntegritat = Mid$(strCadenaIntegritat, lngPosSegonaComa + 1)
         lngPosPrimeraComa = InStr(strCadenaIntegritat, ",")
         If lngPosPrimeraComa = 0 Then
            lngPosSegonaComa = 0
         Else
            lngPosSegonaComa = InStr(lngPosPrimeraComa + 1, strCadenaIntegritat, ",")
         End If
      Loop
      
   End If
   
   'Es mostra el formulari
   frmTaulesAuxiliars.Show vbModal
  
   'Desenllaa els controls perqu no hi hagi problemes
   If bolExisteixRecordsetActual Then
      DeslinkControls Screen.ActiveForm
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
   End If
        
   'Recupera el filtre del recordset
   frmTaulesAuxiliars.rstRecordsetActual.Filter = frmTaulesAuxiliars.strFiltreInicial
   
   Set frmTaulesAuxiliars.rstRecordsetActual = Nothing
  
   'Tanca el formulari de Taules Auxiliars
   Unload frmTaulesAuxiliars
   
   'Enllaa els controls de nou
   If bolExisteixRecordsetActual Then
      LinkControls Screen.ActiveForm
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
   End If
  
   Exit Sub
    
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - ObrirFormulariAuxiliar"
   Exit Sub
End Sub

'**********************************************************************************************
'-- Funcions de gesti d'arxius i imatges
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- ExisteixPropietat ()
'----------------------------------------------------------------------------------------------
' Diu si un objecte t una determinada propietat
'----------------------------------------------------------------------------------------------

Public Function ExisteixPropietat(objObjecte As Variant, strNomPropietat As String)
   Dim bolSenseImportancia As Boolean
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
     
   'Es crida a la propietat per veure si dna error
   bolSenseImportancia = IsNumeric(CallByName(objObjecte, strNomPropietat, VbGet))
   'IsNumeric aqu no t importncia. Noms serveix per unificar la sintaxi dels tipus
   'de dades que s'assignin amb Set i sense Set
   
   'Si no dna error, s que la propietat existeix
   ExisteixPropietat = True
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   'Si l'error s 438, s que la propietat no existeix
   If Err.Number = 438 Then
      Err.Number = 0
   Else
      NumError = Err.Number
      UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - ExisteixPropietat"
   End If
   ExisteixPropietat = False
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- EscullArxiu ()
'----------------------------------------------------------------------------------------------
' Escull un arxiu per llegir
'----------------------------------------------------------------------------------------------

Public Function EscullArxiu() As String
   'Obre un quadre de dileg dOn podem seleccionar un fitxer que es torna com a resultat de la funci
   Dim cdlDialegArxiu As Variant
   
   'Activa la rutina de tractament de errors
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   Set cdlDialegArxiu = CreateObject("MSComDlg.CommonDialog")

   cdlDialegArxiu.CancelError = True 'Per atrapar el bot Cancel.lar

   cdlDialegArxiu.ShowOpen
   EscullArxiu = cdlDialegArxiu.FileName
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - EscullArxiu"
   EscullArxiu = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- EscullArxiuGravar ()
'----------------------------------------------------------------------------------------------
' Escull un arxiu per gravar
'----------------------------------------------------------------------------------------------

Public Function EscullArxiuGravar(strDefaultExtension As String) As String
   Const cdlOFNHideReadOnly = &H4
   'Obre un quadre de dileg dOn podem seleccionar un fitxer que es torna com a resultat de la funci
   Dim cdlDialegArxiu As Variant
   
   'Activa la rutina de tractament de errors
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   Set cdlDialegArxiu = CreateObject("MSComDlg.CommonDialog")

   cdlDialegArxiu.CancelError = True 'Per atrapar el bot Cancel.lar
   
   cdlDialegArxiu.DefaultExt = strDefaultExtension
   cdlDialegArxiu.Flags = cdlOFNHideReadOnly
   cdlDialegArxiu.Filter = "*." & strDefaultExtension

   cdlDialegArxiu.ShowSave
   EscullArxiuGravar = cdlDialegArxiu.FileName
   
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - EscullArxiuGravar"
   EscullArxiuGravar = ""
   Exit Function
End Function

Public Function ObreVisorImatge(strRutaArxiuImatge As String) As Boolean
   Dim frmVisorImatge As New GIM.frmVisorImatge
   
   'Activa la rutina de tractament de errors
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   If Trim(strRutaArxiuImatge) = "" Or Dir(strRutaArxiuImatge) = "" Then
      ObreVisorImatge = False
   Else
      frmVisorImatge.strNomArxiuImatge = strRutaArxiuImatge
      frmVisorImatge.Show vbModal
      If frmVisorImatge.NumError <> ctintErrorOK Then
         UbicacioError = frmVisorImatge.NumError
         Err.Raise frmVisorImatge.NumError
      End If
      ObreVisorImatge = True
   End If
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - ObreVisorImatge"
   ObreVisorImatge = True
   Exit Function
End Function

'**********************************************************************************************
'-- Funcions per gestionar transaccions
'**********************************************************************************************

'----------------------------------------------------------------------------------------------
'-- BeginTransaction()
'----------------------------------------------------------------------------------------------
' Augmenta un nivell de transacci
'----------------------------------------------------------------------------------------------
Public Sub BeginTransaction(objClasseSuport As Variant)
   Dim cntSeccio As ADODB.Connection
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crida al mtode BeginTransaction de la classe SvrTransaccions
   Sistema.SySSessio.BeginTransaction
   
   'Es revisa si hi ha hagut un error
   If Sistema.SySSessio.NumError <> ctintErrorOK Then
      UbicacioError = Sistema.SySSessio.UbicacioError
      Err.Raise Sistema.SySSessio.NumError
   End If

   'Refresca l'identificador de transacci de l'objecte de suport
   Set objClasseSuport.IdTransaccio = Sistema.SySSessio.IdTransaccio
      
   Exit Sub
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - BeginTransaction"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- CommitTransaction()
'----------------------------------------------------------------------------------------------
' Augmenta un nivell de transacci
'----------------------------------------------------------------------------------------------
Public Sub CommitTransaction(objClasseSuport As Variant)
   Dim cntSeccio As ADODB.Connection
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crida al mtode CommitTransaction de la classe SvrTransaccions
   Sistema.SySSessio.CommitTransaction
   
   'Es revisa si hi ha hagut un error
   If Sistema.SySSessio.NumError <> ctintErrorOK Then
      UbicacioError = Sistema.SySSessio.UbicacioError
      Err.Raise Sistema.SySSessio.NumError
   End If
   
   'Refresca l'identificador de transacci de l'objecte de suport
   Set objClasseSuport.IdTransaccio = Sistema.SySSessio.IdTransaccio
      
   Exit Sub
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - CommitTransaction"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- RollBackTransaction()
'----------------------------------------------------------------------------------------------
' Augmenta un nivell de transacci
'----------------------------------------------------------------------------------------------
Public Sub RollBackTransaction(objClasseSuport As Variant)
   Dim cntSeccio As ADODB.Connection
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es crida al mtode RollBackTransaction de la classe SvrTransaccions
   Sistema.SySSessio.RollBackTransaction
   
   'Es revisa si hi ha hagut un error
   If Sistema.SySSessio.NumError <> ctintErrorOK Then
      UbicacioError = Sistema.SySSessio.UbicacioError
      Err.Raise Sistema.SySSessio.NumError
   End If

   'Refresca l'identificador de transacci de l'objecte de suport
   Set objClasseSuport.IdTransaccio = Sistema.SySSessio.IdTransaccio
      
   Exit Sub
TractaError:
   'Si hi ha hagut error, retorna False
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - RollBackTransaction"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- CreaObjecteSuport()
'----------------------------------------------------------------------------------------------
' Crea un objecte d'una classe continguda a GIMSuport.dll
'----------------------------------------------------------------------------------------------
 
Public Function CreaObjecteSuport(strNomClasse As String) As Object
   Dim objResultat As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
  
   Set objResultat = CreateObject("GIMSuport." & strNomClasse)
   
   Set objResultat.IdTransaccio = Sistema.SySSessio.IdTransaccio
   'Es revisa si hi ha hagut un error
   If Sistema.SySSessio.NumError <> ctintErrorOK Then
      UbicacioError = Sistema.SySSessio.UbicacioError
      Err.Raise Sistema.SySSessio.NumError
   End If
   
   Set CreaObjecteSuport = objResultat
   
   Exit Function
TractaError:
   'Si hi ha hagut error, retorna la cadena buida i posa valor a les variables d'error
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
      " - CreaObjecteSuport"
   Set CreaObjecteSuport = Nothing
   Exit Function
End Function

'**********************************************************************************************
'-- Funcions per omplir quadres combinats
'**********************************************************************************************

'----------------------------------------------------------------------------------------------
'-- OmpleComboBox()
'----------------------------------------------------------------------------------------------
' Omple un combobox amb el contingut d'un recordset
'----------------------------------------------------------------------------------------------
Public Sub OmpleComboBox(cmbCombo As ComboBox, rstRecordset As ADODB.Recordset, _
 strCampDades As String, strCampLlista As String, Optional strFiltre As String = "")
   Dim lngElementSeleccionat As Long
   Dim strFiltreActual As String
   Dim objMarcador As Variant
   Dim bolGuardaMarcador As Boolean
   Dim strTextSeleccionat As String
      
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   strTextSeleccionat = cmbCombo.Text
   If Trim(strTextSeleccionat) = "" Then
      strTextSeleccionat = ""
   End If
   
   bolGuardaMarcador = rstRecordset.RecordCount > 0 And (Not rstRecordset.EOF) _
    And (Not rstRecordset.BOF)
   'Guarda la posici actual del recordset
   If bolGuardaMarcador Then
      objMarcador = rstRecordset.Bookmark
   End If
   
   'Si s'ha passat un filtre, l'aplica al recordset
   If Trim(strFiltre) <> "" Then
      strFiltreActual = IIf(rstRecordset.Filter = "0", "", rstRecordset.Filter)
      rstRecordset.Filter = strFiltre
   End If
   
   'Recorre els recordets de zones i posa tots els elements a la llista
   cmbCombo.Clear
   If rstRecordset.RecordCount > 0 Then
      rstRecordset.MoveFirst
      Do While Not rstRecordset.EOF
         cmbCombo.AddItem rstRecordset.Fields(strCampLlista)
         cmbCombo.ItemData(cmbCombo.NewIndex) = rstRecordset.Fields(strCampDades)
         rstRecordset.MoveNext
      Loop
      
      'Selecciona l'element seleccionat si es pot.
      'Altrament selecciona el primer element de la llista.
      
      If cmbCombo.ListCount > 0 Then
         
         If strTextSeleccionat = "" Then
            lngElementSeleccionat = -1
         Else
            lngElementSeleccionat = BuscaComboBox(cmbCombo, strTextSeleccionat)
      
            If NumError <> ctintErrorOK Then
               Err.Raise NumError
            End If
         End If

         If lngElementSeleccionat = -1 Then
            cmbCombo.ListIndex = 0
         Else
            cmbCombo.ListIndex = lngElementSeleccionat
         End If
      End If
   End If
   
   'Es recupera el filtre del recordset
   If Trim(strFiltre) <> "" Then
      rstRecordset.Filter = strFiltreActual
   End If
   
   'Es recupera la posici del recordset abans d'entrar a la funci
   If bolGuardaMarcador Then
      rstRecordset.Bookmark = objMarcador
   End If
   
   Exit Sub
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - OmpleComboBox"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- OmpleDatacombo
'----------------------------------------------------------------------------------------------
' Emplena la llista de un datacombo amb els valors d'un recordset
'----------------------------------------------------------------------------------------------
Public Sub OmpleDatacombo(ctrCombo As DataCombo, rstRecordset As ADODB.Recordset)
   Dim rstDataSource As ADODB.Recordset
   Dim rstRowSource As ADODB.Recordset
   Dim bolManteRegistre As Boolean
   Dim bolTrobat As Boolean
   Dim strFiltreActual As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Troba una referncia al DataSource del control
   Set rstDataSource = ctrCombo.DataSource
   
   bolManteRegistre = (Not rstRecordset.BOF) And (Not rstRecordset.EOF)
   If bolManteRegistre Then
      strFiltreActual = FiltreRegistreActual(rstRecordset)
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
   End If
      
   'Fa una copia del recordset noms amb els registres que compleixen el filtre
   Set rstRowSource = CopiaRecordset(rstRecordset)
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   'Omple el datacombo amb aquests registres
   Set ctrCombo.RowSource = rstRowSource
   ctrCombo.Refresh
   
   'Selecciona el primer registre
   If Not (rstDataSource Is Nothing) Then
      If (Not rstDataSource.EOF) And (Not rstDataSource.BOF) Then
         If Not (rstRowSource Is Nothing) Then
            If rstRowSource.RecordCount > 0 Then
               bolTrobat = BuscaRecordset(rstRowSource, strFiltreActual)
               If NumError <> ctintErrorOK Then
                  Err.Raise NumError
               End If
               If Not bolTrobat Then
                  rstRowSource.MoveFirst
               End If
               rstDataSource.Fields(ctrCombo.DataField) = rstRowSource.Fields(ctrCombo.BoundColumn)
            Else
               rstDataSource.Fields(ctrCombo.DataField) = Null
            End If
         Else
            rstDataSource.Fields(ctrCombo.DataField) = Null
         End If
      End If
   End If
      
   'Allibera les referncies als recordsets
   Set rstRowSource = Nothing
   Set rstDataSource = Nothing
 
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - OmpleDatacombo"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- FixaComboBox
'----------------------------------------------------------------------------------------------
' Fixa el valor del combobox en el cas que s'hagi escrit en el quadre
'en comptes de seleccionar un valor de la llista
'----------------------------------------------------------------------------------------------
Public Sub FixaComboBox(cmbComboBox As ComboBox)
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   If cmbComboBox.ListIndex = -1 And Trim(cmbComboBox.Text) <> "" Then
      cmbComboBox.ListIndex = BuscaComboBox(cmbComboBox, Trim(cmbComboBox.Text))
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - FixaComboBox"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- BuscaComboBox
'----------------------------------------------------------------------------------------------
' Busca un determinat valor en el combobox
'----------------------------------------------------------------------------------------------
Public Function BuscaComboBox(cmbBox As ComboBox, strValor As String) As Long
   Dim lngComptador As Long
   Dim lngIndexFinal As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   lngIndexFinal = cmbBox.ListCount - 1
   lngComptador = 0
   
   Do While lngComptador <= lngIndexFinal And _
    Trim(LCase(cmbBox.List(lngComptador))) <> Trim(LCase(strValor))
      lngComptador = lngComptador + 1
   Loop
   
   If lngComptador > lngIndexFinal Then
      BuscaComboBox = -1
   Else
      BuscaComboBox = lngComptador
   End If
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - BuscaComboBox"
   BuscaComboBox = -1
   Exit Function
End Function

'**********************************************************************************************
'-- Funcions per trobar els valors d'un camp del recordset ordenats i sense repetir
'-- Funcions d'array
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- TrobaStringsCampRecordset
'----------------------------------------------------------------------------------------------
' Retorna un array que cont els valors d'un camp de tipus string d'un recordset
' Els valors es treuen ordenats i no repetits. Si el recordset s buit, retorna un Null
' El lngModeMajuscules indica la forma en qu es retornen els strings quant a les majscules.
' Si s 0 es retornen com es troben a la taula. Si s 1 en majscules. Si s 2 en minscules.
' Si s 3 es retornen amb la primera lletra de cada mot en majscula i la resta en minscules.
'----------------------------------------------------------------------------------------------
Public Function TrobaStringsCampRecordset(rstRecordset As ADODB.Recordset, strNomCamp As String, Optional lngModeMajuscules As Long = 0) As Variant
   Dim objArrayAmbRepetits As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   objArrayAmbRepetits = ObteArrayAmbCampRecordset(rstRecordset, strNomCamp, lngModeMajuscules)
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
      
   If Not IsNull(objArrayAmbRepetits) Then
     
      QuickSortNoCaseSensitive objArrayAmbRepetits, LBound(objArrayAmbRepetits), UBound(objArrayAmbRepetits)
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
      
      EliminaRepetitsArrayOrdenat objArrayAmbRepetits
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
      
   End If
   
   TrobaStringsCampRecordset = objArrayAmbRepetits
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - TrobaStringsCampRecordset"
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- ObteArrayAmbCampRecordset
'----------------------------------------------------------------------------------------------
' Retorna un array que cont els valors d'un camp de tipus string d'un recordset
' Al contrariq ue la funci anterior, els valors poden trobar-se repetits i desordenats.
' El lngModeMajuscules t el mateix significat que la funci anterior
'----------------------------------------------------------------------------------------------
Public Function ObteArrayAmbCampRecordset(rstRecordset As ADODB.Recordset, strNomCamp As String, Optional lngModeMajuscules As Long = 0) As Variant
   Dim objArray As Variant
   Dim objArrayResultat As Variant
   Dim lngPrimerElement As Long
   Dim lngDarrerElement As Long
   Dim lngNumeroElement As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Obt els valors del camp amb nom strNomCamp en un array
   
   If (Not rstRecordset.BOF) Or (Not rstRecordset.EOF) Then 'rstRecordset.EOF And rstRecordset.BOF) Then 'Si el recordset no s buit
      objArray = rstRecordset.GetRows(-1, adBookmarkFirst, strNomCamp)
      
      lngPrimerElement = LBound(objArray, 2)
      lngDarrerElement = UBound(objArray, 2)
      
      ReDim objArrayResultat(lngPrimerElement To lngDarrerElement)
      For lngNumeroElement = lngPrimerElement To lngDarrerElement
         Select Case lngModeMajuscules
            Case 0
               objArrayResultat(lngNumeroElement) = objArray(0, lngNumeroElement)
            Case 1
               objArrayResultat(lngNumeroElement) = UCase$(objArray(0, lngNumeroElement))
            Case 2
               objArrayResultat(lngNumeroElement) = LCase$(objArray(0, lngNumeroElement))
            Case 3
               objArrayResultat(lngNumeroElement) = StrConv(objArray(0, lngNumeroElement), vbProperCase)
         End Select
      Next lngNumeroElement
   
      ObteArrayAmbCampRecordset = objArrayResultat
   Else
      ObteArrayAmbCampRecordset = Null
   End If
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - ObteArrayAmbCampRecordset"
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- QuickSortNoCaseSensitive
'----------------------------------------------------------------------------------------------
' Ordena un array de strings sense tenir en compte les majscules i les minscules
' Utilitza l'algorisme quicksort.
'----------------------------------------------------------------------------------------------
Public Sub QuickSortNoCaseSensitive(objArrayAOrdenar As Variant, lngPrimerElement As Long, lngDarrerElement As Long)
  
   Dim strPivot As String
   Dim strSwap As String
   Dim lngBaix As Long
   Dim lngAlt As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   lngBaix = lngPrimerElement
   lngAlt = lngDarrerElement
   
   strPivot = LCase$(objArrayAOrdenar((lngPrimerElement + lngDarrerElement) / 2))
  
   Do While (lngBaix <= lngAlt)
   
      Do While (LCase$(objArrayAOrdenar(lngBaix)) < strPivot And lngBaix < lngDarrerElement)
         lngBaix = lngBaix + 1
      Loop
      
      
      Do While (strPivot < LCase$(objArrayAOrdenar(lngAlt)) And lngAlt > lngPrimerElement)
         lngAlt = lngAlt - 1
      Loop
      
      If (lngBaix <= lngAlt) Then
         strSwap = objArrayAOrdenar(lngBaix)
         objArrayAOrdenar(lngBaix) = objArrayAOrdenar(lngAlt)
         objArrayAOrdenar(lngAlt) = strSwap
         lngBaix = lngBaix + 1
         lngAlt = lngAlt - 1
      End If
   
   Loop
     
   If (lngPrimerElement < lngAlt) Then
      QuickSortNoCaseSensitive objArrayAOrdenar, lngPrimerElement, lngAlt
   End If
   If (lngBaix < lngDarrerElement) Then
      QuickSortNoCaseSensitive objArrayAOrdenar, lngBaix, lngDarrerElement
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - QuickSortNoCaseSensitive"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- EliminaRepetitsArrayOrdenat
'----------------------------------------------------------------------------------------------
' Elimina valors repetits d'una array ordenat
'----------------------------------------------------------------------------------------------
Public Sub EliminaRepetitsArrayOrdenat(objArray As Variant)
   Dim lngElementALlegir As Long
   Dim lngElementAEscriure As Long
   Dim lngDarrerElement As Long
   Dim lngPrimerElement As Long
   Dim objElementTractat As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   lngPrimerElement = LBound(objArray)
   lngDarrerElement = UBound(objArray)
   
   lngElementALlegir = lngPrimerElement
   lngElementAEscriure = lngPrimerElement
   
   If lngPrimerElement < lngDarrerElement Then
      objElementTractat = objArray(lngElementALlegir)
      lngElementALlegir = lngElementALlegir + 1
      lngElementAEscriure = lngElementAEscriure + 1
      Do While lngElementALlegir <= lngDarrerElement
         If LCase(objElementTractat) <> LCase(objArray(lngElementALlegir)) Then
            objArray(lngElementAEscriure) = objArray(lngElementALlegir)
            objElementTractat = objArray(lngElementALlegir)
            lngElementAEscriure = lngElementAEscriure + 1
         End If
         lngElementALlegir = lngElementALlegir + 1
      Loop
      lngElementAEscriure = lngElementAEscriure - 1
      ReDim Preserve objArray(lngPrimerElement To lngElementAEscriure)
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - EliminaRepetitsArrayOrdenat"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- OmpleComboBoxAmbArray
'----------------------------------------------------------------------------------------------
' Emplena la llista desplegable d'un combobox amb els valors d'un array
'----------------------------------------------------------------------------------------------
Public Sub OmpleComboBoxAmbArray(cmbBox As ComboBox, objArray As Variant)
   Dim lngComptador As Long
   Dim lngPrimerElement As Long
   Dim lngDarrerElement As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   lngPrimerElement = LBound(objArray)
   lngDarrerElement = UBound(objArray)
   
   cmbBox.Clear
   For lngComptador = lngPrimerElement To lngDarrerElement
      cmbBox.AddItem objArray(lngComptador)
   Next lngComptador
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & ctStrNomClasse & _
    " - OmpleComboBoxAmbArray"
   Exit Sub
End Sub

'**********************************************************************************************
'-- Funcions per ajudar a la depuraci: seran eliminades un cop acabat el projecte
'**********************************************************************************************
Public Function SimpliXML(st As String) As String
   Dim comencarow As Long
   Dim acabarow As Long
   Dim stinici As String
   Dim stfinal As String
    
   
   stfinal = Mid$(st, InStr(st, "<rs:data"))
   comencarow = InStr(stfinal, "<z:row")
   Do While comencarow <> 0
      acabarow = InStr(comencarow, stfinal, ">")
      stinici = stinici + Mid$(stfinal, 1, comencarow + 60)
      stfinal = Mid$(stfinal, acabarow + 1)
      comencarow = InStr(stfinal, "<z:row")
   Loop
   stinici = stinici + stfinal
   SimpliXML = stinici
End Function
Public Function LlistaCodisAscii(st As String) As String
   Dim strTemp As String
   Dim intComptador As Long
   strTemp = ""
   For intComptador = 1 To Len(st)
      strTemp = strTemp & Str(Asc(Mid$(st, intComptador, 1))) & Mid$(st, intComptador, 1) & ","
   Next intComptador
   LlistaCodisAscii = Mid$(strTemp, 1, Len(strTemp) - 1)
End Function

Public Function AbocaArray(objArray As Variant) As String
   Dim lngComptador As Long
   Dim strCadena As String
   
   For lngComptador = LBound(objArray) To UBound(objArray)
      strCadena = strCadena & objArray(lngComptador) & Chr(13)
   Next lngComptador
   AbocaArray = strCadena
End Function

