VERSION 5.00
Begin VB.Form frmEntraPassword 
   Caption         =   "frmEntraPassword"
   ClientHeight    =   2985
   ClientLeft      =   4185
   ClientTop       =   4185
   ClientWidth     =   5550
   LinkTopic       =   "Form1"
   ScaleHeight     =   2985
   ScaleWidth      =   5550
   StartUpPosition =   1  'CenterOwner
   Begin VB.CommandButton cmdAcceptar 
      Caption         =   "cmdAcceptar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2160
      TabIndex        =   5
      Top             =   2280
      Width           =   1335
   End
   Begin VB.CommandButton cmdCancellar 
      Caption         =   "cmdCancellar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   3600
      TabIndex        =   4
      Top             =   2280
      Width           =   1335
   End
   Begin VB.TextBox txtPassword 
      DataField       =   "NomClient"
      Height          =   375
      IMEMode         =   3  'DISABLE
      Left            =   480
      PasswordChar    =   "*"
      TabIndex        =   0
      Top             =   720
      Width           =   4455
   End
   Begin VB.TextBox txtConfirmaPassword 
      DataField       =   "Adreca"
      Height          =   375
      IMEMode         =   3  'DISABLE
      Left            =   480
      PasswordChar    =   "*"
      TabIndex        =   1
      Top             =   1560
      Width           =   4455
   End
   Begin VB.Label lblEntraPassword 
      Caption         =   "lblEntraPassword"
      Height          =   255
      Left            =   480
      TabIndex        =   3
      Top             =   480
      Width           =   4455
   End
   Begin VB.Label lblReentraPassword 
      Caption         =   "lblReentraPassword"
      Height          =   255
      Left            =   480
      TabIndex        =   2
      Top             =   1320
      Width           =   4455
   End
End
Attribute VB_Name = "frmEntraPassword"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

Public frmFormulariQueCrida As GIM.frmUsuaris 'Mant una referncia al formulari que la crida

'Serveix per accedir a les propietats i mtodes de la classe clsFuncionsCapaInterficie
Private objFuncionsComuns As clsFuncionsCapaInterficie

Public rstRecordsetIdioma As ADODB.Recordset 'Recordset amb les textos tradus del formulari


'**********************************************************************************************
'-- Events del formulari i dels controls
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Form_Load
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Load()
   IniciFormulari
End Sub

'----------------------------------------------------------------------------------------------
'-- cmdAcceptar_Click
'----------------------------------------------------------------------------------------------
' S'executa quan es prem el bot "Acceptar"
'----------------------------------------------------------------------------------------------
Private Sub cmdAcceptar_Click()
   SurtGuardantContrasenya
End Sub

'----------------------------------------------------------------------------------------------
'-- cmdCancellar_Click
'----------------------------------------------------------------------------------------------
' S'executa quan es prem el bot "Cancellar"
'----------------------------------------------------------------------------------------------
Private Sub cmdCancellar_Click()
   SurtSenseGuardarContrasenya
End Sub

'**********************************************************************************************
'-- Funcions de nivell superior
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- IniciFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques d'inicialitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub IniciFormulari()
   Dim lngComptador As Long
  
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
 
   'Crea una instncia de la classe objFuncionsComuns
   'per utilitzar-ne els mtodes i propietats
   Set objFuncionsComuns = New clsFuncionsCapaInterficie
      
  'Recupera els textos del formulari traduts a l'idioma per defecte
  
   Set rstRecordsetIdioma = objFuncionsComuns.TradueixFormulariIdioma(Me, Sistema.Idioma)
   
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
      
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - IniciFormulari"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- SurtGuardantContrasenya()
'----------------------------------------------------------------------------------------------
' Surt guardant la contrasenya en el quadre de text "txtPassword" del formulari que ha cridat
' el present formulari
'----------------------------------------------------------------------------------------------

Private Sub SurtGuardantContrasenya()
   Dim strCadenaValidacio As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
           
   'Mira si la contrasenya s correcta
   strCadenaValidacio = CadenaValidacioAcceptar()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   'Si no ho s, emet un missatge d'error
   If strCadenaValidacio <> "" Then
       MsgBox (strCadenaValidacio)
   Else
      'Si ho s, omple el textbox del formulari que ha cridat al formulari actual
      frmFormulariQueCrida.txtPassword.Text = Me.txtPassword.Text
      Unload Me
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - SurtGuardantContrasenya"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- SurtSenseGuardarContrasenya()
'----------------------------------------------------------------------------------------------
' Surt sense guardar la contrasenya, aix que tot el que s'ha fet al formulari queda sense
' efecte
'----------------------------------------------------------------------------------------------
Private Sub SurtSenseGuardarContrasenya()
   Unload Me
End Sub

'**********************************************************************************************
'-- Funcions que no sn de nivell superior
'**********************************************************************************************

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioAcceptar()
'----------------------------------------------------------------------------------------------
' Si les contrasenyes del formulari sn correctes, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioAcceptar()

   Dim strCodiMissatge As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
       
   If Trim(Me.txtPassword.Text) = "" Or Trim(Me.txtConfirmaPassword.Text) = "" Then
      strCodiMissatge = "valAlgunaContrasenyaBuida"
   Else
      If Len(Trim(Me.txtPassword.Text)) < 8 Then
         strCodiMissatge = "valContrasenyaCurta"
      Else
         If Not CadenaTeNumericsiCaracters(Trim(Me.txtPassword.Text)) Then
            strCodiMissatge = "valContrasenyaSenseNombresOCaracters"
         Else
            If Trim(Me.txtPassword.Text) <> Trim(Me.txtConfirmaPassword.Text) Then
               strCodiMissatge = "valContrasenyesDiferents"
            Else
               strCodiMissatge = ""
            End If
         End If
      End If
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioAcceptar = strResultat
   Exit Function
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioAcceptar"
   CadenaValidacioAcceptar = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- CadenaTeNumericsiCaracters()
'----------------------------------------------------------------------------------------------
' Donada una cadena, retorna un boole que indica si la cadena t carcters numrics
' i carcters alhora
'----------------------------------------------------------------------------------------------

Private Function CadenaTeNumericsiCaracters(strCadena As String) As Boolean

   Dim bolHiHaNumerics As Boolean
   Dim bolHiHaCaracters As Boolean
   Dim intCodiAscii As Integer
   Dim lngComptador As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
       
   bolHiHaNumerics = False
   bolHiHaCaracters = False
       
   For lngComptador = 1 To Len(strCadena)
      intCodiAscii = Asc(Mid$(strCadena, lngComptador, lngComptador))
      If intCodiAscii >= Asc("0") And intCodiAscii <= Asc("9") Then
         bolHiHaNumerics = True
      End If
      If (intCodiAscii >= Asc("A") And intCodiAscii <= Asc("Z")) Or _
       (intCodiAscii >= Asc("a") And intCodiAscii <= Asc("z")) Then
         bolHiHaCaracters = True
      End If
   Next lngComptador
   
   CadenaTeNumericsiCaracters = bolHiHaNumerics And bolHiHaCaracters
   
   Exit Function
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " -  CadenaTeNumericsiCaracters"
    CadenaTeNumericsiCaracters = False
   Exit Function
End Function


