VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form frmExportEsquema 
   Caption         =   "frmExportEsquema"
   ClientHeight    =   5490
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8595
   LinkTopic       =   "Form1"
   ScaleHeight     =   5490
   ScaleWidth      =   8595
   StartUpPosition =   3  'Windows Default
   Visible         =   0   'False
   Begin VB.PictureBox pctDeviceContext 
      Height          =   615
      Left            =   240
      ScaleHeight     =   555
      ScaleWidth      =   1395
      TabIndex        =   0
      Top             =   360
      Width           =   1455
   End
   Begin MSComctlLib.TreeView trvExportar 
      Height          =   3255
      Left            =   240
      TabIndex        =   1
      Top             =   1200
      Visible         =   0   'False
      Width           =   6495
      _ExtentX        =   11456
      _ExtentY        =   5741
      _Version        =   393217
      Style           =   7
      Appearance      =   1
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
End
Attribute VB_Name = "frmExportEsquema"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

Public EsquemaOriginal As TreeView
Public strRutaArxiu As String

Private Const WM_PRINT = &H317
Private Const PRF_CLIENT = &H4&
Private Const PRF_CHILDREN = &H10&
Private Const PRF_OWNED = &H20&

Private Declare Function SendMessage Lib "USER32" Alias _
   "SendMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, _
   ByVal wParam As Long, ByVal lParam As Long) As Long

'----------------------------------------------------------------------------------------------
'-- GravarEsquema
'----------------------------------------------------------------------------------------------
' Grava l'esquema la referncia del qual es troba en l'esquema original
' i el posa en un arxiu BMP
'----------------------------------------------------------------------------------------------
Public Sub GravarEsquema()
   Dim lngTemporal As Long
   Dim lngNombreNodes As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Recupera el control TreeView
   CopiaTreeview
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   ' Augmenta la mida del control TreeView perqu es vegin tots els nodes
   trvExportar.Height = 0
   lngNombreNodes = Me.trvExportar.Nodes.Count
   Do While trvExportar.GetVisibleCount < lngNombreNodes
      trvExportar.Height = trvExportar.Height + trvExportar.Font.Size
   Loop
      
   'Fa que el picturebox tingui les mateixes dimensions que el TreeView
   pctDeviceContext.Top = trvExportar.Top
   pctDeviceContext.Left = trvExportar.Left
   pctDeviceContext.Width = trvExportar.Width
   pctDeviceContext.Height = trvExportar.Height
   
   'Captura el contingut del TreeView en pctDeviceContext
   DoEvents
   pctDeviceContext.AutoRedraw = True
   lngTemporal = SendMessage(trvExportar.hWnd, WM_PRINT, pctDeviceContext.hDC, PRF_CHILDREN + PRF_CLIENT + PRF_OWNED)
   pctDeviceContext.Picture = pctDeviceContext.Image
   pctDeviceContext.AutoRedraw = False

   'Grava el dibuix capturat en un arxiu d'imatge
   SavePicture pctDeviceContext.Picture, Me.strRutaArxiu
   Exit Sub
   
TractaError:
  'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - GravarEsquema"
   Exit Sub
End Sub
   
'----------------------------------------------------------------------------------------------
'-- CopiaTreeview
'----------------------------------------------------------------------------------------------
' Copia l'esquema la referncia del qual es troba en l'esquema original
' en el treeview d'aquest formulari
'----------------------------------------------------------------------------------------------
Public Sub CopiaTreeview()
   Dim NodeOriginal As Node
   Dim NodeCopia As Node
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Copia tots els nodes del Treeview original al que t aquest formulari
   For Each NodeOriginal In Me.EsquemaOriginal.Nodes
      If NodeOriginal.Root = NodeOriginal Then
         Set NodeCopia = trvExportar.Nodes.Add(, , NodeOriginal.Key, NodeOriginal.Text)
         NodeCopia.Expanded = True
      Else
         Set NodeCopia = trvExportar.Nodes.Add(NodeOriginal.Parent.Key, tvwChild, NodeOriginal.Key, NodeOriginal.Text)
         NodeCopia.Expanded = True
      End If
   Next NodeOriginal
   NodeCopia.EnsureVisible
   trvExportar.Style = tvwTreelinesText ' Estilo 4.
   trvExportar.BorderStyle = vbFixedSingle
  
   Exit Sub
TractaError:
  'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CopiaTreeview"
   Exit Sub
End Sub

