VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form frmIdiomes 
   Caption         =   "frmIdiomes"
   ClientHeight    =   3750
   ClientLeft      =   3285
   ClientTop       =   2580
   ClientWidth     =   6480
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   3750
   ScaleWidth      =   6480
   Begin VB.CommandButton cmdCancellar 
      Caption         =   "cmdCancellar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5040
      TabIndex        =   2
      Top             =   3120
      Width           =   1335
   End
   Begin VB.CommandButton cmdAcceptar 
      Caption         =   "cmdAcceptar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   3600
      TabIndex        =   1
      Top             =   3120
      Width           =   1335
   End
   Begin MSComctlLib.ListView lstIdiomes 
      Height          =   1815
      Left            =   135
      TabIndex        =   0
      Top             =   1200
      Width           =   6015
      _ExtentX        =   10610
      _ExtentY        =   3201
      Arrange         =   2
      LabelWrap       =   -1  'True
      HideSelection   =   0   'False
      _Version        =   393217
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   0
   End
   Begin MSComctlLib.ImageList iltImatgesIdiomes 
      Left            =   360
      Top             =   3120
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      MaskColor       =   12632256
      _Version        =   393216
   End
   Begin VB.Label lblIdiomesDisponibles 
      Caption         =   "lblIdiomesDisponibles"
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   840
      Width           =   4815
   End
   Begin VB.Label lblNomIdiomaActual 
      Caption         =   "Idioma actual"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   360
      Width           =   1935
   End
   Begin VB.Label lblIdiomaActual 
      Caption         =   "lblIdiomaActual"
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   120
      Width           =   1935
   End
End
Attribute VB_Name = "frmIdiomes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

'Serveix per accedir a les propietats i mtodes de la classe SvrIdiomes
Private Const ctstrNomObjecteSuport = "objClasseSuportActual"
Public objClasseSuportActual As GIMSuport.SvrIdiomes
Private objFuncionsComuns As clsFuncionsCapaInterficie

Public rstRecordsetActual As ADODB.Recordset 'Recordset que es mostra al formulari
Public rstRecordsetIdioma As ADODB.Recordset 'Recordset que cont els textos de l'idioma
Public rstRecordsetUsuaris As ADODB.Recordset 'Recordset amb informaci sobre l'usuari actual

Private strCadenaXMLTemporal As String

'**********************************************************************************************
'-- Events del formulari i dels controls
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Form_Load
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Load()
   IniciFormulari
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdAcceptar_Click
'----------------------------------------------------------------------------------------------
' S'executa quan es prem el bot Acceptar
'----------------------------------------------------------------------------------------------
Private Sub cmdAcceptar_Click()
   SurtGravantIdioma
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdCancellar_Click
'----------------------------------------------------------------------------------------------
' S'executa quan es prem el bot Cancellar
'----------------------------------------------------------------------------------------------
Private Sub cmdCancellar_Click()
   SurtSenseGravarIdioma
End Sub

'**********************************************************************************************
'-- Funcions de nivell superior
'**********************************************************************************************

'----------------------------------------------------------------------------------------------
'-- IniciFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques d'inicialitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub IniciFormulari()
   Dim lngComptador As Long
   Dim lngNombreIdiomes As Long
   Dim strRuta As String
   Dim strRutaIcones As String
   Dim strClauImatgeList As String
   Dim lngClau As Long
   Dim strTitol As String
   Dim bolSistemaIdiomaDefinit As Boolean
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Crea una instncia de les classes SvrIdiomes i objFuncionsComuns
   'per utilitzar-ne els mtodes i propietats
   
   Set objFuncionsComuns = New clsFuncionsCapaInterficie
   'Recupera una referncia a la capa de suport
   Set objClasseSuportActual = objFuncionsComuns.CreaObjecteSuport("SvrIdiomes")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Recupera els textos del formulari traduts a l'idioma per defecte
   Set rstRecordsetIdioma = objFuncionsComuns.TradueixFormulariIdioma(Me, Sistema.Idioma)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
        
   'Recupera els idiomes en format XML
   strCadenaXMLTemporal = objClasseSuportActual.GetIdiomes()
   If objClasseSuportActual.NumError <> ctintErrorOK Then
      UbicacioError = objClasseSuportActual.UbicacioError
      Err.Raise objClasseSuportActual.NumError
   End If
   
   'Passa els idiomes a un recordset
   Set rstRecordsetActual = objFuncionsComuns.PassaXMLARecordset(strCadenaXMLTemporal)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Recupera l'usuari en format XML
   strCadenaXMLTemporal = objClasseSuportActual.GetUsuariById(Sistema.Usuari)
   If objClasseSuportActual.NumError <> ctintErrorOK Then
      UbicacioError = objClasseSuportActual.UbicacioError
      Err.Raise objClasseSuportActual.NumError
   End If
   
   'Passa l'usuari a un recordset
   Set rstRecordsetUsuaris = objFuncionsComuns.PassaXMLARecordset(strCadenaXMLTemporal)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
     
   'Recupera la ruta dels arxius d'icones
   strRutaIcones = objFuncionsComuns.ConsultaArxiuIniInterficie("General", _
    "RutaDirectoriIcones")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
 
   'Omple l'etiqueta de l'idioma actual amb el nom de l'idioma que hi ha a
   'Sistema.Idioma
   bolSistemaIdiomaDefinit = False
   rstRecordsetActual.Filter = "NumIdioma = " & Str(Sistema.Idioma)
   If Not rstRecordsetActual.EOF Then
      Me.lblNomIdiomaActual.Caption = rstRecordsetActual!CodIdioma
      bolSistemaIdiomaDefinit = True
   End If
   rstRecordsetActual.Filter = ""
   
   lngNombreIdiomes = rstRecordsetActual.RecordCount
   If lngNombreIdiomes > 0 Then
      rstRecordsetActual.MoveFirst
         
      'Omple el control ImageList amb totes les imatges de les icones de idioma
      For lngComptador = 1 To lngNombreIdiomes
         strRuta = strRutaIcones & "\" & rstRecordsetActual!NomArxiuIconaIdioma
        
         If Dir(strRuta) = "" Then
            strRuta = strRutaIcones & "\" & "Defecte.jpg"
            'Si no es troba la icona i tampoc es troba la icona per defecte
            'es genera un missatge d'error
         
            If Dir(strRuta) = "" Then
               Err.Raise 516
               UbicacioError = ""
            End If
            'Si no es troba la icona i s la imatge per defecte
            's'agafa la imatge per defecte
         End If
        
         iltImatgesIdiomes.ListImages.Add , rstRecordsetActual!CodIdioma & _
          "#" & Str(rstRecordsetActual!NumIdioma), LoadPicture(strRuta)
         rstRecordsetActual.MoveNext
      Next lngComptador
      
      'Omple el control ListView amb les imatges de l'ImatgeList i amb
      'els noms de l'idioma que hi ha a rstRecordsetActual
      Set lstIdiomes.Icons = iltImatgesIdiomes
      Set lstIdiomes.SmallIcons = iltImatgesIdiomes
      Set lstIdiomes.ColumnHeaderIcons = iltImatgesIdiomes
      
      For lngComptador = 1 To lngNombreIdiomes
         strClauImatgeList = iltImatgesIdiomes.ListImages(lngComptador).Key
         lngClau = Val(Mid$(strClauImatgeList, InStr(strClauImatgeList, "#") + 1))
         strTitol = Left$(strClauImatgeList, InStr(strClauImatgeList, "#") - 1)
         lstIdiomes.ListItems.Add , "Clau" & Trim(Str(lngClau)), strTitol, _
          lngComptador, lngComptador
      Next lngComptador
      
      'Se selecciona la imatge corresponent a l'idioma actual
      If bolSistemaIdiomaDefinit Then
         Set lstIdiomes.SelectedItem = lstIdiomes.ListItems("Clau" & Trim(Str(Sistema.Idioma)))
      End If
   End If
   
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - IniciFormulari"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- SurtGravantIdioma()
'----------------------------------------------------------------------------------------------
' Surt guardant la contrasenya en la propietat Idioma del formulari Sistema i en el recordset
' corresponent
'----------------------------------------------------------------------------------------------
Private Sub SurtGravantIdioma()
   Dim bolResultat As Boolean
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Posa com a valor de l'idioma, el corresponent a la icona seleccionada
   Sistema.Idioma = Val(Mid$(lstIdiomes.SelectedItem.Key, 5))
   
   'Al recordset d'usuari es canvia l'idioma pel que s'ha seleccionat
   rstRecordsetUsuaris!NumIdioma = Sistema.Idioma
   
   'Passa el recordset d'usuaris a XML
   strCadenaXMLTemporal = objFuncionsComuns.PassaRecordsetAXML(rstRecordsetUsuaris)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Guarda l 'usuari en format XML
   bolResultat = objClasseSuportActual.SaveUsuari(strCadenaXMLTemporal)
   If objClasseSuportActual.NumError <> ctintErrorOK Then
      UbicacioError = objClasseSuportActual.UbicacioError
      Err.Raise objClasseSuportActual.NumError
   End If
     
   'Surt del formulari
   Unload Me
   Exit Sub
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - SurtGravantIdioma"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- SurtSenseGravarIdioma()
'----------------------------------------------------------------------------------------------
' Surt sense guardar l'idioma, aix que tot el que s'ha fet al formulari queda sense
' efecte
'----------------------------------------------------------------------------------------------
Private Sub SurtSenseGravarIdioma()
   Unload Me
End Sub

