VERSION 5.00
Object = "{F0D2F211-CCB0-11D0-A316-00AA00688B10}#1.0#0"; "MSDATLST.OCX"
Begin VB.Form frmLluminariaModel 
   Caption         =   "frmLluminariaModel"
   ClientHeight    =   4560
   ClientLeft      =   3960
   ClientTop       =   2505
   ClientWidth     =   8025
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   4560
   ScaleWidth      =   8025
   Begin VB.CommandButton cmdFoto 
      Caption         =   "cmdFoto"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   6960
      TabIndex        =   19
      Top             =   3000
      Width           =   855
   End
   Begin VB.CommandButton cmdEliminar 
      Caption         =   "cmdEliminar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5460
      TabIndex        =   16
      Top             =   3960
      Width           =   1215
   End
   Begin VB.CommandButton cmdEditar 
      Caption         =   "cmdEditar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4470
      TabIndex        =   15
      Top             =   3960
      Width           =   975
   End
   Begin VB.CommandButton cmdNou 
      Caption         =   "cmdNou"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   3360
      TabIndex        =   14
      Top             =   3960
      Width           =   1095
   End
   Begin VB.CommandButton cmdSortir 
      Caption         =   "cmdSortir"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   6675
      TabIndex        =   13
      Top             =   3960
      Width           =   1095
   End
   Begin VB.TextBox txtAnyCataleg 
      DataField       =   "CatalegAny"
      Height          =   375
      Left            =   5760
      ScrollBars      =   2  'Vertical
      TabIndex        =   9
      Top             =   2160
      Width           =   2055
   End
   Begin VB.CommandButton cmdEscullFotoLluminaria 
      Caption         =   ".."
      Height          =   360
      Left            =   6600
      TabIndex        =   8
      Top             =   3000
      Width           =   255
   End
   Begin VB.TextBox txtFoto 
      DataField       =   "FotoLluminaria"
      Height          =   375
      Left            =   3360
      ScrollBars      =   2  'Vertical
      TabIndex        =   6
      Top             =   3000
      Width           =   3255
   End
   Begin VB.TextBox txtMarcaCataleg 
      DataField       =   "CodCatalegMarca"
      Height          =   375
      Left            =   3360
      ScrollBars      =   2  'Vertical
      TabIndex        =   3
      Top             =   2160
      Width           =   2055
   End
   Begin VB.TextBox txtCodi 
      DataField       =   "CodLluminariaModel"
      Height          =   375
      Left            =   3360
      TabIndex        =   2
      Top             =   720
      Width           =   4455
   End
   Begin VB.ListBox lstModels 
      Height          =   3420
      ItemData        =   "frmLluminariaModel.frx":0000
      Left            =   240
      List            =   "frmLluminariaModel.frx":0007
      TabIndex        =   0
      Top             =   480
      Width           =   2895
   End
   Begin MSDataListLib.DataCombo cmbMarca 
      DataField       =   "NumLluminariaMarca"
      Height          =   360
      Left            =   3360
      TabIndex        =   12
      Top             =   1440
      Width           =   4455
      _ExtentX        =   7858
      _ExtentY        =   635
      _Version        =   393216
      ListField       =   "CodLluminariaMarca"
      BoundColumn     =   "NumLluminariaMarca"
      Text            =   ""
   End
   Begin VB.CommandButton cmdSortirEdicio 
      Caption         =   "cmdSortirEdicio"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4260
      TabIndex        =   17
      Top             =   3960
      Width           =   1215
   End
   Begin VB.CommandButton cmdDesferCanvis 
      Caption         =   "cmdDesferCanvis"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5475
      TabIndex        =   18
      Top             =   3960
      Width           =   1215
   End
   Begin VB.Label lblMarca 
      Caption         =   "lblMarca"
      Height          =   255
      Left            =   3360
      TabIndex        =   11
      Top             =   1200
      Width           =   4335
   End
   Begin VB.Label lblAnyCataleg 
      Caption         =   "lblAnyCataleg"
      Height          =   255
      Left            =   5760
      TabIndex        =   10
      Top             =   1920
      Width           =   2055
   End
   Begin VB.Label lblFoto 
      Caption         =   "lblFoto"
      Height          =   255
      Left            =   3360
      TabIndex        =   7
      Top             =   2760
      Width           =   4335
   End
   Begin VB.Label lblMarcaCataleg 
      Caption         =   "lblMarcaCataleg"
      Height          =   255
      Left            =   3360
      TabIndex        =   5
      Top             =   1920
      Width           =   2055
   End
   Begin VB.Label lblCodi 
      Caption         =   "lblCodi"
      Height          =   255
      Left            =   3360
      TabIndex        =   4
      Top             =   480
      Width           =   4335
   End
   Begin VB.Label lblModel 
      AutoSize        =   -1  'True
      Caption         =   "lblModel"
      Height          =   240
      Left            =   240
      TabIndex        =   1
      Top             =   240
      Width           =   780
   End
End
Attribute VB_Name = "frmLluminariaModel"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

'Serveix per accedir a les propietats i mtodes de la classe SvrLluminariaModel

Public objClasseSuportActual As GIMSuport.SvrLluminariaModel
Private objFuncionsComuns As clsFuncionsCapaInterficie

Public rstRecordsetActual As ADODB.Recordset 'Recordset que es mostra al formulari
Public rstRecordsetMarques As ADODB.Recordset 'Recordset que cont la llista de clients
Public rstRecordsetIdioma As New ADODB.Recordset 'Cont els textos de l'idioma

Private strCadenaXMLTemporal As String
Private bolAuxModeFormEdicio As Boolean 'Mode d'Edicio del formulari
Private bolModeFormActualitzacio As Integer 'Mode d'Actualitzaci del formulari
   '0 - sense actualitzaci, 1 - nou, 2- esborrar i modificar

'**********************************************************************************************
'-- Funcions d'implementaci de propietats
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Property Let i Get bolModeFormEdicio()
'----------------------------------------------------------------------------------------------
' Implementa la variable ModeFormEdici que indica si el formulari es troba en mode d'edici o
' de consulta. Cada cop que canvia el mode, s'executa el procediment RefreshModeFormEdicio
'----------------------------------------------------------------------------------------------
Private Property Get bolModeFormEdicio() As Long
   bolModeFormEdicio = bolAuxModeFormEdicio
End Property

Private Property Let bolModeFormEdicio(ByVal RHS As Long)
   RefreshModeFormEdicio (RHS)
   bolAuxModeFormEdicio = RHS
End Property
'----------------------------------------------------------------------------------------------
'-- cmdFoto_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic al bot cmdFoto
'----------------------------------------------------------------------------------------------
Private Sub cmdFoto_Click()
   ObreVisor Me.txtFoto.Text
End Sub

'----------------------------------------------------------------------------------------------
'-- cmdEscullFotoLluminaria_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic al bot cmdEscullFotoLluminaria
'----------------------------------------------------------------------------------------------
Private Sub cmdEscullFotoLluminaria_Click()
   SeleccionaFotoLluminaria
End Sub

'**********************************************************************************************
'-- Events del formulari i dels controls
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Form_Load
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Load()
   IniciFormulari
End Sub
'----------------------------------------------------------------------------------------------
'-- Form_Terminate
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Terminate()
   FiFormulari
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdNou_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdNou
' Crida a una funci per inserir-hi un registre nou
'----------------------------------------------------------------------------------------------
Private Sub cmdNou_Click()
   Nou
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdEditar_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdEditar
' Crida a una funci per editar el registre que es mostra per pantalla
'----------------------------------------------------------------------------------------------
Private Sub cmdEditar_Click()
   Editar
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdEliminar_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdEliminar
' Crida a una funci per eliminar el registre que es mostra per pantalla
'----------------------------------------------------------------------------------------------
Private Sub cmdEliminar_Click()
   Eliminar
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdSortir_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdSortir
' Crida a una funci per sortir del formulari
'----------------------------------------------------------------------------------------------
Private Sub cmdSortir_Click()
   Sortir
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdSortirEdicio_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdSortirEdicio
' Crida a una funci per sortir del mode d'edici i guardar els canvis
'----------------------------------------------------------------------------------------------
Private Sub cmdSortirEdicio_Click()
   SortirEdicio
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdDesferCanvis_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdDesferCanvis
' Crida a una funci per sortir del mode d'edici sense guardar els canvis
'----------------------------------------------------------------------------------------------
Private Sub cmdDesferCanvis_Click()
   UndoChanges
End Sub

'----------------------------------------------------------------------------------------------
'-- lstModels_Click()
'----------------------------------------------------------------------------------------------
' S'executa quan es fa clic a la llista de models
'----------------------------------------------------------------------------------------------
Private Sub lstModels_Click()
   RefrescaFormulariAmbLlista
End Sub
'----------------------------------------------------------------------------------------------
'-- Events de DataCombo
'----------------------------------------------------------------------------------------------
' Ja que el datacombo de Microsoft no actualitza convenientment les dades
' Ho hem de fer per programaci amd els segents events
'----------------------------------------------------------------------------------------------

Private Sub cmbMarca_LostFocus()
   FixaDataCombo Me.cmbMarca
End Sub

Private Sub cmbMarca_Validate(Cancel As Boolean)
   Me.cmbMarca.DataChanged = False
End Sub

'**********************************************************************************************
'-- Funcions de nivell superior
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- RefreshModeFormEdicio
'----------------------------------------------------------------------------------------------
' S'executa cada vegada que s'assigna la variable RefreshModeFormEdicio
' Habilita o deshabilita els butons i els controls d'entrada segons el valor de la variable
'----------------------------------------------------------------------------------------------
Private Sub RefreshModeFormEdicio(bolModeFormulari As Boolean)

   Dim ctrDades As Control
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
      
   'Fa visible els botons corresponents a cada mode del formulari
   Me.cmdNou.Visible = (Not bolModeFormulari)
   Me.cmdEditar.Visible = (Not bolModeFormulari)
   Me.cmdEliminar.Visible = (Not bolModeFormulari)
   Me.cmdSortir.Visible = (Not bolModeFormulari)
   Me.cmdSortirEdicio.Visible = bolModeFormulari
   Me.cmdDesferCanvis.Visible = bolModeFormulari
     
   'Si estem en mode d'edici, habilita els controls d'entrada de dades i, si no,
   'els deshabilita
   For Each ctrDades In Me.Controls
      If TypeName(ctrDades) = "TextBox" Or TypeName(ctrDades) = "ComboBox" Or _
       TypeName(ctrDades) = "DataCombo" Then
         ctrDades.Locked = (Not bolModeFormulari)
      End If
   Next ctrDades
   
   Me.lstModels.Enabled = Not bolModeFormulari
   Me.cmdFoto.Enabled = bolModeFormulari
   Me.cmdEscullFotoLluminaria.Enabled = bolModeFormulari
   Exit Sub
    
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefreshModeFormEdicio"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- IniciFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques d'inicialitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub IniciFormulari()
   Dim lngComptador As Long
  
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
 
   'Crea una instncia de les classes SvrLluminariaModel i objFuncionsComuns
   'per utilitzar-ne els mtodes i propietats
   Set objFuncionsComuns = New clsFuncionsCapaInterficie
   Set objClasseSuportActual = objFuncionsComuns.CreaObjecteSuport("SvrLluminariaModel")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
      
   'Recupera els textos del formulari traduts a l'idioma per defecte
   
   Set rstRecordsetIdioma = objFuncionsComuns.TradueixFormulariIdioma(Me, Sistema.Idioma)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
      
   'No estem en mode d'actualitzaci
   bolModeFormActualitzacio = 0
    
    'Recupera les marques i les posa en un recordset
   strCadenaXMLTemporal = objClasseSuportActual.GetLluminariaMarques()
   If objClasseSuportActual.NumError <> ctintErrorOK Then
      UbicacioError = objClasseSuportActual.UbicacioError
      Err.Raise objClasseSuportActual.NumError
   End If
   
   Set rstRecordsetMarques = objFuncionsComuns.PassaXMLARecordset(strCadenaXMLTemporal)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If

   'Recupera els models de la BD
   RecuperaModels
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
      
   'Enllaa els controls al recordset acabat de crear
   objFuncionsComuns.LinkControls Me
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Emplena les llistes dels quadres combinats
   Set cmbMarca.RowSource = rstRecordsetMarques
      
   'Refresca el formulari per tal que s'hi vegi el seu estat actualitzat
   RefrescaFormulariActualitzacio
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   
   'Posa el formulari en mode de consulta (no edici)
   bolModeFormEdicio = False
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - IniciFormulari"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- FiFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques de finalitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub FiFormulari()
   'Allibera les instncies de les classes
   Set objClasseSuportActual = Nothing
   Set objFuncionsComuns = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- Nou
'----------------------------------------------------------------------------------------------
' Crea un registre en blanc per editar un nou registre
'----------------------------------------------------------------------------------------------

Private Sub Nou()
   Dim strCadenaValidacio  As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es fixa el mode d'actualitzaci
   bolModeFormActualitzacio = 1
    
   'Afegeix un registre nou al recordset
   rstRecordsetActual.AddNew
        
   'Posa el formulari en mode d'edici
   bolModeFormEdicio = True
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Nou"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Editar
'----------------------------------------------------------------------------------------------
' Posa el formulari en mode d'edici
'----------------------------------------------------------------------------------------------
Private Sub Editar()
   Dim strCadenaValidacio As String
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
       
    
   strCadenaValidacio = CadenaValidacioEditar()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
       MsgBox (strCadenaValidacio)
   Else
       'Posa el mode d'edici a cert
       bolModeFormEdicio = True
       'Es fixa el mode d'actualitzaci
       bolModeFormActualitzacio = 2
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Editar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- Eliminar
'----------------------------------------------------------------------------------------------
' Elimina el registre actual de la base de dades
'----------------------------------------------------------------------------------------------
Private Sub Eliminar()
   Dim bolResultat As Boolean
   Dim strCadenaValidacio  As String
   Dim strTextValidacioEliminar As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
       
    
   'Mira si es pot eliminar el registre i, si s aix, l'elimina. Altrament emet un error
   strCadenaValidacio = CadenaValidacioEliminar()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
      MsgBox (strCadenaValidacio)
   Else
      'Recupera els textos traduits per omplir el textbox que indica el nmero de registre
      strTextValidacioEliminar = objFuncionsComuns.TradueixDefecteMissatgeFormulariIdioma _
       (rstRecordsetIdioma, "valTextEliminar", "valTextEliminar")
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
         
      If MsgBox(strTextValidacioEliminar, vbYesNo) = vbYes Then
      
         'Es fixa el mode d'actualitzaci
         bolModeFormActualitzacio = 2
      
         'Esborra el registre del recordset actual i propaga els canvis a la BD
         rstRecordsetActual.Delete
      
         'Propaga els canvis a la BD
         PropagaCanvisABD
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
   
         'Refresca el formulari desprs d'una actualitzaci
         RefrescaFormulariActualitzacio
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
         
         'Es fixa el mode d'actualitzaci
         bolModeFormActualitzacio = 0
      End If
   End If
        
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Eliminar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Sortir
'----------------------------------------------------------------------------------------------
' Surt del formulari
'----------------------------------------------------------------------------------------------
Private Sub Sortir()
   Unload Me
End Sub

'----------------------------------------------------------------------------------------------
'-- SortirEdicio
'----------------------------------------------------------------------------------------------
'Si els canvis realitzats durant l'edici sn vlids, surt del mode d'edici
'Si no, emet un missatge d'error
'---------------------------------------------------------------------------------------------
Private Sub SortirEdicio()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   Dim strCadenaValidacio As String
    
   'Mira si el registre que acabem d'introduir s vlid
   strCadenaValidacio = CadenaValidacioRegistreActual()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
      MsgBox (strCadenaValidacio)
   Else
      'Si ho s, fa un Update i propaga els canvis a la BD
      If rstRecordsetActual.RecordCount > 0 Then
         rstRecordsetActual.Update
                  
         'Propaga el canvi a la BD
         PropagaCanvisABD
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
            
         'Refresca el formulari desprs d'una actualitzaci
         RefrescaFormulariActualitzacio
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
   
      End If
      'Posa el mode d'edici a fals
      bolModeFormEdicio = False
        
      'Es fixa el mode d'actualitzaci
      bolModeFormActualitzacio = 0
    End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - SortirEdicio"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- UndoChanges
'----------------------------------------------------------------------------------------------
' Desf els canvis produts amb el mode d'edici
'----------------------------------------------------------------------------------------------
Private Sub UndoChanges()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   
   'Cancella l'Update i refresca el formulari
   rstRecordsetActual.CancelUpdate
   
   'Refresca el formulari desprs d'una actualitzaci
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
      
   RefrescaFormulariActualitzacio
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   bolModeFormEdicio = False
   
   'Es fixa el mode d'actualitzaci
   bolModeFormActualitzacio = 0
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - UndoChanges"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariAmbLlista()
'----------------------------------------------------------------------------------------------
' Quan es fa clic a la llista,
' es refresquen les dades del formulari amb el model escollit de la llista
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariAmbLlista()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
  
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariAmbLlista"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- FixaDataCombo
'----------------------------------------------------------------------------------------------
' Fixa les dades d'un data combo
'----------------------------------------------------------------------------------------------
Private Sub FixaDataCombo(ctrDataCombo As Control)
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   If ctrDataCombo.MatchedWithList Then
      If Not rstRecordsetActual.EOF Then
         rstRecordsetActual.Fields(ctrDataCombo.DataField) = Val(ctrDataCombo.BoundText)
      End If
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - FixaDataCombo"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'**********************************************************************************************
'-- Funcions que no sn de nivell superior
'**********************************************************************************************

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariActualitzacio()
'----------------------------------------------------------------------------------------------
' Refresca el formulari desprs d'una actualitzaci
' Posa en la llista de models en el camp corresponent
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariActualitzacio()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Omple la llista de models
   Me.lstModels.Clear
   If rstRecordsetActual.RecordCount > 0 Then
      rstRecordsetActual.MoveFirst
      Do While Not rstRecordsetActual.EOF
         Me.lstModels.AddItem rstRecordsetActual!CodLluminariaModel
         Me.lstModels.ItemData(lstModels.NewIndex) = _
          rstRecordsetActual.AbsolutePosition
         rstRecordsetActual.MoveNext
      Loop
      Me.lstModels.ListIndex = 0
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariActualitzacio"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariLectura()
'----------------------------------------------------------------------------------------------
' Refresca el formulari desprs d'una lectura
' Concretament, refresca els camps segons el model seleccionat
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariLectura()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Mou el recordset fins al nmero de registre seleccionat des del Listbox
   If rstRecordsetActual.RecordCount > 0 And Me.lstModels.ListCount > 0 Then
      rstRecordsetActual.Move Me.lstModels.ItemData(Me.lstModels.ListIndex) - 1, _
       adBookmarkFirst
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariLectura"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- PropagaCanvisABD
'----------------------------------------------------------------------------------------------
' Guarda els canvis que s'han fet sobre el Recordset
' a la Base de Dades
'----------------------------------------------------------------------------------------------
Private Sub PropagaCanvisABD()
   Dim strCadenaValidacio  As String
   Dim StrCadenaXML As String
   Dim bolResultat As Boolean
   Dim StrXMLDades As String
   Dim strXMLCanvis As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
             
   'Desenllaa per tal que es copi b el Recordset
   objFuncionsComuns.DeslinkControls Me
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Obte la cadena XML corresponent al recordset actual
   StrCadenaXML = objFuncionsComuns.PassaRecordsetAXML(rstRecordsetActual)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Obt noms les actualitzacions de la cadena XML
   strXMLCanvis = objFuncionsComuns.ObteActualitzacionsDeXML(StrCadenaXML)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es graven els canvis a la base de dades
   bolResultat = objClasseSuportActual.SaveLluminariaModel(strXMLCanvis)
   If objClasseSuportActual.NumError <> ctintErrorOK Then
      UbicacioError = objClasseSuportActual.UbicacioError
      Err.Raise objClasseSuportActual.NumError
   End If
    
   'Refresca la informacio del Recordset
   RecuperaModels
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
       
   objFuncionsComuns.LinkControls Me 'Torna a enllaar-se les dades
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - PropagaCanvisABD"
   objFuncionsComuns.LinkControls Me
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- RecuperaModels()
'----------------------------------------------------------------------------------------------
' Crea un recordset amb la mateixa informaci que el recordset actual
' per que no t cap actualitzaci pendent
'----------------------------------------------------------------------------------------------
Public Sub RecuperaModels()
   Dim strResultat As String
   Dim rstTemp As ADODB.Recordset
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Si es tracta del comenament del formulari o d'una inserci
   If bolModeFormActualitzacio = 0 Or bolModeFormActualitzacio = 1 Then
      'Es recuperen els models mitjanant la classe SvrModels
      strResultat = objClasseSuportActual.GetLluminariesModels()
      
      If objClasseSuportActual.NumError <> ctintErrorOK Then
         UbicacioError = objClasseSuportActual.UbicacioError
         Err.Raise objClasseSuportActual.NumError
      End If
   Else
      'En cas de modificaci o esborrat, es purguen les actualitzacions
      'del recordset perqu no cal accedir a les capes inferiors
      strResultat = objFuncionsComuns.PurgaActualitzacionsRecordset(rstRecordsetActual)
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
   End If
    
   'Si no hi ha hagut errors, crea el Recordset a partir de l'XML
   Set rstRecordsetActual = objFuncionsComuns.PassaXMLARecordset(strResultat)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RecuperaModels"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioRegistreActual()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per guardar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------

Private Function CadenaValidacioRegistreActual()
   Dim bolCampRepetit As Boolean
   Dim strCodiMissatge As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
     
   'Mira que s'omplin tots els camps
   If rstRecordsetActual.RecordCount > 0 And (Me.txtCodi.Text = "" Or _
      Me.cmbMarca.Text = "") Then
         strCodiMissatge = "valAlgunCampBuit"
   Else
      If Not Me.cmbMarca.MatchedWithList Then
         strCodiMissatge = "valNoCodiEnLlista"
      Else
         'Mira que no hi hagi un altre registre amb el mateix codi
         bolCampRepetit = objFuncionsComuns.ValorCampRepetit(rstRecordsetActual, _
          "CodLluminariaModel")
         If objFuncionsComuns.NumError <> ctintErrorOK Then
            UbicacioError = objFuncionsComuns.UbicacioError
               Err.Raise objFuncionsComuns.NumError
         End If
      
         If bolCampRepetit Then
            strCodiMissatge = "valRepetitCodiModel"
         Else
            strCodiMissatge = ""
         End If
      End If
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioRegistreActual = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioRegistreActual"
   CadenaValidacioRegistreActual = ""
   Exit Function
End Function
   

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioEliminar()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per eliminar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioEliminar()
   Dim strCodiMissatge As String
   Dim strResultat As String
      
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   If rstRecordsetActual.RecordCount = 0 Then
      strCodiMissatge = "valNoRegistresEliminar"
   Else
      strCodiMissatge = ""
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Retorna el text tradut
   CadenaValidacioEliminar = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioEliminar"
   CadenaValidacioEliminar = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioEditar()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per eliminar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioEditar()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   Dim strCodiMissatge As String
   Dim strResultat As String
   
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   
   If rstRecordsetActual.RecordCount = 0 Then
      strCodiMissatge = "valNoRegistresEditar"
   Else
      strCodiMissatge = ""
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioEditar = strResultat
   Exit Function
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioEditar"
   CadenaValidacioEditar = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- SeleccionaFotoLluminaria
'----------------------------------------------------------------------------------------------
' Selecciona un arxiu obrint un cuadre de dileg
'----------------------------------------------------------------------------------------------
Private Sub SeleccionaFotoLluminaria()
   Dim strRuta As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
   strRuta = objFuncionsComuns.EscullArxiu()
   
   If strRuta <> "" Then
      Me.rstRecordsetActual!FotoLluminaria = strRuta
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - SeleccionaFotoLluminaria"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- ObreVisor
'----------------------------------------------------------------------------------------------
' Obre el visor d'una imatge
'----------------------------------------------------------------------------------------------
Private Sub ObreVisor(strRutaArxiuImatge As String)
   Dim bolResultat As Boolean
   Dim strMissatgeError As String
   Dim strMissatgeErrorTraduit As String
   
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Mira que el camp de foto existeixi i tingui algun valor
   strMissatgeError = ""
   If IsNull(strRutaArxiuImatge) Or Trim(strRutaArxiuImatge = "") Then
      strMissatgeError = "valNoHiHaFoto"
   End If
   
   'Obre el visor
   bolResultat = objFuncionsComuns.ObreVisorImatge(strRutaArxiuImatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
  
   'Si no s'ha pogut obrir, perqu no hi havia ruta, emet el missatge d'error
   If Not bolResultat Then
      strMissatgeError = "valRutaFotoNoValida"
   End If
      
   'Tradueix el missatge d'error a l'idioma escaient
   If strMissatgeError <> "" Then
      strMissatgeErrorTraduit = objFuncionsComuns.TradueixDefecteMissatgeFormulariIdioma _
       (rstRecordsetIdioma, strMissatgeError, "Error en recuperar l'arxiu de foto.")
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
      MsgBox (strMissatgeErrorTraduit)
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - ObreVisorImatge"
    objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
