VERSION 5.00
Begin VB.Form frmManteniments 
   Caption         =   "frmManteniments"
   ClientHeight    =   4860
   ClientLeft      =   4620
   ClientTop       =   2070
   ClientWidth     =   7890
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form2"
   ScaleHeight     =   4860
   ScaleWidth      =   7890
   Begin VB.TextBox txtObservacions 
      DataField       =   "Observacions"
      Height          =   2175
      Left            =   3000
      MultiLine       =   -1  'True
      TabIndex        =   8
      Top             =   1560
      Width           =   4455
   End
   Begin VB.TextBox txtNomManteniment 
      DataField       =   "CodTipusManteniment"
      Height          =   375
      Left            =   3000
      TabIndex        =   7
      Top             =   840
      Width           =   4455
   End
   Begin VB.CommandButton cmdSortir 
      Caption         =   "cmdSortir"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   6240
      TabIndex        =   6
      Top             =   4200
      Width           =   1095
   End
   Begin VB.ListBox lstManteniments 
      Height          =   3180
      ItemData        =   "frmManteniments.frx":0000
      Left            =   240
      List            =   "frmManteniments.frx":0007
      Sorted          =   -1  'True
      TabIndex        =   0
      Top             =   600
      Width           =   2295
   End
   Begin VB.CommandButton cmdEditar 
      Caption         =   "cmdEditar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4035
      TabIndex        =   2
      Top             =   4200
      Width           =   975
   End
   Begin VB.CommandButton cmdEliminar 
      Caption         =   "cmdEliminar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5025
      TabIndex        =   4
      Top             =   4200
      Width           =   1215
   End
   Begin VB.CommandButton cmdNou 
      Caption         =   "cmdNou"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2925
      TabIndex        =   1
      Top             =   4200
      Width           =   1095
   End
   Begin VB.CommandButton cmdSortirEdicio 
      Caption         =   "cmdSortirEdicio"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   3825
      TabIndex        =   3
      Top             =   4200
      Width           =   1215
   End
   Begin VB.CommandButton cmdDesferCanvis 
      Caption         =   "cmdDesferCanvis"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5040
      TabIndex        =   5
      Top             =   4200
      Width           =   1215
   End
   Begin VB.Label lblLlistaManteniments 
      Caption         =   "lblLlistaManteniments"
      Height          =   255
      Left            =   240
      TabIndex        =   11
      Top             =   360
      Width           =   4455
   End
   Begin VB.Label lblObservacions 
      Caption         =   "lblObservacions"
      Height          =   255
      Left            =   3000
      TabIndex        =   10
      Top             =   1320
      Width           =   4455
   End
   Begin VB.Label lblNomManteniment 
      Caption         =   "lblNomManteniment"
      Height          =   255
      Left            =   3000
      TabIndex        =   9
      Top             =   600
      Width           =   4455
   End
End
Attribute VB_Name = "frmManteniments"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

'Serveix per accedir a les propietats i mtodes de la classe SvrManteniments
Public objClasseSuportActual As GIMSuport.SvrManteniments
Private objFuncionsComuns As clsFuncionsCapaInterficie

Public rstRecordsetActual As ADODB.Recordset 'Recordset que es mostra al formulari
Public rstRecordsetProjectes As ADODB.Recordset 'Recordset que es mostra al formulari
Public rstRecordsetIdioma As ADODB.Recordset 'Recordset amb les textos tradus del formulari

Private strCadenaXMLTemporal As String
Private bolAuxModeFormEdicio As Boolean 'Mode d'Edicio del formulari
Private bolModeFormActualitzacio As Integer 'Mode d'Actualitzaci del formulari
   '0 - sense actualitzaci, 1 - nou, 2- esborrar i modificar

'**********************************************************************************************
'-- Funcions d'implementaci de propietats
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Property Let i Get bolModeFormEdicio()
'----------------------------------------------------------------------------------------------
' Implementa la variable ModeFormEdici que indica si el formulari es troba en mode d'edici o
' de consulta. Cada cop que canvia el mode, s'executa el procediment RefreshModeFormEdicio
'----------------------------------------------------------------------------------------------
Private Property Get bolModeFormEdicio() As Long
   bolModeFormEdicio = bolAuxModeFormEdicio
End Property

Private Property Let bolModeFormEdicio(ByVal RHS As Long)
   RefreshModeFormEdicio (RHS)
   bolAuxModeFormEdicio = RHS
End Property

'**********************************************************************************************
'-- Events del formulari i dels controls
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Form_Load
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Load()
   IniciFormulari
End Sub
'----------------------------------------------------------------------------------------------
'-- Form_Terminate
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Terminate()
   FiFormulari
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdNou_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdNou
' Crida a una funci per inserir-hi un registre nou
'----------------------------------------------------------------------------------------------
Private Sub cmdNou_Click()
   Nou
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdEditar_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdEditar
' Crida a una funci per editar el registre que es mostra per pantalla
'----------------------------------------------------------------------------------------------
Private Sub cmdEditar_Click()
   Editar
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdEliminar_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdEliminar
' Crida a una funci per eliminar el registre que es mostra per pantalla
'----------------------------------------------------------------------------------------------
Private Sub cmdEliminar_Click()
   Eliminar
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdSortir_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdSortir
' Crida a una funci per sortir del formulari
'----------------------------------------------------------------------------------------------
Private Sub cmdSortir_Click()
   Sortir
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdSortirEdicio_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdSortirEdicio
' Crida a una funci per sortir del mode d'edici i guardar els canvis
'----------------------------------------------------------------------------------------------
Private Sub cmdSortirEdicio_Click()
   SortirEdicio
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdDesferCanvis_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdDesferCanvis
' Crida a una funci per sortir del mode d'edici sense guardar els canvis
'----------------------------------------------------------------------------------------------
Private Sub cmdDesferCanvis_Click()
   UndoChanges
End Sub

'----------------------------------------------------------------------------------------------
'-- lstManteniments_Click()
'----------------------------------------------------------------------------------------------
' S'executa quan es fa clic a la llista de tipus de manteniment
'----------------------------------------------------------------------------------------------
Private Sub lstManteniments_Click()
   RefrescaFormulariAmbLlista
End Sub

'**********************************************************************************************
'-- Funcions de nivell superior
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- RefreshModeFormEdicio
'----------------------------------------------------------------------------------------------
' S'executa cada vegada que s'assigna la variable RefreshModeFormEdicio
' Habilita o deshabilita els butons i els controls d'entrada segons el valor de la variable
'----------------------------------------------------------------------------------------------
Private Sub RefreshModeFormEdicio(bolModeFormulari As Boolean)

   Dim ctrDades As Control
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
      
   'Fa visible els botons corresponents a cada mode del formulari
   Me.cmdNou.Visible = (Not bolModeFormulari)
   Me.cmdEditar.Visible = (Not bolModeFormulari)
   Me.cmdEliminar.Visible = (Not bolModeFormulari)
   Me.cmdSortir.Visible = (Not bolModeFormulari)
   Me.cmdSortirEdicio.Visible = bolModeFormulari
   Me.cmdDesferCanvis.Visible = bolModeFormulari
    
   'Si estem en mode d'edici, habilita els controls d'entrada de dades i, si no,
   'els deshabilita
   For Each ctrDades In Me.Controls
      If TypeName(ctrDades) = "TextBox" Or TypeName(ctrDades) = "ComboBox" Or _
       TypeName(ctrDades) = "DataCombo" Then
         ctrDades.Locked = (Not bolModeFormulari)
      End If
   Next ctrDades
   
   Me.lstManteniments.Enabled = (Not bolModeFormulari)
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefreshModeFormEdicio"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- IniciFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques d'inicialitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub IniciFormulari()
   Dim lngComptador As Long
  
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
 
   'Crea una instncia de les classes SvrManteniments i objFuncionsComuns
   'per utilitzar-ne els mtodes i propietats
   Set objFuncionsComuns = New clsFuncionsCapaInterficie
   
   'Recupera una referncia a la capa de suport
   Set objClasseSuportActual = objFuncionsComuns.CreaObjecteSuport("SvrManteniments")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
         
   'Recupera els textos del formulari traduts a l'idioma per defecte
   
   Set rstRecordsetIdioma = objFuncionsComuns.TradueixFormulariIdioma(Me, Sistema.Idioma)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
      
   'No estem en mode d'actualitzaci
   bolModeFormActualitzacio = 0
   
   'Recupera els projectes i els posa en un recordset
   strCadenaXMLTemporal = objClasseSuportActual.GetProjectes()
   If objClasseSuportActual.NumError <> ctintErrorOK Then
      UbicacioError = objClasseSuportActual.UbicacioError
      Err.Raise objClasseSuportActual.NumError
   End If
   
   Set rstRecordsetProjectes = objFuncionsComuns.PassaXMLARecordset(strCadenaXMLTemporal)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Recupera els Manteniments de la BD
   RecuperaManteniments
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
      
   'Enllaa els controls al recordset acabat de crear
   objFuncionsComuns.LinkControls Me
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
  
  
   'Refresca el formulari per tal que s'hi vegi el seu estat actualitzat
   RefrescaFormulariActualitzacio
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   
   'Posa el formulari en mode de consulta (no edici)
   bolModeFormEdicio = False
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - IniciFormulari"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- FiFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques de finalitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub FiFormulari()
   'Allibera les instncies de les classes
   Set objClasseSuportActual = Nothing
   Set objFuncionsComuns = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- Nou
'----------------------------------------------------------------------------------------------
' Crea un registre en blanc per editar un nou registre
'----------------------------------------------------------------------------------------------

Private Sub Nou()
   Dim strCadenaValidacio  As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es fixa el mode d'actualitzaci
   bolModeFormActualitzacio = 1
    
   'Afegeix un registre nou al recordset
   rstRecordsetActual.AddNew
        
   'Posa el formulari en mode d'edici
   bolModeFormEdicio = True
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Nou"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Editar
'----------------------------------------------------------------------------------------------
' Posa el formulari en mode d'edici
'----------------------------------------------------------------------------------------------
Private Sub Editar()
   Dim strCadenaValidacio As String
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
       
    
   strCadenaValidacio = CadenaValidacioEditar()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
       MsgBox (strCadenaValidacio)
   Else
       'Posa el mode d'edici a cert
       bolModeFormEdicio = True
       'Es fixa el mode d'actualitzaci
       bolModeFormActualitzacio = 2
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Editar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- Eliminar
'----------------------------------------------------------------------------------------------
' Elimina el registre actual de la base de dades
'----------------------------------------------------------------------------------------------
Private Sub Eliminar()
   Dim bolResultat As Boolean
   Dim strCadenaValidacio  As String
   Dim strTextValidacioEliminar As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
       
    
   'Mira si es pot eliminar el registre i, si s aix, l'elimina. Altrament emet un error
   strCadenaValidacio = CadenaValidacioEliminar()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
      MsgBox (strCadenaValidacio)
   Else
      'Recupera els textos traduits per omplir el textbox que indica el nmero de registre
      strTextValidacioEliminar = objFuncionsComuns.TradueixDefecteMissatgeFormulariIdioma _
       (rstRecordsetIdioma, "valTextEliminar", "valTextEliminar")
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
         
      If MsgBox(strTextValidacioEliminar, vbYesNo) = vbYes Then
      
         'Es fixa el mode d'actualitzaci
         bolModeFormActualitzacio = 2
      
         'Esborra el registre del recordset actual i propaga els canvis a la BD
         rstRecordsetActual.Delete
      
         'Propaga els canvis a la BD
         PropagaCanvisABD
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
   
         'Refresca el formulari desprs d'una actualitzaci
         RefrescaFormulariActualitzacio
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
         
         'Es fixa el mode d'actualitzaci
         bolModeFormActualitzacio = 0
      End If
   End If
        
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Eliminar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Sortir
'----------------------------------------------------------------------------------------------
' Surt del formulari
'----------------------------------------------------------------------------------------------
Private Sub Sortir()
   Unload Me
End Sub
'----------------------------------------------------------------------------------------------
'-- SortirEdicio
'----------------------------------------------------------------------------------------------
'Si els canvis realitzats durant l'edici sn vlids, surt del mode d'edici
'Si no, emet un missatge d'error
'---------------------------------------------------------------------------------------------
Private Sub SortirEdicio()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   Dim strCadenaValidacio As String
    
   'Mira si el registre que acabem d'introduir s vlid
   strCadenaValidacio = CadenaValidacioRegistreActual()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
      MsgBox (strCadenaValidacio)
   Else
      'Si ho s, fa un Update i propaga els canvis a la BD
      If rstRecordsetActual.RecordCount > 0 Then
         rstRecordsetActual.Update
                 
         'Propaga el canvi a la BD
         PropagaCanvisABD
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
            
         'Refresca el formulari desprs d'una actualitzaci
         RefrescaFormulariActualitzacio
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
   
      End If
      'Posa el mode d'edici a fals
      bolModeFormEdicio = False
        
      'Es fixa el mode d'actualitzaci
      bolModeFormActualitzacio = 0
    End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - SortirEdicio"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- UndoChanges
'----------------------------------------------------------------------------------------------
' Desf els canvis produts amb el mode d'edici
'----------------------------------------------------------------------------------------------
Private Sub UndoChanges()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   
   'Cancella l'Update i refresca el formulari
   rstRecordsetActual.CancelUpdate
   
   'Refresca el formulari desprs d'una actualitzaci
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   RefrescaFormulariActualitzacio
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   bolModeFormEdicio = False
   
   'Es fixa el mode d'actualitzaci
   bolModeFormActualitzacio = 0
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - UndoChanges"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariAmbLlista()
'----------------------------------------------------------------------------------------------
' Quan es fa clic a la llista,
' es refresquen les dades del formulari amb el tipus de manteniment escollit de la llista
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariAmbLlista()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariAmbLlista"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'**********************************************************************************************
'-- Funcions que no sn de nivell superior
'**********************************************************************************************

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariActualitzacio()
'----------------------------------------------------------------------------------------------
' Refresca el formulari desprs d'una actualitzaci
' Posa en la llista de tipus de manteniment en el camp corresponent
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariActualitzacio()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Omple la llista de tipus de manteniment
   Me.lstManteniments.Clear
   If rstRecordsetActual.RecordCount > 0 Then
      rstRecordsetActual.MoveFirst
      Do While Not rstRecordsetActual.EOF
         Me.lstManteniments.AddItem rstRecordsetActual!CodTipusManteniment
         Me.lstManteniments.ItemData(lstManteniments.NewIndex) = _
          rstRecordsetActual.AbsolutePosition
         rstRecordsetActual.MoveNext
      Loop
      Me.lstManteniments.ListIndex = 0
   End If
 
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariActualitzacio"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariLectura()
'----------------------------------------------------------------------------------------------
' Refresca el formulari desprs d'una lectura
' Concretament, refresca els camps segons el tipus de manteniment seleccionat
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariLectura()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Mou el recordset fins al nmero de registre seleccionat des del Listbox
   If rstRecordsetActual.RecordCount > 0 And Me.lstManteniments.ListCount > 0 Then
      rstRecordsetActual.Move Me.lstManteniments.ItemData(Me.lstManteniments.ListIndex) _
       - 1, adBookmarkFirst
   End If

   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariLectura"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- PropagaCanvisABD
'----------------------------------------------------------------------------------------------
' Guarda els canvis que s'han fet sobre el Recordset
' a la Base de Dades
'----------------------------------------------------------------------------------------------
Private Sub PropagaCanvisABD()
   Dim strCadenaValidacio  As String
   Dim StrCadenaXML As String
   Dim bolResultat As Boolean
   Dim StrXMLDades As String
   Dim strXMLCanvis As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
             
   'Desenllaa per tal que es copi b el Recordset
   objFuncionsComuns.DeslinkControls Me
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Obte la cadena XML corresponent al recordset actual
   StrCadenaXML = objFuncionsComuns.PassaRecordsetAXML(rstRecordsetActual)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Obt noms les actualitzacions de la cadena XML
   strXMLCanvis = objFuncionsComuns.ObteActualitzacionsDeXML(StrCadenaXML)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es graven els canvis a la base de dades
   bolResultat = objClasseSuportActual.SaveManteniment(strXMLCanvis)
   If objClasseSuportActual.NumError <> ctintErrorOK Then
      UbicacioError = objClasseSuportActual.UbicacioError
      Err.Raise objClasseSuportActual.NumError
   End If
    
   'Refresca la informacio del Recordset
   RecuperaManteniments
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
       
   objFuncionsComuns.LinkControls Me 'Torna a enllaar-se les dades
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - PropagaCanvisABD"
   objFuncionsComuns.LinkControls Me
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- RecuperaManteniments()
'----------------------------------------------------------------------------------------------
' Crea un recordset amb la mateixa informaci que el recordset actual
' per que no t cap actualitzaci pendent
'----------------------------------------------------------------------------------------------
Public Sub RecuperaManteniments()
   Dim strResultat As String
   Dim rstTemp As ADODB.Recordset
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Si es tracta del comenament del formulari o d'una inserci
   If bolModeFormActualitzacio = 0 Or bolModeFormActualitzacio = 1 Then
      'Es recuperen els manteniments mitjanant la classe SvrManteniments
      strResultat = objClasseSuportActual.GetManteniments()

      If objClasseSuportActual.NumError <> ctintErrorOK Then
         UbicacioError = objClasseSuportActual.UbicacioError
         Err.Raise objClasseSuportActual.NumError
      End If
   Else
      'En cas de modificaci o esborrat, es purguen les actualitzacions
      'del recordset perqu no cal accedir a les capes inferiors
      strResultat = objFuncionsComuns.PurgaActualitzacionsRecordset(rstRecordsetActual)
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
   End If
    
   'Si no hi ha hagut errors, crea el Recordset a partir de l'XML
   Set rstRecordsetActual = objFuncionsComuns.PassaXMLARecordset(strResultat)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RecuperaManteniments"
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- CadenaValidacioRegistreActual()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per guardar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioRegistreActual()
   Dim bolCampRepetit As Boolean
   Dim strCodiMissatge As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""

   'Mira que s'omplin tots els camps
     
   If rstRecordsetActual.RecordCount > 0 And (Me.txtNomManteniment.Text = "") Then
      strCodiMissatge = "valCodiMantenimentBuit"
   Else
      'Mira que no hi hagi un altre registre amb el mateix nom
      bolCampRepetit = objFuncionsComuns.ValorCampRepetit(rstRecordsetActual, "CodTipusManteniment")
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
      
      If bolCampRepetit Then
         strCodiMissatge = "valRepetitCodiManteniment"
      Else
         strCodiMissatge = ""
      End If
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioRegistreActual = strResultat
   Exit Function
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioRegistreActual"
   CadenaValidacioRegistreActual = ""
   Exit Function
   
End Function
   

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioEliminar()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per eliminar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioEliminar()
   Dim bolMantenimentAmbProjectes As Boolean
   Dim strCodiMissatge As String
   Dim strResultat As String

   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
  
   If rstRecordsetActual.RecordCount = 0 Then
      strCodiMissatge = "valNoRegistresEliminar"
   Else
      
      bolMantenimentAmbProjectes = (objFuncionsComuns.ComptaAparicionsValorEnRecordset _
       (rstRecordsetProjectes, "NumTipusManteniment", _
       rstRecordsetActual!NumTipusManteniment) > 0)
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
      
      If bolMantenimentAmbProjectes Then
         strCodiMissatge = "valMantenimentAmbProjecte"
      Else
         strCodiMissatge = ""
      End If
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioEliminar = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioEliminar"
   CadenaValidacioEliminar = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioEditar()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per eliminar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioEditar()

   Dim strCodiMissatge As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
     
   If rstRecordsetActual.RecordCount = 0 Then
      strCodiMissatge = "valNoRegistresEditar"
   Else
      strCodiMissatge = ""
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioEditar = strResultat
   Exit Function
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioEditar"
   CadenaValidacioEditar = ""
   Exit Function
End Function
