VERSION 5.00
Object = "{F0D2F211-CCB0-11D0-A316-00AA00688B10}#1.0#0"; "MSDATLST.OCX"
Begin VB.Form frmProjectes 
   Caption         =   "frmProjectes"
   ClientHeight    =   5580
   ClientLeft      =   4620
   ClientTop       =   2070
   ClientWidth     =   7890
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form2"
   ScaleHeight     =   5580
   ScaleWidth      =   7890
   Begin VB.TextBox txtSituacio 
      DataField       =   "Situacio"
      Height          =   375
      Left            =   3000
      TabIndex        =   11
      Top             =   2400
      Width           =   4455
   End
   Begin VB.TextBox txtNomResumit 
      DataField       =   "NomResumit"
      Height          =   375
      Left            =   3000
      TabIndex        =   10
      Top             =   1680
      Width           =   4455
   End
   Begin VB.TextBox txtNomProjecte 
      DataField       =   "NomProjecte"
      Height          =   375
      Left            =   3000
      TabIndex        =   9
      Top             =   960
      Width           =   4455
   End
   Begin VB.CommandButton cmdSortir 
      Caption         =   "cmdSortir"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   6240
      TabIndex        =   8
      Top             =   4920
      Width           =   1095
   End
   Begin VB.CommandButton cmdManteniment 
      Caption         =   ">"
      Height          =   375
      Left            =   7440
      TabIndex        =   2
      Top             =   3840
      Width           =   255
   End
   Begin VB.CommandButton cmdClients 
      Caption         =   ">"
      Height          =   375
      Left            =   7440
      TabIndex        =   1
      Top             =   3120
      Width           =   255
   End
   Begin VB.ListBox lstProjectes 
      Height          =   3900
      ItemData        =   "frmProjectes.frx":0000
      Left            =   240
      List            =   "frmProjectes.frx":0007
      Sorted          =   -1  'True
      TabIndex        =   0
      Top             =   600
      Width           =   2295
   End
   Begin MSDataListLib.DataCombo cboNumClient 
      DataField       =   "NumClient"
      Height          =   360
      Left            =   3000
      TabIndex        =   18
      Top             =   3120
      Width           =   4455
      _ExtentX        =   7858
      _ExtentY        =   635
      _Version        =   393216
      MatchEntry      =   -1  'True
      ListField       =   "NomClient"
      BoundColumn     =   "NumClient"
      Text            =   ""
   End
   Begin MSDataListLib.DataCombo cboNumTipusManteniment 
      DataField       =   "NumTipusManteniment"
      Height          =   360
      Left            =   3000
      TabIndex        =   19
      Top             =   3840
      Width           =   4455
      _ExtentX        =   7858
      _ExtentY        =   635
      _Version        =   393216
      ListField       =   "CodTipusManteniment"
      BoundColumn     =   "NumTipusManteniment"
      Text            =   ""
   End
   Begin VB.CommandButton cmdEditar 
      Caption         =   "cmdEditar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4035
      TabIndex        =   4
      Top             =   4920
      Width           =   975
   End
   Begin VB.CommandButton cmdEliminar 
      Caption         =   "cmdEliminar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5025
      TabIndex        =   6
      Top             =   4920
      Width           =   1215
   End
   Begin VB.CommandButton cmdNou 
      Caption         =   "cmdNou"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2925
      TabIndex        =   3
      Top             =   4920
      Width           =   1095
   End
   Begin VB.CommandButton cmdSortirEdicio 
      Caption         =   "cmdSortirEdicio"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   3825
      TabIndex        =   5
      Top             =   4920
      Width           =   1215
   End
   Begin VB.CommandButton cmdDesferCanvis 
      Caption         =   "cmdDesferCanvis"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5040
      TabIndex        =   7
      Top             =   4920
      Width           =   1215
   End
   Begin VB.Label lblLlistaProjectes 
      Caption         =   "lblLlistaProjectes"
      Height          =   255
      Left            =   240
      TabIndex        =   17
      Top             =   360
      Width           =   2535
   End
   Begin VB.Label lblNumClient 
      Caption         =   "lblNumClient"
      Height          =   255
      Left            =   3000
      TabIndex        =   16
      Top             =   2880
      Width           =   4695
   End
   Begin VB.Label lblSituacio 
      Caption         =   "lblSituacio"
      Height          =   255
      Left            =   3000
      TabIndex        =   15
      Top             =   2160
      Width           =   4455
   End
   Begin VB.Label lblTipusManteniment 
      Caption         =   "lblTipusManteniment"
      Height          =   255
      Left            =   3000
      TabIndex        =   14
      Top             =   3600
      Width           =   4695
   End
   Begin VB.Label lblNomResumit 
      Caption         =   "lblNomResumit"
      Height          =   255
      Left            =   3000
      TabIndex        =   13
      Top             =   1440
      Width           =   4455
   End
   Begin VB.Label lblNomProjecte 
      Caption         =   "lblNomProjecte"
      Height          =   255
      Left            =   3000
      TabIndex        =   12
      Top             =   720
      Width           =   4455
   End
End
Attribute VB_Name = "frmProjectes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

'Serveix per accedir a les propietats i mtodes de la classe SvrProjectes

Public objClasseSuportActual As GIMSuport.SvrProjectes
Private objFuncionsComuns As clsFuncionsCapaInterficie

Public rstRecordsetActual As ADODB.Recordset 'Recordset que es mostra al formulari
Public rstRecordsetClients As ADODB.Recordset 'Recordset que cont la llista de clients
Public rstRecordsetZones As ADODB.Recordset 'Recordset que cont la llista de zones
Public rstRecordsetTipusManteniment As ADODB.Recordset 'Cont els tipus de manteniment
Public rstRecordsetIdioma As New ADODB.Recordset 'Cont els textos de l'idioma

Private strCadenaXMLTemporal As String
Private bolAuxModeFormEdicio As Boolean 'Mode d'Edicio del formulari
Private bolModeFormActualitzacio As Integer 'Mode d'Actualitzaci del formulari
   '0 - sense actualitzaci, 1 - nou, 2- esborrar i modificar

'**********************************************************************************************
'-- Funcions d'implementaci de propietats
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Property Let i Get bolModeFormEdicio()
'----------------------------------------------------------------------------------------------
' Implementa la variable ModeFormEdici que indica si el formulari es troba en mode d'edici o
' de consulta. Cada cop que canvia el mode, s'executa el procediment RefreshModeFormEdicio
'----------------------------------------------------------------------------------------------
Private Property Get bolModeFormEdicio() As Long
   bolModeFormEdicio = bolAuxModeFormEdicio
End Property

Private Property Let bolModeFormEdicio(ByVal RHS As Long)
   RefreshModeFormEdicio (RHS)
   bolAuxModeFormEdicio = RHS
End Property

'**********************************************************************************************
'-- Events del formulari i dels controls
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Form_Load
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Load()
   IniciFormulari
End Sub
'----------------------------------------------------------------------------------------------
'-- Form_Terminate
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Terminate()
   FiFormulari
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdNou_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdNou
' Crida a una funci per inserir-hi un registre nou
'----------------------------------------------------------------------------------------------
Private Sub cmdNou_Click()
   Nou
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdEditar_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdEditar
' Crida a una funci per editar el registre que es mostra per pantalla
'----------------------------------------------------------------------------------------------
Private Sub cmdEditar_Click()
   Editar
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdEliminar_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdEliminar
' Crida a una funci per eliminar el registre que es mostra per pantalla
'----------------------------------------------------------------------------------------------
Private Sub cmdEliminar_Click()
   Eliminar
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdSortir_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdSortir
' Crida a una funci per sortir del formulari
'----------------------------------------------------------------------------------------------
Private Sub cmdSortir_Click()
   Sortir
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdSortirEdicio_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdSortirEdicio
' Crida a una funci per sortir del mode d'edici i guardar els canvis
'----------------------------------------------------------------------------------------------
Private Sub cmdSortirEdicio_Click()
   SortirEdicio
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdDesferCanvis_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdDesferCanvis
' Crida a una funci per sortir del mode d'edici sense guardar els canvis
'----------------------------------------------------------------------------------------------
Private Sub cmdDesferCanvis_Click()
   UndoChanges
End Sub

'----------------------------------------------------------------------------------------------
'-- lstProjectes_Click()
'----------------------------------------------------------------------------------------------
' S'executa quan es fa clic a la llista de projectes
'----------------------------------------------------------------------------------------------
Private Sub lstProjectes_Click()
   RefrescaFormulariAmbLlista
End Sub
'----------------------------------------------------------------------------------------------
'-- Events de DataCombo
'----------------------------------------------------------------------------------------------
' Ja que el datacombo de Microsoft no actualitza convenientment les dades
' Ho hem de fer per programaci amd els segents events
'----------------------------------------------------------------------------------------------
Private Sub cboNumClient_LostFocus()
   FixaDataCombo Me.cboNumClient
End Sub
Private Sub cboNumClient_Validate(Cancel As Boolean)
   Me.cboNumClient.DataChanged = False
End Sub
Private Sub cboNumTipusManteniment_LostFocus()
   FixaDataCombo Me.cboNumTipusManteniment
End Sub
Private Sub cboNumTipusManteniment_Validate(Cancel As Boolean)
   Me.cboNumTipusManteniment.DataChanged = False
End Sub


'**********************************************************************************************
'-- Funcions de nivell superior
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- RefreshModeFormEdicio
'----------------------------------------------------------------------------------------------
' S'executa cada vegada que s'assigna la variable RefreshModeFormEdicio
' Habilita o deshabilita els butons i els controls d'entrada segons el valor de la variable
'----------------------------------------------------------------------------------------------
Private Sub RefreshModeFormEdicio(bolModeFormulari As Boolean)

   Dim ctrDades As Control
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
      
   'Fa visible els botons corresponents a cada mode del formulari
   Me.cmdNou.Visible = (Not bolModeFormulari)
   Me.cmdEditar.Visible = (Not bolModeFormulari)
   Me.cmdEliminar.Visible = (Not bolModeFormulari)
   Me.cmdSortir.Visible = (Not bolModeFormulari)
   Me.cmdSortirEdicio.Visible = bolModeFormulari
   Me.cmdDesferCanvis.Visible = bolModeFormulari
     
   'Si estem en mode d'edici, habilita els controls d'entrada de dades i, si no,
   'els deshabilita
   For Each ctrDades In Me.Controls
      If TypeName(ctrDades) = "TextBox" Or TypeName(ctrDades) = "ComboBox" Or _
       TypeName(ctrDades) = "DataCombo" Then
         ctrDades.Locked = (Not bolModeFormulari)
      End If
   Next ctrDades
   
   Me.lstProjectes.Enabled = Not bolModeFormulari
   
   Exit Sub
    
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefreshModeFormEdicio"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- IniciFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques d'inicialitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub IniciFormulari()
   Dim lngComptador As Long
  
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
 
   'Crea una instncia de les classes SvrProjectes i objFuncionsComuns
   'per utilitzar-ne els mtodes i propietats
   Set objFuncionsComuns = New clsFuncionsCapaInterficie
   Set objClasseSuportActual = objFuncionsComuns.CreaObjecteSuport("SvrProjectes")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
      
   'Recupera els textos del formulari traduts a l'idioma per defecte
   
   Set rstRecordsetIdioma = objFuncionsComuns.TradueixFormulariIdioma(Me, Sistema.Idioma)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
      
   'No estem en mode d'actualitzaci
   bolModeFormActualitzacio = 0
    
    'Recupera els clients i els posa en un recordset
   strCadenaXMLTemporal = objClasseSuportActual.GetClients()
   If objClasseSuportActual.NumError <> ctintErrorOK Then
      UbicacioError = objClasseSuportActual.UbicacioError
      Err.Raise objClasseSuportActual.NumError
   End If
   
   Set rstRecordsetClients = objFuncionsComuns.PassaXMLARecordset(strCadenaXMLTemporal)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   
   'Recupera els tipus de manteniments i els posa en un recordset
   strCadenaXMLTemporal = objClasseSuportActual.GetTipusManteniment()
   If objClasseSuportActual.NumError <> ctintErrorOK Then
      UbicacioError = objClasseSuportActual.UbicacioError
      Err.Raise objClasseSuportActual.NumError
   End If
   
   Set rstRecordsetTipusManteniment = objFuncionsComuns. _
    PassaXMLARecordset(strCadenaXMLTemporal)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Recupera els projectes de la BD
   RecuperaProjectes
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
      
   'Enllaa els controls al recordset acabat de crear
   objFuncionsComuns.LinkControls Me
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Emplena les llistes dels quadres combinats
   Set cboNumClient.RowSource = rstRecordsetClients
   Set cboNumTipusManteniment.RowSource = rstRecordsetTipusManteniment
   
   'Refresca el formulari per tal que s'hi vegi el seu estat actualitzat
   RefrescaFormulariActualitzacio
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   
   'Posa el formulari en mode de consulta (no edici)
   bolModeFormEdicio = False
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - IniciFormulari"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- FiFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques de finalitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub FiFormulari()
   'Allibera les instncies de les classes
   Set objClasseSuportActual = Nothing
   Set objFuncionsComuns = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- Nou
'----------------------------------------------------------------------------------------------
' Crea un registre en blanc per editar un nou registre
'----------------------------------------------------------------------------------------------

Private Sub Nou()
   Dim strCadenaValidacio  As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es fixa el mode d'actualitzaci
   bolModeFormActualitzacio = 1
    
   'Afegeix un registre nou al recordset
   rstRecordsetActual.AddNew
        
   'Posa el formulari en mode d'edici
   bolModeFormEdicio = True
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Nou"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Editar
'----------------------------------------------------------------------------------------------
' Posa el formulari en mode d'edici
'----------------------------------------------------------------------------------------------
Private Sub Editar()
   Dim strCadenaValidacio As String
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
       
    
   strCadenaValidacio = CadenaValidacioEditar()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
       MsgBox (strCadenaValidacio)
   Else
       'Posa el mode d'edici a cert
       bolModeFormEdicio = True
       'Es fixa el mode d'actualitzaci
       bolModeFormActualitzacio = 2
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Editar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- Eliminar
'----------------------------------------------------------------------------------------------
' Elimina el registre actual de la base de dades
'----------------------------------------------------------------------------------------------
Private Sub Eliminar()
   Dim bolResultat As Boolean
   Dim strCadenaValidacio  As String
   Dim strTextValidacioEliminar As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
       
    
   'Mira si es pot eliminar el registre i, si s aix, l'elimina. Altrament emet un error
   strCadenaValidacio = CadenaValidacioEliminar()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
      MsgBox (strCadenaValidacio)
   Else
      'Recupera els textos traduits per omplir el textbox que indica el nmero de registre
      strTextValidacioEliminar = objFuncionsComuns.TradueixDefecteMissatgeFormulariIdioma _
       (rstRecordsetIdioma, "valTextEliminar", "valTextEliminar")
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
         
      If MsgBox(strTextValidacioEliminar, vbYesNo) = vbYes Then
      
         'Es fixa el mode d'actualitzaci
         bolModeFormActualitzacio = 2
      
         'Esborra el registre del recordset actual i propaga els canvis a la BD
         rstRecordsetActual.Delete
      
         'Propaga els canvis a la BD
         PropagaCanvisABD
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
   
         'Refresca el formulari desprs d'una actualitzaci
         RefrescaFormulariActualitzacio
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
         
         'Es fixa el mode d'actualitzaci
         bolModeFormActualitzacio = 0
      End If
   End If
        
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Eliminar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Sortir
'----------------------------------------------------------------------------------------------
' Surt del formulari
'----------------------------------------------------------------------------------------------
Private Sub Sortir()
   Unload Me
End Sub
'----------------------------------------------------------------------------------------------
'-- SortirEdicio
'----------------------------------------------------------------------------------------------
'Si els canvis realitzats durant l'edici sn vlids, surt del mode d'edici
'Si no, emet un missatge d'error
'---------------------------------------------------------------------------------------------
Private Sub SortirEdicio()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   Dim strCadenaValidacio As String
    
   'Mira si el registre que acabem d'introduir s vlid
   strCadenaValidacio = CadenaValidacioRegistreActual()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
      MsgBox (strCadenaValidacio)
   Else
      'Si ho s, fa un Update i propaga els canvis a la BD
      If rstRecordsetActual.RecordCount > 0 Then
         rstRecordsetActual.Update
                  
         'Propaga el canvi a la BD
         PropagaCanvisABD
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
            
         'Refresca el formulari desprs d'una actualitzaci
         RefrescaFormulariActualitzacio
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
   
      End If
      'Posa el mode d'edici a fals
      bolModeFormEdicio = False
        
      'Es fixa el mode d'actualitzaci
      bolModeFormActualitzacio = 0
    End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - SortirEdicio"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- UndoChanges
'----------------------------------------------------------------------------------------------
' Desf els canvis produts amb el mode d'edici
'----------------------------------------------------------------------------------------------
Private Sub UndoChanges()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   
   'Cancella l'Update i refresca el formulari
   rstRecordsetActual.CancelUpdate
   
   'Refresca el formulari desprs d'una actualitzaci
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
      
   RefrescaFormulariActualitzacio
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   bolModeFormEdicio = False
   
   'Es fixa el mode d'actualitzaci
   bolModeFormActualitzacio = 0
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - UndoChanges"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariAmbLlista()
'----------------------------------------------------------------------------------------------
' Quan es fa clic a la llista,
' es refresquen les dades del formulari amb el projecte escollit de la llista
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariAmbLlista()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
  
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariAmbLlista"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- FixaDataCombo
'----------------------------------------------------------------------------------------------
' Fixa les dades d'un data combo
'----------------------------------------------------------------------------------------------
Private Sub FixaDataCombo(ctrDataCombo As Control)
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   If ctrDataCombo.MatchedWithList Then
      If Not rstRecordsetActual.EOF Then
         rstRecordsetActual.Fields(ctrDataCombo.DataField) = Val(ctrDataCombo.BoundText)
      End If
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - FixaDataCombo"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'**********************************************************************************************
'-- Funcions que no sn de nivell superior
'**********************************************************************************************

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariActualitzacio()
'----------------------------------------------------------------------------------------------
' Refresca el formulari desprs d'una actualitzaci
' Posa en la llista de projectes en el camp corresponent
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariActualitzacio()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Omple la llista de projectes
   Me.lstProjectes.Clear
   If rstRecordsetActual.RecordCount > 0 Then
      rstRecordsetActual.MoveFirst
      Do While Not rstRecordsetActual.EOF
         Me.lstProjectes.AddItem rstRecordsetActual!NomResumit
         Me.lstProjectes.ItemData(lstProjectes.NewIndex) = _
          rstRecordsetActual.AbsolutePosition
         rstRecordsetActual.MoveNext
      Loop
      Me.lstProjectes.ListIndex = 0
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariActualitzacio"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariLectura()
'----------------------------------------------------------------------------------------------
' Refresca el formulari desprs d'una lectura
' Concretament, refresca els camps segons el projecte seleccionat
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariLectura()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Mou el recordset fins al nmero de registre seleccionat des del Listbox
   If rstRecordsetActual.RecordCount > 0 And Me.lstProjectes.ListCount > 0 Then
      rstRecordsetActual.Move Me.lstProjectes.ItemData(Me.lstProjectes.ListIndex) - 1, _
       adBookmarkFirst
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariLectura"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- PropagaCanvisABD
'----------------------------------------------------------------------------------------------
' Guarda els canvis que s'han fet sobre el Recordset
' a la Base de Dades
'----------------------------------------------------------------------------------------------
Private Sub PropagaCanvisABD()
   Dim strCadenaValidacio  As String
   Dim StrCadenaXML As String
   Dim bolResultat As Boolean
   Dim StrXMLDades As String
   Dim strXMLCanvis As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
             
   'Desenllaa per tal que es copi b el Recordset
   objFuncionsComuns.DeslinkControls Me
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Obte la cadena XML corresponent al recordset actual
   StrCadenaXML = objFuncionsComuns.PassaRecordsetAXML(rstRecordsetActual)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Obt noms les actualitzacions de la cadena XML
   strXMLCanvis = objFuncionsComuns.ObteActualitzacionsDeXML(StrCadenaXML)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es graven els canvis a la base de dades
   bolResultat = objClasseSuportActual.SaveProjecte(strXMLCanvis)
   If objClasseSuportActual.NumError <> ctintErrorOK Then
      UbicacioError = objClasseSuportActual.UbicacioError
      Err.Raise objClasseSuportActual.NumError
   End If
    
   'Refresca la informacio del Recordset
   RecuperaProjectes
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
       
   objFuncionsComuns.LinkControls Me 'Torna a enllaar-se les dades
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - PropagaCanvisABD"
   objFuncionsComuns.LinkControls Me
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- RecuperaProjectes()
'----------------------------------------------------------------------------------------------
' Crea un recordset amb la mateixa informaci que el recordset actual
' per que no t cap actualitzaci pendent
'----------------------------------------------------------------------------------------------
Public Sub RecuperaProjectes()
   Dim strResultat As String
   Dim rstTemp As ADODB.Recordset
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Si es tracta del comenament del formulari o d'una inserci
   If bolModeFormActualitzacio = 0 Or bolModeFormActualitzacio = 1 Then
      'Es recuperen els projectes mitjanant la classe SvrProjectes
      strResultat = objClasseSuportActual.GetProjectes()
      
      If objClasseSuportActual.NumError <> ctintErrorOK Then
         UbicacioError = objClasseSuportActual.UbicacioError
         Err.Raise objClasseSuportActual.NumError
      End If
   Else
      'En cas de modificaci o esborrat, es purguen les actualitzacions
      'del recordset perqu no cal accedir a les capes inferiors
      strResultat = objFuncionsComuns.PurgaActualitzacionsRecordset(rstRecordsetActual)
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
   End If
    
   'Si no hi ha hagut errors, crea el Recordset a partir de l'XML
   Set rstRecordsetActual = objFuncionsComuns.PassaXMLARecordset(strResultat)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RecuperaProjectes"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioRegistreActual()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per guardar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioRegistreActual()
   Dim bolCampRepetit As Boolean
   Dim strCodiMissatge As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
     
   'Mira que s'omplin tots els camps
   If rstRecordsetActual.RecordCount > 0 And (Me.txtNomProjecte.Text = "" Or _
          Me.txtNomResumit.Text = "" Or Me.txtSituacio.Text = "" Or _
          Me.cboNumClient.Text = "" Or Me.cboNumTipusManteniment.Text = "") Then
            strCodiMissatge = "valAlgunCampBuit"
   Else
      If Not Me.cboNumClient.MatchedWithList Then
         strCodiMissatge = "valNoClientEnLlista"
      Else
         If Not Me.cboNumTipusManteniment.MatchedWithList Then
            strCodiMissatge = "valNoTipusMantenimentEnLlista"
         Else
            'Mira que no hi hagi un altre registre amb el mateix nom
            bolCampRepetit = objFuncionsComuns.ValorCampRepetit(rstRecordsetActual, "NomProjecte")
            If objFuncionsComuns.NumError <> ctintErrorOK Then
               UbicacioError = objFuncionsComuns.UbicacioError
               Err.Raise objFuncionsComuns.NumError
            End If
      
            If bolCampRepetit Then
               strCodiMissatge = "valRepetitNomProjecte"
            Else
               'Mira que no hi hagi un altre registre amb el mateix nom resumit
               bolCampRepetit = objFuncionsComuns.ValorCampRepetit(rstRecordsetActual, "NomResumit")
               If objFuncionsComuns.NumError <> ctintErrorOK Then
                  UbicacioError = objFuncionsComuns.UbicacioError
                  Err.Raise objFuncionsComuns.NumError
               End If
         
               If bolCampRepetit Then
                  strCodiMissatge = "valRepetitNomResumit"
               Else
                  strCodiMissatge = ""
               End If
            End If
         End If
      End If
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioRegistreActual = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioRegistreActual"
   CadenaValidacioRegistreActual = ""
   Exit Function
End Function
   

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioEliminar()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per eliminar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioEliminar()
   Dim strCodiMissatge As String
   Dim strResultat As String
   Dim bolProjecteAmbZones As Boolean
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   If rstRecordsetActual.RecordCount = 0 Then
      strCodiMissatge = "valNoRegistresEliminar"
   Else
      'Recupera les zones i les posa en un recordset
      strCadenaXMLTemporal = objClasseSuportActual.GetZones(rstRecordsetActual!NumProjecte)
      If objClasseSuportActual.NumError <> ctintErrorOK Then
         UbicacioError = objClasseSuportActual.UbicacioError
         Err.Raise objClasseSuportActual.NumError
      End If
      
      Set rstRecordsetZones = objFuncionsComuns. _
       PassaXMLARecordset(strCadenaXMLTemporal)
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
      
      'No deu esborrar si el projecte t zones associades
      If rstRecordsetZones.RecordCount > 0 Then
         strCodiMissatge = "valProjecteAmbZones"
      Else
         strCodiMissatge = ""
      End If
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Retorna el text tradut
   CadenaValidacioEliminar = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioEliminar"
   CadenaValidacioEliminar = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioEditar()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per eliminar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioEditar()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   Dim strCodiMissatge As String
   Dim strResultat As String
   
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   
   If rstRecordsetActual.RecordCount = 0 Then
      strCodiMissatge = "valNoRegistresEditar"
   Else
      strCodiMissatge = ""
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioEditar = strResultat
   Exit Function
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioEditar"
   CadenaValidacioEditar = ""
   Exit Function
End Function

