VERSION 5.00
Object = "{F0D2F211-CCB0-11D0-A316-00AA00688B10}#1.0#0"; "MSDATLST.OCX"
Begin VB.Form frmPropietatsTerra 
   Caption         =   "frmPropietatsTerra"
   ClientHeight    =   3825
   ClientLeft      =   3060
   ClientTop       =   2370
   ClientWidth     =   8760
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   3825
   ScaleWidth      =   8760
   Begin VB.Frame fraPatroTerra 
      Caption         =   "fraPatroTerra"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   3015
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   8535
      Begin VB.TextBox txtObservacions 
         DataField       =   "Observacions"
         Height          =   855
         Left            =   240
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   7
         Tag             =   "frmFormulariQueCrida.rstRecordsetActual"
         Top             =   1800
         Width           =   8055
      End
      Begin VB.CommandButton cmdSeccio 
         Caption         =   ">"
         Height          =   375
         Left            =   2760
         TabIndex        =   5
         Top             =   720
         Width           =   255
      End
      Begin VB.CommandButton cmdTipus 
         Caption         =   ">"
         Height          =   375
         Left            =   2760
         TabIndex        =   6
         Top             =   1080
         Width           =   255
      End
      Begin VB.TextBox txtCodi 
         DataField       =   "CodSPTerra"
         Height          =   375
         Left            =   1080
         TabIndex        =   10
         Tag             =   "frmFormulariQueCrida.rstRecordsetActual"
         Top             =   360
         Width           =   1695
      End
      Begin MSDataListLib.DataCombo cmbTipus 
         DataField       =   "NumTerraCable"
         Height          =   360
         Left            =   1080
         TabIndex        =   11
         Tag             =   "frmFormulariQueCrida.rstRecordsetActual"
         Top             =   1080
         Width           =   1695
         _ExtentX        =   2990
         _ExtentY        =   635
         _Version        =   393216
         ListField       =   "CodTerraCable"
         BoundColumn     =   "NumTerraCable"
         Text            =   ""
      End
      Begin MSDataListLib.DataCombo cmbSeccio 
         DataField       =   "NumTerraSeccio"
         Height          =   360
         Left            =   1080
         TabIndex        =   12
         Tag             =   "frmFormulariQueCrida.rstRecordsetActual"
         Top             =   720
         Width           =   1695
         _ExtentX        =   2990
         _ExtentY        =   635
         _Version        =   393216
         ListField       =   "CodSeccioCable"
         BoundColumn     =   "NumSeccioCable"
         Text            =   ""
      End
      Begin VB.Label lblCodi 
         AutoSize        =   -1  'True
         Caption         =   "lblCodi"
         Height          =   240
         Left            =   240
         TabIndex        =   9
         Top             =   360
         Width           =   630
      End
      Begin VB.Label lblObservacions 
         AutoSize        =   -1  'True
         Caption         =   "lblObservacions"
         Height          =   240
         Left            =   240
         TabIndex        =   8
         Top             =   1560
         Width           =   1470
      End
      Begin VB.Label lblTipus 
         AutoSize        =   -1  'True
         Caption         =   "lblTipus"
         Height          =   240
         Left            =   240
         TabIndex        =   4
         Top             =   1080
         Width           =   720
      End
      Begin VB.Label lblSeccio 
         AutoSize        =   -1  'True
         Caption         =   "lblSeccio"
         Height          =   240
         Left            =   240
         TabIndex        =   3
         Top             =   720
         Width           =   840
      End
   End
   Begin VB.CommandButton cmdCancellar 
      Caption         =   "cmdCancellar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   7440
      TabIndex        =   0
      Top             =   3240
      Width           =   1215
   End
   Begin VB.CommandButton cmdAcceptar 
      Caption         =   "cmdAcceptar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   6240
      TabIndex        =   2
      Top             =   3240
      Width           =   1215
   End
End
Attribute VB_Name = "frmPropietatsTerra"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

Public rstRecordsetIdioma As ADODB.Recordset 'Recordset amb les textos tradus del formulari

Public frmFormulariQueCrida As GIM.frmPatronsTerra
Private objFuncionsComuns As clsFuncionsCapaInterficie

'**********************************************************************************************
'-- Events del formulari i dels controls
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Form_Load
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Load()
   IniciFormulari
End Sub

Private Sub cmdAcceptar_Click()
   Acceptar
End Sub

Private Sub cmdCancellar_Click()
   Cancellar
End Sub

'**********************************************************************************************
'-- Funcions d'obertura de taules auxiliars
'**********************************************************************************************

Private Sub cmdSeccio_Click()
   ObreFormulariTaulaAuxiliar Me.cmbSeccio, "TT_SeccioCable", "NumSeccioCable", _
    "CodSeccioCable", "TSP_Terra, NumTerraSeccio"
   Me.frmFormulariQueCrida.bolTaulesAuxiliarsCanviades = True
End Sub

Private Sub cmdTipus_Click()
   ObreFormulariTaulaAuxiliar Me.cmbTipus, "TTS_PresaTerra", "NumTerraCable", _
    "CodTerraCable", "TSP_Terra, NumTerraCable"
   Me.frmFormulariQueCrida.bolTaulesAuxiliarsCanviades = True
End Sub

'----------------------------------------------------------------------------------------------
'-- Events de DataCombo
'----------------------------------------------------------------------------------------------
' Ja que el datacombo de Microsoft no actualitza convenientment les dades
' Ho hem de fer per programaci amd els segents events
'----------------------------------------------------------------------------------------------
Private Sub cmbTipus_Click(Area As Integer)
   FixaDataCombo Me.cmbTipus
End Sub
Private Sub cmbTipus_Validate(Cancel As Boolean)
   Me.cmbTipus.DataChanged = False
End Sub
Private Sub cmbSeccio_Click(Area As Integer)
   FixaDataCombo Me.cmbSeccio
End Sub
Private Sub cmbSeccio_Validate(Cancel As Boolean)
   Me.cmbSeccio.DataChanged = False
End Sub

'**********************************************************************************************
'-- Events de nivell superior
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- IniciFormulari
'----------------------------------------------------------------------------------------------
' S'executa quan s'obre el formulari
'----------------------------------------------------------------------------------------------

Private Sub IniciFormulari()
   Dim lngComptador As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Mentre no es digui el contrari, no s'han canviat les taules
   Me.frmFormulariQueCrida.bolTaulesAuxiliarsCanviades = False
   Me.frmFormulariQueCrida.bolTaulaPrincipalCanviada = False
   
   'Crea una instncia de les classes SvrUsuaris i objFuncionsComuns
   'per utilitzar-ne els mtodes i propietats
   Set objFuncionsComuns = New clsFuncionsCapaInterficie
        
   'Recupera els textos del formulari traduts a l'idioma per defecte
   
   Set rstRecordsetIdioma = objFuncionsComuns.TradueixFormulariIdioma(Me, Sistema.Idioma)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Emplena les llistes dels quadres combinats
   Set Me.cmbSeccio.RowSource = Me.frmFormulariQueCrida.rstRecordsetSeccioCable
   Set Me.cmbTipus.RowSource = Me.frmFormulariQueCrida.rstRecordsetTipusCable
   
   
   'Enllaa els controls al recordset acabat de crear
   objFuncionsComuns.LinkControls Me
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Obre una transacci
   objFuncionsComuns.BeginTransaction Me.frmFormulariQueCrida.objClasseSuportActual
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - IniciFormulari"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Acceptar
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdAcceptar
' Surt guardant els canvis
'----------------------------------------------------------------------------------------------
Private Sub Acceptar()
   Dim lngComptador As Long
   Dim strCadenaValidacio As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Mira si el registre que acabem d'introduir s vlid
   strCadenaValidacio = CadenaValidacioRegistreActual()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
      MsgBox (strCadenaValidacio)
   Else
      Me.frmFormulariQueCrida.bolTaulaPrincipalCanviada = True
      Me.frmFormulariQueCrida.rstRecordsetActual.Update
      
      'Acaba la transacci guardant els canvis
      objFuncionsComuns.CommitTransaction Me.frmFormulariQueCrida.objClasseSuportActual
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
      
      Unload Me
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Acceptar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Cancellar
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdCancellar
' Surt sense guardar els canvis
'----------------------------------------------------------------------------------------------
Private Sub Cancellar()
   Dim lngComptador As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'En rigor la segent instrucci no s necessria per
   'ens estalvia tornar a emplenar els combos intilment
   'aix que millora l'eficincia
   Me.frmFormulariQueCrida.bolTaulesAuxiliarsCanviades = False
   Me.frmFormulariQueCrida.rstRecordsetActual.CancelUpdate
   
   'Acaba la transacci sense guardar els canvis
   objFuncionsComuns.RollBackTransaction Me.frmFormulariQueCrida.objClasseSuportActual
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   Unload Me
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Cancellar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub


'----------------------------------------------------------------------------------------------
'-- FixaDataCombo
'----------------------------------------------------------------------------------------------
' Fixa les dades d'un data combo
'----------------------------------------------------------------------------------------------
Private Sub FixaDataCombo(ctrDataCombo As Control)
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   If ctrDataCombo.MatchedWithList Then
      If Not frmFormulariQueCrida.rstRecordsetActual.EOF Then
         frmFormulariQueCrida.rstRecordsetActual.Fields(ctrDataCombo.DataField) = _
          Val(ctrDataCombo.BoundText)
      End If
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - FixaDataCombo"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- ObreFormulariTaulaAuxiliar()
'----------------------------------------------------------------------------------------------
' Obre formulari de taula auxiliar
'----------------------------------------------------------------------------------------------
Private Sub ObreFormulariTaulaAuxiliar(ctrCombo As DataCombo, strNomTaula As String, _
 strCampIntegritat As String, strCampLlista As String, strCadenaIntegritat As String)
 
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
     
   'Obre el formulari
   objFuncionsComuns.ObrirFormulariAuxiliar ctrCombo, strNomTaula, strCampIntegritat, _
    strCampLlista, strCadenaIntegritat, , , strCampIntegritat
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
      
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - ObreFormulariTaulaAuxiliar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioRegistreActual()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per guardar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioRegistreActual()
   Dim bolCampRepetit As Boolean
   Dim strCodiMissatge As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""

   'Mira que s'omplin tots els camps
     
   If frmFormulariQueCrida.rstRecordsetActual.RecordCount > 0 And _
    (Me.txtCodi.Text = "" Or Me.cmbTipus.Text = "" Or _
    Me.cmbSeccio.Text = "") Then
      strCodiMissatge = "valAlgunCampNecessariBuit"
   Else
      'Mira que no hi hagi un altre registre amb el mateix codi
      bolCampRepetit = objFuncionsComuns.ValorCampRepetit(frmFormulariQueCrida.rstRecordsetActual, _
       "CodSPTerra")
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
      
      If bolCampRepetit Then
         strCodiMissatge = "valRepetitCodiSuport"
      Else
         strCodiMissatge = ""
      End If
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioRegistreActual = strResultat
   Exit Function
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioRegistreActual"
   CadenaValidacioRegistreActual = ""
   Exit Function
   
End Function
