VERSION 5.00
Begin VB.Form frmTaulesAuxiliars 
   Caption         =   "frmTaulesAuxiliars"
   ClientHeight    =   5130
   ClientLeft      =   4245
   ClientTop       =   2295
   ClientWidth     =   5670
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   5130
   ScaleWidth      =   5670
   Begin VB.CommandButton cmdNou 
      Caption         =   "cmdNou"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   1080
      TabIndex        =   7
      Top             =   4560
      Width           =   1095
   End
   Begin VB.CommandButton cmdEliminar 
      Caption         =   "cmdEliminar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   3180
      TabIndex        =   6
      Top             =   4560
      Width           =   1215
   End
   Begin VB.CommandButton cmdEditar 
      Caption         =   "cmdEditar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2190
      TabIndex        =   5
      Top             =   4560
      Width           =   975
   End
   Begin VB.CommandButton cmdSortir 
      Caption         =   "cmdSortir"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4395
      TabIndex        =   4
      Top             =   4560
      Width           =   1095
   End
   Begin VB.TextBox txtCodi 
      Height          =   375
      Left            =   120
      TabIndex        =   2
      Top             =   4080
      Width           =   5415
   End
   Begin VB.ListBox lstCodis 
      Height          =   3420
      Left            =   120
      TabIndex        =   1
      Top             =   360
      Width           =   5415
   End
   Begin VB.CommandButton cmdSortirEdicio 
      Caption         =   "cmdSortirEdicio"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   1980
      TabIndex        =   8
      Top             =   4560
      Width           =   1215
   End
   Begin VB.CommandButton cmdDesferCanvis 
      Caption         =   "cmdDesferCanvis"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   3195
      TabIndex        =   9
      Top             =   4560
      Width           =   1215
   End
   Begin VB.Label lblCodi 
      AutoSize        =   -1  'True
      Caption         =   "lblCodi"
      Height          =   240
      Left            =   120
      TabIndex        =   3
      Top             =   3840
      Width           =   630
   End
   Begin VB.Label lblLlistaCodis 
      AutoSize        =   -1  'True
      Caption         =   "lblLlistaCodis"
      Height          =   240
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1200
   End
End
Attribute VB_Name = "frmTaulesAuxiliars"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public strNomTaula As String
Public strCampIntegritat As String 'Camp de Clau Primria
Public strCampLlista As String 'Tamb s el camp d'ordre
Public strCampOrdre As String
Public strNomCampFiltre As String 'Si cont la cadena buida, s que no hi ha filtre
Public lngValorCampFiltre As Long 'Valor del camp per filtrar
Public ctrCombo As Variant

Public colIntegritatReferencial As Collection 'Cont la informaci de les regles d'integritat
                                              'referencial de les taules que estan associades
                                              'per una relaci 1 a N a la que estem editant
Public strFiltreInicial As String
Public frmFormulariQueCrida As Form

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

'Serveix per accedir a les propietats i mtodes de la classe SvrTaulesAuxiliars
Public objClasseSuportActual As GIMSuport.SvrTaulesAuxiliars
Private objFuncionsComuns As clsFuncionsCapaInterficie

Public rstRecordsetActual As ADODB.Recordset 'Recordset que es mostra al formulari
Public rstRecordsetIdioma As ADODB.Recordset 'Recordset amb les textos traduts del formulari
Public strRecordsetActualitzar As String 'Nom del Recordset que cal actualitzar

Private strCadenaXMLTemporal As String
Private bolAuxModeFormEdicio As Boolean 'Mode d'Edicio del formulari
Private bolModeFormActualitzacio As Integer 'Mode d'Actualitzaci del formulari
   '0 - sense actualitzaci, 1 - nou, 2- esborrar i modificar
Private strCodiActualitzacio As String
Private frmFormulariRecordset As Form
Private strRecordsetAEnllacar As String


'**********************************************************************************************
'-- Funcions d'implementaci de propietats
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Property Let i Get bolModeFormEdicio()
'----------------------------------------------------------------------------------------------
' Implementa la variable ModeFormEdici que indica si el formulari es troba en mode d'edici o
' de consulta. Cada cop que canvia el mode, s'executa el procediment RefreshModeFormEdicio
'----------------------------------------------------------------------------------------------
Private Property Get bolModeFormEdicio() As Long
   bolModeFormEdicio = bolAuxModeFormEdicio
End Property

Private Property Let bolModeFormEdicio(ByVal RHS As Long)
   RefreshModeFormEdicio (RHS)
   bolAuxModeFormEdicio = RHS
End Property

'**********************************************************************************************
'-- Events del formulari i dels controls
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Form_Load
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Load()
   IniciFormulari
End Sub
'----------------------------------------------------------------------------------------------
'-- Form_Terminate
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Terminate()
   FiFormulari
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdNou_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdNou
' Crida a una funci per inserir-hi un registre nou
'----------------------------------------------------------------------------------------------
Private Sub cmdNou_Click()
   Nou
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdEditar_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdEditar
' Crida a una funci per editar el registre que es mostra per pantalla
'----------------------------------------------------------------------------------------------
Private Sub cmdEditar_Click()
   Editar
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdEliminar_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdEliminar
' Crida a una funci per eliminar el registre que es mostra per pantalla
'----------------------------------------------------------------------------------------------
Private Sub cmdEliminar_Click()
   Eliminar
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdSortir_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdSortir
' Crida a una funci per sortir del formulari
'----------------------------------------------------------------------------------------------
Private Sub cmdSortir_Click()
   Sortir
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdSortirEdicio_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdSortirEdicio
' Crida a una funci per sortir del mode d'edici i guardar els canvis
'----------------------------------------------------------------------------------------------
Private Sub cmdSortirEdicio_Click()
   SortirEdicio
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdDesferCanvis_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdDesferCanvis
' Crida a una funci per sortir del mode d'edici sense guardar els canvis
'----------------------------------------------------------------------------------------------
Private Sub cmdDesferCanvis_Click()
   UndoChanges
End Sub

'----------------------------------------------------------------------------------------------
'-- lstCodis_Click()
'----------------------------------------------------------------------------------------------
' S'executa quan es fa clic a la llista de Codis
'----------------------------------------------------------------------------------------------
Private Sub lstCodis_Click()
   RefrescaFormulariAmbLlista
End Sub

'**********************************************************************************************
'-- Funcions de nivell superior
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- RefreshModeFormEdicio
'----------------------------------------------------------------------------------------------
' S'executa cada vegada que s'assigna la variable RefreshModeFormEdicio
' Habilita o deshabilita els butons i els controls d'entrada segons el valor de la variable
'----------------------------------------------------------------------------------------------
Private Sub RefreshModeFormEdicio(bolModeFormulari As Boolean)
   Dim ctrDades As Control
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
          
   'Fa visible els botons corresponents a cada mode del formulari
   Me.cmdNou.Visible = (Not bolModeFormulari)
   Me.cmdEditar.Visible = (Not bolModeFormulari)
   Me.cmdEliminar.Visible = (Not bolModeFormulari)
   Me.cmdSortir.Visible = (Not bolModeFormulari)
   Me.cmdSortirEdicio.Visible = bolModeFormulari
   Me.cmdDesferCanvis.Visible = bolModeFormulari
       
   'Si estem en mode d'edici, habilita els controls d'entrada de dades i, si no,
   'els deshabilita
   For Each ctrDades In Me.Controls
      If TypeName(ctrDades) = "TextBox" Or TypeName(ctrDades) = "ComboBox" Or _
       TypeName(ctrDades) = "DataCombo" Then
         ctrDades.Locked = (Not bolModeFormulari)
      End If
   Next ctrDades
   Me.lstCodis.Enabled = Not bolModeFormulari
   
   Exit Sub
    
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefreshModeFormEdicio"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- IniciFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques d'inicialitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub IniciFormulari()
   Dim lngComptador As Long
  
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
 
   'Crea una instncia de les classes SvrTaulesAuxiliars i objFuncionsComuns
   'per utilitzar-ne els mtodes i propietats
   Set objFuncionsComuns = New clsFuncionsCapaInterficie
   
   'Recupera una referncia a la classe de suport
   Set objClasseSuportActual = objFuncionsComuns.CreaObjecteSuport("SvrTaulesAuxiliars")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Recupera els textos del formulari traduts a l'idioma per defecte
   
   Set rstRecordsetIdioma = objFuncionsComuns.TradueixFormulariIdioma(Me, Sistema.Idioma)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   Me.Caption = Me.Caption & " " & strNomTaula
   
   'No estem en mode d'actualitzaci
   bolModeFormActualitzacio = 0
         
   'Posa com a camp del text del codi el que es troba a la llista
   Me.txtCodi.DataField = strCampLlista
   
   'Recupera els codis de la BD
   If Me.strRecordsetActualitzar = "" Then
      RecuperaCodis
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
   Else
      DedueixParametresRecordset Me.strRecordsetActualitzar
      Set Me.rstRecordsetActual = _
       CallByName(frmFormulariRecordset, strRecordsetAEnllacar, VbGet)
   End If
         
   'Guarda el filtre inicial
   strFiltreInicial = Me.rstRecordsetActual.Filter
   If strFiltreInicial = "0" Then
      strFiltreInicial = ""
   End If
   
   'Filtra el recordset segons el filtre que se li hagi passat
   'al formulari
   If Me.strNomCampFiltre = "" Then
      Me.rstRecordsetActual.Filter = ""
   Else
      Me.rstRecordsetActual.Filter = Me.strNomCampFiltre & " = " & _
       Me.lngValorCampFiltre
   End If
   
   'Enllaa els controls al recordset acabat de crear
   objFuncionsComuns.LinkControls Me
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   If rstRecordsetActual.RecordCount = 0 Then
      strCodiActualitzacio = ""
   Else
      strCodiActualitzacio = CStr(rstRecordsetActual.Fields(strCampLlista))
   End If
   
   'Refresca el formulari per tal que s'hi vegi el seu estat actualitzat
   RefrescaFormulariActualitzacio
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   
   'Posa el formulari en mode de consulta (no edici)
   bolModeFormEdicio = False
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - IniciFormulari"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- FiFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques de finalitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub FiFormulari()
   'Allibera les instncies de les classes
   Set objClasseSuportActual = Nothing
   Set objFuncionsComuns = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- Nou
'----------------------------------------------------------------------------------------------
' Crea un registre en blanc per editar un nou registre
'----------------------------------------------------------------------------------------------

Private Sub Nou()
   Dim strCadenaValidacio  As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es fixa el mode d'actualitzaci
   bolModeFormActualitzacio = 1
    
   'Afegeix un registre nou al recordset i li omple el camp projecte
   rstRecordsetActual.AddNew
   
   'Si s una taula de tres camps, omple el tercer camp amb el valor corresponent
   If strNomCampFiltre <> "" Then
      rstRecordsetActual.Fields(strNomCampFiltre) = lngValorCampFiltre
   End If
   
   'Posa el formulari en mode d'edici
   bolModeFormEdicio = True
   
   'Com que no hi ha cap element seleccionat, per convenci
   'posa la cadena buida com a element que estava seleccionat actualment
   strCodiActualitzacio = ""
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Nou"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Editar
'----------------------------------------------------------------------------------------------
' Posa el formulari en mode d'edici
'----------------------------------------------------------------------------------------------
Private Sub Editar()
   Dim strCadenaValidacio As String
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
       
    
   strCadenaValidacio = CadenaValidacioEditar()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
       MsgBox (strCadenaValidacio)
   Else
       'Posa el mode d'edici a cert
       bolModeFormEdicio = True
       'Es fixa el mode d'actualitzaci
       bolModeFormActualitzacio = 2
       
       'Guarda el codi seleccionat actualment a strCodiActualitzacio
       strCodiActualitzacio = CStr(rstRecordsetActual.Fields(strCampLlista))
       
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Editar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- Eliminar
'----------------------------------------------------------------------------------------------
' Elimina el registre actual de la base de dades
'----------------------------------------------------------------------------------------------
Private Sub Eliminar()
   Dim bolResultat As Boolean
   Dim strCadenaValidacio  As String
   Dim lngIndexSeleccionatAbansEliminar As Long
   Dim strTextValidacioEliminar As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Mira si es pot eliminar el registre i, si s aix, l'elimina. Altrament emet un error
   strCadenaValidacio = CadenaValidacioEliminar()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
      MsgBox (strCadenaValidacio)
   Else
      'Recupera els textos traduits per omplir el textbox que indica el nmero de registre
      strTextValidacioEliminar = objFuncionsComuns.TradueixDefecteMissatgeFormulariIdioma _
       (rstRecordsetIdioma, "valTextEliminar", "valTextEliminar")
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
         
      If MsgBox(strTextValidacioEliminar, vbYesNo) = vbYes Then
      
         'Es fixa el mode d'actualitzaci
         bolModeFormActualitzacio = 2
      
         'Es recull el codi anterior a l'esborrat per seleccionar-lo desprs d'esborrar
         If Me.lstCodis.ListCount > 1 Then
            'Si abans d'esborrar noms hi ha 2 elements o b l'element seleccionat s el primer de la llista,
            'desprs de l'esborrat, l'element seleccionat ser el primer
            If Me.lstCodis.ListCount = 2 Or Me.lstCodis.ListIndex = 0 Then
               strCodiActualitzacio = "" 'La cadena buida indica que seleccionarem el primer element
            Else
               'En cas contrari, ser l'anterior a l'esborrat
               strCodiActualitzacio = CStr(Me.lstCodis.List(Me.lstCodis.ListIndex - 1))
            End If
         End If
          
         'Esborra el registre del recordset actual
         rstRecordsetActual.Delete
      
         'Propaga els canvis a la BD
         PropagaCanvisABD
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
        
         'Refresca el formulari desprs d'una actualitzaci
         RefrescaFormulariActualitzacio
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
         
         RefrescaFormulariLectura
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
            
         'Es fixa el mode d'actualitzaci
         bolModeFormActualitzacio = 0
      End If
   End If
        
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Eliminar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Sortir
'----------------------------------------------------------------------------------------------
' Surt del formulari
'----------------------------------------------------------------------------------------------
Private Sub Sortir()
   Dim cmbComboBox As ComboBox
   Dim cmbCombo As DataCombo
   Dim objMarcador As Variant
   
   'Refresca la llista del combo
   If TypeName(ctrCombo) = "DataCombo" Then
      Set cmbCombo = ctrCombo
      objFuncionsComuns.OmpleDatacombo cmbCombo, Me.rstRecordsetActual
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
   Else 's un ComboBox
      'strValorCampSeleccionat = Me.rstRecordsetActual.Fields(strCampLlista)
      Set cmbComboBox = ctrCombo
      objFuncionsComuns.OmpleComboBox cmbComboBox, Me.rstRecordsetActual, Me.strCampIntegritat, _
       Me.strCampLlista
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
   End If
   
   If Me.strRecordsetActualitzar <> "" Then
      CallByName frmFormulariRecordset, strRecordsetAEnllacar, VbSet, Me.rstRecordsetActual
   End If

   Me.Visible = False
End Sub
'----------------------------------------------------------------------------------------------
'-- SortirEdicio
'----------------------------------------------------------------------------------------------
'Si els canvis realitzats durant l'edici sn vlids, surt del mode d'edici
'Si no, emet un missatge d'error
'---------------------------------------------------------------------------------------------
Private Sub SortirEdicio()
   Dim strCadenaValidacio As String
   Dim strCodiEditat As String
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
    
   'Mira si el registre que acabem d'introduir s vlid
   strCadenaValidacio = CadenaValidacioRegistreActual()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
      MsgBox (strCadenaValidacio)
   Else
      'Si ho s, fa un Update i propaga els canvis a la BD
      If rstRecordsetActual.RecordCount > 0 Then
      
         strCodiEditat = CStr(rstRecordsetActual.Fields(strCampLlista))
         
         rstRecordsetActual.Update
                  
         'Propaga el canvi a la BD
         PropagaCanvisABD
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
        
        'Si el codi ha canviat, refresca la llista
        If strCodiActualitzacio <> strCodiEditat Then
            strCodiActualitzacio = strCodiEditat
            RefrescaFormulariActualitzacio
            If NumError <> ctintErrorOK Then
               Err.Raise NumError
            End If
         End If
         
         'Refresca els camps
         RefrescaFormulariLectura
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
         
      End If
      
      'Posa el mode d'edici a fals
      bolModeFormEdicio = False
        
      'Es fixa el mode d'actualitzaci
      bolModeFormActualitzacio = 0
    End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - SortirEdicio"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- UndoChanges
'----------------------------------------------------------------------------------------------
' Desf els canvis produts amb el mode d'edici
'----------------------------------------------------------------------------------------------
Private Sub UndoChanges()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
   'Cancella l'Update i refresca el formulari
   rstRecordsetActual.CancelUpdate
   
   'Refresca els camps del formulari
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
       
   bolModeFormEdicio = False
   
   'Es fixa el mode d'actualitzaci
   bolModeFormActualitzacio = 0
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - UndoChanges"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariAmbLlista()
'----------------------------------------------------------------------------------------------
' Quan es fa clic a la llista,
' es refresquen les dades del formulari amb el codi escollit de la llista
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariAmbLlista()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
  
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariAmbLlista"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'**********************************************************************************************
'-- Funcions que no sn de nivell superior
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariActualitzacio()
'----------------------------------------------------------------------------------------------
' Refresca el formulari desprs d'una actualitzaci
' Posa en la llista de Codis en el camp corresponent
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariActualitzacio()
   Dim strCodiActual As String
   Dim bolRegistreActualSeleccionat As Boolean
   Dim bolAlgunRegistreSeleccionat As Boolean
   Dim lngIndexSeleccionat As Long
      
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Buida la llista
   Me.lstCodis.Clear
   Me.lstCodis.ListIndex = -1
                    
   If rstRecordsetActual.RecordCount > 0 Then
      bolAlgunRegistreSeleccionat = False
      rstRecordsetActual.MoveFirst
      Do While Not rstRecordsetActual.EOF
         'Es recupera el codi actual i s'insereix a la llista
                  
         strCodiActual = CStr(rstRecordsetActual.Fields(strCampLlista))
         
         Me.lstCodis.AddItem strCodiActual
         Me.lstCodis.ItemData(lstCodis.NewIndex) = _
          rstRecordsetActual.AbsolutePosition
          
         'Es calcula la posici que t l'element que s'ha de seleccionar
         'desprs d'aquesta inserci
         If bolAlgunRegistreSeleccionat Then
            If lstCodis.NewIndex <= lngIndexSeleccionat Then
               lngIndexSeleccionat = lngIndexSeleccionat + 1
            End If
         Else
            If (strCodiActual = strCodiActualitzacio) Then
               lngIndexSeleccionat = lstCodis.NewIndex
               bolAlgunRegistreSeleccionat = True
            End If
         End If
         
         rstRecordsetActual.MoveNext
      Loop
     
      'Si no s'ha aconseguit seleccionar cap registre (per alguna fallada del programa)
      'se selecciona la primera posici de la llista
      If bolAlgunRegistreSeleccionat Then
         Me.lstCodis.ListIndex = lngIndexSeleccionat
      Else
         Me.lstCodis.ListIndex = 0
      End If
   End If

   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariActualitzacio"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariLectura()
'----------------------------------------------------------------------------------------------
' Refresca el formulari desprs d'una lectura
' Concretament, refresca els camps segons el codi seleccionat
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariLectura()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Mou el recordset fins al nmero de registre seleccionat des del Listbox
   If rstRecordsetActual.RecordCount > 0 And Me.lstCodis.ListCount > 0 Then
      rstRecordsetActual.Move Me.lstCodis.ItemData(Me.lstCodis.ListIndex) - 1, _
       adBookmarkFirst
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariLectura"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- PropagaCanvisABD
'----------------------------------------------------------------------------------------------
' Guarda els canvis que s'han fet sobre el Recordset
' a la Base de Dades
'----------------------------------------------------------------------------------------------
Private Sub PropagaCanvisABD()
   Dim strCadenaValidacio  As String
   Dim StrCadenaXML As String
   Dim bolResultat As Boolean
   Dim StrXMLDades As String
   Dim strXMLCanvis As String
   Dim strClauForana As String
   Dim lngClauPrimaria As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
   'Desenllaa per tal que es copi b el Recordset
   objFuncionsComuns.DeslinkControls Me
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Obte la cadena XML corresponent al recordset actual
   StrCadenaXML = objFuncionsComuns.PassaRecordsetAXML(rstRecordsetActual)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Obt noms les actualitzacions de la cadena XML
   strXMLCanvis = objFuncionsComuns.ObteActualitzacionsDeXML(StrCadenaXML)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es graven els canvis a la base de dades
   bolResultat = objClasseSuportActual.SaveTaulaAuxiliar(strXMLCanvis)
   If objClasseSuportActual.NumError <> ctintErrorOK Then
      UbicacioError = objClasseSuportActual.UbicacioError
      Err.Raise objClasseSuportActual.NumError
   End If
      
   'Refresca la informacio del Recordset
   RecuperaCodis
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
       
   objFuncionsComuns.LinkControls Me 'Torna a enllaar-se les dades
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - PropagaCanvisABD"
   objFuncionsComuns.LinkControls Me
   Exit Sub
   
End Sub
'----------------------------------------------------------------------------------------------
'-- RecuperaCodis()
'----------------------------------------------------------------------------------------------
' Crea un recordset amb la mateixa informaci que el recordset actual
' per que no t cap actualitzaci pendent
'----------------------------------------------------------------------------------------------
Public Sub RecuperaCodis()
   Dim strResultat As String
   Dim rstTemp As ADODB.Recordset
   Dim strFiltre As String
   Dim bolExisteixRecordsetActual As Boolean
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Determina si el recordset actual s'ha inicialitzat
   bolExisteixRecordsetActual = Not (Me.rstRecordsetActual Is Nothing)
   
   'Guarda el filtre si ho ha fet
   If bolExisteixRecordsetActual Then
      strFiltre = Me.rstRecordsetActual.Filter
      If strFiltre = "0" Then
         strFiltre = ""
      End If
      'Treu el filtre
      Me.rstRecordsetActual.Filter = ""
   End If
         
   'Si es tracta del comenament del formulari o d'una inserci
   If bolModeFormActualitzacio = 0 Or bolModeFormActualitzacio = 1 Then
      'Es recuperen els codis mitjanant la classe SvrTaulesAuxiliars
      strResultat = objClasseSuportActual.GetListAuxiliar(strNomTaula, "", _
       0, strCampOrdre)
      If objClasseSuportActual.NumError <> ctintErrorOK Then
         UbicacioError = objClasseSuportActual.UbicacioError
         Err.Raise objClasseSuportActual.NumError
      End If
   Else
      'En cas de modificaci o esborrat, es purguen les actualitzacions
      'del recordset perqu no cal accedir a les capes inferiors
      strResultat = objFuncionsComuns.PurgaActualitzacionsRecordset(rstRecordsetActual)
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
   End If
      
   'Si no hi ha hagut errors, crea el Recordset a partir de l'XML
   Set rstRecordsetActual = objFuncionsComuns.PassaXMLARecordset(strResultat)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
       
   'Recupera el filtre
   If bolExisteixRecordsetActual Then
      Me.rstRecordsetActual.Filter = strFiltre
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RecuperaCodis"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioRegistreActual()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per guardar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioRegistreActual()
   Dim bolCampRepetit As Boolean
   Dim strCodiMissatge As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""

   'Mira que s'omplin tots els camps
     
   If rstRecordsetActual.RecordCount > 0 And (Me.txtCodi.Text = "" Or _
    IsNull(Me.txtCodi)) Then
      strCodiMissatge = "valAlgunCampNecessariBuit"
   Else
      'Mira que no hi hagi un altre registre amb el mateix codi
      bolCampRepetit = objFuncionsComuns.ValorCampRepetit(rstRecordsetActual, strCampLlista)
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
      
      If bolCampRepetit Then
         strCodiMissatge = "valRepetitCodi"
      Else
         strCodiMissatge = ""
      End If
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioRegistreActual = strResultat
   Exit Function
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioRegistreActual"
   CadenaValidacioRegistreActual = ""
   Exit Function
   
End Function

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioEliminar()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per eliminar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioEliminar()
   Dim strCodiMissatge As String
   Dim strResultat As String
   Dim lngComptador As Long
   Dim lngNombreRegles As Long
   Dim TaulaReglaTrencada As String
   Dim rstRecordsetTemporal As ADODB.Recordset
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
  
   If rstRecordsetActual.RecordCount = 0 Then
      strCodiMissatge = "valNoRegistresEliminar"
   Else
      lngComptador = 1
      TaulaReglaTrencada = ""
      lngNombreRegles = Me.colIntegritatReferencial.Count
      Do While (lngComptador <= lngNombreRegles) And (TaulaReglaTrencada = "")
      
         strResultat = objClasseSuportActual.GetListAuxiliar( _
         Me.colIntegritatReferencial(lngComptador).strNomTaulaFill, _
         Me.colIntegritatReferencial(lngComptador).strClauTaulaFill, _
         rstRecordsetActual.Fields(strCampIntegritat), "")
         If objClasseSuportActual.NumError <> ctintErrorOK Then
            UbicacioError = objClasseSuportActual.UbicacioError
            Err.Raise objClasseSuportActual.NumError
         End If
      
         Set rstRecordsetTemporal = objFuncionsComuns.PassaXMLARecordset(strResultat)
         If objFuncionsComuns.NumError <> ctintErrorOK Then
            UbicacioError = objFuncionsComuns.UbicacioError
            Err.Raise objFuncionsComuns.NumError
         End If
      
         If rstRecordsetTemporal.RecordCount > 0 Then
            TaulaReglaTrencada = Me.colIntegritatReferencial(lngComptador).strNomTaulaFill
         End If
         
         lngComptador = lngComptador + 1
      Loop
      
      If TaulaReglaTrencada <> "" Then
         strCodiMissatge = "valVioladaReglaIntegritatReferencial"
      Else
         strCodiMissatge = ""
      End If
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Posa el nom de la taula en el missatge d'error de valVioladaReglaIntegritatReferencial
   If strCodiMissatge = "valVioladaReglaIntegritatReferencial" Then
      strResultat = objFuncionsComuns.StrTran(strResultat, "#1", TaulaReglaTrencada)
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
   End If
   
   CadenaValidacioEliminar = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioEliminar"
   CadenaValidacioEliminar = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioEditar()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per eliminar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioEditar()

   Dim strCodiMissatge As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
     
   If rstRecordsetActual.RecordCount = 0 Then
      strCodiMissatge = "valNoRegistresEditar"
   Else
      strCodiMissatge = ""
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioEditar = strResultat
   Exit Function
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioEditar"
   CadenaValidacioEditar = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- DedueixParametresRecordset
'----------------------------------------------------------------------------------------------
' Dedueix els parmetres del recordset
'----------------------------------------------------------------------------------------------
Private Sub DedueixParametresRecordset(strRecordset As String)
   Dim lngPosPunt As Long
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   Set frmFormulariRecordset = Me.frmFormulariQueCrida
   strRecordsetAEnllacar = strRecordset
   lngPosPunt = InStr(strRecordsetAEnllacar, ".")
   Do While lngPosPunt <> 0
      Set frmFormulariRecordset = CallByName(frmFormulariRecordset, _
       Mid$(strRecordsetAEnllacar, 1, lngPosPunt - 1), VbGet)
      strRecordsetAEnllacar = Mid$(strRecordsetAEnllacar, lngPosPunt + 1)
      lngPosPunt = InStr(strRecordsetAEnllacar, ".")
   Loop
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - DedueixParametresRecordset"
   Exit Sub
End Sub
           
   
 
