VERSION 5.00
Object = "{F0D2F211-CCB0-11D0-A316-00AA00688B10}#1.0#0"; "MSDATLST.OCX"
Begin VB.Form frmUsuariProjecte 
   Caption         =   "frmUsuariProjecte"
   ClientHeight    =   4635
   ClientLeft      =   3855
   ClientTop       =   1830
   ClientWidth     =   4455
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   4635
   ScaleWidth      =   4455
   Begin MSDataListLib.DataCombo cmbProjectes 
      Height          =   360
      Left            =   120
      TabIndex        =   7
      Top             =   840
      Width           =   2895
      _ExtentX        =   5106
      _ExtentY        =   635
      _Version        =   393216
      Text            =   ""
   End
   Begin VB.ListBox lstProjectes 
      Height          =   1980
      Left            =   120
      Sorted          =   -1  'True
      TabIndex        =   6
      Top             =   1680
      Width           =   4215
   End
   Begin VB.CommandButton cmdSortir 
      Caption         =   "cmdSortir"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   3120
      TabIndex        =   3
      Top             =   3960
      Width           =   1215
   End
   Begin VB.CommandButton cmdEliminar 
      Caption         =   "cmdEliminar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   2
      Top             =   3840
      Width           =   1335
   End
   Begin VB.CommandButton cmdAfegir 
      Caption         =   "cmdAfegir"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   3120
      TabIndex        =   1
      Top             =   840
      Width           =   1215
   End
   Begin VB.Label lblNomUsuari 
      AutoSize        =   -1  'True
      Caption         =   "lblNomUsuari"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   1080
      TabIndex        =   8
      Top             =   120
      Width           =   1425
   End
   Begin VB.Label lblProjectes 
      Caption         =   "lblProjectes"
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   600
      Width           =   2055
   End
   Begin VB.Label lblProjectesSeleccionats 
      Caption         =   "lblProjectesSeleccionats"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   1440
      Width           =   4215
   End
   Begin VB.Label lblUsuari 
      AutoSize        =   -1  'True
      Caption         =   "lblUsuari"
      Height          =   240
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   795
   End
End
Attribute VB_Name = "frmUsuariProjecte"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

Public frmFormulariQueCrida As GIM.frmUsuaris 'Mant una referncia al formulari que la crida

'Serveix per accedir a les propietats i mtodes de la classe SvrUsuariProjectes
Public objClasseSuportActual As GIMSuport.SvrUsuariProjectes
Private objFuncionsComuns As clsFuncionsCapaInterficie

Public rstRecordsetActual As ADODB.Recordset 'Recordset amb els projectes seleccionats
Public rstRecordsetIdioma As ADODB.Recordset 'Recordset amb les textos tradus del formulari
Public rstRecordsetAfegir As ADODB.Recordset 'Recordset per tal de fer l'operaci d'afegir
 
Private lngNumUsuari As Long
Private strCadenaXMLTemporal As String
Private bolModeFormActualitzacio As Integer 'Mode d'Actualitzaci del formulari
   '0 - sense actualitzaci, 1 - nou, 2- esborrar i modificar


'**********************************************************************************************
'-- Funcions d'implementaci de propietats
'**********************************************************************************************

'**********************************************************************************************
'-- Events del formulari i dels controls
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Form_Load
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Load()
   IniciFormulari
End Sub
'----------------------------------------------------------------------------------------------
'-- Form_Terminate
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Terminate()
   FiFormulari
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdAfegir_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdAfegir
' Crida a una funci per afegir el projecte a la llista de seleccionats
'----------------------------------------------------------------------------------------------
Private Sub cmdAfegir_Click()
   Afegir
End Sub

'----------------------------------------------------------------------------------------------
'-- cmdEliminar_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdEliminar
' Crida a una funci per eliminar el projecte de la llista de seleccionats
'----------------------------------------------------------------------------------------------
Private Sub cmdEliminar_Click()
   Eliminar
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdSortir_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdSortir
' Crida a una funci per sortir del formulari
'----------------------------------------------------------------------------------------------
Private Sub cmdSortir_Click()
   Sortir
End Sub

'----------------------------------------------------------------------------------------------
'-- lstProjectes_Click()
'----------------------------------------------------------------------------------------------
' S'executa quan es fa clic a la llista de projectes
'----------------------------------------------------------------------------------------------
Private Sub lstProjectes_Click()
   RefrescaFormulariAmbLlista
End Sub

'**********************************************************************************************
'-- Funcions de nivell superior
'**********************************************************************************************

'----------------------------------------------------------------------------------------------
'-- IniciFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques d'inicialitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub IniciFormulari()
   Dim lngComptador As Long
  
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
 
   'Crea una instncia de les classes SvrUsuariProjectes i objFuncionsComuns
   'per utilitzar-ne els mtodes i propietats
   Set objFuncionsComuns = New clsFuncionsCapaInterficie
   Set objClasseSuportActual = New GIMSuport.SvrUsuariProjectes
   
   'Recupera els textos del formulari traduts a l'idioma per defecte
   
   Set rstRecordsetIdioma = objFuncionsComuns.TradueixFormulariIdioma(Me, Sistema.Idioma)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
      
   'No estem en mode d'actualitzaci
   bolModeFormActualitzacio = 0
   
   'Es recupera el nmero d'usuari i es posa en una variable per utilitzar-lo desprs
   lngNumUsuari = Me.frmFormulariQueCrida.rstRecordsetActual!NumUsuari
   
   'Es recupera el nom de l'usuari i es posa en el textbox
   Me.lblNomUsuari = Me.frmFormulariQueCrida.rstRecordsetActual!NomUsuari
   
   'Recupera els Usuaris-Projectes de la BD
   RecuperaUsuarisProjectes
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
      
   'Enllaa els controls al recordset acabat de crear
   Set Me.cmbProjectes.RowSource = Me.frmFormulariQueCrida.rstRecordsetProjectes
   Me.cmbProjectes.ListField = "NomProjecte"
   Me.cmbProjectes.BoundColumn = "NumProjecte"
   
   'Refresca el formulari per tal que s'hi vegi el seu estat actualitzat
   RefrescaFormulariActualitzacio
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
     
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - IniciFormulari"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- FiFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques de finalitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub FiFormulari()
   'Allibera les instncies de les classes
   Set objClasseSuportActual = Nothing
   Set objFuncionsComuns = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- Afegir
'----------------------------------------------------------------------------------------------
' Afegeix el projecte escollit en el datacombo a la llista de projectes seleccionats
'---------------------------------------------------------------------------------------------
Private Sub Afegir()
   Dim strCadenaValidacio As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
       
   'Mira si el registre que acabem d'introduir s vlid
   strCadenaValidacio = CadenaValidacioRegistreActual()
   
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
      MsgBox (strCadenaValidacio)
   Else
      'Recupera un recordset buit en format XML
      strCadenaXMLTemporal = objClasseSuportActual.GetEmptyRecordset()
      If objClasseSuportActual.NumError <> ctintErrorOK Then
         UbicacioError = objClasseSuportActual.UbicacioError
         Err.Raise objClasseSuportActual.NumError
      End If
      
      'Passa el recordset a ADO
      Set rstRecordsetAfegir = objFuncionsComuns.PassaXMLARecordset(strCadenaXMLTemporal)
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
      
      'Hi afegeix un registre amb el projecte a afegir
      rstRecordsetAfegir.AddNew
      rstRecordsetAfegir!NumUsuari = lngNumUsuari
      rstRecordsetAfegir!NumProjecte = Val(Me.cmbProjectes.BoundText)
      rstRecordsetAfegir.Update
         
              
      'Propaga el canvi a la BD
      PropagaCanvisABD
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
         
            
      'Refresca el formulari desprs d'una actualitzaci
      RefrescaFormulariActualitzacio
      If NumError <> ctintErrorOK Then
         Err.Raise NumError
      End If
      
      'Es fixa el mode d'actualitzaci
      bolModeFormActualitzacio = 0
   
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Afegir"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Eliminar
'----------------------------------------------------------------------------------------------
' Elimina el Projecte de la llista de seleccionats
'----------------------------------------------------------------------------------------------
Private Sub Eliminar()
   Dim bolResultat As Boolean
   Dim strCadenaValidacio  As String
   Dim bolResultatDelete As Boolean
   Dim strTextValidacioEliminar As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
       
    
   'Mira si es pot eliminar el registre i, si s aix, l'elimina. Altrament emet un error
   strCadenaValidacio = CadenaValidacioEliminar()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
      MsgBox (strCadenaValidacio)
   Else
      'Recupera els textos traduits per omplir el textbox que indica el nmero de registre
      strTextValidacioEliminar = objFuncionsComuns.TradueixDefecteMissatgeFormulariIdioma _
       (rstRecordsetIdioma, "valTextEliminar", "valTextEliminar")
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
         
      If MsgBox(strTextValidacioEliminar, vbYesNo) = vbYes Then
      
         'Es fixa el mode d'actualitzaci
         bolModeFormActualitzacio = 2
            
         'Esborra el registre a la BD
         bolResultatDelete = objClasseSuportActual.DeleteUsuariProjecte(lngNumUsuari, _
          rstRecordsetActual!NumProjecte)
         If objClasseSuportActual.NumError <> ctintErrorOK Then
            UbicacioError = objClasseSuportActual.UbicacioError
            Err.Raise objClasseSuportActual.NumError
         End If
      
         'Esborra el registre del recordset actual i propaga els canvis a la BD
         rstRecordsetActual.Delete
            
         'Refresca el formulari desprs d'una actualitzaci
         RefrescaFormulariActualitzacio
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
         
         'Es fixa el mode d'actualitzaci
         bolModeFormActualitzacio = 0
      End If
   End If
        
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Eliminar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Sortir
'----------------------------------------------------------------------------------------------
' Surt del formulari
'----------------------------------------------------------------------------------------------
Private Sub Sortir()
   Unload Me
End Sub

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariAmbLlista()
'----------------------------------------------------------------------------------------------
' Quan es fa clic a la llista,
' el recordset es colloca en el registre corresponent
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariAmbLlista()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariAmbLlista"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'**********************************************************************************************
'-- Funcions que no sn de nivell superior
'**********************************************************************************************

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariActualitzacio()
'----------------------------------------------------------------------------------------------
' Refresca el formulari desprs d'una actualitzaci
' Omple la llista de projectes seleccionats
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariActualitzacio()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
  
   'Omple la llista d'UsuariProjectes amb els noms dels projectes indicats al recordset
   Me.lstProjectes.Clear
   If rstRecordsetActual.RecordCount > 0 Then
      rstRecordsetActual.MoveFirst
      Do While Not rstRecordsetActual.EOF
         Me.lstProjectes.AddItem rstRecordsetActual!NomProjecte
         Me.lstProjectes.ItemData(lstProjectes.NewIndex) = _
          rstRecordsetActual.AbsolutePosition
         rstRecordsetActual.MoveNext
      Loop
      Me.lstProjectes.ListIndex = 0
   End If
 
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariActualitzacio"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariLectura()
'----------------------------------------------------------------------------------------------
' Refresca el formulari desprs d'una lectura
' Concretament, el recordset es colloca en el registre corresponent
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariLectura()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Mou el recordset fins al nmero de registre seleccionat des del Listbox
   If rstRecordsetActual.RecordCount > 0 And Me.lstProjectes.ListCount > 0 Then
      rstRecordsetActual.Move Me.lstProjectes.ItemData(Me.lstProjectes.ListIndex) - 1, _
       adBookmarkFirst
   End If

   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariLectura"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- PropagaCanvisABD
'----------------------------------------------------------------------------------------------
' Guarda els canvis que s'han fet sobre el Recordset
' a la Base de Dades
'----------------------------------------------------------------------------------------------
Private Sub PropagaCanvisABD()
   Dim strCadenaValidacio  As String
   Dim StrCadenaXML As String
   Dim bolResultat As Boolean
   Dim StrXMLDades As String
   Dim strXMLCanvis As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
             
   'Desenllaa per tal que es copi b el Recordset
   objFuncionsComuns.DeslinkControls Me
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Obte la cadena XML corresponent al recordset per afegir
   StrCadenaXML = objFuncionsComuns.PassaRecordsetAXML(rstRecordsetAfegir)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Obt noms les actualitzacions de la cadena XML
   strXMLCanvis = objFuncionsComuns.ObteActualitzacionsDeXML(StrCadenaXML)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es graven els canvis a la base de dades
   bolResultat = objClasseSuportActual.SaveUsuariProjecte(strXMLCanvis)
   If objClasseSuportActual.NumError <> ctintErrorOK Then
      UbicacioError = objClasseSuportActual.UbicacioError
      Err.Raise objClasseSuportActual.NumError
   End If
    
   'Refresca la informacio del Recordset
   RecuperaUsuarisProjectes
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
       
   objFuncionsComuns.LinkControls Me 'Torna a enllaar-se les dades
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - PropagaCanvisABD"
   objFuncionsComuns.LinkControls Me
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- RecuperaUsuarisProjectes()
'----------------------------------------------------------------------------------------------
' Crea un recordset amb la mateixa informaci que el recordset actual
' per que no t cap actualitzaci pendent
'----------------------------------------------------------------------------------------------
Public Sub RecuperaUsuarisProjectes()
   Dim strResultat As String
   Dim rstTemp As ADODB.Recordset
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Si es tracta del comenament del formulari o d'una inserci
   If bolModeFormActualitzacio = 0 Or bolModeFormActualitzacio = 1 Then
      'Es recuperen els Usuaris mitjanant la classe SvrUsuariProjectes
      strResultat = objClasseSuportActual.GetUsuariProjectes(lngNumUsuari)
      
      If objClasseSuportActual.NumError <> ctintErrorOK Then
         UbicacioError = objClasseSuportActual.UbicacioError
         Err.Raise objClasseSuportActual.NumError
      End If
   Else
      'En cas de modificaci o esborrat, es purguen les actualitzacions
      'del recordset perqu no cal accedir a les capes inferiors
      strResultat = objFuncionsComuns.PurgaActualitzacionsRecordset(rstRecordsetActual)
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
   End If
      
  
   'Si no hi ha hagut errors, crea el Recordset a partir de l'XML
   Set rstRecordsetActual = objFuncionsComuns.PassaXMLARecordset(strResultat)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RecuperaUsuarisProjectes"
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- CadenaValidacioRegistreActual()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per guardar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioRegistreActual() As String
   Dim bolCampRepetit As Boolean
   Dim strCodiMissatge As String
   Dim strResultat As String
   Dim bmkMarcador As Variant
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""

   'Mira que s'omplin tots els camps
     
   If Me.cmbProjectes.BoundText = "" Then
      strCodiMissatge = "valProjecteBuit"
   Else
      'Mira que el projecte no estigui ja seleccionat
      If rstRecordsetActual.RecordCount = 0 Then
         strCodiMissatge = ""
      Else
         bmkMarcador = rstRecordsetActual.Bookmark
         rstRecordsetActual.Filter = " NumProjecte  = " & Me.cmbProjectes.BoundText
         If rstRecordsetActual.EOF Then
            strCodiMissatge = ""
         Else
            strCodiMissatge = "valProjecteJaSeleccionat"
         End If
         rstRecordsetActual.Filter = ""
         rstRecordsetActual.Bookmark = bmkMarcador
      End If
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioRegistreActual = strResultat
   Exit Function
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioRegistreActual"
   CadenaValidacioRegistreActual = ""
   Exit Function
   
End Function
   

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioEliminar()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per eliminar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioEliminar()
   Dim strCodiMissatge As String
   Dim strResultat As String

   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   If rstRecordsetActual.RecordCount = 0 Then
      strCodiMissatge = "valNoRegistresEliminar"
   Else
      strCodiMissatge = ""
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioEliminar = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioEliminar"
   CadenaValidacioEliminar = ""
   Exit Function
End Function

