VERSION 5.00
Begin VB.Form frmVisorImatge 
   Caption         =   "Form1"
   ClientHeight    =   6795
   ClientLeft      =   3150
   ClientTop       =   2655
   ClientWidth     =   9480
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   6795
   ScaleWidth      =   9480
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdTancar 
      Caption         =   "cmdTancar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   6480
      TabIndex        =   4
      Top             =   8760
      Width           =   1215
   End
   Begin VB.HScrollBar barHoritzontal 
      Height          =   255
      Left            =   0
      TabIndex        =   3
      Top             =   8280
      Width           =   12855
   End
   Begin VB.VScrollBar barVertical 
      Height          =   8535
      Left            =   12960
      TabIndex        =   2
      Top             =   0
      Width           =   255
   End
   Begin VB.PictureBox pictExterior 
      Height          =   8175
      Left            =   0
      ScaleHeight     =   8115
      ScaleWidth      =   12795
      TabIndex        =   0
      Top             =   0
      Width           =   12855
      Begin VB.PictureBox pictInterior 
         AutoSize        =   -1  'True
         BorderStyle     =   0  'None
         Height          =   8475
         Left            =   0
         ScaleHeight     =   8475
         ScaleWidth      =   10635
         TabIndex        =   1
         Top             =   0
         Width           =   10635
      End
   End
End
Attribute VB_Name = "frmVisorImatge"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public strNomArxiuImatge As String
Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

'Serveixen per accedir a las classe clsFuncionsCapaInterficie
Private objFuncionsComuns As clsFuncionsCapaInterficie

Public rstRecordsetIdioma As ADODB.Recordset 'Recordset amb les textos tradus del formulari

Private Declare Function GetSystemMetrics Lib "user32" (ByVal nIndex As Long) As Long
'**********************************************************************************************
'-- Events del formulari i dels controls
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Form_Load
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Load()
   IniciFormulari
End Sub

'----------------------------------------------------------------------------------------------
'-- cmdTancar_Click
'----------------------------------------------------------------------------------------------
' S'executa quan es fa clic al bot Tancar
'----------------------------------------------------------------------------------------------
Private Sub cmdTancar_Click()
   FiFormulari
End Sub

'----------------------------------------------------------------------------------------------
'-- barHoritzontal_Change i barHoritzontal_Scroll
'----------------------------------------------------------------------------------------------
' S'executa quan un es desplaa per la barra horizontal
'----------------------------------------------------------------------------------------------
Private Sub barHoritzontal_Change()
    pictInterior.Left = barHoritzontal.Value
End Sub
Private Sub barHoritzontal_Scroll()
    pictInterior.Left = barHoritzontal.Value
End Sub

'----------------------------------------------------------------------------------------------
'-- barVertical_Change i barVertical_Scroll
'----------------------------------------------------------------------------------------------
' S'executa quan un es desplaa per la barra horizontal
'----------------------------------------------------------------------------------------------
Private Sub barVertical_Change()
    pictInterior.Top = barVertical.Value
End Sub

Private Sub barVertical_Scroll()
    pictInterior.Top = barVertical.Value
End Sub

'**********************************************************************************************
'-- Funcions de nivell superior
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- IniciFormulari
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub IniciFormulari()
   Dim lngMaxAreaHoritzontal As Long
   Dim lngMaxAreaVertical As Long
   Dim lngFolga As Long
   Dim lngBarraHoritzontal As Long
   Dim lngBarraVertical As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Recupera una referncia a la clase clsFuncionsCapaInterficie
   Set objFuncionsComuns = New GIM.clsFuncionsCapaInterficie
   
   'Recupera els textos del formulari traduts a l'idioma per defecte
   Set rstRecordsetIdioma = objFuncionsComuns.TradueixFormulariIdioma(Me, Sistema.Idioma)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'S'importa la imatge al formulari
   Me.pictInterior.Picture = LoadPicture(strNomArxiuImatge)
   
   'Calcula dues folgues proporcionals a la resoluci de la pantalla
   lngFolga = (100 * Screen.Width) / 11520
   
   
   'Calcula la mxima rea horitzontal a mostrar sense barres de desplaament
   lngMaxAreaHoritzontal = 0.95 * GetSystemMetrics(0) * Screen.TwipsPerPixelX
   lngMaxAreaVertical = 0.78 * GetSystemMetrics(1) * Screen.TwipsPerPixelY
   
   'Si la imatge cap sense necessitat de barra de desplaament horitzontal
   If Me.pictInterior.Picture.Width < lngMaxAreaHoritzontal Then
      'S'amaga aquesta barra de desplaament perqu no es necessita
      Me.barHoritzontal.Visible = False
      'La barra no ocupa espai
      lngBarraHoritzontal = 0
      'S'ajusta el quadre a la mesura de la imatge importada
      Me.pictExterior.Width = Me.pictInterior.Width
   Else
      lngBarraHoritzontal = Me.barHoritzontal.Height + lngFolga
      Me.pictExterior.Width = lngMaxAreaHoritzontal
      
   End If
   
   'Si la imatge cap sense necessitat de barra de desplaament vertical
   If Me.pictInterior.Picture.Height < lngMaxAreaVertical Then
      'S'amaga aquesta barra de desplaament perqu no es necessita
      Me.barVertical.Visible = False
      'La barra no ocupa espai
      lngBarraVertical = 0
      'S'ajusta el quadre a la mesura de la imatge importada
      Me.pictExterior.Height = Me.pictInterior.Height
   Else
      lngBarraVertical = Me.barVertical.Width + lngFolga
      Me.pictExterior.Height = lngMaxAreaVertical

   End If
      
   Me.barHoritzontal.Top = Me.pictExterior.Top + Me.pictExterior.Height + lngFolga
   Me.barHoritzontal.Width = Me.pictExterior.Width
   Me.barVertical.Left = Me.pictExterior.Left + Me.pictExterior.Width + lngFolga
   Me.barVertical.Height = Me.pictExterior.Height
      
   'Es colloca el bot de Tancar a la vora de la imatge
   Me.cmdTancar.Top = Me.pictExterior.Top + Me.pictExterior.Height + lngFolga + lngBarraHoritzontal
   Me.cmdTancar.Left = Me.pictExterior.Left + Me.pictExterior.Width - Me.cmdTancar.Width
      
   'S'ajusta l'amplada i alada del formulari a la imatge
   Me.Width = Me.pictExterior.Width + 2 * lngFolga + lngBarraVertical
   Me.Height = 100 + Me.pictExterior.Height + Me.cmdTancar.Height + lngBarraHoritzontal + 5 * lngFolga
   
   'Fixa les barres de desplaament
   FixaBarresDesplacament
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - IniciFormulari"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- FiFormulari
'----------------------------------------------------------------------------------------------
' S'executa quan se surt del formulari.
'----------------------------------------------------------------------------------------------
Private Sub FiFormulari()
   Unload Me
End Sub

'**********************************************************************************************
'-- Funcions que no sn de nivell superior
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- FixaBarresDesplacament
'----------------------------------------------------------------------------------------------
' S'executa per configurar les barres de desplaament
'----------------------------------------------------------------------------------------------
Private Sub FixaBarresDesplacament()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   ' Set scroll bar properties.
   barVertical.Min = 0
   barVertical.Max = pictExterior.ScaleHeight - pictInterior.Height
   barVertical.LargeChange = pictExterior.ScaleHeight
   barVertical.SmallChange = pictExterior.ScaleHeight / 5
    
   barHoritzontal.Min = 0
   barHoritzontal.Max = pictExterior.ScaleWidth - pictInterior.Width
   barHoritzontal.LargeChange = pictExterior.ScaleWidth
   barHoritzontal.SmallChange = pictExterior.ScaleWidth / 5
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - FixaBarresDesplacament"
   Exit Sub
End Sub

