VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form frmZones 
   Caption         =   "frmZones"
   ClientHeight    =   5730
   ClientLeft      =   4620
   ClientTop       =   2070
   ClientWidth     =   7785
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form2"
   ScaleHeight     =   5730
   ScaleWidth      =   7785
   Begin VB.CommandButton cmdRutaZona 
      Caption         =   ".."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   7245
      TabIndex        =   17
      Top             =   2160
      Width           =   330
   End
   Begin VB.TextBox txtFotoZona 
      DataField       =   "FotoZona"
      Height          =   375
      Left            =   3000
      TabIndex        =   15
      Top             =   2160
      Width           =   4230
   End
   Begin VB.CommandButton cmdSituar 
      Caption         =   "cmdSituar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   6600
      TabIndex        =   14
      Top             =   2880
      Width           =   975
   End
   Begin VB.TextBox txtNomZona 
      DataField       =   "NomZona"
      Height          =   375
      Left            =   3000
      TabIndex        =   8
      Top             =   1440
      Width           =   4575
   End
   Begin VB.TextBox txtCodZona 
      DataField       =   "CodZona"
      Height          =   375
      Left            =   3000
      TabIndex        =   7
      Top             =   720
      Width           =   4575
   End
   Begin VB.CommandButton cmdSortir 
      Caption         =   "cmdSortir"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   6480
      TabIndex        =   6
      Top             =   4920
      Width           =   1095
   End
   Begin VB.ListBox lstZones 
      Height          =   4140
      ItemData        =   "frmZones.frx":0000
      Left            =   240
      List            =   "frmZones.frx":0007
      Sorted          =   -1  'True
      TabIndex        =   0
      Top             =   600
      Width           =   2295
   End
   Begin VB.CommandButton cmdEditar 
      Caption         =   "cmdEditar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4275
      TabIndex        =   2
      Top             =   4920
      Width           =   975
   End
   Begin VB.CommandButton cmdEliminar 
      Caption         =   "cmdEliminar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5265
      TabIndex        =   4
      Top             =   4920
      Width           =   1215
   End
   Begin VB.CommandButton cmdNou 
      Caption         =   "cmdNou"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   3165
      TabIndex        =   1
      Top             =   4920
      Width           =   1095
   End
   Begin VB.CommandButton cmdSortirEdicio 
      Caption         =   "cmdSortirEdicio"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4065
      TabIndex        =   3
      Top             =   4920
      Width           =   1215
   End
   Begin VB.CommandButton cmdDesferCanvis 
      Caption         =   "cmdDesferCanvis"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5280
      TabIndex        =   5
      Top             =   4920
      Width           =   1215
   End
   Begin MSComctlLib.ListView lstPunts 
      Height          =   1815
      Left            =   3000
      TabIndex        =   13
      Top             =   2880
      Width           =   3495
      _ExtentX        =   6165
      _ExtentY        =   3201
      View            =   3
      LabelEdit       =   1
      Sorted          =   -1  'True
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      FullRowSelect   =   -1  'True
      _Version        =   393217
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   3
      BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Text            =   "clhNumOrdre"
         Object.Width           =   2558
      EndProperty
      BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         SubItemIndex    =   1
         Text            =   "clhX"
         Object.Width           =   1764
      EndProperty
      BeginProperty ColumnHeader(3) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         SubItemIndex    =   2
         Text            =   "clhY"
         Object.Width           =   1764
      EndProperty
   End
   Begin VB.Label lblFotoZona 
      Caption         =   "lblFotoZona"
      Height          =   255
      Left            =   3000
      TabIndex        =   16
      Top             =   1920
      Width           =   4455
   End
   Begin VB.Label lblSituacioGIS 
      Caption         =   "lblSituacioGIS"
      Height          =   255
      Left            =   3000
      TabIndex        =   12
      Top             =   2640
      Width           =   4455
   End
   Begin VB.Label lblLlistaZones 
      Caption         =   "lblLlistaZones"
      Height          =   255
      Left            =   240
      TabIndex        =   11
      Top             =   360
      Width           =   2535
   End
   Begin VB.Label lblNomZona 
      Caption         =   "lblNomZona"
      Height          =   255
      Left            =   3000
      TabIndex        =   10
      Top             =   1200
      Width           =   4455
   End
   Begin VB.Label lblCodiZona 
      Caption         =   "lblCodiZona"
      Height          =   255
      Left            =   3000
      TabIndex        =   9
      Top             =   480
      Width           =   4455
   End
End
Attribute VB_Name = "frmZones"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const ctstrCampLlista = "CodZona"

Public NumError As Long 'Nmero d'error
Public UbicacioError As String 'Ubicaci de l'error a dins del codi font

'Serveix per accedir a les propietats i mtodes de la classe SvrZones
Public objClasseSuportActual As GIMSuport.SvrZones
Private objFuncionsComuns As clsFuncionsCapaInterficie

Public rstRecordsetActual As ADODB.Recordset 'Recordset que es mostra al formulari
Public rstRecordsetPunts As ADODB.Recordset 'Recordset que cont els punts de zona
Public rstRecordsetIdioma As ADODB.Recordset 'Recordset amb les textos tradus del formulari

Private strCadenaXMLTemporal As String
Private bolAuxModeFormEdicio As Boolean 'Mode d'Edicio del formulari
Private bolModeFormActualitzacio As Integer 'Mode d'Actualitzaci del formulari
   '0 - sense actualitzaci, 1 - nou, 2- esborrar i modificar
Private strCodiActualitzacio As String

'**********************************************************************************************
'-- Funcions d'implementaci de propietats
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Property Let i Get bolModeFormEdicio()
'----------------------------------------------------------------------------------------------
' Implementa la variable ModeFormEdici que indica si el formulari es troba en mode d'edici o
' de consulta. Cada cop que canvia el mode, s'executa el procediment RefreshModeFormEdicio
'----------------------------------------------------------------------------------------------
Private Property Get bolModeFormEdicio() As Long
   bolModeFormEdicio = bolAuxModeFormEdicio
End Property

Private Property Let bolModeFormEdicio(ByVal RHS As Long)
   RefreshModeFormEdicio (RHS)
   bolAuxModeFormEdicio = RHS
End Property

'**********************************************************************************************
'-- Events del formulari i dels controls
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- Form_Load
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Load()
   IniciFormulari
End Sub
'----------------------------------------------------------------------------------------------
'-- Form_Terminate
'----------------------------------------------------------------------------------------------
' S'executa quan s'entra al formulari.
'----------------------------------------------------------------------------------------------
Private Sub Form_Terminate()
   FiFormulari
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdNou_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdNou
' Crida a una funci per inserir-hi un registre nou
'----------------------------------------------------------------------------------------------
Private Sub cmdNou_Click()
   Nou
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdEditar_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdEditar
' Crida a una funci per editar el registre que es mostra per pantalla
'----------------------------------------------------------------------------------------------
Private Sub cmdEditar_Click()
   Editar
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdEliminar_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdEliminar
' Crida a una funci per eliminar el registre que es mostra per pantalla
'----------------------------------------------------------------------------------------------
Private Sub cmdEliminar_Click()
   Eliminar
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdSortir_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdSortir
' Crida a una funci per sortir del formulari
'----------------------------------------------------------------------------------------------
Private Sub cmdSortir_Click()
   Sortir
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdSortirEdicio_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdSortirEdicio
' Crida a una funci per sortir del mode d'edici i guardar els canvis
'----------------------------------------------------------------------------------------------
Private Sub cmdSortirEdicio_Click()
   SortirEdicio
End Sub
'----------------------------------------------------------------------------------------------
'-- cmdDesferCanvis_Click
'----------------------------------------------------------------------------------------------
' S'activa quan es fa clic en el bot cmdDesferCanvis
' Crida a una funci per sortir del mode d'edici sense guardar els canvis
'----------------------------------------------------------------------------------------------
Private Sub cmdDesferCanvis_Click()
   UndoChanges
End Sub

'----------------------------------------------------------------------------------------------
'-- lstZones_Click()
'----------------------------------------------------------------------------------------------
' S'executa quan es fa clic a la llista de Zones
'----------------------------------------------------------------------------------------------
Private Sub lstZones_Click()
   RefrescaFormulariAmbLlista
End Sub

'----------------------------------------------------------------------------------------------
'-- cmdRutaZona_Click()
'----------------------------------------------------------------------------------------------
' S'executa quan es fa clic al bot de RutaZona
'----------------------------------------------------------------------------------------------
Private Sub cmdRutaZona_Click()
   SeleccionaArxiu
End Sub

'**********************************************************************************************
'-- Funcions de nivell superior
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- RefreshModeFormEdicio
'----------------------------------------------------------------------------------------------
' S'executa cada vegada que s'assigna la variable RefreshModeFormEdicio
' Habilita o deshabilita els butons i els controls d'entrada segons el valor de la variable
'----------------------------------------------------------------------------------------------
Private Sub RefreshModeFormEdicio(bolModeFormulari As Boolean)
   Dim ctrDades As Control
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
          
   'Fa visible els botons corresponents a cada mode del formulari
   Me.cmdNou.Visible = (Not bolModeFormulari)
   Me.cmdEditar.Visible = (Not bolModeFormulari)
   Me.cmdEliminar.Visible = (Not bolModeFormulari)
   Me.cmdSortir.Visible = (Not bolModeFormulari)
   Me.cmdSortirEdicio.Visible = bolModeFormulari
   Me.cmdDesferCanvis.Visible = bolModeFormulari
   Me.cmdSituar.Enabled = bolModeFormulari
   Me.cmdRutaZona.Enabled = bolModeFormulari
   
   'Si estem en mode d'edici, habilita els controls d'entrada de dades i, si no,
   'els deshabilita
   For Each ctrDades In Me.Controls
      If TypeName(ctrDades) = "TextBox" Or TypeName(ctrDades) = "ComboBox" Or _
       TypeName(ctrDades) = "DataCombo" Then
         ctrDades.Locked = (Not bolModeFormulari)
      End If
   Next ctrDades
   Me.lstZones.Enabled = Not bolModeFormulari
   
   Exit Sub
    
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefreshModeFormEdicio"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- IniciFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques d'inicialitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub IniciFormulari()
   Dim lngComptador As Long
  
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
 
   'Crea una instncia de les classes SvrZones i objFuncionsComuns
   'per utilitzar-ne els mtodes i propietats
   Set objFuncionsComuns = New clsFuncionsCapaInterficie
   
  'Recupera una referncia a la classe de suport
   Set objClasseSuportActual = objFuncionsComuns.CreaObjecteSuport("SvrZones")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Recupera els textos del formulari traduts a l'idioma per defecte
   
   Set rstRecordsetIdioma = objFuncionsComuns.TradueixFormulariIdioma(Me, Sistema.Idioma)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
      
   'Posa el nom als encapalaments de columna de la llista de punts
   ConfiguraLlistaPunts
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   'No estem en mode d'actualitzaci
   bolModeFormActualitzacio = 0
         
   'Recupera els Zones de la BD
   RecuperaZones
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
      
   'Enllaa els controls al recordset acabat de crear
   objFuncionsComuns.LinkControls Me
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   If rstRecordsetActual.RecordCount = 0 Then
      strCodiActualitzacio = ""
   Else
      strCodiActualitzacio = CStr(rstRecordsetActual.Fields(ctstrCampLlista))
   End If
   
   'Refresca el formulari per tal que s'hi vegi el seu estat actualitzat
   RefrescaFormulariActualitzacio
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   
   'Posa el formulari en mode de consulta (no edici)
   bolModeFormEdicio = False
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - IniciFormulari"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- FiFormulari()
'----------------------------------------------------------------------------------------------
' Executa totes les tasques de finalitzaci del formulari
'----------------------------------------------------------------------------------------------
Private Sub FiFormulari()
   'Allibera les instncies de les classes
   Set objClasseSuportActual = Nothing
   Set objFuncionsComuns = Nothing
End Sub

'----------------------------------------------------------------------------------------------
'-- Nou
'----------------------------------------------------------------------------------------------
' Crea un registre en blanc per editar un nou registre
'----------------------------------------------------------------------------------------------

Private Sub Nou()
   Dim strCadenaValidacio  As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Es fixa el mode d'actualitzaci
   bolModeFormActualitzacio = 1
    
   'Afegeix un registre nou al recordset i li omple el camp projecte
   rstRecordsetActual.AddNew
   rstRecordsetActual!NumProjecte = Sistema.Projecte
   
   'Posa en blanc la llista de punts si s nou
   ObtePuntsZonaActual
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   'Posa el formulari en mode d'edici
   bolModeFormEdicio = True
   
   'Com que no hi ha cap element seleccionat, per convenci
   'posa la cadena buida com a element que estava seleccionat actualment
   strCodiActualitzacio = ""
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Nou"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Editar
'----------------------------------------------------------------------------------------------
' Posa el formulari en mode d'edici
'----------------------------------------------------------------------------------------------
Private Sub Editar()
   Dim strCadenaValidacio As String
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
       
    
   strCadenaValidacio = CadenaValidacioEditar()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
       MsgBox (strCadenaValidacio)
   Else
       'Posa el mode d'edici a cert
       bolModeFormEdicio = True
       'Es fixa el mode d'actualitzaci
       bolModeFormActualitzacio = 2
       
       'Guarda el codi seleccionat actualment a strCodiActualitzacio
       strCodiActualitzacio = CStr(rstRecordsetActual.Fields(ctstrCampLlista))
       
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Editar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- Eliminar
'----------------------------------------------------------------------------------------------
' Elimina el registre actual de la base de dades
'----------------------------------------------------------------------------------------------
Private Sub Eliminar()
   Dim bolResultat As Boolean
   Dim strCadenaValidacio  As String
   Dim lngIndexSeleccionatAbansEliminar As Long
   Dim strTextValidacioEliminar As String
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Mira si es pot eliminar el registre i, si s aix, l'elimina. Altrament emet un error
   strCadenaValidacio = CadenaValidacioEliminar()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
      MsgBox (strCadenaValidacio)
   Else
      'Recupera els textos traduits per omplir el textbox que indica el nmero de registre
      strTextValidacioEliminar = objFuncionsComuns.TradueixDefecteMissatgeFormulariIdioma _
       (rstRecordsetIdioma, "valTextEliminar", "valTextEliminar")
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
         
      If MsgBox(strTextValidacioEliminar, vbYesNo) = vbYes Then
      
         'Es fixa el mode d'actualitzaci
         bolModeFormActualitzacio = 2
      
         'Es recull el codi anterior a l'esborrat per seleccionar-lo desprs d'esborrar
         If Me.lstZones.ListCount > 1 Then
            'Si abans d'esborrar noms hi ha 2 elements o b l'element seleccionat s el primer de la llista,
            'desprs de l'esborrat, l'element seleccionat ser el primer
            If Me.lstZones.ListCount = 2 Or Me.lstZones.ListIndex = 0 Then
               strCodiActualitzacio = "" 'La cadena buida indica que seleccionarem el primer element
            Else
               'En cas contrari, ser l'anterior a l'esborrat
               strCodiActualitzacio = CStr(Me.lstZones.List(Me.lstZones.ListIndex - 1))
            End If
         End If
          
         'Esborra el registre del recordset actual
         rstRecordsetActual.Delete
      
         'Propaga els canvis a la BD
         PropagaCanvisABD
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
        
         'Refresca el formulari desprs d'una actualitzaci
         RefrescaFormulariActualitzacio
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
         
         RefrescaFormulariLectura
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
            
         'Es fixa el mode d'actualitzaci
         bolModeFormActualitzacio = 0
      End If
   End If
        
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - Eliminar"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- Sortir
'----------------------------------------------------------------------------------------------
' Surt del formulari
'----------------------------------------------------------------------------------------------
Private Sub Sortir()
   Unload Me
End Sub
'----------------------------------------------------------------------------------------------
'-- SortirEdicio
'----------------------------------------------------------------------------------------------
'Si els canvis realitzats durant l'edici sn vlids, surt del mode d'edici
'Si no, emet un missatge d'error
'---------------------------------------------------------------------------------------------
Private Sub SortirEdicio()
   Dim strCadenaValidacio As String
   Dim strCodiEditat As String
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
    
   'Mira si el registre que acabem d'introduir s vlid
   strCadenaValidacio = CadenaValidacioRegistreActual()
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   If strCadenaValidacio <> "" Then
      MsgBox (strCadenaValidacio)
   Else
      'Si ho s, fa un Update i propaga els canvis a la BD
      If rstRecordsetActual.RecordCount > 0 Then
      
         strCodiEditat = CStr(rstRecordsetActual.Fields(ctstrCampLlista))
         
         rstRecordsetActual.Update
                           
         'Propaga el canvi a la BD
         PropagaCanvisABD
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
                  
        'Si el codi ha canviat, refresca la llista
        If strCodiActualitzacio <> strCodiEditat Then
            strCodiActualitzacio = strCodiEditat
            RefrescaFormulariActualitzacio
            If NumError <> ctintErrorOK Then
               Err.Raise NumError
            End If
         End If
         
         'Refresca els camps
         RefrescaFormulariLectura
         If NumError <> ctintErrorOK Then
            Err.Raise NumError
         End If
         
      End If
      
      'Posa el mode d'edici a fals
      bolModeFormEdicio = False
        
      'Es fixa el mode d'actualitzaci
      bolModeFormActualitzacio = 0
    End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - SortirEdicio"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- UndoChanges
'----------------------------------------------------------------------------------------------
' Desf els canvis produts amb el mode d'edici
'----------------------------------------------------------------------------------------------
Private Sub UndoChanges()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   
   'Cancella l'Update i refresca el formulari
   rstRecordsetActual.CancelUpdate
   
   'Refresca els camps del formulari
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
       
   bolModeFormEdicio = False
   
   'Es fixa el mode d'actualitzaci
   bolModeFormActualitzacio = 0
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - UndoChanges"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariAmbLlista()
'----------------------------------------------------------------------------------------------
' Quan es fa clic a la llista,
' es refresquen les dades del formulari amb el Zona escollit de la llista
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariAmbLlista()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
   RefrescaFormulariLectura
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
  
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariAmbLlista"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- SeleccionaArxiu
'----------------------------------------------------------------------------------------------
' Selecciona un arxiu obrint un cuadre de dileg
'----------------------------------------------------------------------------------------------
Private Sub SeleccionaArxiu()
   Dim strRuta As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
   strRuta = objFuncionsComuns.EscullArxiu()
   
   If strRuta <> "" Then
      rstRecordsetActual!FotoZona = strRuta
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - SeleccionaArxiu"
   objFuncionsComuns.EmetError NumError, UbicacioError, Sistema.Idioma
   Exit Sub
End Sub


'**********************************************************************************************
'-- Funcions que no sn de nivell superior
'**********************************************************************************************
'----------------------------------------------------------------------------------------------
'-- ConfiguraLlistaPunts()
'----------------------------------------------------------------------------------------------
' Configura el ListView de punts
'----------------------------------------------------------------------------------------------

Private Sub ConfiguraLlistaPunts()
   Dim clhTitolColumna As ColumnHeader
   Dim lngNombreCamps As Long
   Dim lngNombreCampsVisibles As Long
   Dim lngComptadorCamps As Long
   Dim strNomCamp As String
   Dim strNomColumna As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Posa els noms traduts a l'encapalament de les columnes
   lstPunts.ColumnHeaders(1).Text = objFuncionsComuns.TradueixDefecteMissatgeFormulariIdioma _
    (rstRecordsetIdioma, "clhNumOrdre", "Num. Ordre")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
      
   lstPunts.ColumnHeaders(2).Text = objFuncionsComuns.TradueixDefecteMissatgeFormulariIdioma _
    (rstRecordsetIdioma, "clhX", "X")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   lstPunts.ColumnHeaders(3).Text = objFuncionsComuns.TradueixDefecteMissatgeFormulariIdioma _
    (rstRecordsetIdioma, "clhY", "Y")
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
      
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - ConfiguraLlistaPunts"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariActualitzacio()
'----------------------------------------------------------------------------------------------
' Refresca el formulari desprs d'una actualitzaci
' Posa en la llista de Zones en el camp corresponent
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariActualitzacio()
   Dim strCodiActual As String
   Dim bolRegistreActualSeleccionat As Boolean
   Dim bolAlgunRegistreSeleccionat As Boolean
   Dim lngIndexSeleccionat As Long
      
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Buida la llista
   Me.lstZones.Clear
   Me.lstZones.ListIndex = -1
         
   If rstRecordsetActual.RecordCount > 0 Then
      bolAlgunRegistreSeleccionat = False
      rstRecordsetActual.MoveFirst
      Do While Not rstRecordsetActual.EOF
         'Es recupera el codi actual i s'insereix a la llista
         strCodiActual = CStr(rstRecordsetActual.Fields(ctstrCampLlista))
         
         Me.lstZones.AddItem strCodiActual
         Me.lstZones.ItemData(lstZones.NewIndex) = _
          rstRecordsetActual.AbsolutePosition
          
         'Es calcula la posici que t l'element que s'ha de seleccionar
         'desprs d'aquesta inserci
         If bolAlgunRegistreSeleccionat Then
            If lstZones.NewIndex <= lngIndexSeleccionat Then
               lngIndexSeleccionat = lngIndexSeleccionat + 1
            End If
         Else
            If (strCodiActual = strCodiActualitzacio) Then
               lngIndexSeleccionat = lstZones.NewIndex
               bolAlgunRegistreSeleccionat = True
            End If
         End If
         
         rstRecordsetActual.MoveNext
      Loop
     
      'Si no s'ha aconseguit seleccionar cap registre (per alguna fallada del programa)
      'se selecciona la primera posici de la llista
      If bolAlgunRegistreSeleccionat Then
         Me.lstZones.ListIndex = lngIndexSeleccionat
      Else
         Me.lstZones.ListIndex = 0
      End If
   End If

   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariActualitzacio"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- RefrescaFormulariLectura()
'----------------------------------------------------------------------------------------------
' Refresca el formulari desprs d'una lectura
' Concretament, refresca els camps segons el Zona seleccionat
'----------------------------------------------------------------------------------------------
Private Sub RefrescaFormulariLectura()
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Mou el recordset fins al nmero de registre seleccionat des del Listbox
   If rstRecordsetActual.RecordCount > 0 And Me.lstZones.ListCount > 0 Then
      rstRecordsetActual.Move Me.lstZones.ItemData(Me.lstZones.ListIndex) - 1, _
       adBookmarkFirst
   End If
   
   'Obt els punts i omple la llista de punts
   ObtePuntsZonaActual
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
   
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaFormulariLectura"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- PropagaCanvisABD
'----------------------------------------------------------------------------------------------
' Guarda els canvis que s'han fet sobre el Recordset
' a la Base de Dades
'----------------------------------------------------------------------------------------------
Private Sub PropagaCanvisABD()
   Dim strCadenaValidacio  As String
   Dim StrCadenaXML As String
   Dim bolResultat As Boolean
   Dim StrXMLDades As String
   Dim strXMLCanvis As String
   Dim strClauForana As String
   Dim lngClauPrimaria As Long
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
      
   'Desenllaa per tal que es copi b el Recordset
   objFuncionsComuns.DeslinkControls Me
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Obte la cadena XML corresponent al recordset actual
   StrCadenaXML = objFuncionsComuns.PassaRecordsetAXML(rstRecordsetActual)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Obt noms les actualitzacions de la cadena XML
   strXMLCanvis = objFuncionsComuns.ObteActualitzacionsDeXML(StrCadenaXML)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   'Es graven els canvis a la base de dades
   bolResultat = objClasseSuportActual.SaveZona(strXMLCanvis)
   If objClasseSuportActual.NumError <> ctintErrorOK Then
      UbicacioError = objClasseSuportActual.UbicacioError
      Err.Raise objClasseSuportActual.NumError
   End If
      
   'Refresca la informacio del Recordset
   RecuperaZones
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
       
   objFuncionsComuns.LinkControls Me 'Torna a enllaar-se les dades
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
    
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - PropagaCanvisABD"
   objFuncionsComuns.LinkControls Me
   Exit Sub
   
End Sub
'----------------------------------------------------------------------------------------------
'-- RecuperaZones()
'----------------------------------------------------------------------------------------------
' Crea un recordset amb la mateixa informaci que el recordset actual
' per que no t cap actualitzaci pendent
'----------------------------------------------------------------------------------------------
Public Sub RecuperaZones()
   Dim strResultat As String
   Dim rstTemp As ADODB.Recordset
    
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
    
   'Si es tracta del comenament del formulari o d'una inserci
   If bolModeFormActualitzacio = 0 Or bolModeFormActualitzacio = 1 Then
      'Es recuperen els Zones mitjanant la classe SvrZones
      strResultat = objClasseSuportActual.GetZones(Sistema.Projecte)

      If objClasseSuportActual.NumError <> ctintErrorOK Then
         UbicacioError = objClasseSuportActual.UbicacioError
         Err.Raise objClasseSuportActual.NumError
      End If
   Else
      'En cas de modificaci o esborrat, es purguen les actualitzacions
      'del recordset perqu no cal accedir a les capes inferiors
      strResultat = objFuncionsComuns.PurgaActualitzacionsRecordset(rstRecordsetActual)
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
   End If
    
   'Si no hi ha hagut errors, crea el Recordset a partir de l'XML
   Set rstRecordsetActual = objFuncionsComuns.PassaXMLARecordset(strResultat)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RecuperaZones"
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- ObtePuntsZonaActual()
'----------------------------------------------------------------------------------------------
' Obt el recordset de punts i emplena la llista del GIS amb els punts corresponents a
' aquest recordset
'----------------------------------------------------------------------------------------------
Public Sub ObtePuntsZonaActual()
   Dim strXMLTemporal As String
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
   
   'Si hi ha una zona, troba els seus punts i els colloca en el recordset de punts
   If rstRecordsetActual.RecordCount > 0 And Not rstRecordsetActual.EOF And _
    Not IsNull(rstRecordsetActual!NumZona) Then
      
      strXMLTemporal = objClasseSuportActual.GetZonaPunts(rstRecordsetActual!NumZona)
      If objClasseSuportActual.NumError <> ctintErrorOK Then
         UbicacioError = objClasseSuportActual.UbicacioError
         Err.Raise objClasseSuportActual.NumError
      End If
   Else
   'Si no hi ha, recupera el recordset buit de punts per posar-lo en el recordset de Punts
      strXMLTemporal = objClasseSuportActual.GetEmptyRstZonaPunts()
      If objClasseSuportActual.NumError <> ctintErrorOK Then
         UbicacioError = objClasseSuportActual.UbicacioError
         Err.Raise objClasseSuportActual.NumError
      End If
   End If
   
   'Passa els recordsets de XML a ADO
   Set rstRecordsetPunts = objFuncionsComuns.PassaXMLARecordset(strXMLTemporal)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   'Refresca la llista de punts del formulari
   RefrescaLlistaGIS
   If NumError <> ctintErrorOK Then
      Err.Raise NumError
   End If
  
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - ObtePuntsZonaActual"
   Exit Sub
End Sub
'----------------------------------------------------------------------------------------------
'-- RefrescaLlistaGIS()
'----------------------------------------------------------------------------------------------
' Emplena la llista del GIS amb els punts corresponents a la
' zona actual
'----------------------------------------------------------------------------------------------
Public Sub RefrescaLlistaGIS()
   Dim itmItemActual As ListItem
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
 
   'Omple la llista de punts
   Me.lstPunts.ListItems.Clear
   'Si el recordset no s buit
  
   If rstRecordsetPunts.RecordCount > 0 Then
      'Recorre i posa el valor de cada camp a la columna del mateix nom
      rstRecordsetPunts.MoveFirst
      Do While Not rstRecordsetPunts.EOF
         'Afegeix el registre amb el camp corresponent a la primera columna
         Set itmItemActual = Me.lstPunts.ListItems.Add(, _
          "Clau" & Trim(str(rstRecordsetPunts.AbsolutePosition)), rstRecordsetPunts!NumOrdre)
         itmItemActual.SubItems(1) = rstRecordsetPunts!VertexX
         itmItemActual.SubItems(2) = rstRecordsetPunts!VertexY
         rstRecordsetPunts.MoveNext
      Loop
      Set lstPunts.SelectedItem = lstPunts.ListItems(1) 'Selecciona el primer registre
   End If
Exit Sub
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - RefrescaLlistaGIS"
   Exit Sub
End Sub

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioRegistreActual()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per guardar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioRegistreActual()
   Dim bolCampRepetit As Boolean
   Dim strCodiMissatge As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""

   'Mira que s'omplin tots els camps
     
   If rstRecordsetActual.RecordCount > 0 And (Me.txtCodZona.Text = "" Or _
    Me.txtNomZona.Text = "") Then
      strCodiMissatge = "valAlgunCampNecessariBuit"
   Else
      'Mira que no hi hagi un altre registre amb el mateix codi
      bolCampRepetit = objFuncionsComuns.ValorCampRepetit(rstRecordsetActual, ctstrCampLlista)
      If objFuncionsComuns.NumError <> ctintErrorOK Then
         UbicacioError = objFuncionsComuns.UbicacioError
         Err.Raise objFuncionsComuns.NumError
      End If
      
      If bolCampRepetit Then
         strCodiMissatge = "valRepetitCodiZona"
      Else
         strCodiMissatge = ""
      End If
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioRegistreActual = strResultat
   Exit Function
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioRegistreActual"
   CadenaValidacioRegistreActual = ""
   Exit Function
   
End Function

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioEliminar()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per eliminar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioEliminar()
   Dim bolZonaAmbProjectes As Boolean
   Dim strCodiMissatge As String
   Dim strResultat As String

   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
  
   '#PENDENT Que no es pugui esborrar una zona que tingui escomeses
   If rstRecordsetActual.RecordCount = 0 Then
      strCodiMissatge = "valNoRegistresEliminar"
   Else
      strCodiMissatge = ""
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioEliminar = strResultat
   Exit Function
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioEliminar"
   CadenaValidacioEliminar = ""
   Exit Function
End Function

'----------------------------------------------------------------------------------------------
'-- CadenaValidacioEditar()
'----------------------------------------------------------------------------------------------
' Si els camps del formulari sn correctes per eliminar, retorna la cadena buida
' Altrament, retorna una cadena que serveix per identificar l'error.
'----------------------------------------------------------------------------------------------
Private Function CadenaValidacioEditar()

   Dim strCodiMissatge As String
   Dim strResultat As String
   
   'Activa la rutina de tractament de errors i posa els valors
   'per defecte a les variables d'error
   On Error GoTo TractaError
   NumError = ctintErrorOK
   UbicacioError = ""
     
   If rstRecordsetActual.RecordCount = 0 Then
      strCodiMissatge = "valNoRegistresEditar"
   Else
      strCodiMissatge = ""
   End If
   
   'Obt el text tradut del missatge
   strResultat = objFuncionsComuns.TradueixMissatgeFormulariIdioma _
    (rstRecordsetIdioma, strCodiMissatge)
   If objFuncionsComuns.NumError <> ctintErrorOK Then
      UbicacioError = objFuncionsComuns.UbicacioError
      Err.Raise objFuncionsComuns.NumError
   End If
   
   CadenaValidacioEditar = strResultat
   Exit Function
   
TractaError:
   'Si hi ha hagut error, posa valor a les variables d'error i les emet per pantalla
   NumError = Err.Number
   UbicacioError = UbicacioError & Chr(13) & ctstrNomModul & " - " & Me.Name & _
    " - CadenaValidacioEditar"
   CadenaValidacioEditar = ""
   Exit Function
End Function

