DEFINE CLASS CasillaCargosCheque AS CantidadMonetaria
	Caption = ''
	Width = 92
	BackStyle = 0
	DentroGrid = .T.
	controlsource = "bamv01101.cargos"
	Modificacuando = "M.DETA"
	InputMask = "999,999,999.99"
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
	PROCEDURE Valid 
		IF This.value > 0.00
			THISFORM.GRID1.COLUMN5.TEXT1.ENABLED = .F.
		ELSE
			THISFORM.GRID1.COLUMN5.TEXT1.ENABLED = .T.	
		ENDIF
		nRegistro = IIF(EOF(),EOF(),RECNO())
*
		IF bamv01101.cargos <> 0.00 THEN
			REPLACE abonos with 0.00
		ENDIF

		SUM BAMV01101.cargos FOR BAMV01101.NUMDOC = w_numdoc TO ThisForm.Text1.value
		REPLACE BAMV01001.totcargos WITH ThisForm.Text1.value IN BAMV01001
		SUM BAMV01101.abonos FOR BAMV01101.NUMDOC = w_numdoc TO ThisForm.Text2.value
		REPLACE BAMV01001.totabonos WITH ThisForm.Text2.value IN BAMV01001
		ThisForm.Text4.value = ThisForm.Text2.value + ThisForm.Text3.value
		THISFORM.REFRESH

*
		IF TYPE('nRegistro') = 'N'
			GO RECORD nRegistro
		ENDIF
		REPLACE BAMV01001.totcargos WITH ThisForm.Text1.value IN BAMV01001
		THISFORM.REFRESH
	ENDPROC
ENDDEFINE

DEFINE CLASS CasillaAbonosCheque AS CantidadMonetaria
	Caption = ''
	Width = 92
	BackStyle = 0
	DentroGrid = .T.
	controlsource = "bamv01101.abonos"
	InputMask = "999,999,999.99"
	Modificacuando = "M.DETA"
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
	PROCEDURE Valid
		IF This.value > 0.00
			THISFORM.GRID1.COLUMN4.TEXT1.ENABLED = .F.
		ELSE
			THISFORM.GRID1.COLUMN4.TEXT1.ENABLED = .T.
		ENDIF
		nRegistro = IIF(EOF(),EOF(),RECNO())
*
		IF bamv01101.abonos <> 0.00 THEN
			REPLACE cargos with 0.00
		ENDIF

		SUM BAMV01101.cargos FOR BAMV01101.NUMDOC = w_numdoc TO ThisForm.Text1.value
		REPLACE BAMV01001.totcargos WITH ThisForm.Text1.value IN BAMV01001
		SUM BAMV01101.abonos FOR BAMV01101.NUMDOC = w_numdoc TO ThisForm.Text2.value
		REPLACE BAMV01001.totabonos WITH ThisForm.Text2.value IN BAMV01001
		ThisForm.Text4.value = ThisForm.Text2.value + ThisForm.Text3.value
		THISFORM.REFRESH
		
*
		IF TYPE('nRegistro') = 'N'
			GO RECORD nRegistro
		ENDIF
		REPLACE BAMV01001.totabonos WITH ThisForm.Text2.value IN BAMV01001
		THISFORM.REFRESH
	ENDPROC
ENDDEFINE

DEFINE CLASS CasillaCargosRemesa AS CantidadMonetaria
	Alignment = 1
	Caption = ''
	Width = 100
	BackStyle = 0
	DentroGrid = .T.
	controlsource = "bamv02101.cargos"
	Modificacuando = "M.DETA"
	InputMask = "999,999,999.99"
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
	PROCEDURE Valid
		IF This.value > 0.00
			THISFORM.GRID1.COLUMN5.TEXT1.ENABLED = .F.
		ELSE
			THISFORM.GRID1.COLUMN5.TEXT1.ENABLED = .T.
		ENDIF
		nRegistro = IIF(EOF(),EOF(),RECNO())
*
		IF bamv02101.cargos <> 0.00 THEN
			REPLACE abonos with 0.00
		ENDIF

		SUM BAMV02101.cargos FOR BAMV02101.NUMDOC = w_numdoc TO ThisForm.Text2.value
		REPLACE BAMV02001.totcargos WITH ThisForm.Text2.value IN BAMV02001
		SUM BAMV02101.abonos FOR BAMV02101.NUMDOC = w_numdoc TO ThisForm.Text1.value
		REPLACE BAMV02001.totabonos WITH ThisForm.Text1.value IN BAMV02001
		THISFORM.REFRESH

*
		IF TYPE('nRegistro') = 'N'
			GO RECORD nRegistro
		ENDIF
		REPLACE BAMV02001.totcargos WITH ThisForm.Text2.value IN BAMV02001
	ENDPROC
ENDDEFINE

DEFINE CLASS CasillaAbonosRemesa AS CantidadMonetaria
	Alignment = 1
	Caption = ''
	Width = 80
	BackStyle = 0
	DentroGrid = .T.
	controlsource = "bamv02101.abonos"
	InputMask = "999,999,999.99"
	Modificacuando = "M.DETA"
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
	PROCEDURE Valid
		IF This.value > 0.00
			THISFORM.GRID1.COLUMN4.TEXT1.ENABLED = .F.
		ELSE
			THISFORM.GRID1.COLUMN4.TEXT1.ENABLED = .T.
		ENDIF
		nRegistro = IIF(EOF(),EOF(),RECNO())
*
		IF bamv02101.abonos <> 0.00 THEN
			REPLACE CARGOS with 0.00
		ENDIF

		SUM BAMV02101.abonos FOR BAMV02101.NUMDOC = w_numdoc TO ThisForm.Text1.value
		REPLACE BAMV02001.totabonos WITH ThisForm.Text1.value IN BAMV02001
		SUM BAMV02101.cargos FOR BAMV02101.NUMDOC = w_numdoc TO ThisForm.Text2.value
		REPLACE BAMV02001.totcargos WITH ThisForm.Text2.value IN BAMV02001
		THISFORM.REFRESH

*
		IF TYPE('nRegistro') = 'N'
			GO RECORD nRegistro
		ENDIF
		REPLACE BAMV02001.totabonos WITH ThisForm.Text1.value IN BAMV02001
	ENDPROC
	
ENDDEFINE

DEFINE CLASS CasillaCargosNCargo AS CantidadMonetaria
	Alignment = 1
	Caption = ''
	Width = 100
	BackStyle = 0
	DentroGrid = .T.
	controlsource = "bamv03101.cargos"
	Modificacuando = "M.DETA"
	InputMask = "999,999,999.99"
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
	PROCEDURE Valid
		IF This.value > 0.00
			THISFORM.GRID1.COLUMN5.TEXT1.ENABLED = .F.
		ELSE
			THISFORM.GRID1.COLUMN5.TEXT1.ENABLED = .T.
		ENDIF
		nRegistro = IIF(EOF(),EOF(),RECNO())
*
		IF bamv03101.cargos <> 0.00 THEN
			REPLACE abonos with 0.00
		ENDIF

		SUM BAMV03101.cargos FOR BAMV03101.NUMDOC = w_numdoc TO ThisForm.Text1.value
		REPLACE BAMV03001.totcargos WITH ThisForm.Text1.value IN BAMV03001
		SUM BAMV03101.abonos FOR BAMV03101.NUMDOC = w_numdoc TO ThisForm.Text2.value
		REPLACE BAMV03001.totabonos WITH ThisForm.Text2.value IN BAMV03001
		THISFORM.REFRESH

*
		IF TYPE('nRegistro') = 'N'
			GO RECORD nRegistro
		ENDIF
		REPLACE BAMV03001.totcargos WITH ThisForm.Text1.value IN BAMV03001
	ENDPROC
ENDDEFINE

DEFINE CLASS CasillaAbonosNcargo AS CantidadMonetaria
	Alignment = 1
	Caption = ''
	Width = 80
	BackStyle = 0
	DentroGrid = .T.
	controlsource = "bamv03101.abonos"
	InputMask = "999,999,999.99"
	Modificacuando = "M.DETA"
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
	PROCEDURE Valid
		IF This.value > 0.00
			THISFORM.GRID1.COLUMN4.TEXT1.ENABLED = .F.
		ELSE
			THISFORM.GRID1.COLUMN4.TEXT1.ENABLED = .T.
		ENDIF
		nRegistro = IIF(EOF(),EOF(),RECNO())
*
		IF bamv03101.abonos <> 0.00 THEN
			REPLACE cargos with 0.00
		ENDIF

		SUM BAMV03101.abonos FOR BAMV03101.NUMDOC = w_numdoc TO ThisForm.Text2.value
		REPLACE BAMV03001.totabonos WITH ThisForm.Text2.value IN BAMV03001
		SUM BAMV03101.cargos FOR BAMV03101.NUMDOC = w_numdoc TO ThisForm.Text1.value
		REPLACE BAMV03001.totcargos WITH ThisForm.Text1.value IN BAMV03001
		THISFORM.REFRESH

*
		IF TYPE('nRegistro') = 'N'
			GO RECORD nRegistro
		ENDIF
		REPLACE BAMV03001.totabonos WITH ThisForm.Text2.value IN BAMV03001
	ENDPROC
ENDDEFINE

DEFINE CLASS CasillaCargosNAbono AS CantidadMonetaria
	Alignment = 1
	Caption = ''
	Width = 100
	BackStyle = 0
	DentroGrid = .T.
	controlsource = "bamv04101.cargos"
	Modificacuando = "M.DETA"
	InputMask = "999,999,999.99"
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
	PROCEDURE Valid
		nRegistro = IIF(EOF(),EOF(),RECNO())
*
		IF bamv04101.cargos <> 0.00 THEN
			REPLACE abonos with 0.00
		ENDIF

		SUM BAMV04101.cargos FOR BAMV04101.NUMDOC = w_numdoc TO ThisForm.Text2.value
		REPLACE BAMV04001.totcargos WITH ThisForm.Text2.value IN BAMV04001
		SUM BAMV04101.abonos FOR BAMV04101.NUMDOC = w_numdoc TO ThisForm.Text1.value
		REPLACE BAMV04001.totabonos WITH ThisForm.Text1.value IN BAMV04001
		THISFORM.REFRESH

*
		IF TYPE('nRegistro') = 'N'
			GO RECORD nRegistro
		ENDIF
		REPLACE BAMV04001.totcargos WITH ThisForm.Text2.value IN BAMV04001
	ENDPROC
ENDDEFINE

DEFINE CLASS CasillaAbonosNAbono AS CantidadMonetaria
	Alignment = 1
	Caption = ''
	Width = 80
	BackStyle = 0
	DentroGrid = .T.
	controlsource = "bamv04101.abonos"
	InputMask = "999,999,999.99"
	Modificacuando = "M.DETA"
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
	PROCEDURE Valid
		nRegistro = IIF(EOF(),EOF(),RECNO())
*
		IF bamv04101.abonos <> 0.00 THEN
				REPLACE cargos with 0.00
		ENDIF

			SUM BAMV04101.abonos FOR BAMV04101.NUMDOC = w_numdoc TO totalab
			REPLACE BAMV04001.totabonos WITH ThisForm.Text1.value IN BAMV04001
			SUM BAMV04101.cargos FOR BAMV04101.NUMDOC = w_numdoc TO ThisForm.Text2.value
			REPLACE BAMV04001.totcargos WITH ThisForm.Text2.value IN BAMV04001
			THISFORM.REFRESH
*
			tabla = ALIAS()
			SELECT BAMV04001
			REPLACE totabonos WITH totalab
			SELECT (tabla)
			IF TYPE('nRegistro') = 'N'
				GO RECORD nRegistro
			ENDIF
		THISFORM.REFRESH
	ENDPROC
ENDDEFINE

PROCEDURE destraslada(tabla, tabla2)
	LOCAL temp
	SELEC &tabla
	SCAN FOR fecdoc = m.fechat AND trasladado = .T. AND empresa = nCodigo
		temp = tabla+".numdoc"
		REPLACE ALL trasladado WITH .F. FOR numdoc = &temp AND trasladado = .T.	AND empresa = nCodigo IN &tabla2	
	ENDSCAN
	REPLACE ALL trasladado WITH .F. FOR fecdoc = m.fechat AND empresa = nCodigo IN &tabla
ENDPROC

PROCEDURE PROPAGA_BANCARIO
	DO PROPAGA_BANCOS
	DO PROPAGA_CUENTAS_BANCO
ENDPROC

PROCEDURE CREA_BANCARIO_NUEVO_MES
	W_DESDEANT = W_DESDE
	W_HASTAANT = W_HASTA
	W_MESMAXANT = W_MESMAX
	W_ANYOMAXANT = W_ANYOMAX
	DO CREA_BANCOS_NUEVO_MES
	W_DESDE = W_DESDEANT
	W_HASTA = W_HASTAANT
	W_MESMAX = W_MESMAXANT
	W_ANYOMAX = W_ANYOMAXANT
	DO CREA_CUENTAS_BANCO_NUEVO_MES
ENDPROC

PROCEDURE PROPAGA_BANCOS
	LOCAL filtro, mesactual, anyoactual, contames, contaanyo, nregist
		
		mesactual = MONTH(W_DESDE)
		anyoactual = YEAR(W_DESDE)
		IF NOT USED('BAMT0100') THEN
			USE BAMT0100 IN 0 ALIAS BAMT0100 EXCLUSIVE
		ENDIF
		SELECT BAMT0100
		filtro = FILTER()
		SET FILTER TO
		LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual
		DO WHILE NOT EOF()
			nregist = RECNO()
			
			contames = MES_MESDESPUES(mesactual,anyoactual)
			contaanyo = ANYO_MESDESPUES(mesactual,anyoactual)
			codigobanco = bamt0100.codbco
			
			IF NOT BAMT0100.POSTERIOR THEN
		
				REPLACE POSTERIOR WITH .T.
				encontradaconmismocodigo = .F.
				
				DO WHILE NOT POSTERIORMES (contames, contaanyo, W_MESMAX, W_ANYOMAX) AND NOT encontradaconmismocodigo
					nreg1 = GUARDANUMEROREGISTRO()
					LOCATE FOR codbco = codigobanco AND nmes = contames AND anyo = contaanyo AND empresa = nCodigo
					encontradaconmismocodigo = FOUND()
					RECUPERANUMEROREGISTRO(nreg1)
					
					IF NOT encontradaconmismocodigo THEN
						SCATTER MEMVAR
						
						M.posterior = ((contames <> W_MESMAX) OR (contaanyo <> W_ANYOMAX))
				
						M.nmes = contames
						M.anyo = contaanyo
					
						INSERT INTO BAMT0100 FROM MEMVAR
						
						contamesant = contames
						contaanyoant = contaanyo
						contames = MES_MESDESPUES(contamesant,contaanyoant)			
						contaanyo = ANYO_MESDESPUES (contamesant,contaanyoant)
					ENDIF
						
				ENDDO
			ENDIF
			
			
			GO nregist
			SKIP
			IF NOT EOF() THEN
				LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual REST
			ENDIF
		ENDDO 
		SET FILTER TO &filtro
		SELE BAMT0100
		USE
ENDPROC


PROCEDURE PROPAGA_CUENTAS_BANCO
	LOCAL filtro, mesactual, anyoactual, contames, contaanyo, nregist
		
		mesactual = MONTH(W_DESDE)
		anyoactual = YEAR(W_DESDE)
		IF NOT USED('BAMT0200') THEN
			USE BAMT0200 IN 0 ALIAS BAMT0200 EXCLUSIVE
		ENDIF
		SELECT BAMT0200
		filtro = FILTER()
		SET FILTER TO
		LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual
		DO WHILE NOT EOF()
			nregist = RECNO()
			cuenta = BAMT0200.CODCTA
			
			saldofinal = BAMT0200.SALACT
			nombrecuenta = BAMT0200.NOMCTA
			cuentamayor = BAMT0200.CTACON
				
			********
			contames = MES_MESDESPUES(mesactual,anyoactual)
			contaanyo = ANYO_MESDESPUES(mesactual,anyoactual)
			
			IF BAMT0200.POSTERIOR THEN
				LOCATE FOR ALLTRIM(codcta) == ALLTRIM(cuenta) AND empresa = nCodigo AND nmes = contames AND anyo = contaanyo
				IF FOUND() THEN
					diferencia = saldofinal - BAMT0200.salini
					IF diferencia <>0 THEN
						REPLACE ALL salini WITH salini+diferencia, salact WITH salact+diferencia FOR ALLTRIM(codcta) == ALLTRIM(cuenta) AND empresa = nCodigo AND POSTERIOROIGUALMES(W_MESMAX,W_ANYOMAX,nmes,anyo) AND POSTERIOROIGUALMES(nmes,anyo,contames,contaanyo)
					ENDIF
				ENDIF
		
			ELSE
		
				REPLACE POSTERIOR WITH .T.
				nombrecuenta = BAMT0200.NOMCTA
				encontradaconmismocodigo = .F.
				
				SCATTER MEMVAR
			
				DO WHILE NOT POSTERIORMES (contames, contaanyo, W_MESMAX, W_ANYOMAX) AND NOT encontradaconmismocodigo
				
					nreg1 = GUARDANUMEROREGISTRO()
					LOCATE FOR ALLTRIM(UPPER(codcta)) == ALLTRIM(UPPER(cuenta)) AND nmes = contames AND anyo = contaanyo AND empresa = nCodigo								
					encontradaconmismocodigo = FOUND()
					RECUPERANUMEROREGISTRO(nreg1)
					
					IF NOT encontradaconmismocodigo THEN
						M.salini = saldofinal
						M.salact = saldofinal
						M.cargos = 0
						M.abonos = 0	
						M.posterior = ((contames <> W_MESMAX) OR (contaanyo <> W_ANYOMAX))
				
						M.nmes = contames
						M.anyo = contaanyo
					
						INSERT INTO BAMT0200 FROM MEMVAR
						
						contamesant = contames
						contaanyoant = contaanyo
						contames = MES_MESDESPUES(contamesant,contaanyoant)			
						contaanyo = ANYO_MESDESPUES (contamesant,contaanyoant)
					ENDIF	
				ENDDO
			ENDIF
			
			
			GO nregist
			SKIP
			IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual REST
			ENDIF
		ENDDO 
		SET FILTER TO &filtro
		SELE BAMT0200
		USE
ENDPROC


PROCEDURE CREA_BANCOS_NUEVO_MES

	* Nos colocamos en el ltimo mes existente
	W_DESDE=DATE(W_ANYOMAX,W_MESMAX,01)
	W_HASTA=DATE(W_ANYOMAX,W_MESMAX,DIAS_MES(W_MESMAX,W_ANYOMAX))
	
	* Hacemos que el mes mximo sea el posterior al ltimo existente
	
	W_MESMAX = W_MES
	W_ANYOMAX = W_AO
	
	
	* Propagamos 
	DO PROPAGA_BANCOS
	
	
ENDPROC

PROCEDURE CREA_CUENTAS_BANCO_NUEVO_MES
	* Nos colocamos en el ltimo mes existente
	
	W_DESDE=DATE(W_ANYOMAX,W_MESMAX,01)
	W_HASTA=DATE(W_ANYOMAX,W_MESMAX,DIAS_MES(W_MESMAX,W_ANYOMAX))
	
	* Hacemos que el mes mximo sea el posterior al ltimo existente
	W_MESMAX = W_MES
	W_ANYOMAX = W_AO
	
	* Propagamos 
	DO PROPAGA_CUENTAS_BANCO
	
ENDPROC

PROCEDURE BORRA_CUENTA_BANCARIA (nomcuenta, elmeso, elanyono, laempresao)
	
	tabla = ALIAS()
	cerrarcuen = .F.
	cerrar1 =.F.
	cerrar2 =.F.
	cerrar3 =.F.
	cerrar4 =.F.
	
	cerrar10 =.F.
	cerrar20 =.F.
	cerrar30 =.F.
	cerrar40 =.F.

	
	IF NOT USED('BAMT0200') THEN
		USE BAMT0200 IN 0 ALIAS BAMT0200
		cerrarcuen = .T.
	ENDIF
	
	IF NOT USED('BAMV0100') THEN
		USE BAMV0100 IN 0 ALIAS BAMV0100
		cerrar1 = .T.
	ENDIF
	
	IF NOT USED('BAMV0110') THEN
		USE BAMV0110 IN 0 ALIAS BAMV0110
		cerrar10 = .T.
	ENDIF

	IF NOT USED('BAMV0200') THEN
		USE BAMV0200 IN 0 ALIAS BAMV0200
		cerrar2 = .T.
	ENDIF
	
	IF NOT USED('BAMV0210') THEN
		USE BAMV0210 IN 0 ALIAS BAMV0210
		cerrar20 = .T.
	ENDIF

	IF NOT USED('BAMV0300') THEN
		USE BAMV0300 IN 0 ALIAS BAMV0300
		cerrar3 = .T.
	ENDIF
	
	IF NOT USED('BAMV0310') THEN
		USE BAMV0310 IN 0 ALIAS BAMV0310
		cerrar30 = .T.
	ENDIF

	IF NOT USED('BAMV0400') THEN
		USE BAMV0400 IN 0 ALIAS BAMV0400
		cerrar4 = .T.
	ENDIF
	
	IF NOT USED('BAMV0410') THEN
		USE BAMV0410 IN 0 ALIAS BAMV0410
		cerrar40 = .T.
	ENDIF
	
	SELE BAMV0100
	filtro = FILTER()
	SET FILTER TO codcta = nomcuenta AND POSTERIOROIGUALMES(nmes, anyo, elmeso, elanyono) AND empresa = laempresao
	GO TOP
	DO WHILE NOT EOF()
		elmovimiento = bamv0100.numdoc
		themes = bamv0100.nmes
		theanyo = bamv0100.anyo
		SELE BAMV0110
		DELETE ALL FOR numdoc = elmovimiento AND codcta = nomcuenta AND nmes = themes AND anyo = theanyo AND empresa = laempresao
		SELE BAMV0100
		SKIP
	ENDDO
	DELETE ALL FOR codcta = nomcuenta AND POSTERIOROIGUALMES(nmes, anyo, elmeso, elanyono) AND empresa = laempresao
	SET FILTER TO &filtro
	
	SELE BAMV0200
	filtro = FILTER()
	SET FILTER TO codcta = nomcuenta AND POSTERIOROIGUALMES(nmes, anyo, elmeso, elanyono) AND empresa = laempresao
	GO TOP
	DO WHILE NOT EOF()
		elmovimiento = bamv0200.numdoc
		themes = bamv0200.nmes
		theanyo = bamv0200.anyo
		SELE BAMV0210
		DELETE ALL FOR numdoc = elmovimiento AND codcta = nomcuenta AND nmes = themes AND anyo = theanyo AND empresa = laempresao
		SELE BAMV0200
		SKIP
	ENDDO
	DELETE ALL FOR codcta = nomcuenta AND POSTERIOROIGUALMES(nmes, anyo, elmeso, elanyono) AND empresa = laempresao
	SET FILTER TO &filtro
	
	
	SELE BAMV0300
	filtro = FILTER()
	SET FILTER TO codcta = nomcuenta AND POSTERIOROIGUALMES(nmes, anyo, elmeso, elanyono) AND empresa = laempresao
	GO TOP
	DO WHILE NOT EOF()
		elmovimiento = bamv0300.numdoc
		themes = bamv0300.nmes
		theanyo = bamv0300.anyo
		SELE BAMV0310
		DELETE ALL FOR numdoc = elmovimiento AND codcta = nomcuenta AND nmes = themes AND anyo = theanyo AND empresa = laempresao
		SELE BAMV0300
		SKIP
	ENDDO
	DELETE ALL FOR codcta = nomcuenta AND POSTERIOROIGUALMES(nmes, anyo, elmeso, elanyono) AND empresa = laempresao
	SET FILTER TO &filtro
	
	
	SELE BAMV0400
	filtro = FILTER()
	SET FILTER TO codcta = nomcuenta AND POSTERIOROIGUALMES(nmes, anyo, elmeso, elanyono) AND empresa = laempresao
	GO TOP
	DO WHILE NOT EOF()
		elmovimiento = bamv0400.numdoc
		themes = bamv0400.nmes
		theanyo = bamv0400.anyo
		SELE BAMV0410
		DELETE ALL FOR numdoc = elmovimiento AND codcta = nomcuenta AND nmes = themes AND anyo = theanyo AND empresa = laempresao
		SELE BAMV0400
		SKIP
	ENDDO
	DELETE ALL FOR codcta = nomcuenta AND POSTERIOROIGUALMES(nmes, anyo, elmeso, elanyono) AND empresa = laempresao
	SET FILTER TO &filtro
	
	SELE BAMT0200
	filtro = FILTER()
	SET FILTER TO
	DELETE ALL FOR codcta = nomcuenta AND POSTERIOROIGUALMES(nmes, anyo, elmeso, elanyono) AND empresa = laempresao
	SET FILTER TO &filtro
	
	IF cerrarcuen THEN
		SELE BAMT0200
		USE
	ENDIF
	
	IF cerrar1 THEN
		SELE BAMV0100
		USE
	ENDIF

	IF cerrar2 THEN
		SELE BAMV0200
		USE
	ENDIF
	
	IF cerrar3 THEN
		SELE BAMV0300
		USE
	ENDIF

	IF cerrar4 THEN
		SELE BAMV0400
		USE
	ENDIF
	
	IF cerrar10 THEN
		SELE BAMV0110
		USE
	ENDIF

	IF cerrar20 THEN
		SELE BAMV0210
		USE
	ENDIF
	
	IF cerrar30 THEN
		SELE BAMV0310
		USE
	ENDIF

	IF cerrar40 THEN
		SELE BAMV0410
		USE
	ENDIF
		
	SELECT (tabla)
ENDPROC

PROCEDURE TRADUCEBAMT0200SEGUNVARIABLESMONEDAREP(elmes,elanyo)
	IF W_TIPOCAMBIOREP = -1 THEN
		TRADUCEBAMT0200SEGUNCOTIZACIONES(elmes,elanyo)
	ELSE
		TRADUCETABLAMONEDADELTA('bamt0200','wbamt0200',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP,'', 'salini, salact, cargos, abonos', 'nmes = '+STR(elmes)+' AND anyo = '+STR(elanyo)+' AND empresa = '+STR(nCodigo))
	ENDIF
ENDPROC

PROCEDURE TRADUCEBAMT0200SEGUNCOTIZACIONES(elmes,elanyo)
	LOCAL eltipoc
	eltipoc = CALCULATIPOCAMBIOMATRIZ (@W_COTIZAREP, W_MONEDAREP, DATE(elanyo,elmes,1)) 
	DO RECORDARCODIGO IN CILIB001
	
	** Se juntan los cheques, remesas, notas de cargo y abono en una sola tabla de movimientos
	CREATE TABLE (dirtemp+"TEMPBAMOVIMIENTOS.DBF") (codcta C(15), fecdoc D, valdoc N(20,8), nmes N(2,0), anyo N(4,0), empresa N(2,0), cmoneda N(2,0), tipocambio N(16,8), tipo N(1,0))
	SELE TEMPBAMOVIMIENTOS
	APPEND FROM BAMV0100 FIELDS codcta, fecdoc, valdoc, nmes, anyo, empresa, cmoneda, tipocambio FOR nmes = elmes AND anyo = elanyo AND empresa = nCodigo
	APPEND FROM BAMV0300 FIELDS codcta, fecdoc, valdoc, nmes, anyo, empresa, cmoneda, tipocambio FOR nmes = elmes AND anyo = elanyo AND empresa = nCodigo
	REPLACE ALL tipo WITH 2 
	APPEND FROM BAMV0200 FIELDS codcta, fecdoc, valdoc, nmes, anyo, empresa, cmoneda, tipocambio FOR nmes = elmes AND anyo = elanyo AND empresa = nCodigo
	APPEND FROM BAMV0400 FIELDS codcta, fecdoc, valdoc, nmes, anyo, empresa, cmoneda, tipocambio FOR nmes = elmes AND anyo = elanyo AND empresa = nCodigo
	REPLACE ALL tipo WITH 1 FOR tipo <> 2   
	USE
	
	** Se traducen los movimientos a la moneda segn cotizaciones 
	TRADUCETABLAMONEDAGAMMA(dirtemp+'tempbamovimientos','wbamovi',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, 'fecdoc', 'valdoc', 'empresa = '+STR(nCodigo))
	
	** Se "sumarizan" todos los movimientos para extraer una tabla de cargos y abonos para cada cuenta que tiene movimientos
	SELECT codcta, SUM(IIF(tipo = 1, valdoc, 0.00000000)) AS cargos, SUM(IIF(tipo = 1, 0.00000000, valdoc)) AS abonos;
	FROM (dirtemp+"wbamovi");
	INTO TABLE (dirtemp+"tempbamov2");
	GROUP BY codcta
	INDEX ON codcta TAG codcta
	
	** A partir de esa tabla, se crea una tabla con saldo inicial, cargos, abonos y saldo actual de todas las cuentas.
	SELECT bamt0200.codcta, IIF(ISNULL(bamt0200.salini*eltipoc),0.00000000,bamt0200.salini*eltipoc) AS salini,;
		IIF(ISNULL(tempbamov2.cargos),0.00000000,tempbamov2.cargos) AS cargos,;
		IIF(ISNULL(tempbamov2.abonos),0.00000000,tempbamov2.abonos) AS abonos,; 
		IIF(ISNULL((bamt0200.salini*eltipoc)+tempbamov2.cargos-tempbamov2.abonos),0.00000000,(bamt0200.salini*eltipoc)+tempbamov2.cargos-tempbamov2.abonos) AS salact,;
		bamt0200.nomcta, bamt0200.codbco, bamt0200.ctacon, bamt0200.sucursal, bamt0200.empresa, bamt0200.nmes, bamt0200.anyo, bamt0200.posterior;
	FROM bamt0200 LEFT OUTER JOIN (dirtemp+"tempbamov2") ON bamt0200.codcta = tempbamov2.codcta;
	INTO TABLE (dirtemp+"wbamt0200");
	WHERE bamt0200.nmes = MONTH(W_DESDE) AND bamt0200.anyo = YEAR(W_DESDE) AND bamt0200.empresa = nCodigo;
	ORDER BY bamt0200.codcta
	INDEX ON codcta TAG codcta	
	
	** Se cierran las tablas temporales que hemos utilizado y se selecciona wbamt0200
	
	SELE wbamovi
	USE
	SELE tempbamov2
	USE
	SELE wbamt0200
ENDPROC