******************************************************************************************
*                       REPORTE DE CONCILIACIONES BANCARIAS                                                                 *
******************************************************************************************
CLOSE DATA ALL
PUBLIC OPCION, R_MES, R_ANYO, R_CUENTA, R_BANCO, R_SALDOBANCO, R_SALDOPROGRAMA, R_CHEQUES, R_REMESAS, R_NCARGO, R_NABONO
DO FORM BARP1000.SCX


IF OPCION = 1 THEN

	PUBLIC ncodigo
	USE (cdirectorio+"config\opciones") IN 0
	RESTORE FROM MEMO opciones.codigo ADDITIVE
	USE IN opciones
	
	IF NOT USED ('BAMT0200') THEN
		USE BAMT0200 IN 0 ALIAS BAMT0200
	ENDIF
	SELE BAMT0200
	LOCATE FOR codcta = R_CUENTA AND empresa = nCodigo AND nmes = R_MES AND anyo = R_ANYO
	IF NOT FOUND() THEN
		USE
		MESSAGEBOX("El nmero de cuenta elegido no existe para esta empresa en este mes.",48,"MILLENNIUM CONSULTING")
	ELSE
		untipo = CALCULATIPOCAMBIOREPORTE (@W_COTIZAREP, W_MONEDAREP, DATE(R_ANYO, R_MES,DIAS_MES(R_MES,R_ANYO))) 
		R_SALDOPROGRAMA = bamt0200.salact * untipo
		USE
		DO GENERA
		DO IMPRIME_REPORTE IN CILIB001 WITH ('BARP1000'), (''), ('CIRP0110')
	ENDIF
	
ENDIF
DO DESTRUYEVARIABLESMONEDAREP IN CILIB001	
CLOSE DATA ALL
SET PROC TO CILIB001 ADDITIVE

PROCEDURE GENERA
	RECORDARCODIGO()
	TRADUCETABLAMONEDAGAMMA('bamv0100','wbamv0100',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, 'fecdoc', 'totcargos, totabonos, valdoc', 'ALLTRIM(UPPER(codcta)) == "'+ALLTRIM(UPPER(R_CUENTA))+'" AND estado = 1 AND regis = .F. AND empresa='+STR(nCodigo))
	TRADUCETABLAMONEDAGAMMA('bamv0200','wbamv0200',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, 'fecdoc', 'totcargos, totabonos, valdoc', 'ALLTRIM(UPPER(codcta)) == "'+ALLTRIM(UPPER(R_CUENTA))+'" AND regis = .F. AND empresa='+STR(nCodigo))
	TRADUCETABLAMONEDAGAMMA('bamv0300','wbamv0300',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, 'fecdoc', 'totcargos, totabonos, valdoc', 'ALLTRIM(UPPER(codcta)) == "'+ALLTRIM(UPPER(R_CUENTA))+'" AND regis = .F. AND empresa='+STR(nCodigo))
	TRADUCETABLAMONEDAGAMMA('bamv0400','wbamv0400',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, 'fecdoc', 'totcargos, totabonos, valdoc', 'ALLTRIM(UPPER(codcta)) == "'+ALLTRIM(UPPER(R_CUENTA))+'" AND regis = .F. AND empresa='+STR(nCodigo))
	
	USE (dirtemp+"WBAMV0100") IN 0 ALIAS WBAMV0100
	USE (dirtemp+"WBAMV0200") IN 0 ALIAS WBAMV0200
	USE (dirtemp+"WBAMV0300") IN 0 ALIAS WBAMV0300
	USE (dirtemp+"WBAMV0400") IN 0 ALIAS WBAMV0400
		
	IF FILE (dirraiz+'BANCOS\TEMPCON.DBF') THEN
		ERASE (dirraiz+'BANCOS\TEMPCON.DBF')
	ENDIF
	
	CREATE TABLE tempcon (tipo N1, fecdoc D, numdoc N(15), valdoc N(20,8), concepto C(60), nmes N(2), anyo N(4))
	INDEX ON STR(tipo)+DTOS(fecdoc) TO ordencon
	
	SELE wbamv0100
	R_CHEQUES = 0
	SCAN FOR ALLTRIM(UPPER(codcta)) == ALLTRIM(UPPER(R_CUENTA)) AND estado = 1 AND regis = .F. AND empresa=nCodigo AND POSTERIOROIGUALMES(R_MES,R_ANYO,nmes,anyo)
		SCATTER MEMVAR
		m.tipo = 1
		m.concepto = ALLTRIM(m.afavor)
		R_CHEQUES = R_CHEQUES + m.valdoc
		INSERT INTO TEMPCON FROM MEMVAR
	ENDSCAN
	USE
	
	
	SELE wbamv0200
	R_REMESAS = 0 
	SCAN FOR ALLTRIM(UPPER(codcta)) == ALLTRIM(UPPER(R_CUENTA)) AND regis = .F. AND empresa=nCodigo AND POSTERIOROIGUALMES(R_MES,R_ANYO,nmes,anyo)
		SCATTER MEMVAR
		m.tipo = 2
		R_REMESAS = R_REMESAS + m.valdoc
		INSERT INTO TEMPCON FROM MEMVAR	
	ENDSCAN
	USE

	SELE wbamv0300
	R_NCARGO = 0
	SCAN FOR ALLTRIM(UPPER(codcta)) == ALLTRIM(UPPER(R_CUENTA)) AND regis = .F. AND empresa=nCodigo AND POSTERIOROIGUALMES(R_MES,R_ANYO,nmes,anyo)
		SCATTER MEMVAR
		m.tipo = 3
		R_NCARGO = R_NCARGO + m.valdoc
		INSERT INTO TEMPCON FROM MEMVAR	
	ENDSCAN
	USE

	SELE wbamv0400
	R_NABONO = 0
	SCAN FOR ALLTRIM(UPPER(codcta)) == ALLTRIM(UPPER(R_CUENTA)) AND regis = .F.  AND empresa=nCodigo AND POSTERIOROIGUALMES(R_MES,R_ANYO,nmes,anyo)
		SCATTER MEMVAR
		m.tipo = 4
		R_NABONO = R_NABONO + m.valdoc
		INSERT INTO TEMPCON FROM MEMVAR	
	ENDSCAN
	USE	
ENDPROC
