*** TRASLADO DE PARTIDAS A CONTABILIDAD
PUBLIC OPCION, F_FECHAINI, F_FECHAFIN, NUMPARTIDAINICIAL

IF ESCON <> 1 THEN
	MESSAGEBOX("Esta opcin slo est disponible si se contrata el mdulo de contabilidad", 48 ,"MILLENNIUM GESTION")
ELSE
	XCOBAAGRUPACIONTRASLADOBANCOS = LEEVARNUMDEFECTO('XCOBAAGRUPACIONTRASLADOBANCOS',0)
	* El valor 0 (por defecto) agrupa los movimientos de bancos con la misma fecha, moneda y tipo de cambio en la misma partida
	* El valor 1 agrupa los movimientos de bancos con la misma fecha, moneda, tipo de cambio y tipo de documento
	* El valor 2 coloca cada movimiento diferente de bancos en una sola partida.

	DO FORM BAUT0300.SCX && Aqu se controla que tanto la fecha ini como la fin son correctas.
	
	IF OPCION = 1 THEN
		RECORDARCODIGO()

		** Crea una tabla con todos los movimientos entre las fechas que no han sido trasladados

		SELECT BAMV0110.CTACON AS CCDETALLE, BAMV0110.NOMCTA, BAMV0110.CARGOS, BAMV0110.ABONOS, BAMV0100.*, (ALLTRIM(bamv0100.concep1)+" "+ALLTRIM(bamv0100.concep2)) AS concepto, 1 AS tipodoc;
		FROM BAMV0100 JOIN BAMV0110 ON bamv0100.numdoc = bamv0110.numdoc AND bamv0100.nmes = bamv0110.nmes AND bamv0100.anyo = bamv0110.anyo AND bamv0100.empresa = bamv0110.empresa;
		INTO TABLE (dirtemp+"wtempmovbanc");
		WHERE BETWEEN(bamv0100.fecdoc, F_FECHAINI, F_FECHAFIN) AND estado = 1 AND NOT bamv0100.trasladado AND bamv0100.empresa = nCodigo
		
		SELECT BAMV0210.CTACON AS CCDETALLE, BAMV0210.NOMCTA, BAMV0210.CARGOS, BAMV0210.ABONOS, BAMV0200.*, 2 AS tipodoc;
		FROM BAMV0200 JOIN BAMV0210 ON bamv0200.numdoc = bamv0210.numdoc AND bamv0200.nmes = bamv0210.nmes AND bamv0200.anyo = bamv0210.anyo AND bamv0200.empresa = bamv0210.empresa;
		INTO TABLE (dirtemp+"wtempremesas");
		WHERE BETWEEN(bamv0200.fecdoc, F_FECHAINI, F_FECHAFIN) AND NOT bamv0200.trasladado AND bamv0200.empresa = nCodigo
		
		SELECT bamv0310.CTACON AS CCDETALLE, bamv0310.NOMCTA, bamv0310.CARGOS, bamv0310.ABONOS, bamv0300.*, 3 AS tipodoc;
		FROM bamv0300 JOIN bamv0310 ON bamv0300.numdoc = bamv0310.numdoc AND bamv0300.nmes = bamv0310.nmes AND bamv0300.anyo = bamv0310.anyo AND bamv0300.empresa = bamv0310.empresa;
		INTO TABLE (dirtemp+"wtempncargo");
		WHERE BETWEEN(bamv0300.fecdoc, F_FECHAINI, F_FECHAFIN) AND NOT bamv0300.trasladado AND bamv0300.empresa = nCodigo
		
		SELECT bamv0410.CTACON AS CCDETALLE, bamv0410.NOMCTA, bamv0410.CARGOS, bamv0410.ABONOS, bamv0400.*, 4 AS tipodoc;
		FROM bamv0400 JOIN bamv0410 ON bamv0400.numdoc = bamv0410.numdoc AND bamv0400.nmes = bamv0410.nmes AND bamv0400.anyo = bamv0410.anyo AND bamv0400.empresa = bamv0410.empresa;
		INTO TABLE (dirtemp+"wtempnabono");
		WHERE BETWEEN(bamv0400.fecdoc, F_FECHAINI, F_FECHAFIN) AND NOT bamv0400.trasladado AND bamv0400.empresa = nCodigo

		SELE wtempmovbanc
		APPEND FROM (dirtemp+"wtempremesas")
		APPEND FROM (dirtemp+"wtempncargo")
		APPEND FROM (dirtemp+"wtempnabono")
		
		BEGIN TRANSACTION
		
		** Marca los movimientos de bancos como trasladados
		MARCACOMOTRASLADADO('BAMV0100', 'BAMV0110', F_FECHAINI, F_FECHAFIN)
		MARCACOMOTRASLADADO('BAMV0200', 'BAMV0210', F_FECHAINI, F_FECHAFIN)
		MARCACOMOTRASLADADO('BAMV0300', 'BAMV0310', F_FECHAINI, F_FECHAFIN)
		MARCACOMOTRASLADADO('BAMV0400', 'BAMV0410', F_FECHAINI, F_FECHAFIN)
						
		** Cierra unas tablas y abre otras
		USE IN BAMV0100
		USE IN BAMV0110
		USE IN BAMV0200
		USE IN BAMV0210
		USE IN BAMV0300
		USE IN BAMV0310
		USE IN BAMV0400
		USE IN BAMV0410
		USE IN wtempremesas
		USE IN wtempncargo
		USE IN wtempnabono
	
		USE (dirraiz+"CONTABLE\COMT0200.DBF") IN 0 ALIAS COMT0200	
		USE (dirraiz+"CONTABLE\COMT0210.DBF") IN 0 ALIAS COMT0210	
		
		SELECT COMT0200
		CALCULATE MAX(MO_NUMDOC) FOR nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE) AND empresa = nCodigo TO ultimonumeropartida
		numpartidainicial = ultimonumeropartida+1
		
		** Crea un ndice para definir el orden en que vamos a tratar los movimientos
		SELE wtempmovbanc
		INDEX ON DTOS(fecdoc)+ALLTRIM(STR(cmoneda))+ ALLTRIM(STR(tipocambio,50,18))+ ALLTRIM(STR(tipodoc))+ ALLTRIM(STR(numdoc)) TAG orden
		
		** Recorre toda la tabla wtempmovbanc poniendo su contenido en las partidas de Contabilidad
		
		setratoalgunregistro = .F.
		numpartida = numpartidainicial
		totalcargospartida = 0 
		totalabonospartida = 0 
		SCAN
			** Si se ha cambiado de movimiento, se escribe el cargo o abono del movimiento
			IF CAMBIOMOVIMIENTOBANCOS() THEN
				ESCRIBECARGOOABONOIMPLICITOMOVIMIENTOS(@totalcargospartida, @totalabonospartida)
			ENDIF
			 
			IF CAMBIOPARTIDA(XCOBAAGRUPACIONTRASLADOBANCOS)  THEN 
				ESCRIBETOTALESPARTIDA()
				numpartida = numpartida +1 
				totalcargospartida = 0 
				totalabonospartida = 0 
			ENDIF
			
			** Se guardan los valores relevantes del registro actual
			setratoalgunregistro = .T.
			SCATTER NAME ultimoregistro
			letradetalle = IIF(ultimoregistro.tipodoc = 1,"CH", IIF(ultimoregistro.tipodoc = 2,"R", IIF(ultimoregistro.tipodoc = 3,"NC","NA")))
			ultimonomdoc = IIF(ultimoregistro.tipodoc = 1,"Cheque", IIF(ultimoregistro.tipodoc = 2,"Remesa", IIF(ultimoregistro.tipodoc = 3,"Nota de cargo","Nota de abono")))
			haycargos = (ultimoregistro.tipodoc = 2) OR (ultimoregistro.tipodoc = 4)
			hayabonos = (ultimoregistro.tipodoc = 1) OR (ultimoregistro.tipodoc = 3)
							
			** Pone detalle actual
			ESCRIBEDETALLEACTUAL(@totalcargospartida, @totalabonospartida)
		ENDSCAN

		** Escribe el ltimo cargo la ltima partida 
		IF setratoalgunregistro THEN
			ESCRIBECARGOOABONOIMPLICITOMOVIMIENTOS(@totalcargospartida, @totalabonospartida)
			ESCRIBETOTALESPARTIDA()
			MESSAGEBOX("Traslado de movimientos finalizado.", 48, "MILLENNIUM CONSULTING")
		ELSE
			MESSAGEBOX("No hay movimientos de bancos a trasladar en las fechas especificadas.", 48, "MILLENNIUM CONSULTING")
		ENDIF
		
		END TRANSACTION
					
		CLOSE DATA ALL
	ENDIF	
ENDIF

RELEASE OPCION, F_FECHAINI, F_FECHAFIN, NUMPARTIDAINICIAL

FUNCTION CAMBIOMOVIMIENTOBANCOS()
	RETURN setratoalgunregistro AND (ultimoregistro.fecdoc <> wtempmovbanc.fecdoc OR ultimoregistro.tipodoc <> wtempmovbanc.tipodoc OR	ultimoregistro.numdoc <> wtempmovbanc.numdoc)
ENDFUNC

FUNCTION CAMBIOPARTIDA(agrupaciontrasladobancos)
	DO CASE
		CASE agrupaciontrasladobancos = 0 
			RETURN setratoalgunregistro AND (ultimoregistro.fecdoc <> wtempmovbanc.fecdoc OR ultimoregistro.cmoneda <> wtempmovbanc.cmoneda OR ultimoregistro.tipocambio <> wtempmovbanc.tipocambio)
		CASE agrupaciontrasladobancos = 1 
			RETURN setratoalgunregistro AND (ultimoregistro.fecdoc <> wtempmovbanc.fecdoc OR ultimoregistro.tipodoc <> wtempmovbanc.tipodoc OR	ultimoregistro.cmoneda <> wtempmovbanc.cmoneda OR ultimoregistro.tipocambio <> wtempmovbanc.tipocambio)
		CASE agrupaciontrasladobancos = 2
			RETURN setratoalgunregistro AND (ultimoregistro.fecdoc <> wtempmovbanc.fecdoc OR ultimoregistro.tipodoc <> wtempmovbanc.tipodoc OR	ultimoregistro.numdoc <> wtempmovbanc.numdoc)
	ENDCASE
ENDFUNC

PROCEDURE ESCRIBETOTALESPARTIDA()
	INSERT INTO comt0200 (mo_fecdoc, mo_tipdoc, empresa, mo_numdoc, totalcargos, totalabonos, nmes, anyo, trasladado, cmoneda, tipocambio);
		VALUES (ultimoregistro.fecdoc, "", nCodigo, numpartida, totalcargospartida, totalabonospartida, MONTH(W_DESDE), YEAR(W_DESDE), .T., ultimoregistro.cmoneda, ultimoregistro.tipocambio)
ENDPROC

PROCEDURE ESCRIBECARGOOABONOIMPLICITOMOVIMIENTOS(totalcargospartida, totalabonospartida)
	INSERT INTO Comt0210 (mo_numdoc, mo_codcta, mo_cargos, mo_abonos, empresa, mo_concep, nmes, anyo, cmoneda, tipocambio, trasladado);
		VALUES  (numpartida, ultimoregistro.ctacon, IIF(haycargos,ultimoregistro.valdoc,0), IIF(hayabonos,ultimoregistro.valdoc,0),; 
			nCodigo,letradetalle+ALLTRIM(STR(ultimoregistro.numdoc))+" - "+"VALOR DE "+UPPER(ultimonomdoc),;
			MONTH(ultimoregistro.fecdoc), YEAR(ultimoregistro.fecdoc), ultimoregistro.cmoneda, ultimoregistro.tipocambio, .T.)
	IF haycargos THEN
		totalcargospartida = totalcargospartida +ultimoregistro.valdoc
	ENDIF
	IF hayabonos THEN
		totalabonospartida = totalabonospartida +ultimoregistro.valdoc
	ENDIF
ENDPROC

PROCEDURE ESCRIBEDETALLEACTUAL(totalcargospartida, totalabonospartida)
	INSERT INTO Comt0210 (mo_numdoc, mo_codcta, mo_cargos, mo_abonos, empresa, mo_concep, nmes, anyo, cmoneda, tipocambio, trasladado);
		VALUES  (numpartida, ultimoregistro.ccdetalle, ultimoregistro.cargos, ultimoregistro.abonos, nCodigo, ;
		letradetalle+ALLTRIM(STR(ultimoregistro.numdoc))+ " - " + ultimoregistro.nomcta ,; 
		MONTH(ultimoregistro.fecdoc), YEAR(ultimoregistro.fecdoc), ultimoregistro.cmoneda, ultimoregistro.tipocambio, .T.)			
	totalcargospartida = totalcargospartida +ultimoregistro.cargos
	totalabonospartida = totalabonospartida +ultimoregistro.abonos
ENDPROC

PROCEDURE MARCACOMOTRASLADADO(tabla, tabla2, fechainicial, fechafinal)
	** Las fechas deben estar dentro del mes actual
	SELECT (tabla)
	SCAN FOR BETWEEN(fecdoc,fechainicial,fechafinal) AND NOT trasladado AND empresa = nCodigo
		REPLACE trasladado WITH .T. 
		WREPLACEALL('trasladado WITH .T.','numdoc = '+ tabla+'.numdoc AND NOT trasladado AND nmes = '+ STR(MONTH(W_DESDE))+' AND anyo = '+ STR(YEAR(W_DESDE))+ ' AND empresa = ' + STR(nCodigo),tabla2)	
	ENDSCAN
ENDPROC

PROCEDURE ACTUALIZATOTALESCARGOSYABONOS()
	IF haycargos THEN
		totalcargospartida = totalcargospartida +ultimoregistro.valdoc
	ENDIF
	IF hayabonos THEN
		totalabonospartida = totalabonospartida +ultimoregistro.valdoc
	ENDIF
ENDPROC