****************************************************************************
*      PROCEDIMIENTO QUE REALIZA LA REVERSIN DEL TRASLADO DE LAS PARTIDAS*
****************************************************************************


PUBLIC OPCION, F_FECHAINI, F_FECHAFIN

IF ESCON <> 1 THEN
	MESSAGEBOX("Esta opcin slo est disponible si se contrata el mdulo de Contabilidad", 48 ,"MILLENNIUM GESTION")
ELSE
	DO FORM BAUT0400.SCX

	IF OPCION = 1 THEN
		RECORDARCODIGO()
		USE (dirraiz+"CONTABLE\COMT0200.DBF") IN 0 ALIAS COMT0200	
		SELE COMT0200
		
		LOCATE FOR trasladado AND BETWEEN(mo_fecdoc, F_FECHAINI, F_FECHAFIN) AND empresa = nCodigo AND mo_actualiz
		IF FOUND() THEN
			MESSAGEBOX("Hay partidas actualizadas en esta fecha. Para evitar inconsistencia en los datos, revierta la actualizacin de estas partidas antes de revertir su traslado.",48,"MILLENNIUM CONSULTING")
		ELSE	
			USE (dirraiz+"CONTABLE\COMT0210.DBF") IN 0 ALIAS COMT0210	
			USE BAMV0100 IN 0 ALIAS BAMV0100
			USE BAMV0110 IN 0 ALIAS BAMV0110
			USE BAMV0200 IN 0 ALIAS BAMV0200
			USE BAMV0210 IN 0 ALIAS BAMV0210
			USE BAMV0300 IN 0 ALIAS BAMV0300
			USE BAMV0310 IN 0 ALIAS BAMV0310
			USE BAMV0400 IN 0 ALIAS BAMV0400
			USE BAMV0410 IN 0 ALIAS BAMV0410
		
			BEGIN TRANSACTION
			** Borra las partidas trasladadas en contabilidad en ese rango de fechas
			SELECT COMT0200
			setratoalgunregistro = .F.

			SCAN FOR BETWEEN(mo_fecdoc,F_FECHAINI,F_FECHAFIN) AND trasladado AND empresa = nCodigo
				elnumdoc = comt0200.mo_numdoc
				elmes = comt0200.nmes
				elanyo = comt0200.anyo
				WDELETEALL('trasladado AND mo_numdoc = '+STR(elnumdoc)+' AND nmes = '+STR(elmes)+' AND anyo = '+STR(elanyo)+' AND empresa = '+STR(nCodigo),'COMT0210')	
				setratoalgunregistro = .T.
			ENDSCAN

			WDELETEALL('trasladado AND BETWEEN(mo_fecdoc, '+DTOCCOMANDO(F_FECHAINI)+','+DTOCCOMANDO(F_FECHAFIN)+') AND empresa = '+STR(nCodigo),'COMT0200')	

			** Marca como no trasladado todos los movimientos de bancos correspondientes a este rango de fechas
			MARCACOMONOTRASLADADO('BAMV0100', 'BAMV0110', F_FECHAINI, F_FECHAFIN)
			MARCACOMONOTRASLADADO('BAMV0200', 'BAMV0210', F_FECHAINI, F_FECHAFIN)
			MARCACOMONOTRASLADADO('BAMV0300', 'BAMV0310', F_FECHAINI, F_FECHAFIN)
			MARCACOMONOTRASLADADO('BAMV0400', 'BAMV0410', F_FECHAINI, F_FECHAFIN)
			END TRANSACTION
			
			USE IN COMT0210
			USE IN BAMV0100
			USE IN BAMV0110
			USE IN BAMV0200
			USE IN BAMV0210
			USE IN BAMV0300
			USE IN BAMV0310
			USE IN BAMV0400
			USE IN BAMV0410
		
			IF setratoalgunregistro THEN
				MESSAGEBOX("Reversin de traslado finalizada.", 48, "MILLENNIUM CONSULTING")
			ELSE
				MESSAGEBOX("No hay movimientos de bancos en las fechas especificadas para los cuales revertir el traslado.", 48, "MILLENNIUM CONSULTING")
			ENDIF
		ENDIF	
		USE IN COMT0200
	ENDIF
ENDIF
RELEASE OPCION, F_FECHAINI, F_FECHAFIN

PROCEDURE MARCACOMONOTRASLADADO(tabla, tabla2, fechainicial, fechafinal)
	SELECT (tabla)
	SCAN FOR BETWEEN(fecdoc,fechainicial,fechafinal) AND trasladado AND empresa = nCodigo
		REPLACE trasladado WITH .F.
		WREPLACEALL('trasladado WITH .F.','numdoc = '+ tabla+'.numdoc AND trasladado AND nmes = '+ STR(MONTH(W_DESDE))+' AND anyo = '+ STR(YEAR(W_DESDE))+ ' AND empresa = ' + STR(nCodigo),tabla2)	
	ENDSCAN
ENDPROC
