
DEFINE CLASS Aplicacion AS Custom 
	HIDDEN HayModuloActivo

	Nombre = ""
	Codigo = 0
	Autor = "MILLENNIUM CONSULTING"
	DirectorioRaiz = ""
	
	DIMENSION Modulos(100)  
	NumeroModulos = 0
	ModuloActivo = NULL
	HayModuloActivo = .F.
	
	FUNCTION CreaModulo(clasemodulo)
		IF THIS.NumeroModulos = 100 THEN
			RETURN NULL
		ELSE
			THIS.NumeroModulos = THIS.NumeroModulos+1
			esteobjeto = THIS
			THIS.Modulos [THIS.NumeroModulos] = CREATEOBJECT(clasemodulo, @esteobjeto)
			esteobjeto = NULL
			RETURN 0 
		ENDIF
	ENDFUNC

	FUNCTION ActivaModulo(nummod)
		IF nummod > THIS.NumeroModulos THEN
			RETURN NULL
		ELSE
			THIS.ModuloActivo = THIS.Modulos[nummod]
			THIS.HayModuloActivo = .T.
			RETURN 0 
		ENDIF
	ENDFUNC
	
	FUNCTION DesactivaModuloActivo
		THIS.ModuloActivo = NULL
		THIS.HayModuloActivo = .F.
	ENDFUNC
	
	FUNCTION ExisteModuloActivo
		RETURN THIS.HayModuloActivo	
	ENDFUNC
ENDDEFINE

DEFINE CLASS AplicacionGestion AS Aplicacion
	Nombre = "MILLENNIUM GESTION"
	Codigo = 1
	
	CodigoEmpresa = ""
	NombreEmpresa = ""
	
	PROCEDURE Init
		THIS.DirectorioRaiz = JUSTPATH(SYS(16,0))+"\"
		
		THIS.CreaModulo("ModuloContabilidad")
		THIS.CreaModulo("ModuloBancos")
		THIS.CreaModulo("ModuloIva")
		THIS.CreaModulo("ModuloInventario")
		THIS.CreaModulo("ModuloPlanilla")
		THIS.CreaModulo("ModuloConfiguracion")
	ENDPROC
		
ENDDEFINE

DEFINE CLASS Modulo AS Custom
	Nombre = ""
	Codigo = 0 
	DirectorioRaiz = ""
	Aplicacion = NULL
	PROCEDURE Init
		LPARAMETERS aplic
		THIS.Aplicacion = aplic
	ENDPROC
ENDDEFINE

DEFINE CLASS ModuloGestion AS Modulo
	HIDDEN HayPeriodoActivo
	
	HayPeriodoActivo = .F.
	PeriodoActivo = 0
	
	MesActivo = 0
	AnyoActivo = 0
	
	PrimerDiaActivo = 0
	UltimoDiaActivo = 0
	
		
	FUNCTION ExistePeriodoActivo
		RETURN HayPeriodoActivo
	ENDFUNC
	
	
	FUNCTION RespaldaDatos
		archivocopia = PUTFILE('Archivo CAB',THIS.Nombre,'CAB')
		IF NOT EMPTY(archivocopia) THEN
			IF NOT LEEVARBOOLDEFECTO('XRESPALDOCUALQUIERDISCO', .F.) AND NOT (ALLTRIM(UPPER(JUSTDRIVE(archivocopia))) == "A:") THEN
				MESSAGEBOX("La opcin de poder hacer copias de respaldo en discos diferentes al A: no ha sido contratada. Si desea contratarla, contacte con MILLENNIUM CONSULTING.", 48, "MILLENNIUM CONSULTING")
			ELSE
				tipodisco = DRIVETYPE(JUSTDRIVE(archivocopia))
				continuar = 6
				IF tipodisco = 1 THEN
					continuar = MESSAGEBOX("No se detect el tipo del disco. Est seguro de que desea continuar?",52, "MILLENNIUM CONSULTING")
				ENDIF
				IF continuar = 6 THEN
					DO FORM CIUT0100 WITH archivocopia, tipodisco TO mensajeres
					MESSAGEBOX(mensajeres,48, "MILLENNIUM CONSULTING")
				ENDIF
			ENDIF
		ENDIF
	ENDFUNC
ENDDEFINE 

DEFINE CLASS ModuloContabilidad AS ModuloGestion
	Nombre = "Contabilidad"
	Codigo = 1
	
	PROCEDURE Init
		LPARAMETERS aplic
		DODEFAULT(aplic)
		THIS.DirectorioRaiz = THIS.Aplicacion.DirectorioRaiz+"CONTABLE\"
	ENDPROC
	
ENDDEFINE

DEFINE CLASS ModuloBancos AS ModuloGestion
	Nombre = "Bancos"
	Codigo = 2
	
ENDDEFINE

DEFINE CLASS ModuloIva AS ModuloGestion
	Nombre = "Iva"
	Codigo = 3
	
ENDDEFINE

DEFINE CLASS ModuloInventario AS ModuloGestion
	Nombre = "Inventario"
	Codigo = 4
	
ENDDEFINE

DEFINE CLASS ModuloPlanilla AS ModuloGestion
	Nombre = "Planilla"
	Codigo = 5
	
ENDDEFINE

DEFINE CLASS ModuloConfiguracion AS ModuloGestion
	Nombre = "Configuracin"
	Codigo = 6
	
ENDDEFINE



