*:*****************************************************************
*:	PROGRAMA	: CILIB001.PRG
*:  PROGRAMADOR : DR. VICENT-RAMON PALAS LALLANA
*:	FECHA		: SEPTIEMBRE DE 1999.-
*:	EMPRESA     : MILLENNIUM CONSULTING.
*:	FUNCION		: LIBRERIA DE UTILIDADES Y FUNCIONES DEL SISTEMA.
*:******************************************************************

PROCEDURE ESTABLECEDIRECTORIO
	PUBLIC dirraiz, cdirectorio, dirtemp,CRT
	dirraiz = JUSTPATH(SYS(16,0))+"\"
	SET PATH TO &dirraiz
	dirlocal = "C:\GESTION\"
	dirtemp = GETENV('WINDIR')+"\TEMP\MGTMP\"
	IF NOT DIRECTORY (dirtemp) THEN
		MKDIR (dirtemp)
	ENDIF
	SET SAFETY OFF
	DELETE FILE (dirtemp+"*.*")
	cdirectorio = dirraiz
ENDPROC

PROCEDURE INICIALIZAMONEDASSOLOREPORTES
	LOCAL taula, nousado
	taula = ALIAS()
	nousado = NOT USED('CFMT0100')
	XMONEDASNOAPARECENFORMULARIOS = ","+LEEVARDEFECTO ("XMONEDASNOAPARECENFORMULARIOS","")+","
	IF nousado THEN
		USE (dirraiz+"CONFIG\CFMT0100.DBF") IN 0 ALIAS CFMT0100
	ENDIF
	SELE CFMT0100
	XMONEDASNOACTIVASFORMULARIOS =""
	SCAN 
		IF ATC(","+ALLTRIM(STR(cfmt0100.codigo))+",", XMONEDASNOAPARECENFORMULARIOS)<>0 THEN
			REPLACE solorep WITH .T.
		ENDIF
		IF cfmt0100.solorep THEN
			XMONEDASNOACTIVASFORMULARIOS = XMONEDASNOACTIVASFORMULARIOS+","+ALLTRIM(STR(cfmt0100.codigo))+","
		ENDIF
	ENDSCAN
	IF nousado THEN
		USE
	ENDIF
	IF NOT EMPTY(taula) THEN
		SELE (taula) 
	ENDIF
ENDPROC

PROCEDURE SALIRPROGRAMA()
	
ENDPROC

PROCEDURE INICIALIZALOGGER()
	LOCAL i, Iteraciones, nomtaula, nomtaulaantiga, pathtaula, pathtaulaantiga
	
	PUBLIC XNUMEROTABLASLOGGER, XFORMATORESUMIDOLOGGER
	XNUMEROTABLASLOGGER = LEEVARNUMDEFECTO('XNUMEROTABLASLOGGER',0)
	XFORMATORESUMIDOLOGGER = LEEVARBOOLDEFECTO('XFORMATORESUMIDOLOGGER',.F.)
	XANTIGUONUMEROTABLASLOGGER = LEEVARNUMDEFECTO('XANTIGUONUMEROTABLASLOGGER',0)
	ESCRIBEVAR('XANTIGUONUMEROTABLASLOGGER',ALLTRIM(STR(XNUMEROTABLASLOGGER)),0)
	
	Iteraciones = MAX(XNUMEROTABLASLOGGER,XANTIGUONUMEROTABLASLOGGER)
	
	FOR i = XNUMEROTABLASLOGGER+1 TO XANTIGUONUMEROTABLASLOGGER
		BORRAVAR('XTABLALOGGER'+ALLTRIM(STR(i)),0)
	ENDFOR
	
	FOR i = 1 TO Iteraciones
		nomtaula = ALLTRIM(UPPER(LEEVARDEFECTO('XTABLALOGGER'+ALLTRIM(STR(i)),'')))
		nomtaulaantiga = ALLTRIM(UPPER(LEEVARDEFECTO('XANTIGUATABLALOGGER'+ALLTRIM(STR(i)),'')))
		IF NOT (ALLTRIM(UPPER(nomtaula)) == ALLTRIM(UPPER(nomtaulaantiga))) THEN
			IF NOT EMPTY(nomtaulaantiga) THEN
				pathtaulaantiga = dirraiz+nomtaulaantiga
				DELETE TRIGGER ON (pathtaulaantiga) FOR DELETE
            	DELETE TRIGGER ON (pathtaulaantiga) FOR UPDATE
            	DELETE TRIGGER ON (pathtaulaantiga) FOR INSERT          	
            	BORRAVAR('XANTIGUATABLALOGGER'+ALLTRIM(STR(i)),0)
			ENDIF
			IF NOT EMPTY(nomtaula) THEN
				pathtaula = dirraiz+nomtaula
				CREATE TRIGGER ON (pathtaula) FOR DELETE AS Logger()
            	CREATE TRIGGER ON (pathtaula) FOR UPDATE AS Logger()
            	CREATE TRIGGER ON (pathtaula) FOR INSERT AS Logger()            	
           		ESCRIBEVAR('XANTIGUATABLALOGGER'+ALLTRIM(STR(i)),nomtaula,0)
            ENDIF
		ENDIF
	ENDFOR
	IF XNUMEROTABLASLOGGER > 0 THEN
		XMAXIMOREGISTROSLOGGER = LEEVARNUMDEFECTO('XMAXIMOREGISTROSLOGGER', 500)
		IF XMAXIMOREGISTROSLOGGER > 0 THEN
			USE (dirraiz+"COMUN\LOGGER.DBF") IN 0 
			SELE LOGGER
			GO BOTTOM
			IF NOT EOF() THEN
				mayornumero = Logger.numero
				diferencia = mayornumero - XMAXIMOREGISTROSLOGGER
				IF diferencia > 0 THEN
					BEGIN TRANSACTION
					WDELETEALL('numero <= '+ STR(diferencia)) 
					WREPLACEALL('numero WITH numero - '+STR(diferencia))
					END TRANSACTION
				ENDIF
			ENDIF
			USE
		ENDIF
	ENDIF
ENDPROC

PROCEDURE DEDUCEPATHDELATABLA(nombretabla)
	LOCAL dosletras
	nombretabla = ALLTRIM(UPPER(nombretabla))
	dosletras = UPPER(SUBSTR(nombretabla,1,2))
	DO CASE 
		CASE dosletras == "CO"
			nombretabla = dirraiz+"CONTABLE\"+nombretabla
		CASE dosletras == "BA"
			nombretabla = dirraiz+"BANCOS\"+nombretabla
		CASE dosletras == "IN"
			nombretabla = dirraiz+"INVENTARIO\"+nombretabla
		CASE dosletras == "IV"
			nombretabla = dirraiz+"IVA\"+nombretabla
		CASE dosletras == "PL"
			nombretabla = dirraiz+"PLANILLA\"+nombretabla
		CASE dosletras == "CB"
			nombretabla = dirraiz+"COBROS\"+nombretabla
		CASE dosletras == "CI"
			nombretabla = dirraiz+"COMUN\"+nombretabla
		CASE dosletras == "CF" OR nombretabla == "EMPRESAS" OR nombretabla == "OPCIONES" OR nombretabla == "VARIABLES"
			nombretabla = dirraiz+"CONFIG\"+nombretabla
		OTHERWISE
			nombretabla = FULLPATH(nombretabla)
	ENDCASE
	RETURN nombretabla		
ENDPROC

PROCEDURE entorno
	SET TALK OFF
	SET ECHO OFF
	SET PRIN OFF
	SET ESCA OFF
	SET CONF OFF
	SET STAT OFF
	SET SCOR OFF
	SET SAFE OFF
	SET EXCLUSIVE OFF
	SET REPROCESS TO 1 SECONDS
	SET HELP ON
	SET EXAC OFF
	SET SYSM OFF
	SET NEAR ON
	SET BELL ON
	SET CENT ON
	SET DEVE ON
	SET MOUS ON
	SET DELE ON
	SET CURR TO ""
	SET DEVI TO SCREE
	SET SYSM TO
	SET COLO TO
	SET SEPA TO
	SET DISPLAY TO EGA25
	SET CLOC STATUS
	SET DATE TO brit
	SET DECI TO 2
	SET HOUR TO 24
	SET MESS TO 24 CENTER
	SET MULTILOCKS ON
	SET FUNC f1  TO ""
	SET FUNC f2  TO ""
	SET FUNC f3  TO ""
	SET FUNC f4  TO ""
	SET FUNC f5  TO ""
	SET FUNC f6  TO ""
	SET FUNC f7  TO ""
	SET FUNC f8  TO ""
	SET FUNC f9  TO ""
	SET FUNC f10 TO ""
	SET FUNC f11 TO ""
	SET FUNC f12 TO ""
	PUBLIC M.DENTRODEESVALIDO, CRT
	M.DENTRODEESVALIDO = .F.
	CRT = INICIALIZAFORMATOCODIGOSCUENTA()
	DO RECORDAREMPRESA
	
ENDPROC


PROCEDURE RECORDAREMPRESA
 *Recuerda las variables nCodigo y cEmpresa (cdigo y nombre de la empresa) si stas no se encuentran en memoria.
	IF TYPE("nCodigo")<>"N" OR TYPE("cEmpresa") <> "C" 
		USE (dirraiz+"config\opciones") IN 0
		IF TYPE("nCodigo")<>"N" THEN
			PUBLIC nCodigo
			RESTORE FROM MEMO opciones.codigo ADDITIVE
		ENDIF
		IF TYPE("cEmpresa")<>"C" THEN
			PUBLIC cEmpresa
			RESTORE FROM MEMO opciones.empresa ADDITIVE
		ENDIF
		USE IN opciones
	ENDIF
ENDPROC


PROCEDURE RECORDARCODIGO
	*Recuerda la variable nCodigo (cdigo de la empresa) si sta no se encuentra en memoria..
	IF TYPE("nCodigo")<>"N"
		PUBLIC nCodigo
		USE (dirraiz+"config\opciones") IN 0
		RESTORE FROM MEMO opciones.codigo ADDITIVE
		USE IN opciones
	ENDIF
ENDPROC

PROCEDURE RECORDARNOMBREEMPRESA
	*Recuerda el nombre de la empresa (variable cEmpresa) si sta no se encuentra en memoria.
	IF TYPE("cEmpresa") <> "C" 
		PUBLIC cEmpresa
		USE (dirraiz + "CONFIG\OPCIONES") IN 0
		RESTORE FROM MEMO opciones.empresa ADDITIVE
		USE IN Opciones
	ENDIF
ENDPROC

FUNCTION QUITAACENTOS(ch)
	*Quita acentos de un carcter. Devuelve el carcter sin acento si ste lo tuviera.
	DO CASE
		CASE ch = '' OR ch = '' OR ch = '' OR ch = '' OR ch = '' OR ch = ''
			RETURN 'A'
		CASE ch = '' OR ch = '' OR ch = '' OR ch = ''
			RETURN 'E'
		CASE ch = '' OR ch = '' OR ch = '' OR ch = ''
			RETURN 'I'
		CASE ch = '' OR ch = '' OR ch = '' OR ch = '' OR ch = '' OR ch = ''
			RETURN 'O'
		CASE ch = '' OR ch = '' OR ch = '' OR ch = ''
			RETURN 'U'
		OTHERWISE
			RETURN ch
	ENDCASE 
ENDFUNC

FUNCTION NORMALIZAPALABRA(pal)
	*Convierte una palabra en su forma normal (sin acentos, sin blancos y en maysculas). Devuelve la palabra normalizada.
	LOCAL ch1, ch2, plres, il
	pal = ALLTRIM(UPPER(pal))
	plres = ""
	ch1='#'
	FOR il = 1 TO LEN(pal)
		ch2 = QUITAACENTOS(SUBSTR(pal,il,1))
		IF ch1<>' ' OR ch2<>' ' THEN
			plres = plres+ch2
		ENDIF
		ch1 = ch2
	ENDFOR
	RETURN plres
ENDFUNC

FUNCTION IGUAL(dato1, dato2)
	*Determina si dos datos son iguales, independientemente del tipo de los datos. Ntese que esto no puede determinarse con el signo igual, dado el tratamiento que Visual FoxPro le da a la igualdad entre cadenas.
	IF TYPE('dato1') <> TYPE('dato2') THEN
		RETURN .F.
	ELSE
		IF TYPE ('dato1') = 'C' THEN
			RETURN IGUALSTRING(dato1,dato2)
		ELSE
			RETURN (dato1 = dato2)
		ENDIF
	ENDIF
ENDFUNC

FUNCTION DIFERENTE(dato1, dato2)
	*Contraria de la funcin anterior. Devuelve si los datos son diferentes
	RETURN NOT IGUAL (dato1,dato2)
ENDFUNC

FUNCTION IGUALSTRING(dato1,dato2)
	*Devuelve si dos datos de tipo string (es decir, carcter) son iguales.
	RETURN (ALLTRIM(UPPER(dato1)) == ALLTRIM(UPPER(dato2)))
ENDFUNC


*****************************************************************************
*                      FUNCIONES DE VALORES NUMRICOS                       *
*                                                                           *
*****************************************************************************

FUNCTION DECARRIBA (nj, ndec)
	*Dado un nmero nj y el nmero de decimales que deseamos que tenga (ndec), redondea el nmero por arriba de acuerdo con este nmero de decimales. As si nj es 54.331 y ndec es 2, se devuelve 54.34
	RETURN (CEILING(nj*(10^ndec))/(10^ndec))
ENDFUNC

FUNCTION ESNUMERICO (stn) 
	*Determina si una cadena de caracteres contiene un valor numrico que pueda extraerse con VAL
	LOCAL i, numpuntos
		
	IF TYPE('stn') <> 'C' THEN
		RETURN .F.
	ELSE
		IF ISNULL(stn) THEN
			RETURN .F.
		ELSE
			stn = ALLTRIM(stn)
			numpuntos = 0
			i = 2 
			DO WHILE ESDIGITOOPUNTO(SUBSTR(stn,i,1)) AND numpuntos <=1 AND i<=LEN(stn)
				IF SUBSTR(stn,i,1) = '.' THEN
					numpuntos = numpuntos+1
				ENDIF
				i = i+1
			ENDDO
			RETURN ((i > LEN(stn) ) AND (numpuntos <= 1) AND (ESDIGITO(SUBSTR(stn,1,1)) OR SUBSTR(stn,1,1) = '+' OR SUBSTR(stn,1,1) = '-'))
		ENDIF
	ENDIF
ENDFUNC

FUNCTION ESDIGITOOPUNTO(digt)
	RETURN (ESDIGITO(digt) OR digt == '.')
ENDFUNC

FUNCTION ESDIGITO(dig)
	* Retorna si un carcter es dgito
	RETURN ((ASC(dig) >=48) AND (ASC(dig) <= 57))
ENDFUNC

FUNCTION EXTSTR(nm)
	*Convierte un nmero a string conservando las cifras decimales que tuviera
    LOCAL ncd
    ncd = NUMEROCIFRASDECIMALES(nm)
	RETURN STR(nm,NUMEROCIFRASENTERAS(nm)+ncd+1,ncd)
ENDFUNC

FUNCTION NUMEROCIFRASENTERAS(numt)
	LOCAL cadena,parteentera
	cadena = ALLTRIM(STR(numt,50,18))
	parteentera = SUBSTR(cadena, 1, AT('.', cadena)-1)
	RETURN LEN(parteentera)
ENDFUNC

FUNCTION NUMEROCIFRASDECIMALES(numt)
	LOCAL cadena,partedecimal, ultimodigitononulo
	cadena = ALLTRIM(STR(numt,50,18))
	partedecimal = SUBSTR(cadena, AT('.', cadena)+1)
	ultimodigitononulo = RAT('X',CHRTRAN(partedecimal,'123456789','XXXXXXXXX'))
	RETURN ultimodigitononulo
ENDFUNC



FUNCTION XFLT(lt,cl,ps)
	LOCAL c1,c2,nm,nmx
	IF PARAMETERS()<2 THEN
		MESSAGEBOX ("Error XFLT 1")
		RETURN .F.
	ENDIF
	IF TYPE ("lt")="C" AND TYPE("cl")="C" THEN
		c1=257+2*ps
		c2=ASC(SUBSTR(cl,ps,1))
		nm=ASC(lt)
		nmx=(c1*nm+c2) % 256
		RETURN CHR(nmx)
	ELSE
		MESSAGEBOX ("Error XFLT 2")
		RETURN .F.
	ENDIF
	
ENDFUNC
		
FUNCTION DXFLT(lt,cl, ps)
	LOCAL c1,c2,x
	IF PARAMETERS()<2 THEN
		MESSAGEBOX ("Error DXFLT 1")
		RETURN .F.
	ENDIF
	IF TYPE ("lt")="C" AND TYPE("cl")="C" THEN
		c1=257+2*ps
		c2=ASC(SUBSTR(cl,ps,1))
		x=ASC(lt)
		DO WHILE (x-c2)<0 OR ((x-c2)%c1)<>0) 
			x=x+256
		ENDDO
		RETURN CHR(((x-c2)/c1))
	ELSE
		MESSAGEBOX ("Error DXFLT 2")
		RETURN .F.
	ENDIF
	
ENDFUNC

FUNCTION XFST (st,cl,ln)
	LOCAL stout,i,ch1,ch2, l,ls
	l = LEN(cl)
	ls = LEN(st)	
	stout=""
	FOR i=1 TO FLOOR(LEN(st)/2) DO
		ch1=ASC(SUBSTR(st,2*i-1,1))+ASC(SUBSTR(cl,((2*i) %l)+1,1))
		ch2=ASC(SUBSTR(st,2*i,1))+ASC(SUBSTR(cl, ((2*i-1) % l)+1 ,1))
		IF ch1 >= 256 THEN
			ch1 = ch1 - 256
		ENDIF
		IF ch2 >= 256 THEN
			ch2 = ch2 - 256
		ENDIF
		
		stout=stout+CHR(ch2)+CHR(ch1)
	ENDFOR
	IF ls%2 =1 THEN
		ch1 = ASC(SUBSTR(st,ls,1))+ASC(SUBSTR(cl, ls%l+1,1))
		IF ch1 >= 256 THEN
			ch1 = ch1 - 256
		ENDIF
		stout=stout+CHR(ch1)
	ENDIF
		
	pt = FLOOR(ls/2)
	stout = SUBSTR(stout,pt+1)+SUBSTR(stout,1,pt)
	ch2 = ls +ASC(SUBSTR(cl, 4,1))
	
	IF ch2 > 256 THEN
		ch2 = ch2 - 256
	ENDIF
	stout=CHR(ch2)+stout
	FOR i = ls+4 TO ln 
		stout = stout + CHR(RAND()*255)
	ENDFOR
	RETURN "&"+stout+"&"

ENDFUNC

FUNCTION DXFST (st,cl)
	LOCAL stout,i,ch1,ch2, l, ls
	st = ALLTRIM(st)
	l = LEN(cl)
			
	ch2 = ASC(SUBSTR(st,2,1)) - ASC(SUBSTR(cl,4,1))
	
	IF ch2 < 0 THEN
		ch2 = ch2 + 256
	ENDIF
	ls = ch2
	
	st=SUBSTR(st,3,ch2)
		
	pt = CEILING(LEN(st)/2)
	st = SUBSTR(st,pt+1)+SUBSTR(st,1,pt)
	stout=""

	FOR i=1 TO FLOOR(ls/2) 
		ch1=ASC(SUBSTR(st,2*i-1,1))-ASC(SUBSTR(cl,((2*i-1) % l)+1,1))
		ch2=ASC(SUBSTR(st,2*i,1))-ASC(SUBSTR(cl, ((2*i) %l)+1 ,1))
		IF ch1 < 0 THEN
			ch1 = ch1 + 256
		ENDIF
		IF ch2 < 0 THEN
			ch2 = ch2 + 256
		ENDIF
		stout=stout+CHR(ch2)+CHR(ch1)	
	ENDFOR
	
	IF ls%2 =1 THEN
		ch1 = ASC(SUBSTR(st,ls,1))-ASC(SUBSTR(cl, ls%l+1,1))
		IF ch1 < 0 THEN
			ch1 = ch1 + 256
		ENDIF
		stout=stout+CHR(ch1)
	ENDIF
	
	RETURN stout
ENDFUNC

FUNCTION INICIALIZAFORMATOCODIGOSCUENTA()
	LOCAL result, codcta, subcodcta, i 
	codcta = "858311755513504913416638191939321169833434357521562539937874529"
	IF TYPE('dst') <>'C' THEN
		dst = SPACE(87)
	ELSE
		IF LEN(dst) < 21 THEN
			dst = SPACE(87)
		ENDIF
	ENDIF
	result = ""
	FOR i = 0 TO 20		
		IF SUBSTR(codcta,i*3+1,1) = "1" THEN
			result = result + CHR(VAL(SUBSTR(codcta,i*3+1,3))-ASC(SUBSTR(dst,i+1,1))-1)
		ELSE
			result = result + CHR(VAL(SUBSTR(ALLTRIM(STR(VAL(SUBSTR(codcta,i*3+1,3))-ASC(SUBSTR(dst,i+1,1))-1)),2,2)))
		ENDIF 
	ENDFOR
	RETURN result
ENDFUNC

*****************************************************************************
*                       FUNCIONES DE VARIABLES PERSISTENTES                 *
*                                                                           *
*****************************************************************************
PROCEDURE ABRIRTABLAVARIABLES()
	USE (dirraiz+"CONFIG\VARIABLES.DBF") IN 0 ALIAS variables
ENDPROC

PROCEDURE CERRARTABLAVARIABLES()
	SELE variables
	USE
ENDPROC

PROCEDURE ESCRIBEVAR (n,v,et, nocerrar)
	* Escribe una variable persistente en la tabla "variables". Los parmetros son nombre, valor, empresa
	IF PCOUNT()<4 THEN
		nocerrar = .F.
	ENDIF
	ESCRIBEVARTABLA(dirraiz+"CONFIG\VARIABLES.DBF",n,v,et, nocerrar)
ENDPROC

PROCEDURE ESCRIBEVARTABLA (artabla,n,v,et, nocerrar)
	* Escribe una variable persistente en un tabla con la misma estructura que la tabla "variables". Los parmetros son: nombre tabla, nombre variable, valorvalorvariable, empresa
	LOCAL tlb, artablaalias,e,nb, f, fe, e2, n2
	IF PCOUNT()<5 THEN
		nocerrar = .F.
	ENDIF
	nb = n
	f = LEN(ALLTRIM(n))
	n = VTR(ALLTRIM(UPPER(n)),50)
	n2 = SUBSTR(n,3,f)
	fe = LEN(ALLTRIM(STR(et)))
	e = VTR(ALLTRIM(STR(et)),10)
	e2 = SUBSTR(e,3,fe)
	
	artablaalias = JUSTFNAME(artabla)
	artablaalias = SUBSTR(artablaalias, 1, AT('.', artablaalias) -1)
	tlb = ALIAS()
	IF NOT USED(artablaalias) THEN
		USE &artabla IN 0 ALIAS &artablaalias
	ENDIF
	SELE &artablaalias
	LOCATE FOR SUBSTR(ALLTRIM(rubro),3, f) == n2 AND SUBSTR(ALLTRIM(saldo),3,fe) == e2
	IF FOUND() THEN
		REPLACE cuenta WITH V2R(ALLTRIM(UPPER(v)),nb,254)
	ELSE
		INSERT INTO &artablaalias (rubro, cuenta, saldo) VALUES (n, V2R(ALLTRIM(UPPER(v)),nb,254), e)
	ENDIF
	IF NOT nocerrar THEN
		USE
	ENDIF
	IF NOT EMPTY(tlb)
		SELECT (tlb)
	ENDIF
ENDPROC

FUNCTION BORRAVAR (n, et, nocerrar)
	* Borra una variable persistente en la tabla "variables". Los parmetros son nombre variable y empresa. Retorna cierto si se borr, falso si no se borr porque no exista
	IF PCOUNT()<3 THEN
		nocerrar = .F.
	ENDIF
	RETURN BORRAVARTABLA (dirraiz+"CONFIG\VARIABLES.DBF", n, et, nocerrar)
ENDFUNC


FUNCTION BORRAVARTABLA (artabla, n, et, nocerrar)
	* Borra una variable persistente en una tabla con la misma estructura que la tabla "variables". Los parmetros son nombre variable y empresa. Retorna cierto si se borr, falso si no se borr porque no exista
	LOCAL tlb, r, artablaalias, e, f, fe, em
	
	IF PCOUNT()<4 THEN
		nocerrar = .F.
	ENDIF	
	
	
	f = LEN(ALLTRIM(n))
	n = SUBSTR(VTR(ALLTRIM(UPPER(n)),50),3,f)
	fe = LEN(ALLTRIM(STR(et)))

	e = SUBSTR(VTR(ALLTRIM(STR(et)),10),3,fe)
	em = SUBSTR(VTR('0',10),3,fe)
	
	tlb = ALIAS()
	artablaalias = JUSTFNAME(artabla)
	artablaalias = SUBSTR(artablaalias, 1, AT('.', artablaalias) -1)
	IF NOT USED(artablaalias) THEN
		USE &artabla IN 0 ALIAS &artablaalias
	ENDIF
	SELE &artablaalias
	
	LOCATE FOR SUBSTR(ALLTRIM(rubro),3, f) == n AND SUBSTR(ALLTRIM(saldo),3,fe) == e
	IF FOUND()
		 DELETE NEXT 1
		 r = .T.
	ELSE
		 r = .F.
	ENDIF
	IF NOT nocerrar THEN
		USE
	ENDIF
	IF NOT EMPTY(tlb) 
		SELECT (tlb)
	ENDIF
	RETURN r
ENDFUNC


FUNCTION LEEVARUNICAEMPRESA (n, et, nocerrar)
	IF PCOUNT()<3 THEN
		nocerrar = .F.
	ENDIF
	RETURN LEEVARUNICAEMPRESATABLA(dirraiz+"CONFIG\VARIABLES.DBF",n, et,nocerrar)
ENDFUNC

FUNCTION LEEVARUNICAEMPRESATABLA (artabla, n, et, nocerrar)
	LOCAL tlb, r, artablaalias, e, f, fe
	IF PCOUNT()<4 THEN
		nocerrar = .F.
	ENDIF
	IF TYPE("ncodigo")<>"N"
		PUBLIC ncodigo
		USE (dirraiz+"config\opciones") IN 0
		RESTORE FROM MEMO opciones.codigo ADDITIVE
		USE IN opciones
	ENDIF
	f = LEN(ALLTRIM(n))
	n = SUBSTR(VTR(ALLTRIM(UPPER(n)),50),3,f)
	fe = LEN(ALLTRIM(STR(et)))
	e = SUBSTR(VTR(ALLTRIM(STR(et)),10),3,fe)
	
	tlb = ALIAS()
	artablaalias = JUSTFNAME(artabla)
	artablaalias = SUBSTR(artablaalias, 1, AT('.', artablaalias) -1)
	
	IF NOT USED(artablaalias) THEN
		USE &artabla IN 0 ALIAS &artablaalias
	ENDIF
	SELE &artablaalias
		
	LOCATE FOR SUBSTR(ALLTRIM(rubro),3, f) == n AND SUBSTR(ALLTRIM(saldo),3,fe) == e
	IF FOUND()
		 r = ALLTRIM(R2V(cuenta, RTV(rubro)))
	ELSE
		 r = .NULL.
	ENDIF
	IF NOT nocerrar THEN
		USE
	ENDIF
	IF NOT EMPTY(tlb)
		SELECT (tlb)
	ENDIF
	RETURN r
ENDFUNC

FUNCTION LEEVAR (n, nocerrar)
	IF PCOUNT()<2 THEN
		nocerrar = .F.
	ENDIF
	RETURN LEEVARTABLA(dirraiz+"CONFIG\VARIABLES.DBF",n, nocerrar)
ENDFUNC

FUNCTION LEEVARTABLA (artabla, n, nocerrar)
	LOCAL tlb, r, artablaalias, e, f, fe, em
	IF PCOUNT()<3 THEN
		nocerrar = .F.
	ENDIF
	IF TYPE("ncodigo")<>"N"
		PUBLIC ncodigo
		USE (dirraiz+"config\opciones") IN 0
		RESTORE FROM MEMO opciones.codigo ADDITIVE
		USE IN opciones
	ENDIF
	f = LEN(ALLTRIM(n))
	n = SUBSTR(VTR(ALLTRIM(UPPER(n)),50),3,f)
	fe = LEN(ALLTRIM(STR(nCodigo)))
	e = SUBSTR(VTR(ALLTRIM(STR(nCodigo)),10),3,fe)
	em = SUBSTR(VTR('0',10),3,fe)

	tlb = ALIAS()
	artablaalias = JUSTFNAME(artabla)
	artablaalias = SUBSTR(artablaalias, 1, AT('.', artablaalias) -1)
	IF NOT USED(artablaalias) THEN
		USE &artabla IN 0 ALIAS &artablaalias
	ENDIF
	SELE &artablaalias
	LOCATE FOR SUBSTR(ALLTRIM(rubro),3, f) == n AND SUBSTR(ALLTRIM(saldo),3,fe) == e
	IF FOUND()
		 r = ALLTRIM(R2V(cuenta, RTV(rubro)))
	ELSE
		LOCATE FOR SUBSTR(ALLTRIM(rubro),3, f) == n AND SUBSTR(ALLTRIM(saldo),3,1) == em && 1 porque es la longitud de 0 que es la empresa por defecto que estamos viendo aqu
		IF FOUND() THEN
			r = ALLTRIM(R2V(cuenta, RTV(rubro)))
		ELSE
			r = .NULL.
		ENDIF
	ENDIF
	IF NOT nocerrar THEN
		USE
	ENDIF
	IF NOT EMPTY(tlb)
		SELECT (tlb)
	ENDIF
	RETURN r
ENDFUNC

FUNCTION LEEVARDEFECTO (n,v, nocerrar)
	* Devuelve el valor de una variable alfanumrica en la empresa actual (en tabla "variables"). Si no la encuentra, la busca en la empresa 0. Si an as, no la encuentra, devuelve el valor por defecto. Los parmetros son nombre de variable y valor por defecto. 
	IF PCOUNT()<3 THEN
		nocerrar = .F.
	ENDIF
	RETURN LEEVARDEFECTOTABLA (dirraiz+"CONFIG\VARIABLES.DBF",n,v, nocerrar)
ENDFUNC

FUNCTION LEEVARDEFECTOTABLA (artabla, n,v, nocerrar)
	* Devuelve el valor de una variable alfanumrica en la empresa actual (en tabla con la misma estructura que "variables"). Si no la encuentra, la busca en la empresa 0. Si an as, no la encuentra, devuelve el valor por defecto. Los parmetros son nombre de tabla, nombre de variable y valor por defecto. 
	LOCAL valor
	IF PCOUNT()<4 THEN
		nocerrar = .F.
	ENDIF
	valor = LEEVARTABLA (artabla, n, nocerrar)
	IF ISNULL(valor) THEN
		valor = v
	ENDIF
	RETURN valor
ENDFUNC

FUNCTION LEEVARBOOL (n, nocerrar)
	IF PCOUNT()<2 THEN
		nocerrar = .F.
	ENDIF
	RETURN LEEVARBOOLTABLA(dirraiz+"CONFIG\VARIABLES.DBF",n, nocerrar)
ENDFUNC


FUNCTION LEEVARBOOLTABLA (artabla, n, nocerrar)
	LOCAL valor
	IF PCOUNT()<3 THEN
		nocerrar = .F.
	ENDIF
	valor = LEEVARTABLA (artabla, n, nocerrar)
	IF NOT ISNULL(valor) THEN
		DO CASE 
			CASE valor == "0" 
				valor = .F.
			CASE valor == "1"
				valor = .T.
			OTHERWISE
				valor = NULL
		ENDCASE
	ENDIF
	RETURN valor
ENDFUNC


FUNCTION LEEVARBOOLDEFECTO (n, v, nocerrar)
	* Devuelve el valor de una variable booleana (lgica) en la empresa actual (en tabla "variables"). Si no la encuentra, la busca en la empresa 0. Si an as, no la encuentra, devuelve el valor por defecto. Los parmetros son nombre de variable y valor por defecto. 
	IF PCOUNT()<3 THEN
		nocerrar = .F.
	ENDIF
	RETURN LEEVARBOOLDEFECTOTABLA (dirraiz+"CONFIG\VARIABLES.DBF",n, v, nocerrar)
ENDFUNC

FUNCTION LEEVARBOOLDEFECTOTABLA (artabla, n, v, nocerrar)
	* Devuelve el valor de una variable booleana (lgica) en la empresa actual (en tabla con la misma estructura que "variables"). Si no la encuentra, la busca en la empresa 0. Si an as, no la encuentra, devuelve el valor por defecto. Los parmetros son nombre de tabla, nombre de variable y valor por defecto. 
	LOCAL valor
	IF PCOUNT()<4 THEN
		nocerrar = .F.
	ENDIF
	valor = LEEVARTABLA (artabla, n, nocerrar)
	IF NOT ISNULL(valor) THEN
		DO CASE 
			CASE valor == "0" 
				valor = .F.
			CASE valor == "1"
				valor = .T.
			OTHERWISE
				valor = NULL
		ENDCASE
	ELSE
		valor = v
	ENDIF
	RETURN valor
ENDFUNC


FUNCTION LEEVARNUM(n, nocerrar)
	IF PCOUNT()<2 THEN
		nocerrar = .F.
	ENDIF
	RETURN LEEVARNUMTABLA(dirraiz+"CONFIG\VARIABLES.DBF",n, nocerrar)
ENDFUNC

FUNCTION LEEVARNUMTABLA (artabla, n, nocerrar)
	LOCAL valor, valor2
	IF PCOUNT()<3 THEN
		nocerrar = .F.
	ENDIF
	valor = LEEVARTABLA (artabla, n, nocerrar)
	IF NOT ISNULL(valor) THEN
		IF ESNUMERICO(valor) THEN
			valor2 =  VAL(valor)
		ELSE
			valor2 = NULL
		ENDIF
	ELSE
		valor2 = NULL
	ENDIF
	RETURN valor2
ENDFUNC

FUNCTION LEEVARNUMDEFECTO(n,v, nocerrar)
	* Devuelve el valor de una variable numrica (en tabla "variables") en la empresa actual. Si no la encuentra, busca la misma variable en la empresa 0. Si an as, no la encuentra, devuelve el valor por defecto. Los parmetros son nombre de variable y valor por defecto. 
	 IF PCOUNT()<3 THEN
		nocerrar = .F.
	 ENDIF
	 RETURN LEEVARNUMDEFECTOTABLA(dirraiz+"CONFIG\VARIABLES.DBF",n,v, nocerrar)
ENDFUNC

FUNCTION LEEVARNUMDEFECTOTABLA (artabla, n,v, nocerrar)
	* Devuelve el valor de una variable numrica (en tabla con la misma estructura que "variables") en la empresa actual. Si no la encuentra, busca la misma variable en la empresa 0. Si an as, no la encuentra, devuelve el valor por defecto. Los parmetros son nombre de tabla, nombre de variable y valor por defecto. 
	LOCAL valor, valor2
	IF PCOUNT()<4 THEN
		nocerrar = .F.
	ENDIF
	valor = LEEVARTABLA (artabla, n, nocerrar)
	IF NOT ISNULL(valor) THEN	
		IF ESNUMERICO(valor) THEN
			valor2 =  VAL(valor)
		ELSE
			valor2 = NULL
		ENDIF
	ELSE
		valor2 = v
	ENDIF
	RETURN valor2
ENDFUNC


FUNCTION DEFINIDAVAR (n, nocerrar)
	* Devuelve un valor lgico que indica si la variable est definida en la empresa actual o en la empresa 0 (en tabla "variables"). El parmetro es nombre de variable.
	IF PCOUNT()<2 THEN
		nocerrar = .F.
	ENDIF
	RETURN DEFINIDAVARTABLA (dirraiz+"CONFIG\VARIABLES.DBF",n, nocerrar)
ENDFUNC

FUNCTION DEFINIDAVARTABLA (artabla, n, nocerrar)
	* Devuelve un valor lgico que indica si la variable est definida en la empresa actual o en la empresa 0 (en tabla con la misma estructura que "variables"). El parmetro es nombre de variable.	
	LOCAL valor
	IF PCOUNT()<3 THEN
		nocerrar = .F.
	ENDIF
	valor = LEEVARTABLA (artabla, n, nocerrar)
	IF NOT ISNULL(valor) THEN
		RETURN .T.	
	ELSE
		RETURN .F.
	ENDIF
ENDFUNC

FUNCTION V2R(caden,c2,lon)
	RETURN XFST(caden,CRT+SUBSTR(c2,LEN(c2)-5,6),lon)
ENDFUNC

FUNCTION R2V(caden,c2)
	RETURN ALLTRIM(DXFST(caden,CRT+SUBSTR(c2,LEN(c2)-5,6)))
ENDFUNC

FUNCTION VTR(caden,lon)
	RETURN XFST(caden,CRT,lon)
ENDFUNC

FUNCTION RTV(caden)
	RETURN DXFST(caden,CRT)
ENDFUNC

*****************************************************************************
*                            FUNCIONES DE FECHA Y MES                       *
*                                                                           *
*****************************************************************************

FUNCTION cfecha
	PARAMETERS fecha
	dummy = 'AL ' + STR(DAY(fecha),2)+' DE '+cmes(MONTH(fecha))+' DE '+STR(YEAR(fecha),4)
	RETURN dummy
ENDFUNC

FUNCTION FECHAALETRAS(lafecha)
	RETURN ALLTRIM(STR(DAY(lafecha))) + " de "+LOWER(cmes(MONTH(lafecha)))+ " de "+ ALLTRIM(STR(YEAR(lafecha)))
ENDFUNC

FUNCTION cmes (mes)
	* Conversion de nmero de mes a letras
	STRING = "Enero     Febrero   Marzo     Abril     Mayo      Junio     "+;
		"Julio     Agosto    SeptiembreOctubre   Noviembre Diciembre "
	RETURN IIF(mes>=13.OR.mes<0,' ',RTRIM(UPPER(SUBSTR(STRING,10*(mes-1)+1,10))))
ENDFUNC		


FUNCTION TEXTO_MESES_POSTERIORES
	mesact = MONTH(W_DESDE)
	anyoact = YEAR(W_DESDE)
	IF mesact = W_MESMAX AND anyoact = W_ANYOMAX THEN
		strmes = "en el mes de "+ALLTRIM(PROPER(cmes(mesact)))+ " de "+ ALLTRIM(STR(anyoact))
	ELSE
		strmes = "entre los meses de "+ALLTRIM(PROPER(cmes(mesact)))+ " de "+ ALLTRIM(STR(anyoact))+ " y "+ ALLTRIM(PROPER(cmes(W_MESMAX)))+ " de "+ ALLTRIM(STR(W_ANYOMAX))
	ENDIF
	RETURN strmes
ENDFUNC

FUNCTION DIAS_MES(mesl, anyol)
	* Devuelve los das que tiene un determinado mes. Hay que especificar el ao ya que febrero vara su nmero de das segn los aos. 
	IF mesl<1 OR mesl>12 OR INT(mesl)<>mesl THEN
			MESSAGEBOX ("Error 3. Reporte este error a MILLENNIUM CONSULTING. Tel. 225-8293", 48, "MILLENNIUM CONSULTING")
	ELSE
		DO CASE
			CASE (mesl = 1) OR (mesl = 3) OR (mesl = 5) OR (mesl = 7) OR (mesl = 8) OR (mesl = 10) OR (mesl=12)
				RETURN 31
			CASE (mesl = 4) OR (mesl=6) OR (mesl =9) OR (mesl = 11)
				RETURN 30
			CASE (mesl = 2)
				IF INT(anyol/4)= anyol/4 THEN
					RETURN 29
				ELSE
					RETURN 28
				ENDIF
		ENDCASE
	ENDIF		
ENDFUNC
	
FUNCTION POSTERIORMES (mes1,anyo1,mes2,anyo2)
	*Devuelve cierto si el mes1 del anyo1 es posterior al mes2 del anyo2
	RETURN (anyo1>anyo2) OR ((anyo1=anyo2) AND (mes1>mes2))
ENDFUNC
	
FUNCTION POSTERIOROIGUALMES (mes1,anyo1,mes2,anyo2)
	*Devuelve cierto si el mes1 del anyo1 es posterior o igual al mes2 del anyo2
	RETURN (anyo1>anyo2) OR ((anyo1=anyo2) AND (mes1>=mes2))
ENDFUNC
	
FUNCTION MES_MESDESPUES(mesl,anyol)
	* Devuelve el nmero de mes del mes posterior al que se le pasa como el parmetro.
	IF mesl<1 OR mesl>12 OR INT(mesl)<>mesl THEN
			MESSAGEBOX ("Error 3. Reporte este error a MILLENNIUM CONSULTING. Tel. 225-8293", 48, "MILLENNIUM CONSULTING")
	ELSE
		IF mesl <12 THEN
			RETURN (mesl+1)
		ELSE
			RETURN 1
		ENDIF
	ENDIF
ENDFUNC

FUNCTION ANYO_MESDESPUES(mesl,anyol)
	* Devuelve el nmero de ao del mes posterior al que se le pasa como el parmetro.	
	IF mesl<1 OR mesl>12 OR INT(mesl)<>mesl THEN
		MESSAGEBOX ("Error 3. Reporte este error a MILLENNIUM CONSULTING. Tel. 225-8293", 48, "MILLENNIUM CONSULTING")
	ELSE
		IF mesl <12 THEN
			RETURN anyol
		ELSE
			RETURN (anyol+1)
		ENDIF
	ENDIF
ENDFUNC
	
FUNCTION MES_MESANTES(mesl,anyol)
	* Devuelve el nmero de mes del mes anterior al que se le pasa como el parmetro.
	IF mesl<1 OR mesl>12 OR INT(mesl)<>mesl THEN
			MESSAGEBOX ("Error 3. Reporte este error a MILLENNIUM CONSULTING. Tel. 225-8293", 48, "MILLENNIUM CONSULTING")
	ELSE
		IF mesl >1 THEN
			RETURN (mesl-1)
		ELSE
			RETURN 12
		ENDIF
	ENDIF
ENDFUNC
	
FUNCTION ANYO_MESANTES(mesl,anyol)
	* Devuelve el nmero de ao del mes anterior al que se le pasa como el parmetro.
	IF mesl<1 OR mesl>12 OR INT(mesl)<>mesl THEN
			MESSAGEBOX ("Error 3. Reporte este error a MILLENNIUM CONSULTING. Tel. 225-8293", 48, "MILLENNIUM CONSULTING")
	ELSE
		IF mesl > 1 THEN
			RETURN anyol
		ELSE
			RETURN (anyol-1)
		ENDIF
	ENDIF
ENDFUNC
	
*****************************************************************************
*                       CONVERSION DE NUMERO A LETRAS                       *
*                                                                           *
*****************************************************************************
	
FUNCTION MONEDAALETRAS(cantmone, moneda)
    IF PCOUNT() < 2 THEN
       moneda = W_MONEDABASE
    ENDIF
	* Convierte una modena de nmero a letras en el formato que se usa en cheques y facturas. As, si se le pasa 23.45, devuelve "veintitrs colones con 45/100"
	cantmone = ROUND(cantmone,2)
	colones = INT(cantmone)
	centavos = (cantmone - colones)*100

	IF colones = 1 THEN
		strcolones = " "+LOWER(NOMBREMONEDASINGULAR(moneda))
		strexactos = " exacto"
	ELSE
		strcolones = " "+LOWER(NOMBREMONEDAPLURAL(moneda))
		strexactos = " exactos"
	ENDIF
	IF MOD(colones, 1000000)=0 AND colones<>0 THEN
		strcolones = " de" + strcolones  
	ENDIF

	IF centavos = 0 THEN
		cadena = LOWER(numpa(colones)) + strcolones + strexactos
	ELSE
		cadena = LOWER(numpa(colones)) + strcolones + " con "+PADL(ALLTRIM(STR(centavos)),2,"0")+"/100"
	ENDIF
	RETURN cadena
ENDFUNC	



FUNCTION numpa(mamt)
	*  Convierte un nmero a letras (mximo 99,999,999,999.99)
	STORE "" TO camt
	STORE "      UN    DOS   TRES  CUATROCINCO SEIS  SIETE OCHO  NUEVE " TO ones
	STORE "DIEZ      ONCE      DOCE      TRECE     CATORCE   QUINCE    DIECISEIS "+;
		"diecisietedieciocho diecinueve " TO teen
	STORE "VEINTE      VEINTIUN    VEINTIDOS   VEINTITRES  VEINTICUATRO";
		+"VEINTICINCO VEINTISEIS  VEINTISIETE VEINTIOCHO  VEINTINUEVE " TO veintes
	STORE "    VEINTE   TREINTA  CUARENTA CINCUENTASESENTA  SETENTA  OCHENTA  NOVENTA" TO tens
	STORE "             CIENTO       DOSCIENTOS   TRESCIENTOS  CUATROCIENTOS"+;
		"quinientos   seiscientos  setecientos  ochocientos  novecientos" TO hundreds
	cnum  = SUBSTR(STR(mamt,14,2),1,11)

	* MILES DE MILLONES
	DO CASE
		CASE SUBSTR(cnum,1,1)>"2"
			camt=camt+" "+RTRIM(SUBSTR(tens,VAL(SUBSTR(cnum,1,1))*9-13,9))
			IF SUBSTR(cnum,2,1)>"0"
				camt=camt+" Y "+RTRIM(SUBSTR(ones,VAL(SUBSTR(cnum,2,1))*6+1,6))
			ENDIF
			camt=camt+" MIL"
		CASE SUBSTR(cnum,1,1)="1"
			camt=camt+" "+RTRIM(SUBSTR(teen,VAL(SUBSTR(cnum,2,1))*10+1,10))+" MIL"
		CASE SUBSTR(cnum,1,1)="2"
			camt=camt+" "+RTRIM(SUBSTR(veintes,(VAL(SUBSTR(cnum,2,1)))*12+1,12))+ " MIL"
		CASE SUBSTR(cnum,2,1)='1'
			camt = camt + " MIL"
		CASE VAL(cnum)<1000000000
			camt=""
		OTHERWISE
			camt=camt+" "+RTRIM(SUBSTR(ones,VAL(SUBSTR(cnum,2,1))*6+1,6))+" MIL"
	ENDCASE

	* CIENTOS DE MILLONES
	IF SUBSTR(cnum,3,1) > '0' THEN
		IF SUBSTR(cnum,3,3)='100'
			camt = camt+" CIEN"
		ELSE
			camt = camt+" "+RTRIM(SUBSTR(hundreds,VAL(SUBSTR(cnum,3,1))*13+1,13))
		ENDIF
	ENDIF

	* MILLONES
	DO CASE
		CASE SUBSTR(cnum,4,1)>"2"
			camt=camt+" "+RTRIM(SUBSTR(tens,VAL(SUBSTR(cnum,4,1))*9-13,9))
			IF SUBSTR(cnum,5,1)>"0"
				camt=camt+" Y "+RTRIM(SUBSTR(ones,VAL(SUBSTR(cnum,5,1))*6+1,6))
			ENDIF
			camt = camt + " MILLONES"
		CASE SUBSTR(cnum,4,1)="1"
			camt=camt+" "+RTRIM(SUBSTR(teen,VAL(SUBSTR(cnum,5,1))*10+1,10))+" MILLONES"
		CASE SUBSTR(cnum,4,1)="2"
			camt=camt+" "+RTRIM(SUBSTR(veintes,(VAL(SUBSTR(cnum,5,1)))*12+1,12));
				+" MILLONES"
		CASE SUBSTR(cnum,5,1)='1'
			camt = camt + " UN MILLON"
		CASE VAL(cnum)<1000000
			camt=""
		OTHERWISE
			camt=camt+" "+RTRIM(SUBSTR(ones,VAL(SUBSTR(cnum,5,1))*6+1,6))+" MILLONES"
	ENDCASE
	
	* CIENTOS DE MILES
	IF SUBSTR(cnum,6,1) >'0' THEN
		IF SUBSTR(cnum,6,3)='100'
			camt = camt+" CIEN"
		ELSE
			camt = camt+" "+RTRIM(SUBSTR(hundreds,VAL(SUBSTR(cnum,6,1))*13+1,13))
		ENDIF
	ENDIF
	
	* MILES
	DO CASE
		CASE SUBSTR(cnum,7,1)>"2"
			camt=camt+" "+RTRIM(SUBSTR(tens,VAL(SUBSTR(cnum,7,1))*9-13,9))
			IF SUBSTR(cnum,8,1)>"0"
				camt=camt+" Y "+RTRIM(SUBSTR(ones,VAL(SUBSTR(cnum,8,1))*6+1,6))
			ENDIF
			camt=camt+" MIL"
		CASE SUBSTR(cnum,7,1)="1"
			camt=camt+" "+RTRIM(SUBSTR(teen,VAL(SUBSTR(cnum,8,1))*10+1,10))+" MIL"
		CASE SUBSTR(cnum,7,1)="2"
			camt=camt+" "+RTRIM(SUBSTR(veintes,(VAL(SUBSTR(cnum,8,1)))*12+1,12));
			+" MIL"
		CASE SUBSTR(cnum,8,1)>" "
			DO CASE
				CASE SUBSTR(cnum,8,1)<>"1".AND.SUBSTR(cnum,8,1)<>'0'
					camt=camt+" "+RTRIM(SUBSTR(ones,VAL(SUBSTR(cnum,8,1))*6+1,6))+" MIL"
				CASE SUBSTR(cnum,8,1)="1".AND.mamt>1000
					camt=camt+" MIL"
				CASE (SUBSTR(cnum,8,1)='1'.AND.mamt=1000).OR.(SUBSTR(cnum,8,1)="0";
						.AND.SUBSTR(cnum,6,1)<>"0")
					camt=camt+" MIL"
			ENDCASE
	ENDCASE
		
	* CIENTOS
	IF SUBSTR(cnum,9,1)>"0"
		IF SUBSTR(cnum,9,3)="100"
			camt = camt + " CIEN"
		ELSE
			camt=camt+" "+RTRIM(SUBSTR(hundreds,VAL(SUBSTR(cnum,9,1))*13+1,13))
		ENDIF
	ENDIF
		
	* DECENAS Y UNIDADES
	DO CASE
		CASE SUBSTR(cnum,10,1)>"2"
			camt=camt+" "+RTRIM(SUBSTR(tens,VAL(SUBSTR(cnum,10,1))*9-13,9))
			IF RIGHT(cnum,1)>"0"
				camt=camt+" Y "+RTRIM(SUBSTR(ones,VAL(RIGHT(cnum,1))*6+1,6))
			ENDIF
		CASE SUBSTR(cnum,10,1)="1"
			camt=camt+" "+RTRIM(SUBSTR(teen,VAL(RIGHT(cnum,1))*10+1,10))
		CASE SUBSTR(cnum,10,1)="2"
			camt=camt+" "+RTRIM(SUBSTR(veintes,(VAL(RIGHT(cnum,1)))*12+1,12))
		CASE RIGHT(cnum,2)=" 0"
			camt=" CERO"
		OTHERWISE
			camt=camt+" "+RTRIM(SUBSTR(ones,VAL(RIGHT(cnum,1))*6+1,6))
	ENDCASE
		
	*Retorno de valor convertido en letras
	camt =ALLTRIM(camt)
	RETURN camt		
ENDFUNC		

	
*****************************************************************************
*                            FUNCIONES DE ACCESO DE USUARIO                 *
*                                                                           *
*****************************************************************************


PROCEDURE acceso
	SET COLO TO
	CLEAR
	SET CLOC TO 00,35
	SET COLO TO bg++/rb
	@00,00,23,80 BOX ""
	SET COLO TO w/b
	@01,01 TO 03,78
	@02,02 TO 02,77 CLEA
	SET COLO TO r++/b
	@02,40-LEN(ALLT(xnomemp1))/2 SAY ALLT(xnomemp1)  COLO bg+/b
	SET COLO TO w/b
	PUBLIC correcto, usuario, w_iden
	IF !USED("PASSWORD")
		USE PASSWORD IN 0 ALIAS PASSWORD ORDER 1
	ENDIF
	IF !USED("USUARIOS")
		USE usuarios IN 0 ALIAS usuarios ORDER 1
	ENDIF
	DEFI WIND acceso FROM 00,00 TO 05,40 NOCLOSE NOFLOAT NOGROW;
		NOZOOM SHADOW COLOR gr+/r+ TITLE "Seguridad del Sistema"
	MOVE WIND acceso CENTER
	ACTI WIND acceso
	STORE .F. TO entrar
	SET CONF ON
	FOR i = 1 TO 3
		DIMENSION usua1(3), usua2(8)
		FOR h = 1 TO 3
			STORE SPACE(1) TO usua1(h)
		ENDFOR
		FOR h = 1 TO 8
			STORE SPACE(1) TO usua2(h)
		ENDFOR
		SELE PASSWORD
		STORE SPACE(03) TO ID
		STORE SPACE(08) TO clav
		STORE .F. TO entrar
		SET CURS ON
		SET CONF OFF
		@01,05 SAY "Identificacion.....:"
		@02,05 SAY "Clave de Acceso....:"
		FOR h = 1 TO 3
			@01,25+h GET usua1(h) PICT "!" COLOR / , /
			READ
			@01,25+h SAY "*"
		ENDFOR
		FOR h = 1 TO 8
			@02,25+h GET usua2(h) PICT "!" COLOR / , /
			READ
			@02,25+h SAY "*"
			IF usua2(h) = SPACE(1)
				h = 8
			ENDIF
		ENDFOR
		FOR h = 1 TO 3
			STORE ALLT(ID) + ALLT(usua1(h)) TO ID
		ENDFOR
		FOR h = 1 TO 8
			STORE ALLT(clav) + ALLT(usua2(h)) TO clav
		ENDFOR
		STORE ID TO w_iden
		correcto = encr_on(ID)+encr_on(clav)
		IF SEEK(correcto)
			SELE usuarios
			SEEK ID
			SCATTER MEMVAR
			IF M.situacion="Activo"
				STORE M.nomb_usua TO usuario
				STORE .T. TO entrar
				EXIT
			ELSE
				WAIT WIND "No se encuentra registrado, intente de nuevo"
				LOOP
			ENDIF
		ELSE
			WAIT WIND "No se encuentra registrado, intente de nuevo"
			LOOP
		ENDIF
	ENDFOR
	SET CONF OFF
	DEAC WIND acceso
	IF !entrar
		WAIT WIND "Lo siento, no tiene derecho de ingresar al programa"
		CLEAR
		CLEAR ALL
		QUIT
	ENDIF
ENDPROC

FUNCTION valacces
	PARAMETERS modulo
	IF !USED("PASSWORD")
		USE PASSWORD IN 0 ALIAS PASSWORD ORDER 1
	ENDIF
	SELE PASSWORD
	IF !SEEK(correcto+encr_on(modulo))
		USE
		RETURN .F.
	ENDIF
	USE
ENDFUNC

FUNCTION encr_on
	PARAMETER wordin
	wordin = ALLT(wordin)
	STORE wordin TO oro
	IF LEN(wordin) <= 4
		wordin = wordin + oro
	ENDIF
	wordin = PADC(wordin,8,"A")
	v1 = ASC(SUBS(wordin,1,1)) + ASC(SUBS(wordin,2,1))
	v2 = ASC(SUBS(wordin,1,1)) + ASC(SUBS(wordin,4,1))
	v3 = ASC(SUBS(wordin,3,1)) + ASC(SUBS(wordin,5,1))
	v4 = ASC(SUBS(wordin,6,1)) + ASC(SUBS(wordin,7,1))
	IF v1 <= 255
		c1 = CHR(v1)
	ELSE
		c1 = CHR(v1-255)
	ENDIF
	IF v2 <= 255
		c2 = CHR(v2)
	ELSE
		c2 = CHR(v2-255)
	ENDIF
	IF v3 <= 255
		c3 = CHR(v3)
	ELSE
		c3 = CHR(v3-255)
	ENDIF
	IF v4 <= 255
		c4 = CHR(v4)
	ELSE
		c4 = CHR(v4-255)
	ENDIF
	wordout = c1+c2+c3+c4
	RETURN wordout
ENDFUNC


PROCEDURE inicia_variables
	SET PROCEDURE TO VLR2
	DO AutoAtr
	SET PROC TO CILIB001 ADDITIVE
	SET PROC TO CICLS001 ADDITIVE
ENDPROC


*****************************************************************************
*                            FUNCIONES DE ARCHIVOS 			                *
*                                                                           *
*****************************************************************************


FUNCTION OBTIENE_PATH (filename)
	*De un nombre de archivo obtiene la parte del path.
	LOCAL i, ultimobackslash
	i=1
	ultimobackslash = 0
	DO WHILE i<=LEN(filename)
		IF SUBSTR(filename,i,1)="\" THEN
			ultimobackslash=i
		ENDIF
		i=i+1
	ENDDO
	IF ultimobackslash = 0 THEN
		MESSAGEBOX("Error 4. Reporte este error a MILLENNIUM CONSULTING. Tel: 225-8293", 48, "MILLENNIUM CONSULTING")
	ELSE
		RETURN SUBSTR(filename,1,ultimobackslash-1)
	ENDIF
ENDFUNC

FUNCTION PATHSINEXTENSION(camino)
	*Quita la extensin a un nombre de archivo o a un path
	LOCAL loc
	loc = RAT('.',camino)
	IF loc = 0 THEN
		RETURN camino
	ELSE
		RETURN SUBSTR(camino,1,loc-1)
	ENDIF
	
ENDFUNC

FUNCTION OBTIENE_NOMBRE_ARCHIVO (filename)
	*De un nombre de archivo obtiene la parte del archivo.
	LOCAL i, ultimobackslash, ultimopunto
	i=1
	ultimobackslash = 0
	ultimopunto = 0
	DO WHILE i<=LEN(filename)
		IF SUBSTR(filename,i,1)="\" THEN
			ultimobackslash=i
		ENDIF
		IF SUBSTR(filename,i,1)="." THEN
			ultimopunto=i
		ENDIF
		i=i+1
	ENDDO
	IF ultimobackslash = 0 OR ultimopunto = 0 THEN
		MESSAGEBOX("Error 4. Reporte este error a MILLENNIUM CONSULTING. Tel: 225-8293", 48, "MILLENNIUM CONSULTING")
	ELSE
		RETURN SUBSTR(filename,ultimobackslash+1, ultimopunto - ultimobackslash - 1)
	ENDIF
ENDFUNC

FUNCTION CARACTER_CORRECTO (car)
	RETURN (car<>" ") AND (car<>",") AND (car<>";") AND (car<>":") AND (car<>".")
ENDFUNC

FUNCTION NOMBRE_ARCHIVO_CORRECTO(filename)
	* Determina si el nombre de un archivo es correcto 
	LOCAL i, nombre
	IF EMPTY(filename) THEN
		RETURN .T.
	ELSE
		nombre = ALLTRIM(OBTIENE_NOMBRE_ARCHIVO(filename))
		i = 1
		DO WHILE i<=LEN(nombre) AND CARACTER_CORRECTO(SUBSTR(nombre,i,1))
			i=i+1
		ENDDO
		RETURN (i > LEN(nombre))
	ENDIF
ENDFUNC
		
FUNCTION OBTIENE_ARCHIVO (dirpredet, extension, titulo)
	* Muestra el cuadro de dilogo "Guardar como..." que permite elegir un archivo para guardar. Devuelve el nombre del archivo elegido para guardar (con path). Los parmetros son el directorio predeterminado, la extensin del archivo y el ttulo del cuadro de dilogo.
	LOCAL directorio
	#DEFINE MYCURDIR SYS(5) + SYS(2003)
	STORE FULLPATH(MYCURDIR) TO directorio
	SET DEFA TO &dirpredet
	archivo = PUTFILE(titulo,'',extension)
	DO WHILE (NOT NOMBRE_ARCHIVO_CORRECTO(ALLTRIM(archivo))) 
		MESSAGEBOX("El nombre del archivo no puede contener espacios en blanco ni signos de puntuacin."+CHR(13)+"Puede sustituirlos por guiones bajos.",48,"MILLENNIUM CONSULTING")
		dirant = OBTIENE_PATH(archivo)
		SET DEFA TO &dirant
		archivo = PUTFILE(titulo,'',extension)
	ENDDO
	SET DEFA TO &directorio
	RETURN ALLTRIM(archivo)
ENDFUNC

*****************************************************************************
*                         FUNCIONES DE LISTA ESTRUCTURAS                    *
*                                                                           *
*****************************************************************************


PROCEDURE LISTAESTRUCTURAS()
	DO COMPARAESTRUCTURASDEDATOS WITH "C:\GESTIONBO", "C:\GESTION"
ENDPROC

PROCEDURE COMPARAESTRUCTURASDEDATOS(dir1,dir2)
	PUBLIC dirorigen,dirdestino
	LOCAL dr
	
	&&Inicializacin
	
	SET FULLPATH ON
	SET EXCLUSIVE ON
	SET SAFETY OFF
	CLOSE DATA ALL
	
	dirorigen = dir1
	dirdestino = dir2
	dr = FULLPATH(CURDIR())
	
	&& Crea la tabla de resultados

	IF FILE('C:\resultado.dbf') THEN
		DELETE FILE c:\resultado.dbf
	ENDIF

	CREATE TABLE C:\resultado.dbf (tipo C(20), tabla C(60), campo C(30))
	USE
	
	&& Hace la primera llamada recursiva	
	SET DEFA TO &dirorigen
	DO APLICATODASTABLAS WITH dir1,"R","DO APLICACOMPARAESTRUCTURA WITH"+CHR(34)+"tabla"+CHR(34)
	
	dirraiz = dirorigen+"\"
	XRESIZE = .F.
	XADAPTACOLORES = .F.
	DO IMPRIME_REPORTE IN CILIB001 WITH ('COMPARAESTRUCTURAS'), (''), ('CIRP0110')		
	RELEASE dirorigen,dirdestino
	SET EXCLUSIVE OFF
	SET SAFETY ON
	SET DEFA TO &dr
ENDPROC

PROCEDURE APLICACOMPARAESTRUCTURA(tla)
	LOCAL tla2, tlasinextension, diractual, diractual2, it,  tl, ncampos  
			
	tlasinextension = SUBSTR(tla, 1, LEN(tla)-4)
	tla2 = STRTRAN(FULLPATH(tla), dirorigen, dirdestino)
	
	diractual = FULLPATH(CURDIR())
	diractual2 = STRTRAN(diractual, dirorigen, dirdestino)
	
	IF NOT FILE(tla2) THEN
		USE C:\RESULTADO.DBF
		INSERT INTO C:\resultado.dbf VALUES ('TABLA NO EXISTE', tla2,'')
		USE
	ELSE
		
		USE (tla)
		ncampos = AFIELDS(campos)
		USE
		
		SET DEFA TO &diractual2
		
		FOR it = 1 TO ncampos
			IF NOT EXISTECAMPOESTRUCTURA (tlasinextension, campos(it,1)) THEN
				USE C:\RESULTADO.DBF
				INSERT INTO C:\resultado.dbf VALUES ('CAMPO NO EXISTE', tla2, campos(it,1))
				USE
			ENDIF
		ENDFOR

		SET DEFA TO &diractual
	ENDIF
	
ENDPROC


PROCEDURE MANEJAERR
	MESSAGEBOX(tabla)
	MESSAGEBOX(TYPE('nmes'))
	MESSAGEBOX(TYPE('anyo'))
	ON ERROR 
ENDPROC

PROCEDURE EXTRAEDOCUMENTACION
	LOCAL archivo, handle, dentroproc, registrar, handwrit
	archivo = GETFILE('PRG', 'Elija un PRG')
	handle = FOPEN(archivo,0)
	handwrit = FCREATE('C:\WINDOWS\ESCRITORIO\DOCU.TXT',0)
	IF handle = -1 OR handwrit = -1 THEN
		MESSAGEBOX("Error al abrir el archivo")
	ELSE
		pos = 1
		fidelinia = .F.
		dentroproc = .F.
		registrar = .F.
		DO WHILE NOT FEOF(handle)
			principiolinea = ALLTRIM(UPPER(STRTRAN(FREAD(handle, 40),CHR(9),CHR(32))))
			*IF SUBSTR(principiolinea,2,1) = "*" THEN
			*	MESSAGEBOX(STR(ASC(SUBSTR(principiolinea,1,1))))
			*ENDIF
			DO CASE
				
				CASE SUBSTR(principiolinea,1,8) == 'FUNCTION'  OR principiolinea == 'PROCEDURE' 
					posaux = pos
					*DO WHILE (NOT FEOF(handle)) AND (NOT (FREAD(handle,2) == CHR(13)+CHR(10)))
					*	FSEEK(handle,posaux)
					*	posaux = posaux+1
					*ENDDO
					*FSEEK(handle,posaux+1)
					registrar = .T. &&(ALLTRIM(STRTRAN(FREAD(handle,40),CHR(9),CHR(32))) = "*")
					dentroproc = .T.
					FSEEK(handle,pos)	
				CASE SUBSTR(principiolinea,1,7) == 'ENDPROC' OR SUBSTR(principiolinea,1,7) == 'ENDFUNC' 
					dentroproc = .F.
					registrar = .F.
				CASE SUBSTR(principiolinea,1,1) == "*" 
						IF dentroproc THEN
							* No hacer nada, seguir con la misma poltica de registrar
						ELSE
							registrar = .T.
						ENDIF
				OTHERWISE
						registrar = .F.
			ENDCASE
				
			
			DO WHILE (NOT FEOF(handle)) AND (NOT (FREAD(handle,2) == CHR(13)+CHR(10)))
				FSEEK(handle,pos)
				IF registrar THEN
					FWRITE(handwrit, FREAD(handle,1))
				ENDIF
				pos = pos+1
			ENDDO
			IF registrar THEN
				FWRITE(handwrit,CHR(13)+CHR(10))
			ENDIF
			pos = pos + 1 
		ENDDO
		FCLOSE(handle)
		FCLOSE(handwrit)	
	ENDIF
ENDPROC
			*	IF ALLTRIM(UPPER(SUBSTR(llegit,1,8))) = 'FUNCTION'  OR ALLTRIM(UPPER(llegit)) = 'PROCEDURE' THEN
		*		?EXTRAEHASTAFINALLINEAACTUAL(handle, pos)
		*	ENDIF

		*	FSEEK(handle,pos)
FUNCTION EXTRAEHASTAFINALLINEAACTUAL(hand, posact)
LOCAL posaux, lleg
	posaux = posact 
	
		FSEEK(hand,posaux)
		lleg = FREAD(hand,2)	
		IF ASC(SUBSTR(lleg,1,1)) = 13
			?lleg
		ENDIF
		posaux = posaux+1
	ENDDO
	FSEEK(hand,posact)
	RETURN FREAD(hand,posaux-posact-1)
ENDFUNC


*****************************************************************************
*                         FUNCIONES SOBRE TABLAS                            *
*                                                                           *
*****************************************************************************
PROCEDURE NORMALIZAR(st)
	* Normaliza una cadena que contiene una condicin como la que puede existir en un LOCATE FOR
	IF EMPTY(st) THEN
		RETURN ""
	ELSE
		RETURN ALLTRIM(UPPER(NORMALIZE(st)))
	ENDIF
ENDPROC

PROCEDURE ABRIR(nomtabla)
	IF NOT USED(nomtabla) THEN
		USE &nomtabla IN 0 ALIAS &nomtabla
	ENDIF
	SELECT &nomtabla
ENDPROC

PROCEDURE ABRIREXCLUSIVO(nomtabla)
	IF USED(nomtabla) THEN
		SELECT &nomtabla
		USE
	ENDIF
	USE &nomtabla IN 0 ALIAS &nomtabla EXCLUSIVE
	SELECT &nomtabla
ENDPROC


PROCEDURE GUARDAESTADO(tabla, prefijo)
	&&Si no tiene argumentos, guarda el estado de la tabla actual.
	&&Si tiene un argumento, guarda el estado de la tabla que se especifica
	&&Si tiene dos argumentos, guarda el estado de la tabla que se especifica en el prefijo que se especifica
	
	LOCAL tlxw, comando, tls, par
	
	par = PCOUNT()

	DO CASE
		CASE par = 0 
			prefijo = 'tpxw'
		CASE par = 1
			prefijo = 'tpxz'+ ALLTRIM(tabla)
			tls = ALIAS()
			SELE (tabla)
		CASE par = 2
			prefijo = prefijo+ALLTRIM(tabla)
			tls = ALIAS()
			SELE (tabla)
	ENDCASE

	
	comando = "PUBLIC "+prefijo+"_taula"
	&comando
	comando = prefijo+"_taula = ALIAS()"
	&comando
	comando = "tlxw = NOT EMPTY("+prefijo+"_taula)"
	&comando
	IF tlxw THEN
		comando = "PUBLIC "+prefijo+"_filtre"
		&comando
		comando = prefijo+"_filtre = FILTER()"
		&comando
		comando = "PUBLIC "+prefijo+"_orden"
		&comando
		comando = prefijo+"_orden = ORDER()"
		&comando
		comando = "PUBLIC "+prefijo+"_eof"
		&comando
		comando = prefijo+"_eof = EOF()"
		&comando
		comando = "PUBLIC "+prefijo+"_registro"
		&comando
		comando = prefijo+"_registro = RECNO()"
		&comando
	ENDIF
	
	IF PCOUNT() >=1 THEN
		SELE (tls)
	ENDIF
ENDPROC

PROCEDURE RECUPERAESTADO(tabla, prefijo, seleccionar)
	&&Si no tiene argumentos, recupera el estado guardado Y CONVIERTE LA TABLA EN TABLA ACTUAL.
	&&Si tiene un argumento, recupera el estado de la tabla que se especifica
	&&Si tiene dos argumentos, recupera el estado de la tabla que se especifica en el prefijo que se especifica

	LOCAL tlxw, tlxw2, tlxw3, tlxw4, comando, tls
		
	
	par = PCOUNT()
	DO CASE
		CASE par = 0 
			prefijo = 'tpxw'
		CASE par = 1
			prefijo = 'tpxz'+ ALLTRIM(tabla)
			tls = ALIAS()
			SELE (tabla)
		CASE par = 2
			prefijo = prefijo+ALLTRIM(tabla)
			tls = ALIAS()
			SELE (tabla)
	ENDCASE
	
	comando = "tlxw = NOT EMPTY("+prefijo+"_taula)"
	&comando
	IF tlxw THEN
		tlxw4 = prefijo+"_taula"
		comando = "SELECT "+ &tlxw4
		&comando
		comando = "tlxw = NOT (NORMALIZAR("+prefijo+"_filtre) == NORMALIZAR(FILTER()) )" 
		&comando
		IF tlxw THEN
			tlxw = prefijo+"_filtre"
			tlxw2 = &tlxw
			IF EMPTY(&tlxw) THEN
				SET FILTER TO
			ELSE
				
				SET FILTER TO &tlxw2
			ENDIF
		ENDIF
		
		comando = "tlxw = NOT (NORMALIZAR("+prefijo+"_orden) == NORMALIZAR(ORDER()) )" 
		&comando
		IF tlxw THEN
			tlxw = prefijo+"_orden"
			tlxw2 = &tlxw
			IF EMPTY(&tlxw) THEN
				SET ORDER TO
			ELSE
				SET ORDER TO &tlxw2
			ENDIF
		ENDIF
		
		tlxw = prefijo+"_eof"
		IF &tlxw <> EOF() AND &tlxw THEN
			GO BOTTOM
			IF NOT EOF() THEN
				SKIP
			ENDIF
		ENDIF
		tlxw3 = prefijo+"_registro"
		
		IF &tlxw3 <> RECNO() AND NOT &tlxw THEN
			GO &tlxw3
		ENDIF	
		
		comando = "RELEASE "+prefijo+"_filtre"
		&comando
		comando = "RELEASE "+prefijo+"_orden"
		&comando
		comando = "RELEASE "+prefijo+"_eof"
		&comando
		comando = "RELEASE "+prefijo+"_registro"
		&comando
	ENDIF
	
	comando = "RELEASE "+prefijo+"_taula"
	&comando
	
	IF PCOUNT() >=1 THEN
		SELE (tls)
	ENDIF
ENDPROC


PROCEDURE GUARDAESTADOPREFIJO(prefijo)
	*Guarda el estado completo de la tabla actual en un prefijo
	
	LOCAL tlxw, comando, tls, par
	
	IF PCOUNT() = 0 THEN
		prefijo = 'tpcxw'
	ENDIF

	comando = "PUBLIC "+prefijo+"_taula"
	&comando
	comando = prefijo+"_taula = ALIAS()"
	&comando
	comando = "tlxw = NOT EMPTY("+prefijo+"_taula)"
	&comando
	IF tlxw THEN
		comando = "PUBLIC "+prefijo+"_filtre"
		&comando
		comando = prefijo+"_filtre = FILTER()"
		&comando
		comando = "PUBLIC "+prefijo+"_orden"
		&comando
		comando = prefijo+"_orden = ORDER()"
		&comando
		comando = "PUBLIC "+prefijo+"_eof"
		&comando
		comando = prefijo+"_eof = EOF()"
		&comando
		comando = "PUBLIC "+prefijo+"_registro"
		&comando
		comando = prefijo+"_registro = RECNO()"
		&comando
	ENDIF
	
ENDPROC

PROCEDURE RECUPERAESTADOPREFIJO(prefijo)
	*Recupera el estado almacenado en prefijo

	LOCAL tlxw, tlxw2, tlxw3, tlxw4, comando, tls
		
	IF PCOUNT() = 0 THEN
		prefijo = 'tpcxw'
	ENDIF
	
	comando = "tlxw = NOT EMPTY("+prefijo+"_taula)"
	&comando
	IF tlxw THEN
		tlxw4 = prefijo+"_taula"
		comando = "SELECT "+ &tlxw4
		&comando
		comando = "tlxw = NOT (NORMALIZAR("+prefijo+"_filtre) == NORMALIZAR(FILTER()) )" 
		&comando
		IF tlxw THEN
			tlxw = prefijo+"_filtre"
			tlxw2 = &tlxw
			IF EMPTY(&tlxw) THEN
				SET FILTER TO
			ELSE
				
				SET FILTER TO &tlxw2
			ENDIF
		ENDIF
		
		comando = "tlxw = NOT (NORMALIZAR("+prefijo+"_orden) == NORMALIZAR(ORDER()) )" 
		&comando
		IF tlxw THEN
			tlxw = prefijo+"_orden"
			tlxw2 = &tlxw
			IF EMPTY(&tlxw) THEN
				SET ORDER TO
			ELSE
				SET ORDER TO &tlxw2
			ENDIF
		ENDIF
		
		tlxw = prefijo+"_eof"
		IF &tlxw <> EOF() AND &tlxw THEN
			GO BOTTOM
			IF NOT EOF() THEN
				SKIP
			ENDIF
		ENDIF
		tlxw3 = prefijo+"_registro"
		
		IF &tlxw3 <> RECNO() AND NOT &tlxw THEN
			GO &tlxw3
		ENDIF	
		
		comando = "RELEASE "+prefijo+"_filtre"
		&comando
		comando = "RELEASE "+prefijo+"_orden"
		&comando
		comando = "RELEASE "+prefijo+"_eof"
		&comando
		comando = "RELEASE "+prefijo+"_registro"
		&comando
	ENDIF
	comando = "RELEASE "+prefijo+"_taula"
	&comando
	
ENDPROC


PROCEDURE ABRIRSEGURO(tabla)
	LOCAL comando, prefijo
	prefijo =  "tpxw_"+ALLTRIM(tabla)
	
	PUBLIC (prefijo+"tl")
	comando = prefijo + 'tl = ALIAS()'
	&comando
	
	PUBLIC (prefijo+"sabri")
	
	IF NOT USED(tabla) THEN
		USE &tabla IN 0 ALIAS &tabla
		SELE &tabla
		comando = prefijo +"sabri = .T."
		&comando
	ELSE
		SELE &tabla
		comando = prefijo +"sabri = .F."
		&comando
		PUBLIC (prefijo+"flt")
		comando = prefijo+"flt = FILTER()"
		&comando
		PUBLIC (prefijo+"od")
		comando = prefijo+"od = ORDER()"
		&comando
		PUBLIC (prefijo+"eseof")
		comando = prefijo+"eseof = EOF()"
		&comando
		PUBLIC (prefijo+"nreg")
		comando = prefijo+"nreg = RECNO()"
		&comando
	ENDIF
ENDPROC

PROCEDURE CERRARSEGURO(tabla)
	LOCAL comandop, comando,comando2,comando3,comando4, prefijo
	prefijo =  "tpxw_"+ALLTRIM(tabla)
	comandop = prefijo+"sabri"
	
	IF &comandop THEN
		SELE &tabla
		USE
	ELSE
		SELE &tabla
		comando = prefijo+"flt"
		comando2 = &comando
		IF NORMALIZAR(comando2) <> NORMALIZAR(FILTER()) THEN
			IF EMPTY(comando2) THEN
				SET FILTER TO
			ELSE
				SET FILTER TO &comando2
			ENDIF
		ENDIF
		RELEASE &comando
		
		comando = prefijo+"od"
		comando2 = &comando
		
		IF NORMALIZAR(comando) <> NORMALIZAR(ORDER()) THEN
			IF EMPTY(comando2) THEN
				SET ORDER TO
			ELSE
				SET ORDER TO &comando2
			ENDIF
		ENDIF
		RELEASE &comando
		
		comando = prefijo+"eseof"
		comando2 = &comando
		IF comando2 <> EOF() AND comando2 THEN
			GO BOTTOM
			IF NOT EOF() THEN
				SKIP
			ENDIF
		ENDIF
		
		
		comando3 = prefijo+"nreg"
		comando4 = &comando3

		
		IF (comando4 <> RECNO()) AND (NOT comando2) THEN
			GO comando4
		ENDIF	
		RELEASE &comando
		RELEASE &comando3
		
	ENDIF
	
	comando = prefijo+"tl"
	comando2 = &comando
	IF NOT EMPTY(comando2) THEN
		SELE &comando2
	ENDIF
	RELEASE &comando
	RELEASE &comandop
ENDPROC

PROCEDURE CERRAR(nomtabla)
	IF NOT (ALLTRIM(UPPER(ALIAS())) == ALLTRIM(UPPER(nomtabla))) THEN
		SELECT &nomtabla
	ENDIF
	USE
ENDPROC


PROCEDURE APLICABORRATABLAS(tabla)
	
	tabla = ALLTRIM(tabla)
	
	IF (NOT (UPPER(SUBSTR(tabla,3,2))== "GN"))  AND (NOT (ALLTRIM(SYS(2003))=="\GESTION\CONFIG" ))THEN
		USE (tabla)
		ZAP
		USE
	ENDIF
ENDPROC
PROCEDURE BORRATABLAS(directorio)
	SET EXCLUSIVE ON
	SET SAFETY OFF
	DO APLICATODASTABLAS WITH directorio,"R","DO APLICABORRATABLAS WITH"+CHR(34)+"tabla"+CHR(34)
	SET EXCLUSIVE OFF
	SET SAFETY ON
ENDPROC

FUNCTION CREATABLALIBREMISMAESTRUCTURAQUEACTUAL(pathnuevo)
	LOCAl numcampos, i
	numcampos = AFIELDS(ltxcampos)
	FOR i = 1 TO numcampos
		ltxcampos(i,12) = ""
	ENDFOR
	CREATE TABLE (pathnuevo) FREE FROM ARRAY ltxcampos
ENDFUNC


PROCEDURE CREATABLASUMAGRUPOS(nomtorigen,nomtdestino, camposasumar, stwhere, stgroupby, storderby, cerrartabla)
	* A partir de la tabla "nomtorigen" crea una tabla "nomtdestino" que contiene 
	* para cada grupo de la tabla original agrupado segn "stgroupby", un registro con 
	* la suma de sus campos. De hecho slo se suman los campos incluidos en "Campos a sumar"
	* los restantes se dejan como estn. Los registros se filtran segn el parmetro
	* 'stwhere' y se ordena segn el parmetro "storder by". Todos los parmetros son strings y
	* siguen la sintaxis del SELECT-SQL. La tabla resultado tiene los mismos nombres de campos
	* que la original. POr defecto se cierra la tabla.

	PUBLIC stselect
	LOCAL ncampos, stselect, taula, usada
	&& Se guarda el estado de la tabla

	aliasorigen = JUSTSTEM(nomtorigen)
	
	IF PCOUNT() < 7 THEN
		cerrartabla = .T.
	ENDIF
	
	
	taula = ALIAS()
	usada = .T.
	
	IF NOT USED(aliasorigen) THEN
		usada = .F.
		USE (nomtorigen) IN 0 ALIAS (aliasorigen)
	ENDIF
	
	&& Se construye la sentencia SELECT
	camposasumar = ","+STRTRAN(UPPER(camposasumar),' ','')+","
	SELE (aliasorigen)
	ncampos = AFIELDS(campos) 
	stselect = ""
	FOR i = 1 TO ncampos
		IF AT(","+campos(i,1)+",",camposasumar) = 0 THEN
			stselect = stselect + campos(i,1)+","
		ELSE
			stselect = stselect + ' SUM('+campos(i,1)+') AS '+ campos(i,1)+","
		ENDIF
	ENDFOR
	IF NOT EMPTY(stselect) THEN
		stselect = LEFT(stselect,LEN(stselect)-1)
	ENDIF
	
	stselect = 'SELECT '+stselect+' FROM '+aliasorigen +' INTO TABLE '+nomtdestino
	IF NOT EMPTY(stwhere) THEN
		stselect = stselect+' WHERE '+stwhere
	ENDIF
	
	IF NOT EMPTY(stgroupby) THEN
		stselect = stselect+' GROUP BY '+stgroupby
	ENDIF

	IF NOT EMPTY(storderby) THEN
		stselect = stselect+' ORDER BY '+storderby
	ENDIF
	
	&& Se ejecuta la sentencia SELECT 
	&stselect
	
	&& Se cierra la tabla y se recupera el estado de la tabla, si as se ha determinado
	IF cerrartabla THEN
		SELE TEMPORAL
		USE
		
		IF NOT usada THEN
			SELE (aliasorigen)
			USE
		ENDIF
		IF NOT EMPTY(taula) THEN
			SELECT (taula)
		ENDIF
	ENDIF
	
ENDPROC

FUNCTION GUARDANUMEROREGISTRO()
	RETURN IIF( EOF(), 0, RecNo() )
ENDFUNC

PROCEDURE RECUPERANUMEROREGISTRO(nRegistroNo)
	DO CASE
		CASE RECCOUNT() = 0
  			* No hace nada
		CASE  nRegistroNo = 0
			IF NOT EOF() THEN
  				GO BOTTOM
  				SKIP
  			ENDIF
		OTHERWISE
  			GO (nRegistroNo)
	ENDCASE
ENDPROC




*****************************************************************************
*                        PROCEDIMIENTOS RECURSIVOS                          *
*                                                                           *
*****************************************************************************

PROCEDURE RECURSIVODIRECTORIOS (dirraiz, comando)
	&& Este programa va recursivamente por todo el arbol de directorios
	&& y realiza una accin en todas las tablas que encuentra
	LOCAL ARRAY arraydir[1000]
	LOCAL numdir, xx

	* Selecciona los directorios
	SET DEFA TO &dirraiz
	numdir=ADIR(arraydir, "*.*", "D")
 
	* Realiza bucle a travs del array
	 DO &comando
	 FOR xx = 1 TO ALEN(arraydir,1)
 		* Saltarse los directorios "." y ".." 

		IF (SUBSTR(arraydir[xx,5],5,1) = "D") AND !("." $ arraydir[xx,1]) THEN
     		    
     		* Llamada recursiva
       		DO RECURSIVODIRECTORIOS with dirraiz+"\"+arraydir[xx,1], comando
     		
   		ENDIF
 	ENDFOR
ENDPROC

PROCEDURE APLICATODASTABLAS(directorioa, tcRecur, Comando)
	camino = FULLPATH(CURDIR())
	SET DEFA TO &directorioa
	DO APLICATODASAUX WITH tcRecur, Comando
	SET DEFAULT TO &camino
ENDPROC

PROCEDURE APLICATODASAUX (tcRecur, Comando)
	&& Este programa va recursivamente por todo el arbol de directorios
	&& y realiza una accin en todas las tablas que encuentra
	IF PCOUNT() < 2
 		MESSAGEBOX("Error. Todos los parmetros deben ser pasados")
	ELSE  
		LOCAL ARRAY tarray[1000], frxarray[1]
		LOCAL lncount

		* Cuntos archivos en este directorio?
		lncount=ADIR(tarray, "*.*", "D")
 
		* Realiza bucle a travs del array
		LOCAL xx
		IF UPPER(tcRecur) = "R"
			 AplicaTablas(Comando)
			 FOR xx = 1 TO ALEN(tarray,1)

	 			* Saltarse los directorios "." y ".." 
				
   				IF (SUBSTR(tarray[xx,5],5,1) = "D") AND !("." $ tarray[xx,1]) THEN
     				CD (tarray[xx,1])
     
     				*AplicaTablas(Comando)
     
     				* llamada recursiva
     
     				DO APLICATODASAUX with tcRecur, Comando
     				CD ..
   				ENDIF
 			ENDFOR
		ELSE
 
 		* slo un directorio de inters
 		AplicaTablas(Comando)
		ENDIF  
	ENDIF
ENDPROC
PROCEDURE AplicaTablas (Comando)

	LOCAL lnnumfound, yy
	LOCAL ARRAY frxarray[1]

	* Asegurndose que tenemos dbf en el directorio

	lnnumfound = ADIR(frxarray, "*dbf")
	IF (lnnumfound > 0)
 		FOR yy = 1 TO ALEN(frxarray,1)
			*PUBLIC tabla
			tabla = frxarray[yy,1]
	   		ComandoPart = STRTRAN(Comando,'tabla',tabla)
    		&ComandoPart
    		*RELEASE tabla  
 		ENDFOR
	ENDIF
	RELEASE ARRAY frxarray

	RETURN
ENDPROC


*****************************************************************************
*                 FUNCIONES SOBRE ESTRUCTURA DE TABLAS                      *
*                                                                           *
*****************************************************************************
PROCEDURE AGREGACAMPOTABLA(tabla, campota, tipo, ancho, decimales)
	&&El ancho y los decimales se ignoran si es un tipo de campo que no los necesita
	LOCAL ancho, decimales,decm
	DO CASE 
		CASE tipo = 'D' OR tipo = 'T' OR tipo = 'I' OR tipo = 'L' OR tipo = 'M' OR tipo ='G'
			ALTERATABLA(tabla,'ADD COLUMN '+UPPER(campota)+ ' '+ tipo)
		CASE tipo = 'C' OR tipo = 'B' 
			ALTERATABLA(tabla,'ADD COLUMN '+UPPER(campota)+ ' '+ tipo+'('+STR(ancho)+')')
		CASE tipo = 'N' OR tipo = 'F'
			ALTERATABLA(tabla,'ADD COLUMN '+UPPER(campota)+ ' '+ tipo+'('+STR(ancho)+','+STR(decimales)+')')
	ENDCASE
ENDPROC

PROCEDURE ELIMINACAMPOTABLA(tabla, campota)
	ALTERATABLA(tabla, 'DROP COLUMN '+UPPER(campota))
ENDPROC

PROCEDURE ALTERATIPOCAMPOTABLA(tabla, campota, tipo, ancho, decimales)
	&&El ancho y los decimales se ignoran si es un tipo de campo que no los necesita
	LOCAL ancho, decimales,decm
	DO CASE 
		CASE tipo = 'D' OR tipo = 'T' OR tipo = 'I' OR tipo = 'L' OR tipo = 'M' OR tipo ='G'
			ALTERATABLA(tabla,'ALTER COLUMN '+UPPER(campota)+ ' '+ tipo)
		CASE tipo = 'C' OR tipo = 'B' 
			ALTERATABLA(tabla,'ALTER COLUMN '+UPPER(campota)+ ' '+ tipo+'('+STR(ancho)+')')
		CASE tipo = 'N' OR tipo = 'F'
			ALTERATABLA(tabla,'ALTER COLUMN '+UPPER(campota)+ ' '+ tipo+'('+STR(ancho)+','+STR(decimales)+')')
	ENDCASE
ENDPROC

PROCEDURE ALTERAANCHOCAMPOTABLA(tabla,campota,nuevoancho)
	LOCAL ancho, decm, tipo
	tipo = TIPOCAMPO(tabla,campota)
	DO CASE	
		CASE tipo = 'D' OR tipo = 'T' OR tipo = 'I' OR tipo = 'L' OR tipo = 'M' OR tipo ='G'
			&& No hace nada, pues el ancho no puede cambiarse por ser el tipo de ancho fijo
		CASE tipo = 'C' OR tipo = 'B' 
			ancho = ANCHOCAMPO(tabla,campota)
			ALTERATABLA(tabla,'ALTER COLUMN '+UPPER(campota)+ ' '+tipo+'('+ALLTRIM(STR(nuevoancho))+')')
		CASE tipo = 'N' OR tipo = 'F'
			ancho = ANCHOCAMPO(tabla,campota)
			decm = DECIMALESCAMPO (tabla,campota)
			ALTERATABLA(tabla,'ALTER COLUMN '+UPPER(campota)+ ' '+tipo+'('+ALLTRIM(STR(nuevoancho))+','+ALLTRIM(STR(decm))+')')
	ENDCASE
ENDPROC

PROCEDURE ALTERADECIMALESCAMPOTABLA(tabla,campota,decm)
	LOCAL ancho, decimales,decm
	ancho = ANCHOCAMPO(tabla,campota)
	decimales = DECIMALESCAMPO (tabla,campota)
	ALTERATABLA(tabla,'ALTER COLUMN '+UPPER(campota)+ ' N('+ALLTRIM(STR(ancho+decm-decimales))+','+ALLTRIM(STR(decm))+')')
ENDPROC

PROCEDURE FIJADECIMALESCAMPOTABLA(tabla,campota,decm)
	LOCAL ancho, decimales,decm
	ancho = ANCHOCAMPO(tabla,campota)
	ALTERATABLA(tabla,'ALTER COLUMN '+UPPER(campota)+ ' N('+ALLTRIM(STR(ancho))+','+ALLTRIM(STR(decm))+')')
ENDPROC

PROCEDURE FIJADECIMALESYENTEROSCAMPOTABLA(tabla,campota,ent,decm)
	LOCAL elanchopunto
	elanchopunto = IIF(dec = 0,0,1)
	IF ent+anchopunto+decm > 20 THEN
		MESSAGEBOX("El nmero mximo de dgitos en un campo es de 20. No se pudo realizar el cambio de dgitos.")
	ELSE
		ALTERATABLA(tabla,'ALTER COLUMN '+UPPER(campota)+ ' N('+ALLTRIM(STR(ent+anchopunto+decm))+','+ALLTRIM(STR(decm))+')')
	ENDIF
ENDPROC

PROCEDURE FIJADECIMALESYENTEROSCAMPOSIDIFERENTES(tabla,campota,ent,decm)
	IF ENTEROSCAMPO(tabla, campota)<> ent OR DECIMALESCAMPO(tabla, campota)<> decm THEN
		FIJADECIMALESYENTEROSCAMPOTABLA(tabla,campota,ent,decm)
	ENDIF
ENDPROC

PROCEDURE ALTERATABLA (taula, expre)
	LOCAL comandot, taula, expre
	comandot = "ALTER TABLE "+taula+" "+expre
	&comandot
	SELE &taula
	USE
ENDPROC

FUNCTION EXISTENOMBREINDICE(nombretag)
	LOCAL ntag
	i = 1
	ntag = TAG(i)
	DO WHILE NOT EMPTY(ntag) AND NOT(UPPER(ALLTRIM(ntag)) == UPPER(ALLTRIM(nombretag)))
		i = i+1
		ntag = TAG(i)
	ENDDO
	RETURN (NOT (EMPTY(ntag)))
ENDFUNC

FUNCTION EXPRESIONINDICE(nombretag)
	LOCAL ntag
	i = 1
	ntag = TAG(i)
	DO WHILE NOT EMPTY(ntag) AND NOT(UPPER(ALLTRIM(ntag)) == UPPER(ALLTRIM(nombretag)))
		i = i+1
		ntag = TAG(i)
	ENDDO
	IF EMPTY(ntag) THEN
		RETURN .NULL.
	ELSE
		RETURN KEY(i)
	ENDIF
ENDFUNC


FUNCTION EXISTECAMPOESTRUCTURA (taula, campo)
	&& Retorna un valor lgico que indica si si existe el campo en la estructura de una tabla.
	LOCAL comandot, aliastaula, campo, nc, i, usado, tablaanterior
	tablaanterior = ALIAS()
	aliastaula = JUSTSTEM(taula)
	usado = USED(aliastaula)
	IF NOT usado THEN
		USE (taula) IN 0 ALIAS (aliastaula)
	ENDIF
	SELE (aliastaula)
	nc = AFIELDS(matriu)
	IF NOT usado THEN
		USE
	ENDIF
	i = ACAMPO(@matriu,campo)
	IF NOT EMPTY(tablaanterior) THEN
		SELE (tablaanterior)
	ENDIF
	RETURN (i<>0)
ENDFUNC

FUNCTION TIPOCAMPO (taula, campo)
	&& Retorna el tipo de un campo en una tabla
	&& Si el campo no existe, retorna NULL
	
	PRIVATE comandot, taula, campo, matriu, nc, i
	USE &taula IN 0 ALIAS &taula
	SELE &taula
	nc = AFIELDS(matriu)
	USE
	i = ACAMPO(@matriu,campo)
	IF i = 0  THEN
		RETURN NULL
	ELSE
		RETURN matriu(i,2)
	ENDIF	
ENDFUNC

FUNCTION ANCHOCAMPO (taula, campo)
	&& Retorna el ancho de un campo en una tabla
	&& Si el campo no existe, retorna NULL
	
	PRIVATE comandot, taula, campo, matriu, nc, i
	USE &taula IN 0 ALIAS &taula
	SELE &taula
	nc = AFIELDS(matriu)
	USE
	i = ACAMPO(@matriu,campo)
	IF i = 0  THEN
		RETURN NULL
	ELSE
		RETURN matriu(i,3)
	ENDIF	
ENDFUNC

FUNCTION ENTEROSCAMPO(taula, campo)
	LOCAL elanchopunto, dec, anch
	dec = DECIMALESCAMPO(taula,campo)
	elanchopunto = IIF(dec = 0,0,1)
	anch = ANCHOCAMPO(taula,campo)
	RETURN (anch - dec - elanchopunto)
ENDFUNC

FUNCTION DECIMALESCAMPO (taula, campo)
	&& Retorna los decimales de un campo en una tabla
	&& Si el campo no existe, retorna NULL
	
	PRIVATE comandot, taula, campo, matriu, nc, i
	USE &taula IN 0 ALIAS &taula
	SELE &taula
	nc = AFIELDS(matriu)
	USE
	i = ACAMPO(@matriu,campo)
	IF i = 0  THEN
		RETURN NULL
	ELSE
		RETURN matriu(i,4)
	ENDIF	
ENDFUNC

FUNCTION ACAMPO (mat,camp)
	&& Busca un campo en una matriz de campos obtenida con AFIELD
	&& Retorna 0 si no lo encuentra y el nmero de posicin del campo en la matriz si lo encuentra
	
	PRIVATE camp,it,nct, mat
	it = 1
	nct = ALEN(mat,1)
	DO WHILE it<=nct AND NOT (UPPER(mat(it,1)) == UPPER(ALLTRIM(camp))) 
		it = it+1
	ENDDO 
	IF it > nct THEN
		RETURN 0
	ELSE
		RETURN it
	ENDIF
ENDFUNC

*****************************************************************************
*                         CONTROL DE ERRORES                                *
*                                                                           *
*****************************************************************************


PROCEDURE OK (cntrol)
	IF M.ERRORC = cntrol.Name THEN
		M.ERRORM = "Ok"
		M.ERRORC = "Ok"
	ENDIF
ENDPROC

PROCEDURE MERROR (cntrol, st)
	M.ERRORM = st
	M.ERRORC = cntrol.Name
ENDPROC

PROCEDURE MENSAJE_ERROR(formul)
	LOCAL temp
	MESSAGEBOX(M.ERRORM, 48, "MILLENNIUM CONSULTING")
	temp = "formul." + M.ERRORC +".SetFocus()"
	&temp
ENDPROC

PROCEDURE MSERROR(meserr)
	* Rutina para indicar un mensaje de error en un control. Se coloca en el evento LostFocus
	IF M.DENTRODEESVALIDO THEN
		M.ERROR = meserr
	ENDIF
ENDPROC

PROCEDURE CONFIRMACION(mesconf)
	* Rutina para indicar un mensaje de confirmacin en un control. Se coloca en el evento LostFocus
	IF M.DENTRODEESVALIDO THEN
		IF TYPE('M.ERROR') <> 'C' THEN
			M.ERROR = ''
		ELSE
			IF M.ERROR == 'Ok' THEN
				M.ERROR = ''
			ENDIF
		ENDIF
		M.ERROR = M.ERROR+'#?'+mesconf
	ENDIF
ENDPROC

FUNCTION DENTRODEESVALIDO()
	* Indica si estamos dentro del proceso de validacin de errores. Se coloca en el evento LostFocus
	RETURN M.DENTRODEESVALIDO
ENDFUNC

FUNCTION ENCONTRARSIGUIENTECONF (mesconf)
	LOCAL pos
	pos = (AT('#?',mesconf))
	IF pos = 0 THEN
		RETURN LEN(mesconf)
	ELSE
		RETURN pos-1
	ENDIF
ENDFUNC



FUNCTION NUEVOESVALIDO(formul)
	LOCAL resultadoesvalido, merror, objetoerroneo 
	M.DENTRODEESVALIDO = .T.
	
	M.ERROR = "Ok"
	merror = ESVALIDOMSERRORES(formul,@objetoerroneo)
	IF merror <> "Ok" THEN
		MESSAGEBOX(merror, 48, "MILLENNIUM CONSULTING")
		objetoerroneo.SetFocus
		resultadoesvalido = .F.
	ELSE
		M.ERROR = "Ok"
		resultadoesvalido = .T.
		merror = ESVALIDOCONFIRMACIONES(formul,@objetoerroneo)
		IF merror <> "Ok" THEN
			objetoerroneo.SetFocus
			resultadoesvalido = .F.
		ELSE
			resultadoesvalido = .T.
		ENDIF
	ENDIF

	M.DENTRODEESVALIDO = .F.
		
	RETURN resultadoesvalido

ENDFUNC



FUNCTION NUEVOESVALIDOMSERRORES(formul, objetoerror)
	LOCAL indicecontrolesvalido, cuenta, coleccionok, mensaerror, objetoerrorcol 
	
	* Por defecto todo esta bien 

	mensaerror = "Ok"
	
	* Primero mira la coleccion si el control es contenedor	
	cuenta  = CARDINALCOLECCION(formul)
	IF cuenta = -10 THEN
		coleccionok = .T. &&No es un contenedor, no tiene coleccin y, por tanto, la coleccin est bien
	ELSE
		indicecontrolesvalido = 1
		DO WHILE indicecontrolesvalido <= cuenta AND ALLTRIM(UPPER(mensaerror)) == "OK"
			mensaerror = ESVALIDOMSERRORES(ITEMCOLECCION(formul,indicecontrolesvalido),@objetoerror)
			indicecontrolesvalido = indicecontrolesvalido + 1
		ENDDO

		IF indicecontrolesvalido > cuenta THEN
			coleccionok = .T.
		ELSE
			coleccionok = .F.
			**mensaerror = mensaerror &&Superfluo
		ENDIF
	ENDIF
		
	* Si la coleccin est bien, mira si da error el control con su evento LostFocus.
	
	IF coleccionok AND PEMSTATUS(formul,'LostFocus',5) AND formul.Visible THEN
		formul.LostFocus	
		IF VARTYPE(M.ERROR) = 'C' THEN
			IF NOT (SUBSTR(ALLTRIM(M.ERROR),1,2) == '??') AND NOT (SUBSTR(ALLTRIM(M.ERROR),1,2) == '#?') AND NOT (ALLTRIM(M.ERROR) =="Ok") THEN
				objetoerror = formul
				mensaerror = M.ERROR
				M.ERROR = "Ok" 	&&Como la variable es pblica, podra confundir en las siguientes llamadas recursivas si no la ponemos a Ok
			ENDIF		
		ENDIF
	ENDIF
	
	RETURN mensaerror
ENDFUNC


FUNCTION NUEVOESVALIDOCONFIRMACIONES(formul, objetoerror)
	LOCAL indicecontrolesvalido, cuenta, coleccionok, mensaerror, objetoerrorcol, confirmaci, il 
	
	* Por defecto todo esta bien 

	mensaerror = "Ok"
	
	* Primero mira la coleccion si el control es contenedor	
	cuenta  = CARDINALCOLECCION(formul)
	IF cuenta = -10 THEN
		coleccionok = .T. &&No es un contenedor, no tiene coleccin y, por tanto, la coleccin est bien
	ELSE
		indicecontrolesvalido = 1
		DO WHILE indicecontrolesvalido <= cuenta AND ALLTRIM(UPPER(mensaerror)) == "OK"
			mensaerror = ESVALIDOCONFIRMACIONES(ITEMCOLECCION(formul,indicecontrolesvalido),@objetoerror)
			indicecontrolesvalido = indicecontrolesvalido + 1
		ENDDO

		IF indicecontrolesvalido > cuenta THEN
			coleccionok = .T.
		ELSE
			coleccionok = .F.
			**mensaerror = mensaerror &&Superfluo
		ENDIF
	ENDIF
		
	* Si la coleccin est bien, mira si da confirmacin el control con su evento LostFocus.
	
	IF coleccionok AND PEMSTATUS(formul,'LostFocus',5) AND formul.Visible THEN
		formul.LostFocus
		IF VARTYPE(M.ERROR) = 'C' THEN
			IF SUBSTR(ALLTRIM(M.ERROR),1,2) == '??' THEN
				confirmaci = MESSAGEBOX(SUBSTR(ALLTRIM(M.ERROR),3), 52, "MILLENNIUM CONSULTING")
				IF confirmaci = 6
					M.ERROR = "Ok"	
				ENDIF
			ELSE
				IF SUBSTR(ALLTRIM(M.ERROR),1,2) == '#?' THEN	
					M.ERROR = ALLTRIM(M.ERROR)
					confirmaci = 6
					DO WHILE NOT EMPTY(M.ERROR) AND confirmaci = 6	
						M.ERROR = ALLTRIM(SUBSTR(M.ERROR,3))
						il = ENCONTRARSIGUIENTECONF(M.ERROR)
						confirmaci = MESSAGEBOX(SUBSTR(M.ERROR,1,il), 52, "MILLENNIUM CONSULTING")
						M.ERROR = ALLTRIM(SUBSTR(M.ERROR,il+1))
					ENDDO
					IF confirmaci = 6 THEN
						M.ERROR = "Ok"
					ENDIF
				ELSE
					M.ERROR = "Ok"	
				ENDIF
			ENDIF		
					
			IF NOT (ALLTRIM(M.ERROR) =="Ok") THEN
				objetoerror = formul
				mensaerror = M.ERROR
				M.ERROR = "Ok" 	&&Como la variable es pblica, podra confundir en las siguientes llamadas recursivas si no la ponemos a Ok
			ENDIF				
		ENDIF
	ENDIF
	RETURN mensaerror
ENDFUNC

FUNCTION ESVALIDO(formul)
	* Aplica el proceso de validacin de errores a un formulario. Si el formulario no contiene errores, devuelve cierto. En caso contrario, devuelve falso despus de haber nmostrado mensajes de error. El uso tpico es en el evento Click del cmdAdd de un formulario, de la forma "IF ESVALIDO(THISFORM) THEN ..".
	PUBLIC indicecontrolesvalido
	LOCAL resultadoesvalido
	M.DENTRODEESVALIDO = .T.
			
	IF NOT ESVALIDOMSERRORES(formul) THEN
		MESSAGEBOX(M.ERROR, 48, "MILLENNIUM CONSULTING")
		formul.Controls(indicecontrolesvalido-1).SetFocus
		resultadoesvalido = .F.
	ELSE
		IF NOT ESVALIDOCONFIRMACIONES(formul) THEN
			formul.Controls(indicecontrolesvalido-1).SetFocus 
			resultadoesvalido = .F.
		ELSE
			resultadoesvalido = .T.
		ENDIF
	ENDIF

	M.DENTRODEESVALIDO = .F.
	RELEASE indicecontrolesvalido
	RETURN resultadoesvalido
ENDFUNC

FUNCTION ESVALIDOMSERRORES(formul)
	indicecontrolesvalido = 1
	M.ERROR = "Ok"
	DO WHILE indicecontrolesvalido<=formul.ControlCount AND ALLTRIM(M.ERROR) == "Ok"
		IF PEMSTATUS(formul.Controls(indicecontrolesvalido),'LostFocus',5) AND formul.Controls(indicecontrolesvalido).Visible THEN
			formul.Controls(indicecontrolesvalido).LostFocus	
			IF SUBSTR(ALLTRIM(M.ERROR),1,2) == '??' OR SUBSTR(ALLTRIM(M.ERROR),1,2) == '#?' THEN
				M.ERROR = "Ok"	
			ENDIF
		ENDIF
		indicecontrolesvalido = indicecontrolesvalido + 1
	ENDDO
	RETURN (ALLTRIM(M.ERROR) == "Ok")
ENDFUNC


FUNCTION ESVALIDOCONFIRMACIONES(formul)
	LOCAL il, confirmaci
	indicecontrolesvalido = 1
	M.ERROR = "Ok"
	DO WHILE indicecontrolesvalido<=formul.ControlCount AND ALLTRIM(M.ERROR) == "Ok"
		IF PEMSTATUS(formul.Controls(indicecontrolesvalido),'LostFocus',5) AND formul.Controls(indicecontrolesvalido).Visible THEN
			formul.Controls(indicecontrolesvalido).LostFocus
			IF SUBSTR(ALLTRIM(M.ERROR),1,2) == '??' THEN
				confirmaci = MESSAGEBOX(SUBSTR(ALLTRIM(M.ERROR),3), 52, "MILLENNIUM CONSULTING")
				IF confirmaci = 6
					M.ERROR = "Ok"	
				ENDIF
			ELSE
				IF SUBSTR(ALLTRIM(M.ERROR),1,2) == '#?' THEN	
					M.ERROR = ALLTRIM(M.ERROR)
					confirmaci = 6

					DO WHILE NOT EMPTY(M.ERROR) AND confirmaci = 6	
						M.ERROR = ALLTRIM(SUBSTR(M.ERROR,3))
						il = ENCONTRARSIGUIENTECONF(M.ERROR)
						confirmaci = MESSAGEBOX(SUBSTR(M.ERROR,1,il), 52, "MILLENNIUM CONSULTING")
						M.ERROR = ALLTRIM(SUBSTR(M.ERROR,il+1))
					ENDDO
					IF confirmaci = 6 THEN
						M.ERROR = "Ok"
					ENDIF
				ELSE
					M.ERROR = "Ok"	
				ENDIF
			ENDIF	
		ENDIF
		indicecontrolesvalido = indicecontrolesvalido + 1
	ENDDO
	RETURN (ALLTRIM(M.ERROR) == "Ok")
ENDFUNC


PROCEDURE ESVALIDODETALLE(rejilla)
	LOCAL i, focus
	i = 1
	M.ERRORDETA = "Ok"
	DO WHILE i<=rejilla.ColumnCount AND M.ERRORDETA = "Ok"
		IF PEMSTATUS(rejilla.Columns(i).CurrentControl,'LostFocus',5) THEN
			rejilla.Columns(i).CurrentControl.LostFocus	
		ENDIF
		i = i + 1
	ENDDO
	
	IF M.ERRORDETA <>"Ok" THEN
		MESSAGEBOX(M.ERRORDETA, 48, "MILLENNIUM CONSULTING")
		rejilla.Columns(i-1).CurrentControl.SetFocus
		RETURN .F.
	ELSE
		RETURN .T.
	ENDIF
ENDPROC


*****************************************************************************
*                            FUNCIONES DE FORMULARIOS		                *
*                                                                           *
*****************************************************************************

PROCEDURE REFRESCATITULOPROGRAMA()
	*Refresca el ttulo de la pgina principal de cada mdulo. Se utiliza cuando cambiamos de empresa o mes de trabajo

	IF TYPE('cEmpresa') <> 'C' THEN
		PUBLIC cEmpresa
		USE (cDirectorio + "CONFIG\OPCIONES") IN 0
		RESTORE FROM MEMO opciones.empresa ADDITIVE
		USE IN Opciones
	ENDIF

	DO CASE
		CASE MODULO = 1
			STRMODULO = "CONTABILIDAD"
		CASE MODULO = 2
			STRMODULO = "BANCOS"
		CASE MODULO = 3
			STRMODULO = "FACTURACION"
		CASE MODULO = 4
			STRMODULO = "INVENTARIO"
		CASE MODULO = 5
			STRMODULO = "PLANILLA"
		CASE MODULO = 6
			STRMODULO = "CONFIGURACION"
		CASE MODULO = 7
			STRMODULO = "CUENTAS POR COBRAR"
	ENDCASE
	
	IF MODULO = 6 THEN
		strmes = ""
	ELSE
		IF W_ACTIVO AND TYPE('W_DESDE')= 'D' AND MODULO <> 5 THEN
			strmes = " - "+PROPER(cmes(MONTH(W_DESDE)))+ " de "+ ALLTRIM(STR(YEAR(W_DESDE))) 
		ELSE
			IF W_ACTIVO AND TYPE('W_PERIODO') = 'N' AND TYPE('W_DESDE')= 'D' AND TYPE('W_HASTA')= 'D' AND MODULO =5 THEN
				strmes = " - Periodo "+ALLTRIM(STR(W_PERIODO))+ ": de "+DTOC(W_DESDE)+" hasta "+DTOC(W_HASTA)
			ELSE
				IF MODULO = 5 THEN
					strmes = " - No se ha definido un periodo de trabajo"
				ELSE
					strmes = " - No se ha definido un mes de trabajo"
				ENDIF
			ENDIF
		ENDIF 
	ENDIF
	
	MODIFY WINDOW SCREEN TITLE "MILLENNIUM "+ALLTRIM(UPPER(STRMODULO))+" - "+ ALLTRIM(cEmpresa)+ strmes;
		ICON FILE (dirraiz+"ICONOS\CAMERA.ICO") 

ENDPROC

PROCEDURE TRUEHOR(hor)
	RETURN (hor*SYSMETRIC(1))/800
ENDPROC

PROCEDURE TRUEVER(ver)
	RETURN (ver*SYSMETRIC(2))/600
ENDPROC

PROCEDURE COLOCA(obj, hor, ver)
	&& Coloca objetos en formularios en tiempo de ejecucin adecuando a las diferentes configuraciones de pantalla.
	obj.Left = (hor*SYSMETRIC(1))/800
	obj.Top = (ver*SYSMETRIC(2))/600
ENDPROC

PROCEDURE COLOCAHORIZONTAL(obj, hor)
	obj.Left = (hor*SYSMETRIC(1))/800
ENDPROC

PROCEDURE COLOCAVERTICAL(obj, ver)
	obj.Top = (ver*SYSMETRIC(2))/600
ENDPROC

PROCEDURE COLOCAALTOFORM(formu, alto)
	formu.MaxHeight = -1
	formu.MinHeight = -1
	formu.Height = (alto*SYSMETRIC(2))/600
	formu.MaxHeight = formu.Height
	formu.MinHeight = formu.Height
ENDPROC

PROCEDURE COLOCAANCHOFORM(formu, ancho)
	formu.MaxWidth = -1
	formu.MinWidth = -1
	formu.Width = (ancho*SYSMETRIC(1))/800
	formu.MaxWidth = formu.Width
	formu.MinWidth = formu.Width
ENDPROC


FUNCTION COLORESPANTALLA()
	* Devuelve Colores Disponibles
	LOCAL liGetDC, liDCHandle, liPlanes, liBitsPixel, liNumColors, ;
  	liStandardPlanes, liStandardBitsPixel, piDCHandle, piNumColors
	DECLARE INTEGER GetDC IN WIN32API INTEGER liGetDC
	liDCHandle = GetDC(0)
	liStandardPlanes = 14
	liStandardBitsPixel= 12
	DECLARE INTEGER GetDeviceCaps IN WIN32API INTEGER piDCHandle,;
  	INTEGER piNumColors
	liPlanes = GetDeviceCaps(liDCHandle, liStandardPlanes)
	liBitsPixel = GetDeviceCaps(liDCHandle, liStandardBitsPixel)
	liNumColors = 2^(liPlanes * liBitsPixel)
	DECLARE INTEGER ReleaseDC IN WIN32API INTEGER piHandle,;
  	INTEGER piDCHandle
	ReleaseDC(0, liDCHandle)
	RETURN INT(liNumColors)
ENDFUNC

FUNCTION ACTIVA_PAGINA(nombrepagina)
	LOCAL formulario, il
	elformset = _SCREEN.ActiveForm.PARENT
	formulario = NULL
	FOR il = 1 TO elformset.FormCount
		IF ALLTRIM(UPPER(elformset.Forms(il).Name)) == ALLTRIM(UPPER(nombrepagina)) THEN
			formulario = elformset.Forms(il)
		ELSE
			elformset.Forms(il).AlwaysOnTop=.F.
		ENDIF
	ENDFOR
	IF NOT ISNULL(formulario) THEN
		formulario.Visible=.T.
		formulario.AlwaysOnTop=.T.
	ENDIF
ENDFUNC


FUNCTION ACTIVA_FORM(formul, par1, par2, par3, par4, par5)
	* Funcin utilizada en los hipervnculos para activar una opcin que es un formulario si est definido un mes de trabajo. En caso contrario, se genera un mensaje de error.
	LOCAL formul2
	IF W_ACTIVO THEN
		** Realiza el INICIA_FORM con los parmetros correspondientes
		npar = PCOUNT()-1
		comando = "DO INICIA_FORM IN CILIB001 WITH formul,"
		FOR i = 1 TO npar
			comando = comando + " par"+ALLTRIM(STR(i))+","
		ENDFOR
		comando = SUBSTR(comando,1,LEN(comando)-1)
		&comando
	ELSE
		IF MODULO = 5 THEN
			MESSAGEBOX("No se ha definido un periodo de trabajo. Defnalo y vuelva a intentarlo ",48,"MILLENNIUM CONSULTING")
		ELSE
			MESSAGEBOX("No se ha definido un mes de trabajo. Defnalo y vuelva a intentarlo ",48,"MILLENNIUM CONSULTING")	
		ENDIF
	ENDIF
ENDFUNC



FUNCTION INICIA_FORM(formul, par1, par2, par3, par4, par5)
	* Funcin utilizada en los hipervnculos para activar una opcin que es un formulario.
	LOCAL formulario, estabaentop, ite, npar, strpar
	SET PROC TO CILIB001 ADDITIVE
	npar = PCOUNT()-1
	formulario = DEVUELVEFORMULARIOONTOP()
	IF NOT ISNULL(formulario) THEN
		formulario.AlwaysOnTop = .F.
	ENDIF
	
	** Realiza el DO FORM con los parmetros correspondientes
	
	IF npar = 0 THEN
		comando = "DO FORM "+formul+".SCX"
	ELSE
		comando = "DO FORM "+formul+".SCX WITH"
		FOR i = 1 TO npar
			comando = comando + " par"+ALLTRIM(STR(i))+","
		ENDFOR
		comando = SUBSTR(comando,1,LEN(comando)-1)
	ENDIF
	&comando
	
	IF NOT ISNULL(formulario) THEN
		formulario.AlwaysOnTop = .T.
	ENDIF
ENDFUNC

FUNCTION ACTIVA_PRG(programa)
	* Funcin utilizada en los hipervnculos para activar una opcin que es un PRG si est definido un mes de trabajo. En caso contrario, se genera un mensaje de error.
	LOCAL programa2
	IF W_ACTIVO THEN
		DO INICIA_PRG IN CILIB001 WITH programa
	ELSE
		IF MODULO = 5 THEN
			MESSAGEBOX("No se ha definido un periodo de trabajo. Defnalo y vuelva a intentarlo. ",48,"MILLENNIUM CONSULTING")
		ELSE
			MESSAGEBOX("No se ha definido un mes de trabajo. Defnalo y vuelva a intentarlo. ",48,"MILLENNIUM CONSULTING")
		ENDIF
	ENDIF
ENDFUNC


FUNCTION INICIA_PRG(programa)
	* Funcin utilizada en los hipervnculos para activar una opcin que es un formulario.
	LOCAL formulario
	SET PROC TO CILIB001 ADDITIVE
	formulario = DEVUELVEFORMULARIOONTOP()
	IF NOT ISNULL(formulario) THEN
		formulario.AlwaysOnTop = .F.
	ENDIF
	DO (programa+".PRG")
	IF NOT ISNULL(formulario) THEN
		formulario.AlwaysOnTop = .T.
	ENDIF
ENDFUNC

FUNCTION DEVUELVEFORMULARIOONTOP(frt)
	** Devuelve el formulario del Formset actual que tiene la propiedad AlwaysOnTop a cierto
	** Si no lo encuentra, devuelve NULL 
	LOCAL elformset, ite
	elformset = _SCREEN.ActiveForm.Parent
	ite = 1 
	DO WHILE (ite <= elformset.FormCount) AND (NOT elformset.Forms(ite).AlwaysOnTop)
		ite = ite + 1
	ENDDO
	IF ite <= elformset.FormCount THEN
		RETURN elformset.Forms(ite)
	ELSE
		RETURN NULL 
	ENDIF
ENDFUNC

PROCEDURE DESHACER_FORM(formul)
	IF M.ADIC THEN
		GO TOP
	ENDIF
	SCATTER MEMVAR
	formul.cmdAdd.Picture 	= cDirectorio + "ICONOS\WZNEW.BMP"
	formul.cmdEdit.Picture 	= cDirectorio + "ICONOS\WZEDIT.BMP"
	REFRESCA_BOTONES(formul)
	STORE .F. TO M.ADIC
	STORE .F. TO M.MODI
	formul.REFRESH
ENDPROC

PROCEDURE REFRESCA_BOTONES (formul)
	* Activa o desactiva los botones de comando de un formulario segn corresponde.
	LOCAL nregis
	nregis = RECNO()
	COUNT TO nRegistros
	IF nRegistros > 0
		GO nregis
		SKIP -1
		IF BOF() THEN
			formul.cmdTop.Enabled 	= .F.
			formul.cmdPrev.Enabled 	= .F.
		ELSE
			formul.cmdTop.Enabled 	= .T.
			formul.cmdPrev.Enabled 	= .T.
			SKIP 1
		ENDIF
		SKIP
		IF EOF() THEN
			formul.cmdNext.Enabled 	= .F.
			formul.cmdEnd.Enabled 	= .F.
		ELSE
			formul.cmdNext.Enabled 	= .T.
			formul.cmdEnd.Enabled 	= .T.
		ENDIF
		SKIP -1
		formul.cmdFind.Enabled 	= .T.
		formul.cmdPrint.Enabled 	= .T.
		formul.cmdEdit.Enabled 	= .T.
		formul.cmdDelete.Enabled 	= .T.
	ELSE
		formul.cmdTop.Enabled 	= .F.
		formul.cmdPrev.Enabled 	= .F.
		formul.cmdNext.Enabled 	= .F.
		formul.cmdEnd.Enabled 	= .F.
		formul.cmdFind.Enabled 	= .F.
		formul.cmdPrint.Enabled 	= .F.
		formul.cmdEdit.Enabled 	= .F.
		formul.cmdDelete.Enabled 	= .F.
	ENDIF
	formul.cmdAdd.Enabled 	= .T.
	formul.cmdExit.Enabled 	= .T.
ENDPROC
PROCEDURE BOTON_AVANZA (formu)
	* Procedimiento que se coloca en el botn cmdNext de un formulario
	SKIP
	DO REFRESCA_BOTONES WITH formu
	IF PEMSTATUS(formu,'reg',5) THEN
		SCATTER NAME formu.reg
	ELSE
		SCATTER MEMVAR	
	ENDIF
	formu.REFRESH
ENDPROC

PROCEDURE BOTON_RECULA (formu)
	* Procedimiento que se coloca en el botn cmdPrev de un formulario
	SKIP -1
	DO REFRESCA_BOTONES WITH formu
	IF PEMSTATUS(formu,'reg',5) THEN
		SCATTER NAME formu.reg
	ELSE
		SCATTER MEMVAR	
	ENDIF
	formu.REFRESH
ENDPROC

PROCEDURE BOTON_PRINCIPIO (formu)
	* Procedimiento que se coloca en el botn cmdTop de un formulario
	GO TOP
	DO REFRESCA_BOTONES WITH formu
	IF PEMSTATUS(formu,'reg',5) THEN
		SCATTER NAME formu.reg
	ELSE
		SCATTER MEMVAR	
	ENDIF

	formu.REFRESH
ENDPROC

PROCEDURE BOTON_FIN (formu)
	* Procedimiento que se coloca en el botn cmdEnd de un formulario
	GO BOTTOM
	DO REFRESCA_BOTONES WITH formu
	IF PEMSTATUS(formu,'reg',5) THEN
		SCATTER NAME formu.reg
	ELSE
		SCATTER MEMVAR	
	ENDIF
	formu.REFRESH
ENDPROC

PROCEDURE BOTON_VISTA(formu)
	* Procedimiento que se coloca en el botn cmdFind de un formulario.
	LOCAL nreg, nomcon, nomtab
	IF PEMSTATUS(formu,'ConsultaPrincipal',5) AND NOT EMPTY(formu.ConsultaPrincipal) THEN
		nomcon = JUSTSTEM(formu.ConsultaPrincipal)+".QPR"
	ELSE
		nomcon = ALLTRIM(formu.TablaPrincipal)+".QPR"
	ENDIF
	
	nomtab = ALIAS()
		
	nreg = RECNO()
	formu.Closable = .T.
		
	DO &nomcon
	formu.Closable = .F.
	USE
	SELE &nomtab
	GO nreg
	IF PEMSTATUS(formu,'reg',5) THEN
		SCATTER NAME formu.reg
	ELSE
		SCATTER MEMVAR	
	ENDIF
	formu.REFRESH
	REFRESCA_BOTONES(formu)	
ENDPROC

FUNCTION INIT_FORM(formt)
	* Funcin que se coloca en todas los eventos Init de todos los formularios, cuadros de dilogo, etc y que permite que estos se adecuen a las diferentes configuraciones de pantalla y nmero de colores
	DO DECLARA_VARIABLES_FORM
	IF XADAPTACOLORES THEN
		DO ADAPTA_COLORES_FORM WITH formt
	ENDIF
	
	IF XRESIZE THEN
		DO RESIZE_FORM WITH formt
	ENDIF
ENDFUNC

FUNCTION DECLARA_VARIABLES_FORM
	PUBLIC M.ERROR
	PUBLIC M.DENTRODEESVALIDO
	M.DENTRODEESVALIDO = .F.
ENDFUNC

FUNCTION ADAPTA_COLORES_FORM(formulr)
	IF COLORESPANTALLA <=256 AND formulr.Backcolor = RGB(194,191,165) THEN
		formulr.BackColor = RGB(192,192,192)
	ENDIF
ENDFUNC

FUNCTION RESIZE_FORM(formulr)

	PRIVATE altopantalla, anchopantalla
	formulr.MaxHeight = -1
	formulr.MinHeight = -1
	formulr.MaxWidth = -1
	formulr.MinWidth = -1

	anchopantalla = SYSMETRIC(1)
	altopantalla = SYSMETRIC(2)
	
	formulr.SIZER1.screenheight = altopantalla
	formulr.SIZER1.screenwidth = anchopantalla
	
	IF TYPE('formulr.SIZER1.formheight') = 'N' AND TYPE('formulr.SIZER1.formwidth') = 'N' THEN
		IF formulr.SIZER1.formheight <> 0 AND formulr.SIZER1.formwidth <>0 THEN
			altura = formulr.SIZER1.formheight
			anchura = formulr.SIZER1.formwidth
		ELSE
			altura = formulr.height
			anchura = formulr.width
		ENDIF
	ELSE
		altura = formulr.height
		anchura = formulr.width
	ENDIF

	DO CASE
		CASE anchopantalla = 640 AND altopantalla = 480
			IF altura = 574 AND anchura = 802 THEN
				formulr.Shape2.Height = 86
				formulr.Shape2.Width = 86
				*formulr.Shape2.Top = 40
				formulr.Shape2.Left = 92

				formulr.Shape1.Height = 100
				formulr.Shape1.Width = 100
				*formulr.Shape1.Top = 34
				formulr.Shape1.Left = 87
			
				formulr.Height = 458 
				formulr.Width = 641 
			ELSE
				formulr.Height = (altopantalla * altura)/600
				formulr.Width = (anchopantalla * anchura)/800
			ENDIF
			
			IF altura = 407 AND anchura = 806 THEN	
				formulr.Top = 100
				formulr.Left = 125			
			ELSE
				IF formulr.AutoCenter THEN
					formulr.Top = ((458 -38)- formulr.Height)/2
					formulr.Left = (641 - formulr.Width)/2
				ELSE
					formulr.Top = (formulr.Top*458)/574
					formulr.Left = (formulr.Left*641)/802
				ENDIF
			ENDIF
			formulr.SIZER1.FRMRESIZE()
			
		CASE anchopantalla = 800 AND altopantalla = 600
	
		CASE anchopantalla = 1024 AND altopantalla = 768
			IF altura = 574 AND anchura = 802 THEN
				formulr.Height = 734
				formulr.Width = 1026
			ELSE
				formulr.Height = (altopantalla * altura)/600
				formulr.Width = (anchopantalla * anchura)/800
			ENDIF
			
			IF formulr.AutoCenter THEN
				formulr.Top = ((734 - 60) - formulr.Height)/2
				formulr.Left = (1026 - formulr.Width)/2
			ELSE
				formulr.Top = (formulr.Top*734)/574
				formulr.Left = (formulr.Left*1026)/802
			ENDIF
			
			
			formulr.SIZER1.FRMRESIZE()
		
		OTHERWISE
			formulr.Height = (altopantalla * altura)/600
			formulr.Width = (anchopantalla * anchura)/800
			IF formulr.AutoCenter THEN
				formulr.Top = (altopantalla- formulr.Height)/2
				formulr.Left = (anchopantalla - formulr.Width)/2
			ELSE
				formulr.Top = (formulr.Top*altopantalla)/600
				formulr.Left = (formulr.Left*anchopantalla)/800
			ENDIF
			formulr.SIZER1.FRMRESIZE()
	ENDCASE

	formulr.MaxHeight = formulr.Height
	formulr.MinHeight = formulr.Height
	formulr.MaxWidth = formulr.Width
	formulr.MinWidth = formulr.Width
ENDFUNC

FUNCTION QUITA_DETALLE_FORM (formut, altseiscientos)
	LOCAL altura
	altura = (altseiscientos*SYSMETRIC(2))/600
	formut.MinHeight = -1
	formut.Top = formut.Top + (altura/2)
	formut.Height = formut.Height - altura
	formut.Grid1.Visible = .F.
	formut.CmdTop.Top = formut.CmdTop.Top - altura
	formut.CmdEnd.Top = formut.CmdEnd.Top - altura
	formut.CmdPrev.Top = formut.CmdPrev.Top - altura
	formut.CmdNext.Top = formut.CmdNext.Top - altura
	formut.CmdAdd.Top = formut.CmdAdd.Top - altura	
	formut.CmdEdit.Top = formut.CmdEdit.Top - altura
	formut.CmdDelete.Top = formut.CmdDelete.Top - altura
	formut.CmdPrint.Top = formut.CmdPrint.Top - altura
	formut.CmdFind.Top = formut.CmdFind.Top - altura	
	formut.CmdExit.Top = formut.CmdExit.Top - altura
	formut.Shape3.Top = formut.Shape3.Top - altura
	formut.Shape4.Top = formut.Shape4.Top - altura
	formut.MinHeight = formut.Height
ENDFUNC
*****************************************************************************
*                            FUNCIONES DE CONTROLES			                *
*                                                                           *
*****************************************************************************

FUNCTION EXISTEPARAMETRO(ctrlp,par)
	LOCAL df
	df = ctrlp.Tag
	RETURN EXISTEPARAMETROAUX(df,par)
ENDFUNC

FUNCTION VALORPARAMETRO(ctrlp,par)
	LOCAL df 
	df = ctrlp.Tag
	RETURN VALORPARAMETROAUX(df,par)
ENDFUNC

FUNCTION EXISTEPARAMETROAUX(strp,par)
	LOCAL lugar
	lugar = RETORNAPALABRA(UPPER(strp),UPPER(par))
	RETURN (lugar<>0)
ENDFUNC

FUNCTION VALORPARAMETROAUX(strp,par)
	LOCAL lugar,ddf
	lugar = RETORNAPALABRA(UPPER(strp),UPPER(par))
	IF lugar = 0 THEN
		RETURN NULL
	ELSE
		ddf = PALABRASIGUIENTE (strp,lugar+LEN(par))
		RETURN ddf
	ENDIF
ENDFUNC

FUNCTION RETORNAPALABRA(strp2,par2)
	LOCAL lugar, comienzo, final
	
	lugar = AT(UPPER(par2),UPPER(strp2))
	IF lugar <= 1 THEN
		comienzo = (lugar = 1)
	ELSE
		comienzo = (SUBSTR(strp2,lugar-1,1) == ' ')
	ENDIF
	
	IF lugar+ LEN(par2) > LEN(strp2) THEN
		final = (lugar+LEN(par2)= LEN(strp2)+1)
	ELSE
		final = (SUBSTR(strp2,lugar+LEN(par2),1) == ' ')
	ENDIF
	
	IF comienzo AND final THEN
		RETURN lugar
	ELSE
		RETURN 0 
	ENDIF	
	
ENDFUNC

FUNCTION PALABRASIGUIENTE (strp,posp)
	LOCAL finp, cadenaauxiliar
	IF posp > LEN(strp) THEN
		RETURN NULL
	ELSE
		cadenaauxiliar = LTRIM(SUBSTR(strp,posp))
		finp = AT(' ',cadenaauxiliar) 
		
		IF finp = 0 THEN 
			finp = LEN(strp)
		ELSE
			finp = finp + LEN(strp)-LEN(cadenaauxiliar)
		ENDIF
		RETURN ALLTRIM(UPPER(SUBSTR(strp,posp,finp-posp+1)))
	ENDIF
ENDFUNC

FUNCTION MASCARAENTRADANUMERICA(enteros, decimales)
	LOCAL cadena, cocientetres, restotres
	cocientetres = INT(enteros/3)
	restotres = enteros - 3*cocientetres
	cadena = REPLICATE(',999', cocientetres)
	IF restotres = 0 THEN
		cadena = SUBSTR(cadena,2)
	ELSE
		cadena = REPLICATE('9',restotres) + cadena
	ENDIF
	IF decimales > 0 THEN
		cadena = cadena +'.'+REPLICATE('9',decimales)
	ENDIF
	RETURN cadena
ENDFUNC

*****************************************************************************
*                            FUNCIONES DE REPORTES			                *
*                                                                           *
*****************************************************************************


PROCEDURE IMPRIME_REPORTE (nomreporte, condicion, nomform)
	* Imprime un reporte. Los parmetros son "nombre del reporte", "condicion en la que se imprime" () y "nombre del formulario que se presenta antes del reporte y que sirve para elegir el destino del reporte"
	PUBLIC SALIDA, CONTOTALES
	STORE 1 TO SALIDA
	IF EMPTY(condicion) THEN
		stcondicion = ""
	ELSE
		stcondicion = " FOR "+ condicion
	ENDIF
	
	DO FORM dirraiz+"COMUN\"+ALLTRIM(nomform)+".SCX"
	
	IF SALIDA <> 0 THEN
		PUBLIC CONFECHA
		CONFECHA = NOT (LEEVARBOOLDEFECTO('XREPORTESSINFECHAHORA',.F.))
	
		IF DEFINIDAVAR('XREPORTE'+ALLTRIM(nomreporte)) THEN
			nomreporte = LEEVAR('XREPORTE_'+ALLTRIM(nomreporte))
		ENDIF
	
		DO CASE 
			CASE SALIDA = 1
				KEYBOARD '{CTRL+F10}'
				REPO FORM &nomreporte PREVIEW &stcondicion
						
			CASE SALIDA = 2	
				REPO FORM &nomreporte TO PRINTER PROMPT NOEJECT NOCONSOLE &stcondicion
			
			CASE SALIDA = 3
				archivo = OBTIENE_ARCHIVO("C:\","TXT","Reporte en ASCII")
				IF NOT EMPTY(archivo) THEN
					REPO FORM &nomreporte TO FILE &archivo ASCII &stcondicion
				ENDIF
			
			CASE SALIDA = 4
				STORE 0 TO CONTOTALES 
				DO FORM dirraiz+"COMUN\CIRP0200.SCX"
				IF CONTOTALES <> 0 THEN
					archivo = OBTIENE_ARCHIVO("C:\","XLS","Reporte en Excel")
					IF NOT EMPTY(archivo) THEN
						programaexcel = ALLTRIM(nomreporte+"ex")
						ntab = "XC"+nomreporte+".DBF"
						DO &programaexcel WITH CONTOTALES
						USE &ntab
						COPY TO &archivo TYPE XL5
						USE
					ENDIF
				ENDIF
		ENDCASE	
		RELEASE CONFECHA
	ENDIF
ENDPROC

PROCEDURE IMPRIME_REPORTE_FORM (formu, nomreporte, condicion, nomform, tablamoneda, cfecha, camposmonetarios)
	* Imprime un reporte desde el botn cmdPrint de un formulario. Debe pasarse el formulario a parte de los parmetros de la funcin IMPRIME_REPORTE.
	LOCAL nreg, filtro, tabla, continua, filtroaux, tabladestino
	IF PCOUNT() <5
		tablamoneda = ""
	ENDIF
	
	RECORDARCODIGO()
	
	tabla = ALIAS()
	filtro = FILTER()
	nreg = RECNO()
	continua = .T.
	IF NOT EMPTY(tablamoneda) THEN
		PUBLIC OPCION
		DO FORM CIRP0500.SCX
		IF MODULO = 5 THEN
			filtroaux = 'periodo = '+STR(W_PERIODO)+' AND empresa = '+STR(nCodigo)
		ELSE
			filtroaux = 'nmes = '+STR(MONTH(W_DESDE))+ ' AND anyo = '+ STR(YEAR(W_DESDE))+' AND empresa = '+STR(nCodigo)
		ENDIF
		tabladestino = 'w'+JUSTSTEM(tablamoneda)
	
		TRADUCETABLAMONEDAGAMMA(tablamoneda,tabladestino,W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, cfecha, camposmonetarios, filtroaux)
		continua = (OPCION = 1)
		RELEASE OPCION
	ENDIF
	
	IF continua THEN
		DO IMPRIME_REPORTE WITH nomreporte, condicion, nomform
	ENDIF

	IF NOT EMPTY(tablamoneda) THEN
		DO DESTRUYEVARIABLESMONEDAREP IN CILIB001	
	ENDIF
	
	IF TYPE("nCodigo") <>"N"
		formu.Dataenvironment.Beforeopentables
	ENDIF
	
	IF NOT EMPTY(tabla) THEN
		SELECT (tabla)
		SET FILTER TO &filtro
		GO nreg
	ENDIF
ENDPROC

PROCEDURE IMPRIME_REPORTE_DATOS(formu, nomreporte, condicion, nomform)
	PUBLIC OPCION, R_MES, R_ANYO
	DO FORM &formu
	IF OPCION = 1 THEN
		DO IMPRIME_REPORTE WITH nomreporte, condicion, nomform
	ENDIF
	RELEASE OPCION, R_MES, R_ANYO
ENDPROC

FUNCTION PAGINAS_REPORTE(lc_report)
	LOCAL nPaginas, nreg, filtro, tabla

	tabla = ALIAS()
	filtro = FILTER()
	nreg = RECNO() 
	
	nPaginas = 0
	
	DEFINE WINDOW x FROM 1,1 TO 2,2
	ACTIVATE WINDOW x NOSHOW
	REPORT FORM (lc_report) NOCONSOLE
	nPaginas = _PAGENO
	RELEASE WINDOW x
	
	
	IF TYPE("nCodigo") <>"N"
		_VFP.ActiveForm.Dataenvironment.Beforeopentables
	ENDIF
	SELECT (tabla)
	SET FILTER TO &filtro
	GO nreg

	RETURN npaginas
ENDFUNC

FUNCTION SIPIEDEGRUPO()
	PIEDEGRUPO = .T.		
	RETURN
ENDFUNC

FUNCTION NOPIEDEGRUPO()
	PIEDEGRUPO = .F.		
	RETURN
ENDFUNC

*****************************************************************************
*                            FUNCIONES DE DEPURACION                        *
*                                                                           *
*****************************************************************************

FUNCTION LISTATABLASUSADAS
	* Para depuracin. Devuelve un string con todas la lista de tablas usadas hasta el momento.
	PRIVATE nt, stt, sdbf
	stt = ''
	FOR nt = 1 TO 255
		sdbf = DBF(nt)
		IF NOT EMPTY(sdbf) AND TYPE('sdbf') = 'C' THEN
			stt = stt + STR(nt)+"-"+ALLTRIM(sdbf)+" ("+ ALIAS(nt) +")"+ALLTRIM(STR(RECNO(ALIAS(nt))))+"//"
		ENDIF
	ENDFOR
	RETURN stt
ENDFUNC

FUNCTION STRBOOL(b)
	IF b THEN
		RETURN '.T.'
	ELSE
		RETURN '.F.'
	ENDIF
ENDFUNC

PROCEDURE MBOX(p)
	* Para depuracin. Es un MESSAGEBOX pero con cualquier tipo de datos.
	LOCAL tipus
	tipus = TYPE('p')
	DO CASE
		CASE tipus = 'C'
			MESSAGEBOX(p)
		CASE tipus = 'N'
			MESSAGEBOX(EXTSTR(p))
		CASE tipus = 'L'
			MESSAGEBOX(STRBOOL(p))
		CASE tipus = 'D'
			MESSAGEBOX(DTOC(p))	
	ENDCASE
ENDPROC

FUNCTION STRGEN(p)
	LOCAL tipus
	IF ISNULL(p) THEN
		RETURN '.NULL.'
	ELSE
		tipus = TYPE('p')
		DO CASE
			CASE tipus = 'C'
				RETURN p
			CASE tipus = 'N'
				RETURN EXTSTR(p)
			CASE tipus = 'L'
				RETURN STRBOOL(p)
			CASE tipus = 'D'
				RETURN DTOC(p)	
		ENDCASE
	ENDIF
ENDFUNC

FUNCTION STRGENCOMANDO(p, tipus)
	IF PCOUNT() < 2 THEN 
		tipus = TYPE('p')
	ENDIF
	DO CASE
		CASE tipus = 'C'
			RETURN CHR(34)+p+CHR(34)
		CASE tipus = 'N'
			RETURN EXTSTR(p)
		CASE tipus = 'L'
			RETURN STRBOOL(p)
		CASE tipus = 'D'
			RETURN 'DATE('+STR(YEAR(p))+ ','+STR(MONTH(p))+','+STR(DAY(p))+')'
	ENDCASE
ENDPROC

FUNCTION DTOCCOMANDO(p)
	RETURN 'DATE('+STR(YEAR(p))+ ','+STR(MONTH(p))+','+STR(DAY(p))+')'
ENDFUNC 

FUNCTION STRIGUALDADGENERALCOMANDO(p1,p2, mode) && Mode 0, el primero un string y el segundo un valor. Mode 1, dos valores
	LOCAL tipus, st1
	tipus = TYPE('p2')
	IF mode = 0 AND TYPE('p1')='C' THEN
		st1 = p1
	ELSE
		st1 = STRGEN(p1)
	ENDIF
	
	DO CASE
		CASE tipus = 'C'
			RETURN 'ALLTRIM(UPPER('+st1+')) == ALLTRIM(UPPER('+CHR(34)+p2+CHR(34)+'))'
		CASE tipus = 'N'
			RETURN st1 + '=' +EXTSTR(p2)
		CASE tipus = 'L'
			RETURN st1 + '=' +STRBOOL(p2)
		CASE tipus = 'D'
			RETURN st1 + '=' +'DATE('+STR(YEAR(p2))+ ','+STR(MONTH(p2))+','+STR(DAY(p2))+')'
	ENDCASE
ENDFUNC

PROCEDURE DMBOX(p)
	LOCAL tipus
	tipus = TYPE('p')
	DO CASE
		CASE tipus = 'C'
			MESSAGEBOX("Carcter ##"+p+"##")
		CASE tipus = 'N'
			MESSAGEBOX("Numrico "+EXTSTR(p))
		CASE tipus = 'L'
			MESSAGEBOX("Lgico "+STRBOOL(p))
		CASE tipus = 'D'
			MESSAGEBOX("Fecha "+DTOC(p))	
	ENDCASE
ENDPROC

FUNCTION CASCII(cadena)
	* Para depuracin. Devuelve un string con todos los cdigos ASCII de una cadena de caracteres.
	LOCAL rst,ig
	rst = ""
	FOR ig = 1 TO LEN(cadena)
		rst = rst + STR(ASC(SUBSTR(cadena,ig,1))) + ","
	ENDFOR

	RETURN rst
ENDFUNC

PROCEDURE DIFSEGUNDOS(s1,s2, textoopcional)
	IF PCOUNT() < 3 THEN
		textoopcional = ""
	ENDIF
	MESSAGEBOX(textoopcional+" "+ALLTRIM(STR((s2-s1)*1000))+ " milisegundos")
ENDPROC

*****************************************************************************
*                         WRAPPERS 					                        *
*                                                                           *
*****************************************************************************

PROCEDURE WSETFILTERADDITIVE(filtro)
	filtro = filtro + IIF(!EMPTY(FILTER())," AND " + FILTER(),"")
	SET FILTER TO &filtro
ENDPROC

PROCEDURE WREPLACEALL(listacampos,condicion, tabla) 

	GUARDAESTADOPREFIJO('wreplaceall')
	
	IF PCOUNT() > 2 THEN
		SELECT &tabla
	ENDIF
	
	IF PCOUNT() <= 1 THEN
		condicion = '.T.'
	ENDIF
			
	SCAN FOR &condicion
		comando = "REPLACE "+ listacampos
		&comando
	ENDSCAN
	
	RECUPERAESTADOPREFIJO('wreplaceall')	
ENDPROC

PROCEDURE WDELETEALL(condicion, tabla) 
	LOCAl taulap
	
	taulap = ALIAS()
	
	IF PCOUNT() > 1 THEN
		SELECT &tabla
	ENDIF
	
	GUARDAESTADOPREFIJO('wdeleteall')
	
	IF PCOUNT() = 0 THEN
		condicion = '.T.'
	ENDIF
			
	SCAN FOR &condicion
		DELETE 
	ENDSCAN
	
	RECUPERAESTADOPREFIJO('wdeleteall')	
	IF NOT EMPTY(taulap) THEN
		SELE &taulap
	ENDIF
ENDPROC





*****************************************************************************
*                 			FUNCIONES DE BACKUP 		                    *
*                                                                           *
*****************************************************************************


PROCEDURE GUARDABACKUP(diraguardar, recursivo, mesini, anyoini, mesfin, anyofin, modomovimientos)
&& Si recursivo, no slo se guarda el directorio actual sino todos los subdirectorios
&& Si alguno de los parmetros meses o los parmetros anyos es 0, eso quiere decir todos lod meses definidos
&& Modo movimientos ser 0 - toda la informacin, 1 - tabla de movimientos
&& Por ahora, la opcin de meses y modomovimientos no estn implementadas
	LOCAL directorio, tipodisco
	IF SUBSTR(diraguardar,LEN(diraguardar),1) <> "\" THEN
		diraguardar = diraguardar + "\"
	ENDIF
	rutaarchivo = PUTFILE('Guardar respaldo', '', 'ZIP')
	IF NOT EMPTY(rutaarchivo) THEN
		directorio = JUSTPATH(rutaarchivo)
		tipodisco = DRIVETYPE(JUSTDRIVE(directorio))
		IF tipodisco = 1 THEN
			MESSAGEBOX("Error. No se pudo determinar el tipo de disco.", 48, "MILLENNIUM CONSULTING")
		ELSE
			IF (tipodisco = 2 OR tipodisco = 5) AND DISKSPACE(JUSTDRIVE(directorio))<=0 THEN
				MESSAGEBOX("Error. No hay un disco dentro de la unidad que usted especific o bien el disco no tiene espacio disponible.", 48, "MILLENNIUM CONSULTING")
			ELSE
				IF (NOT LEEVARBOOLDEFECTO('XRESPALDOESTILONUEVO',.F.)) AND (NOT (ALLTRIM(UPPER(directorio)) == "A:\")) THEN
					MESSAGEBOX("La versin de MILLENNIUM GESTION que usted ha adquirido slo puede hacer respaldo en el directorio raz del disco A: Si desea poder respaldos en cualquier directorio de cualquier disco, pngase en contacto con MILLENNIUM CONSULTING.", 48, "MILLENNIUM CONSULTING")
				ELSE
					IF FILE(rutaarchivo) THEN
				    	DELETE FILE &rutaarchivo
					ENDIF
					*CREATE TABLE 	
					IF recursivo THEN
						reclet = 'r'
					ELSE
						reclet = ''
					ENDIF
					codeline = dirraiz+"pkzip.exe -"+reclet+"p "+ rutaarchivo + " "+ diraguardar+"*.dbf "+diraguardar+"*.cdx"
					RUN &codeline
					MESSAGEBOX("Proceso de respaldo finalizado.",48,"MILLENNIUM CONSULTING")
				ENDIF		
			ENDIF
		ENDIF
	ENDIF
ENDPROC

PROCEDURE RECUPERABACKUP(dirarecuperar)
&& Si recursivo, no slo se guarda el directorio actual sino todos los subdirectorios
&& Si alguno de los parmetros meses o los parmetros anyos es 0, eso quiere decir todos lod meses definidos
&& Modo movimientos ser 0 - toda la informacin, 1 - tabla de movimientos
&& Por ahora, la opcin de meses y modomovimientos no estn implementadas
	LOCAL directorio, tipodisco
	
	rutaarchivo = GETFILE('ZIP','Recuperar respaldo')
	IF NOT EMPTY(rutaarchivo) THEN
		directorio = JUSTPATH(rutaarchivo)
		tipodisco = DRIVETYPE(JUSTDRIVE(directorio))
		IF tipodisco = 1 THEN
			MESSAGEBOX("Error. No se pudo determinar el tipo de disco.", 48, "MILLENNIUM CONSULTING")
		ELSE
			IF (tipodisco = 2 OR tipodisco = 5) AND DISKSPACE(JUSTDRIVE(directorio))<=0 THEN
				MESSAGEBOX("Error. No hay un disco dentro de la unidad que usted especific o bien el disco no tiene espacio disponible.", 48, "MILLENNIUM CONSULTING")
			ELSE
				IF (NOT LEEVARBOOLDEFECTO('XRESPALDOESTILONUEVO',.F.)) AND (NOT (ALLTRIM(UPPER(directorio)) == "A:\")) THEN
					MESSAGEBOX("La versin de MILLENNIUM GESTION que usted ha adquirido slo puede recuperar el respaldo desde el directorio raz del disco A: Si desea poder recuperar respaldos en cualquier directorio, pngase en contacto con MILLENNIUM CONSULTING.", 48, "MILLENNIUM CONSULTING")
				ELSE
					codeline = dirraiz+"pkunzip.exe -d "+ rutaarchivo + dirarecuperar
					MESSAGEBOX(codeline)
					RUN &codeline
					MESSAGEBOX("Proceso de restauracin finalizado.",64,"MILLENNIUM CONSULTING")			
				ENDIF		
			ENDIF
		ENDIF
	ENDIF
ENDPROC

PROCEDURE GRAFICOS(funcion)
	DO CASE
		CASE MODULO = 1
			DO FORM GRAFICOS.SCX WITH funcion, 'COGR001'
		CASE MODULO = 2
			DO FORM GRAFICOS.SCX WITH funcion, 'BAGR001'
		CASE MODULO = 3
			DO FORM GRAFICOS.SCX WITH funcion, 'IVGR001'
		CASE MODULO = 4
			DO FORM GRAFICOS.SCX WITH funcion, 'INGR001'
		CASE MODULO = 5
			DO FORM GRAFICOS.SCX WITH funcion, 'PLGR001'
	ENDCASE 
ENDPROC


*****************************************************************************
*                 			FUNCIONES DE MONEDA 		                    *
*                                                                           *
*****************************************************************************


FUNCTION CREARMATRICESMONEDA (moneda, primero, ultimo, matrizmoneda, matriz)
** Si moneda est en blanco, son todas las monedas.
** Las matrices deben estar creadas y en blanco. Se pasan por referencia
** "Matrizmoneda" contiene la matriz de las monedas y "matriz" las cotizaciones
** Retorna NULL si primero es mayor que ltimo, 0 si no hay moneda base, el cdigo de la moneda base si lo hay
	PRIVATE i, numeromonedas, numerocotizaciones
	LOCAL taula, usadacotizaciones, usadamonedas, monedabase, filtro100, filtro110 
	RECORDARCODIGO()
	
	IF primero > ultimo THEN
		RETURN NULL
	ELSE
		&& Llena la matriz de monedas
		taula = ALIAS()
		usadamonedas = .T.
		usadacotizaciones = .T.
	
		IF NOT USED('CFMT0100') THEN
			USE (dirraiz+"CONFIG\CFMT0100.DBF") IN 0 ALIAS CFMT0100
			usadamonedas = .F.
		ENDIF
	
		SELE CFMT0100
		
		IF EMPTY(moneda) THEN
			cFiltrando = "SET FILTER TO empresa = "+STR(nCodigo)
			&cFiltrando
		ELSE
			cFiltrando = "SET FILTER TO codigo = "+ STR(moneda) +" AND empresa = "+STR(nCodigo)
			&cFiltrando
		ENDIF
		LOCATE
	
		SET ORDER TO codigo
		i = 1
		DIMENSION matrizmoneda(1,5)
		monedabase = 0 
		GO TOP
		DO WHILE NOT EOF() THEN
			matrizmoneda(i,3) = cfmt0100.codigo
			matrizmoneda(i,2) = cfmt0100.nomsing
			matrizmoneda(i,1) = cfmt0100.nomplural
			matrizmoneda(i,4) = cfmt0100.base
			matrizmoneda(i,5) = .F.
			IF cfmt0100.base THEN
				monedabase = cfmt0100.codigo
			ENDIF
			SKIP
			i = i+1
			DIMENSION matrizmoneda (i,5)
		ENDDO
		numeromonedas = i-1
		
		IF NOT usadamonedas THEN
			SELE CFMT0100
			USE
		ENDIF	
	
		&&Llena la matriz de cotizaciones
	
		IF NOT USED('CFMT0110') THEN
			USE (dirraiz+"CONFIG\CFMT0110.DBF") IN 0 ALIAS CFMT0110
			usadacotizaciones = .F.
		ENDIF
	
		SELE CFMT0110
		
		SET ORDER TO codidesde
		IF EMPTY(moneda) THEN
			cFiltrando = "SET FILTER TO empresa = "+STR(nCodigo)
			&cFiltrando
		ELSE
			cFiltrando = "SET FILTER TO codigo = "+ STR(moneda) +" AND empresa = "+STR(nCodigo)
			&cFiltrando
		ENDIF
		LOCATE
		i = 1
	
		DIMENSION matriz(1,5)
		IF NOT EMPTY(monedabase) THEN
			LLENAYAVANZALINEAMATRIZCOTIZACIONES(@matriz, monedabase, primero, ultimo, 1.00, .T.)
			MARCAMONEDA(monedabase, @matrizmoneda)
		ENDIF
		GO TOP
		DO WHILE NOT EOF()
			monedaactual = cfmt0110.codigo
			MARCAMONEDA(monedaactual, @matrizmoneda)
			primeroactual = primero		
			ultimoactual = ultimo		
			DO WHILE NOT EOF() AND codigo = monedaactual AND empresa = nCodigo AND primero <= ultimo
											
				IF HASTAMAYOROIGUALQUE(primero) THEN
					IF DESDEMENOROIGUALQUE(primero) THEN
						minimo = MENORENTREHASTAY(ultimo) 
						LLENAYAVANZALINEAMATRIZCOTIZACIONES(@matriz,monedaactual,primero, minimo, cfmt0110.tipocambio, .T.)
						primero = minimo+1
						SKIP
					ELSE
						minimo = MENORENTREDESDEMENOSUNOY(ultimo)
						LLENAYAVANZALINEAMATRIZCOTIZACIONES(@matriz,monedaactual,primero, minimo, 0.00, .F.)
						primero = minimo +1 
					ENDIF	
				ELSE
					SKIP
				ENDIF
			ENDDO
			
			IF primero <= ultimo THEN
				LLENAYAVANZALINEAMATRIZCOTIZACIONES(@matriz,monedaactual,primero, ultimo, 0.00, .F.)
			ENDIF
			
			*Salta los registros hasta la siguiente moneda
			LOCATE FOR codigo <> monedaactual AND empresa = nCodigo REST
			
			primero	= primeroactual 
			ultimo	= ultimoactual 
		ENDDO
		** Para las monedas que no tienen cotizaciones, se ponen todas a indefinido
	
		FOR k = 1 TO numeromonedas
			IF NOT matrizmoneda(k,5) THEN
				LLENAYAVANZALINEAMATRIZCOTIZACIONES(@matriz,matrizmoneda(k,3),primero, ultimo, 0.00, .F.)
			ENDIF
		ENDFOR
		numerocotizaciones = i - 1
	
		IF numeromonedas > 0 THEN
			DIMENSION matrizmoneda(numeromonedas,5)
		ENDIF
	
		IF numerocotizaciones > 0 THEN
			DIMENSION matriz(numerocotizaciones,5)
		ENDIF
		
		
		IF NOT usadacotizaciones THEN
			SELE CFMT0110
			USE
		ENDIF
		IF NOT EMPTY(taula) THEN
			SELE (taula)
		ENDIF
		
		RETURN monedabase 
	ENDIF
ENDFUNC

PROCEDURE LLENAYAVANZALINEAMATRIZCOTIZACIONES(matr, moned, fecha1, fecha2, tipoc, esdefinido)
	matr(i,1) = moned
	matr(i,2) = fecha1
	matr(i,3) = fecha2
	matr(i,4) = IIF(esdefinido,tipoc,0.00)
	matr(i,5) = esdefinido
	i = i+1
	DIMENSION matr(i,5)
ENDPROC

PROCEDURE MARCAMONEDA(moneda, mat)
	LOCAL j
	j = 1 
	DO WHILE j <= numeromonedas AND mat(j,3) <> moneda
		j = j+1
	ENDDO
	IF mat(j,3) =  moneda THEN
		mat(j,5) = .T.
	ENDIF
ENDPROC 

FUNCTION DESDEMENOROIGUALQUE(d)
	RETURN ((NOT EMPTY(cfmt0110.desde)) AND  (cfmt0110.desde <= d)) OR EMPTY(cfmt0110.desde)
ENDFUNC


FUNCTION HASTAMAYOROIGUALQUE(d)
	RETURN ((NOT EMPTY(cfmt0110.hasta)) AND(cfmt0110.hasta >= d)) OR EMPTY(cfmt0110.hasta)
ENDFUNC

FUNCTION MENORENTREHASTAY(d) 
	IF EMPTY(cfmt0110.hasta) THEN
		RETURN d
	ELSE
		IF d <= cfmt0110.hasta THEN
			RETURN d
		ELSE
			RETURN cfmt0110.hasta
		ENDIF
	ENDIF
ENDFUNC

FUNCTION MENORENTREDESDEMENOSUNOY(d)
	IF EMPTY(cfmt0110.desde) THEN
		RETURN cfmt0110.desde && Este caso nunca se dar
	ELSE
		IF d <= cfmt0110.desde-1 THEN
			RETURN d
		ELSE
			RETURN cfmt0110.desde-1
		ENDIF
	ENDIF
ENDFUNC

FUNCTION CALCULATIPOCAMBIOMATRIZ (matriz, lamoneda, lafecha) 
	LOCAL filas, it
	filas = ALEN(matriz,1)
	it = 1
	DO WHILE (it <= filas) AND (NOT (matriz(it,1) = lamoneda AND BETWEEN(lafecha, matriz(it,2),matriz(it,3))))
		it = it+1
	ENDDO
	IF it <= filas THEN 
		RETURN matriz(it,4)
	ELSE
		RETURN 0.00
	ENDIF
ENDFUNC

FUNCTION CALCULATIPOCAMBIOREPORTE (matriz, lamoneda, lafecha) 
	IF W_TIPOCAMBIOREP = -1 THEN
		RETURN CALCULATIPOCAMBIOMATRIZ (@matriz, lamoneda, lafecha) 
	ELSE
		RETURN W_TIPOCAMBIOREP
	ENDIF
ENDFUNC

FUNCTION EXISTEMONEDABASE 
	LOCAL taula
	taula = ALIAS()
	IF NOT FILE(dirraiz+"CONFIG\CFMT0100.DBF") THEN
		RETURN .F.
	ELSE
		RECORDARCODIGO()
		USE (dirraiz+"CONFIG\CFMT0100.DBF") IN 0 ALIAS CFMT0100
		SELE CFMT0100
		LOCATE FOR base AND empresa = nCodigo 
		haymonedabase = FOUND()
		USE
		RETURN haymonedabase 
	ENDIF
	IF NOT EMPTY(taula) THEN
		SELE (taula)
	ENDIF
ENDFUNC

FUNCTION NOMBREMONEDASINGULAR(codigomon)
	LOCAL nombremon, taula, usado
	taula = ALIAS()
	RECORDARCODIGO()
	usado = USED('CFMT0100')
	IF NOT usado THEN
		USE (dirraiz+"CONFIG\CFMT0100.DBF") IN 0 ALIAS CFMT0100
	ENDIF
	SELE CFMT0100
	LOCATE FOR codigo = codigomon AND empresa = nCodigo
	nombremon = ALLTRIM(cfmt0100.nomsing)	
	IF NOT usado THEN
		USE
	ENDIF
	IF NOT EMPTY(taula) THEN
		SELE (taula)
	ENDIF
	RETURN nombremon
ENDFUNC

FUNCTION NOMBREMONEDASINGULARMATRIZ(codigomon, matriz)
	LOCAL nombremon, filas, il
	il = 1
	filas = ALEN(matriz,1)
	DO WHILE il <= filas AND matriz(il,3) <> codigomon
		il = il+1
	ENDDO
	IF il > filas THEN
		MESSAGEBOX("Error. No se encuentra el nombre de moneda", 48, "MILLENNIUM CONSULTING")
	ELSE
		RETURN matriz(il,2)
	ENDIF
ENDFUNC

FUNCTION NOMBREMONEDAPLURAL(codigomon)
	LOCAL nombremon, taula, usado
	taula = ALIAS()
	RECORDARCODIGO()
	usado = USED('CFMT0100')
	IF NOT usado THEN
		USE (dirraiz+"CONFIG\CFMT0100.DBF") IN 0 ALIAS CFMT0100
	ENDIF
	SELE CFMT0100
	LOCATE FOR codigo = codigomon AND empresa = nCodigo
	nombremon = ALLTRIM(cfmt0100.nomplural)	
	IF NOT usado THEN
		USE
	ENDIF
	IF NOT EMPTY(taula) THEN
		SELE (taula)
	ENDIF
	RETURN nombremon
ENDFUNC

FUNCTION NOMBREMONEDAPLURALMATRIZ(codigomon, matriz)
	LOCAL nombremon, filas, il
	il = 1
	filas = ALEN(matriz,1)
	DO WHILE il <= filas AND matriz(il,3) <> codigomon
		il = il+1
	ENDDO
	IF il > filas THEN
		MESSAGEBOX("Error. No se encuentra el nombre de moneda", 48, "MILLENNIUM CONSULTING")
	ELSE
		RETURN matriz(il,1)
	ENDIF
ENDFUNC


FUNCTION CONVERTIRTABLANUEVOTIPOCAMBIO(nomtabla, listacamposmoneda, condicion, tiponuevo, monedanueva)
	LOCAL tla, fltr, nrcn, usd, condicion2, condicion3
	RECORDARCODIGO()
	usd = .T.
	tla = ALIAS()
	IF NOT USED(nomtabla) THEN
		USE (nomtabla) IN 0 ALIAS (nomtabla)
		usd = .F.
	ENDIF
	SELE (nomtabla)
	nrcn = GUARDANUMEROREGISTRO()	
	
	condicion2 = condicion +" AND tipocambio <> "+EXTSTR(tiponuevo)+ " AND empresa = "+ STR(nCodigo)
	condicion3 = condicion +" AND cmoneda <> "+STR(monedanueva)+ " AND empresa = "+ STR(nCodigo)
	
	listacampos = ALLTRIM(listacamposmoneda)+","
	expresioncampos = ""
	poscoma = AT(",",listacampos)
	DO WHILE poscoma <> 0 AND NOT EMPTY(listacampos) THEN
		campo = ALLTRIM(SUBSTR(listacampos,1, poscoma -1))
		IF NOT EMPTY(campo) THEN
			expresioncampos = expresioncampos+" "+campo+" WITH ROUND("+campo+"* tipocambio,2)/"+EXTSTR(tiponuevo)+","
		ENDIF
		listacampos = ALLTRIM(SUBSTR(listacampos, poscoma+1))
		poscoma = AT(",",listacampos)
	ENDDO
	expresioncampos = expresioncampos+" tipocambio WITH "+EXTSTR(tiponuevo)
	
	WREPLACEALL(expresioncampos,condicion2) 
	WREPLACEALL('cmoneda WITH '+STR(monedanueva),condicion3)
	
	RECUPERANUMEROREGISTRO(nrcn)	
	
	IF NOT usd THEN
		USE
	ENDIF
	IF NOT EMPTY(tla) THEN
		SELE (tla)
	ENDIF
	
ENDFUNC

FUNCTION CREACOTIZACIONESREPORTE(ltmoneda, inicio, final)
	LOCAL basura2, longmatriz, itr, merror
	
	IF W_TIPOCAMBIOREP > 0 THEN
		RETURN .T.
	ELSE	
		DIMENSION BASURA(1)
		basura2 = CREARMATRICESMONEDA(ltmoneda,inicio, final, @basura,@W_COTIZAREP)
		longmatriz = ALEN(W_COTIZAREP,1)
		merror = .F.	
		FOR itr = 1 TO longmatriz
			IF W_COTIZAREP(itr,5) = .F. THEN
				merror = .T.
			ENDIF
		ENDFOR
		RETURN NOT(merror)
	ENDIF
ENDFUNC

FUNCTION INTERVALOCONELMISMOTIPOCAMBIO(moneda, fechainicial, fechafinal)
	** Mira si las monedas no cambian de tipo de cambio durante el rango de las dos fechas.
	** Si moneda est en blanco, son todas las monedas.
	  LOCAL i, basura, basura2, longitud
	  DIMENSION W_COTIZATEMP(1,5)
	  
	  basura2 = CREARMATRICESMONEDA(moneda,fechainicial, fechafinal, @basura, @W_COTIZATEMP)
	  
	  longitud = ALEN(W_COTIZATEMP,1)
	  IF longitud = 0 THEN
	  	RETURN .T.
	  ELSE
	  	monedaanterior = W_COTIZATEMP(1,1)  
	  	cambioanterior = W_COTIZATEMP(1,4)  
	  	igualcambio = .T.
	 	i = 2
	 	DO WHILE i <= longitud AND igualcambio  
	  		igualcambio = W_COTIZATEMP(i,5) AND ((monedaanterior <> W_COTIZATEMP(i,1)) OR (cambioanterior = W_COTIZATEMP(i,4)))
	  		monedaanterior = W_COTIZATEMP(i,1)  
	  		cambioanterior = W_COTIZATEMP(i,4)  
	  		i = i+1
	  	ENDDO
	  	RETURN igualcambio
	  ENDIF
ENDFUNC


*** Funciones para traducir moneda

PROCEDURE TRADUCETABLAMONEDAGAMMA(tablainicial,tablafinal,lamoneda, tipcam, matrizcotizaciones, campofecha, listacamposcantidad, filtro)
	** Si no se especifica tablafinal, la tabla se guarda en el directorio temp del directorio raiz con el mismo nombre.
	** Si tipocambio es -1 utiliza matrizcotizaciones, si no utiliza tipo cambio
	
	LOCAL aliasinicial, aliasfinal, escursor, usadainicial, it
	
	RECORDARCODIGO()
	aliasinicial = JUSTSTEM(tablainicial)

	IF EMPTY(tablafinal) THEN
		tablafinal = dirtemp+aliasinicial
	ELSE
		IF AT("\",tablafinal) = 0 THEN
			tablafinal = dirtemp+tablafinal
		ENDIF
	ENDIF

	aliasfinal = "WX"+aliasinicial
	
	usadainicial = .T.

	
	IF NOT USED(aliasinicial) THEN
		USE (tablainicial) IN 0 ALIAS (aliasinicial)
		usadainicial = .F.
	ENDIF
	
	SELE (aliasinicial)
	
	*filtro = IIF(EMPTY(filtro),'empresa = '+STR(nCodigo),'empresa = '+STR(nCodigo)+' AND '+filtro)
	*********


	comando = 'COPY TO '+tablafinal+IIF(EMPTY(filtro),'',' FOR '+filtro)+' WITH CDX'
	&comando

	
	IF NOT usadainicial THEN
		USE 
	ENDIF
	
	USE (tablafinal) IN 0 ALIAS (aliasfinal)
	SELE (aliasfinal)
	
	IF tipcam <> -1 THEN
		REEMPLAZATABLAACTUALMONEDA(listacamposcantidad, lamoneda, tipcam,3,"")
	ELSE
		REEMPLAZATABLAACTUALMONEDA(listacamposcantidad, lamoneda, tipcam,1,"")
		numcotiza = ALEN(matrizcotizaciones,1)
		FOR it = 1 TO numcotiza
			filtrofecha = 'BETWEEN('+campofecha+',CTOD("'+DTOC(matrizcotizaciones(it,2))+'"),CTOD("'+DTOC(matrizcotizaciones(it,3))+'"))'
			REEMPLAZATABLAACTUALMONEDA(listacamposcantidad, lamoneda, matrizcotizaciones(it,4),2, filtrofecha)
		ENDFOR
	ENDIF
	USE
ENDPROC

PROCEDURE TRADUCETABLAMONEDADELTA(tablainicial,tablafinal,lamoneda, tipcam, matrizcotizaciones, campofecha, listacamposcantidad, filtro)&&, tablamovimientos, campossumables, camposumariza, campocantidadinicial, campocantidadfinal, fechamesinicial, fechamesfinal)
	** Modo O. Fecha o proceso, segn XPROCESODELTADEFECTO.
	** Modo 1. Slo fecha	
	LOCAL aliasinicial, aliasfinal, usadainicial
	RECORDARCODIGO()

	aliasinicial = JUSTSTEM(tablainicial)
	IF EMPTY(tablafinal) THEN
		tablafinal = dirtemp+aliasinicial
	ELSE
		IF AT("\",tablafinal) = 0 THEN
			tablafinal = dirtemp+tablafinal
		ENDIF
	ENDIF
	
	aliasfinal = "WX"+aliasinicial
	
	usadainicial = .T.

	IF NOT USED(aliasinicial) THEN
		USE (tablainicial) IN 0 ALIAS (aliasinicial)
		usadainicial = .F.
	ENDIF
	
	SELE (aliasinicial)
	
	*filtro = IIF(EMPTY(filtro),'empresa = '+STR(nCodigo),'empresa = '+STR(nCodigo)+' AND '+filtro)
		
	comando = 'COPY TO '+tablafinal+IIF(EMPTY(filtro),'',' FOR '+filtro)+' WITH CDX'
	&comando
	
	IF NOT usadainicial THEN
		USE 
	ENDIF
	
	IF tipcam <> -1 THEN
		USE (tablafinal) IN 0 ALIAS (aliasfinal)
		SELE (aliasfinal)
		REEMPLAZATABLAACTUALMONEDA(listacamposcantidad, lamoneda, tipcam, 0,"")
		USE
	ELSE
		IF INTERVALOCONELMISMOTIPOCAMBIO('', fechamesinicial, fechamesfinal) THEN
			eltipoc = CALCULATIPOCAMBIOMATRIZ (@matrizcotizaciones, lamoneda, fechainicial) 
			USE (tablafinal) IN 0 ALIAS (aliasfinal)
			SELE (aliasfinal)
			REEMPLAZATABLAACTUALMONEDA(listacamposcantidad, lamoneda, eltipcom, 0,"")
			USE
		*ELSE
		*	TRADUCETABLAMONEDADELTASEGUNCOTIZACIONES(tablainicial,tablafinal,lamoneda, tipcam, @matrizcotizaciones, campofecha, listacamposcantidad, filtro, tablamovimientos, campossumables, camposumariza, campocantidadinicial, campocantidadfinal, fechamesinicial, fechamesfinal)
		ENDIF
	ENDIF
ENDPROC



*PROCEDURE TRADUCETABLAMONEDADELTASEGUNCOTIZACIONES(tablainicial,tablafinal,lamoneda, tipcam, matrizcotizaciones, campofecha, listacamposcantidad, filtro, tablamovimientos, campossumables, camposumariza, campocantidadinicial, campocantidadfinal, fechamesinicial, fechamesfinal)
	
*	** Arregla el formato de algunos parmetros
*	campossumables = campossumables +","
*	aliasinicial = ALLTRIM(JUSTSTEM(tablainicial))	
*	aliasfinal = ALLTRIM(JUSTSTEM(tablafinal))
*	aliasmovimientos = ALLTRIM(JUSTSTEM(tablamovimientos))
*	camposumariza = ALLTRIM(UPPER(camposumariza))
*	campossumables = ALLTRIM(UPPER(campossumables))
*	campossumablesinicio = campossumables
*	campocantidadinicial = ALLTRIM(UPPER(campocantidadinicial))
*	campocantidadfinal = ALLTRIM(UPPER(campocantidadfinal))
*	eltipoc = CALCULATIPOCAMBIOMATRIZ (@matrizcotizaciones, lamoneda, fechamesinicial) 
*	campossumablessinsigno = STRTRAN(STRTRAN(campossumables, '+', ''),'-','')
	
	** Se abre la tablainicial y se guarda el nombre de los campos que no son el de cantidadinicial, ni final, ni sumables
*	usadainicial = USED(aliasinicial)
*	IF NOT usadainicial THEN
*		USE (tablainicial) IN 0 ALIAS (aliasinicial)
*	ENDIF

*	SELE (aliasinicial)
*	listacamposnormales = ''
*	numerocampos = AFIELDS(matrizcampos)
*	FOR i = 1 TO numerocampos
*		elcampo = matrizcampos(i,1)
*		IF (ATC(ALLTRIM(UPPER(elcampo)), campossumablesinicio) = 0) AND (NOT(ALLTRIM(UPPER(elcampo)) == campocantidadinicial)) AND (NOT (ALLTRIM(UPPER(elcampo)) == campocantidadfinal)) THEN
*			listacamposnormales = listacamposnormales+aliasinicial+'.'+elcampo+","
*		ENDIF
*	ENDFOR
	
*	IF NOT usadainicial THEN
*		USE 
*	ENDIF
				
	** Se hace el proceso 
*	parteselect1 = ''
*	parteselect2 = ''
*	parteselect3 = ''
	
*	poscoma = AT(",", campossumables)
*	campoatratar = ALLTRIM(SUBSTR(campossumables, 1, poscoma -1))
*	DO WHILE NOT EMPTY(campoatratar)
		&& Se separa el campo del signo
*		primercaracter = SUBSTR(campoatratar,1,1)
*		IF primercaracter = '-' OR primercaracter = '+' THEN
*			signo = primercaracter
*			campoatratar = ALLTRIM(SUBSTR(campoatratar,2))
*		ELSE
*			signo = '+'
*		ENDIF
		
		&&Se construyen los strings

*		parteselect1 = parteselect1+' SUM ('+campoatratar+') AS '+campoatratar+' ,'
*		parteselect2 = parteselect2+'IIF(ISNULL(tempbamov2.'+campoatratar+'),0.00000000,tempbamov2.'+campoatratar+') AS '+ campoatratar + ', '
*		parteselect3 = parteselect3+signo+'tempbamov2.'+campoatratar
		
		&& Se obtiene el siguiente campo		
*		campossumables = SUBSTR(campossumables, poscoma+1)
*		poscoma = AT(",", campossumables)
*		campoatratar = ALLTRIM(SUBSTR(campossumables, 1, poscoma-1))
*	ENDDO
	
		 
	** Se traducen los movimientos segn las cotizaciones 
	
*	TRADUCETABLAMONEDAGAMMA(tablamovimientos,'wtabmovi',lamoneda, tipcam, @matrizcotizaciones, campofecha, campossumablessinsigno, filtro)
	
*	USE (dirtemp+"wtabmovi") IN 0 ALIAS wtabmovi

	
	** Se "sumarizan" todos los movimientos para extraer una tabla de cargos y abonos para cada cuenta que tiene movimientos
*	comando = ' SELECT '+ parteselect1 +" "+camposumariza +' FROM wtabmovi INTO TABLE '+dirtemp+'tempbamov2 WHERE '+filtro+' GROUP BY '+camposumariza
*	&comando
*	BROWSE
	** A partir de esa tabla, se crea una tabla con saldo inicial, cargos, abonos y saldo actual de todas las cuentas.	
	
*	filtro2 = 'POSTERIOROIGUALMES('+aliasinicial+'.nmes,'+aliasinicial+'.anyo,'+ STR(MONTH(fechamesinicial))+', '+STR(YEAR(fechamesinicial))+') AND POSTERIOROIGUALMES('+STR(MONTH(fechamesfinal))+','+STR(YEAR(fechamesfinal))+', '+aliasinicial+'.nmes, '+aliasinicial+'.anyo)'
*	MESSAGEBOX(filtro2)
	
*	comando = 'SELECT '+listacamposnormales+' IIF(ISNULL('+aliasinicial+'.'+campocantidadinicial+'* eltipoc),0.00000000,'+aliasinicial+'.'+campocantidadinicial+'* eltipoc) AS '+campocantidadinicial+','+;
*	+parteselect2+'IIF(ISNULL(('+aliasinicial+'.'+ campocantidadinicial+'* eltipoc)'+parteselect3+'),0.00000000,('+aliasinicial+'.'+campocantidadinicial+'* eltipoc)'+parteselect3+') AS '+campocantidadfinal+;
*	+' FROM '+ aliasinicial+' LEFT OUTER JOIN tempbamov2 ON '+aliasinicial+'.'+camposumariza+' = tempbamov2.'+camposumariza+;
*	+' INTO TABLE '+ tablafinal +' WHERE '+ filtro2+ ' ORDER BY '+aliasinicial+'.'+camposumariza
*	&comando
*	MESSAGEBOX('segundoselect'+CHR(13)+comando)
*	BROWSE
*	comando = 'INDEX ON '+camposumariza+' TAG '+ camposumariza
*	&comando	
*	*LEFT OUTER JOIN

	** Se cierran las tablas temporales que hemos utilizado 
	
*	SELE wtabmovi
*	USE
*	SELE tempbamov2
*	USE
*ENDPROC

PROCEDURE TRADUCETABLAMONEDABETA(tablainicial,tablafinal, matrizcotizaciones, listacamposcantidad, filtro, agregacampotipocambio)
	** Si no se especifica tablafinal, la tabla se guarda en el directorio temp del directorio raiz con el mismo nombre.
	** Si tipocambio es -1 utiliza matrizcotizaciones, si no utiliza tipo cambio
	
	LOCAL aliasinicial, aliasfinal, escursor, usadainicial, it
	
	IF PCOUNT () <6 THEN
		agregacampotipocambio = .F.
	ENDIF
	
	RECORDARCODIGO()
	aliasinicial = JUSTSTEM(tablainicial)

	IF EMPTY(tablafinal) THEN
		tablafinal = dirtemp+aliasinicial
	ELSE
		IF AT("\",tablafinal) = 0 THEN
			tablafinal = dirtemp+tablafinal
		ENDIF
	ENDIF
	
	aliasfinal = "WX"+aliasinicial
	
	usadainicial = .T.

	IF NOT USED(aliasinicial) THEN
		USE (tablainicial) IN 0 ALIAS (aliasinicial)
		usadainicial = .F.
	ENDIF
	
	SELE (aliasinicial)
	
	*filtro = IIF(EMPTY(filtro),'empresa = '+STR(nCodigo),'empresa = '+STR(nCodigo)+' AND '+filtro)
	
	comando = 'COPY TO '+tablafinal+IIF(EMPTY(filtro),'',' FOR '+filtro)+' WITH CDX'
	&comando
	
	IF NOT usadainicial THEN
		USE 
	ENDIF
	
	
	IF agregacampotipocambio THEN
		ALTER TABLE (tablafinal) ADD COLUMN tipocambio N(12,4)
		USE
	ENDIF
		
	USE (tablafinal) IN 0 ALIAS (aliasfinal)
	SELE (aliasfinal)
	
	numcotiza = ALEN(matrizcotizaciones,1)
	FOR it = 1 TO numcotiza
		REEMPLAZATABLAACTUALMONEDA(listacamposcantidad, matrizcotizaciones(it,1), matrizcotizaciones(it,4),4, 'cmoneda = '+STR(matrizcotizaciones(it,1)))
	ENDFOR
	USE
	
ENDPROC

PROCEDURE REEMPLAZATABLAACTUALMONEDA(listacampos, lmoneda, tipcamb, modo, condicion)
	* Modo 0: (Aplicable normalmente a tablas tipo Delta) Aplica a todas las monedas pero con igual poltica.
	* Modo 1: (Tablas tipo Gamma) Solo aplica a la misma moneda con poltica de misma moneda
	* Modo 2: (Tablas tipo Gamma) Solo aplica a la otra moneda con la poltica de la otra moneda
	* Modo 3: (Tablas tipo Gamma) Aplica a todas las monedas pero con diferente poltica
	* Modo 4: (Tablas tipo Beta) Aplica a todas las monedas con poltica de misma moneda. Adems rellena el campo de tipocambio
		
	LOCAL expresionmismamoneda, expresionotramoneda, poscoma, campo, esmisma, esotra
	esmisma = (modo = 1) OR (modo = 3) 
	esotra = (modo = 2) OR (modo = 3)
	 
	listacampos = ALLTRIM(listacampos)+","
	expresionmismamoneda = ""
	expresionotramoneda = ""
	expresionmonedabeta = ""
	poscoma = AT(",",listacampos)
	DO WHILE poscoma <> 0 AND NOT EMPTY(listacampos) THEN
		campo = ALLTRIM(SUBSTR(listacampos,1, poscoma -1))
		IF NOT EMPTY(campo) THEN
			expresionmismamoneda = expresionmismamoneda+" "+campo+" WITH ROUND("+campo+"* tipocambio,2),"
			expresionotramoneda = expresionotramoneda +" "+campo+" WITH ROUND("+campo+"* tipcamb,2),"
			expresionmonedabeta = expresionmonedabeta +" "+campo+" WITH "+campo+"/ tipcamb,"
		ENDIF
		listacampos = ALLTRIM(SUBSTR(listacampos, poscoma+1))
		poscoma = AT(",",listacampos)
	ENDDO
	
	expresionmismamoneda = ALLTRIM(expresionmismamoneda)
	expresionotramoneda = ALLTRIM(expresionotramoneda)
	expresionmismamoneda = SUBSTR(expresionmismamoneda, 1, LEN(expresionmismamoneda)-1)
	expresionotramoneda = SUBSTR(expresionotramoneda, 1, LEN(expresionotramoneda)-1)
	
	IF esmisma THEN
		comando = "REPLACE ALL "+ expresionmismamoneda+ " FOR cmoneda = lmoneda"+IIF(EMPTY(condicion),'',' AND '+condicion)
		&comando
	ENDIF
	IF esotra THEN
		comando = "REPLACE ALL "+ expresionotramoneda+ " FOR cmoneda <> lmoneda"+IIF(EMPTY(condicion),'',' AND '+condicion)
		&comando
	ENDIF
	IF modo = 0 THEN
		comando = "REPLACE ALL "+ expresionotramoneda+IIF(EMPTY(condicion),'',' FOR '+condicion)
		&comando
	ENDIF
	IF modo = 4 THEN
		expresionmonedabeta = expresionmonedabeta+" tipocambio WITH tipcamb,"
		expresionmonedabeta = ALLTRIM(expresionmonedabeta)
		expresionmonedabeta = SUBSTR(expresionmonedabeta, 1, LEN(expresionmonedabeta)-1)
		comando = "REPLACE ALL "+ expresionmonedabeta+IIF(EMPTY(condicion),'',' FOR '+condicion)
		&comando
	ENDIF
ENDPROC

PROCEDURE CREAVARIABLESMONEDAREP
	PUBLIC W_MONEDAREP, W_TIPOCAMBIOREP, W_LABELMONEDAREP
	PUBLIC ARRAY W_COTIZAREP(1)
	W_MONEDAREP = W_MONEDABASE
	W_TIPOCAMBIOREP =  1
	W_LABELMONEDAREP = "Moneda: "+PROPER(NOMBREMONEDAPLURAL(W_MONEDAREP))+" (moneda base)"
ENDPROC

PROCEDURE DESTRUYEVARIABLESMONEDAREP
	RELEASE W_MONEDAREP, W_TIPOCAMBIOREP, W_LABELMONEDAREP, W_COTIZAREP
ENDPROC

PROCEDURE DESTRUYEVARIABLESMONEDAREPFORM
	DESTRUYEVARIABLESMONEDAREP()
	IF USED('WBAMT0200') THEN
		SET RELATION OFF INTO WBAMT0200
    	SELE WBAMT0200
    	USE
    ENDIF
ENDPROC

PROCEDURE IGUALMONEDA(moneda1,moneda2)
	RETURN (ROUND(moneda1,2) = ROUND(moneda2,2))
ENDPROC

PROCEDURE MAYOROIGUALMONEDA(moneda1,moneda2)
	RETURN (moneda1 > moneda2 OR ROUND(moneda1,2) = ROUND(moneda2,2))
ENDPROC

PROCEDURE MENORMONEDA(moneda1,moneda2)
	RETURN  (moneda1 < moneda2) AND (ROUND(moneda1,2) <> ROUND(moneda2,2))
ENDPROC

PROCEDURE CONVIERTEMONEDAENBASE(lamoneda,eltipocambio)
	RETURN (lamoneda/eltipocambio)
ENDPROC

PROCEDURE CONVIERTEMONEDADESDEBASE(lamoneda,eltipocambio)
	RETURN (lamoneda*eltipocambio)
ENDPROC

PROCEDURE ADAPTAPATHENTORNODATOS(de)
	LOCAL ic, nomcursor, fuente, posprefijo
	IF NOT (ALLTRIM(UPPER(dirtemp)) == "C:\WINDOWS\TEMP\MGTMP\") OR OCCURS('\',FULLPATH(CURDIR())) <> 3 OR NOT (ALLTRIM(UPPER(SYS(5))) == "C:") THEN
		FOR ic = 1 TO 10
			nomcursor = "de.Cursor"+ALLTRIM(STR(ic))
			IF TYPE(nomcursor) <> 'U' THEN
				strfuente = nomcursor+".CursorSource"
				fuente = ALLTRIM(UPPER(&strfuente))
				posprefijo = AT ('WINDOWS\TEMP\MGTMP\', fuente)
				IF 	posprefijo <> 0 THEN
					comando = strfuente +' = "'+ dirtemp + SUBSTR(fuente, RAT('\', fuente) +1)+'"'
					&comando
				ENDIF	
			ENDIF
		ENDFOR
	ENDIF
ENDPROC

** Funciones empleadas en procesos de generacin tipo beta

PROCEDURE CREAMATRIZCOTIZABETA(lafecha, lamatriz)
	DIMENSION BASURA(1)
	CREARMATRICESMONEDA ('', lafecha, lafecha, @basura, @lamatriz)
ENDPROC


FUNCTION MONEDASTABLANODEFINIDAS(latabla, lafechaoperiodo, lamatriz)
	** Determina si la tabla tiene registros expresados en una moneda que no est definida en la matriz que se pasa (normalmente, una matriz de tipo beta con todas las cotizaciones de todas las monedas en un solo da).
	** La fechaoperiodo sirve para filtrar los registros de la tabla
	** Si lafechaoperiodo no es de tipo fecha  se supone que estamos en el mdulo de planilla. En ese caso, dicho parmetro indica una fecha.
	** En caso contrario, cualquier otro mdulo. En este caso, el periodo es indiferente.
	** La funcin devuelve la lista de monedas no definidas. Devuelve la cadena definida si todas las monedas estn definidas.
	LOCAL usada, numfilas, it, aliastabla, monedaserror, taula
	
	taula = ALIAS()
	
	monedaserror = ""
	usada = .T.
	aliastabla = JUSTSTEM(latabla)
	IF NOT USED(aliastabla) THEN
		usada = .F.
		USE (latabla) IN 0 ALIAS (aliastabla)
	ENDIF
	SELE (aliastabla)
	numfilas = ALEN(lamatriz,1)
	FOR it = 1 TO numfilas
		IF lamatriz(it,5) = .F. THEN
			IF EMPTY(lafechaoperiodo) THEN
				LOCATE FOR cmoneda = lamatriz(it,1) AND empresa = nCodigo 
			ELSE
				IF TYPE('lafechaoperiodo') = 'D' THEN
					LOCATE FOR cmoneda = lamatriz(it,1) AND empresa = nCodigo AND nmes = MONTH(lafechaoperiodo) AND anyo = YEAR(lafechaoperiodo)
				ELSE
					LOCATE FOR cmoneda = lamatriz(it,1) AND empresa = nCodigo AND periodo = lafechaoperiodo
				ENDIF
			ENDIF
			IF FOUND() THEN
				monedaserror = monedaserror+" "+NOMBREMONEDASINGULARMATRIZ(lamatriz(it,1),@W_MONEDAS)+","
			ENDIF
		ENDIF
	ENDFOR
	IF NOT usada THEN
		USE
	ENDIF
	IF NOT EMPTY(monedaserror) THEN
		monedaserror = SUBSTR(monedaserror,1,LEN(monedaserror)-1)
		monedaserror = ALLTRIM(monedaserror)
	ENDIF
	IF NOT EMPTY(taula) THEN
		SELE (taula)
	ENDIF
	RETURN monedaserror
ENDFUNC

** Fin de funciones empleadas en procesos de generacin tipo beta
FUNCTION NUMEROMAXIMOMONEDAS()
	LOCAL usado0100, taula, usadoempresas
	taula = ALIAS()
	usado0100 = USED(dirraiz+"CONFIG\CFMT0100")
	usadoempresas = USED(dirraiz+"CONFIG\EMPRESAS")
	IF NOT usado0100 THEN
		USE (dirraiz+"CONFIG\CFMT0100") IN 0 
	ENDIF
	IF NOT usadoempresas THEN
		USE (dirraiz+"CONFIG\EMPRESAS") IN 0 
	ENDIF
	maxmoned = 0 
	SELE EMPRESAS
	SCAN
		SELE CFMT0100
		COUNT FOR empresa = empresas.codigo TO monedaemp
		maxmoned = MAX(monedaemp, maxmoned)
		SELE EMPRESAS
	ENDSCAN
	IF NOT usadoempresas THEN
		SELE EMPRESAS
		USE
	ENDIF
	IF NOT usado0100 THEN
		SELE CFMT0100
		USE
	ENDIF
	IF NOT EMPTY(taula) THEN
		SELE (taula)
	ENDIF
	RETURN maxmoned
ENDFUNC

******* BUFFERING

FUNCTION GRABADATOSFORMULARIOSIMPLE
	LOCAL exito
	GRABARDATOSTABLAPRINCIPAL()
	exito = SAVEDATA('F')
	RETURN exito
ENDFUNC


PROCEDURE GRABARDATOSTABLAPRINCIPAL()
	IF M.ADIC THEN
		APPEND BLANK
		INSERT FROM MEMVAR
	ELSE
		GATHER MEMVAR
	ENDIF
ENDPROC


FUNCTION SAVEDATA(mode) &&'F'-form 'P'-process
	LOCAL totaltablas, tbuff, lSuccess
	IF XBUFFERING  = -1 THEN
		RETURN .T.
	ELSE
		** Recupera informacin sobre todas las tablas abiertas
		totaltablas = AUSED(tablasabiertas)
	
		** Actualiza todas las tablas abiertas con buffering optimista
		lSuccess = .T.
		itabla = 1 
		BEGIN TRANSACTION
		DO WHILE (itabla <=totaltablas) AND lSuccess
			tbuff = CURSORGETPROP("Buffering",tablasabiertas[itabla,1])
			IF (tbuff > 1) THEN
				lSuccess = TABLEUPDATE(1,.F.,tablasabiertas[itabla,1])
			ENDIF
			itabla = itabla + 1
		ENDDO
	
		** Si ha fallado alguna actualizacin, las deshace todas y vuelve a poner el buffer como estaba.
		IF lSuccess THEN
			END TRANSACTION
		ELSE
			DO CASE 
				CASE mode = 'F'
					MESSAGEBOX("No se pueden guardar los cambios ya que otro usuario ha manipulado los mismos datos que usted al mismo tiempo. Oprima el botn de Deshacer e intntelo de nuevo ms tarde.",48, "MILLENNIUM CONSULTING")
					ROLLBACK
					REVERTCURRENTRECORD(_VFP.ActiveForm.TablaPrincipal)
				CASE mode = 'P'
					MESSAGEBOX("Fallo al guardar los datos. Probablemente, otro usuario estaba manipulando los mismos datos que usted al mismo tiempo. Intente de nuevo ms tarde o bien pulse el botn de Cancelar.",48, "MILLENNIUM CONSULTING")
					ROLLBACK
					REVERTDATA()
			ENDCASE
		ENDIF
		RETURN lSuccess
	ENDIF
ENDFUNC

PROCEDURE REVERTDATA()
	LOCAL totaltablas, tbuff
	IF XBUFFERING  <> -1 THEN
		** Recupera informacin sobre todas las tablas abiertas
		totaltablas = AUSED(tablasabiertas)
	
		** Revierte la actualizacin de todas las tablas abiertas con buffering optimista
		FOR itabla = 1 TO totaltablas
			tbuff = CURSORGETPROP("Buffering",tablasabiertas[itabla,1])
			IF (tbuff > 1) THEN
				TABLEREVERT(.T.,tablasabiertas[itabla,1])
			ENDIF
		ENDFOR
	ENDIF
ENDPROC

PROCEDURE REVERTCURRENTRECORD(elalias)
	LOCAL nField, campo, valorantiguo, elaliasactual
	aliasactual = ALIAS()
	IF PCOUNT () = 0 THEN
		elalias = aliasactual
	ENDIF
	IF NOT EMPTY(elalias) THEN
		SELE (elalias)
		FOR nField = 1 TO FCOUNT(elalias)
			campo = FIELD(nField)
			valorantiguo =  OLDVAL(campo)
			comando = campo+" = valorantiguo"
			MESSAGEBOX(comando)	
			&comando
			IF NOT EMPTY(elaliasactual) THEN
				SELE (elaliasactual)
			ENDIF
		ENDIF
	ENDIF
ENDPROC

PROCEDURE SETBUFFERINGDE(de)
	LOCAL ic, nomcursor, fuente, posprefijo

	IF XBUFFERING <> -1 THEN
		FOR ic = 1 TO 200
			nomcursor = "de.Cursor"+ALLTRIM(STR(ic))
			IF TYPE(nomcursor) <> 'U' THEN
				comando = nomcursor+".BufferModeOverride = "+ ALLTRIM(STR(XBUFFERING))
				&comando
			ENDIF
		ENDFOR
	ENDIF
ENDPROC

*** Ayuda 
PROCEDURE VISUALIZAAYUDA()
	IF LEEVARBOOLDEFECTO("XAYUDA",.F.) THEN
		IF LEEVARNUMDEFECTO("XMODOAYUDA",0) = 0 
			HELP
		ELSE
			comando = "RUN /N START "+ (dirraiz+"Comun\AYUDA.CHM") &&HELP
			&comando
		ENDIF
	ELSE
		MESSAGEBOX("La ayuda no est activada.", 48, "MILLENNIUM CONSULTING")
	ENDIF
ENDPROC


** Espacio total y libre de un disco


FUNCTION StringToInteger
  LPARAMETER pcstring, plsigned
    
  LOCAL lnresult, lnlast, lni, llsigned,;
    lnmsb, lnmax
  lnresult = 0
  lnlast = LEN(pcstring)
  * Return Signed Integer?
  IF PCOUNT() = 2
    llsigned = plsigned
  ELSE
    llsigned = .F.
  ENDIF
  FOR lni = 1 TO lnlast
    lnresult = lnresult + ;
    ASC(SUBSTR(pcstring,lni,1)) * (256^(lni-1))
  NEXT
  IF llsigned
    lnmsb = (lnlast * 8) - 1
    IF BITTEST(lnresult, lnmsb)
      lnmax = (2 ^ (lnmsb + 1))
      lnresult = lnresult - lnmax
    ENDIF
  ENDIF
  RETURN lnresult
ENDFUNC


FUNCTION ESPACIOTOTALENDISCO(tDirectory) && Se le pasa un directorio y devuelve el espacio total.

	LOCAL espacio, currentdir, lcdir, lnresult, lccaller, lctotal,lcfree, lcmodule, lcprocname
	
	* Declaraciones de funciones API
  	DECLARE INTEGER GetModuleHandle IN Win32API STRING @lpModuleName
  	DECLARE INTEGER GetProcAddress IN Win32API INTEGER hModule, STRING @lpProcName
  	DECLARE SHORT GetDiskFreeSpaceEx IN Win32API STRING @lpDirectoryName, STRING @lpFreeBytesAvailableToCaller, STRING @lpTotalNumberOfBytes, STRING @lpTotalNumberOfFreeBytes
  	
  	STORE REPLICATE(CHR(0), 8) TO lccaller, lctotal, lcfree
  	
  	* Determina el directorio a que se le aplica 
  	currentdir = SYS(5)+CURDIR()
  	IF TYPE('tDirectory') = 'C'
     	lcdir = ADDBS(tDirectory)
    ELSE
    	* Si no se especific un directorio, se saca el espacio total de la unidad actual
    	lcdir = ADDBS(SYS(5))
   	ENDIF
   	lcdrive = JUSTDRIVE(lcdir)
    	
    lcmodule = "kernel32.dll"
  	lcprocname = "GetDiskFreeSpaceExA"
  	
  	IF GetProcAddress(GetModuleHandle(@lcmodule), @lcprocname) # 0
  		* Si el sistema operativo soporta la API DiskFreeSpaceEx se usa.
    	
    	IF GetDiskFreeSpaceEx(@lcdir, @lccaller, @lctotal, @lcfree) # 0
    		* Devuelve el espacio total. 
      		espacio = StringToInteger(lctotal)
   			RETURN espacio
      	ELSE
      		RETURN .NULL.
    	ENDIF
    ELSE
    	* En caso contrario se usa SYS(2020) que es un "wrapper" de la ms antigua GetDiskFreeSpace
    	* y que slo sirve para discos de hasta 2 gigas.
    	SET DEFAULT TO (lcdir)
    	espacio = SYS(2020)
    	SET DEFAULT TO (currentdir)
    	RETURN espacio
  	ENDIF

ENDFUNC

FUNCTION ESPACIOLIBREENDISCO(tDirectory) && Se le pasa un directorio y devuelve el espacio total.

	LOCAL espacio, currentdir, lcdir, lnresult, lccaller, lctotal,lcfree, lcmodule, lcprocname
	
	* Declaraciones de funciones API
  	DECLARE INTEGER GetModuleHandle IN Win32API STRING @lpModuleName
  	DECLARE INTEGER GetProcAddress IN Win32API INTEGER hModule, STRING @lpProcName
  	DECLARE SHORT GetDiskFreeSpaceEx IN Win32API STRING @lpDirectoryName, STRING @lpFreeBytesAvailableToCaller, STRING @lpTotalNumberOfBytes, STRING @lpTotalNumberOfFreeBytes
  	
  	STORE REPLICATE(CHR(0), 8) TO lccaller, lctotal, lcfree
  	
  	* Determina el directorio a que se le aplica 
  	currentdir = SYS(5)+CURDIR()
  	IF TYPE('tDirectory') = 'C'
     	lcdir = ADDBS(tDirectory)
    ELSE
    	* Si no se especific un directorio, se saca el espacio total de la unidad actual
    	lcdir = ADDBS(SYS(5))
   	ENDIF
   	lcdrive = JUSTDRIVE(lcdir)
    	
    lcmodule = "kernel32.dll"
  	lcprocname = "GetDiskFreeSpaceExA"
  	
  	IF GetProcAddress(GetModuleHandle(@lcmodule), @lcprocname) # 0
  		* Si el sistema operativo soporta la API DiskFreeSpaceEx se usa.
    	
    	IF GetDiskFreeSpaceEx(@lcdir, @lccaller, @lctotal, @lcfree) # 0
    		* Devuelve el espacio libre. 
      		espacio = StringToInteger(lcfree)
      		RETURN espacio
      	ELSE
      		RETURN NULL
    	ENDIF
    ELSE
    	* En caso contrario se usa DISKSPACE que es un "wrapper" de la ms antigua GetDiskFreeSpace
    	* y que slo sirve para discos de hasta 2 gigas.
    	espacio = DISKSPACE(JUSTDRIVE(lcdir))
    	IF espacio = -1 THEN
    		RETURN NULL
    	ELSE
    		RETURN espacio
    	ENDIF
  	ENDIF
ENDFUNC

FUNCTION AUXESTAENTEXTODISCOS(directorio, textodiscos)
	LOCAL poscoma, texto, encontrado, letra 
	directorio = ADDBS(ALLTRIM(UPPER(directorio)))
	textodiscos = ALLTRIM(UPPER(textodiscos)) +","
	letra = ALLTRIM(UPPER(LEFT(JUSTDRIVE(directorio),1)))
	
	poscoma = AT(",",textodiscos)
	encontrado = .F.
	DO WHILE NOT EMPTY(textodiscos) AND NOT encontrado
		texto = ALLTRIM(UPPER(SUBSTR(textodiscos,1,poscoma-1)))
		IF LEN(texto) = 1 AND (letra = texto) THEN
			encontrado = .T.
		ELSE
			texto = ADDBS(texto)
			encontrado = (AT(texto, directorio) <> 0) 
		ENDIF
		textodiscos = ALLTRIM(UPPER(SUBSTR(textodiscos,poscoma+1)))
	ENDDO
	RETURN encontrado
ENDIF

FUNCTION AUXDEDUCESIELDISCOESREMOVIBLE(directorio) 
	** Arbitrariamente se supone que los discos de menos de 300 megas son removibles
	** Los de ms de 700 Mb no son removibles
	** Entre 300 y 700 depende de lo que devuelva DRIVETYPE
	** No es infalible, por ello se utiliza la funcin disco removible
	LOCAL espa, letra, tipo
	espa = ESPACIOTOTALENDISCO(directorio)/(1024*1024) && Saca el espacio total en megas
	DO CASE
		CASE espa <= 300 
			RETURN .T.
		CASE espa >= 700
			RETURN .F.
		OTHERWISE 
			letra = ALLTRIM(UPPER(LEFT(JUSTDRIVE(directorio),1)))
			tipo = DRIVETYPE(letra)
			RETURN (tipo  = 2) OR (tipo = 5)
	ENDCASE
ENDFUNC

FUNCTION DISCOREMOVIBLE(directorio)
	textodiscosremovibles = LEEVARDEFECTO('XDISCOSREMOVIBLES','')
	IF AUXESTAENTEXTODISCOS(directorio,textodiscosremovibles) THEN
		RETURN .T.
	ELSE
		textodiscosnoremovibles = LEEVARDEFECTO('XDISCOSNOREMOVIBLES','')
		IF AUXESTAENTEXTODISCOS(directorio,textodiscosnoremovibles) THEN
			RETURN .F.
		ELSE
			** Si no hemos especificado en las variables persistentes si el disco no es 
			** removible o no, se intentar deducir. Este proceso de deduccin no es infalible 
			** por lo que se recomienda fijar las variables en caso de que falle.  
			RETURN AUXDEDUCESIELDISCOESREMOVIBLE(directorio)
		ENDIF
	ENDIF
ENDFUNC



Public Function DoesSystemSupportLargeDrives() As Boolean

  'Determines whether the method supports a
  'call to the GetDiskFreeSpaceEx API.
  'The method first calls the GetDiskFreeSpaceEx API.
  'If the call fails (no entry point in kernel32)
  'then the function returns false, indicating
  'that the app should use the GetDiskFreeSpace
  'API instead.  GetDiskFreeSpace is limited
  'to partitions less than 2 gig.

   On Local Error GoTo LargeSupport_Error
   
   Dim RootPathName As String
   Dim tmp1 As Currency
   Dim tmp2 As Currency
   Dim tmp3 As Currency
    
   RootPathName = "C:\"
  
  'get the drive's disk parameters
   If GetDiskFreeSpaceEx(RootPathName, _
                         tmp1, _
                         tmp2, _
                         tmp3) Then
      
     'GetDiskFreeSpaceEx supported.
      DoesSystemSupportLargeDrives = True
      
   End If
   
LargeSupport_Exit:
                         
   Exit Function
   
LargeSupport_Error:

  'No large drive support; use
  'GetDiskFreeSpace instead
  
   DoesSystemSupportLargeDrives = False
   Resume LargeSupport_Exit

End Function

PROCEDURE RESPALDOANTIGUO(eldirectorio)
	LOCAL directorioactual, directoriocompleto, codeline
	directorioactual = SYS(5)+CURDIR()
	directoriocompleto = dirraiz + eldirectorio
	SET DEFA TO &directoriocompleto
	codeline = dirraiz+"respaldo.exe -3 -& -rp  a:\"+eldirectorio+".zip *.dbf *.cdx "
	RUN &codeline
	SET DEFA TO &directorioactual
ENDPROC

PROCEDURE RECUPERACIONANTIGUA(eldirectorio)
	LOCAL directorioactual, directoriocompleto, codeline
	directorioactual = SYS(5)+CURDIR()
	directoriocompleto = dirraiz + eldirectorio
	SET DEFA TO &directoriocompleto
	codeline = dirraiz+"restaura.exe -d -o a:\"+eldirectorio+".zip"
	RUN &codeline
	SET DEFA TO &directorioactual
ENDPROC



FUNCTION NombreArchivoModulo(numeromodulo)
	LOCAL dd
	dd = NombreDirectorioModulo(numeromodulo)
	IF EMPTY(dd) THEN 
		RETURN "GESTION"
	ELSE
		RETURN dd
	ENDIF
ENDFUNC 

FUNCTION NombreDirectorioModulo(numeromodulo)
	LOCAL nombredir
	DO CASE
		CASE modulo = 1
		 	nombredir = "CONTABLE"
		CASE modulo = 2 
			nombredir = "BANCOS"
		CASE modulo = 3
			nombredir = "IVA" 
		CASE modulo = 4 
		 	nombredir = "INVENTARIO"
		CASE modulo = 5 
		 	nombredir = "PLANILLA"
		CASE modulo = 6 && Si estamos en configuracin, haremos la copia de todo el directorio.
		 	nombredir = ""
		CASE modulo = 7 
			nombredir = "COBROS"
	ENDCASE
	RETURN nombredir
ENDFUNC
