PROCEDURE PROPAGA_COBROS
ENDPROC

PROCEDURE CREA_COBROS_NUEVO_MES
	* Nos colocamos en el ltimo mes existente
	W_DESDE=DATE(W_ANYOMAX,W_MESMAX,01)
	W_HASTA=DATE(W_ANYOMAX,W_MESMAX,DIAS_MES(W_MESMAX,W_ANYOMAX))
	
	* Hacemos que el mes mximo sea el posterior al ltimo existente
	
	W_MESMAX = W_MES
	W_ANYOMAX = W_AO
	
	* Propagamos las cuentas
	DO PROPAGA_COBROS
ENDPROC

PROCEDURE CALCULAFECHAVENCIMIENTO(lafecha, laformapago)
	taula = ALIAS()
	SELE CBMT0100
	nreg = GUARDANUMEROREGISTRO()
	LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(laformapago)) AND empresa = nCodigo
	IF NOT FOUND() THEN
		MESSAGEBOX("No se ha definido esta forma de pago", 48, "MILLENNIUM CONSULTING")
		fechavencimiento = .NULL.
	ELSE
		IF cbmt0100.dias = 0 THEN
			fechavencimiento = lafecha
		ELSE
			IF cbmt0100.unitiempo = 1 THEN
				fechavencimiento = lafecha + cbmt0100.dias
			ELSE
				fechavencimiento = GOMONTH(lafecha,cbmt0100.dias)
			ENDIF
		ENDIF
		
		IF DOW(fechavencimiento) = 1 AND cbmt0100.calculodia = 1 THEN
			fechavencimiento = fechavencimiento+1
		ELSE
			IF DOW(fechavencimiento) = 7 AND cbmt0100.calculodia = 1 THEN
				fechavencimiento = fechavencimiento+2
			ENDIF
		ENDIF
	ENDIF
	RECUPERANUMEROREGISTRO(nreg)
	IF NOT EMPTY(taula) THEN
		SELE (taula)
	ENDIF
	RETURN fechavencimiento
ENDPROC