*:*****************************************************************
*:	PROGRAMA	: CBRP0100.PRG
*:	FECHA		: ABRIL DE 2001.
*:	FUNCION		: REPORTE DE VENCIMIENTOS Y MORAS
*:******************************************************************

PUBLIC R_HASTA, OPCION, FILTRO

DO FORM CBRP0100.SCX

IF OPCION = 1
	DO GENERA
	DO IMPRIME_REPORTE IN CILIB001 WITH ('CBRP0100'), (''), ('CIRP0110')	
ENDIF

DO DESTRUYEVARIABLESMONEDAREP IN CILIB001
RELEASE R_HASTA, OPCION, FILTRO
CLOSE DATA ALL

PROCEDURE GENERA
	RECORDARCODIGO()
	* Se traduce el monto de los abonos a la moneda del reporte
	
	TRADUCETABLAMONEDAGAMMA('cbmv0200','wtemp0',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, 'fecha', 'valmov', '')
	
	* Se calcula la suma de abonos y el ltimo abono que se realiz
	SELECT codicargo, MAX(fecha) AS ultiabono, SUM(valmov) AS cancelado, empresa;
	FROM (dirtemp+"wtemp0.dbf");
	INTO TABLE (dirtemp+"wtemp1.dbf");
	WHERE fecha <= R_HASTA AND empresa = nCodigo;
	GROUP BY codicargo

	* Se calculan los datos del reporte
	SELECT cbmv0100.*, R_HASTA - cbmv0100.fecvenci AS diasmora, wtemp1.ultiabono, IIF(ISNULL(wtemp1.cancelado),0, wtemp1.cancelado) AS cancelado;
	FROM cbmv0100 LEFT OUTER JOIN wtemp1 ON cbmv0100.codigo = wtemp1.codicargo AND cbmv0100.empresa = wtemp1.empresa;
	INTO TABLE (dirtemp+"wtemp2.dbf");
	WHERE fecha <= R_HASTA AND cancelado <> valmov AND cbmv0100.empresa = nCodigo
	INDEX ON UPPER(vendedor)+DTOS(fecha)+STR(codigo) TAG orden
	
	* Aunque el campo cancelado est en el reporte, el campo valmov est en la monedabase, as que se lo traduce a la moneda del reporte 
	TRADUCETABLAMONEDAGAMMA(dirtemp+'wtemp2','wtemp3',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, 'fecha', 'valmov', '')
		
ENDPROC
		
