* Logger
* Uso    .....: CREATE TRIGGER ON <Table> FOR DELETE AS Logger()
*              CREATE TRIGGER ON <Table> FOR UPDATE AS Logger()
*              CREATE TRIGGER ON <Table> FOR INSERT AS Logger()


LOCAL ARRAY laRecord[1, 3]
LOCAL lnFields, lnI, lcAction, lcTable, lcDatabase, lcKeyTag, lcKeyExp, lcOldKey, lcNewKey

IF TYPE('XNUMEROTABLASLOGGER') = 'N' AND XNUMEROTABLASLOGGER = 0 
   * Si no se ha activado el log, no se hace nada
   RETURN .T.
ENDIF

* Se asegura de que tenemos el nombre correcto de la tabla 

lcTable    = JUSTSTEM(DBF())                               

*Determina si el movimiento es un borrado, insercin o modificacin
DO CASE
   CASE DELETED()
      * En este caso, se ha borrado 
      lcAction = 'D'
      
   CASE LEFT(GetFldState(-1), 1) <> '1'
      * En este caso, se ha insertado un nuevo registro.
      lcAction = 'I'
      
   OTHERWISE
      * En este caso, debe ser que se ha actualizado
      lcAction = 'U'
      
ENDCASE

* Crea un array para los datos de los campos

lnFields   = FCOUNT()

IF lcAction = 'U' THEN
	DIMENSION laRecord[lnFields, 3]
ELSE
	DIMENSION laRecord[lnFields, 2]
ENDIF

* Rellena el array con el nombre del campo, su valor actual y el valor nuevo
NadaCambio = .T.
FOR lnI = 1 TO lnFields 
   laRecord[lnI, 1] = FIELD(lnI)
   ev = EVALUATE(FIELD(lnI))
   cu = CURVAL(FIELD(lnI))
   
   NadaCambio = NadaCambio AND (ev = cu)
   
   IF lcAction = 'I' THEN
   		laRecord[lnI, 2] = ev
   ELSE
   		laRecord[lnI, 2] = cu
   ENDIF
   
   IF lcAction = 'U' THEN
   		laRecord[lnI, 3] = ev
   ENDIF
ENDFOR

* En el caso de borrado e insercin, siempre cambia algo
NadaCambio = NadaCambio AND (lcAction = 'U')

DO CASE
   CASE USED('Logger')
      * Abierto, no hace nada
      GO BOTTOM	IN Logger
      
   CASE FILE(dirraiz+'COMUN\Logger.dbf')
      * No abierto pero existe, lo abre        
      USE (dirraiz + 'COMUN\Logger') IN 0  
	  GO BOTTOM	IN Logger      
ENDCASE

* Obtiene el contador del ultimo registro. Si no existe, lo crea

IF EOF() THEN
	contador = 1 
ELSE
	contador = Logger.numero+1
ENDIF 

* Si cambi algo
IF NOT NadaCambio THEN
	* Inserta un nuevo registro en la tabla de logger
	INSERT INTO Logger (Numero, Tabla, Cuando, Accion, Datos, FormActivo) ;
		VALUES (contador,lcTable, DateTime(), lcAction, '', _SCREEN.ActiveForm.Name)


	* Aade el array con los datos de los campos entre el campo mData
	IF NOT XFORMATORESUMIDOLOGGER THEN
		SAVE TO MEMO Logger.Datos ALL LIKE laRecord
	ENDIF
ENDIF

* Siempre devuelve OK

RETURN .T.
