DEFINE CLASS CasillaCargosPartida AS CantidadMonetaria
	Caption = ''
	Width = 92
	BackStyle = 0
	DentroGrid = .T.
	controlsource = "comt0210.mo_cargos"
	Modificacuando = "M.DETA"
	InputMask = "999,999,999.99"
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
	PROCEDURE Valid
		IF COMT0210.MO_CARGOS <> 0.00
			REPLACE MO_ABONOS WITH 0.00
			SUM COMT0210.MO_ABONOS FOR COMT0210.MO_NUMDOC = M.MO_NUMDOC AND COMT0210.EMPRESA = nCodigo AND COMT0210.nmes = MONTH(W_DESDE) AND COMT0210.anyo = YEAR(W_DESDE) TO W_ABONOS
			M.TOTALABONOS = W_ABONOS
			REPLACE TOTALABONOS WITH W_ABONOS IN COMT0200
		ENDIF
		nRegistro = IIF(EOF(),EOF(),RECNO())
		SUM COMT0210.MO_CARGOS FOR COMT0210.MO_NUMDOC = M.MO_NUMDOC AND COMT0210.EMPRESA = nCodigo AND COMT0210.nmes = MONTH(W_DESDE) AND COMT0210.anyo = YEAR(W_DESDE) TO W_CARGOS
		IF TYPE('nRegistro') = 'N'
			GO RECORD nRegistro
		ENDIF

		M.TOTALCARGOS = W_CARGOS 
		REPLACE TOTALCARGOS WITH W_CARGOS IN COMT0200
		THISFORM.REFRESH
	ENDPROC
	
ENDDEFINE

DEFINE CLASS CasillaAbonosPartida AS CantidadMonetaria
	Caption = ''
	Width = 92
	BackStyle = 0
	DentroGrid = .T.
	controlsource = "comt0210.mo_abonos"
	Modificacuando = "M.DETA"
	InputMask = "999,999,999.99"
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
	PROCEDURE Valid
		IF COMT0210.MO_ABONOS <> 0.00
			REPLACE MO_CARGOS WITH 0.00
			SUM COMT0210.MO_CARGOS FOR COMT0210.MO_NUMDOC = M.MO_NUMDOC AND COMT0210.EMPRESA = nCodigo AND COMT0210.nmes = MONTH(W_DESDE) AND COMT0210.anyo = YEAR(W_DESDE) TO W_CARGOS
			M.TOTALCARGOS = W_CARGOS
			REPLACE TOTALCARGOS WITH W_CARGOS IN COMT0200
		ENDIF
		nRegistro = IIF(EOF(),EOF(),RECNO())
		SUM COMT0210.MO_ABONOS FOR COMT0210.MO_NUMDOC = M.MO_NUMDOC AND COMT0210.EMPRESA = nCodigo AND COMT0210.nmes = MONTH(W_DESDE) AND COMT0210.anyo = YEAR(W_DESDE) TO W_ABONOS
		IF TYPE('nRegistro') = 'N'
			GO RECORD nRegistro
		ENDIF
		M.TOTALABONOS = W_ABONOS
		REPLACE TOTALABONOS WITH W_ABONOS IN COMT0200
		THISFORM.REFRESH
	ENDPROC
ENDDEFINE

*DEFINE CLASS Prova AS monetario
	
*	ControlSource = 'comt0210.mo_cargos' 
*	PROCEDURE When
*		RETURN M.DETA
*	ENDPROC
	
*ENDDEFINE

*DEFINE CLASS Prova2 AS TextBox
*	Format = '999,999,999.99'
*	InputMask = '999,999,999.99'
*	BorderStyle = 0
*	ControlSource = 'comt0210.mo_cargos' 
*	PROCEDURE When
*		RETURN M.DETA
*	ENDPROC
*	PROCEDURE Value_assign
*		LPARAMETERS vnewval
		
*		THIS.Value = vnewval
*	ENDPROC
*ENDDEFINE
*****************************************************************************
*                    		 RUBROS   					                    *
*                                                                           *
*****************************************************************************


FUNCTION QUITACEROSFINAL(strg) 
	RETURN LEFT(strg,LEN(RTRIM(STRTRAN(strg,'0',' '))))
ENDFUNC

FUNCTION CUENTAESRUB(nct,nrbr)
** Devuelve cierto si la cuenta nct es del rubro (o nivel de catlogo) nrbr
	DO CASE
		CASE XCOINTERPRETACIONRUBROS = 0 
			RETURN (LEN(ALLTRIM(nct)) = RUBRO(nrbr))
		CASE XCOINTERPRETACIONRUBROS = 1 
			RETURN (LEN(QUITACEROSFINAL(ALLTRIM(nct))) = RUBRO(nrbr))
		CASE XCOINTERPRETACIONRUBROS = 2
		 	RETURN (LEN(ALLTRIM(CHRTRAN(nct,".Rr",""))) = RUBRO(nrbr))
		CASE XCOINTERPRETACIONRUBROS = 3
		 	RETURN (LEN(ALLTRIM(CHRTRAN(nct,"-Rr",""))) = RUBRO(nrbr))

	ENDCASE
ENDFUNC

FUNCTION CUENTAESHASTARUB(nct,nrbr)
** Devuelve cierto si la cuenta nct es del rubro (o nivel de catlogo) nrbr o UN RUBRO INFERIOR
	DO CASE
		CASE XCOINTERPRETACIONRUBROS = 0 
			RETURN (LEN(ALLTRIM(nct)) <= RUBRO(nrbr))
		CASE XCOINTERPRETACIONRUBROS = 1 
			RETURN (LEN(QUITACEROSFINAL(ALLTRIM(nct))) <= RUBRO(nrbr))
		CASE XCOINTERPRETACIONRUBROS = 2
		 	RETURN (LEN(ALLTRIM(CHRTRAN(nct,".Rr",""))) <= RUBRO(nrbr))
		CASE XCOINTERPRETACIONRUBROS = 3
		 	RETURN (LEN(ALLTRIM(CHRTRAN(nct,"-Rr",""))) <= RUBRO(nrbr))
	ENDCASE
ENDFUNC


FUNCTION HASTARUBCUENTA(ct,rb)
** Devuelve la parte del cdigo de cuenta que corresponde al rubro rb
	DO CASE
		CASE XCOINTERPRETACIONRUBROS = 0 
			RETURN SUBSTR(ct,1, RUBRO(rb))
		
		CASE XCOINTERPRETACIONRUBROS = 1 
			RETURN SUBSTR(QUITACEROSFINAL(ct),1, RUBRO(rb))
		
		CASE XCOINTERPRETACIONRUBROS = 2 
			RETURN SUBSTR(ALLTRIM(CHRTRAN(ct,".Rr","")),1, RUBRO(rb))
			
		CASE XCOINTERPRETACIONRUBROS = 3 
			RETURN SUBSTR(ALLTRIM(CHRTRAN(ct,"-Rr","")),1, RUBRO(rb))			
	ENDCASE	
ENDFUNC




*****************************************************************************
*                      PROPAGA CUENTAS				                       *
*                                                                           *
*****************************************************************************


PROCEDURE PROPAGA_CUENTAS
	LOCAL filtro, mesactual, anyoactual, messiguiente, anyosiguiente, nregist
	
	** Almacena en variables cul es el mes actual y el inmediatamente posterior al actual
		
	mesactual = MONTH(W_DESDE)
	anyoactual = YEAR(W_DESDE)
	messiguiente = MES_MESDESPUES(mesactual,anyoactual)
	anyosiguiente = ANYO_MESDESPUES(mesactual,anyoactual)
		
	** Propaga las diferencias
	
	USE COMT0100 IN 0 ALIAS COMT0100 EXCLUSIVE
	SELECT COMT0100
	filtro = FILTER()
	SET FILTER TO
	SCAN FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual
		nregist = GUARDANUMEROREGISTRO()
		cuenta = COMT0100.CA_CODCTA
		saldofinal = COMT0100.CA_SALACT
		
		LOCATE FOR ALLTRIM(ca_codcta) == ALLTRIM(cuenta) AND empresa = nCodigo AND nmes = messiguiente AND anyo = anyosiguiente
		IF FOUND() THEN
			diferencia = saldofinal - COMT0100.ca_salini
			IF diferencia <>0 THEN
				REPLACE ALL ca_salini WITH ca_salini+diferencia, ca_salact WITH ca_salact+diferencia FOR ALLTRIM(ca_codcta) == ALLTRIM(cuenta) AND empresa = nCodigo AND POSTERIOROIGUALMES(W_MESMAX,W_ANYOMAX,nmes,anyo) AND POSTERIOROIGUALMES(nmes,anyo,messiguiente,anyosiguiente)
			ENDIF
		ENDIF
		
		RECUPERANUMEROREGISTRO(nregist)
	ENDSCAN 
	SET FILTER TO &filtro
	USE
ENDPROC

PROCEDURE CREA_CUENTAS_NUEVO_MES
	* Copiamos todas las cuentas del ltimo mes en el mes posterior al ltimo, poniendo posterior a .T. en las cuentas copiadas
		
	USE COMT0100 IN 0 ALIAS COMT0100 EXCLUSIVE
	SELECT COMT0100
	SCAN FOR nmes = W_MESMAX AND anyo = W_ANYOMAX AND empresa = nCodigo
		numeroregistro = GUARDANUMEROREGISTRO()
		
		SCATTER MEMVAR
		
		m.nmes = W_MES
		m.anyo = W_AO 
		m.ca_cargos = 0 
		m.ca_abonos = 0 
		m.ca_salini = m.ca_salact
						
		INSERT INTO COMT0100 FROM MEMVAR
		RECUPERANUMEROREGISTRO(numeroregistro)		
	ENDSCAN
	USE
	
	* Nos colocamos en el mes posterior al ltimo
	
	W_MESMAX = W_MES
	W_ANYOMAX = W_AO
	
	W_DESDE=DATE(W_ANYOMAX,W_MESMAX,01)
	W_HASTA=DATE(W_ANYOMAX,W_MESMAX,DIAS_MES(W_MESMAX,W_ANYOMAX))	
ENDPROC


PROCEDURE TRASLADADIFERENCIAANTEPASADOS(lacuenta, difcargos, difabonos,  cmes, canyo)
	&& Se supone que la tabla comt0100 est abierta 
	LOCAL cuenta, tula
	
	IF difcargos <> 0 OR difabonos <> 0 THEN
		tula = ALIAS()
		SELE COMT0100
		GUARDAESTADOPREFIJO('temptraslada')
		cuenta = lacuenta
		DO WHILE .T.
			LOCATE FOR ALLTRIM(ca_codcta) == ALLTRIM(cuenta) AND empresa = nCodigo AND nmes = cmes AND anyo = canyo
			IF FOUND()
				REPLACE CA_CARGOS WITH CA_CARGOS+difcargos, CA_ABONOS WITH CA_ABONOS+difabonos
				DO CASE
					CASE CA_TIPCTA = "Deudora"
						REPL NEXT 1 CA_SALACT WITH (CA_SALINI + CA_CARGOS) - CA_ABONOS

					CASE CA_TIPCTA = "Acreedora"
						REPL NEXT 1 CA_SALACT WITH (CA_SALINI + CA_ABONOS) - CA_CARGOS
				ENDCASE
			ELSE
				EXIT
			ENDIF
			
			STORE CA_CTAMAY TO CUENTA
			
			IF EMPTY(CUENTA) THEN
				EXIT
			ENDIF
		ENDDO
	
	
		RECUPERAESTADOPREFIJO('temptraslada')
		IF NOT EMPTY(tula) THEN
			SELE (tula)
		ENDIF
	ENDIF
ENDPROC



PROCEDURE CAMBIACUENTAMAYOR(ctamayvieja, ctamaynueva, dcargos, dabonos, unmes, unanyo)
	IF NOT EMPTY(ctamayvieja) THEN
		TRASLADADIFERENCIAANTEPASADOS(ctamayvieja, -dcargos, -dabonos,  unmes, unanyo)
	ENDIF
	
	IF NOT EMPTY(ctamaynueva) THEN
		TRASLADADIFERENCIAANTEPASADOS(ctamaynueva, dcargos, dabonos,  unmes, unanyo)	
	ENDIF
ENDPROC


PROCEDURE TRADUCECOMT0100SEGUNVARIABLESMONEDAREP(elnmes,elanyo)
	DO RECORDARCODIGO IN CILIB001
    IF USED('WCOMT0100') THEN
	   SELE WCOMT0100
	   USE
	ENDIF
	IF W_TIPOCAMBIOREP = -1 THEN
		TRADUCECOMT0100SEGUNCOTIZACIONES(elnmes,elanyo)
	ELSE
		TRADUCETABLAMONEDADELTA('comt0100','wcomt0100',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP,'', 'ca_salini, ca_salact, ca_cargos, ca_abonos', 'nmes = '+STR(elnmes)+' AND anyo = '+STR(elanyo)+' AND empresa = '+STR(nCodigo))
		USE (dirtemp+"wcomt0100") IN 0 ALIAS WCOMT0100 EXCLUSIVE
		INDEX ON ca_codcta TAG ca_codcta
	ENDIF
ENDPROC

PROCEDURE TRADUCECOMT0100SEGUNCOTIZACIONES(elnmes,elanyo)
	LOCAL eltipoc
	
	condicion = 'nmes = '+STR(elnmes)+' AND anyo = '+ STR(elanyo)+' AND empresa = '+STR(nCodigo)
	condicion2 = 'comt0100.nmes = '+STR(elnmes)+' AND comt0100.anyo = '+ STR(elanyo)+' AND comt0100.empresa = '+STR(nCodigo)

	RECORDARCODIGO()
		 
    ** Se incorpora la fecha de la partida a cada uno de los cargos y abonos para poder traducirlos a la moneda
			
	SELECT comt0210.*, comt0200.mo_fecdoc AS mo_fecdoc;
	FROM comt0210 INNER JOIN comt0200 ON comt0200.mo_numdoc = comt0210.mo_numdoc AND comt0200.nmes = comt0210.nmes AND comt0200.anyo = comt0210.anyo AND comt0200.empresa = comt0210.empresa;
	INTO TABLE (dirtemp+"TEMPBAMOVIMIENTOS.DBF");
	WHERE comt0210.nmes = elnmes AND comt0210.anyo = elanyo AND comt0210.empresa = nCodigo

	** Se traducen los cargos y abonos  a la moneda segn cotizaciones 
	TRADUCETABLAMONEDAGAMMA(dirtemp+"TEMPBAMOVIMIENTOS.DBF",'wcomt0210',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, 'mo_fecdoc', 'mo_cargos, mo_abonos', condicion)
	USE (dirtemp+"WCOMT0210") IN 0 ALIAS WCOMT0210
	SELE TEMPBAMOVIMIENTOS
	USE
	
	usado100 = USED('COMT0100')
	IF NOT usado100 THEN
		USE COMT0100 IN 0 
	ENDIF
	
	* Se crea una tabla temporal con una copia del catlogo sin partidas actualizadas traducido a la moneda en cuestin
	
	SELE COMT0100
	COPY TO (dirtemp+'WCOMT0100') FOR &condicion2 WITH CDX
	eltipoc = CALCULATIPOCAMBIOMATRIZ (@W_COTIZAREP, W_MONEDAREP, DATE(elanyo,elnmes,1)) 		
	
	USE IN 0 (dirtemp+"wcomt0100") ORDER TAG "llave1" ALIAS WCOMT0100 EXCLUSIVE
	SELECT WCOMT0100
    REPLACE ALL ca_salact WITH ca_salini*eltipoc, ca_salini WITH ca_salini*eltipoc, ca_cargos WITH 0, ca_abonos WITH 0 
   	INDEX ON ca_codcta TAG ca_codcta

	* Se actualiza esta tabla temporal con los movimientos que se haban traducido a la otra moneda, por lo cual tenemos el catlogo en la otra moneda segn cotizaciones.
	ACTUALIZAPARTIDASENTABLAWCOMT0100(elnmes, elanyo)

    * Se cierran las tablas.

	
	IF NOT usado100 THEN
		SELE COMT0100
		USE
	ENDIF
	SELE COMT0210
	USE
	SELE wcomt0210
	USE
	SELE wcomt0100
	USE IN opciones
ENDPROC

PROCEDURE ACTUALIZAPARTIDASENTABLAWCOMT0100(elnmes, elanyo)

    RECORDARCODIGO()
    STORE SPACE(12) TO CUENTA

    * Almacena en wtempor01 los movimientos que se deben actualizar
	USE (cDirectorio + "CONFIG\OPCIONES") IN 0
	RESTORE FROM MEMO opciones.codigo ADDITIVE
	SELECT wcomt0210.MO_NUMDOC, wcomt0210.MO_CODCTA, wcomt0210.MO_CARGOS,;
			wcomt0210.MO_ABONOS, COMT0200.MO_FECDOC, COMT0200.NMES, COMT0200.ANYO;
	FROM 	COMT0200.DBF, (dirtemp+"wcomt0210.DBF");
	WHERE	COMT0200.MO_NUMDOC = wcomt0210.MO_NUMDOC	AND;
			COMT0200.NMES = elnmes AND COMT0200.anyo = elanyo AND COMT0200.MO_ACTUALIZ  AND;
			COMT0200.EMPRESA = nCodigo AND wcomt0210.EMPRESA = nCodigo;
			AND COMT0200.NMES = wcomt0210.NMES AND COMT0200.ANYO = wcomt0210.ANYO ;
	INTO TABLE (dirtemp+"wtempor01.DBF")
    SELE COMT0200
    USE
    * Abre la copia del catlogo y le aplica un filtro segun el mes
    usadow0100 = USED('wcomt0100')
    IF NOT usadow0100 THEN
       USE IN 0 (dirtemp+"wcomt0100") ORDER TAG "llave1" ALIAS WCOMT0100 
    ENDIF
    SELE WCOMT0100
	cFiltrando = 'SET FILTER TO ' + STR(nCodigo) + ' = EMPRESA AND NMES = '+STR(elnmes)+' AND ANYO = '+ STR(elanyo)
	&cFiltrando
	LOCATE

    * Actualiza los movimientos de las partidas
	SELE wtempor01
	INDEX ON MO_CODCTA TAG CUENTA
	
		
	*USE IN 0 (dirtemp+"wtempor01") ORDER TAG 1 ALIAS wtempor01
	*SELE wtempor01
	DO WHILE !EOF()
		STORE MO_CODCTA TO CUENTA	
		SELE WCOMT0100
		DO WHILE .T.
			LOCATE FOR ALLTRIM(CA_CODCTA) == ALLTRIM(CUENTA) AND NMES = elnmes AND ANYO = elanyo AND empresa = nCodigo
			IF FOUND() THEN		
				DO CASE	
					CASE !EMPTY(wtempor01.MO_CARGOS)
						REPL NEXT 1 CA_CARGOS WITH CA_CARGOS + wtempor01.MO_CARGOS
		
					CASE !EMPTY(wtempor01.MO_ABONOS)
						REPL NEXT 1 CA_ABONOS WITH CA_ABONOS + wtempor01.MO_ABONOS
				ENDCASE
				DO CASE
					CASE CA_TIPCTA = "Deudora"
						REPL NEXT 1 CA_SALACT WITH (CA_SALINI + CA_CARGOS) - CA_ABONOS

					CASE CA_TIPCTA = "Acreedora"
						REPL NEXT 1 CA_SALACT WITH (CA_SALINI + CA_ABONOS) - CA_CARGOS
				ENDCASE
			ELSE
				MESSAGEBOX("Error. La cuenta " + ALLTRIM(CUENTA) + " no se encontr en el catlogo y, por lo tanto, no se actualiz." ,48,"MILLENNIUM CONSULTING")
				EXIT
			ENDIF
			STORE CA_CTAMAY TO CUENTA
			
			IF CUENTA = " "
				EXIT
			ENDIF
		ENDDO
		SELE wtempor01
		SKIP
	ENDDO
	SELE wtempor01
	USE
    IF NOT usadow0100 THEN
       SELE wcomt0100
       USE 
    ENDIF
ENDPROC