*:*****************************************************************
*:	PROGRAMA	: COMV0400.PRG
*:	FECHA		: AGOSTO DE 1998.
*:	FUNCION		: REVERTIR ACTUALIZACION DIARIA DE MOVIMIENTOS.
*:	APLICACION	: SISTEMA INTEGRADO DE INFORMACION.
*:******************************************************************
CLOSE DATA ALL
PUBLIC OP
STORE 0 TO OP,XFECHA, XFECHAFINAL
STORE SPACE(12) TO CUENTA
DO FORM COMV0400.SCX
IF OP = 1
	RECORDARCODIGO()
	SELECT 	ALLTRIM(UPPER(COMT0210.MO_CODCTA)) AS MO_CODCTA, SUM(COMT0210.MO_CARGOS) AS MO_CARGOS,;
			SUM(COMT0210.MO_ABONOS) AS MO_ABONOS, COMT0200.NMES, COMT0200.ANYO;
	FROM 	COMT0200.DBF, COMT0210.DBF;
	WHERE	COMT0200.MO_NUMDOC = COMT0210.MO_NUMDOC	AND;
			BETWEEN(COMT0200.MO_FECDOC, XFECHA, XFECHAFINAL) AND COMT0200.MO_ACTUALIZ = .T. AND;
			COMT0200.EMPRESA = nCodigo AND COMT0210.EMPRESA = nCodigo;
			AND COMT0200.NMES = MONTH(W_DESDE) AND COMT0200.ANYO = YEAR(W_DESDE);
			AND COMT0210.NMES = MONTH(W_DESDE) AND COMT0210.ANYO = YEAR(W_DESDE);
	GROUP BY MO_CODCTA;
	INTO TABLE TEMPOR01.DBF
	
	INDEX ON MO_CODCTA TAG CUENTA
	CLOSE DATA ALL
	USE IN 0 COMT0100 ORDER TAG "llave1" ALIAS MT0100
	cAlias = ALIAS()
	SELECT MT0100
	IF !TYPE("nCodigo") $ "UL"
		cFiltrando = "SET FILTER TO " + STR(nCodigo) + " = EMPRESA AND NMES = MONTH(W_DESDE) AND ANYO = YEAR(W_DESDE) "
		&cFiltrando
		LOCATE
	ENDIF
	SELECT (cAlias)
	RELEASE cAlias
	USE IN 0 TEMPOR01 ORDER TAG 1 ALIAS TEMPO1
	SELE TEMPO1
	IF EOF() THEN
		MESSAGEBOX("No hay ninguna partida actualizada en este rango de fechas",48, "MILLENNIUM CONSULTING")
		CLOSE DATA ALL
	ELSE
		BEGIN TRANSACTION
		DO WHILE NOT EOF()	
			STORE MO_CODCTA TO CUENTA
		
			SELE MT0100
			DO WHILE .T.
				LOCATE FOR ALLTRIM(CA_CODCTA) == ALLTRIM(CUENTA) AND NMES = MONTH(W_DESDE) AND ANYO = YEAR(W_DESDE) 
				IF FOUND()
					WAIT WIND "Desactualizando la Cuenta "+ ALLTRIM(CUENTA) NOWAIT
					
					IF NOT EMPTY(TEMPO1.MO_CARGOS) THEN
						REPL NEXT 1 CA_CARGOS WITH CA_CARGOS - TEMPO1.MO_CARGOS
					ENDIF
					
					IF NOT EMPTY(TEMPO1.MO_ABONOS) THEN
						REPL NEXT 1 CA_ABONOS WITH CA_ABONOS - TEMPO1.MO_ABONOS
					ENDIF
					
					DO CASE
						CASE CA_TIPCTA = "Deudora"
							REPL NEXT 1 CA_SALACT WITH (CA_SALINI + CA_CARGOS) - CA_ABONOS
						CASE CA_TIPCTA = "Acreedora"
							REPL NEXT 1 CA_SALACT WITH (CA_SALINI + CA_ABONOS) - CA_CARGOS
					ENDCASE
				ELSE
					IF NOT EMPTY(CUENTA) THEN
						MESSAGEBOX("Error. La cuenta " + ALLTRIM(CUENTA) + " no se encontr en el catlogo y, por lo tanto, no se desactualiz." ,48,"MILLENNIUM CONSULTING")
						EXIT	
					ENDIF
				ENDIF
				STORE CA_CTAMAY TO CUENTA
				IF CUENTA = " "
					EXIT
				ENDIF
			ENDDO
			SELE TEMPO1
			SKIP
		ENDDO
		WAIT CLEAR
		CLOSE DATA ALL
		USE COMT0200
		REPL ALL MO_ACTUALIZ WITH .F. FOR BETWEEN(MO_FECDOC, XFECHA, XFECHAFINAL) AND EMPRESA = nCodigo
		CLOSE DATA ALL
		END TRANSACTION
		MESSAGEBOX("Reversin de la actualizacin finalizada.",48, "MILLENNIUM CONSULTING")
	ENDIF
ENDIF
