*:*****************************************************************
*:	PROGRAMA	: CORP0400.PRG
*:	FECHA		: AGOSTO DE 1998.
*:	FUNCION		: INFORME: LIBRO DIARIO MAYOR.
*:	APLICACION	: SISTEMA INTEGRADO DE INFORMACION.
*:******************************************************************
PUBLIC  OPCION, R_MES, R_ANYO, R_DESDE, R_HASTA
PUBLIC R_FORMATO

SET PROCEDURE TO COLIB001 ADDITIVE

XFORMATODIARIOMAYOR = LEEVARBOOLDEFECTO("XFORMATODIARIOMAYOR",.F.)

IF XFORMATODIARIOMAYOR THEN
	DO FORM CORP0400.SCX
ELSE
	R_FORMATO = 1
	DO FORM CORP0100.SCX
ENDIF

IF OPCION = 1
	DELETE FILE dirraiz+"\TEMPOR01.DBF"
	DO GENERA

	IF LEEVARBOOLDEFECTO("XCOHORIZONTALDIARIOMAYOR",.F.) THEN
		DO IMPRIME_REPORTE IN CILIB001 WITH ('CORP0410'), (''), ('CIRP0110')
	ELSE
		DO IMPRIME_REPORTE IN CILIB001 WITH ('CORP0400'), (''), ('CIRP0110')
	ENDIF
	
ENDIF
DO DESTRUYEVARIABLESMONEDAREP IN CILIB001
RELEASE OPCION, R_MES, R_ANYO, R_DESDE, R_HASTA
RELEASE R_FORMATO

PROCEDURE GENERA
	RECORDARCODIGO()

	** Crea la tabla temporal del reporte
	CREATE TABLE (dirtemp+"wwtemporal") (CA_CODCTA C(12), CA_NOMCTA C(40), CA_SALINI N(20,8), CA_SALACT N(20,8), CA_CARGOS N(20,8), CA_ABONOS N(20,8), MO_FECDOC D, MO_CARGOS N(20,8), MO_ABONOS N(20,8), PDAMINIMA N(10), PDAMAXIMA N(10), NMES N(2,0), ANYO N(4,0), EMPRESA N(2,0), CMONEDA N(2,0), TIPOCAMBIO N(16,8))
	
	** La traduce a la moneda
	TRADUCECOMT0100SEGUNVARIABLESMONEDAREP(R_MES, R_ANYO)
			
	** Incluye en ella todas las cuentas de catlogo del mismo mes y ao (si el formato es 3, slo las del tercer rubro)
	SELE wwtemporal
	IF R_FORMATO = 1 OR R_FORMATO = 2 THEN
		APPEND FROM (dirtemp+"WCOMT0100") FIELDS CA_CODCTA, CA_NOMCTA, CA_SALINI, CA_SALACT, CA_CARGOS, CA_ABONOS, NMES, ANYO, EMPRESA FOR NMES = R_MES AND ANYO = R_ANYO AND EMPRESA = nCodigo 
	ELSE
		APPEND FROM (dirtemp+"WCOMT0100") FIELDS CA_CODCTA, CA_NOMCTA, CA_SALINI, CA_SALACT, CA_CARGOS, CA_ABONOS, NMES, ANYO, EMPRESA FOR CUENTAESRUB(CA_CODCTA, 3) AND NMES = R_MES AND ANYO = R_ANYO AND EMPRESA = nCodigo 	
	ENDIF
	
	** Crea la informacin sobre movimientos
	IF R_FORMATO = 1 OR R_FORMATO = 3 THEN
		* Si el formato es 3, consideramos como cdigo de la cuenta el de su cuenta mayor
		IF R_FORMATO = 1 THEN
			campocodcta = "COMT0210.MO_CODCTA AS CA_CODCTA"
		ELSE
			campocodcta = 'HASTARUBCUENTA(COMT0210.MO_CODCTA,3) AS CA_CODCTA'
		ENDIF
		
		* Recogemos la informacin sobre movimientos
		SELECT &campocodcta, SUM(COMT0210.MO_CARGOS) AS MO_CARGOS, ;
			SUM(COMT0210.MO_ABONOS) AS MO_ABONOS, COMT0200.MO_FECDOC AS MO_FECDOC,;
			MIN(COMT0210.MO_NUMDOC) AS PDAMINIMA, MAX(COMT0210.MO_NUMDOC) AS PDAMAXIMA,;
			COMT0200.CMONEDA, COMT0200.TIPOCAMBIO;
		FROM COMT0210 INNER JOIN COMT0200 ON;
			COMT0210.MO_NUMDOC = COMT0200.MO_NUMDOC  ;
			AND COMT0210.EMPRESA = COMT0200.EMPRESA ; 
			AND COMT0210.NMES = COMT0200.NMES   ; 
			AND COMT0210.ANYO = COMT0200.ANYO  ;
		INTO TABLE (dirtemp+"wtemporal2");
		WHERE  COMT0210.NMES = R_MES ;
			AND COMT0210.ANYO = R_ANYO AND COMT0210.EMPRESA = nCodigo;
		GROUP BY CA_CODCTA, COMT0200.MO_FECDOC

		** Se incluye en la tabla temporal
		SELE wwtemporal			
		APPEND FROM (dirtemp+"wtemporal2")
	ENDIF

	** Genera un ndice para ordenar la tabla
	INDEX ON ca_codcta+DTOS(mo_fecdoc) TAG orden
	CLOSE DATA ALL
	TRADUCETABLAMONEDAGAMMA(dirtemp+'wwtemporal','wtemporal',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, 'mo_fecdoc', 'mo_cargos, mo_abonos', '')
ENDPROC
		
