*:*****************************************************************
*:	PROGRAMA	: CORP0600.PRG
*:	FECHA		: AGOSTO DE 1998.
*:	FUNCION		: INFORME: BALANCE GENERAL.
*:	APLICACION	: SISTEMA INTEGRADO DE INFORMACION.
*:******************************************************************

SET PROCEDURE TO COLIB001 ADDITIVE
PUBLIC OPCION, R_MES, R_ANYO

	DO FORM CORP0100.SCX

	IF OPCION = 1 THEN
		DO GENERA
		DO IMPRIME_REPORTE IN CILIB001 WITH ('CORP0600'), (''), ('CIRP0110')
	ENDIF
DO DESTRUYEVARIABLESMONEDAREP IN CILIB001
RELEASE OPCION, R_MES, R_ANYO
CLOSE DATA ALL


PROCEDURE GENERA
	XCAPITALENPASIVO = LEEVARBOOLDEFECTO("XCAPITALENPASIVO",.T.)
	TRADUCECOMT0100SEGUNVARIABLESMONEDAREP(R_MES, R_ANYO)
	CREATE TABLE tempor01.DBF (a_codcta c(12), a_nomcta c(40), a_salact N(15,4))
	SELE tempor01
	USE
	*USE WCOMT0100
	SELE WCOMT0100
	COPY STRU TO tempor02.DBF
	USE (cdirectorio + "CONFIG\OPCIONES") IN 0
	RESTORE FROM MEMO opciones.codigo ADDITIVE
	USE tempor02
	APPEND FROM (dirtemp+"WCOMT0100.DBF") FOR CUENTAESRUB(ca_codcta,2) AND empresa = ncodigo AND nmes = R_MES AND anyo = R_ANYO
	INDEX ON HASTARUBCUENTA(ca_codcta,2) TAG cuenta
	CLOSE DATA ALL
	
	USE IN 0 tempor01 ALIAS tempor01
	USE IN 0 (dirtemp+"WCOMT0100.DBF") ORDER TAG ca_codcta ALIAS WCOMT0100
	SELE WCOMT0100
	SET FILTER TO CUENTAESRUB(ca_codcta,3) AND (HASTARUBCUENTA(ca_codcta,1) = "1" OR HASTARUBCUENTA(ca_codcta,1) = "2" OR (NOT XCAPITALENPASIVO AND HASTARUBCUENTA(ca_codcta,1) = "3")) AND empresa = ncodigo AND nmes = R_MES AND anyo = R_ANYO
	GO TOP
	DO WHILE !EOF()
		IF NOT EMPTY(WCOMT0100.ca_salact) THEN
			SELE tempor01
			APPEND BLANK
			REPL NEXT 1 a_codcta WITH WCOMT0100.ca_codcta
			REPL NEXT 1 a_nomcta WITH WCOMT0100.ca_nomcta
			REPL NEXT 1 a_salact WITH WCOMT0100.ca_salact
			SELE WCOMT0100
		ENDIF
		SKIP
	ENDDO
	CLOSE DATA ALL
	
	
	USE IN 0 tempor01 ALIAS tempor01
	
	
	SELECT tempor01
	
	
	** Escribe registros en blanco para equilibrar los totales de activo y de pasivo
	
	COUNT FOR HASTARUBCUENTA(a_codcta,1) < "2"  TO numlinactivonivel3 
	
	COUNT FOR HASTARUBCUENTA(a_codcta,1) >= "2" TO numlinpasivonivel3 
	
	SELECT DISTINCT tempor02.ca_codcta ;
	FROM tempor01, tempor02 ;
	INTO CURSOR curtemp;
	WHERE ALLTRIM(UPPER(tempor02.ca_codcta)) == HASTARUBCUENTA(tempor01.a_codcta,2)
	
	COUNT FOR HASTARUBCUENTA(ca_codcta,1) < "2" TO numlinactivonivel2	
	COUNT FOR HASTARUBCUENTA(ca_codcta,1) >= "2" TO numlinpasivonivel2
	
	numlinactivo = numlinactivonivel2+ numlinactivonivel3
	numlinpasivo = numlinpasivonivel2+ numlinpasivonivel3

	DO CASE
		CASE numlinactivo = numlinpasivo
			** No hacer nada
		CASE numlinactivo < numlinpasivo
			FOR ilin = 1 TO numlinpasivo-numlinactivo
				INSERT INTO tempor01 (a_codcta , a_nomcta, a_salact) VALUES ('199999999999','',0)
			ENDFOR
		CASE numlinactivo > numlinpasivo
			FOR ilin = 1 TO numlinactivo-numlinpasivo
				INSERT INTO tempor01(a_codcta , a_nomcta, a_salact) VALUES ('399999999999','',0)
			ENDFOR	
	ENDCASE
		
	** Si no hay registros de pasivo y capital, escribe uno slo para que salga el ttulo. Lo mismo con el activo.
	
	SELECT tempor01
	
	LOCATE FOR HASTARUBCUENTA(a_codcta,1) = "1" 
	IF NOT FOUND() THEN
		INSERT INTO tempor01 (a_codcta, a_nomcta, a_salact) VALUES ('199999999999',"",0)
	ENDIF
	
	
	LOCATE FOR HASTARUBCUENTA(a_codcta,1) = "2" OR (NOT XCAPITALENPASIVO AND HASTARUBCUENTA(a_codcta,1) = "3")
	IF NOT FOUND() THEN
		INSERT INTO tempor01 (a_codcta, a_nomcta, a_salact) VALUES ('399999999999',"",0)
	ENDIF
	
	
	SELECT tempor02.*, tempor01.*;
	FROM tempor01 LEFT OUTER JOIN tempor02 ON ALLTRIM(tempor02.ca_codcta) == HASTARUBCUENTA(tempor01.a_codcta,2);
	INTO TABLE (dirtemp+"wtemporal.dbf");
	ORDER BY a_codcta
		
	CLOSE DATA ALL
	
ENDPROC