*:*****************************************************************
*:	PROGRAMA	: CORP0900.PRG
*:	FECHA		: NOVIEMBRE DE 1998.
*:	FUNCION		: CONSULTA DE MOVIMIENTO ACUMULADO POR CUENTA.
*:	APLICACION	: SISTEMA INTEGRADO DE INFORMACION.
*:******************************************************************

PUBLIC OPCION, R_DESDE, R_HASTA, R_CUENTAINI, R_CUENTAFIN
SET PROCEDURE TO COLIB001 ADDITIVE
DO FORM corp0900.scx
IF OPCION = 1
	DO GENERA
	DO IMPRIME_REPORTE IN CILIB001 WITH ('CORP0900'), (''), ('CIRP0110')	
ENDIF
DO DESTRUYEVARIABLESMONEDAREP IN CILIB001
RELEASE OPCION, R_DESDE, R_HASTA, R_CUENTAINI, R_CUENTAFIN
CLOSE DATA ALL


PROCEDURE GENERA
	USE (cdirectorio + "CONFIG\OPCIONES") IN 0
	RESTORE FROM MEMO opciones.codigo ADDITIVE
	RESTORE FROM MEMO opciones.empresa ADDITIVE
	
	SELECT Comt0210.mo_codcta, Comt0200.mo_fecdoc, Comt0210.mo_numdoc,;
  	Comt0210.mo_concep, Comt0210.mo_cargos, Comt0210.mo_abonos,;
  	SUM(Comt0210.mo_cargos) AS cargos, SUM(Comt0210.mo_abonos) AS abonos,;
  	Comt0200.empresa, COMT0200.CMONEDA, COMT0200.TIPOCAMBIO;
 	FROM comt0200, comt0210;
	WHERE Comt0200.mo_numdoc = Comt0210.mo_numdoc;
   	AND Comt0200.empresa = Comt0210.empresa;
   	AND (Comt0210.mo_codcta >= R_CUENTAINI;
   	AND Comt0210.mo_codcta <= R_CUENTAFIN;
   	AND Comt0200.mo_fecdoc >= R_DESDE;
   	AND Comt0200.mo_fecdoc <= R_HASTA) AND COMT0200.MO_ACTUALIZ = .T.; 
   	AND COMT0200.EMPRESA = nCodigo AND COMT0210.EMPRESA = nCodigo AND;
   	POSTERIOROIGUALMES (MONTH(R_HASTA), YEAR(R_HASTA), COMT0200.NMES, COMT0200.ANYO) AND;
   	POSTERIOROIGUALMES (COMT0200.NMES, COMT0200.ANYO, MONTH(R_DESDE), YEAR(R_DESDE)) AND;
   	POSTERIOROIGUALMES (MONTH(R_HASTA), YEAR(R_HASTA), COMT0210.NMES, COMT0210.ANYO) AND;
   	POSTERIOROIGUALMES (COMT0210.NMES, COMT0210.ANYO, MONTH(R_DESDE), YEAR(R_DESDE));
   	GROUP BY Comt0210.mo_codcta;
	INTO TABLE (dirtemp+"wwtemporal.dbf")
	INDEX ON mo_codcta TAG mo_codcta
	CLOSE DATA ALL	 
	TRADUCETABLAMONEDAGAMMA(dirtemp+'wwtemporal','wtemporal',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, 'mo_fecdoc', 'mo_cargos, mo_abonos, cargos, abonos', '')
ENDPROC