*:*****************************************************************
*:	PROGRAMA	: CORP1100.PRG
*:	FECHA		: AGOSTO DE 1998.
*:	FUNCION		: INFORME: BALANCE DE COMPROBACIN
*:	APLICACION	: SISTEMA INTEGRADO DE INFORMACION.
*:******************************************************************
SET PROCEDURE TO COLIB001 ADDITIVE
PUBLIC OPCION, R_MES, R_ANYO, MODO
PUBLIC activos, pasivos, deudoras, acreedoras
PUBLIC XCAPITALENPASIVO, TOTALACTIVO, TOTALPASIVO, TOTALCAPITAL, TOTALCOSTOS, TOTALPRODUCTOS, TOTALAJUSTE
PUBLIC NOMBREACTIVO, NOMBREPASIVO, NOMBRECAPITAL, NOMBRECOSTOS, NOMBREPRODUCTOS, NOMBREAJUSTE, XMUESTRARESUMENCOMPROBACION
PUBLIC DEUDORAS, ACREEDORAS, TOTALDEUDORAS, TOTALACREEDORAS
PUBLIC DIMENSION DDEUDORAS [20,2]
PUBLIC DIMENSION DACREEDORAS [20,2]

	DO FORM CORP1100.SCX
	IF OPCION = 1 THEN
		XMUESTRARESUMENCOMPROBACION = LEEVARBOOLDEFECTO("XMUESTRARESUMENCOMPROBACION",.F.)
		TRADUCECOMT0100SEGUNVARIABLESMONEDAREP(R_MES, R_ANYO)		
		DEUDORAS = 0 
		ACREEDORAS = 0 
		
		IF XMUESTRARESUMENCOMPROBACION THEN
		
			&& Pone como resumen del balance de comprobacion las cuentas de primer nivel
			*USE WCOMT0100 IN 0 ALIAS WCOMT0100
			SELE WCOMT0100
			SET ORDER TO llave1
			SCAN FOR nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE) AND empresa = nCodigo AND CUENTAESRUB(WCOMT0100.ca_codcta,1)
				DO CASE 
					CASE ALLTRIM(WCOMT0100.ca_tipcta) == "Acreedora"
						ACREEDORAS = ACREEDORAS + 1
						DACREEDORAS[ACREEDORAS,1] = PROPER(ALLTRIM(WCOMT0100.ca_nomcta))
						DACREEDORAS[ACREEDORAS,2] = WCOMT0100.ca_salact
					
					CASE ALLTRIM(WCOMT0100.ca_tipcta) == "Deudora" 
						DEUDORAS = DEUDORAS + 1
						DDEUDORAS[DEUDORAS,1] = PROPER(ALLTRIM(WCOMT0100.ca_nomcta))
						DDEUDORAS[DEUDORAS,2] = WCOMT0100.ca_salact
				ENDCASE
			ENDSCAN
			
			&& Si hay alguna variable definida sobre el resumen del balance de comprobacin la aplica

			FOR i = 1 TO 20 
				DO ABRIRTABLAVARIABLES IN CILIB001
				variableabuscar = LEEVAR("XMAYORDEUDORA"+ALLTRIM(STR(i)),.T.)
				IF NOT ISNULL (variableabuscar) THEN
					LOCATE FOR ALLTRIM(CA_CODCTA) == variableabuscar AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE) AND empresa = nCodigo
					IF FOUND() THEN
						DDEUDORAS[i,1] = PROPER(ALLTRIM(WCOMT0100.ca_nomcta))
						DDEUDORAS[i,2] = WCOMT0100.ca_salact
						DEUDORAS = MAX(DEUDORAS,i)
					ENDIF
				ENDIF
				variableabuscar = LEEVAR("XMAYORACREEDORA"+ALLTRIM(STR(i)),.T.)
				IF NOT ISNULL (variableabuscar) THEN
					LOCATE FOR ALLTRIM(CA_CODCTA) == variableabuscar AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE) AND empresa = nCodigo
					IF FOUND() THEN
						DACREEDORAS[i,1] = PROPER(ALLTRIM(WCOMT0100.ca_nomcta))
						DACREEDORAS[i,2] = WCOMT0100.ca_salact
						ACREEDORAS = MAX(ACREEDORAS,i)
					ENDIF
				ENDIF
				DO CERRARTABLAVARIABLES IN CILIB001
			ENDFOR
			
			&& Saca los totales de cuentas deudoras y acreedoras para el resumen
			
			TOTALACREEDORAS = 0 
			FOR i = 1 TO ACREEDORAS
				TOTALACREEDORAS = TOTALACREEDORAS + DACREEDORAS[i,2]
			ENDFOR
		
			TOTALDEUDORAS = 0 
			FOR i = 1 TO DEUDORAS
				TOTALDEUDORAS = TOTALDEUDORAS + DDEUDORAS[i,2]
			ENDFOR
			SELE WCOMT0100
			USE
		ENDIF
		
		IF MODO = 1 THEN
			DO IMPRIME_REPORTE IN CILIB001 WITH ('CORP1110'), (''), ('CIRP0110')		
		ELSE
			DO IMPRIME_REPORTE IN CILIB001 WITH ('CORP1100'), (''), ('CIRP0110')		
		ENDIF
	ENDIF
DO DESTRUYEVARIABLESMONEDAREP IN CILIB001
RELEASE OPCION, R_MES, R_ANYO,  MODO
CLOSE DATA ALL


