LPARAMETERS mrevision, laversionhasta
PUBLIC versionejecutable, versiondata, modorevision, versionultimamodificacion, versionhasta
versionhasta = laversionhasta
modorevision = mrevision

SET PROC TO CILIB001 ADDITIVE
DO ZZSGRREVISIONANTIGA
SET PROC TO CILIB001 ADDITIVE

versionultimamodificacion = "7.0.0" && Se inicializa. Puede cambiar despus.
versionejecutable = NUMEROVERSIONEJECUTABLE()
versiondata = NUMEROVERSIONDATA()

IF versiondata == "7.0.0" THEN
	ESCRIBEVAR("XPRTPFLL","1",0)
	ESCRIBEVAR("XVPRTPGA","0",0)
ENDIF

*DO EXPANSIONVARIABLES


EJREVI('CreaDirectorioComun','','N','7.0.0')
	&& Crea el directorio comun
EJREVI('STOCKMAXIMOYMINIMOENCARACTERES','INVENTARIO','N','7.0.0')
	&& Si los campos stockmax y stockmin de inmt0400 son de tipo numrico, los transforma en de tipo carcter
EJREVI('AgregaCampoTrasladadoCobrosAIvmv0100','IVA','N','7.0.1')
	&& Aade un campo en ivmv0100 para marcar que la factura ha sido trasladada al mdulo de cuentas por cobrar
EJREVI('CreaTablaLogger','COMUN','N','7.0.2')
	&& Crea una tabla para el logger
EJREVI('AgregaComprobanteRetencionFacturacion','IVA','N','7.0.3')
	&& Aade comprobante de retencin como documento vlido en Facturacin
EJREVI('AgregaComprobanteRetencionInventario','INVENTARIO','N','7.0.3')
	&& Aade comprobante de retencin como documento vlido en Inventario
EJREVI('AgregaComprobanteRetencionCobros','COBROS','N','7.0.3')
	&& Aade comprobante de retencin como documento vlido en Cuentas por cobrar

** Graba versin en la base de datos
IF modorevision = 1 THEN 
	versionBdatos = versionultimamodificacion
ELSE
	versionBdatos =	versionhasta
ENDIF
	
OPEN DATABASE (dirraiz+"CONFIG\CONFIG")
DBSETPROP("config", "Database", "Comment", versionBdatos)
CLOSE DATA ALL


MESSAGEBOX("Revisin finalizada",48,"MILLENNIUM CONSULTING")

** GENERAL

PROCEDURE CreaDirectorioComun
	IF NOT DIRECTORY(dirraiz+"COMUN") THEN
		MKDIR (dirraiz+"COMUN")
	ENDIF
ENDPROC

PROCEDURE CreaTablaLogger
   CLOSE DATA ALL
   IF NOT FILE(dirraiz + 'COMUN\Logger') THEN
	   CREATE TABLE (dirraiz + 'COMUN\Logger') (Numero N(5), Tabla C(8) NOT NULL, Cuando T NOT NULL, Accion C(1) NOT NULL, Datos M NOT NULL NOCPTRANS, FormActivo C(8) )
   ENDIF
ENDPROC

** FACTURACION

PROCEDURE AgregaCampoTrasladadoCobrosAIvmv0100
	SET DEFA TO (dirraiz+"IVA")
	IF NOT EXISTECAMPOESTRUCTURA ('ivmv0100', 'traslacob')
		AGREGACAMPOTABLA('ivmv0100', 'traslacob','L',0,0)
	ENDIF
ENDPROC

PROCEDURE AgregaComprobanteRetencionFacturacion
	IF ANCHOCAMPO('ivgn0100','nombre') <> 24
		ALTERAANCHOCAMPOTABLA('ivgn0100','nombre',24)
		USE ivgn0100 IN 0 
		SELE ivgn0100
		LOCATE FOR codigo = 5
		IF NOT FOUND() THEN
			INSERT INTO ivgn0100 (codigo, nombre) VALUES(5, 'Comprobante de retencin')	 
		ENDIF
		USE IN ivgn0100 
	ENDIF
ENDPROC

** INVENTARIO

PROCEDURE STOCKMAXIMOYMINIMOENCARACTERES
	LOCAL ancho, decimales
	SET DEFA TO (dirraiz+"INVENTARIO")
	IF TIPOCAMPO ('inmt0400', 'stockmax') <> 'C' THEN
		ancho = ANCHOCAMPO('inmt0400', 'stockmax')
		ALTERATIPOCAMPOTABLA('inmt0400', 'stockmax', 'C', ancho, 0)
	ENDIF
	IF TIPOCAMPO ('inmt0400', 'stockmin') <> 'C' THEN
		ancho = ANCHOCAMPO('inmt0400', 'stockmin')
		ALTERATIPOCAMPOTABLA('inmt0400', 'stockmin', 'C', ancho, 0)
	ENDIF
ENDPROC

PROCEDURE AgregaComprobanteRetencionInventario
	IF ANCHOCAMPO('ingn0100','nombre') <> 24
		ALTERAANCHOCAMPOTABLA('ingn0100','nombre',24)
		USE ingn0100 IN 0 
		SELE ingn0100
		LOCATE FOR codigo = 5
		IF NOT FOUND() THEN
			INSERT INTO ingn0100 (codigo, nombre) VALUES(5, 'Comprobante de retencin')	 
		ENDIF
		USE IN ingn0100 
	ENDIF
ENDPROC

** CUENTAS POR COBRAR


PROCEDURE AgregaComprobanteRetencionCobros
	IF ANCHOCAMPO('cbgn0100','nombre') <> 24
		ALTERAANCHOCAMPOTABLA('cbgn0100','nombre',24)
		USE cbgn0100 IN 0 
		SELE cbgn0100
		LOCATE FOR codigo = 5
		IF NOT FOUND() THEN
			INSERT INTO cbgn0100 (codigo, nombre) VALUES(5, 'Comprobante de retencin')	 
		ENDIF
		USE IN cbgn0100 
	ENDIF
ENDPROC

** Definicin de EJECUTAR REVISION

PROCEDURE EJREVI(nombre, modulo, tipo, versionqueseintrodujo) &&Realmente no es mdulo, sino directorio.
	IF EXISTEMODULO(modulo) THEN
		SET DEFA TO (dirraiz+modulo)
		IF modorevision = 1 OR (modorevision = 2 AND MAYOROIGUALNUMEROVERSION(versionhasta, versionqueseintrodujo)) THEN
			DO &nombre
		ENDIF
		IF MAYORNUMEROVERSION(versionqueseintrodujo,versionultimamodificacion) THEN
			versionultimamodificacion = versionqueseintrodujo
		ENDIF
	ENDIF
ENDPROC

FUNCTION EXISTEMODULO(modulo)
	RETURN (EMPTY(modulo) OR DIRECTORY(dirraiz+modulo))
ENDFUNC

PROCEDURE MAYOROIGUALNUMEROVERSION(num1, num2)
	RETURN MAYORNUMEROVERSION(num1,num2) OR IGUALESNUMEROSVERSION(num1, num2)
ENDPROC 

PROCEDURE IGUALESNUMEROSVERSION(num1, num2)
	num1 = ALLTRIM(UPPER(num1))
	num2 = ALLTRIM(UPPER(num2))

	RETURN (numeromayor(num1) = numeromayor(num2)) AND (numeromenor(num1) = numeromenor(num2)) AND (numerorevision(num1) = numerorevision(num2))
ENDPROC

PROCEDURE MAYORNUMEROVERSION(num1, num2)
	num1 = ALLTRIM(UPPER(num1))
	num2 = ALLTRIM(UPPER(num2))
	
	RETURN (numeromayor(num1) > numeromayor(num2)) OR (numeromayor(num1) = numeromayor(num2) AND numeromenor(num1) > numeromenor(num2))	OR (numeromayor(num1) = numeromayor(num2) AND numeromenor(num1) = numeromenor(num2) AND numerorevision(num1) > numerorevision(num2))
ENDPROC


PROCEDURE NUMEROMAYOR(versionactual) 
	IF EMPTY(versionactual) THEN
		RETURN 7
	ELSE
		nmay = SUBSTR(versionactual,1,AT(".",versionactual)-1)
		IF EMPTY(nmay) OR VAL(nmay) = 5 THEN
			RETURN 7
		ELSE
			RETURN VAL(nmay)
		ENDIF
	ENDIF 
ENDPROC

PROCEDURE NUMEROMENOR(versionactual) 
	IF EMPTY(versionactual) THEN
		RETURN 0
	ELSE
		nmay = SUBSTR(versionactual,AT(".",versionactual)+1, AT(".",versionactual,2)- AT(".",versionactual))
		IF EMPTY(nmay) OR VAL(SUBSTR(versionactual,1,AT(".",versionactual)-1)) = 5 THEN
			RETURN 0
		ELSE
			RETURN VAL(nmay)
		ENDIF
	ENDIF 
ENDPROC

PROCEDURE NUMEROREVISION(versionactual) 
	IF EMPTY(versionactual) THEN
		RETURN 0
	ELSE
		nmay = SUBSTR(versionactual,AT(".",versionactual,2)+1)
		IF EMPTY(nmay) OR VAL(SUBSTR(versionactual,1,AT(".",versionactual)-1)) = 5 THEN
			RETURN 0
		ELSE
			RETURN VAL(nmay)
		ENDIF
	ENDIF 
ENDPROC

PROCEDURE NORMALIZANUMEROVERSION(num)
	RETURN ALLTRIM(STR(NUMEROMAYOR(num)))+"."+ALLTRIM(STR(NUMEROMENOR(num)))+"."+ALLTRIM(STR(NUMEROREVISION(num)))
ENDPROC

PROCEDURE NUMEROVERSIONEJECUTABLE()
	LOCAL resultado
	lnReply = AGETFILEVERSION(aVer, dirraiz+"GESTION.EXE")
	IF lnReply = 0 THEN
		resultado = "7.0.0"
	ELSE
	 	resultado = NORMALIZANUMEROVERSION(aVer[4])
	ENDIF
	RETURN resultado
ENDPROC

PROCEDURE NUMEROVERSIONDATA()
	LOCAL versiodata
	OPEN DATABASE (dirraiz+"CONFIG\CONFIG")
	versiodata = DBGETPROP("config", "Database", "Comment")
	CLOSE DATA ALL
	RETURN NORMALIZANUMEROVERSION(versiodata)
ENDPROC

PROCEDURE EUREKA()
	RETURN "Eureka"
ENDPROC