CLOSE DATA ALL

SET PROC TO (dirraiz+"CILIB001.PRG")


SET DEFAULT TO &dirraiz
DO ENTORNO 

SET EXCLUSIVE ON

DO NOVEDADES
DO CONFIGURACION

EJREV('AGREGACAMPOSOLOREP','N','01/02/27')
	* Agrega el campo solorep en la tabla cfmt0100
EJREV('TRADUCEINDICECODIGOCONUPPER', 'N','01/02/27' )
	*La expresin del ndice cdigo de inmt0400 que era 'codigo' pasa a ser 'UPPER(codigo)'
EJREV('CAMBIAANCHOTIPOCAMBIOFORMULARIO', 'N','01/03/09' )
	* El campo tipoform de la tabla cfmt0110 pasa a ser de 16 digitos y 8 decimales
	



PROCEDURE EJREV(nomproc, modo, fecha)
	DO &nomproc
ENDPROC


PROCEDURE NOVEDADES
	DO ZZSGRLLEVAFXP WITH .F.
	
	IF NOT FILE(dirraiz+"CONFIG\VARIABLES.DBF") THEN
		SET DEFA TO (dirraiz+"CONFIG")
		OPEN DATABASE config
		CREATE TABLE variables (rubro C(50), cuenta C(254), saldo C(10))
		USE
	ELSE
		SET DEFA TO (dirraiz+"CONFIG")
		IF EXISTECAMPOESTRUCTURA('variables','empresa') THEN
			AGREGACAMPOTABLA('variables','rubro','C',50,0)
			AGREGACAMPOTABLA('variables','cuenta','C',254,0)
			AGREGACAMPOTABLA('variables','saldo','C',10,0)
			USE variables IN 0 ALIAS variables
			SELE variables
			REPLACE ALL rubro WITH VTR(ALLTRIM(UPPER(nombre)),50)
			REPLACE ALL cuenta WITH V2R(ALLTRIM(UPPER(valor)),nombre,254)
			REPLACE ALL saldo WITH VTR(ALLTRIM(STR(empresa)),10)
			
			ELIMINACAMPOTABLA('variables','nombre')
			ELIMINACAMPOTABLA('variables','valor')
			ELIMINACAMPOTABLA('variables','empresa')
		ENDIF
	ENDIF
	
	
	IF DIRECTORY(dirraiz+"CONTABLE") THEN
		DO NOVEDADES_CONTABILIDAD
	ENDIF
	IF DIRECTORY(dirraiz+"IVA") THEN
		DO NOVEDADES_FACTURACION
	ENDIF
	IF DIRECTORY(dirraiz+"INVENTARIO") THEN
		DO NOVEDADES_INVENTARIO
	ENDIF
	IF DIRECTORY(dirraiz+"PLANILLA") THEN
		DO NOVEDADES_PLANILLA
	ENDIF
	
	DO NOVEDADES_MODULO_CONFIGURACION
	
	DO DEFINECAMPOSMONEDAEXISTENTES 
ENDPROC

PROCEDURE CONFIGURACION
	IF DIRECTORY(dirraiz+"IVA") THEN
		DO CONFIGURACION_FACTURACION
	ENDIF
	IF DIRECTORY(dirraiz+"INVENTARIO") THEN
		DO CONFIGURACION_INVENTARIO
	ENDIF
	IF DIRECTORY(dirraiz+"PLANILLA") THEN
		DO CONFIGURACION_PLANILLA
	ENDIF
	DO CONFIGURACION_MODULO_CONFIGURACION
ENDPROC

*****************************************************************************
*                 				CONFIGURACION 			                    *
*                                                                           *
*****************************************************************************


PROCEDURE NOVEDADES_MODULO_CONFIGURACION
	SET DEFAULT TO (dirraiz+"CONFIG")
	DO CREA_TABLA_MONEDAS
ENDPROC

PROCEDURE CONFIGURACION_MODULO_CONFIGURACION
	SET DEFAULT TO (dirraiz+"CONFIG")
	DO CREAMONEDASBIMONETARIAS	
ENDPROC

PROCEDURE CREA_TABLA_MONEDAS
	IF NOT FILE(dirraiz+"CONFIG\CFMT0100.DBF") THEN
		OPEN DATABASE config
		CREATE TABLE cfmt0100 (codigo N(2,0), nomsing C(40), nomplural C(40), base L, empresa N(2,0), solorep L)
		INDEX ON codigo TAG codigo
		INDEX ON nomplural TAG nomplural
		CREATE TABLE cfmt0110 (codigo N(2,0), desde D, hasta D, modo N(1,0) DEFAULT 1, tipoform N(12,4) DEFAULT 1, tipocambio N(16,8), empresa N(2,0))
		INDEX ON codigo TAG codigo
		INDEX ON desde TAG desde
		INDEX ON STR(codigo)+IIF(EMPTY(desde),"A",IIF(EMPTY(hasta),"Z","L"+DTOS(desde))) TAG codidesde
		CLOSE DATA ALL
	ENDIF
ENDPROC

PROCEDURE CREAMONEDASBIMONETARIAS	
	XMULTIMONEDA = LEEVARNUMDEFECTO('XMULTIMONEDA',0)
	IF XMULTIMONEDA = 0 OR XMULTIMONEDA = 1 THEN
		USE (dirraiz+"CONFIG\CFMT0100.DBF") IN 0 ALIAS CFMT0100
		COUNT TO nummonedas
		IF nummonedas = 0 THEN
			USE (dirraiz+"CONFIG\CFMT0110.DBF") IN 0 ALIAS CFMT0110
			USE (dirraiz+"CONFIG\EMPRESAS.DBF") IN 0 ALIAS EMPRESAS
			SELE EMPRESAS
			SCAN
				codiempresa = empresas.codigo
				INSERT INTO CFMT0100 (codigo, nomsing, nomplural, base, empresa, solorep) VALUES (1, 'Coln', 'Colones', .T., codiempresa, .F.)
				IF XMULTIMONEDA = 1 THEN
					INSERT INTO CFMT0100 (codigo, nomsing, nomplural, base, empresa, solorep) VALUES (2, 'Dlar', 'Dlares', .F., codiempresa, .F.)
					INSERT INTO CFMT0110 (codigo, desde, hasta, modo, tipoform, tipocambio, empresa) VALUES (2, {}, {}, 2, 8.75, 0.11428571, codiempresa)
				ENDIF
			ENDSCAN
		ENDIF
		CLOSE DATA ALL						
	ENDIF
ENDPROC

PROCEDURE AGREGACAMPOSOLOREP
	IF NOT EXISTECAMPOESTRUCTURA('cfmt0100','solorep') THEN
		AGREGACAMPOTABLA('cfmt0100','solorep','L',0,0)
	ENDIF
ENDPROC

PROCEDURE CAMBIAANCHOTIPOCAMBIOFORMULARIO
	SET DEFA TO dirraiz+"CONFIG"
	IF DECIMALESCAMPO("CFMT0110", "tipoform") = 4 THEN
		ALTERAANCHOCAMPOTABLA("CFMT0110","tipoform",16)
		FIJADECIMALESCAMPOTABLA("CFMT0110","tipoform",8)
	ENDIF
ENDPROC


*****************************************************************************
*                 					CONTABILIDAD   			                *
*                                                                           *
*****************************************************************************

PROCEDURE NOVEDADES_CONTABILIDAD
	SET DEFAULT TO (dirraiz+"CONTABLE")
	DO REFORMAR_TABLA_COMT0500
ENDPROC

PROCEDURE REFORMAR_TABLA_COMT0500
	IF NOT EXISTECAMPOESTRUCTURA ('comt0500', 'formato') THEN
		AGREGACAMPOTABLA('comt0500','formato','C',20,0)
		USE (dirraiz+"CONTABLE\comt0500.dbf") IN 0 ALIAS comt0500
		REPLACE ALL FORMATO WITH 'A'
		USE
	ENDIF
	
	IF NOT EXISTECAMPOESTRUCTURA ('comt0500', 'cenreserva') THEN
		AGREGACAMPOTABLA('comt0500','cenreserva','N',3,2)
		USE (dirraiz+"CONTABLE\comt0500.dbf") IN 0 ALIAS comt0500
		REPLACE ALL cenreserva WITH 7.00
		USE
	ENDIF
	
	IF NOT EXISTECAMPOESTRUCTURA ('comt0500', 'otrosprod') THEN
		AGREGACAMPOTABLA('comt0500','otrosprod','C',20,0)
	ENDIF
ENDPROC

*****************************************************************************
*                 					FACTURACION   			                *
*                                                                           *
*****************************************************************************
PROCEDURE NOVEDADES_FACTURACION
	SET DEFAULT TO (dirraiz+"IVA")
	DO AGREGACAMPOSIVMT0200
	DO PREPARA_TRASLADO_INVENTARIO 
	DO CREA_VENDEDORES_Y_FECHA_PAGO
ENDPROC

PROCEDURE CONFIGURACION_FACTURACION
	SET DEFAULT TO (dirraiz+"IVA")
	DO PROC_ENTEROS_Y_DECIMALESDETALLEFACTURAS
ENDPROC

PROCEDURE PREPARA_TRASLADO_INVENTARIO 

	IF NOT EXISTECAMPOESTRUCTURA ('ivmv0100', 'trasladado')
		AGREGACAMPOTABLA('ivmv0100', 'trasladado','L',0,0)
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('ivmv0100', 'bodega')
		AGREGACAMPOTABLA('ivmv0100', 'bodega','N',2,0)
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('ivmv0110', 'atrasladar')
		AGREGACAMPOTABLA('ivmv0110', 'atrasladar','L',0,0)
	ENDIF
	numcod = LEEVARNUMDEFECTO('XYINLONGITUDCODIGOPRODUCTO', 15)
	IF NOT EXISTECAMPOESTRUCTURA ('ivmv0110', 'codiprod')
		AGREGACAMPOTABLA('ivmv0110', 'codiprod','C',numcod,0)
	ENDIF
	IF ANCHOCAMPO('ivmv0110','codiprod') <> numcod THEN 
		ALTERAANCHOCAMPOTABLA('ivmv0110','codiprod',numcod)
	ENDIF
ENDPROC

PROCEDURE PROC_ENTEROS_Y_DECIMALESDETALLEFACTURAS
	enterosvar = LEEVARNUMDEFECTO('XYIVENTEROSCANTIDADDETALLE',6)
	dec = LEEVARNUMDEFECTO('XYIVDECIMALESCANTIDADDETALLE',0)
	anchopunto = IIF(dec = 0,0,1)
	
	IF (DECIMALESCAMPO('ivmv0110','cantidad')<>dec) THEN
		FIJADECIMALESCAMPOTABLA('ivmv0110','cantidad',dec)
	ENDIF
	
	IF (ANCHOCAMPO('ivmv0110','cantidad') <> enterosvar + dec + anchopunto) THEN
		ALTERAANCHOCAMPOTABLA('ivmv0110','cantidad',enterosvar+dec+anchopunto)
	ENDIF
ENDPROC

PROCEDURE CREA_VENDEDORES_Y_FECHA_PAGO
	IF NOT EXISTECAMPOESTRUCTURA ('ivmt0300', 'codigo') THEN
		OPEN DATABASE ivmenu00
		REMOVE TABLE ivmt0300 DELETE RECYCLE
		CREATE TABLE ivmt0300 (codigo C(5), apellido C(40), nombre C(40), estado N(1,0), empresa N(2))
		INDEX ON codigo TAG codigo
		CLOSE DATABASES
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('ivmv0100', 'vendedor') THEN
		AGREGACAMPOTABLA('ivmv0100','vendedor','C',5,0)
		USE IVMV0100 IN 0 
		SELE IVMV0100
		INDEX ON vendedor+DTOS(fecdoc) TAG vendefecha
		DELETE TAG llave1 
		INDEX ON DTOS(fecdoc)+STR(tipmov)+STR(tipdoc)+STR(aplica)+STR(numdoc)+numiva TAG llave1
		USE
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('ivmv0100', 'fecpago') THEN
		AGREGACAMPOTABLA('ivmv0100','fecpago','D',0,0)
	ENDIF
ENDPROC

PROCEDURE AGREGACAMPOSIVMT0200
	IF NOT EXISTECAMPOESTRUCTURA ('ivmt0200', 'codigo')
		AGREGACAMPOTABLA('ivmt0200', 'codigo','C',15,0)
		USE IVMT0200 IN 0 ALIAS IVMT0200
		SELE IVMT0200
		INDEX ON codigo TAG codigo
		USE
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('ivmt0200', 'munici')
		AGREGACAMPOTABLA('ivmt0200', 'munici','C',40,0)
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('ivmt0200', 'departa')
		AGREGACAMPOTABLA('ivmt0200', 'departa','C',20,0)
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('ivmt0200', 'concepfac')
		AGREGACAMPOTABLA('ivmt0200', 'concepfac','C',30,0)
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('ivmt0200', 'cuotafac')
		AGREGACAMPOTABLA('ivmt0200', 'cuotafac','C',20,8)
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('ivmt0200', 'exento')
		AGREGACAMPOTABLA('ivmt0200', 'exento','L',0,0)
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('ivmt0200', 'aplica')
		AGREGACAMPOTABLA('ivmt0200', 'aplica','N',1,0)
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('ivmt0200', 'tipoiva')
		AGREGACAMPOTABLA('ivmt0200', 'tipoiva','N',4,2)
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('ivmt0200', 'giro')
		AGREGACAMPOTABLA('ivmt0200', 'giro','C',40,0)
	ENDIF	
ENDPROC

*****************************************************************************
*                 					INVENTARIO   			                *
*                                                                           *
*****************************************************************************
	
PROCEDURE NOVEDADES_INVENTARIO
	SET DEFAULT TO (dirraiz+"INVENTARIO")
	IF NOT FILE(dirraiz+"INVENTARIO\INMV0120.DBF") THEN
		CREATE TABLE INMV0120 (correla N(12,0), fecha D, tipcomp N(2,0), entrada L, unidadin C(15), bodegaini N(2,0), bodegafin N(2,0), empresa N(2,0), sucursal N(2,0), nmes N(2,0), anyo N(4,0))
		INDEX ON correla TAG correla
		INDEX ON unidadin TAG unidadin
		USE
	ENDIF	
	DO IN_TRANSFORMA_MOVIMIENTOS_EN_TIPO_FACTURA
	
	DO PROC_UNIDADESINDIVIDUALES
	
	USE inmv0105 IN 0 ALIAS inmv0105 EXCLUSIVE
	IF EXISTENOMBREINDICE('calcular') THEN
		DELETE TAG CALCULAR
	ENDIF
	USE
	IF NOT FILE(dirraiz+"INVENTARIO\INMV0400.DBF") THEN
		CREA_TABLA_INMV0400()
	ELSE
		USE (dirraiz+"INVENTARIO\INMV0400.DBF") IN 0 ALIAS INMV0400
		SELE INMV0400
		IF NOT EXISTENOMBREINDICE('correla') THEN
			INDEX ON correla TAG CORRELA
		ENDIF
		USE
	ENDIF
	DO AGREGA_CAMPO_TRASLADADO_A_inmv0105 
	*DO BORRA_CAMPOS_DE_inmv0105 
	DO ESCRIBE_CAMPOS_CONCEPTO
ENDPROC

PROCEDURE CONFIGURACION_INVENTARIO
	DO PROC_DECIMALESINVENTARIO


	XYINVORDENMEJORADO = LEEVARBOOLDEFECTO('XYINVORDENMEJORADO',.F.)

	IF XYINVORDENMEJORADO THEN
		DO PROC_TRUEINVORDENMEJORADO
	ELSE
		DO PROC_FALSEINVORDENMEJORADO
	ENDIF
	DO PROC_STRINGCARACTERISTICAS
	
	DO PROC_LONGITUDCODIGOINVENTARIO	
	
	DO PROC_CONFIGURAIVAMOVIMIENTOS
ENDPROC
	
PROCEDURE PROC_DECIMALESINVENTARIO
	PRIVATE dec, ancho, deccantidad, decstoini, decstoact, decpvaunidadini, decpvaunidadfin
	
	SET DEFAULT TO (dirraiz+"INVENTARIO")
	entmov = VAL(LEEVARDEFECTO('XYINENTEROSMOVIMIENTOS','6'))
	entsto = VAL(LEEVARDEFECTO('XYINENTEROSSTOCKS','10'))
	dec = VAL(LEEVARDEFECTO('XYDECIMALESINVENTARIO','0'))
	anchopunto = IIF(dec = 0,0,1)
	IF entmov + dec +anchopunto > 20 OR entsto + dec + anchopunto > 20 THEN
		MESSAGEBOX("El nmero de dgitos en el inventario no puede ser mayor a 20", 48, "MILLENNIUM CONSULTING")
	ELSE
		FIJADECIMALESYENTEROSCAMPOSIDIFERENTES('inmv0115','cantidad',entmov,dec)
		FIJADECIMALESYENTEROSCAMPOSIDIFERENTES('inmv0100','stoini',entsto,dec)
		FIJADECIMALESYENTEROSCAMPOSIDIFERENTES('inmv0100','stoact',entsto,dec)
		FIJADECIMALESYENTEROSCAMPOSIDIFERENTES('inmt0400','stockmin',entsto,dec)
		FIJADECIMALESYENTEROSCAMPOSIDIFERENTES('inmt0400','stockmax',entsto,dec)
		IF FILE(dirraiz+"INVENTARIO\INMV0400.DBF")
			FIJADECIMALESYENTEROSCAMPOSIDIFERENTES('inmv0400','unidadini',entmov,dec)
			FIJADECIMALESYENTEROSCAMPOSIDIFERENTES('inmv0400','unidadfin',entmov,dec)
		ENDIF
	ENDIF

ENDPROC

PROCEDURE PROC_TRUEINVORDENMEJORADO
	CLOSE DATA ALL
	SET DEFAULT TO (dirraiz+"INVENTARIO")
	*USE inmv0105 IN 0 ALIAS inmv0105 EXCLUSIVE
	*IF EXISTENOMBREINDICE('cronos') THEN
	*	DELETE TAG CRONOS
	*ENDIF
	*INDEX ON DTOC(fecha,1)+IIF(tipcomp=1 OR tipcomp = 3 OR tipcomp = 13 OR tipcomp = 16,"A",IIF(tipcomp = 10, "Z", "M"))+STR(correla) TAG cronos
	*IF EXISTENOMBREINDICE('calculart') THEN
	*	DELETE TAG CALCULART
	*ENDIF
	*INDEX ON producto+DTOC(fecha,1)+IIF(tipcomp=1 OR tipcomp = 3 OR tipcomp = 13 OR tipcomp = 16,"A",IIF(tipcomp = 10, "Z", "M"))+STR(correla) TAG calculart
	*CLOSE DATA ALL
	IF LEEVARBOOLDEFECTO('XYUNIDADESINDIVIDUALES',.F.) THEN
		USE INMV0120 IN 0 ALIAS INMV0120 EXCLUSIVE
		IF EXISTENOMBREINDICE('cronos') THEN
			DELETE TAG CRONOS
		ENDIF
		INDEX ON DTOC(fecha,1)+IIF(tipcomp=1 OR tipcomp = 3 OR tipcomp = 13 OR tipcomp = 16,"A",IIF(tipcomp = 10, "Z", "M"))+IIF(entrada,"1","2")+STR(correla) TAG cronos
		CLOSE DATA ALL
	ENDIF
ENDPROC

PROCEDURE PROC_FALSEINVORDENMEJORADO
	CLOSE DATA ALL
	SET DEFAULT TO (dirraiz+"INVENTARIO")
	*USE inmv0105 IN 0 ALIAS inmv0105 EXCLUSIVE
	*IF EXISTENOMBREINDICE('cronos') THEN
	*	DELETE TAG CRONOS
	*ENDIF
	
	*INDEX ON DTOC(fecha,1)+IIF(tipcomp=10,"Z","A")+STR(correla) TAG cronos
	
	*IF EXISTENOMBREINDICE('calculart') THEN
	*	DELETE TAG CALCULART
	*ENDIF
	*INDEX ON producto+DTOC(fecha,1)+IIF(tipcomp=10,"Z","A")+STR(correla) TAG calculart
	*CLOSE DATA ALL
	IF LEEVARBOOLDEFECTO('XYUNIDADESINDIVIDUALES',.F.) THEN
		USE INMV0120 IN 0 ALIAS INMV0120 EXCLUSIVE
		IF EXISTENOMBREINDICE('cronos') THEN
			DELETE TAG CRONOS
		ENDIF
		INDEX ON DTOC(fecha,1)+IIF(tipcomp=10,"Z","A")+STR(correla) TAG cronos
		CLOSE DATA ALL
	ENDIF
ENDPROC

PROCEDURE PROC_STRINGCARACTERISTICAS
	LOCAL tipocampo
	SET DEFAULT TO (dirraiz+'INVENTARIO')
	tipocampo = TIPOCAMPO('INMT0410','cantidad')
	XYINSTRINGCARACTERISTICAS = LEEVARBOOLDEFECTO ('XYINSTRINGCARACTERISTICAS', .F.)
	IF XYINSTRINGCARACTERISTICAS AND tipocampo = 'N'
		ALTERATIPOCAMPOTABLA('INMT0410','cantidad','C',15,0)
	ENDIF
	IF NOT XYINSTRINGCARACTERISTICAS AND tipocampo = 'C'
		ALTERATIPOCAMPOTABLA('INMT0410','cantidad','N',15,4)
	ENDIF
ENDPROC

PROCEDURE PROC_LONGITUDCODIGOINVENTARIO
	XYINLONGITUDCODIGO = LEEVARNUMDEFECTO('XYINLONGITUDCODIGOPRODUCTO',15)
	IF ANCHOCAMPO('inmt0400','codigo')<> XYINLONGITUDCODIGO THEN
		ALTERAANCHOCAMPOTABLA('inmt0400','codigo',XYINLONGITUDCODIGO)
		ALTERAANCHOCAMPOTABLA('inmt0410','codigo',XYINLONGITUDCODIGO)
		ALTERAANCHOCAMPOTABLA('inmt0500','prodini',XYINLONGITUDCODIGO)
		ALTERAANCHOCAMPOTABLA('inmt0500','prodfin',XYINLONGITUDCODIGO)
		ALTERAANCHOCAMPOTABLA('inmt0600','producto',XYINLONGITUDCODIGO)
		ALTERAANCHOCAMPOTABLA('inmv0100','producto',XYINLONGITUDCODIGO)
		ALTERAANCHOCAMPOTABLA('inmv0115','producto',XYINLONGITUDCODIGO)
	ENDIF	
ENDPROC





PROCEDURE PROC_UNIDADESINDIVIDUALES
	LOCAL XYUNIDADESINDIVIDUALES
	
	SET DEFAULT TO (dirraiz+'INVENTARIO')
	
	OPEN DATABASE inventario
	
	XYUNIDADESINDIVIDUALES = LEEVARBOOLDEFECTO('XYUNIDADESINDIVIDUALES',.F.) 
	
	IF NOT FILE(dirraiz+"INVENTARIO\INMT0600.DBF") THEN
		CREATE TABLE INMT0600 (codigo C(15), producto C(15), bodegaini N(2,0), bodegafin N(2,0), empresa N(2,0), nmes N(2,0), anyo N(4,0), posterior L)
		INDEX ON codigo TAG codigo
		INDEX ON producto TAG producto
		USE
	ENDIF
	
	IF NOT FILE(dirraiz+"INVENTARIO\INMT0610.DBF") THEN
		CREATE TABLE INMT0610 (codigo C(15), numdeta N(2,0), magnitud C(60), cantidad C(15), unidad C(60), deproducto L, empresa N(2,0), nmes N(2,0), anyo N(4,0), posterior L)
		INDEX ON codigo TAG codigo
		USE
	ENDIF
	
	
	
	CLOSE DATABASES
	
ENDPROC

PROCEDURE CREA_TABLA_INMV0400
	LOCAL elpva
	OPEN DATABASE inventario
	CREATE TABLE INMV0400 (correla N(12,0), fecha D, bodega N(2,0), pva C(50), unidadini N(6,0), unidadfin N(6,0), prodini C(15) , prodfin C(15), valunita N(15,2), valtot N(15,2), cosunitran N(15,2), empresa N(2,0), sucursal N(2,0), nmes N(2,0), anyo N(4,0))
	INDEX ON correla TAG correla
	USE
	entmov = VAL(LEEVARDEFECTO('XYINENTEROSMOVIMIENTOS','6'))
	dec = VAL(LEEVARDEFECTO('XYDECIMALESINVENTARIO','0'))
	anchopunto = IIF(dec = 0,0,1)
	IF entmov + dec +anchopunto > 20 THEN
		MESSAGEBOX("El nmero de dgitos en el inventario no puede ser mayor a 20", 48, "MILLENNIUM CONSULTING")
	ELSE
		FIJADECIMALESYENTEROSCAMPOSIDIFERENTES('inmv0400','unidadini',entmov,dec)
		FIJADECIMALESYENTEROSCAMPOSIDIFERENTES('inmv0400','unidadfin',entmov,dec)
	ENDIF
	CLOSE DATABASES 
ENDPROC


PROCEDURE AGREGA_CAMPO_TRASLADADO_A_inmv0105 
	IF NOT EXISTECAMPOESTRUCTURA ('inmv0105', 'trasladado')
		AGREGACAMPOTABLA('inmv0105', 'trasladado','L',0,0)
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('inmv0105', 'motivo')
		AGREGACAMPOTABLA('inmv0105', 'motivo','C',20,0)
	ENDIF
ENDPROC

PROCEDURE PROC_CONFIGURAIVAMOVIMIENTOS
	LOCAL conivamovi
	conivamovi = LEEVARBOOLDEFECTO('XYINMUESTRAIVAMOVIMIENTOS', .F.)
	IF (NOT EXISTECAMPOESTRUCTURA ('inmv0105', 'valiva')) THEN
		AGREGACAMPOTABLA('inmv0105', 'valiva','N',15,2)
	ENDIF
	IF (NOT EXISTECAMPOESTRUCTURA ('inmv0105', 'valtot')) THEN
		AGREGACAMPOTABLA('inmv0105', 'valtot','N',15,2)
	ENDIF
ENDPROC 

*PROCEDURE BORRA_CAMPOS_DE_inmv0105 
*	IF EXISTECAMPOESTRUCTURA('inmv0105','comenta') THEN
*		USE inmv0105
*		REPLACE ALL motivo WITH comenta FOR tipcomp = 12 OR tipcomp = 13
*		USE
*		ELIMINACAMPOTABLA('inmv0105','comenta')
*	ENDIF
*	IF EXISTECAMPOESTRUCTURA('inmv0105','pva') THEN
*		ELIMINACAMPOTABLA('inmv0105','pva')
*	ENDIF
*	IF EXISTECAMPOESTRUCTURA('inmv0105','prodfin') THEN
*		ELIMINACAMPOTABLA('inmv0105','prodfin')
*	ENDIF
*	IF EXISTECAMPOESTRUCTURA('inmv0105','unita') THEN
*		ELIMINACAMPOTABLA('inmv0105','unita')
*	ENDIF
*	IF EXISTECAMPOESTRUCTURA('inmv0105','costuni') THEN
*		ELIMINACAMPOTABLA('inmv0105','costuni')
*	ENDIF
*	IF EXISTECAMPOESTRUCTURA('inmv0105','costosal') THEN
*		ELIMINACAMPOTABLA('inmv0105','costosal')
*	ENDIF
*ENDPROC

PROCEDURE ESCRIBE_CAMPOS_CONCEPTO
	IF NOT EXISTECAMPOESTRUCTURA('ingn0110','nomlargo') THEN
		AGREGACAMPOTABLA('ingn0110', 'nomlargo','C',35,0)
		USE INGN0110 IN 0 
		SELE INGN0110
		DELETE ALL
		INDEX ON codigo TAG codigo
		INSERT INTO INGN0110 (codigo, tipomov, nomlargo) VALUES (1, "Compra", "Compra")
		INSERT INTO INGN0110 (codigo, tipomov, nomlargo) VALUES (2, "Venta", "Venta")
		INSERT INTO INGN0110 (codigo, tipomov, nomlargo) VALUES (3, "Entrada", "Entrada")
		INSERT INTO INGN0110 (codigo, tipomov, nomlargo) VALUES (4, "Salida", "Salida")
		INSERT INTO INGN0110 (codigo, tipomov, nomlargo) VALUES (10, "Ajuste", "Ajuste de inventario")
		INSERT INTO INGN0110 (codigo, tipomov, nomlargo) VALUES (12, "Salida proceso", "Salida por proceso industrial")
		INSERT INTO INGN0110 (codigo, tipomov, nomlargo) VALUES (13, "Entrada proceso", "Entrada por proceso industrial")
		INSERT INTO INGN0110 (codigo, tipomov, nomlargo) VALUES (14, "Transferencia", "Transferencia de bodegas")
		USE
	ENDIF
ENDPROC


PROCEDURE IN_TRANSFORMA_MOVIMIENTOS_EN_TIPO_FACTURA
	LOCAL seagregovaliva, seagregovaltot
	seagregovaliva = .F.
	seagregovaltot = .F.
	IF NOT FILE(dirraiz+'INVENTARIO\INMV0105.DBF') THEN
		SET DEFA TO (dirraiz+"INVENTARIO")
		OPEN DATABASE inventario
		REMOVE TABLE inmv0110 
		RENAME inmv0110.dbf TO inmv0105.dbf
		RENAME inmv0110.cdx TO inmv0105.cdx
		ADD TABLE inmv0105
		AGREGACAMPOTABLA('inmv0105','vtaexe','N',15,2)
		IF NOT EXISTECAMPOESTRUCTURA('inmv0105','valiva') THEN
			AGREGACAMPOTABLA('inmv0105','valiva','N',15,2)
			seagregovaliva = .T.
		ENDIF
		IF NOT EXISTECAMPOESTRUCTURA('inmv0105','valtot') THEN
			AGREGACAMPOTABLA('inmv0105','valtot','N',15,2)
			seagregovaltot = .T.
		ENDIF
		
		CREATE TABLE inmv0115 (correla N(12,0), corredeta C(16),producto C(15), cantidad N(6,0), unitario N(15,2), total N(15,2), exento N(1,0), valmov N(15,2), tipoent N(1,0), empresa N(2,0), nmes N(2,0), anyo N(4,0), tipcomp N(2,0))
		
		INDEX ON correla TAG correla
		INDEX ON corredeta TAG corredeta
		INDEX ON producto TAG producto
				
		USE inmv0105 IN 0 ALIAS inmv0105
		SELE inmv0105
		REPLACE ALL vtaexe WITH 0 
		IF seagregovaliva THEN
			REPLACE ALL valiva WITH 0 
		ENDIF
		IF seagregovaltot THEN
			REPLACE ALL valtot WITH 0 
		ENDIF
		
		SELE inmv0115
		APPEND FROM inmv0105 FIELDS correla, producto, cantidad, valmov, nmes, anyo, empresa, tipcomp
				
		REPLACE ALL corredeta  WITH STR(correla, 12)+"-"+STR(1,3) FOR tipcomp <> 13
	 	REPLACE ALL corredeta WITH STR(correla, 12)+"-"+STR(2,3) FOR tipcomp = 13
		
		REPLACE ALL total WITH valmov
		REPLACE ALL unitario WITH IIF(cantidad = 0, 0, valmov/cantidad)
	 	REPLACE ALL exento WITH 0
	 	
	 	REPLACE ALL tipoent WITH 0 FOR tipcomp = 10 OR tipcomp = 14
	 	REPLACE ALL tipoent WITH 1 FOR tipcomp = 1 OR tipcomp = 3 OR tipcomp = 13
	 	REPLACE ALL tipoent WITH 2 FOR tipcomp = 2 OR tipcomp = 4 OR tipcomp = 12
	 	
		ELIMINACAMPOTABLA('inmv0115','valmov')
		ELIMINACAMPOTABLA('inmv0115','tipcomp')
		SELE inmv0105
		DELETE ALL FOR tipcomp = 13
		DELETE TAG producto
		IF EXISTENOMBREINDICE('calcular') THEN
			DELETE TAG calcular
		ENDIF

		IF EXISTENOMBREINDICE('calculart') THEN
			DELETE TAG calculart
		ENDIF
		ELIMINACAMPOTABLA('inmv0105','producto')
		ELIMINACAMPOTABLA('inmv0105','cantidad')	
		CLOSE DATA ALL
		AGREGACAMPOTABLA('inmv0120', 'corredeta','C',16,0)
		AGREGACAMPOTABLA('inmv0120', 'tipoent','N',1,0)
		USE inmv0120 IN 0 ALIAS inmv0120
		SELE inmv0120
		INDEX ON corredeta TAG corredeta
		REPLACE ALL corredeta  WITH STR(correla, 12)+"-"+STR(1,3) FOR tipcomp <> 13
	 	REPLACE ALL corredeta WITH STR(correla, 12)+"-"+STR(2,3) FOR tipcomp = 13
	 	REPLACE ALL tipoent WITH 0 FOR tipcomp = 10 OR tipcomp = 14
	 	REPLACE ALL tipoent WITH 1 FOR tipcomp = 1 OR tipcomp = 3 OR tipcomp = 13
	 	REPLACE ALL tipoent WITH 2 FOR tipcomp = 2 OR tipcomp = 4 OR tipcomp = 12
	 	REPLACE tipcomp WITH 12 FOR tipcomp = 13
	 	CLOSE DATA ALL
	 	CREAVISTAINMV0110()
	ENDIF
ENDPROC

PROCEDURE CREAVISTAINMV0110
	SET DEFA TO (dirraiz+"INVENTARIO")
	IF NOT EXISTECAMPOESTRUCTURA ('inmt0400', 'individua')
		AGREGACAMPOTABLA('inmt0400','individua','L',0,0)
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('inmv0105', 'bodegafin')
		AGREGACAMPOTABLA('inmv0105', 'bodegafin','N',2,0)
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('inmv0105', 'motivo')
		AGREGACAMPOTABLA('inmv0105', 'motivo','C',20,0)
	ENDIF
	IF NOT EXISTECAMPOESTRUCTURA ('inmv0105', 'trasladado')
		AGREGACAMPOTABLA('inmv0105', 'trasladado','L',20,0)
	ENDIF
	
	OPEN DATABASE inventario
	CREATE SQL VIEW inmv0110 AS SELECT Inmv0115.corredeta, Inmv0115.producto, Inmv0115.cantidad,;
		Inmv0115.unitario, Inmv0115.total, Inmv0115.exento, Inmv0115.tipoent,;
 		Inmv0115.empresa, Inmv0115.nmes, Inmv0115.anyo, Inmv0105.correla,;
  		Inmv0105.fecha, Inmv0105.tipcomp, Inmv0105.tipdoc, Inmv0105.numdoc,;
  		Inmv0105.aplica, Inmv0105.valmov, Inmv0105.valiva, Inmv0105.valtot,;
  		Inmv0105.correfac, Inmv0105.bodega, Inmv0105.motivo, Inmv0105.bodegafin,;
  		Inmv0105.trasladado,;
  		IIF(Inmv0105.tipcomp=1.OR.Inmv0105.tipcomp=3.OR.Inmv0105.tipcomp=13.OR.Inmv0105.tipcomp=16,"A",IIF(Inmv0105.tipcomp=10,"Z","M"));
 	FROM  inventario!inmv0115 INNER JOIN inventario!inmv0105 ;
   		ON  Inmv0115.correla = Inmv0105.correla;
 	WHERE Inmv0115.nmes = Inmv0105.nmes;
   		AND Inmv0115.anyo = Inmv0105.anyo;
   		AND Inmv0115.empresa = Inmv0105.empresa;
 	ORDER BY Inmv0105.fecha, 25
 	CLOSE DATA ALL
ENDPROC

PROCEDURE TRADUCEINDICECODIGOCONUPPER 
	IF DIRECTORY(dirraiz+"INVENTARIO") THEN
		SET DEFA TO (dirraiz+"INVENTARIO")
		OPEN DATABASE inventario	
		USE INMT0400
		SELE INMT0400
		IF EXISTENOMBREINDICE('codigo') THEN
			IF NOT (ALLTRIM(UPPER(EXPRESIONINDICE('codigo'))) == 'UPPER(CODIGO)') THEN
				DELETE TAG CODIGO
				INDEX ON UPPER(CODIGO) TAG CODIGO
			ENDIF
		ENDIF
		USE
		CLOSE DATA ALL
	ENDIF
ENDPROC


*****************************************************************************
*                 					PLANILLA	   			                *
*                                                                           *
*****************************************************************************


PROCEDURE NOVEDADES_PLANILLA
	LOCAL llenar 
	SET DEFA TO (dirraiz+"PLANILLA")
	IF FILE(dirraiz+"PLANILLA\TEMPREC.DBF") THEN
		DELETE FILE (dirraiz+"PLANILLA\TEMPREC.DBF")
	ENDIF
	llenar = CREA_PLUT0600()
	IF llenar 
		DO CREA_CAMPOS_PERIODO
		DO LLENA_CAMPOS_PERIODO
	ENDIF
ENDPROC

FUNCTION CREA_PLUT0600
	LOCAL primeravez
	primeravez = .F.
	MULTIPLANILLA = LEEVARBOOLDEFECTO('XPLMULTIPLANILLA',.F.)
	IF FILE(dirraiz+"PLANILLA\PLUT0600.DBF") THEN
		IF EXISTECAMPOESTRUCTURA ('plut0600', 'desde') THEN
			OPEN DATABASE planilla
			REMOVE TABLE plut0600
			IF FILE(dirraiz+"PLANILLA\PLMV0100.DBF") THEN
				REMOVE TABLE plmv0100
				DELETE FILE (dirraiz+"PLANILLA\PLMV0100.DBF")
			ENDIF
			CLOSE DATABASE ALL
			RENAME (dirraiz+"PLANILLA\PLUT0600.DBF") TO (dirraiz+"PLANILLA\PL600ANT.DBF")
			primeravez = .T.
		ENDIF
	ENDIF
		
	IF (NOT FILE(dirraiz+"PLANILLA\PLUT0600.DBF")) AND (NOT FILE(dirraiz+"PLANILLA\PLUT0610.DBF")) THEN
		primeravez = .T.
		OPEN DATABASE planilla
		CREATE TABLE PLUT0600 (empresa N(2,0), sucursal N(2,0), permin N(6), permax N(6), peractivo N(6))
		CREATE TABLE PLUT0610 (periodo N(6), desde D, hasta D, empresa N(2,0), sucursal N(2,0), quincenal L, mensual L, anual L)
		IF FILE(dirraiz+"PLANILLA\PLMV0100.DBF") THEN
			USE PLMV0100 IN 0 ALIAS PLMV0100
			SELE PLMV0100
			GO TOP
			DO WHILE NOT EOF()
				IF PLMV0100.ESTADO = 1 THEN
					SELE PLUT0610
					LOCATE FOR empresa = plmv0100.empresa
					IF NOT FOUND() THEN
						APPEND BLANK
						REPLACE empresa WITH plmv0100.empresa
						REPLACE desde WITH plmv0100.fecini
						REPLACE hasta WITH plmv0100.fecfin
						REPLACE periodo WITH 1 &&IIF(MULTIPLANILLA,plmv0100.numplan,1)
						SELE PLUT0600
						APPEND BLANK
						REPLACE empresa WITH plmv0100.empresa
						REPLACE permin WITH 1 
						REPLACE permax WITH 1 
						REPLACE peractivo WITH 1 
					ENDIF 			
					SELE PLMV0100
				ENDIF	
				SKIP
			ENDDO
			USE
		ELSE
			IF FILE(dirraiz+"PLANILLA\PL600ANT.DBF") THEN
				USE PL600ANT IN 0 ALIAS PL600ANT
				SELE PL600ANT
				GO TOP
				DO WHILE NOT EOF()
					SELE PLUT0610
					LOCATE FOR empresa = pl600ant.empresa
					IF NOT FOUND() THEN
						APPEND BLANK
						REPLACE empresa WITH pl600ant.empresa
						REPLACE desde WITH pl600ant.desde
						REPLACE hasta WITH pl600ant.hasta
						REPLACE periodo WITH 1 
						SELE PLUT0600
						APPEND BLANK
						REPLACE empresa WITH pl600ant.empresa
						REPLACE permin WITH 1 
						REPLACE permax WITH 1 
						REPLACE peractivo WITH 1 
					ENDIF 			
					SELE PL600ANT
					SKIP
				ENDDO
				USE
			ENDIF
		ENDIF
		SELE PLUT0610
		INDEX ON periodo TAG periodo 
	ENDIF
	CLOSE DATA ALL
	RETURN primeravez
ENDFUNC

PROCEDURE CREA_CAMPOS_PERIODO
	FOR nt = 1 TO 6
		IF NOT EXISTECAMPOESTRUCTURA ('plmt0'+ALLTRIM(STR(nt))+'00', 'periodo')
			AGREGACAMPOTABLA('plmt0'+ALLTRIM(STR(nt))+'00', 'periodo','N',6,0)
			AGREGACAMPOTABLA('plmt0'+ALLTRIM(STR(nt))+'00', 'posterior','L',0,0)
		ENDIF
	ENDFOR
	IF NOT EXISTECAMPOESTRUCTURA ('plmv0200', 'periodo')
		AGREGACAMPOTABLA('plmv0200', 'periodo','N',6,0)
	ENDIF
	
ENDPROC


PROCEDURE LLENA_CAMPOS_PERIODO

	esplanilla = LEEVARBOOLDEFECTO("XPLMULTIPLANILLA",.F.)
	IF esplanilla THEN
		DIMENSION periodoempresa (1000)
		USE PLUT0600 IN 0 ALIAS PLUT0600
		SELE PLUT0600
		GO TOP
		DO WHILE NOT EOF()
			periodoempresa(plut0600.empresa) = plut0600.peractivo	
			SKIP
		ENDDO
		USE
	ENDIF
	
	USE PLMT0100 IN 0 ALIAS PLMT0100
	SELE PLMT0100
	REPLACE ALL periodo WITH 1 
	REPLACE ALL posterior WITH .F.
	USE
	USE PLMT0200 IN 0 ALIAS PLMT0200
	SELE PLMT0200
	REPLACE ALL periodo WITH 1 
	REPLACE ALL posterior WITH .F.
	USE
	USE PLMT0300 IN 0 ALIAS PLMT0300
	SELE PLMT0300
	REPLACE ALL periodo WITH 1 
	REPLACE ALL posterior WITH .F.
	USE
	USE PLMT0400 IN 0 ALIAS PLMT0400
	SELE PLMT0400
	REPLACE ALL periodo WITH 1 
	REPLACE ALL posterior WITH .F.
	USE
	USE PLMT0500 IN 0 ALIAS PLMT0500
	SELE PLMT0500
	REPLACE ALL periodo WITH 1 
	REPLACE ALL posterior WITH .F.
	USE
	USE PLMT0600 IN 0 ALIAS PLMT0600
	SELE PLMT0600
	REPLACE ALL periodo WITH 1 
	REPLACE ALL posterior WITH .F.
	USE
	USE PLMV0200 IN 0 ALIAS PLMV0200
	SELE PLMV0200
	REPLACE ALL periodo WITH 1 
	USE
ENDPROC


PROCEDURE CONFIGURACION_PLANILLA
	SET DEFA TO (dirraiz+"PLANILLA")
ENDPROC

*****************************************************************************
*                 				RECURSIVO TABLAS		                    *
*                                                                           *
*****************************************************************************

PROCEDURE APLICAMULTIMONEDATABLAS(tabla)
	tabla = ALLTRIM(tabla)
	aliastabla = SUBSTR(tabla,1,AT('.',tabla)-1)
	IF AT ("CONFIG",JUSTPATH(FULLPATH(tabla)))= 0  THEN
		USE (tabla) IN 0 ALIAS (aliastabla)
		SELE (aliastabla)	
		basedatos = CURSORGETPROP("Database")

			IF NOT EMPTY(basedatos) THEN
				WAIT WINDOW tabla+","+basedatos TIMEOUT 0.5
				SET DATABASE TO &basedatos
				numcampos = AFIELDS(matcampos)
				FOR i = 1 TO numcampos
					comentario = DBGETPROP(aliastabla+"."+matcampos(i,1),"Field","Comment")
					IF ATC("*MONEDA",comentario) <> 0 THEN
						MESSAGEBOX(aliastabla+CHR(13)+comentario)
						decimales = DECIMALESCAMPO(tabla,campo)
						ALTERADECIMALESCAMPO(tabla,campo,decimales+4)
					ENDIF
				ENDFOR
			ENDIF
		USE
	ENDIF
ENDPROC

PROCEDURE MULTIMONEDATABLAS
	CLOSE DATA ALL
	OPEN DATABASE (dirraiz+"CONTABLE\CONTABLE.DBC")
	OPEN DATABASE (dirraiz+"BANCOS\BANCOS01.DBC")
	OPEN DATABASE (dirraiz+"INVENTARIO\INVENTARIO.DBC")
	OPEN DATABASE (dirraiz+"IVA\IVMENU00.DBC")
	OPEN DATABASE (dirraiz+"PLANILLA\PLANILLA.DBC")
	SET EXCLUSIVE ON
	SET SAFETY OFF
	DO APLICATODASTABLAS IN CILIB001 WITH dirraiz,"R","DO APLICAMULTIMONEDATABLAS WITH"+CHR(34)+"tabla"+CHR(34)
	SET EXCLUSIVE OFF
	SET SAFETY ON
	CLOSE DATA ALL
ENDPROC



PROCEDURE DEFINECAMPOSMONEDAEXISTENTES
	IF DIRECTORY(dirraiz+"PLANILLA") THEN
		SET DEFA TO (dirraiz+"PLANILLA")
		IF NOT EXISTECAMPOESTRUCTURA('plut0610','feccambio') THEN
			AGREGACAMPOTABLA('plut0610','feccambio','D',0,0)
			USE (dirraiz+"PLANILLA\PLUT0610.DBF") IN 0 ALIAS PLUT0610
			SELE PLUT0610
			REPLACE ALL feccambio WITH hasta
			USE
		ENDIF
	ENDIF
	SET DEFA TO (dirraiz)
	mnt = "bamv0100.valdoc, bamv0100.totcargos, bamv0100.totabonos, bamv0110.cargos, bamv0110.abonos, "
	mnt = mnt+"bamv0200.valdoc, bamv0200.totcargos, bamv0200.totabonos, bamv0210.cargos, bamv0210.abonos, "
	mnt = mnt+"bamv0300.valdoc, bamv0300.totcargos, bamv0300.totabonos, bamv0310.cargos, bamv0310.abonos, "
	mnt = mnt+"bamv0400.valdoc, bamv0400.totcargos, bamv0400.totabonos, bamv0410.cargos, bamv0410.abonos, "
	mnt = mnt+"D*bamt0200.salini, D*bamt0200.salact, D*bamt0200.cargos, D*bamt0200.abonos, "
	MARCACAMPOSMONEDA(mnt, .T.)
	mnt = "B*plmt0500.sueldo, B*plmt0600.valdes, "
	mnt = mnt +"plmv0200.sueldo, plmv0200.salhora, plmv0200.valinca, plmv0200.vextnor, "
	mnt = mnt + "plmv0200.vextnoc, plmv0200.vjornada, plmv0200.varios, plmv0200.otroing, "
	mnt = mnt + "plmv0200.vacaciones, plmv0200.totdev, plmv0200.retanti, plmv0200.retinst, "
	mnt = mnt + "plmv0200.retotros, plmv0200.retisss, plmv0200.pension, plmv0200.retafp1, plmv0200.retafp2, plmv0200.retafpt, plmv0200.retrenta, plmv0200.ppafpsa, plmv0200.ppisspe, plmv0200.totdes, plmv0200.salliq, plmv0200.viaticos, plmv0200.transporte"
	MARCACAMPOSMONEDA(mnt, .T.)
	IF DIRECTORY(dirraiz+"PLANILLA") THEN
		DO LLENA_FECPAG_EN_PLMV0200
	ENDIF
	mnt = "ivmv0100.valmov, ivmv0100.valiva, ivmv0100.valtot, ivmv0100.vtaexe, ivmv0110.unitario, ivmv0110.total, "
	mnt = mnt +"B*ivmt0200.cuotafac"
	MARCACAMPOSMONEDA(mnt, .T.)   
	mnt = "comt0200.totalcargos, comt0200.totalabonos, comt0210.mo_cargos, comt0210.mo_abonos,"
	mnt = mnt +"D*comt0100.ca_salini, D*comt0100.ca_salact, D*comt0100.ca_cargos, D*comt0100.ca_abonos" 
	MARCACAMPOSMONEDA(mnt, .T.)   
ENDPROC

PROCEDURE MARCACAMPOSMONEDA(cm, sumadecimales)
	LOCAL camino, tabla, dosletras, pospunto, campo, tabla
	IF PCOUNT() = 1 THEN
		sumadecimales = .F.
	ENDIF
	cm = cm+","
	poscampo = AT(",",cm)
	DO WHILE NOT EMPTY(cm) AND poscampo <> 0 
		IF poscampo <> 0 THEN
			campotabla = SUBSTR(cm,1,poscampo-1)
			cm = SUBSTR(cm,poscampo+1)
			IF NOT EMPTY(campotabla) THEN 
				pospunto = AT(".",campotabla)
				IF pospunto <> 0 THEN
					tabla = UPPER(ALLTRIM(SUBSTR(campotabla,1,pospunto-1)))
					IF AT("*",tabla) = 0 THEN
						tipotabla = 'C'
					ELSE
						tipotabla = SUBSTR(tabla,1,1)
						tabla = SUBSTR(tabla,3)
					ENDIF
					IF AT("\",tabla) = 0 THEN
						dosletras = SUBSTR(tabla,1,2)
						DO CASE
							CASE dosletras = "CO"
								camino = dirraiz+"CONTABLE\"
							CASE dosletras = "BA"
								camino = dirraiz+"BANCOS\"
							CASE dosletras = "IN"
								camino = dirraiz+"INVENTARIO\"
							CASE dosletras = "IV"
								camino = dirraiz+"IVA\"
							CASE dosletras = "PL"
								camino = dirraiz+"PLANILLA\"
							CASE dosletras = "CF"
								camino = dirraiz+"CONFIG\"
							OTHERWISE
								camino = dirraiz
						ENDCASE
						pathtabla = camino+tabla+".DBF"
					ELSE
						pathtabla = tabla
					ENDIF
				
					camino = JUSTPATH(pathtabla)
					tabla = JUSTFNAME(pathtabla)
					nomtabla = JUSTSTEM(pathtabla)
					campo = UPPER(ALLTRIM(SUBSTR(campotabla,pospunto+1)))
					
					IF FILE(pathtabla) THEN
						SET DEFA TO &camino
						IF NOT EXISTECAMPOESTRUCTURA(nomtabla,campo) THEN
							MESSAGEBOX("No existe el campo "+campo+" en la tabla "+nomtabla)
						ELSE
							USE (pathtabla) IN 0 ALIAS (nomtabla)
							SELE (nomtabla)	
							basedatos = CURSORGETPROP("Database")
							USE
							IF NOT EMPTY(basedatos) THEN
								SET DATABASE TO &basedatos
								comentabla = DBGETPROP(nomtabla,"Table","Comment")
								IF AT("*TM",comentabla) = 0 THEN
									DBSETPROP(nomtabla,"Table","Comment",ALLTRIM(comentabla)+" *TM"+tipotabla)	
								ENDIF
								comentario = DBGETPROP(nomtabla+"."+campo,"Field","Comment")
								IF ATC("*MON",comentario) = 0 THEN
									IF sumadecimales THEN
										FIJADECIMALESCAMPOTABLA(nomtabla,campo,8)
										ALTERAANCHOCAMPOTABLA(nomtabla,campo,20)
									ENDIF
									IF NOT EXISTECAMPOESTRUCTURA(nomtabla,'tipocambio') AND tipotabla = "C" THEN
										AGREGACAMPOTABLA(nomtabla, 'tipocambio','N',16,8)
										USE (pathtabla) IN 0 ALIAS (nomtabla)
										SELE (nomtabla)	
										REPLACE ALL tipocambio WITH 1.00
										USE
									ENDIF 
								
									IF NOT EXISTECAMPOESTRUCTURA(nomtabla,'cmoneda') AND (tipotabla = "B" OR tipotabla = "C") THEN
										AGREGACAMPOTABLA(nomtabla, 'cmoneda','N',2,0)
										USE (pathtabla) IN 0 ALIAS (nomtabla)
										SELE (nomtabla)	
										REPLACE ALL cmoneda WITH 1
										USE
									ENDIF
							
									DO CASE
										CASE tipotabla = "B"
											marca = "*MONVIS"
										CASE tipotabla = "C"
											marca = "*MONCON"
										CASE tipotabla = "D"
											marca = "*MONBAS"
									ENDCASE
									DBSETPROP(nomtabla+"."+campo,"Field","Comment",ALLTRIM(comentario)+" "+marca)	
								ENDIF
							ENDIF
						ENDIF
					ENDIF
				ENDIF
			ENDIF
		ENDIF
		poscampo = AT(",",cm)
	ENDDO
ENDPROC


PROCEDURE LLENA_FECPAG_EN_PLMV0200
	
	IF FILE(dirraiz+"PLANILLA\PLMV0200.DBF") THEN
		USE (dirraiz+"PLANILLA\PLUT0610.DBF") IN 0 ALIAS PLUT0610
		USE (dirraiz+"PLANILLA\PLMV0200.DBF") IN 0 ALIAS PLMV0200
		SELE PLUT0610
		SCAN
			elperiodo = plut0610.periodo
			fechapago = plut0610.feccambio
			laempresa = plut0610.empresa
			SELE PLMV0200
			REPLACE fecpag WITH fechapago FOR periodo = elperiodo AND empresa = laempresa
			SELE PLUT0610
		ENDSCAN 
		CLOSE DATA ALL
	ENDIF
ENDPROC

