#DEFINE MAXBODEGAS 200

DEFINE CLASS CasillaExento AS CheckBox
	Caption = ''
	BackStyle = 0
	Width = 32
	Controlsource = inmv0115.exento
	
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
	PROCEDURE InteractiveChange
		IF THIS.Value = 1 AND M.TIPCOMP =2 AND M.APLICA = 2 THEN 
			MESSAGEBOX("Las exportaciones son gravadas con una tasa 0 de IVA (Art. 74 y 75 de la Ley)", 48, "MILLENNIUM CONSULTING")
			THIS.Value = 0 
		ELSE 
			IF THIS.Value = 1 AND M.TIPDOC =3 THEN 
				MESSAGEBOX("Las notas de crdito no incluyen ventas exentas.", 48, "MILLENNIUM CONSULTING")
				THIS.Value = 0 
			ELSE
			    IF THIS.Value = 1 AND M.TIPDOC =4 THEN 
					MESSAGEBOX("Las notas de dbito no incluyen ventas exentas.", 48, "MILLENNIUM CONSULTING")
					THIS.Value = 0 
				ELSE			
				    REPLACE exento WITH THIS.VALUE IN inmv0115
				    THISFORM.TOTALESFORM() 
				ENDIF
			ENDIF
		ENDIF
	ENDPROC
	PROCEDURE Valid
		This.Visible = .T.
	ENDPROC
ENDDEFINE

*****************************************************************************
*                    FUNCIONES DE PROPAGACION DE INVENTARIOS                *
*                                                                           *
*****************************************************************************
FUNCTION EXISTENUNIDADESINDIVIDUALES
	LOCAL taul, resul
	taul = ALIAS()
	resul = LEEVARBOOLDEFECTO('XYUNIDADESINDIVIDUALES',.F.)
	IF NOT EMPTY(taul) THEN
		SELE (taul)
	ENDIF
	RETURN resul
ENDFUNC

PROCEDURE PROPAGA_INVENTARIOS
	basura = 0
	DO PROPAGA_BODEGAS
	DO PROPAGA_CLASES
	DO PROPAGA_MARCAS
	DO PROPAGA_PRODUCTOS
	IF EXISTENUNIDADESINDIVIDUALES() THEN
		DO PROPAGA_UNIDADES_INDIVIDUALES
	ENDIF
	DO PROPAGA_PVA
ENDPROC

PROCEDURE CREA_INVENTARIOS_NUEVO_MES
	W_DESDEANT = W_DESDE
	W_HASTAANT = W_HASTA
	W_MESMAXANT = W_MESMAX
	W_ANYOMAXANT = W_ANYOMAX
	DO CREA_BODEGAS_NUEVO_MES
	W_DESDE = W_DESDEANT
	W_HASTA = W_HASTAANT
	W_MESMAX = W_MESMAXANT
	W_ANYOMAX = W_ANYOMAXANT
	DO CREA_CLASES_NUEVO_MES
	W_DESDE = W_DESDEANT
	W_HASTA = W_HASTAANT
	W_MESMAX = W_MESMAXANT
	W_ANYOMAX = W_ANYOMAXANT
	DO CREA_MARCAS_NUEVO_MES
	W_DESDE = W_DESDEANT
	W_HASTA = W_HASTAANT
	W_MESMAX = W_MESMAXANT
	W_ANYOMAX = W_ANYOMAXANT
	DO CREA_PRODUCTOS_NUEVO_MES
	W_DESDE = W_DESDEANT
	W_HASTA = W_HASTAANT
	W_MESMAX = W_MESMAXANT
	W_ANYOMAX = W_ANYOMAXANT
	IF EXISTENUNIDADESINDIVIDUALES() THEN
		DO CREA_UNIDADES_INDIVIDUALES_NUEVO_MES
		W_DESDE = W_DESDEANT
		W_HASTA = W_HASTAANT
		W_MESMAX = W_MESMAXANT
		W_ANYOMAX = W_ANYOMAXANT
	ENDIF
	DO CREA_PVA_NUEVO_MES
ENDPROC

PROCEDURE PROPAGA_BODEGAS
	LOCAL filtro, mesactual, anyoactual, contames, contaanyo, nregist
	
	mesactual = MONTH(W_DESDE)
	anyoactual = YEAR(W_DESDE)
	USE INMT0100 IN 0 ALIAS INMT0100 EXCLUSIVE
	
	SELECT INMT0100
	filtro = FILTER()
	SET FILTER TO
	GO TOP
	LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual
	DO WHILE NOT EOF()
		nregist = RECNO()
		codibodega = INMT0100.codigo
		contames = MES_MESDESPUES(mesactual,anyoactual)
		contaanyo = ANYO_MESDESPUES(mesactual,anyoactual)
				
		IF NOT INMT0100.POSTERIOR THEN
		
			REPLACE POSTERIOR WITH .T.
			encontradaconmismocodigo = .F.
			
			DO WHILE (NOT POSTERIORMES (contames, contaanyo, W_MESMAX, W_ANYOMAX)) AND (NOT encontradaconmismocodigo)
				
				nreg1 = GUARDANUMEROREGISTRO()
				LOCATE FOR codigo = codibodega  AND nmes = contames AND anyo = contaanyo AND empresa = nCodigo
				encontradaconmismocodigo = FOUND()
				
				RECUPERANUMEROREGISTRO(nreg1)						
						
					
				IF NOT encontradaconmismocodigo THEN

					SCATTER MEMVAR
					
					M.posterior = ((contames <> W_MESMAX) OR (contaanyo <> W_ANYOMAX))
					M.borrada = .F.
					M.nmes = contames
					M.anyo = contaanyo
					
					INSERT INTO INMT0100 FROM MEMVAR
				
					contamesant = contames
					contaanyoant = contaanyo
					contames = MES_MESDESPUES(contamesant,contaanyoant)			
					contaanyo = ANYO_MESDESPUES (contamesant,contaanyoant)
				ENDIF	
			ENDDO
		ENDIF
		
			
		GO nregist
		SKIP
		IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual REST
		ENDIF
	ENDDO 
	SET FILTER TO &filtro
	USE
	
ENDPROC

PROCEDURE PROPAGA_CLASES
	LOCAL filtro, mesactual, anyoactual, contames, contaanyo, nregist
	
	mesactual = MONTH(W_DESDE)
	anyoactual = YEAR(W_DESDE)
	
	USE INMT0210 IN 0 ALIAS INMT0210 EXCLUSIVE
	USE INMT0200 IN 0 ALIAS INMT0200 EXCLUSIVE
	
	SELECT INMT0200
	filtro = FILTER()
	SET FILTER TO
	GO TOP
	LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual
	
	DO WHILE NOT EOF()
	
		nregist = RECNO()
		codiclase = INMT0200.codigo
		contames = MES_MESDESPUES(mesactual,anyoactual)
		contaanyo = ANYO_MESDESPUES(mesactual,anyoactual)
				
		IF NOT INMT0200.POSTERIOR THEN
				
			REPLACE POSTERIOR WITH .T.
			encontradaconmismocodigo = .F.
							
			DO WHILE NOT POSTERIORMES (contames, contaanyo, W_MESMAX, W_ANYOMAX) AND NOT encontradaconmismocodigo
				nreg1 = GUARDANUMEROREGISTRO()
				LOCATE FOR codigo = codiclase AND nmes = contames AND anyo = contaanyo AND empresa = nCodigo
				encontradaconmismocodigo = FOUND()
				RECUPERANUMEROREGISTRO(nreg1)						
					
				IF NOT encontradaconmismocodigo THEN
				
					SCATTER MEMVAR
					
					M.posterior = ((contames <> W_MESMAX) OR (contaanyo <> W_ANYOMAX))
					M.borrada = .F.
					M.nmes = contames
					M.anyo = contaanyo
	
					INSERT INTO INMT0200 FROM MEMVAR
				
					*Propaga las unidades
				
					SELE INMT0210
					LOCATE FOR codigo = codiclase AND empresa = nCodigo AND nmes = mesactual AND anyo = anyoactual			
					DO WHILE NOT EOF()
						regnum = RECNO()
						SCATTER MEMVAR
						m.nmes = contames
						m.anyo = contaanyo
											
						INSERT INTO INMT0210 FROM MEMVAR
						
						GO regnum
						SKIP
						IF NOT EOF() THEN
							LOCATE FOR codigo = codiclase AND empresa = nCodigo AND nmes = mesactual AND anyo = anyoactual	REST								
						ENDIF
					ENDDO
								
						
					SELE INMT0200
				
					contamesant = contames
					contaanyoant = contaanyo
					contames = MES_MESDESPUES(contamesant,contaanyoant)			
					contaanyo = ANYO_MESDESPUES (contamesant,contaanyoant)
				ENDIF
			ENDDO
		ENDIF
		
					
		GO nregist
		SKIP
		IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual REST
		ENDIF
	ENDDO 
	SET FILTER TO &filtro
	SELE INMT0210
	USE
	SELE INMT0200
	USE
	
ENDPROC


PROCEDURE PROPAGA_MARCAS
	LOCAL filtro, mesactual, anyoactual, contames, contaanyo, nregist
	
	mesactual = MONTH(W_DESDE)
	anyoactual = YEAR(W_DESDE)
	USE INMT0300 IN 0 ALIAS INMT0300 EXCLUSIVE
	
	SELECT INMT0300
	filtro = FILTER()
	SET FILTER TO
	GO TOP
	LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual
	DO WHILE NOT EOF()
		nregist = RECNO()
		codimarca = INMT0300.codigo
		contames = MES_MESDESPUES(mesactual,anyoactual)
		contaanyo = ANYO_MESDESPUES(mesactual,anyoactual)
			
		IF NOT INMT0300.POSTERIOR THEN	
							
			REPLACE POSTERIOR WITH .T.
			encontradaconmismocodigo = .F.
				
			DO WHILE NOT POSTERIORMES (contames, contaanyo, W_MESMAX, W_ANYOMAX) AND NOT encontradaconmismocodigo
				nreg1 = GUARDANUMEROREGISTRO()
				LOCATE FOR codigo = codimarca AND nmes = contames AND anyo = contaanyo AND empresa = nCodigo
				encontradaconmismocodigo = FOUND()
				RECUPERANUMEROREGISTRO(nreg1)						
					
				IF NOT encontradaconmismocodigo THEN
								
					SCATTER MEMVAR
					
					M.posterior = ((contames <> W_MESMAX) OR (contaanyo <> W_ANYOMAX))
					M.borrada = .F.
					M.nmes = contames
					M.anyo = contaanyo
					
					INSERT INTO INMT0300 FROM MEMVAR
				
					contamesant = contames
					contaanyoant = contaanyo
					contames = MES_MESDESPUES(contamesant,contaanyoant)			
					contaanyo = ANYO_MESDESPUES (contamesant,contaanyoant)
				ENDIF
			ENDDO
		ENDIF
		
			
		GO nregist
		SKIP
		IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual REST
		ENDIF
	ENDDO 
	SET FILTER TO &filtro
	USE
ENDPROC

PROCEDURE PROPAGA_PRODUCTOS
	LOCAL filtro, mesactual, anyoactual, contames, contaanyo, nregist
	
	mesactual = MONTH(W_DESDE)
	anyoactual = YEAR(W_DESDE)
	USE INMV0100 IN 0 ALIAS INMV0100 EXCLUSIVE
	USE INMT0400 IN 0 ALIAS INMT0400 EXCLUSIVE
	USE INMT0410 IN 0 ALIAS INMT0410 EXCLUSIVE
	
	SELECT INMV0100
	SET FILTER TO
	SELECT INMT0410
	SET FILTER TO
	SELECT INMT0400
	SET FILTER TO
	
	GO TOP
	LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual
	DO WHILE NOT EOF()
		nregist = RECNO()
		codiproducto = INMT0400.codigo
			
		IF NOT INMT0400.POSTERIOR THEN
			contames = MES_MESDESPUES(mesactual,anyoactual)
			contaanyo = ANYO_MESDESPUES(mesactual,anyoactual)
							
			REPLACE POSTERIOR WITH .T.
			encontradaconmismocodigo = .F.
				
			DO WHILE NOT POSTERIORMES (contames, contaanyo, W_MESMAX, W_ANYOMAX) AND NOT encontradaconmismocodigo
				nreg1 = GUARDANUMEROREGISTRO()
				LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(codiproducto)) AND nmes = contames AND anyo = contaanyo AND empresa = nCodigo
				encontradaconmismocodigo = FOUND()
				RECUPERANUMEROREGISTRO(nreg1)						
					
				IF NOT encontradaconmismocodigo THEN
					SCATTER MEMVAR
					
					M.posterior = ((contames <> W_MESMAX) OR (contaanyo <> W_ANYOMAX))
					M.borrada = .F.
					M.nmes = contames
					M.anyo = contaanyo
					
					INSERT INTO INMT0400 FROM MEMVAR
				
					* Propaga los inventarios (para productos nuevos)	
					SELE INMV0100
					LOCATE FOR ALLTRIM(UPPER(producto)) == ALLTRIM(UPPER(codiproducto)) AND empresa = nCodigo AND nmes = mesactual AND anyo = anyoactual			
					DO WHILE NOT EOF()
						regnum = RECNO()
						SCATTER MEMVAR
						m.nmes = contames
						m.anyo = contaanyo
						m.stoini = m.stoact
						m.cosini = m.cosact
						
						INSERT INTO INMV0100 FROM MEMVAR
						
						GO regnum
						SKIP
						IF NOT EOF() THEN
							LOCATE FOR ALLTRIM(UPPER(producto)) == ALLTRIM(UPPER(codiproducto)) AND empresa = nCodigo AND nmes = mesactual AND anyo = anyoactual	REST								
						ENDIF
					ENDDO
				
					*Propaga las unidades
				
					SELE INMT0410
					LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(codiproducto)) AND empresa = nCodigo AND nmes = mesactual AND anyo = anyoactual			
					DO WHILE NOT EOF()
						regnum = RECNO()
						SCATTER MEMVAR
						m.nmes = contames
						m.anyo = contaanyo
											
						INSERT INTO INMT0410 FROM MEMVAR
						
						GO regnum
						SKIP
						IF NOT EOF() THEN
							LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(codiproducto)) AND empresa = nCodigo AND nmes = mesactual AND anyo = anyoactual	REST								
						ENDIF
					ENDDO
								
						
					SELE INMT0400
					contamesant = contames
					contaanyoant = contaanyo
					contames = MES_MESDESPUES(contamesant,contaanyoant)			
					contaanyo = ANYO_MESDESPUES (contamesant,contaanyoant)
				ENDIF	
			ENDDO
		ENDIF
		
			
		GO nregist
		SKIP
		IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual REST
		ENDIF
	ENDDO 
	
	** Propaga los inventarios para productos no nuevos
	
	SELE INMV0100
	GO TOP
	LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual
	DO WHILE NOT EOF()

		nregist = RECNO()
		codiproducto = INMV0100.producto
		costoactual = INMV0100.cosact
		stockactual = INMV0100.stoact
		estabodega =  INMV0100.bodega
		LOCATE FOR ALLTRIM(UPPER(producto)) == ALLTRIM(UPPER(codiproducto)) AND bodega = estabodega AND empresa = nCodigo AND nmes = MES_MESDESPUES(mesactual,anyoactual) AND anyo = ANYO_MESDESPUES (mesactual,anyoactual) 
		IF FOUND() THEN
			diferenciacosto = costoactual - INMV0100.cosini
			diferenciastock = stockactual - INMV0100.stoini
		ELSE
			diferenciacosto = costoactual
			diferenciastock = stockactual
		ENDIF

		IF diferenciacosto<>0 OR diferenciastock <> 0 THEN
		
			cmes = MES_MESDESPUES(mesactual,anyoactual) 
			canyo = ANYO_MESDESPUES (mesactual,anyoactual) 
			encontrado = .T.
			DO WHILE POSTERIOROIGUALMES(W_MESMAX,W_ANYOMAX,cmes,canyo) AND encontrado
				SELE INMT0400
				LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(codiproducto)) AND empresa = nCodigo AND nmes = cmes AND anyo = canyo	
				encontrado = FOUND()
				SELE INMV0100
				IF encontrado THEN
					LOCATE FOR ALLTRIM(UPPER(producto)) == ALLTRIM(UPPER(codiproducto)) AND bodega = estabodega AND empresa = nCodigo AND nmes = cmes AND anyo = canyo
					IF FOUND() THEN
						REPLACE cosini WITH cosini+diferenciacosto, cosact WITH cosact+diferenciacosto, stoini WITH stoini+diferenciastock, stoact WITH stoact+diferenciastock
					ELSE
						INSERT INTO INMV0100 (producto, bodega, stoini, stoact, cosini, cosact, empresa, nmes, anyo) ;
							VALUES (codiproducto, estabodega, diferenciastock, diferenciastock, diferenciacosto, diferenciacosto, nCodigo, cmes, canyo)
					ENDIF
				ENDIF	
				cmesant = cmes
				canyoant = canyo
				cmes = MES_MESDESPUES(cmesant,canyoant) 
				canyo = ANYO_MESDESPUES (cmesant,canyoant) 
			ENDDO
		ENDIF
			
		GO nregist
		SKIP
		IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual REST
		ENDIF
	ENDDO 
		
	SELE INMV0100
	USE
	SELE INMT0400
	USE
	SELE INMT0410
	USE
	
ENDPROC

PROCEDURE PROPAGA_UNIDADES_INDIVIDUALES
	LOCAL filtro, mesactual, anyoactual, contames, contaanyo, nregist, bodegafinmesanterior
	
	mesactual = MONTH(W_DESDE)
	anyoactual = YEAR(W_DESDE)
	
	USE INMV0120 IN 0 ALIAS INMV0120 EXCLUSIVE
	USE INMT0600 IN 0 ALIAS INMT0600 EXCLUSIVE
	USE INMT0610 IN 0 ALIAS INMT0610 EXCLUSIVE
	
	SELECT INMT0600
	filtro = FILTER()
	SET FILTER TO
	GO TOP
	LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual
	DO WHILE NOT EOF()
		nregist = RECNO()
		codiunidad = INMT0600.codigo
		
		REPLACE bodegafin WITH BODEGAUNIDADFINDEMES(codiunidad,mesactual,anyoactual)	
		
		IF INMT0600.POSTERIOR THEN
			
			bodegafinmesanterior = inmt0600.bodegafin
									
			contames = MES_MESDESPUES(mesactual,anyoactual)
			contaanyo = ANYO_MESDESPUES(mesactual,anyoactual)
		
			continua = .T.
			
			DO WHILE NOT POSTERIORMES (contames, contaanyo, W_MESMAX, W_ANYOMAX) AND continua
						
				LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(codiunidad)) AND empresa = nCodigo AND nmes = contames AND anyo = contaanyo
				
				IF FOUND() THEN
					
					bf0600 = inmt0600.bodegafin
					REPLACE bodegaini WITH bodegafinmesanterior
					bf1120 = BODEGAUNIDADFINDEMES(codiunidad,contames,contaanyo)
					continua = (bf1120 <> bf0600) 
					REPLACE bodegafin WITH bf1120 IN INMT0600
					bodegafinmesanterior = inmt0600.bodegafin
				ELSE
					continua = .F.
				ENDIF
			
					
				contamesant = contames
				contaanyoant = contaanyo
				contames = MES_MESDESPUES(contamesant,contaanyoant)			
				contaanyo = ANYO_MESDESPUES (contamesant,contaanyoant)
			ENDDO
		ELSE
				
			contames = MES_MESDESPUES(mesactual,anyoactual)
			contaanyo = ANYO_MESDESPUES(mesactual,anyoactual)
							
			REPLACE POSTERIOR WITH .T.
			encontradaconmismocodigo = .F.
				
			DO WHILE NOT POSTERIORMES (contames, contaanyo, W_MESMAX, W_ANYOMAX) AND NOT encontradaconmismocodigo 
				nreg1 = GUARDANUMEROREGISTRO()
				LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(codiunidad)) AND nmes = contames AND anyo = contaanyo AND empresa = nCodigo
				encontradaconmismocodigo = FOUND()
				RECUPERANUMEROREGISTRO(nreg1)						
					
				IF NOT encontradaconmismocodigo THEN
							
					SCATTER MEMVAR
					
					M.posterior = ((contames <> W_MESMAX) OR (contaanyo <> W_ANYOMAX))
				
					M.nmes = contames
					M.anyo = contaanyo
					m.bodegaini = m.bodegafin
				
					INSERT INTO INMT0600 FROM MEMVAR
				
				
					*Propaga las propiedades
				
					SELE INMT0610
					LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(codiunidad)) AND empresa = nCodigo AND nmes = mesactual AND anyo = anyoactual			
					DO WHILE NOT EOF()
						regnum = RECNO()
						SCATTER MEMVAR
						m.nmes = contames
						m.anyo = contaanyo
											
						INSERT INTO INMT0610 FROM MEMVAR
						
						GO regnum
						SKIP
						IF NOT EOF() THEN
							LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(codiunidad)) AND empresa = nCodigo AND nmes = mesactual AND anyo = anyoactual	REST								
						ENDIF
					ENDDO
								
						
					SELE INMT0600
					contamesant = contames
					contaanyoant = contaanyo
					contames = MES_MESDESPUES(contamesant,contaanyoant)			
					contaanyo = ANYO_MESDESPUES (contamesant,contaanyoant)
				ENDIF
			ENDDO
		ENDIF
		
			
		GO nregist
		SKIP
		IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual REST
		ENDIF
	ENDDO 
	SET FILTER TO &filtro
	SELE INMT0600
	USE
	SELE INMT0610
	USE
	SELE INMV0120	
	USE
ENDPROC




PROCEDURE PROPAGA_PVA
	LOCAL filtro, mesactual, anyoactual, contames, contaanyo, nregist
	
	mesactual = MONTH(W_DESDE)
	anyoactual = YEAR(W_DESDE)
	USE INMT0500 IN 0 ALIAS INMT0500 EXCLUSIVE
	
	SELECT INMT0500
	filtro = FILTER()
	SET FILTER TO
	GO TOP
	LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual
	DO WHILE NOT EOF()
		nregist = RECNO()
		codigopva = inmt0500.codpva
			
		IF NOT INMT0500.POSTERIOR THEN
		
			contames = MES_MESDESPUES(mesactual,anyoactual)
			contaanyo = ANYO_MESDESPUES(mesactual,anyoactual)
							
			REPLACE POSTERIOR WITH .T.
			
			encontradaconmismocodigo = .F.
			
			DO WHILE NOT POSTERIORMES (contames, contaanyo, W_MESMAX, W_ANYOMAX) AND NOT encontradaconmismocodigo
				
				nreg1 = GUARDANUMEROREGISTRO()
				LOCATE FOR codpva = codigopva AND nmes = contames AND anyo = contaanyo AND empresa = nCodigo
				encontradaconmismocodigo = FOUND()
				RECUPERANUMEROREGISTRO(nreg1)						
					
				IF NOT encontradaconmismocodigo THEN
								
					SCATTER MEMVAR
					
					M.posterior = ((contames <> W_MESMAX) OR (contaanyo <> W_ANYOMAX))
					M.borrada = .F.
					M.nmes = contames
					M.anyo = contaanyo
					
					INSERT INTO INMT0500 FROM MEMVAR
				
					contamesant = contames
					contaanyoant = contaanyo
					contames = MES_MESDESPUES(contamesant,contaanyoant)			
					contaanyo = ANYO_MESDESPUES (contamesant,contaanyoant)
				ENDIF
			ENDDO
		ENDIF
		
			
		GO nregist
		SKIP
		IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND anyo = anyoactual AND nmes=mesactual REST
		ENDIF
	ENDDO 
	SET FILTER TO &filtro
	USE
ENDPROC

PROCEDURE CREA_BODEGAS_NUEVO_MES
	* Nos colocamos en el ltimo mes existente
	
	W_DESDE=DATE(W_ANYOMAX,W_MESMAX,01)
	W_HASTA=DATE(W_ANYOMAX,W_MESMAX,DIAS_MES(W_MESMAX,W_ANYOMAX))
	
	* Hacemos que el mes mximo sea el posterior al ltimo existente
	W_MESMAX = W_MES
	W_ANYOMAX = W_AO
	
	* Propagamos 
	DO PROPAGA_BODEGAS
	
ENDPROC

PROCEDURE CREA_CLASES_NUEVO_MES

	* Nos colocamos en el ltimo mes existente
	W_DESDE=DATE(W_ANYOMAX,W_MESMAX,01)
	W_HASTA=DATE(W_ANYOMAX,W_MESMAX,DIAS_MES(W_MESMAX,W_ANYOMAX))
	
	* Hacemos que el mes mximo sea el posterior al ltimo existente
	
	W_MESMAX = W_MES
	W_ANYOMAX = W_AO
	
	
	* Propagamos 
	DO PROPAGA_CLASES
	
	
ENDPROC

PROCEDURE CREA_MARCAS_NUEVO_MES
	* Nos colocamos en el ltimo mes existente
	
	W_DESDE=DATE(W_ANYOMAX,W_MESMAX,01)
	W_HASTA=DATE(W_ANYOMAX,W_MESMAX,DIAS_MES(W_MESMAX,W_ANYOMAX))
	
	* Hacemos que el mes mximo sea el posterior al ltimo existente
	W_MESMAX = W_MES
	W_ANYOMAX = W_AO
	
	* Propagamos 
	DO PROPAGA_MARCAS
	
ENDPROC

PROCEDURE CREA_PRODUCTOS_NUEVO_MES
	* Nos colocamos en el ltimo mes existente
	W_DESDE=DATE(W_ANYOMAX,W_MESMAX,01)
	W_HASTA=DATE(W_ANYOMAX,W_MESMAX,DIAS_MES(W_MESMAX,W_ANYOMAX))
	
	* Hacemos que el mes mximo sea el posterior al ltimo existente
	W_MESMAX = W_MES
	W_ANYOMAX = W_AO
	
	* Propagamos
	DO PROPAGA_PRODUCTOS
	
ENDPROC

PROCEDURE CREA_UNIDADES_INDIVIDUALES_NUEVO_MES
	* Nos colocamos en el ltimo mes existente
	W_DESDE=DATE(W_ANYOMAX,W_MESMAX,01)
	W_HASTA=DATE(W_ANYOMAX,W_MESMAX,DIAS_MES(W_MESMAX,W_ANYOMAX))
	
	* Hacemos que el mes mximo sea el posterior al ltimo existente
	W_MESMAX = W_MES
	W_ANYOMAX = W_AO
	
	* Propagamos
	DO PROPAGA_UNIDADES_INDIVIDUALES
	
ENDPROC





PROCEDURE CREA_PVA_NUEVO_MES
	* Nos colocamos en el ltimo mes existente
	
	W_DESDE=DATE(W_ANYOMAX,W_MESMAX,01)
	W_HASTA=DATE(W_ANYOMAX,W_MESMAX,DIAS_MES(W_MESMAX,W_ANYOMAX))
	
	* Hacemos que el mes mximo sea el posterior al ltimo existente
	W_MESMAX = W_MES
	W_ANYOMAX = W_AO
	
	* Propagamos 
	DO PROPAGA_PVA
	
ENDPROC


*****************************************************************************
*                        RECALCULAR COSTOS Y STOCKS                         *
*                     (y otras operaciones relacionadas)                    *
*****************************************************************************

*********
&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
PROCEDURE TABLAEXISTENCIASENFECHAPORPRODUCTO(pfecha, nomtabla)
	&&Crea una tabla temporal donde cada registro corresponde a un producto 
	&&y contiene las existencias de ese producto en cada una de las bodegas (tambin un total)
	
	&& Inicializaciones
	SET PROC TO CILIB001 ADDITIVE
	LOCAL numbodegas, basura, basura2, stcreabodegas, strinserta, i, productoactual, claseactual, totalexisprod
	DIMENSION BODEGAS(MAXBODEGAS) 
	basura2 = 0 
	
	&& Revisa el nmero y nombre de bodegas del mes en cuestion
	
	numbodegas = CREAARRAYBODEGAS(MONTH(pfecha), YEAR(pfecha), .T.)
		
	IF numbodegas = 0 THEN
		RETURN NULL
	ELSE
		DIMENSION STOCKS(numbodegas), COSTOS(numbodegas)
		&&Revisa la longitud de algunos campos que varian entre distintas instalaciones		
		numenteros = LEEVARNUMDEFECTO('XYINENTEROSSTOCKS',10) &&
		numdecimales = LEEVARNUMDEFECTO('XYDECIMALESINVENTARIO',0)&&
		longcodigo = LEEVARNUMDEFECTO('XYINLONGITUDCODIGOPRODUCTO',15)&&	
		
		&&Crea la tabla donde se guardarn los resultados (borra una copia anterior si exista)	
		
		IF FILE(nomtabla) THEN
			DELETE FILE &nomtabla
		ENDIF
		stcreabodegas = ""
		FOR i = 1 TO numbodegas
			stcreabodegas = stcreabodegas+" bod"+ALLTRIM(STR(i)) + " N(" +ALLTRIM(STR(numenteros)) +" , " + ALLTRIM(STR(numdecimales))+") ," 
		ENDFOR
		stcreabodegas = SUBSTR(stcreabodegas, 1, LEN(stcreabodegas) -1)
		comando = "CREATE TABLE "+dirtemp+nomtabla+ " FREE ( codprod C("+ ALLTRIM(STR(longcodigo))+"), clase N(6,0), total N("+ALLTRIM(STR(numenteros)) +" , " + ALLTRIM(STR(numdecimales))+") , "+ stcreabodegas+")"
		&comando
		
		INDEX ON STR(clase)+codprod TAG claseprod
		INDEX ON clase TAG clase			
		
		&& Abre las tablas 
				
		USE INMT0400 IN 0 ALIAS INMT0400
		
		CREATABLAINMV0110(MONTH(pfecha), YEAR(pfecha)) 
			
		&& Pone las existencias iniciales en la tabla para evitar que se nos escape algun producto con existencias pero sin movimientos
		
		*PON_INMV0100_EN_TABLA_TEMPORAL(pfecha, nomtabla, numbodegas)
					
		&& Filtra y ordena la tabla inmt0400. Establece una relacin con inmv0110
		
		SELECT INMV0110
		*SET RELATION TO PRODUCTO INTO INMT0400		
			
		SELECT INMT0400
		comando = "SET FILTER TO empresa = nCodigo AND nmes = "+STR(MONTH(pfecha))+" AND anyo = "+STR(YEAR(pfecha)) 
		&comando
		LOCATE
		*SET ORDER TO TAG CODIGO IN INMT0400
		
		DO WHILE NOT EOF() 
			&& Guarda datos del producto actual 
			registroinmt0400 = GUARDANUMEROREGISTRO()
			productoactual = inmt0400.codigo
			claseactual = inmt0400.clase
			
			&& Pone las existencias iniciales en las tabla para que no se escapen los productos con existencias pero sin movimientos
			PONEINICIALESENARRAYS(productoactual, MONTH(pfecha), YEAR(pfecha),numbodegas)
			
			SELE INMV0110
			
	
			&& Recorre todos los movimientos del producto actual actualizando los stocks y costos
			SCAN FOR ALLTRIM(UPPER(producto)) == ALLTRIM(UPPER(productoactual)) AND fecha <= pfecha AND empresa = nCodigo AND nmes = MONTH(pfecha) AND anyo = YEAR(pfecha) 
				ACTUALIZASTOCKYCOSTOUNMOVIMIENTO(inmv0110.tipcomp, inmv0110.tipoent, inmv0110.cantidad, inmv0110.total, inmv0110.bodega, inmv0110.bodegafin, @basura, 1, basura2)
			ENDSCAN 

			&&Inserta el registro en la tabla de resultados. Si exista un registro igual, lo borra.

			SELE (nomtabla)
			LOCATE FOR IGUALSTRING(codprod,productoactual)
			IF FOUND() THEN
				DELETE NEXT 1
			ENDIF	
			
			SELE INMV0110

			strinserta = ""
			totalexisprod = 0 
			FOR i = 1 TO numbodegas
				strinserta = strinserta+EXTSTR(STOCKS(i))+","
				totalexisprod = totalexisprod + STOCKS(i)
			ENDFOR
			
			strinserta = SUBSTR(strinserta, 1, LEN(strinserta) -1)
			comando = "INSERT INTO "+ nomtabla + " VALUES ("+CHR(34)+productoactual+CHR(34)+" , "+ ALLTRIM(STR(claseactual))+" , "+EXTSTR(totalexisprod)+" , "+strinserta+")"
			&comando
			
			
			SELECT INMT0400
			RECUPERANUMEROREGISTRO(registroinmt0400)
			SKIP
		ENDDO
		
		&&Cierra las tablas
		
		SELE INMT0400
		USE
		SELE INMV0110
		USE
		SELE INMV0100
		USE
		SELE (nomtabla)
		USE
	ENDIF
ENDPROC

PROCEDURE PON_INMV0100_EN_TABLA_TEMPORAL(lafecha, nomtabla, nbodegas)

	LOCAL taula, prodacti,il, totalexist 
	taula = ALIAS()
	SELE INMT0400
	SET ORDER TO TAG CODIGO
	SELE INMV0100
	SET RELATION TO PRODUCTO INTO INMT0400
	SCAN FOR empresa = nCodigo AND nmes = MONTH(lafecha) AND anyo = YEAR(lafecha)
		prodacti = inmv0100.producto
		
		SELE (nomtabla)
		LOCATE FOR IGUALSTRING(codprod,prodacti)
		IF FOUND() THEN
			comando = "REPLACE bod"+ALLTRIM(STR(inmv0100.bodega))+" WITH "+EXTSTR(inmv0100.stoini)
			&comando
			REPLACE total WITH total+inmv0100.stoini
		ELSE
			stringinserta = ""
			FOR il = 1 TO nbodegas
				stringinserta  = stringinserta +IIF(il = inmv0100.bodega, EXTSTR(inmv0100.stoini), "0")+","	
			ENDFOR
			totalexist = inmv0100.stoini
			stringinserta = SUBSTR(stringinserta, 1, LEN(stringinserta) -1)
			comando = "INSERT INTO "+ nomtabla + " VALUES ("+CHR(34)+prodacti+CHR(34)+" , "+ ALLTRIM(STR(inmt0400.clase))+" , "+EXTSTR(totalexist)+" , "+stringinserta+")"
			&comando	
		ENDIF
		SELE INMV0100
	ENDSCAN
	SELE (taula)
ENDPROC

PROCEDURE CREAEXPRESIONFILTRODEPRODUCTOSUNMOVIMIENTO(unelcorrela)
	LOCAL tla, usado115, elmesact, elanyoact, strfiltro
	s1 = SECONDS()
	tla = ALIAS()
	usado115 = USED('inmv0115')
	IF NOT usado115 THEN
		USE INMV0115 IN 0 
	ENDIF
	SELE INMV0115
	elmesact = MONTH(W_DESDE)
	elanyoact = YEAR(W_DESDE)
	strfiltro = ""
	SCAN FOR correla = unelcorrela AND nmes = elmesact AND anyo = elanyoact AND empresa = nCodigo
		strfiltro = strfiltro+ "ALLTRIM(UPPER(producto)) == '"+ALLTRIM(UPPER(inmv0115.producto))+"' OR "
	ENDSCAN
	
	IF NOT EMPTY(strfiltro) THEN
		strfiltro = SUBSTR(strfiltro,1,LEN(strfiltro)-3)
	ENDIF
		
	IF NOT usado115 THEN
		USE IN INMV0115
	ENDIF
	IF NOT EMPTY(tla) THEN
		SELE (tla)
	ENDIF
	s2 = SECONDS()
	RETURN strfiltro
ENDPROC

PROCEDURE CREATABLAINMV0110(R_MES, R_ANYO, filtroproductos)
	LOCAL tla
	usada105 = USED('inmv0105')
	usada115 = USED('inmv0115')

	tla = ALIAS()
	RECORDARCODIGO()
	
	
	IF (PCOUNT() < 3) OR (EMPTY(filtroproductos)) THEN && En este caso son todos los movimientos de un mes
		SELECT inmv0115.*, inmv0105.numdoc, inmv0105.tipdoc, inmv0105.fecha, inmv0105.tipcomp, inmv0105.bodega, inmv0105.bodegafin;
		FROM inmv0115 INNER JOIN inmv0105 ON inmv0115.correla = inmv0105.correla AND inmv0115.nmes = inmv0105.nmes AND inmv0115.anyo = inmv0105.anyo AND inmv0115.empresa = inmv0105.empresa;
		INTO TABLE (dirtemp+"inmv0110");
		WHERE inmv0105.nmes = R_MES AND inmv0105.anyo = R_ANYO AND inmv0105.empresa = nCodigo;
		ORDER BY inmv0115.producto, inmv0105.fecha
	ELSE && En este caso slo los de los productos que pasan el filtro
				
		SELECT inmv0115.*;
		FROM inmv0115;
		INTO TABLE (dirtemp+"winmv0115");
		WHERE inmv0115.nmes = R_MES AND inmv0115.anyo = R_ANYO AND inmv0115.empresa = nCodigo AND &filtroproductos
					
		SELECT winmv0115.*, inmv0105.numdoc, inmv0105.tipdoc, inmv0105.fecha, inmv0105.tipcomp, inmv0105.bodega, inmv0105.bodegafin;
		FROM winmv0115 INNER JOIN inmv0105 ON winmv0115.correla = inmv0105.correla; 	
		INTO TABLE (dirtemp+"inmv0110");
		WHERE inmv0105.nmes = R_MES AND inmv0105.anyo = R_ANYO AND inmv0105.empresa = nCodigo;
		ORDER BY winmv0115.producto, inmv0105.fecha
				
		USE IN winmv0115
	ENDIF
	
	IF NOT usada105 THEN
		USE IN INMV0105
	ENDIF
	
	IF NOT usada115 THEN
		USE IN INMV0115
	ENDIF
	IF NOT EMPTY(tla) THEN
		SELECT (tla)
	ENDIF
ENDPROC

PROCEDURE RECALCULA_STOCKS_Y_COSTOS(R_MES, R_ANYO, tablabeneficios, elfiltroproductos, indicetablabeneficios) 
	&& Si tablabeneficios existe y no es vaco se genera una tabla con todos los movimientos y beneficios del mes
	
	LOCAL taula, prodactual, bodegaactual, comando, numbodegas
	DIMENSION BODEGAS(MAXBODEGAS), STOCKS(MAXBODEGAS), COSTOS(MAXBODEGAS)
	IF PCOUNT()<3 THEN
		tablabeneficios = ""
	ENDIF
	
	IF PCOUNT()<4 THEN
		elfiltroproductos  = ""
	ENDIF
	
	IF PCOUNT()<5 THEN
		indicetablabeneficios = "DTOS(fecha)+corredeta"
	ENDIF
	
	&& Inicializaciones.
	
	taula = ALIAS()	
	
	RECORDARCODIGO()
	
	IF EMPTY(tablabeneficios) THEN
		BEGIN TRANSACTION
	ENDIF
		

	&& Se abren las tablas y se aplican los filtros y el orden
	
	nousado0100inicio = NOT USED('INMV0100')
	
		
	IF nousado0100inicio THEN
		USE INMV0100 IN 0 ALIAS INMV0100
		SELE INMV0100
	ELSE
		SELE INMV0100
		registro0100 = GUARDANUMEROREGISTRO()
		filtro0100 = FILTER()
		SET FILTER TO
	ENDIF

	SET ORDER TO producto
	
	nousado0400 = NOT USED('INMT0400')
	IF nousado0400 THEN
		USE INMT0400 IN 0 ALIAS INMT0400
		SELE INMT0400
	ELSE
		SELE INMT0400
		registro0400 = GUARDANUMEROREGISTRO()
		filtro0400 = FILTER()
	ENDIF
	
	&& Se crean las tablas y el array que nos van a servir para 
	
	numbodegas = CREAARRAYBODEGAS(R_MES, R_ANYO)		
	
	IF NOT EMPTY(tablabeneficios) THEN
		CREATABLABENEFICIOS(tablabeneficios, indicetablabeneficios)
	ENDIF

	CREATABLAINMV0110(R_MES, R_ANYO, elfiltroproductos)
		
	SELE INMT0400

	comando = 'SET FILTER TO nmes = '+ STR(R_MES)+' AND anyo = '+ STR(R_ANYO)+ ' AND empresa = '+ STR(nCodigo)
	&comando
	LOCATE
	
	&& Para todos los productos, se les inicializa el stock y costo final a sus respectivos iniciales
	&& Como el stock y costo finales sern modificados para los productos que tienen movimientos 
	&& esto slo ser efectivo para los productos sin movimientos en este mes.
	
	&&El reseteo de los movimientos es slo para los productos del movimiento actual
	IF EMPTY(tablabeneficios) THEN
		strfiltroproductos = IIF(EMPTY(elfiltroproductos),""," AND "+elfiltroproductos)
		SELE INMV0100
		WREPLACEALL('cosact WITH cosini, stoact WITH stoini', 'nmes = '+STR(R_MES)+' AND anyo = '+ STR(R_ANYO)+' AND empresa = '+STR(nCodigo)+ strfiltroproductos)
	ENDIF

		
	&& Se actualiza el costo y el stock de los productos 
	
	SELE INMV0110
	GO TOP 
	
	DO WHILE NOT EOF()
		prodactual = inmv0110.producto	
		PONEINICIALESENARRAYS(prodactual, R_MES, R_ANYO, numbodegas)
		DO RECALCULA_STOCOSTOS_PRODUCTO_AUX WITH R_MES, R_ANYO, tablabeneficios
		IF EMPTY(tablabeneficios) THEN
			ACTUALIZABODEGASCONARRAY(prodactual, R_MES, R_ANYO, numbodegas)
		ENDIF
	ENDDO
	
	&& Se cierra y se restaura la configuracin anterior
	
		
	SELE INMV0100
	
	
	IF nousado0100inicio THEN
		USE
	ELSE
		IF EMPTY(filtro0100) THEN
			SET FILTER TO
		ELSE
			SET FILTER TO &filtro0100
		ENDIF
		RECUPERANUMEROREGISTRO(registro0100)
	ENDIF
	
	SELE INMT0400
	IF nousado0400 THEN
		USE
	ELSE
		IF EMPTY(filtro0400) THEN
			SET FILTER TO
		ELSE
			SET FILTER TO &filtro0400
		ENDIF
		RECUPERANUMEROREGISTRO(registro0400)
	ENDIF
	
	USE IN WEXISTENCIAS
	USE IN WBODEGAS
	USE IN INMV0110
	
	IF NOT EMPTY(tablabeneficios) THEN
		USE IN (tablabeneficios)
	ENDIF

	
	IF NOT EMPTY(taula) THEN
		SELECT &taula
	ENDIF
	
	IF EMPTY(tablabeneficios) THEN
		END TRANSACTION
	ENDIF
	
ENDPROC

PROCEDURE RECALCULA_STOCOSTOS_PRODUCTO_AUX(R_MES, R_ANYO, tablabeneficios)
	* Debe encontrarse la tabla inmv0110 
	* Debe encontrarse al principio de los registros del producto. 
	* Slo calcula los costos de un producto
	
	LOCAL prodactual, tempcstsal
	IF PCOUNT()<3 THEN
		tablabeneficios = ""
	ENDIF
	prodactual = inmv0110.producto
	SELE INMV0110
	STOCKTODAS = 0
	COSTOTODAS = 0 
	DO WHILE NOT EOF() AND (IGUALSTRING(prodactual, inmv0110.producto))
		ACTUALIZASTOCKYCOSTOUNMOVIMIENTO(inmv0110.tipcomp, inmv0110.tipoent, inmv0110.cantidad, inmv0110.total, inmv0110.bodega, inmv0110.bodegafin, @tempcstsal, 2, 0)
		IF NOT EMPTY(tablabeneficios) THEN
			AGREGAREGISTROTABLABENEFICIOS(tablabeneficios, tempcstsal)
		ENDIF
		SKIP
	ENDDO
ENDPROC


FUNCTION CREAARRAYBODEGAS(eltnmes, eltnanyo, ordencodigo)
	&& Llena el array BODEGAS con las bodegas existentes ese mes y ao
	&& y retorna el nmero de bodegas.
	
	&& El parmetro "ordencodigo" indica si las bodegas se guardan en el 
	&&array en el orden de sus cdigos. Por defecto, es falso.
	LOCAL usadainmt0100
	RECORDARCODIGO()
	
	usadainmt0100 = USED('INMT0100')
	
	SELECT inmt0100.codigo; 
	FROM INMT0100;
	INTO TABLE (dirtemp+"WBODEGAS.DBF");
	WHERE inmt0100.nmes = eltnmes AND inmt0100.anyo = eltnanyo AND inmt0100.empresa = nCodigo;
	ORDER BY inmt0100.codigo
	
	
	SELECT * FROM WBODEGAS INTO ARRAY BODEGAS
	
	SELECT ALLTRIM(UPPER(inmv0100.producto)) AS producto, inmv0100.bodega, inmv0100.cosini, inmv0100.stoini; 
	FROM INMV0100;
	INTO TABLE (dirtemp+"WEXISTENCIAS.DBF");
	WHERE inmv0100.nmes = eltnmes AND inmv0100.anyo = eltnanyo AND inmv0100.empresa = nCodigo
	
	SELECT WEXISTENCIAS
	
	INDEX ON ALLTRIM(UPPER(producto)) TAG producto
	INDEX ON bodega TAG bodega
	
	IF NOT usadainmt0100 THEN
		USE IN INMT0100
	ENDIF		

	RETURN ALEN(BODEGAS)
ENDFUNC

PROCEDURE PONEINICIALESENARRAYS(elproducto, elpnmes, elpnanyo,nb)
	&& Pone stocks y costo iniciales de todas las bodegas en los arrays STOCKS y COSTOS 
	LOCAL tla, ni
	elproducto = ALLTRIM(UPPER(elproducto))
	tla = ALIAS()
	SELE WEXISTENCIAS	
	FOR ni = 1 TO nb
		LOCATE FOR ALLTRIM(UPPER(producto)) == elproducto AND bodega = BODEGAS(ni)
		IF FOUND() THEN 
			COSTOS(ni) = wexistencias.cosini
			STOCKS(ni) = wexistencias.stoini 
		ELSE
			COSTOS(ni) = 0
			STOCKS(ni) = 0
		ENDIF
		
	ENDFOR
	
	IF NOT EMPTY(tla) THEN
		SELE (tla)
	ENDIF
ENDPROC

PROCEDURE ACTUALIZABODEGASCONARRAY(elproducto, elnmes, elnanyo, nb)
	&& Coloca los stocks finales del mes (que se encuentran en los arrays STOCKS Y COSTOS) 
	&& en los registros de INMV0100	

	LOCAL tbla, ni
	tbla = ALIAS()
	SELE INMV0100
	FOR ni = 1 TO nb
		elproducto = ALLTRIM(UPPER(elproducto))
		LOCATE FOR ALLTRIM(UPPER(producto)) == elproducto AND bodega = BODEGAS(ni) AND empresa = nCodigo AND nmes = elnmes AND anyo = elnanyo
		IF FOUND() THEN
			IF cosact <> COSTOS(ni) AND stoact <> STOCKS(ni) THEN
				REPLACE cosact WITH COSTOS(ni), stoact WITH STOCKS(ni)
			ENDIF
		ELSE
			IF COSTOS(ni) <>0 OR STOCKS(ni) <>0 THEN	
				INSERT INTO INMV0100 (producto, bodega, stoini, stoact, cosini, cosact, empresa, nmes, anyo);
				VALUES (elproducto, BODEGAS(ni), 0, STOCKS(ni), 0, COSTOS(ni), nCodigo, elnmes, elnanyo)
			ENDIF
		ENDIF
	ENDFOR
	IF NOT EMPTY(tbla) THEN
		SELE (tbla)
	ENDIF
ENDPROC


PROCEDURE ACTUALIZASTOCKYCOSTOUNMOVIMIENTO(eltipcomp, eltipoent, lacantidad, elvalmov, lbodegaini, lbodegafin, cstsal, modofunc, bodegatrans)
	&& ATENCION: El parmetro elvalmov no contiene el valor del campo valmov, sino el valor del campo total.
	&& Actualiza los arrays STOCKS Y COSTOS con el efecto de un movimiento de inventario.
	&& Tiene varios modos de funcionamiento: 
	&& Si modofunc es 0 se calculan slo los stocks de una nica bodega. En este caso, si tipcomp = 14 (transferencia de bodegas), bodegatrans indica cul es esa bodega
	&& Si modofunc es mayor que 0, se calculan los costos y stocks de todas las bodegas.
	&& Si modofunc es mayor que 1, adems se calcula el costo y stock de todas las bodegas juntas (de cada producto)
	&& Los parmetros cstsal,  debe pasarse por referencia pues devuelve un valor
	&& El parmetro lbodegafin slo contiene informacin relevante si es una transferencia de bodegas
	&& Se suponen definidas las matrices, BODEGAS, STOCKS y COSTOS
	LOCAL indicebodega, indicebodegafin
		IF PCOUNT() < 7 THEN
			modofunc = 1
		ENDIF
		
		IF PCOUNT() < 8 THEN
			bodegatrans = 0
		ENDIF
		
		IF (modofunc = 0) THEN
			indicebodega = 1
			indicebodegafin = 1
		ELSE
			indicebodega = BUSCAARRAY(@BODEGAS,lbodegaini)
		ENDIF
	
		
		DO CASE
			CASE eltipcomp = 1
				
				STOCKS(indicebodega) = STOCKS(indicebodega) + lacantidad
				IF modofunc > 0 THEN
					COSTOS(indicebodega) = COSTOS(indicebodega) + elvalmov
					cstsal = elvalmov
				ENDIF
				
				IF modofunc >1 THEN
					STOCKTODAS = STOCKTODAS + lacantidad
					COSTOTODAS = COSTOTODAS + elvalmov
				ENDIF
								
			CASE eltipcomp = 2
					
				IF modofunc > 0 THEN					
					cstsal = IIF(STOCKS(indicebodega) = 0,0,lacantidad * COSTOS(indicebodega)/STOCKS(indicebodega)) 
				ENDIF

				STOCKS(indicebodega) = STOCKS(indicebodega) - lacantidad				
				IF modofunc > 0 THEN
					COSTOS(indicebodega) = COSTOS(indicebodega) - cstsal
				ENDIF
				
				IF modofunc >1 THEN
					STOCKTODAS = STOCKTODAS - lacantidad
					COSTOTODAS = COSTOTODAS - cstsal
				ENDIF
				
				
			CASE eltipcomp = 3
				STOCKS(indicebodega) = STOCKS(indicebodega) + lacantidad
				IF modofunc > 0 THEN
					COSTOS(indicebodega) = COSTOS(indicebodega) + elvalmov
					cstsal = elvalmov
				ENDIF
				IF modofunc >1 THEN
					STOCKTODAS = STOCKTODAS + lacantidad
					COSTOTODAS = COSTOTODAS + elvalmov
				ENDIF
				
				
			CASE eltipcomp = 4
				
				IF modofunc > 0 THEN
					cstsal = IIF(STOCKS(indicebodega) = 0,0,lacantidad * COSTOS(indicebodega)/STOCKS(indicebodega)) 
				ENDIF
				STOCKS(indicebodega) = STOCKS(indicebodega) - lacantidad
				IF modofunc > 0 THEN
					COSTOS(indicebodega) = COSTOS(indicebodega) - cstsal
				ENDIF
				IF modofunc >1 THEN
					STOCKTODAS = STOCKTODAS - lacantidad
					COSTOTODAS = COSTOTODAS - cstsal
				ENDIF
				
				
			CASE eltipcomp = 10
				
				STOCKS(indicebodega) = STOCKS(indicebodega) + lacantidad
				IF modofunc > 0 THEN
					COSTOS(indicebodega) = COSTOS(indicebodega) + elvalmov
					cstsal = elvalmov
				ENDIF
				IF modofunc >1 THEN
					STOCKTODAS = STOCKTODAS + lacantidad
					COSTOTODAS = COSTOTODAS + elvalmov
				ENDIF
				
				
			CASE eltipcomp = 12 AND eltipoent = 2
				
				STOCKS(indicebodega) = STOCKS(indicebodega) - lacantidad
				IF modofunc > 0 THEN
					COSTOS(indicebodega) = COSTOS(indicebodega) - elvalmov  
					cstsal = elvalmov
				ENDIF
				IF modofunc >1 THEN
					STOCKTODAS = STOCKTODAS - lacantidad
					COSTOTODAS = COSTOTODAS - elvalmov
				ENDIF
				
				
			CASE eltipcomp = 12 AND eltipoent = 1 
				
				STOCKS(indicebodega) = STOCKS(indicebodega) + lacantidad
				IF modofunc > 0 THEN
					COSTOS(indicebodega) = COSTOS(indicebodega) + elvalmov 
					cstsal = elvalmov
				ENDIF
				IF modofunc >1 THEN
					STOCKTODAS = STOCKTODAS + lacantidad
					COSTOTODAS = COSTOTODAS + elvalmov
				ENDIF
				
				
			CASE eltipcomp = 14
				
				IF modofunc > 0 THEN
					indicebodegafin = BUSCAARRAY(@BODEGAS,lbodegafin)
					cstsal = IIF(STOCKS(indicebodega) = 0,0,lacantidad * COSTOS(indicebodega)/STOCKS(indicebodega)) 
				ENDIF
				IF modofunc > 0  OR bodegatrans = lbodegaini THEN	
					STOCKS(indicebodega) = STOCKS(indicebodega) - lacantidad
				ENDIF
				IF modofunc > 0  OR bodegatrans = lbodegafin THEN
					STOCKS(indicebodegafin) = STOCKS(indicebodegafin) + lacantidad 	
				ENDIF
				IF modofunc > 0 THEN
					COSTOS(indicebodega) = COSTOS(indicebodega) - cstsal
					COSTOS(indicebodegafin) = COSTOS(indicebodegafin) + cstsal
				ENDIF
				&& En este caso no varan stocktodas ni COSTOTODAS 
				
		ENDCASE
ENDPROC



PROCEDURE CREATABLABENEFICIOS(tablagene, indicetablabeneficios)
	LOCAL numcampos, numcolumnas, it 
	
	IF NOT USED('INMV0115') THEN
		USE INMV0115 IN 0 ALIAS INMV0115
	ENDIF
		
	SELE INMV0115
	
	numcampos = AFIELDS(campostabla)
	USE
	
	numcolumnas = ALEN(campostabla,2)

	DIMENSION campostabla(numcampos+9, numcolumnas)


	campostabla (numcampos+1, 1) = 'fecha'
	campostabla (numcampos+1, 2) = 'D'
	campostabla (numcampos+1, 3) = 8
	campostabla (numcampos+1, 4) = 0

	campostabla (numcampos+2, 1) = 'tipcomp'
	campostabla (numcampos+2, 2) = 'N'
	campostabla (numcampos+2, 3) = 2
	campostabla (numcampos+2, 4) = 0
	
	campostabla (numcampos+3, 1) = 'numdoc'
	campostabla (numcampos+3, 2) = 'N'
	campostabla (numcampos+3, 3) = 10
	campostabla (numcampos+3, 4) = 0

	campostabla (numcampos+4, 1) = 'tipdoc'
	campostabla (numcampos+4, 2) = 'N'
	campostabla (numcampos+4, 3) = 2
	campostabla (numcampos+4, 4) = 0

	campostabla (numcampos+5, 1) = 'costobod'
	campostabla (numcampos+5, 2) = 'N'
	campostabla (numcampos+5, 3) = 15
	campostabla (numcampos+5, 4) = 2
		
	campostabla (numcampos+6, 1) = 'stockbod'
	campostabla (numcampos+6, 2) = 'N'
	campostabla (numcampos+6, 3) = LEEVARNUMDEFECTO('XYINENTEROSSTOCKS',10)
	campostabla (numcampos+6, 4) = LEEVARNUMDEFECTO('XYDECIMALESINVENTARIO',0)
	
	campostabla (numcampos+7, 1) = 'costoprod'
	campostabla (numcampos+7, 2) = 'N'
	campostabla (numcampos+7, 3) = 15
	campostabla (numcampos+7, 4) = 2
		
	campostabla (numcampos+8, 1) = 'stockprod'
	campostabla (numcampos+8, 2) = 'N'
	campostabla (numcampos+8, 3) = LEEVARNUMDEFECTO('XYINENTEROSSTOCKS',10)
	campostabla (numcampos+8, 4) = LEEVARNUMDEFECTO('XYDECIMALESINVENTARIO',0)

	campostabla (numcampos+9, 1) = 'costomovi'
	campostabla (numcampos+9, 2) = 'N'
	campostabla (numcampos+9, 3) = 15
	campostabla (numcampos+9, 4) = 2

	FOR it = numcampos+1 TO numcampos+9
		campostabla(it,5) = .F.
		campostabla(it,6) = .F.
		campostabla(it,7) = ""
		campostabla(it,8) = ""
		campostabla(it,9) = ""
		campostabla(it,10) = ""
		campostabla(it,11) = ""
		campostabla(it,12) = tablagene
		campostabla(it,13) = ""
		campostabla(it,14) = ""
		campostabla(it,15) = ""
		campostabla(it,16) = ""
	ENDFOR
	CREATE TABLE (dirtemp+tablagene) FREE FROM ARRAY campostabla
	comando = "INDEX ON "+indicetablabeneficios+" TAG fecha"
	&comando
ENDPROC

PROCEDURE AGREGAREGISTROTABLABENEFICIOS(tablabeneficios, costosal)
	LOCAL taula, indicebodgene
	
	taula = ALIAS()
	SELE INMV0110
	SCATTER MEMVAR
	indicebodgene = BUSCAARRAY(@BODEGAS,inmv0110.bodega)
	m.costobod = COSTOS(indicebodgene)
	m.stockbod = STOCKS(indicebodgene)
	m.costoprod = COSTOTODAS
	m.stockprod = STOCKTODAS
	m.costomovi = costosal
	IF (inmv0110.tipcomp = 14) THEN
		m.total = costosal 
	ENDIF

	INSERT INTO (tablabeneficios) FROM MEMVAR
	
	IF NOT EMPTY(taula) THEN
		SELE (taula)
	ENDIF	
ENDPROC



PROCEDURE BUSCAARRAY(matriu, element)
	LOCAL confexact, resultado
	confexact = SET ('EXACT')
	SET EXACT ON
	resultado = ASCAN(matriu, element)
	SET EXACT &confexact
	RETURN resultado
ENDPROC

PROCEDURE concepto(tipcomp, eltipoent, motivo)
	DO CASE
		CASE tipcomp = 1
			vconcepto = "COMPRA"
			
		CASE tipcomp = 2
			vconcepto = "VENTA"
				
		CASE tipcomp = 3
			IF EMPTY(ALLTRIM(UPPER(motivo))) THEN
				strcont = ""
			ELSE
				strcont = " POR "+ ALLTRIM(UPPER(motivo))
			ENDIF
			vconcepto = "ENTRADA" + strcont 
				
		CASE tipcomp = 4
			IF EMPTY(ALLTRIM(UPPER(motivo))) THEN
				strcont = ""
			ELSE
				strcont = " POR "+ ALLTRIM(UPPER(motivo))
			ENDIF
			vconcepto = "SALIDA" + strcont
				
		CASE tipcomp = 10
			vconcepto = "AJUSTE DE INVENTARIO"
			
		CASE tipcomp = 12 AND eltipoent = 2
			vconcepto = "SALIDA POR "+ ALLTRIM(UPPER(inmv0110.motivo))
			
		CASE tipcomp = 12 AND eltipoent = 1
			vconcepto = "ENTRADA POR "+ ALLTRIM(UPPER(inmv0110.motivo))
			
		CASE tipcomp = 14 AND inmv0110.bodega = MBODEGA
			vconcepto = "SALIDA POR TRANSFERENCIA"
			
		CASE tipcomp = 14 AND inmv0110.bodegafin = MBODEGA
			vconcepto = "ENTRADA POR TRANSFERENCIA"			
	ENDCASE
	RETURN vconcepto
ENDFUNC
	
*****************************************************************************
*                              OBTIENE STOCKS                               *
*                                                                           *
*****************************************************************************

FUNCTION STOCKPRINCIPIODEMES(tlproducto,tlbodega)
	LOCAL cost
	cost = 0 &&
	RETURN STOCKYCOSTOPRINCIPIODEMES(tlproducto,tlbodega, @cost)
ENDFUNC


FUNCTION STOCKYCOSTOPRINCIPIODEMES(ulproducto,ulbodega, costol)
	LOCAL result, taula
	taula = ALIAS()
	ABRIRSEGURO('INMV0100')
	LOCATE FOR ALLTRIM(UPPER(producto)) == ALLTRIM(UPPER(ulproducto)) AND bodega = ulbodega AND empresa = nCodigo AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE)
	IF FOUND() THEN
		result = inmv0100.stoini
		costol = inmv0100.cosini
	ELSE
		result = 0
		costol = 0
	ENDIF
	CERRARSEGURO('INMV0100')
	IF NOT EMPTY(taula) THEN
		SELECT &taula
	ENDIF
	RETURN result
ENDFUNC

FUNCTION STOCKFINDEMES(tlproducto,tlbodega)
	LOCAL cost
	cost = 0 &&
	RETURN STOCKYCOSTOFINDEMES(tlproducto,tlbodega, @cost)
ENDFUNC

FUNCTION STOCKYCOSTOFINDEMES(elproducto,labodega, costol)
	LOCAL stactual, taula
	taula = ALIAS()
	
	ABRIRSEGURO('INMV0100')
	LOCATE FOR ALLTRIM(UPPER(producto)) == ALLTRIM(UPPER(elproducto)) AND bodega = labodega AND empresa = nCodigo AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE)
	IF FOUND() THEN
		stactual = inmv0100.stoact
		costol = inmv0100.cosact
	ELSE
		stactual = 0
		costol = 0
	ENDIF
	
	CERRARSEGURO('INMV0100')
	IF NOT EMPTY(taula) THEN
		SELECT &taula
	ENDIF
	RETURN stactual
ENDIF

FUNCTION STOCKENFECHA(tlproducto,tlbodega, tlfecha)
	&& Devuelve el stock de un producto en una bodega en una fecha determinada.
	
	&& Declaracin de variables
	DIMENSION STOCKS(1)
	LOCAL cost, tempctsal, taula, seabrio0100, seabrio0110
	
	&& Abre las tablas si no estn abiertas y guarda la tabla actual
	seabrio0100 = .F.
	seabrio0110 = .F.
	taula = ALIAS()
	IF NOT USED('INMV0100') THEN
		USE INMV0100 IN 0 ALIAS INMV0100
		seabrio0100 = .T.
	ENDIF
	
	CREATABLAINMV0110(MONTH(tlfecha), YEAR(tlfecha))
			
	&& Recupera el stock inicial del producto en la bodega determinada
	SELE INMV0100
	GUARDAESTADOPREFIJO('tmp1')
	LOCATE FOR ALLTRIM(UPPER(producto)) == ALLTRIM(UPPER(tlproducto)) AND bodega = tlbodega AND empresa = nCodigo AND nmes = MONTH(tlfecha) AND anyo = YEAR(tlfecha)
	IF FOUND() THEN
		STOCKS(1) = inmv0100.stoini 
	ELSE
		STOCKS(1) = 0
	ENDIF
	RECUPERAESTADOPREFIJO('tmp1')
	
	&& Actualiza el stock con los movimientos
	
	SELE INMV0110
	GUARDAESTADOPREFIJO('tmp2')
	comando = 'SET FILTER TO ALLTRIM(UPPER(producto)) == '+ CHR(34)+ALLTRIM(UPPER(tlproducto))+CHR(34)+ ' AND fecha <= DATE('+STR(YEAR(tlfecha))+','+STR(MONTH(tlfecha))+','+STR(DAY(tlfecha))+') AND empresa = '+ STR(nCodigo)+' AND nmes = '+ STR(MONTH(tlfecha))+' AND anyo = '+ STR(YEAR(tlfecha))
	&comando
	
	GO TOP
	DO WHILE NOT EOF()
		ACTUALIZASTOCKYCOSTOUNMOVIMIENTO(inmv0110.tipcomp, inmv0110.tipoent, inmv0110.cantidad, inmv0110.total, inmv0110.bodega, inmv0110.bodegafin, @tempctsal, 0, tlbodega)
		SKIP
	ENDDO
	RECUPERAESTADOPREFIJO('tmp2')
	
	
	&& Cierra las tablas si las abri y recupera la tabla que hab aal pricipio de la funcin
	IF seabrio0100 THEN
		SELE INMV0100
		USE
	ENDIF
	SELE INMV0110
	USE
	
	IF NOT EMPTY(taula) THEN
		SELE (taula)
	ENDIF
	RETURN STOCKS(1)
ENDFUNC

FUNCTION STOCKYCOSTOENFECHA(unproducto, unabodega, unafecha, costo)
	&& Devuelve el stock y costo de un producto en una bodega en una fecha determinada
	&& El stock se devuelve como resultado de la funcin y el costo en un parmetro por referencia.
	LOCAL taula, comando, indice, nousado100, nousado110
	DIMENSION BODEGAS(MAXBODEGAS), STOCKS(MAXBODEGAS), COSTOS(MAXBODEGAS)
	taula = ALIAS()
	numbodegas = CREAARRAYBODEGAS(MONTH(unafecha), YEAR(unafecha))
	indice = BUSCAARRAY(@BODEGAS, unabodega)
	
	nousado100 = NOT USED('INMV0100')
	
	
	IF nousado100 THEN
		USE INMV0100 IN 0 ALIAS INMV0100
	ENDIF	
	
	CREATABLAINMV0110(MONTH(unafecha), YEAR(unafecha))
	
	SELE INMV0110

	filtro = FILTER()
	comando = 'SET FILTER TO ALLTRIM(UPPER(producto)) == '+ CHR(34)+ALLTRIM(UPPER(unproducto))+CHR(34)+ ' AND fecha <= DATE('+STR(YEAR(unafecha))+','+STR(MONTH(unafecha))+','+STR(DAY(unafecha))+') AND empresa = '+ STR(nCodigo)+' AND nmes = '+ STR(MONTH(unafecha))+' AND anyo = '+ STR(YEAR(unafecha))
	&comando
		
	PONEINICIALESENARRAYS(unproducto, MONTH(unafecha), YEAR(unafecha), numbodegas)


	GO TOP
	IF NOT EOF() THEN
		RECALCULA_STOCOSTOS_PRODUCTO_AUX(MONTH(unafecha), YEAR(unafecha))
	ENDIF
	
	IF EMPTY(filtro) THEN
		SET FILTER TO
	ELSE
		SET FILTER TO &filtro
	ENDIF


	IF nousado100 THEN
		SELE INMV0100
		USE
	ENDIF
	
	SELE INMV0110
	USE
	
	
	IF NOT EMPTY(taula) THEN
		SELECT &taula
	ENDIF
	costo = COSTOS(indice)
	RETURN STOCKS(indice)
ENDFUNC

FUNCTION STOCKMINIMO(elproducto)

	LOCAL lstmin, seabriotabla, taula
	
	taula = ALIAS()
	
	ABRIRSEGURO('INMT0400')	
	
	LOCATE FOR ALLTRIM(UPPER(codigo))== ALLTRIM(UPPER(elproducto)) AND empresa = nCodigo AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE)
	IF FOUND() THEN
		lstmin = inmt0400.stockmin
	ELSE
		lstmin = NULL
	ENDIF
		
	
	CERRARSEGURO('INMT0400')
	IF NOT EMPTY(taula) THEN
		SELECT &taula
	ENDIF
	
	RETURN lstmin
	
ENDFUNC

FUNCTION STOCKMAXIMO(elproducto)

	LOCAL stmax, seabriotabla, taula
	
	taula = ALIAS()

	ABRIRSEGURO('INMT0400')	
	
	LOCATE FOR ALLTRIM(UPPER(codigo))== ALLTRIM(UPPER(elproducto)) AND empresa = nCodigo AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE)
	IF FOUND() THEN
		stmax = inmt0400.stockmax
	ELSE
		stmax = NULL
	ENDIF
	
	IF seabriotabla THEN
		USE
	ENDIF
	CERRARSEGURO('INMT0400')
	IF NOT EMPTY(taula) THEN
		SELECT &taula
	ENDIF
	RETURN stmax
	
ENDFUNC

*****************************************************************************
*        	    	OBTIENE BODEGAS DE UNIDADES INDIVIDUALES                *
*                                                                           *
*****************************************************************************

PROCEDURE BODEGAUNIDADESPRODUCTO(elproducto, labodega, lafecha, cmes, canyo, nomtabla, solonombreunidad)
	LOCAL unaunidad, bodegainicial, nomtabla, tact, seencuentraenbodega
	** Mira qu unidades se encuentran en una bodega en una fecha determinada
	** Si producto es vaco, considera las unidades de todos los productos
	** Si producto no es vaco, considera las unidades de slo ese producto
	** Las unidades que encuentra las incluye en una tabla de nombre 'nomtabla'
	** Si solonombreunidad es cierto, la tabla slo contiene los nombres de las unidades
	** Si es falso, contiene toda la informacin de las unidades, tal como sta es guardada en INMT0600
	** Tanto inmt0600, inmv0120 como 'nomtabla' deben estar abiertas cuando se llama a esta funcin.
	
	&& Guardar el estado de las tablas
	tact = ALIAS()
	GUARDAESTADO('inmv0120')
	GUARDAESTADO('inmt0600')
	
	&& Recorrer las tablas inmv0120 e inmt0600 en bsqueda de las unidades que estn en la bodega
	SELE INMV0120
	SET ORDER TO cronos
	SET FILTER TO
	SELE INMT0600
	IF EMPTY(elproducto) THEN
		comando = "SET FILTER TO empresa = " + STR(nCodigo) + " AND nmes = " + STR(cmes) + " AND anyo = " + STR(canyo)
		&comando
	ELSE
		comando = "SET FILTER TO ALLTRIM(UPPER(producto)) == "+ CHR(34)+ ALLTRIM(UPPER(elproducto))+ CHR(34) +" AND empresa = "+ STR(nCodigo)+ " AND nmes = "+ STR(cmes)+ " AND anyo = "+ STR(canyo)
		&comando
	ENDIF
	GO TOP
	DO WHILE NOT EOF()
		registrog = RECNO()
		unaunidad = inmt0600.codigo
		bodegainicial = inmt0600.bodegaini
		SELE INMV0120
		
		&& Una unidad se encuentra en la bodega final si
		&& o bien, rama THEN, no hay ningn movimiento de esta unidad hasta la fecha y estaba en esa bodega al principio del mes
		&& rama ELSE, el ltimo movimiento hasta la fecha que hay con esa unidad la coloca en esa bodega
		
		filtro = FILTER()
		SET FILTER TO ALLTRIM(UPPER(unidadin)) == ALLTRIM(UPPER(unaunidad)) AND fecha <= lafecha AND empresa = nCodigo AND nmes = cmes AND anyo = canyo
		GO BOTTOM 
		IF EOF() THEN
			seencuentraenbodega = (bodegainicial = labodega) 
		ELSE
			seencuentraenbodega = (inmv0120.bodegafin = labodega)
		ENDIF
		IF EMPTY(filtro) THEN
			SET FILTER TO 
		ELSE
			SET FILTER TO &filtro
		ENDIF
		
		IF seencuentraenbodega THEN
			SELE INMT0600
			GO registrog
			SCATTER NAME registro		
			SELE (nomtabla)
			APPEND BLANK
			IF solonombreunidad THEN
				REPLACE unidadin WITH unaunidad
			ELSE
				GATHER NAME registro
			ENDIF	
		ENDIF
		
		SELE INMT0600


		GO registrog
		SKIP
	ENDDO
	
	&& Recuperar el estado de las tablas
	RECUPERAESTADO('inmv0120')
	RECUPERAESTADO('inmt0600')

	IF NOT EMPTY(tact) THEN
		SELE (tact)
	ENDIF
ENDPROC


FUNCTION BODEGAUNIDADANTESMOVIMIENTO()
* Necesita que las tablas INMT0600 e INMV0120 esten abiertas
* Necesita que en la tabla INMV0120 este posicionado el registro que contiene el movimiento
* Adems, la unidad debe existir

	LOCAL regis, seregistro, elmovimiento, launidad

	GUARDAESTADO()	
	SELE INMV0120
	elmovimiento = inmv0120.correla
	launidad = inmv0120.unidadin
	SET FILTER TO IGUALSTRING(unidadin, launidad) AND empresa = nCodigo
	SET ORDER TO cronos

	LOCATE FOR correla = elmovimiento AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE)
	SKIP -1
	IF BOF() THEN
		SELE INMT0600
		seregistro = .F.
		IF NOT EOF() THEN
			regis = RECNO()
			seregistro = .T.
		ENDIF
		LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(launidad)) AND empresa = nCodigo AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE)
		resultado = inmt0600.bodegaini

		IF seregistro THEN
			GO regis
		ENDIF
		SELE INMV0120
	ELSE
		resultado = inmv0120.bodegafin
	ENDIF
	RECUPERAESTADO()
	RETURN resultado
ENDFUNC

FUNCTION BODEGAUNIDADDESPUESMOVIMIENTO()
* Necesita que las tablas INMT0600 e INMV0120 esten abiertas
* Necesita que en la tabla INMV0120 este posicionado el registro que contiene el movimiento
* Adems, la unidad debe existir
* DEVUELVE -1 SI NO HAY UN MOVIMIENTO POSTERIOR CON ESA UNIDAD

	LOCAL regis, seregistro, elmovimiento, launidad
	GUARDAESTADO()	
	SELE INMV0120
	elmovimiento = inmv0120.correla
	launidad = inmv0120.unidadin
	SET FILTER TO IGUALSTRING(unidadin, launidad) AND empresa = nCodigo 
	SET ORDER TO cronos
	LOCATE FOR correla = elmovimiento AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE)
	SKIP
	IF EOF() THEN
		resultado = -1
	ELSE
		resultado = inmv0120.bodegaini
	ENDIF
	RECUPERAESTADO()
	RETURN resultado
ENDFUNC

FUNCTION 


FUNCTION BODEGAUNIDADENFECHA(launidad, lafecha)
* Necesita que las tablas INMT0600 e INMV0120 esten abiertas
* Retorna 0 si no est en ninguna bodega o la unidad no existe

	LOCAL regis, seregistro, elmovimiento, launidad

	GUARDAESTADOPREFIJO('unidadenfecha')	
	SELE INMV0120
	
	SET FILTER TO IGUALSTRING(unidadin, launidad) AND fecha <= lafecha AND empresa = nCodigo AND nmes = MONTH(lafecha) AND anyo = YEAR(lafecha)
	SET ORDER TO cronos
	GO BOTTOM
	IF EOF() THEN
		SELE INMT0600
		seregistro = .F.
		IF NOT EOF() THEN
			regis = RECNO()
			seregistro = .T.
		ENDIF
		LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(launidad)) AND empresa = nCodigo AND nmes = MONTH(lafecha) AND anyo = YEAR(lafecha)
		IF FOUND() THEN
			resultado = inmt0600.bodegaini
		ELSE
			resultado = 0
		ENDIF
		IF seregistro THEN
			GO regis
		ENDIF
		SELE INMV0120
	ELSE
		resultado = inmv0120.bodegafin
		SELE INMV0120
	ENDIF
	RECUPERAESTADOPREFIJO('unidadenfecha')	
	RETURN resultado
ENDFUNC

FUNCTION BODEGAUNIDADFINDEMES(launidad, elmes, elanyo)
* Necesita que las tablas INMT0600 e INMV0120 esten abiertas
* Necesita que en la tabla INMV0120 este posicionado el registro que contiene el movimiento
* Adems, la unidad debe existir

	LOCAL regis, seregistro, elmovimiento, launidad, comando

	GUARDAESTADO()	
	SELE INMV0120

	comando = "SET FILTER TO IGUALSTRING(unidadin, "+ CHR(34)+ launidad +CHR(34)+") AND empresa ="+ STR(nCodigo)+ "AND nmes = "+ STR(elmes)+" AND anyo = "+ STR(elanyo)
	&comando
	SET ORDER TO cronos
	GO BOTTOM
	IF EOF() THEN &&No hay registros
		SELE INMT0600
		seregistro = .F.
		IF NOT EOF() THEN
			regis = RECNO()
			seregistro = .T.
		ENDIF
		
		LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(launidad)) AND empresa = nCodigo AND nmes = elmes AND anyo = elanyo
		resultado = inmt0600.bodegaini
		IF seregistro THEN
			GO regis
		ENDIF
		SELE INMV0120
	ELSE
		resultado = inmv0120.bodegafin
	ENDIF
	RECUPERAESTADO()
	RETURN resultado
ENDFUNC


FUNCTION MENSAJEBODEGAUNIDAD(bodega, modo)
	LOCAL part1, part2, part3
	&& El modo es el modo verbal en que se encuentra la frase: 
	&& 1 es indicativo, 2 es subjuntivo, 3 es condicional
	DO CASE
		CASE modo = 1 
			part2 = 'se encuentra en '
		CASE modo = 2
			part2 = 'se encuentre en '
		CASE modo = 3
			part2 = 'debera encontrarse en '
	ENDCASE
	IF bodega = 0 THEN
		part1 = 'no '
		part3 = 'ninguna bodega'
	ELSE
		part1 = ''
		part3 = 'la bodega '+ EXTSTR(bodega)
	ENDIF
	RETURN (part1+part2+part3)
ENDFUNC



*****************************************************************************
*        	    	TIPO DE MOVIMIENTO SEGUN TIPCOMP                        *
*                                                                           *
*****************************************************************************


*FUNCTION ESMOVIMIENTO(tpcmp)
*	RETURN (tpcmp <> 11)
*ENDFUNC

FUNCTION TIPOENTNOAJUSTE(tpcmp)
	DO CASE
		CASE tpcmp = 10 OR tpcmp = 14
			RETURN 0 
		CASE tpcmp = 1 OR tpcmp = 3
			RETURN 1
		CASE tpcmp = 2 OR tpcmp = 4
			RETURN 2	
	ENDCASE
ENDFUNC

FUNCTION MOVIMIENTONOAJUSTEESENTRADA(tpcmp, eltipoent)
	RETURN (tpcmp = 1 ) OR (tpcmp = 3) OR ((tpcmp = 12) AND (eltipoent = 1))
ENDFUNC

FUNCTION MOVIMIENTONOAJUSTEESSALIDA(tpcmp, eltipoent)
	RETURN (tpcmp = 2 ) OR (tpcmp = 4) OR ((tpcmp = 12) AND (eltipoent = 2))
ENDFUNC

FUNCTION BODEGAINICIAL(eltipcomp, eltipoent, labodega)
	LOCAL LBODEGAINI
	DO CASE
		CASE eltipcomp = 1 OR eltipcomp = 3 OR (eltipcomp = 12 AND eltipoent = 1)
			LBODEGAINI = 0
		CASE eltipcomp = 2 OR eltipcomp = 4 OR eltipcomp = 10 OR (eltipcomp = 12 AND eltipoent = 2) OR eltipcomp = 14
			LBODEGAINI = labodega
	ENDCASE
	RETURN LBODEGAINI
ENDFUNC

FUNCTION BODEGAFINAL(eltipcomp, eltipoent, labodega, labodegafin)		
	LOCAL LBODEGAFIN
	DO CASE
		CASE eltipcomp = 1 OR eltipcomp = 3 OR eltipcomp = 10 OR (eltipcomp = 12 AND eltipoent = 1)
			LBODEGAFIN = labodega
		CASE eltipcomp = 2 OR eltipcomp = 4 OR (eltipcomp = 12 AND eltipoent = 2)
			LBODEGAFIN = 0
		CASE eltipcomp = 14
			LBODEGAFIN = labodegafin
	ENDCASE
	RETURN LBODEGAFIN
ENDFUNC
*****************************************************************************
*                          CALCULO CON VARIACIONES                          *
*                                                                           *
*****************************************************************************

FUNCTION CONTINUAANOMALIAS(modo, condicion)
	* Revisa las anomalas que se pueden producir en el alta, baja o modificacin
	* de un movimiento de inventario. Si no hay anomalas devuelve cierto
	* indicando que se puede continuar con el movimiento. Si las hay, visualiza 
	* un formulario con mensajes de error y devuelve falso.
	* Modo: 1 significa alta, 2 modificacin y 3 baja
	* Condicion es la condicin que define los registros de inmv0115 que se examinarn 
	* Inmv0105, inmv0115 y Inmv0120 deben estar abiertos. El registro de inmv0105 debe
	* ser el que representa al movimiento en cuestin.
	LOCAL texto, resultado
	IF LEEVARBOOLDEFECTO('XINOCULTARANOMALIAS',.F.) THEN
		RETURN .T.
	ELSE
		texto = TEXTOANOMALIASTABLA(modo, condicion)
		IF EMPTY(texto) THEN
			RETURN .T.
		ELSE
			DO FORM INMV0050 WITH texto TO resultado
			RETURN resultado
		ENDIF
	ENDIF
ENDFUNC

FUNCTION TEXTOANOMALIASTABLA(modo, condicion)
	* Revisa anomalias que se pueden producir en el alta, baja o modificacin
	* de un movimiento de inventario. Devuelve una cadena con la descripcin de las
	* anomalas si stas existen. Si no, devuelve la cadena vaca.
	* Modo: 1 significa alta, 2 modificacin y 3 baja
	* Condicion es la condicin que define los registros de inmv0115 que se examinarn 
	* Inmv0105, inmv0115 y Inmv0120 deben estar abiertos. El registro de inmv0105 debe
	* ser el que representa al movimiento en cuestin.
	* ALERTA: Tal como est programado, en el caso de la baja se debe revisar antes de borrar los registros
	* En el caso de la alta y modificacin despus (es decir, cuando ya se han introducido los registros). 
	* Esto podra cammbiar en el futuro si cambia el manejo de datos de los grid
	LOCAL texto, nregis, taula
	
	taula = ALIAS()
	eltipcomp = inmv0105.tipcomp
	labodega = inmv0105.bodega
	labodegafin = inmv0105.bodegafin
	lafecha = inmv0105.fecha
	SELE INMV0115
	IF NOT EMPTY(condicion) THEN
		condicion = 'FOR '+ condicion
	ENDIF
	texto = ''
	nregis = GUARDANUMEROREGISTRO()
	SCAN &condicion
		textoregact = TEXTOANOMALIASREGISTROACTUAL(modo, eltipcomp, inmv0115.producto, labodega, labodegafin, lafecha)
		IF NOT EMPTY(textoregact) THEN
			texto = texto + textoregact+CHR(13)+CHR(10)
		ENDIF
	ENDSCAN
	RECUPERANUMEROREGISTRO(nregis)
	IF NOT EMPTY(texto) THEN
		texto = SUBSTR(texto, 1, LEN(texto)- 2) 
	ENDIF
	IF NOT EMPTY(taula) THEN
		SELE (taula)
	ENDIF
	RETURN texto
ENDFUNC

FUNCTION TEXTOANOMALIASREGISTROACTUAL(modo, eltipcomp, elproducto, labodega, labodegafin, lafecha)
	* Revisa anomalias que se pueden producir en el alta, baja o modificacin
	* de un movimiento de inventario PERO SLO EN EL REGISTRO ACTUAL DE INMV0115
	* Es decir,slo en el movimiento de detalle que representa a un producto individual
	* Modo: 1 significa alta, 2 modificacin y 3 baja
	* Inmv0115 debe estar abierto y en el registro de detalle que representa
	* el producto en cuestin del movimiento en cuestin.
	
	LOCAL stmax, stmin, mensaje, stact, variacion, stdespues
	stmax = inmt0400.stockmax
	stmin = inmt0400.stockmin
	
	
	stact = STOCKENFECHA(elproducto, labodega, lafecha )

	IF eltipcomp = 2 OR eltipcomp = 4 OR (eltipcomp = 12 AND inmv0115.tipoent = 2) OR eltipcomp = 14 THEN 
		variacion = -inmv0115.cantidad
	ELSE
		variacion = inmv0115.cantidad
	ENDIF

	&& Alerta. Esto puede cambiar si el grid no est ligado
	DO CASE 
		CASE modo = 1 &&Alta
			stdespues = stact
		CASE modo = 2 &&Modificacin
			stdespues = stact
		CASE modo = 3 &&Baja
			stdespues = stact - variacion
	ENDCASE
	
	mensaje = ''
	IF stdespues < 0 THEN
		mensaje = mensaje +' sern negativas,'
	ENDIF

	IF ESNUMERICO(stmax) THEN 	
		IF stdespues+variacion > VAL(stmax) THEN
			mensaje = mensaje +' sern mayores que el stock mximo,'
		ENDIF		
	ENDIF
	
	IF ESNUMERICO(stmin) THEN 	
		IF stdespues+variacion < VAL(stmin) THEN
			mensaje = mensaje +' sern menores que el stock mmimo,'
		ENDIF
	ENDIF		
	
	IF NOT EMPTY(mensaje) THEN
		mensaje = SUBSTR(mensaje,1, LEN(mensaje)-1)+"."
		posultimacoma = RATC(',', mensaje)	
		IF posultimacoma <> 0 THEN
			mensaje = SUBSTR(mensaje, 1, posultimacoma-1)+"y"+ SUBSTR(mensaje, posultimacoma+1)
		ENDIF
		mensaje = 'Las existencias del producto "'+ALLTRIM(inmt0400.nomart)+'"'+mensaje
	ENDIF


	IF LEEVARBOOLDEFECTO ('XYUNIDADESINDIVIDUALES',.F.) AND modo = 3 THEN &&Si es una baja, comprueba las unidades individuales
		elcorredeta = inmv0115.corredeta
		elmes = inmv0115.nmes
		elanyo = inmv0115.anyo
		laempresa = inmv0115.empresa

		SELE INMV0120
		nregis120 = GUARDANUMEROREGISTRO()
		SCAN FOR ALLTRIM(UPPER(corredeta)) == ALLTRIM(UPPER(elcorredeta)) AND nmes = elmes AND anyo = elanyo AND empresa = laempresa
			bodegadespues = BODEGAUNIDADDESPUESMOVIMIENTO()
			IF (bodegadespues <> -1) AND (BODEGAINICIAL(eltipcomp, inmv0115.tipoent, labodega) <> BODEGAFINAL(eltipcomp, inmv0115.tipoent, labodega, labodegafin)) THEN
				mensaje = mensaje +  "No se debera borrar la unidad "+CHR(34)+ALLTRIM(inmv0120.unidadin)+CHR(34)+" del"+; 
					" presente movimiento pues los movimientos posteriores asumen que la unidad se encuentra"+;
					" donde el presente movimiento la dej."+ CHR(13)+CHR(10)
			ENDIF
		ENDSCAN
		RECUPERANUMEROREGISTRO(nregis120)
		SELE INMV0115
	ENDIF
	RETURN mensaje
ENDFUNC

FUNCTION MENSAJEERRORVARIACIONAUX(variaci, stmax,stmin, stact)
	LOCAL stres

	stres = ""
	
	IF stact >= 0 AND variaci + stact <0 THEN
		stres = stres + ", sern negativas ("+ ALLTRIM(STR(stact+variaci)) +")"
	ENDIF

	IF ESNUMERICO(stmax) THEN && Si hay stock mximo para este producto
		stmax = VAL(stmax)
		IF stact <= stmax AND variaci + stact > stmax THEN 
			stres = stres + ", superarn el stock mximo ("+ALLTRIM(STR(stmax)) + ")"
		ENDIF
	ENDIF
	
	IF ESNUMERICO(stmin) THEN && Si hay stock mnimo para este producto
		stmin = VAL(stmin)
	
		IF stact >= stmin AND variaci + stact < stmin THEN 
			stres = stres + ", descendern por debajo del stock mnimo ("+ALLTRIM(STR(stmin)) + ")"
		ENDIF
	ENDIF
	
	&& AJusta gramaticalmente la frase, prescindiendo de la primera coma y cambiando la ltima por "y" en caso de que haya ms de 2.
	IF NOT EMPTY(stres) THEN
		pos = AT(',',stres,3)
		IF pos = 0 THEN
			pos = AT(',',stres,2)
		ENDIF
		
		IF pos <> 0 THEN
			stres = SUBSTR(stres,1,pos-1)+" y"+SUBSTR(stres,pos+1)
		ENDIF
		
		stres = SUBSTR(stres,2)
	ENDIF
		
	RETURN stres
ENDFUNC

FUNCTION MENSAJEERRORVARIACION(variaci, stmax,stmin, stenfec, stfindemes)
	LOCAL st1, st2

	IF LEEVARBOOLDEFECTO('XAVISASTOCKSENFECHA',.T.) THEN
		st1 = MENSAJEERRORVARIACIONAUX(variaci, stmax,stmin, stenfec)
	ELSE
		st1 = ""	
	ENDIF
		
	IF LEEVARBOOLDEFECTO('XAVISASTOCKSFINDEMES',.T.) THEN
		st2 = MENSAJEERRORVARIACIONAUX(variaci, stmax,stmin, stfindemes)
	ELSE
		st2 = ""		
	ENDIF

	
	DO CASE
	
		CASE (NOT EMPTY(st1)) AND (NOT EMPTY(st2))
			st3 = "Si decide continuar, en este da, las existencias"+ st1 +"."+CHR(13)+CHR(13)+"Adems, al final de mes, las existencias"+ st2 + "." + CHR(13)+CHR(13)+"Est seguro de que desea continuar?"	
			
		CASE (NOT EMPTY(st1)) AND EMPTY(st2) 
			st3 = "Si decide continuar, en este da, las existencias"+ st1 +"."+CHR(13)+"Est seguro de que desea continuar?"
	
		CASE EMPTY(st1) AND (NOT EMPTY(st2)) 
			st3 = "Si decide continuar, al final de mes, las existencias"+ st2 +"."+CHR(13)+"Est seguro de que desea continuar?"
			
		CASE EMPTY(st1) AND EMPTY(st2) 
			st3 = ""
	
	ENDCASE
	
	RETURN st3
ENDFUNC



FUNCTION CALCULAVARIACIONREGISTRO(actual,antigua,valormadic, valormtipcomp, valortipoent)
	LOCAL variac
	IF valormadic THEN && Se trata de una insercin de un registro nuevo
		antigua = 0 
	ENDIF
	variac = actual - antigua
	IF valormtipcomp = 2 OR valormtipcomp = 4 OR (valormtipcomp = 12 AND valortipoent = 2) OR valormtipcomp = 14 THEN 
		&& Es una salida, venta o transferencia de bodegas, la variacin es negativa
		&& En el caso de transferencia de bodegas, se considera la variacin a la salida
		variac = - variac
	ENDIF
	RETURN variac		
ENDFUNC


FUNCTION ESVALIDOVARPVA(varia, prduct, nomproducto)
	SELE INMV0100
	LOCATE FOR ALLTRIM(UPPER(producto)) == ALLTRIM(UPPER(prduct)) AND bodega = m.bodega AND empresa = nCodigo AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE)
	IF FOUND() THEN
		stockactual = inmv0100.stoact
		existente = .T.
	ELSE
		stockactual = 0
		existente = .F.
	ENDIF
	IF stockactual + varia < 0 THEN
		MESSAGEBOX("No se puede ejecutar un proceso de valor agregado sobre ms unidades de las que se tienen (que son "+STR(stockactual,2)+").",48,"MILLENNIUM CONSULTING")
		esval = .F.
	ELSE
		SELE INMT0400
		LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(prduct)) AND empresa = nCodigo AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE)
		IF FOUND() THEN
			stockmaximo = inmt0400.stockmax
			stockminimo = inmt0400.stockmin
			IF stockactual+varia < VAL(stockminimo) AND NOT EMPTY(stockminimo) AND varia <>0 THEN
				IF stockactual >= VAL(stockminimo) THEN
					respuesta = MESSAGEBOX("Con este proceso, las existencias del producto "+nomproducto+" sern inferiores a "+ALLTRIM(stockminimo)+", que es el stock mnimo. Est seguro de que desea ejecutar este proceso?",52,"MILLENNIUM CONSULTING")
					esval = (respuesta = 6)
				ELSE
					IF varia <0 THEN
						respuesta = MESSAGEBOX("Las existencias del producto "+nomproducto+" son inferiores a "+ALLTRIM(stockminimo)+", que es el stock mnimo. Con este proceso, sern an ms inferiores. Est seguro de que desea ejecutar este proceso?",52,"MILLENNIUM CONSULTING")
						esval = (respuesta = 6)
					ELSE
						esval = .T.
					ENDIF
				ENDIF
			ELSE
				IF stockactual+varia > VAL(stockmaximo) AND NOT EMPTY(stockmaximo) AND varia<>0 THEN
					IF stockactual <= VAL(stockmaximo) THEN
						respuesta = MESSAGEBOX("Con este proceso, las existencias del producto "+CHR(34)+nomproducto+CHR(34)+" sern superiores a "+ALLTRIM(stockmaximo)+", que es el stock mximo. Est seguro de que desea ejecutar este proceso?",52,"MILLENNIUM CONSULTING")
						esval = (respuesta = 6)
					ELSE
						IF varia > 0 THEN
							respuesta = MESSAGEBOX("Las existencias del producto "+CHR(34)+nomproducto+CHR(34)+" son superiores a "+ALLTRIM(stockmaximo)+", que es el stock mximo. Con este proceso, sern an ms superiores. Est seguro de que desea ejecutar este proceso?",52,"MILLENNIUM CONSULTING")
							esval = (respuesta = 6)
						ELSE
							esval = .T.
						ENDIF
					ENDIF
				ELSE
					esval = .T.
				ENDIF	
			ENDIF
		ELSE
			MESSAGEBOX("El producto "+CHR(34)+nomproducto+CHR(34)+" que usted ha especificado no existe en el mes de trabajo",48, "MILLENNIUM CONSULTING")
			esval = .F.
		ENDIF
	ENDIF
	SELE INMV0110
	RETURN esval				
ENDFUNC	

FUNCTION NEGATIVOCONVARIACION(elproducto, labodega, stockact, lavariac)
	
	RETURN (stockactual + varia < 0) THEN
		
		esval = .F.	
	SELE &taula
ENDFUNC


*****************************************************************************
*          OTRAS FUNCIONES DEL FORMULARIO DE INVENTARIO                     *
*                                                                           *
*****************************************************************************


FUNCTION FECHAAJUSTEPOSTERIOR(labodega,lafecha, elproducto)
	LOCAL encontrado, seabriotabla, tablaant, recuperarregistro
	
	encontrado = {}
	seabriotabla = .F.
	recuperarregistro = .F.
	tablaant = ALIAS()
	
	CREATABLAINMV0110(MONTH(lafecha), YEAR(lafecha))
		
	SELE INMV0110
	
	IF NOT EOF() THEN
		nregis = RECNO()
		recuperarregistro = .T.
	ENDIF
	filtro = FILTER()
	SET FILTER TO 
	LOCATE FOR tipcomp = 10 AND empresa = nCodigo AND bodega = labodega AND fecha >= lafecha AND ALLTRIM(UPPER(producto)) == ALLTRIM(UPPER(elproducto))
	IF FOUND() THEN
		encontrado = inmv0110.fecha
	ENDIF
	SET FILTER TO &filtro
	IF recuperarregistro THEN
		GO nregis
	ENDIF
	
	USE
		
	SELE &tablaant
	RETURN encontrado
ENDFUNC



FUNCTION EXISTEREGISTROTABLAEXISTENCIAS (elproducto,labodega)
	LOCAL existe, seabriotabla, taula
	taula = ALIAS()
	
	IF NOT USED('INMV0100') THEN
		USE INMV0100 IN 0 ALIAS INMV0100
		seabriotabla = .T.
	ENDIF
	
	SELE INMV0100
	
	LOCATE FOR ALLTRIM(UPPER(producto)) == ALLTRIM(UPPER(elproducto)) AND bodega = labodega AND empresa = nCodigo AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE)
	existe = FOUND()
		
	IF seabriotabla THEN
		USE
	ENDIF
	
	SELECT &taula
	RETURN existe
ENDIF


FUNCTION HAYMOVIMIENTOSCONFECHAPOSTERIORENMES (xproducto, xbodega, xfecha)
	LOCAL taula, eseof, trobat
	taula = ALIAS()
	SELE INMV0110
	eseof = EOF()
	IF NOT eseof THEN
		nreg = RECNO()
	ENDIF
	LOCATE FOR ALLTRIM(UPPER(producto)) == ALLTRIM(UPPER(xproducto)) AND bodega = xbodega AND empresa = nCodigo AND fecha > xfecha AND nmes = MONTH(xfecha) AND anyo = YEAR(xfecha)
	trobat = FOUND()
	IF NOT eseof THEN
		GO nreg
	ELSE
	ENDIF
	SELE &taula
	RETURN trobat
ENDFUNC

FUNCTION MENSAJECAMBIOFECHA(elcorrela, lafecha, bodinicial, bodfinal)
	LOCAL mensaje1, mensaje2, mensaje3, vi, taula
	mensaje1 = ""
	mensaje2 = ""
	mensaje3 = ""
	taula = ALIAS()
	SELE INMV0120
	GUARDAESTADO('inmv0120','mensajecambiofecha')
	comando = "SET FILTER TO correla = "+ STR(elcorrela)+ "AND empresa = "+ STR(nCodigo) +" AND nmes = "+ STR(MONTH(W_DESDE))+ " AND anyo = "+ STR(YEAR(W_DESDE))
	
	&comando
	GO TOP
	DO WHILE NOT EOF()
		IF NOT CAMBIODENTROINTERVALO (lafecha) THEN
			IF NOT VALIDOBORRARUNIDAD(elcorrela, inmv0120.unidadin) THEN
				mensaje1 = mensaje1+ALLTRIM(inmv0120.unidadin)+","
			ENDIF
			vi = VALIDOINSERTARUNIDAD(elcorrela, inmv0120.unidadin, lafecha)
			IF  vi = -1 THEN
				mensaje2 = mensaje2+ALLTRIM(inmv0120.unidadin)+","
			ENDIF
			IF vi = -2 THEN
				mensaje3 = mensaje3+ALLTRIM(inmv0120.unidadin)+","
			ENDIF
		ENDIF
		SKIP
	ENDDO
	
	IF NOT EMPTY(mensaje1) THEN
		mensajefinal = "No se puede cambiar la fecha pues los movimientos posteriores asumen que algunas de las unidades ("+;
						SUBSTR(mensaje1,1,LEN(mensaje1)-1) +") se encuentran en la bodega donde el presente movimiento las dej."
	ELSE

		IF NOT EMPTY(mensaje2) THEN
				mensajefinal = "Para que la fecha de este movimiento sea "+ DTOC(lafecha)+;
				" las unidades de este movimiento en "+ DTOC(lafecha)+ MENSAJEBODEGAUNIDAD(bodinicial,3)+;
				", pero esto no se cumple en algunas unidades ("+SUBSTR(mensaje2,1,LEN(mensaje2)-1)+")."
		ELSE
			IF NOT EMPTY(mensaje3) THEN
				mensajefinal = "Para que la fecha de este movimiento sea "+ DTOC(lafecha)+;
				" las unidades de este movimiento despus "+ DTOC(lafecha)+MENSAJEBODEGAUNIDAD(bodfinal,3)+;
				", pero esto no se cumple en algunas unidades ("+SUBSTR(mensaje3,1,LEN(mensaje3)-1)+")."
			ELSE
				mensajefinal = ""
			ENDIF
		ENDIF
	ENDIF
				
	RECUPERAESTADO('inmv0120','mensajecambiofecha')
	SELE (taula)
	RETURN mensajefinal
ENDFUNC


FUNCTION VALIDOBORRARUNIDAD(elcorrela, launidadin)
	LOCAL bd
	SELE INMV0120
	GUARDAESTADO('inmv0120')
	LOCATE FOR correla = elcorrela AND ALLTRIM(UPPER(unidadin)) == ALLTRIM(UPPER(launidadin)) AND empresa = nCodigo AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE)
	bd = BODEGAUNIDADDESPUESMOVIMIENTO()
	RECUPERAESTADO('inmv0120')
	RETURN (bd = -1) OR (inmv0120.bodegaini = inmv0120.bodegafin)
ENDFUNC

FUNCTION VALIDOINSERTARUNIDAD(elcorrela, launidadin, lafecha)
	LOCAL ba, bd, resultado
	SELE INMV0120
	GUARDAESTADO('inmv0120')
	BEGIN TRANSACTION
	LOCATE FOR correla = elcorrela AND ALLTRIM(UPPER(unidadin)) == ALLTRIM(UPPER(launidadin)) AND empresa = nCodigo AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE)
	SCATTER MEMVAR
	DELETE NEXT 1
	m.fecha = lafecha
	INSERT INTO INMV0120 FROM MEMVAR	
	ba = BODEGAUNIDADANTESMOVIMIENTO()
	bd = BODEGAUNIDADDESPUESMOVIMIENTO()
	IF (ba <> inmv0120.bodegaini) THEN
		resultado = -1
	ELSE
		IF (bd <> -1) AND (bd <> inmv0120.bodegafin) THEN
			resultado =  -2
		ELSE
			resultado =  1
		ENDIF
	ENDIF
	ROLLBACK
	RECUPERAESTADO('inmv0120')
	RETURN resultado
ENDFUNC

PROCEDURE BORRARUNIDADESPRODUCTOMESESPOSTERIORES(codigoproducto)
	LOCAL taul, usado600, usado610, usado120, filtro600, filtro610, filtro120
	
	&& Si no hay unidades individuales, no hace nada.
	IF LEEVARBOOLDEFECTO('XYUNIDADESINDIVIDUALES',.F.) THEN
	
		&& Inicializa variables y abre las tablas si no estaban abiertas
		taul = ALIAS()
		usado600 = .T.
		usado610 = .T.
		usado120 = .T.
		
		IF NOT USED('INMT0600') THEN
			usado600 = .F.
			USE INMT0600 IN 0 ALIAS INMT0600
		ENDIF
		IF NOT USED('INMT0610') THEN
			usado610 = .F.
			USE INMT0610 IN 0 ALIAS INMT0610
		ENDIF
		IF NOT USED('INMV0120') THEN
			usado120 = .F.
			USE INMV0120 IN 0 ALIAS INMV0120
		ENDIF
		
		SELE INMT0600
		filtro600 = FILTER()
		SET FILTER TO 
		SELE INMT0610
		filtro610 = FILTER()
		SET FILTER TO 
		SELE INMV0120
		filtro120 = FILTER()
		SET FILTER TO 

		&& Borra las lneas de detalle de las unidades individuales (INMT0610) y los movimientos de las unidades (INMV0120)
		SELE INMT0600
		filtro = FILTER()
		SET FILTER TO ALLTRIM(UPPER(producto)) == ALLTRIM(UPPER(codigoproducto)) AND empresa = nCodigo AND POSTERIOROIGUALMES(W_MESMAX,W_ANYOMAX,nmes,anyo) AND POSTERIOROIGUALMES(nmes,anyo,MONTH(W_DESDE),YEAR(W_DESDE))
		GO TOP
		DO WHILE NOT EOF()
			SELE INMT0610
			DELETE ALL FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(inmt0600.codigo)) AND empresa = nCodigo AND POSTERIOROIGUALMES(W_MESMAX,W_ANYOMAX,nmes,anyo) AND POSTERIOROIGUALMES(nmes,anyo,MONTH(W_DESDE),YEAR(W_DESDE)) IN INMT0610
			SELE INMV0120
			DELETE ALL FOR ALLTRIM(UPPER(unidadin)) == ALLTRIM(UPPER(inmt0600.codigo)) AND empresa = nCodigo AND POSTERIOROIGUALMES(W_MESMAX,W_ANYOMAX,nmes,anyo) AND POSTERIOROIGUALMES(nmes,anyo,MONTH(W_DESDE),YEAR(W_DESDE)) IN INMV0120
			SELE INMT0600
			SKIP	
		ENDDO
		
		&& Borra los encabezados de las unidades individuales (INMT0600)
		
		DELETE ALL IN INMT0600 &&Slo borra los registros filtrados
		
		&&Vuelve al filtro anterior de INMT0600 y cierra las tablas si procede
		
		SELE INMT0600		
		IF EMPTY(filtro600) THEN
			SET FILTER TO 
		ELSE
			SET FILTER TO &filtro600
		ENDIF
		
		SELE INMT0610		
		IF EMPTY(filtro610) THEN
			SET FILTER TO 
		ELSE
			SET FILTER TO &filtro610
		ENDIF
		
		SELE INMV0120
		IF EMPTY(filtro120) THEN
			SET FILTER TO 
		ELSE
			SET FILTER TO &filtro120
		ENDIF
				
		
		IF NOT usado600 THEN
			SELE INMT0600
			USE
		ENDIF
		IF NOT usado610 THEN
			SELE INMT0610
			USE
		ENDIF
		IF NOT usado120 THEN
			SELE INMV0120
			USE
		ENDIF
		&&Recupera la tabla actual
		IF NOT EMPTY(taul) THEN
			SELE (taul)
		ENDIF
			
	ENDIF
ENDPROC

FUNCTION CAMBIODENTROINTERVALO (lafecha)
	LOCAL nrec, filtro, cr, cmando, fecha1, fecha2, pda, fda
	nrec = RECNO()
	filtro = FILTER()
	cmando = "SET FILTER TO ALLTRIM(UPPER(unidadin)) == "+CHR(34)+ALLTRIM(UPPER(inmv0120.unidadin))+CHR(34)+" AND empresa ="+ STR(nCodigo)
	&cmando
	
	SKIP -1
	pda = BOF()
	IF NOT pda THEN
		fecha1 = inmv0120.fecha
		SKIP
	ENDIF
	
	SKIP
	
	fda = EOF()
	IF NOT fda THEN
		fecha2 = inmv0120.fecha
	ENDIF

	SET FILTER TO &filtro
	GO nrec
	RETURN (pda OR lafecha > fecha1) AND (fda OR lafecha < fecha2)
ENDFUNC

FUNCTION PRODUCTOCONUNIDADESINDIVIDUALES(elproducto)
&& Mira si un producto tiene gestin de unidades individuales.
	LOCAL taula, indiv, registro

	taula = ALIAS()

	SELE INMT0400
	registro = GUARDANUMEROREGISTRO()		
	LOCATE FOR ALLTRIM(UPPER(codigo)) == ALLTRIM(UPPER(elproducto)) AND empresa = nCodigo AND nmes = MONTH(W_DESDE) AND anyo = YEAR(W_DESDE)
	IF FOUND() THEN
		indiv = inmt0400.individua
	ELSE
		indiv = .F.
	ENDIF

	RECUPERANUMEROREGISTRO(registro)

	IF NOT EMPTY(taula) THEN
		SELE (taula)
	ENDIF

	RETURN indiv
ENDFUNC

