DEFINE CLASS CasillaExento AS CheckBox
	Caption = ''
	BackStyle = 0
	Width = 32
			
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
	PROCEDURE InteractiveChange
		IF THIS.Value = 1 AND M.TIPMOV =2 AND M.APLICA = 2 THEN 
			MESSAGEBOX("Las exportaciones son gravadas con una tasa 0 de IVA (Art. 74 y 75 de la Ley)", 48, "MILLENNIUM CONSULTING")
			THIS.Value = 0 
		ELSE 
			IF THIS.Value = 1 AND M.TIPDOC =3 THEN 
				MESSAGEBOX("Las notas de crdito no incluyen ventas exentas.", 48, "MILLENNIUM CONSULTING")
				THIS.Value = 0 
			ELSE
				IF THIS.Value = 1 AND M.TIPDOC =4 THEN 
					MESSAGEBOX("Las notas de dbito no incluyen ventas exentas.", 48, "MILLENNIUM CONSULTING")
					THIS.Value = 0 
				ELSE
					IF THIS.Value = 1 AND M.TIPDOC =5 THEN 
						MESSAGEBOX("Los comprobantes de retencin no incluyen ventas exentas.", 48, "MILLENNIUM CONSULTING")
						THIS.Value = 0 
					ELSE
						IF THIS.Value = 1 THEN
							cambio = ivmv0110.total
						ELSE
							cambio = - ivmv0110.total
						ENDIF
						IF M.TIPMOV = 2 AND M.APLICA = 2 THEN
							TIPOIVA = 0
						ELSE
							TIPOIVA = 0.13
						ENDIF
						IF M.TIPDOC = 2 AND FACTURASDIFERENTES THEN
							totalmov = M.VALMOV+M.VALIVA
							totalmov = totalmov - cambio
							M.VTAEXE = M.VTAEXE + cambio
							M.VALMOV = (totalmov/(1+TIPOIVA))
							M.VALIVA = totalmov - M.VALMOV
						ELSE
							M.VALMOV = M.VALMOV - cambio
							M.VTAEXE = M.VTAEXE + cambio
							M.VALIVA = TIPOIVA * M.VALMOV
						ENDIF
						
						M.VALTOT = M.VALMOV+M.VALIVA+M.VTAEXE

						REPLACE VTAEXE WITH M.VTAEXE IN IVMV0100
						REPLACE VALMOV WITH M.VALMOV IN IVMV0100
						REPLACE VALIVA WITH M.VALIVA IN IVMV0100
						REPLACE VALTOT WITH M.VALTOT IN IVMV0100
					
						DO REFRESCATOTALESFACTURA IN IVLIB001
					
						REPLACE exento WITH THIS.VALUE IN ivmv0110
					ENDIF
				ENDIF
			ENDIF
		ENDIF
	ENDPROC
	PROCEDURE Valid
		This.Visible = .T.
	ENDPROC
ENDDEFINE

DEFINE CLASS CasillaTrasladado AS CheckBox
	Caption = ''
	BackStyle = 0
	Width = 32
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
ENDDEFINE

DEFINE CLASS CasillaUnitario AS CantidadMonetaria
	Caption = ''
	BackStyle = 0
	Width = 77
	DentroGrid = .T.
	ControlSource = 'ivmv0110.unitario'
	InputMask = '999,999,999,999.99'
	PROCEDURE When
		RETURN M.DETA
	ENDPROC
	PROCEDURE Valid
		REPLACE NEXT 1 TOTAL WITH THIS.VALUE * CANTIDAD
		THISFORM.TOTALESFACTURA()
		THISFORM.REFRESH
	ENDPROC
ENDDEFINE

DEFINE CLASS CasillaTotal AS CantidadMonetaria
	Caption = ''
	BackStyle = 0
	Width = 77
	DentroGrid = .T.
	ControlSource = 'ivmv0110.total'
	InputMask = '999,999,999,999.99'
	PROCEDURE When
		RETURN .F.
	ENDPROC
ENDDEFINE

PROCEDURE REFRESCATOTALESFACTURA() 
	_VFP.ActiveForm.txtValmov.REFRESH
	_VFP.ActiveForm.txtValiva.REFRESH
	_VFP.ActiveForm.txtVtaexe.REFRESH
	_VFP.ActiveForm.txtValtot.REFRESH
ENDPROC

PROCEDURE PRIMERAFECHAFACTURA(condicion)
	LOCAL seabrio, taula, lregistro, filtre 
	
	taula = ALIAS()
	
	IF USED('IVMV0100') THEN
	    SELE IVMV0100
	    filtre = FILTER()
	    SET FILTER TO 
		lregistro = GUARDANUMEROREGISTRO()
		seabrio = .F.	
	ELSE
		USE IVMV0100 IN 0 ALIAS IVMV0100
		SELE IVMV0100
		seabrio = .T.	
	ENDIF

	CALCULATE MIN(fecdoc) FOR &condicion TO resultado

	IF seabrio THEN
		USE 
	ELSE
		RECUPERANUMEROREGISTRO(lregistro)
		IF NOT EMPTY(filtre) THEN
		   SET FILTER TO &filtre
		   LOCATE
		ENDIF
	ENDIF
	IF NOT EMPTY(taula) THEN
		SELE (taula)
	ENDIF
	RETURN resultado 
ENDPROC

PROCEDURE ULTIMAFECHAFACTURA(condicion)
	LOCAL seabrio, taula, lregistro, filtre 
	
	taula = ALIAS()
	
	IF USED('IVMV0100') THEN
	    SELE IVMV0100
	    filtre = FILTER()
	    SET FILTER TO 
		lregistro = GUARDANUMEROREGISTRO()
		seabrio = .F.	
	ELSE
		USE IVMV0100 IN 0 ALIAS IVMV0100
		SELE IVMV0100
		seabrio = .T.	
	ENDIF

	CALCULATE MAX(fecdoc) FOR &condicion TO resultado

	IF seabrio THEN
		USE 
	ELSE
		RECUPERANUMEROREGISTRO(lregistro)
		IF NOT EMPTY(filtre) THEN
		   SET FILTER TO &filtre
		   LOCATE
		ENDIF
	ENDIF
	IF NOT EMPTY(taula) THEN
		SELE (taula)
	ENDIF
	RETURN resultado 
ENDPROC


