*****************************************************************************
*                        PROPAGA PLANILLA		                            *
*                                                                           *
*****************************************************************************

PROCEDURE PROPAGA_PLANILLA
	SET PROC TO CILIB001 ADDITIVE
	DO PROPAGA_DEPARTAMENTOS	
	DO PROPAGA_CARGOS
	DO PROPAGA_INSTITUCIONES
	DO PROPAGA_AFPS
	DO PROPAGA_EMPLEADOS
	DO PROPAGA_DESCUENTOS
ENDPROC

PROCEDURE CREA_PLANILLA_NUEVO_PERIODO(PERIODONUEVO)
	SET PROC TO CILIB001 ADDITIVE
	W_PERANT = W_PERIODO
	W_PERMAXANT = W_PERMAX
	DO CREA_DEPARTAMENTOS_NUEVO_PERIODO WITH PERIODONUEVO
	W_PERIODO = W_PERANT 
	W_PERMAX = W_PERMAXANT 	
	DO CREA_CARGOS_NUEVO_PERIODO WITH PERIODONUEVO
	W_PERIODO = W_PERANT 
	W_PERMAX = W_PERMAXANT 
	DO CREA_INSTITUCIONES_NUEVO_PERIODO WITH PERIODONUEVO
	W_PERIODO = W_PERANT 
	W_PERMAX = W_PERMAXANT 
	DO CREA_AFPS_NUEVO_PERIODO WITH PERIODONUEVO
	W_PERIODO = W_PERANT 
	W_PERMAX = W_PERMAXANT 
	DO CREA_EMPLEADOS_NUEVO_PERIODO WITH PERIODONUEVO
	W_PERIODO = W_PERANT 
	W_PERMAX = W_PERMAXANT 
	DO CREA_DESCUENTOS_NUEVO_PERIODO WITH PERIODONUEVO
ENDPROC

PROCEDURE PROPAGA_DEPARTAMENTOS
	LOCAL filtro, periodoactual, contaperiodo, nregist

	periodoactual = W_PERIODO
	IF NOT USED('PLMT0100') THEN
		USE PLMT0100 IN 0 ALIAS PLMT0100 EXCLUSIVE
	ENDIF
	SELECT PLMT0100
	filtro = FILTER()
	SET FILTER TO
	LOCATE FOR empresa = nCodigo AND periodo = periodoactual
	DO WHILE NOT EOF()
		nregist = RECNO()
		contaperiodo = periodoactual+1
		codidepartamento = plmt0100.coddep
		
		IF NOT PLMT0100.POSTERIOR THEN
			REPLACE POSTERIOR WITH .T.
			encontradaconmismocodigo = .F.
			
			DO WHILE contaperiodo <= W_PERMAX AND NOT encontradaconmismocodigo 
				nreg1 = GUARDANUMEROREGISTRO()
				LOCATE FOR ALLTRIM(UPPER(coddep)) == ALLTRIM(UPPER(codidepartamento)) AND periodo = contaperiodo AND empresa = nCodigo
				encontradaconmismocodigo = FOUND()
				RECUPERANUMEROREGISTRO(nreg1)						
					
				IF NOT encontradaconmismocodigo THEN
					SCATTER MEMVAR
					M.posterior = (contaperiodo <> W_PERMAX) 
					M.periodo = contaperiodo
					INSERT INTO PLMT0100 FROM MEMVAR
					contaperiodo = contaperiodo+1
				ENDIF
			ENDDO
		ENDIF
		GO nregist
		SKIP
		IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND periodo = periodoactual REST
		ENDIF
	ENDDO 
	SET FILTER TO &filtro
	SELE PLMT0100
	USE
ENDPROC

PROCEDURE PROPAGA_CARGOS
	LOCAL filtro, periodoactual, contaperiodo, nregist

	periodoactual = W_PERIODO
	IF NOT USED('PLMT0200') THEN
		USE PLMT0200 IN 0 ALIAS PLMT0200 EXCLUSIVE
	ENDIF
	SELECT PLMT0200
	filtro = FILTER()
	SET FILTER TO
	LOCATE FOR empresa = nCodigo AND periodo = periodoactual
	DO WHILE NOT EOF()
		nregist = RECNO()
		codocupacion = plmt0200.codocup
		contaperiodo = periodoactual+1
		
		IF NOT PLMT0200.POSTERIOR THEN
			REPLACE POSTERIOR WITH .T.
			encontradaconmismocodigo = .F.
			
			DO WHILE contaperiodo <= W_PERMAX AND NOT encontradaconmismocodigo
				nreg1 = GUARDANUMEROREGISTRO()
				LOCATE FOR codocupacion = plmt0200.codocup AND periodo = contaperiodo AND empresa = nCodigo
				encontradaconmismocodigo = FOUND()
				RECUPERANUMEROREGISTRO(nreg1)						
					
				IF NOT encontradaconmismocodigo THEN
					SCATTER MEMVAR
					M.posterior = (contaperiodo <> W_PERMAX) 
					M.periodo = contaperiodo
					INSERT INTO PLMT0200 FROM MEMVAR
					contaperiodo = contaperiodo+1
				ENDIF
			ENDDO
			
		ENDIF
		GO nregist
		SKIP
		IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND periodo = periodoactual REST
		ENDIF
	ENDDO 
	SET FILTER TO &filtro
	SELE PLMT0200
	USE
ENDPROC


PROCEDURE PROPAGA_INSTITUCIONES
	LOCAL filtro, periodoactual, contaperiodo, nregist

	periodoactual = W_PERIODO
	IF NOT USED('PLMT0300') THEN
		USE PLMT0300 IN 0 ALIAS PLMT0300 EXCLUSIVE
	ENDIF
	SELECT PLMT0300
	filtro = FILTER()
	SET FILTER TO
	LOCATE FOR empresa = nCodigo AND periodo = periodoactual
	DO WHILE NOT EOF()
		nregist = RECNO()
		codinstitucion  = plmt0300.codins
		contaperiodo = periodoactual+1
		IF NOT PLMT0300.POSTERIOR THEN
			REPLACE POSTERIOR WITH .T.
			encontradaconmismocodigo = .F.
			DO WHILE contaperiodo <= W_PERMAX AND NOT encontradaconmismocodigo
				nreg1 = GUARDANUMEROREGISTRO()
				LOCATE FOR ALLTRIM(UPPER(codins)) == ALLTRIM(UPPER(codinstitucion)) AND periodo = contaperiodo AND empresa = nCodigo
				encontradaconmismocodigo = FOUND()
				RECUPERANUMEROREGISTRO(nreg1)						
					
				IF NOT encontradaconmismocodigo THEN
					SCATTER MEMVAR
					M.posterior = (contaperiodo <> W_PERMAX) 
					M.periodo = contaperiodo
					INSERT INTO PLMT0300 FROM MEMVAR
					contaperiodo = contaperiodo+1
				ENDIF
			ENDDO
		ENDIF
		GO nregist
		SKIP
		IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND periodo = periodoactual REST
		ENDIF
	ENDDO 
	SET FILTER TO &filtro
	SELE PLMT0300
	USE
ENDPROC

PROCEDURE PROPAGA_AFPS
	LOCAL filtro, periodoactual, contaperiodo, nregist

	periodoactual = W_PERIODO
	IF NOT USED('PLMT0400') THEN
		USE PLMT0400 IN 0 ALIAS PLMT0400 EXCLUSIVE
	ENDIF
	SELECT PLMT0400
	filtro = FILTER()
	SET FILTER TO
	LOCATE FOR empresa = nCodigo AND periodo = periodoactual
	DO WHILE NOT EOF()
		nregist = RECNO()
		codigoafp = plmt0400.codafp
		contaperiodo = periodoactual+1
		IF NOT PLMT0400.POSTERIOR THEN
			REPLACE POSTERIOR WITH .T.
			encontradaconmismocodigo = .F.
			
			DO WHILE contaperiodo <= W_PERMAX AND NOT encontradaconmismocodigo
				nreg1 = GUARDANUMEROREGISTRO()
				LOCATE FOR codafp = codigoafp AND periodo = contaperiodo AND empresa = nCodigo
				encontradaconmismocodigo = FOUND()
				RECUPERANUMEROREGISTRO(nreg1)						
					
				IF NOT encontradaconmismocodigo THEN
					SCATTER MEMVAR
					M.posterior = (contaperiodo <> W_PERMAX) 
					M.periodo = contaperiodo
					INSERT INTO PLMT0400 FROM MEMVAR
					contaperiodo = contaperiodo+1
				ENDIF
			ENDDO
		ENDIF
		GO nregist
		SKIP
		IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND periodo = periodoactual REST
		ENDIF
	ENDDO 
	SET FILTER TO &filtro
	SELE PLMT0400
	USE
ENDPROC

PROCEDURE PROPAGA_EMPLEADOS
	LOCAL filtro, periodoactual, contaperiodo, nregist

	periodoactual = W_PERIODO
	IF NOT USED('PLMT0500') THEN
		USE PLMT0500 IN 0 ALIAS PLMT0500 EXCLUSIVE
	ENDIF
	SELECT PLMT0500
	filtro = FILTER()
	SET FILTER TO
	LOCATE FOR empresa = nCodigo AND periodo = periodoactual
	DO WHILE NOT EOF()
		nregist = RECNO()
		codigoempleado = plmt0500.codemp
		contaperiodo = periodoactual+1
		IF NOT PLMT0500.POSTERIOR THEN
			REPLACE POSTERIOR WITH .T.
			encontradaconmismocodigo = .F.
			DO WHILE contaperiodo <= W_PERMAX AND NOT encontradaconmismocodigo 
				nreg1 = GUARDANUMEROREGISTRO()
				LOCATE FOR ALLTRIM(UPPER(codemp)) == ALLTRIM(UPPER(codigoempleado)) AND periodo = contaperiodo AND empresa = nCodigo
				encontradaconmismocodigo = FOUND()
				RECUPERANUMEROREGISTRO(nreg1)						
					
				IF NOT encontradaconmismocodigo THEN
					SCATTER MEMVAR
					M.posterior = (contaperiodo <> W_PERMAX) 
					M.periodo = contaperiodo
					INSERT INTO PLMT0500 FROM MEMVAR
					contaperiodo = contaperiodo+1
				ENDIF
			ENDDO
		ENDIF
		GO nregist
		SKIP
		IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND periodo = periodoactual REST
		ENDIF
	ENDDO 
	SET FILTER TO &filtro
	SELE PLMT0500
	USE
ENDPROC

PROCEDURE PROPAGA_DESCUENTOS
	LOCAL filtro, periodoactual, contaperiodo, nregist, usadatablaperiodo, regtablaperiodo
	
	periodoactual = W_PERIODO

	IF USED('PLUT0610') THEN
		usadatablaperiodo = .T.
		SELE PLUT0610
		regtablaperiodo = GUARDANUMEROREGISTRO()
	ELSE
		usadatablaperiodo = .F.
		USE PLUT0610 IN 0 ALIAS PLUT0610 
	ENDIF
	
	IF NOT USED('PLMT0600') THEN
		USE PLMT0600 IN 0 ALIAS PLMT0600 EXCLUSIVE
	ENDIF
	SELECT PLMT0600
	filtro = FILTER()
	SET FILTER TO
	LOCATE FOR empresa = nCodigo AND periodo = periodoactual
	DO WHILE NOT EOF()
		nregist = RECNO()
		contaperiodo = periodoactual+1
		IF NOT PLMT0600.POSTERIOR THEN
			REPLACE POSTERIOR WITH .T.
			codigoempleado = plmt0600.codemp
			codigoinstitucion = plmt0600.codins
			encontradaconmismocodigo = .F.
			DO WHILE contaperiodo <= W_PERMAX AND NOT encontradaconmismocodigo
				nreg1 = GUARDANUMEROREGISTRO()
				LOCATE FOR ALLTRIM(UPPER(codemp)) == ALLTRIM(UPPER(codigoempleado)) AND ALLTRIM(UPPER(codins)) == ALLTRIM(UPPER(codigoinstitucion)) AND contaperiodo = periodo AND empresa = nCodigo
				encontradaconmismocodigo = FOUND()
				RECUPERANUMEROREGISTRO(nreg1)						
					
				IF NOT encontradaconmismocodigo THEN
					SELE PLUT0610
					LOCATE FOR periodo = contaperiodo AND empresa = nCodigo
					SELE PLMT0600	
					SCATTER MEMVAR
					IF m.fecfin >= plut0610.desde THEN
						M.posterior = (contaperiodo <> W_PERMAX) 
						M.periodo = contaperiodo
						INSERT INTO PLMT0600 FROM MEMVAR
					ENDIF
					contaperiodo = contaperiodo+1
				ENDIF
			ENDDO
		ENDIF
		GO nregist
		SKIP
		IF NOT EOF() THEN
			LOCATE FOR empresa = nCodigo AND periodo = periodoactual REST
		ENDIF
	ENDDO 
	SET FILTER TO &filtro
	SELE PLMT0600
	USE
	IF usadatablaperiodo THEN
		SELE PLUT0610
		IF TYPE('regtablaperiodo') = 'N' THEN
			RECUPERANUMEROREGISTRO(regtablaperiodo)
		ENDIF
	ELSE
		SELE PLUT0610
		USE
	ENDIF
ENDPROC

PROCEDURE CREA_DEPARTAMENTOS_NUEVO_PERIODO(PERIODONUEVO)
	* Nos colocamos en el ltimo periodo existente
	W_PERIODO = W_PERMAX
	* Hacemos que el periodo mximo sea el posterior al ltimo existente
	W_PERMAX = PERIODONUEVO
	* Propagamos 
	DO PROPAGA_DEPARTAMENTOS
ENDPROC

PROCEDURE CREA_DEPARTAMENTOS_NUEVO_PERIODO(PERIODONUEVO)
	* Nos colocamos en el ltimo periodo existente
	W_PERIODO = W_PERMAX
	* Hacemos que el periodo mximo sea el posterior al ltimo existente
	W_PERMAX = PERIODONUEVO
	* Propagamos 
	DO PROPAGA_DEPARTAMENTOS
ENDPROC

PROCEDURE CREA_CARGOS_NUEVO_PERIODO(PERIODONUEVO)
	* Nos colocamos en el ltimo periodo existente
	W_PERIODO = W_PERMAX
	* Hacemos que el periodo mximo sea el posterior al ltimo existente
	W_PERMAX = PERIODONUEVO
	* Propagamos 
	DO PROPAGA_CARGOS
ENDPROC

PROCEDURE CREA_INSTITUCIONES_NUEVO_PERIODO(PERIODONUEVO)
	* Nos colocamos en el ltimo periodo existente
	W_PERIODO = W_PERMAX
	* Hacemos que el periodo mximo sea el posterior al ltimo existente
	W_PERMAX = PERIODONUEVO
	* Propagamos 
	DO PROPAGA_INSTITUCIONES
ENDPROC

PROCEDURE CREA_AFPS_NUEVO_PERIODO(PERIODONUEVO)
	* Nos colocamos en el ltimo periodo existente
	W_PERIODO = W_PERMAX
	* Hacemos que el periodo mximo sea el posterior al ltimo existente
	W_PERMAX = PERIODONUEVO
	* Propagamos 
	DO PROPAGA_AFPS
ENDPROC

PROCEDURE CREA_EMPLEADOS_NUEVO_PERIODO(PERIODONUEVO)
	* Nos colocamos en el ltimo periodo existente
	W_PERIODO = W_PERMAX
	* Hacemos que el periodo mximo sea el posterior al ltimo existente
	W_PERMAX = PERIODONUEVO
	* Propagamos 
	DO PROPAGA_EMPLEADOS
ENDPROC

PROCEDURE CREA_DESCUENTOS_NUEVO_PERIODO(PERIODONUEVO)
	* Nos colocamos en el ltimo periodo existente
	W_PERIODO = W_PERMAX
	* Hacemos que el periodo mximo sea el posterior al ltimo existente
	W_PERMAX = PERIODONUEVO
	* Propagamos 
	DO PROPAGA_DESCUENTOS
ENDPROC


*****************************************************************************
*                        MULTIPLANILLA			                            *
*                                                                           *
*****************************************************************************

PROCEDURE CREA_TABLA_PLMV0200_MULTIPLANILLA(tdestino, perini, perfin)
	*Crea la tabla plmv0200 para varios periodos comprendidos entre perini y perfin (incluidos)
	* El resultado lo almacena en tdestino
	LOCAL sumacampos
	IF TYPE('nCodigo') <> 'N' THEN
		PUBLIC  nCodigo
		USE (cDirectorio + "CONFIG\OPCIONES") IN 0
		RESTORE FROM MEMO opciones.codigo ADDITIVE
		USE IN Opciones
	ENDIF
	mntl = "sueldo, salhora, valinca, vextnor, vextnoc, vjornada, varios, otroing, vacaciones, totdev,"
	mntl = mntl +"retanti, retinst, retotros, retisss, pension, retafp1, retafp2, retafpt, retrenta, ppafpsa, ppisspe, totdes, salliq, viaticos, transporte"
	
	TRADUCETABLAMONEDAGAMMA('plmv0200','wplmv0200',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, 'fecpag', mntl, 'BETWEEN(periodo,'+ STR(perini) + ','+ STR(perfin)+') AND empresa = '+ STR(nCodigo))
	
	sumacampos = "sueldo, salhora, diaslab, diasinc, valinca, hextnor, hextnoc, vextnor, vextnoc,"
	sumacampos = sumacampos + "vjornada, jornada, varios, otroing, vacaciones, totdev, retanti,"
	sumacampos = sumacampos + "retinst, retotros, retiss, pension, retafp1, retafp2, retafpt,"
	sumacampos = sumacampos+"retrenta, retisss, ppafpsa, ppisspe, totdes, salliq, viaticos, transporte"	

	DO CREATABLASUMAGRUPOS IN CILIB001 WITH dirtemp+'WPLMV0200',tdestino,sumacampos, 'empresa = '+STR(nCodigo)+' AND periodo BETWEEN '+ALLTRIM(STR(perini))+' AND '+ALLTRIM(STR(perfin)),'codemp', 'coddep, codemp'
ENDPROC


*****************************************************************************
*                        CALCULOS PLANILLA		                            *
*                                                                           *
*****************************************************************************


PROCEDURE Formulario_normal (formul)
		formul.cmdtop.Enabled = .T.
		formul.cmdprev.Enabled = .T.
		formul.cmdnext.Enabled = .T.
		formul.cmdend.Enabled = .T.
		formul.cmdfind.Enabled = .T.
		formul.cmdprint.Enabled = .T.
		formul.cmdadd.Enabled = .T.
		formul.cmdedit.Enabled = .T.
		formul.cmddelete.Enabled = .T.
		formul.cmdexit.Enabled = .T.
		formul.cmdbusca.Enabled = .T.

		formul.txtDiaslab.DisabledBackColor = RGB(255,255,255)
		formul.txtJornada.DisabledBackColor = RGB(255,255,255)
		formul.txtVjornada.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtHextnor.DisabledBackColor = RGB(255,255,255)
		formul.txtVextnor.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtHextnoc.DisabledBackColor = RGB(255,255,255)
		formul.txtVextnoc.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtOtroing.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtVarios.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtDiasInc.DisabledBackColor = RGB(255,255,255)
		formul.txtValinca.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtViaticos.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtTransporte.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtTotdev.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtRetanti.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtRetinst.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtRetotros.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtRetisss.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtRetafpt.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtRetrenta.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtTotdes.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
		formul.txtSalliq.txtMonedaVisible.DisabledBackColor = RGB(255,255,255)
	
		formul.txtDiaslab.Enabled = .T.
		formul.txtJornada.Enabled = .T.
		formul.txtVjornada.txtMonedavisible.Enabled = .T.
		formul.txtHextnor.Enabled = .T.
		formul.txtVextnor.txtMonedavisible.Enabled = .T.
		formul.txtHextnoc.Enabled = .T.
		formul.txtVextnoc.txtMonedavisible.Enabled = .T.
		formul.txtOtroing.txtMonedavisible.Enabled = .T.
		formul.txtVarios.txtMonedavisible.Enabled = .T.
		formul.txtDiasInc.Enabled = .T.
		formul.Optiongroup1.Enabled = .T.
		formul.txtValinca.txtMonedavisible.Enabled = .T.
		formul.txtViaticos.txtMonedavisible.Enabled = .T.
		formul.txtTransporte.txtMonedavisible.Enabled = .T.
		formul.txtTotdev.txtMonedavisible.Enabled = .T.
		formul.txtRetanti.txtMonedavisible.Enabled = .T.
		formul.txtRetinst.txtMonedavisible.Enabled = .T.
		formul.txtRetotros.txtMonedavisible.Enabled = .T.
		formul.txtRetisss.txtMonedavisible.Enabled = .T.
		formul.txtRetafpt.txtMonedavisible.Enabled = .T.
		formul.txtRetrenta.txtMonedavisible.Enabled = .T.
		formul.txtTotdes.txtMonedavisible.Enabled = .T.
		formul.txtSalliq.txtMonedavisible.Enabled = .T.
		
		formul.REFRESH
		formul.REFRESH
ENDPROC

PROCEDURE busca_empleado (codigoempl, formulario)
	IF EMPTY(ALLTRIM(formulario.CODEMP1.Value)) THEN
		MESSAGEBOX("Debe introducir un cdigo de empleado", 48, "MILLENNIUM CONSULTING")
	ELSE
		LOCATE FOR codemp = codigoempl AND empresa = nCodigo AND periodo = W_PERIODO
		IF FOUND() THEN
			SCATTER MEMVAR
			STORE PLMT0500.CODEMP TO M.CODEMP1
			STORE PLMT0500.APEEMP TO M.txtApeemp
			STORE PLMT0500.NOMEMP TO M.txtNomemp
			STORE PLMT0500.NUMCTA TO M.txtNumcta
			DO formulario_normal WITH formulario		
			STORE .F. TO M.BUSCA
			formulario.cmdEdit.Picture = cDirectorio + "ICONOS\WZEDIT.BMP"
			REFRESCA_BOTONES(_VFP.ActiveForm)
		ELSE
			MESSAGEBOX("El empleado cuyo cdigo introdujo no se encuentra", 48, "MILLENNIUM CONSULTING")
		ENDIF
	ENDIF
ENDPROC

PROCEDURE descuentos
	SET PROC TO CILIB001 ADDITIVE
	m.salneto = 0.00
	
	m.vextnor= CONVIERTEMONEDAENBASE(hextnor * (sueldohorario*2), tipocambioactual) &&ROUND(
	m.vextnoc= CONVIERTEMONEDAENBASE(hextnoc * (sueldohorario*2*1.25), tipocambioactual) &&ROUND(
	m.valinca = CONVIERTEMONEDAENBASE(valincaactua(), tipocambioactual) &&ROUND(
	
	m.totdevgravado = vjornada + m.vextnor + m.vextnoc + m.valinca + otroing + varios
	m.totdev = m.totdevgravado + viaticos + transporte

	IF !EMPTY(codafp) THEN
		SELE plmt0400
		LOCATE FOR codafp = plmv0200.codafp AND empresa = nCodigo AND periodo = W_PERIODO
		IF FOUND() THEN
			SELE plmv0200
			IF MAYOROIGUALMONEDA((m.totdevgravado/diaslab)* 30, XPLPARAMETROMAXIMOISSS) THEN
				m.retisss = (diaslab * (XPLPARAMETROMAXIMOISSS/30)) * (plmt0400.cotisss/100) 
			ELSE
				m.retisss = M.totdevgravado * (plmt0400.cotisss/100) &&0.03
			ENDIF
		ELSE
			WAIT WINDOW "Error. El empleado de cdigo "+ALLTRIM(plmt0500.codemp)+" est afiliado a una AFP que no est definida."
			m.retisss = 0 
		ENDIF
		SELE plmt0500
	ELSE
		m.retisss = 0 
	ENDIF

	IF !EMPTY(codafp) THEN
		SELE plmt0400
		LOCATE FOR codafp = plmv0200.codafp AND empresa = nCodigo AND periodo = W_PERIODO
		IF FOUND() THEN
			AFPExiste = .T.
			AFPEsISSS = (ALLTRIM(nomafp)="ISSS")
		ELSE
			AFPExiste = .F.
			AFPEsISSS = .F.
		ENDIF
	ELSE
		AFPExiste = .F.
		AFPEsISSS = .F.
	ENDIF
	
	IF AFPExiste
		STORE plmt0400.cottrab TO w_cottrab
		STORE plmt0400.comtrab TO w_comtrab
		m.retafp1 = (w_cottrab * M.totdevgravado) / 100
		m.retafp2 = (w_comtrab * M.totdevgravado) / 100
		m.retafpt = m.retafp1 + m.retafp2 && ROUND(
		m.ppafpsa = M.totdevgravado * 0.05
		STORE 0.00 TO M.pension, M.ppisspe
		SELE plmv0200
	ELSE
		SELE plmv0200
		m.retafp1 = 0.00 
		m.retafp2 = 0.00 
		m.retafpt = 0.00 
		M.ppafpsa = 0.00
		m.pension = M.totdevgravado * 0.045
		m.ppisspe = M.totdevgravado * 0.075
	ENDIF
	
	m.retisss = M.retisss + M.pension &&ROUND((

	** CALCULO DEL IMPUESTO SOBRE LA RENTA

	devrenta = M.totdevgravado - M.retafpt

	m.retrenta = CALCULARETENCIONRENTA(devrenta)

	m.totdes = retinst + M.retafpt + M.retisss + M.retrenta + retotros + retanti && ROUND((
	m.salliq = M.totdev - M.totdes &&ROUND((
	
	RETURN
ENDPROC

FUNCTION valorincapacidad
VALORINCA = 0
IF (m.diasinc > 0) AND ((m.tipoinc =1) OR (m.tipoinc=2)) THEN
	IF PLMT0500.TIPSAL=1 THEN &&Si el Salario es Mensual
  		IF m.tipoinc = 1
	  			VALORINCA = m.diasinc * (m.sueldo/30) * 0.25
  		ELSE 
		 		VALORINCA = (m.diasinc - 3) * (m.sueldo/30) * 0.25	
  		ENDIF
	ELSE
  		IF PLMT0500.TIPSAL=2  &&Si el Salario es Quincenal
     		IF m.tipoinc=1
	    		VALORINCA = m.diasinc * (m.sueldo/15) * 0.25     		
	    	ELSE
	  			VALORINCA = (m.diasinc - 3) * (m.sueldo/15) * 0.25
	    	ENDIF
  		ELSE
    		IF PLMT0500.TIPSAL=3 &&Si el Salario es Diario
       			IF m.tipoinc=1 
	      			VALORINCA = m.diasinc * m.sueldo * 0.25
       			ELSE
	    	    	VALORINCA = (m.diasinc -3) * m.sueldo * 0.25
	      		ENDIF
    		ENDIF
		ENDIF
	ENDIF
ENDIF
RETURN VALORINCA
ENDFUNC

FUNCTION valincaactua
VALORINCA = 0
IF (diasinc > 0) AND ((tipoinc =1) OR (tipoinc=2)) THEN
	IF plmt0500.TIPSAL=1 THEN&&Si el Salario es Mensual
  		IF tipoinc = 1
	  			VALORINCA = diasinc * (plmv0200.sueldo/30) * 0.25
  		ELSE 
		 		VALORINCA = (diasinc - 3) * (plmv0200.sueldo/30) * 0.25	
  		ENDIF
	ELSE
  		IF plmt0500.TIPSAL=2  &&Si el Salario es Quincenal
     		IF tipoinc=1
	    		VALORINCA = diasinc * (plmv0200.sueldo/15) * 0.25     		
	    	ELSE
	  			VALORINCA = (diasinc - 3) * (plmv0200.sueldo/15) * 0.25
	    	ENDIF
  		ELSE
    		IF plmt0500.TIPSAL=3 &&Si el Salario es Diario
       			IF tipoinc=1 
	      			VALORINCA = diasinc * plmv0200.sueldo * 0.25
       			ELSE
	    	    	VALORINCA = (diasinc -3) * plmv0200.sueldo * 0.25
	      		ENDIF
    		ENDIF
		ENDIF
	ENDIF
ENDIF
RETURN VALORINCA
ENDFUNC

PROCEDURE actualizaregistro 
	SET PROC TO CILIB001 ADDITIVE
	LOCAL m.totdevgravado
	
	m.vjornada = m.jornada * m.salhora &&ROUND(
	m.vextnor= m.hextnor * (m.salhora*2) &&ROUND(
	m.vextnoc= m.hextnoc * (m.salhora*2*1.25) &&ROUND(
	m.valinca = valorincapacidad() && ROUND(
	
	m.totdevgravado = m.vjornada + m.vextnor + m.vextnoc + m.valinca + m.otroing + m.varios
	m.totdev = m.totdevgravado + m.viaticos + m.transporte

	IF !EMPTY(codafp) THEN
		SELE plmt0400
		LOCATE FOR codafp = plmv0200.codafp AND empresa = nCodigo AND periodo = W_PERIODO
		IF FOUND() THEN
			IF MAYOROIGUALMONEDA(CONVIERTEMONEDAENBASE((m.totdevgravado/m.diaslab)* 30, m.tipocambio), XPLPARAMETROMAXIMOISSS) THEN
				m.retisss = (m.diaslab * (XPLPARAMETROMAXIMOISSS/30)) * (plmt0400.cotisss/100) 
			ELSE
				m.retisss = M.totdevgravado * (plmt0400.cotisss/100) 
			ENDIF
		ELSE
			m.retisss = 0 
		ENDIF
		SELE plmv0200
	ELSE
		m.retisss = 0 
	ENDIF
		
	IF !EMPTY(m.codafp) THEN
		SELE plmt0400
		LOCATE FOR codafp = plmv0200.codafp AND empresa = nCodigo AND periodo = W_PERIODO
		IF FOUND() THEN
			AFPExiste = .T.
			AFPEsISSS = (ALLTRIM(nomafp)="ISSS")
		ELSE
			AFPExiste = .F.
			AFPEsISSS = .F.
		ENDIF
	ELSE
		AFPExiste = .F.
		AFPEsISSS = .F.
	ENDIF
			
	IF AFPExiste THEN
		
		STORE plmt0400.cottrab TO w_cottrab
		STORE plmt0400.comtrab TO w_comtrab
		m.retafp1 = (w_cottrab * m.totdevgravado) / 100
		m.retafp2 = (w_comtrab * m.totdevgravado) / 100
		m.retafpt = m.retafp1 + m.retafp2 &&ROUND(
		m.ppafpsa = m.totdevgravado * 0.05
		m.pension = 0.00
		m.ppisspe = 0.00
		STORE 0.00 TO m.pension
		SELE plmv0200
	ELSE
		*SELE plmv0200
		m.pension = M.totdevgravado * 0.045 
		m.ppisspe = M.totdevgravado * 0.075
		m.retafpt = 0.00
		m.ppafpsa = 0.00
	ENDIF
	m.retisss = M.retisss + m.pension &&ROUND((

	devrenta = M.totdevgravado - M.retafpt

	** CALCULO DEL IMPUESTO SOBRE LA RENTA
	
		
	m.retrenta = CALCULARETENCIONRENTA(devrenta)

	m.totdes = m.retinst + M.retafpt + M.retisss + M.retrenta + m.retotros + m.retanti && ROUND
	m.salliq = M.totdev - M.totdes &&ROUND((
ENDPROC

*****************************************************************************
*                        MULTIMONEDA PLANILLA		                        *
*                                                                           *
*****************************************************************************
PROCEDURE CREAMATRIZCOTIZAPLANILLA()
	DIMENSION BASURA(1)
	IF TYPE('W_COTIZAPLANILLA') <> 'U' THEN
		RELEASE W_COTIZAPLANILLA
	ENDIF 
	PUBLIC ARRAY W_COTIZAPLANILLA(1)
	CREARMATRICESMONEDA ('', W_DESDE, W_HASTA, @basura, @W_COTIZAPLANILLA)
ENDPROC

FUNCTION REVISAGENERAPLANILLA (fechacambio, periodo, lamatriz)
	nodef500 = MONEDASTABLANODEFINIDAS('plmt0500', periodo, @lamatriz)
	mensaje = ''
	IF NOT EMPTY(nodef500) THEN
		mensaje = 'El sueldo de algunos empleados se ha definido en la(s) moneda(s) siguientes: '+nodef500+ '. Como no hay cotizacin para esta(s) moneda(s) en '+ DTOC(fechacambio) +', no se puede generar la planilla. Defina la cotizacin en el formulario de Monedas, o bien, cambie la fecha de tipo de cambio.'
	ELSE
		nodef600 = MONEDASTABLANODEFINIDAS('plmt0600', periodo, @lamatriz)
		IF NOT EMPTY(nodef600) THEN
			mensaje = 'El valor de algunas retenciones se ha definido en la(s) moneda(s) siguientes: '+nodef500+ '. Como no hay cotizacin para esta(s) moneda(s) en '+ DTOC(fechacambio) +', no se puede generar la planilla. Defina la cotizacin en el formulario de Monedas, o bien, cambie la fecha de tipo de cambio.'
		ENDIF
	ENDIF
	RETURN mensaje
ENDFUNC

PROCEDURE DESTRUYEPARAMETROSPLANILLA()
	RELEASE XPLPARAMETRODESDETRAMO, XPLPARAMETROSUBSTRAETRAMO, XPLPARAMETROFIJOTRAMO, XPLPARAMETROPORCENTAJETRAMO
	RELEASE XPLPARAMETROMAXIMOISSS, XPLPARAMETRONUMTRAMOSRENTA
ENDPROC

PROCEDURE CREAPARAMETROSPLANILLA()
	PUBLIC ARRAY XPLPARAMETRODESDETRAMO(5), XPLPARAMETROSUBSTRAETRAMO(5), XPLPARAMETROFIJOTRAMO(5), XPLPARAMETROPORCENTAJETRAMO(5)
	PUBLIC XPLPARAMETROMAXIMOISSS, XPLPARAMETRONUMTRAMOSRENTA

	XPLTIPOCAMBIOMONEDAPARAMETROS = LEEVARNUMDEFECTO('XPLTIPOCAMBIOMONEDAPARAMETROS',1)	
	XPLPARAMETROMAXIMOISSS = LEEVARNUMDEFECTO('XPLPARAMETROMAXIMOISSS',6000.00)	
	XPLPARAMETROMAXIMOISSS = XPLPARAMETROMAXIMOISSS / XPLTIPOCAMBIOMONEDAPARAMETROS
	
	** Introduce los valores predeterminados
		
	XPLPARAMETRODESDETRAMO(1) = 0.00
	XPLPARAMETRODESDETRAMO(2) = 1385.42
	XPLPARAMETRODESDETRAMO(3) = 2052.09
	XPLPARAMETRODESDETRAMO(4) = 3333.34
	XPLPARAMETRODESDETRAMO(5) = 8333.01
	
	XPLPARAMETROSUBSTRAETRAMO(1) = 0.00
	XPLPARAMETROSUBSTRAETRAMO(2) = 1385.42
	XPLPARAMETROSUBSTRAETRAMO(3) = 1000
	XPLPARAMETROSUBSTRAETRAMO(4) = 3333.33
	XPLPARAMETROSUBSTRAETRAMO(5) = 8333.00
	
	XPLPARAMETROFIJOTRAMO(1) = 0.00
	XPLPARAMETROFIJOTRAMO(2) = 20.85
	XPLPARAMETROFIJOTRAMO(3) = 20.85
	XPLPARAMETROFIJOTRAMO(4) = 262.50
	XPLPARAMETROFIJOTRAMO(5) = 1000

	XPLPARAMETROPORCENTAJETRAMO(1) = 0.00
	XPLPARAMETROPORCENTAJETRAMO(2) = 0.1
	XPLPARAMETROPORCENTAJETRAMO(3) = 0.1
	XPLPARAMETROPORCENTAJETRAMO(4) = 0.2
	XPLPARAMETROPORCENTAJETRAMO(5) = 0.3

	** Si hay alguna variable con el valor del parmetro, la fija
	
	XPLPARAMETRONUMTRAMOSRENTA = LEEVARNUMDEFECTO('XPLPARAMETRONUMTRAMOSRENTA',5)	
	
	FOR im = 1 TO XPLPARAMETRONUMTRAMOSRENTA
		IF im > 5 THEN
			DIMENSION XPLPARAMETRODESDETRAMO(im), XPLPARAMETROSUBSTRAETRAMO(im), XPLPARAMETROFIJOTRAMO(im), XPLPARAMETROPORCENTAJETRAMO(im)
		ENDIF
		IF DEFINIDAVAR('XPLPARAMETRODESDETRAMO'+ALLTRIM(STR(im))) THEN
			XPLPARAMETRODESDETRAMO(im) = LEEVARNUM('XPLPARAMETRODESDETRAMO'+ALLTRIM(STR(im)))
		ENDIF
		IF DEFINIDAVAR('XPLPARAMETROSUBSTRAETRAMO'+ALLTRIM(STR(im))) THEN
			XPLPARAMETROSUBSTRAETRAMO(im) = LEEVARNUM('XPLPARAMETROSUBSTRAETRAMO'+ALLTRIM(STR(im)))
		ENDIF
		IF DEFINIDAVAR('XPLPARAMETROFIJOTRAMO'+ALLTRIM(STR(im))) THEN
			XPLPARAMETROFIJOTRAMO(im) = LEEVARNUM('XPLPARAMETROFIJOTRAMO'+ALLTRIM(STR(im)))
		ENDIF
		IF DEFINIDAVAR('XPLPARAMETROPORCENTAJETRAMO'+ALLTRIM(STR(im))) THEN
			XPLPARAMETROPORCENTAJETRAMO(im) = LEEVARNUM('XPLPARAMETROPORCENTAJETRAMO'+ALLTRIM(STR(im)))
		ENDIF
	ENDFOR
	
	
	FOR im = 1 TO XPLPARAMETRONUMTRAMOSRENTA
		XPLPARAMETRODESDETRAMO(im) = XPLPARAMETRODESDETRAMO(im) / XPLTIPOCAMBIOMONEDAPARAMETROS
		XPLPARAMETROSUBSTRAETRAMO(im) = XPLPARAMETROSUBSTRAETRAMO(im) / XPLTIPOCAMBIOMONEDAPARAMETROS
		XPLPARAMETROFIJOTRAMO(im) = XPLPARAMETROFIJOTRAMO(im) / XPLTIPOCAMBIOMONEDAPARAMETROS
	ENDFOR
	
	
ENDPROC


FUNCTION CALCULARETENCIONRENTA(drenta)
	LOCAL tramo, resultado
	tramo = 1 
	DO WHILE tramo < XPLPARAMETRONUMTRAMOSRENTA AND (MENORMONEDA(drenta,XPLPARAMETRODESDETRAMO(tramo)) OR MAYOROIGUALMONEDA(drenta,XPLPARAMETRODESDETRAMO(tramo+1)))
		tramo = tramo +1	
	ENDDO
	
	IF tramo = XPLPARAMETRONUMTRAMOSRENTA AND MENORMONEDA(drenta,XPLPARAMETRODESDETRAMO(tramo)) THEN
		MESSAGEBOX("Error. Tramos de la renta mal definidos o tipo de cambio negativo")
	ENDIF
		
	resultado = ROUND(((drenta - XPLPARAMETROSUBSTRAETRAMO(tramo))* XPLPARAMETROPORCENTAJETRAMO(tramo))+ XPLPARAMETROFIJOTRAMO(tramo),2)
	RETURN resultado
ENDFUNC



