*:*****************************************************************
*:	PROGRAMA	: PLMV0100.PRG
*:	FECHA		: AGOSTO DE 1999.
*:	FUNCION		: PROCESO DE INICIALIZACION DE PLANILLA.
*:  ANALISTA    : DR. VICENT-RAMON PALASI LALLANA
*:	APLICACION	: SISTEMA INTEGRADO DE INFORMACION.
*:******************************************************************
PARAMETERS NUEVAPLANILLA


IF TYPE('W_COTIZAGENERAPLANILLA') <> 'U' THEN
	RELEASE W_COTIZAGENERAPLANILLA
ENDIF 

DIMENSION W_COTIZAGENERAPLANILLA(1)


SET PROC TO PLLIB001 ADDITIVE
SET PROC TO CILIB001 ADDITIVE
SET PROCEDURE TO config ADDITIVE

PUBLIC M.retisss, M.totdev, M.cottrab, M.comtrab, M.retafp1, M.retafp2
PUBLIC M.retafpt, M.ppafpsa, M.pension, M.ppisspe, M.salneto, M.retrenta
PUBLIC M.totdes, M.salliq, M.vjornada, M.vextnor, M.vextnoc, M.valinca  

CREAMATRIZCOTIZABETA(W_FECCAMBIO, @W_COTIZAGENERAPLANILLA)
mensaje = REVISAGENERAPLANILLA (W_FECCAMBIO, W_PERIODO, @W_COTIZAGENERAPLANILLA)

IF NOT EMPTY(mensaje) THEN
	MESSAGEBOX(mensaje, 48, "MILLENNIUM CONSULTING")
	RETURN 0 
ELSE	
	IF NUEVAPLANILLA THEN
		STORE 0.00 TO M.retisss, M.totdev, M.cottrab, M.comtrab, M.retafp1, M.retafp2
		STORE 0.00 TO M.retafpt, M.ppafpsa, M.pension, M.ppisspe, M.salneto, M.retrenta
		STORE 0.00 TO M.totdes, M.salliq, M.vjornada, M.vextnor, M.vextnoc, M.valinca  
	ENDIF

	IF NOT W_MULTIPLANILLA THEN
		SET EXCL ON
		USE plmv0200 
		IF NUEVAPLANILLA THEN
			ZAP
		ELSE
			PACK
		ENDIF
		USE
		SET EXCL OFF
	ENDIF

	

	USE (cdirectorio + "CONFIG\OPCIONES") IN 0
	RESTORE FROM MEMO opciones.codigo ADDITIVE
	USE IN opciones
	
	SET DEFA TO (dirraiz + "PLANILLA\")	
	calias = ALIAS()

	*USE IN 0 plmv0200 ORDER TAG 1 ALIAS plmv0200
	*SELECT plmv0200
	*comando = "SET FILTER TO periodo = "+STR(W_PERIODO)+ " AND " + STR(ncodigo) + " = empresa"
	*&comando
	*LOCATE
	*comando = "COPY TO "+ dirtemp+"plmv0200.dbf FOR periodo = "+STR(W_PERIODO)+ " AND " + STR(ncodigo) + " = empresa WITH CDX"
	*&comando
	*USE
	
	USE IN 0 (dirraiz+"planilla\plmv0200.dbf") ORDER TAG 1 ALIAS plmv0200
	SELECT plmv0200
	comando = "SET FILTER TO periodo = "+STR(W_PERIODO)+ " AND " + STR(ncodigo) + " = empresa"
	&comando
	LOCATE


	IF NOT EMPTY(calias) THEN
		SELECT (calias)
	ENDIF
	RELEASE calias
			
	USE IN 0 plmt0400 ORDER TAG 1 ALIAS plmt0400
	calias = ALIAS()
	SELECT plmt0400

	comando = "SET FILTER TO periodo = "+STR(W_PERIODO)+ " AND " + STR(ncodigo) + " = empresa"
	&comando
	LOCATE
	
	IF NOT EMPTY(calias) THEN
		SELECT (calias)
	ENDIF
	RELEASE calias

	USE IN 0 plmt0600 ORDER TAG 1 ALIAS plmt0600
	calias = ALIAS()	
	SELECT plmt0600

	comando = "SET FILTER TO periodo = "+STR(W_PERIODO)+ " AND " + STR(ncodigo) + " = empresa"
	&comando
	LOCATE

	IF NOT EMPTY(calias) THEN
		SELECT (calias)
	ENDIF
	RELEASE calias
	
	USE IN 0 plmt0500 ORDER TAG 1 ALIAS plmt0500
	SELE plmt0500
	
	
	SCAN FOR periodo = W_PERIODO AND empresa = nCodigo AND ESTADO = 1
	
		tipocambioactual = CALCULATIPOCAMBIOMATRIZ (@W_COTIZAGENERAPLANILLA, plmt0500.cmoneda, W_FECCAMBIO) 
		
		SELE plmt0600
						
		SUM valdes FOR ALLTRIM(UPPER(codemp)) == ALLTRIM(UPPER(plmt0500.codemp)) AND fredes = 2 AND (fecfin >= W_HASTA OR EMPTY(fecfin)) AND periodo = W_PERIODO AND empresa = nCodigo TO descins1
		SUM valdes FOR ALLTRIM(UPPER(codemp)) == ALLTRIM(UPPER(plmt0500.codemp)) AND fredes = 1 AND (fecfin >= W_HASTA OR EMPTY(fecfin)) AND periodo = W_PERIODO AND empresa = nCodigo TO descins2
		
		m.retinst = descins1 + (descins2/2)
		SELE plmv0200
		WAIT WIND "Generando al Empleado: " + ALLT(plmt0500.apeemp)+" "+ALLT(plmt0500.nomemp) NOWAIT
		WAIT CLEAR
	
		IF NUEVAPLANILLA THEN
			nuevoregistro = .T.
		ELSE
			LOCATE FOR ALLTRIM(UPPER(codemp)) == ALLTRIM(UPPER(plmt0500.codemp)) AND empresa = nCodigo AND periodo = W_PERIODO
			nuevoregistro = (NOT FOUND())
		ENDIF
		
		IF nuevoregistro THEN
			APPEND BLANK	
			REPL NEXT 1 codemp	WITH plmt0500.codemp
			REPL NEXT 1 diaslab		WITH 15
			REPL NEXT 1	jornada		WITH 120.00
			REPL NEXT 1 periodo WITH W_PERIODO
		ELSE
			** No se hace nada pues ya estamos en el registro que queremos modificar
		ENDIF
		REPL NEXT 1 fecpag WITH W_FECCAMBIO
		REPL NEXT 1 cmoneda WITH plmt0500.cmoneda
		REPL NEXT 1 tipocambio WITH tipocambioactual
		REPL NEXT 1 coddep		WITH plmt0500.coddep
		REPL NEXT 1 codafp		WITH plmt0500.codafp
		REPL NEXT 1 tipsal		WITH plmt0500.tipsal
		
		DO CASE
			CASE plmt0500.tipsal = 1
				sueldodiario = (plmt0500.sueldo / 30)
				sueldohorario = (plmt0500.sueldo / 240)
			CASE plmt0500.tipsal = 2
				sueldodiario = (plmt0500.sueldo / 15)
				sueldohorario = (plmt0500.sueldo / 120)
			CASE plmt0500.tipsal = 3
				sueldodiario = 	plmt0500.sueldo
				sueldohorario =  plmt0500.sueldo / 8
		ENDCASE
	
		
		REPL NEXT 1 nuevo WITH .T.
		REPL NEXT 1 sueldo	WITH CONVIERTEMONEDAENBASE(sueldodiario,tipocambioactual)
		REPL NEXT 1 salhora WITH CONVIERTEMONEDAENBASE(sueldohorario,tipocambioactual)
		REPL NEXT 1 numcta		WITH plmt0500.numcta
		REPL NEXT 1 estado		WITH plmt0500.estado
		REPL NEXT 1 vjornada	WITH CONVIERTEMONEDAENBASE(jornada * sueldohorario, tipocambioactual) &&ROUND(
		REPL NEXT 1 retinst		WITH CONVIERTEMONEDAENBASE(m.retinst, tipocambioactual)
		
		DO descuentos IN pllib001.prg
		
		SELE plmv0200
		REPL NEXT 1 retisss		WITH M.retisss
		REPL NEXT 1 totdev		WITH M.totdev
		REPL NEXT 1 retafp1		WITH M.retafp1
		REPL NEXT 1 retafp2		WITH M.retafp2
		REPL NEXT 1 retafpt		WITH M.retafpt
		REPL NEXT 1 ppafpsa		WITH M.ppafpsa
		
		REPL NEXT 1 pension		WITH M.pension
		REPL NEXT 1 ppisspe		WITH M.ppisspe
		REPL NEXT 1 retrenta	WITH M.retrenta
		REPL NEXT 1 totdes		WITH M.totdes
		REPL NEXT 1 salliq		WITH M.salliq

		REPL NEXT 1 vextnor		WITH m.vextnor
		REPL NEXT 1 vextnoc		WITH m.vextnoc
		REPL NEXT 1 valinca		WITH m.valinca
		REPL NEXT 1 empresa     WITH nCodigo

		SELE plmt0500


		IF NUEVAPLANILLA THEN
			descins1 = 0.00
			descins2 = 0.00
			m.retinst = 0.00
			STORE 0.00 TO M.retisss, M.totdev, M.cottrab, M.comtrab, M.retafp1, M.retafp2
			STORE 0.00 TO M.retafpt, M.ppafpsa, M.pension, M.ppisspe, M.salneto, M.retrenta
			STORE 0.00 TO M.totdes, M.salliq, M.vextnor, M.vextnoc, M.valinca 
		ENDIF

	ENDSCAN

	SELE plMV0200
	WDELETEALL('NOT nuevo AND periodo = '+STR(W_PERIODO))
	WREPLACEALL('nuevo WITH .F.', 'periodo = '+STR(W_PERIODO))
	USE
	SELE PLMT0400
	USE
	SELE PLMT0600
	USE
	SELE PLMT0500
	USE
	
	*mnt = "sueldo, salhora, valinca, vextnor, vextnoc, vjornada, totdev, retinst, "
	*mnt = mnt + "retisss, pension, retafp1, retafp2, retafpt, retrenta, ppafpsa, ppisspe, totdes, salliq"
	
	*TRADUCETABLAMONEDABETA(dirtemp+'wxplmv0200','wplmv0200', @W_COTIZAGENERAPLANILLA, mnt, '')
	
	*USE plmv0200 IN 0 ALIAS plmv0200
	*SELE plmv0200
	*comando = "DELETE ALL FOR periodo = "+STR(W_PERIODO)+ " AND " + STR(ncodigo) + " = empresa"
	*&comando
	*APPEND FROM (dirtemp+"wplmv0200")
	*USE
	RETURN 1
ENDIF

