PARAMETER contotales
PUBLIC viaticos200

* Recupera el cdigo de la empresa
USE (cDirectorio + "CONFIG\OPCIONES") IN 0
RESTORE FROM MEMO opciones.codigo ADDITIVE
RESTORE FROM MEMO opciones.empresa ADDITIVE

* Borra los registros de la tabla temporal
OPEN DATABASE planilla
IF FILE(dirraiz+"PLANILLA\XCPLRP0100.DBF") THEN
	REMOVE TABLE XCPLRP0100 DELETE
ENDIF 
DO CREA_TABLA_EXCEL 
CLOSE DATABASE

* Abre las tablas

USE XCPLRP0100 IN 0 ALIAS XCPLRP0100
USE TEMPORAL IN 0 ALIAS PLMV0200 &&Se puso temporal para permitir el multiperiodo
USE PLMT0500 IN 0 ALIAS PLMT0500
USE PLMT0200 IN 0 ALIAS PLMT0200
USE PLMT0100 IN 0 ALIAS PLMT0100


* Filtra y ordena la tabla de planilla
SELECT PLMV0200
IF !TYPE("nCodigo") $ "UL"
		cFiltrando = "SET FILTER TO " + STR(nCodigo) + " = EMPRESA"
		&cFiltrando
		LOCATE
ENDIF
INDEX ON CODDEP TAG CODDEP
SET ORDER TO TAG CODDEP IN PLMV0200

* Filtra y ordena la tabla de empleados
SELECT PLMT0500
IF !TYPE("nCodigo") $ "UL"
		cFiltrando = "SET FILTER TO " + STR(nCodigo) + " = EMPRESA"
		&cFiltrando
		LOCATE
ENDIF
SET ORDER TO TAG LLAVE1 IN PLMT0500

* Filtra y ordena la tabla de ocupaciones
SELECT PLMT0200
IF !TYPE("nCodigo") $ "UL"
		cFiltrando = "SET FILTER TO " + STR(nCodigo) + " = EMPRESA"
		&cFiltrando
		LOCATE
ENDIF
SET ORDER TO TAG CODOCUP IN PLMT0200

* Filtra y ordena la tabla de departamentos
SELECT PLMT0100
IF !TYPE("nCodigo") $ "UL"
		cFiltrando = "SET FILTER TO " + STR(nCodigo) + " = EMPRESA"
		&cFiltrando
		LOCATE
ENDIF
SET ORDER TO TAG CODDEP IN PLMT0100

* Establece relaciones entre tablas
SELECT PLMV0200
SET RELATION TO CODEMP INTO PLMT0500
SELECT PLMT0500
SET RELATION TO CODOCUP INTO PLMT0200
SET RELATION TO CODDEP INTO PLMT0100 ADDITIVE


SELECT PLMV0200
*inicializaciones
*ordenar por departamento
IF contotales=1 THEN
	DO ESCRIBE_CABECERA
ENDIF
yaregistro1 = .F.
GO TOP
i= 1
DO WHILE NOT EOF()
	SCATTER MEMVAR
	IF yaregistro1 = .F. THEN
		yaregistro1 = .T.
		STORE 0.00 TO tdepsalario, tdephoras_extras, tdepcomisiones, tdepotros_gravados, tdeptotal_ingresos, tdepretencion_instituciones, tdepotros_descuentos, tdepisss, tdepafp, tdeprenta, tdeptotal_egresos, tdepviaticos, tdepotros_exentos, tdepsaldo_liquido
		STORE 0.00 TO tgensalario, tgenhoras_extras, tgencomisiones, tgenotros_gravados, tgentotal_ingresos, tgenretencion_instituciones, tgenotros_descuentos, tgenisss, tgenafp, tgenrenta, tgentotal_egresos, tgenviaticos, tgenotros_exentos, tgensaldo_liquido
		depactual = m.coddep
		IF contotales = 1 THEN
			SELECT XCPLRP0100
			APPEND BLANK
			APPEND BLANK
			REPLACE codigo WITH "Depto:"
			REPLACE empleado WITH m.coddep+" "+plmt0100.nomdep
			APPEND BLANK
			SELECT PLMV0200
		ENDIF
	ENDIF
	IF m.coddep <> depactual AND contotales = 1 THEN
		SELECT XCPLRP0100
		DO ESCRIBE_TOTALES_DEPARTAMENTO
		STORE 0.00 TO tdepsalario, tdephoras_extras, tdepcomisiones, tdepotros_gravados, tdeptotal_ingresos, tdepretencion_instituciones, tdepotros_descuentos, tdepisss, tdepafp, tdeprenta, tdeptotal_egresos, tdepviaticos, tdepotros_exentos, tdepsaldo_liquido
		depactual = m.coddep
		APPEND BLANK
		APPEND BLANK
		APPEND BLANK
		REPLACE codigo WITH "Depto:"
		REPLACE empleado WITH m.coddep+plmt0100.nomdep
		APPEND BLANK
		SELECT PLMV0200
	ENDIF
	nombreemp = ALLTRIM(plmt0500.apeemp)+", "+ALLTRIM(plmt0500.nomemp)
	ocupaemp = ALLTRIM(plmt0200.nomocup)
	nomdep = ALLTRIM(plmt0100.nomdep)
	DO ESCRIBE_DETALLE
	DO ACTUALIZA_TOTALES
	SKIP
ENDDO

IF yaregistro1 = .T. THEN
	IF contotales = 1 THEN
		SELE XCPLRP0100
		DO ESCRIBE_TOTALES_DEPARTAMENTO
		DO ESCRIBE_TOTALES_GENERAL
	ENDIF
	CLOSE DATA ALL
ELSE
	CLOSE DATA ALL
	MESSAGEBOX("La planilla de salarios est vaca." + CHR(13)+ "Genere una planilla antes de intentar guardarla.",48,"MILLENNIUM CONSULTING")
ENDIF

RELEASE viaticos200

PROCEDURE CREA_TABLA_EXCEL
	IF contotales = 1 THEN
		CREATE TABLE XCPLRP0100 (departamento C(20), codigo C(20), empleado C(60), ocupacion C(40),	dias_laborables C(20), salario C(20), horas_extras C(20), comisiones C(20), otros_gravados C(20), total_ingresos C(20), retencion_instituciones C(20), otros_descuentos C(20), isss C(20), afp C(20), renta C(20), total_egresos C(20), viaticos C(20), otros_exentos C(20), saldo_liquido C(20))  			
	ELSE
		CREATE TABLE XCPLRP0100 (departamento C(20), codigo C(20), empleado C(60), ocupacion C(40), dias_laborables N(20,2), salario N(20,2), horas_extras N(20,2), comisiones N(20,2), otros_gravados N(20,2), total_ingresos N(20,2), retencion_instituciones N(20,2), otros_descuentos N(20,2), isss N(20,2), afp N(20,2), renta N(20,2), total_egresos N(20,2), viaticos N(20,2), otros_exentos N(20,2), saldo_liquido N(20,2))
	ENDIF
	USE
ENDPROC

PROCEDURE ESCRIBE_CABECERA
	SELECT XCPLRP0100 
	APPEND BLANK
	APPEND BLANK
	REPLACE empleado WITH "PLANILLA DE SALARIOS"
	APPEND BLANK
	APPEND BLANK
	REPLACE codigo WITH "Empresa:"
	nomempre = IIF(TYPE("cEmpresa")="L" OR TYPE("cEmpresa")="U","Nombre de Empresa pendiente",cEmpresa)
	REPLACE empleado WITH nomempre
	IF R_PERINI = R_PERFIN THEN
		APPEND BLANK
		REPLACE empleado WITH "PERIODO "+ALLTRIM(STR(R_PERINI))+": ("+DTOC(R_FECHAINI1)+"-"+DTOC(R_FECHAINI2)+")" 
	ELSE
		APPEND BLANK 
		REPLACE empleado WITH "DESDE EL PERIODO "+ALLTRIM(STR(R_PERINI))+": ("+DTOC(R_FECHAINI1)+"-"+DTOC(R_FECHAINI2)+")" 
		APPEND BLANK
		REPLACE empleado WITH "HASTA EL PERIODO "+ALLTRIM(STR(R_PERFIN))+": ("+DTOC(R_FECHAFIN1)+"-"+DTOC(R_FECHAFIN2)+")" 
	ENDIF
	
	APPEND BLANK
	SELECT PLMV0200
ENDPROC

PROCEDURE ACTUALIZA_TOTALES
	tdepsalario = tdepsalario + ROUND(m.sueldo*15,2)
	tdephoras_extras = tdephoras_extras + m.vextnor + m.vextnoc
	tdepcomisiones = tdepcomisiones + m.otroing
	tdepotros_gravados = tdepotros_gravados + m.varios
	tdeptotal_ingresos = tdeptotal_ingresos + m.totdev
	tdepotros_descuentos = tdepotros_descuentos + m.retotros
	tdepretencion_instituciones = tdepretencion_instituciones + m.retinst
	tdepisss = tdepisss + m.retisss
	tdepafp = tdepafp + m.retafpt
	tdeprenta = tdeprenta + m.retrenta
	tdeptotal_egresos = tdeptotal_egresos + m.totdes
	tdepviaticos = tdepviaticos + viaticos200
	tdepotros_exentos = tdepotros_exentos + m.transporte
	tdepsaldo_liquido = tdepsaldo_liquido + ROUND(m.salliq,2)
		
	tgensalario = tgensalario + ROUND(m.sueldo*15,2)
	tgenhoras_extras = tgenhoras_extras + m.vextnor + m.vextnoc
	tgencomisiones = tgencomisiones + m.otroing
	tgenotros_gravados = tgenotros_gravados + m.varios
	tgentotal_ingresos = tgentotal_ingresos + m.totdev
	tgenotros_descuentos = tgenotros_descuentos + m.retotros
	tgenretencion_instituciones = tgenretencion_instituciones + m.retinst
	tgenisss = tgenisss + m.retisss
	tgenafp = tgenafp + m.retafpt
	tgenrenta = tgenrenta + m.retrenta
	tgentotal_egresos = tgentotal_egresos + m.totdes
	tgenviaticos = tgenviaticos + viaticos200
	tgenotros_exentos = tgenotros_exentos + m.transporte
	tgensaldo_liquido = tgensaldo_liquido + ROUND(m.salliq,2)
ENDPROC

PROCEDURE ESCRIBE_TOTALES_DEPARTAMENTO
	APPEND BLANK
	REPLACE empleado WITH "Totales del Departamento "+ depactual +" :"
	REPLACE salario WITH ALLTRIM(STR(tdepsalario,20,2)) 
	REPLACE horas_extras WITH ALLTRIM(STR(tdephoras_extras,20,2)) 
	REPLACE comisiones WITH ALLTRIM(STR(tdepcomisiones,20,2)) 
	REPLACE otros_gravados WITH ALLTRIM(STR(tdepotros_gravados,20,2)) 
	REPLACE total_ingresos WITH ALLTRIM(STR(tdeptotal_ingresos,20,2)) 
	REPLACE otros_descuentos WITH ALLTRIM(STR(tdepotros_descuentos,20,2)) 
	REPLACE retencion_instituciones WITH ALLTRIM(STR(tdepretencion_instituciones,20,2)) 
	REPLACE isss WITH ALLTRIM(STR(tdepisss,20,2)) 
	REPLACE afp WITH ALLTRIM(STR(tdepafp,20,2)) 
	REPLACE renta WITH ALLTRIM(STR(tdeprenta,20,2)) 
	REPLACE total_egresos WITH ALLTRIM(STR(tdeptotal_egresos,20,2)) 
	REPLACE viaticos WITH ALLTRIM(STR(tdepviaticos,20,2)) 
	REPLACE otros_exentos WITH ALLTRIM(STR(tdepotros_exentos,20,2)) 
	REPLACE saldo_liquido WITH ALLTRIM(STR(tdepsaldo_liquido,20,2)) 
ENDPROC

PROCEDURE ESCRIBE_TOTALES_GENERAL
	APPEND BLANK
	APPEND BLANK
	APPEND BLANK
	REPLACE empleado WITH "Totales Generales "
	REPLACE salario WITH ALLTRIM(STR(tgensalario,20,2)) 
	REPLACE horas_extras WITH ALLTRIM(STR(tgenhoras_extras,20,2)) 
	REPLACE comisiones WITH ALLTRIM(STR(tgencomisiones,20,2)) 
	REPLACE otros_gravados WITH ALLTRIM(STR(tgenotros_gravados,20,2)) 
	REPLACE total_ingresos WITH ALLTRIM(STR(tgentotal_ingresos,20,2)) 
	REPLACE otros_descuentos WITH ALLTRIM(STR(tgenotros_descuentos,20,2)) 
	REPLACE retencion_instituciones WITH ALLTRIM(STR(tgenretencion_instituciones,20,2)) 
	REPLACE isss WITH ALLTRIM(STR(tgenisss,20,2)) 
	REPLACE afp WITH ALLTRIM(STR(tgenafp,20,2)) 
	REPLACE renta WITH ALLTRIM(STR(tgenrenta,20,2)) 
	REPLACE total_egresos WITH ALLTRIM(STR(tgentotal_egresos,20,2)) 
	REPLACE viaticos WITH ALLTRIM(STR(tgenviaticos,20,2)) 
	REPLACE otros_exentos WITH ALLTRIM(STR(tgenotros_exentos,20,2)) 
	REPLACE saldo_liquido WITH ALLTRIM(STR(tgensaldo_liquido,20,2)) 
ENDPROC

PROCEDURE ESCRIBE_DETALLE
	IF contotales = 1 THEN
		m.departamento = ALLTRIM(m.coddep)
		m.codigo = ALLTRIM(m.codemp)
		m.empleado = nombreemp
		m.ocupacion = ocupaemp
		m.dias_laborables = ALLTRIM(STR(m.diaslab))
		m.salario = ALLTRIM(STR(ROUND(m.sueldo*15,2),20,2))
		m.horas_extras = ALLTRIM(STR(m.vextnor+m.vextnoc,20,2))
		m.comisiones = ALLTRIM(STR(m.otroing,20,2))
		m.otros_gravados = ALLTRIM(STR(m.varios,20,2))
		m.total_ingresos = ALLTRIM(STR(m.totdev,20,2))
		m.retencion_instituciones = ALLTRIM(STR(m.retinst,20,2))
		m.otros_descuentos = ALLTRIM(STR(m.retotros,20,2))
		m.isss = ALLTRIM(STR(m.retisss,20,2))
		m.afp = ALLTRIM(STR(m.retafpt,20,2))
		m.renta = ALLTRIM(STR(m.retrenta,20,2))
		m.total_egresos = ALLTRIM(STR(m.totdes,20,2))
		viaticos200 = m.viaticos
		m.viaticos = ALLTRIM(STR(m.viaticos,20,2))
		m.otros_exentos = ALLTRIM(STR(m.transporte,20,2))
		m.saldo_liquido = ALLTRIM(STR(ROUND(m.salliq,2),20,2))
	ELSE
		m.departamento = ALLTRIM(m.coddep)
		m.codigo = ALLTRIM(m.codemp)
		m.empleado = nombreemp
		m.ocupacion = ocupaemp
		m.dias_laborables = m.diaslab
		m.salario = ROUND(m.sueldo*15,2)
		m.horas_extras = m.vextnor+m.vextnoc
		m.comisiones = m.otroing
		m.otros_gravados = m.varios
		m.total_ingresos = m.totdev
		m.retencion_instituciones = m.retinst
		m.otros_descuentos = m.retotros
		m.isss = m.retisss
		m.afp = m.retafpt
		m.renta = m.retrenta
		m.total_egresos = m.totdes
		viaticos200 = m.viaticos
		m.viaticos = m.viaticos
		m.otros_exentos = m.transporte
		m.saldo_liquido = ROUND(m.salliq,2)
	ENDIF
	
	INSERT INTO XCPLRP0100 FROM MEMVAR

ENDPROC