*:*****************************************************************
*:	PROGRAMA	: PLRP1000.PRG
*:	FECHA		: AGOSTO DE 1998.
*:	FUNCION		: RECIBOS DE LIQUIDACION
*:  ANALISTA    : DR. VICENT-RAMON PALASI LALLANA
*:******************************************************************

#DEFINE MAXFILAS 30

CLOSE DATA ALL
SET PROC TO CILIB001
PUBLIC TIP_RECIBO, R_PERINI, R_PERFIN, OPCION, R_FECHAINI1, R_FECHAINI2, R_FECHAFIN1, R_FECHAFIN2 

XPLPERMITERECIBOAMPLIADO = LEEVARBOOLDEFECTO('XPLPERMITERECIBOAMPLIADO', .F.)
TIP_RECIBO = 1
IF XPLPERMITERECIBOAMPLIADO THEN
	DO FORM PLRP1000 WITH 'XPLRECIBOLIQUIDACIONVARIOSPERIODOS'
ELSE
	DO FORM PLRP0100 WITH 'XPLRECIBOLIQUIDACIONVARIOSPERIODOS'
ENDIF

IF OPCION = 1 THEN
	DO CASE
		CASE TIP_RECIBO = 1 
			DO CREA_TABLA_PLMV0200_MULTIPLANILLA IN PLLIB001 WITH 'temporal', R_PERINI, R_PERFIN
			DO IMPRIME_REPORTE IN CILIB001 WITH ('PLRP1000'), (''), ('CIRP0110')

		CASE TIP_RECIBO = 2 
			PUBLIC TOTALITEMS
			R_PERIODO = R_PERINI
			DO GENERA
			DO IMPRIME_REPORTE IN CILIB001 WITH ('PLRP1010'), (''), ('CIRP0110')	
			RELEASE TOTALITEMS	
	ENDCASE
ENDIF
DO DESTRUYEVARIABLESMONEDAREP IN CILIB001
CLOSE DATA ALL
RELEASE TIP_RECIBO, R_PERINI, R_PERFIN, OPCION, R_FECHAINI1, R_FECHAINI2, R_FECHAFIN1, R_FECHAFIN2 


PROCEDURE GENERA

	SELECT PLMT0600.*, PLMV0200.FECPAG;
	FROM PLMT0600, PLMV0200;
	INTO TABLE (dirtemp+"wxxplmt0600.dbf");
	WHERE ALLTRIM(UPPER(PLMT0600.CODEMP)) == ALLTRIM(UPPER(PLMV0200.CODEMP)) AND;
		PLMT0600.periodo = PLMV0200.periodo AND PLMT0600.empresa = PLMV0200.empresa AND;
		BETWEEN(PLMT0600.periodo, R_PERINI, R_PERFIN) AND PLMT0600.empresa = nCodigo 
	SELE wxxplmt0600
	USE
	
	IF TYPE('W_COTIZAGENERAPLANILLA') <> 'U' THEN
		RELEASE W_COTIZAGENERAPLANILLA
	ENDIF 

	DIMENSION BASURA(1), W_COTIZAGENERAPLANILLA(1)

	CREARMATRICESMONEDA ('',  R_FECHAINI1, R_FECHAFIN2 , @basura, @W_COTIZAGENERAPLANILLA)
	
	
	TRADUCETABLAMONEDABETA(dirtemp+'wxxplmt0600.dbf','wxplmt0600',  @W_COTIZAGENERAPLANILLA, 'valdes', '', .T.)
	
	TRADUCETABLAMONEDAGAMMA(dirtemp+'wxplmt0600','wplmt0600',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, 'fecpag', 'valdes', 'BETWEEN(periodo,'+ STR(R_PERINI) + ','+ STR(R_PERFIN)+') AND empresa = '+ STR(nCodigo))	
	
		
	mntl = "sueldo, salhora, valinca, vextnor, vextnoc, vjornada, varios, otroing, vacaciones, totdev,"
	mntl = mntl +"retanti, retinst, retotros, retisss, pension, retafp1, retafp2, retafpt, retrenta, ppafpsa, ppisspe, totdes, salliq, viaticos, transporte"
	
	TRADUCETABLAMONEDAGAMMA('plmv0200','wplmv0200',W_MONEDAREP, W_TIPOCAMBIOREP, @W_COTIZAREP, 'fecpag', mntl, 'BETWEEN(periodo,'+ STR(R_PERINI) + ','+ STR(R_PERFIN)+') AND empresa = '+ STR(nCodigo))	
	CLOSE DATA ALL
	
	IF TYPE('nCodigo') <>'N' THEN
		USE (cdirectorio+"config\opciones") IN 0
		RESTORE FROM MEMO opciones.codigo ADDITIVE
		USE IN opciones
	ENDIF
	&& Se colocan por valores por defecto en las variables

	XPLINGRESOSRECIBO1 = 'plmv0200.diaslab'
	XPLINGRESOSRECIBO2 = 'plmv0200.jornada'
	XPLINGRESOSRECIBO3 = 'plmv0200.vjornada'
	XPLINGRESOSRECIBO4 = 'plmv0200.hextnor'
	XPLINGRESOSRECIBO5 = 'plmv0200.vextnor'
	XPLINGRESOSRECIBO6 = 'plmv0200.hextnoc'
	XPLINGRESOSRECIBO7 = 'plmv0200.vextnoc'
	XPLINGRESOSRECIBO8 = 'plmv0200.otroing'
	XPLINGRESOSRECIBO9 = 'plmv0200.varios'
	XPLINGRESOSRECIBO10 ='plmv0200.diasinc'
	XPLINGRESOSRECIBO11 ='plmv0200.valinca'
	XPLINGRESOSRECIBO12 ='plmv0200.viaticos'
	XPLINGRESOSRECIBO13 ='plmv0200.transporte'

	XPLEGRESOSRECIBO1 = 'plmv0200.retanti'
	XPLEGRESOSRECIBO2 = 'plmv0200.retisss'
	XPLEGRESOSRECIBO3 = 'plmv0200.retafpt'
	XPLEGRESOSRECIBO4 = 'plmv0200.retrenta'

	FORMATOINGRESOS1 = '2#Dias laborados' 
	FORMATOINGRESOS2 = '2#Horas jornada laboral' 
	FORMATOINGRESOS3 = '1#Sueldo'
	FORMATOINGRESOS4 = '2#Horas extras diurnas' 
	FORMATOINGRESOS5 = '1#Sueldo horas extras diurnas'
	FORMATOINGRESOS6 = '2#Horas extras nocturnas'
	FORMATOINGRESOS7 = '1#Sueldo horas extras nocturnas'
	FORMATOINGRESOS8 = '1#Comisiones' 
	FORMATOINGRESOS9 = '1#Varios'
	FORMATOINGRESOS10 = '2#Dias incapacidad'
	FORMATOINGRESOS11 = '1#Valor incapacidad'
	FORMATOINGRESOS12 = '1#Viticos' 
	FORMATOINGRESOS13 = '1#Otros exentos' 

	FORMATOEGRESOS1 = '1#Anticipos'
	FORMATOEGRESOS2 = '1#ISSS' 
	FORMATOEGRESOS3 = '1#AFP' 
	FORMATOEGRESOS4 = '1#Renta' 
	
	USE plmt0300 IN 0 ALIAS plmt0300
	SELE plmt0300
	SET FILTER TO empresa = nCodigo AND periodo = R_PERIODO
	GO TOP
    i = 5
	DO WHILE i< MAXFILAS AND NOT EOF()
		comando = 'XPLEGRESOSRECIBO'+ALLTRIM(STR(i))+" = "+ CHR(34) +"descuento["+plmt0300.nomins+"]"+ CHR(34)
		&comando
		comando = 'FORMATOEGRESOS'+ALLTRIM(STR(i))+" = "+ CHR(34) +"1#"+plmt0300.nomins+ CHR(34)
		&comando
		i = i+1
		SKIP
	ENDDO

	NUMEROINSTITUCIONESDERETENCION = i -5
	comando = 'XPLEGRESOSRECIBO'+ALLTRIM(STR(i))+" = " + CHR(34)+ "plmv0200.retotros" +CHR(34)
	&comando
	comando = 'FORMATOEGRESOS'+ALLTRIM(STR(i))+" = " + CHR(34)+ "1#Otros descuentos" +CHR(34)
	&comando
	
	&& Si hay algn valor definido especficamente en la tabla de variables, reemplaza al valor por defecto

	XPLNUMINGRESOS = VAL(LEEVARDEFECTO('XPLNUMINGRESOS','13'))
	
	IF XPLNUMINGRESOS > MAXFILAS THEN
		XPLNUMINGRESOS =  MAXFILAS
	ENDIF

	FOR i = 1 TO XPLNUMINGRESOS
		IF DEFINIDAVAR('XPLINGRESOSRECIBO'+ALLTRIM(STR(i))) THEN
			comando = 'XPLINGRESOSRECIBO'+ALLTRIM(STR(i))+' = '+ CHR(34) + ANTESDELSOSTENIDO(LEEVAR('XPLINGRESOSRECIBO'+ALLTRIM(STR(i))))+ CHR(34)
			&comando
			comando = 'FORMATOINGRESOS'+ALLTRIM(STR(i))+' = '+ CHR(34) + DESPUESDELSOSTENIDO(LEEVAR('XPLINGRESOSRECIBO'+ALLTRIM(STR(i))))+ CHR(34)
			&comando
		ENDIF
	ENDFOR

	XPLNUMEGRESOS = VAL(LEEVARDEFECTO('XPLNUMEGRESOS',STR(5+NUMEROINSTITUCIONESDERETENCION)))


	IF XPLNUMEGRESOS > MAXFILAS THEN
		XPLNUMEGRESOS =  MAXFILAS
	ENDIF
	
	TOTALITEMS = XPLNUMINGRESOS+XPLNUMEGRESOS
	
	FOR i = 1 TO XPLNUMEGRESOS
		IF DEFINIDAVAR('XPLEGRESOSRECIBO'+ALLTRIM(STR(i))) THEN
			comando = 'XPLEGRESOSRECIBO'+ALLTRIM(STR(i))+' = '+ CHR(34) + ANTESDELSOSTENIDO(LEEVAR('XPLEGRESOSRECIBO'+ALLTRIM(STR(i))))+ CHR(34)
			&comando
			comando = 'FORMATOEGRESOS'+ALLTRIM(STR(i))+' = '+ CHR(34) + DESPUESDELSOSTENIDO(LEEVAR('XPLEGRESOSRECIBO'+ALLTRIM(STR(i))))+ CHR(34)
			&comando
		ENDIF
	ENDFOR

	&& Reemplaza en las expresiones el nombre de instituciones por sus cdigos

	FOR i = 1 TO XPLNUMINGRESOS
			comando = 'XPLINGRESOSRECIBO'+ALLTRIM(STR(i))+' = TRANSFORMARDESCUENTOSENCAMPO(XPLINGRESOSRECIBO'+ALLTRIM(STR(i))+')'
			&comando
	ENDFOR

	FOR i = 1 TO XPLNUMEGRESOS
			comando = 'XPLEGRESOSRECIBO'+ALLTRIM(STR(i))+' = TRANSFORMARDESCUENTOSENCAMPO(XPLEGRESOSRECIBO'+ALLTRIM(STR(i))+')'
			&comando
	ENDFOR

	&& Crea la tabla o la vaca si ya exista

	IF FILE(dirraiz+"PLANILLA\TEMPREC.DBF") THEN
		SET EXCLUSIVE ON
		USE temprec IN 0 ALIAS temprec
		SELE temprec
		ZAP
		USE
		SET EXCLUSIVE OFF
		USE temprec IN 0 ALIAS temprec
	ELSE
		CREATE TABLE temprec (fila N(2,0), columna C(1), codemp C(5), coddep C(4), titulo C(40), cantidad N(16,2),;
		posicion C(1), totdev N(20,2), totdes N(20,2), salliq N(20,2), periodo N(6,0))
		USE temprec
	ENDIF

	&& Llena la tabla con valores

	USE (dirtemp+"wplmt0600") IN 0 ALIAS plmt0600
	USE (dirtemp+"wplmv0200") IN 0 ALIAS plmv0200
	SELE plmv0200
	SET FILTER TO empresa = nCodigo
	GO TOP
	DO WHILE NOT EOF()
		SELE temprec
		FOR i = 1 TO XPLNUMINGRESOS
			APPEND BLANK
			REPLACE fila WITH i, columna WITH '1', codemp WITH plmv0200.codemp, coddep WITH plmv0200.coddep, totdev WITH plmv0200.totdev, totdes WITH plmv0200.totdes, salliq WITH plmv0200.salliq, periodo WITH plmv0200.periodo
			comando = 'REPLACE temprec.cantidad WITH '+ EXTSTR(EVALUAR('XPLINGRESOSRECIBO'+ALLTRIM(STR(i)),plmv0200.periodo))+', temprec.posicion WITH ANTESDELSOSTENIDO(FORMATOINGRESOS'+ALLTRIM(STR(i))+")" + ', temprec.titulo WITH UPPER(DESPUESDELSOSTENIDO(FORMATOINGRESOS'+ALLTRIM(STR(i))+"))"	
		 	&comando
		ENDFOR
	
		FOR i = 1 TO XPLNUMEGRESOS
			APPEND BLANK
			REPLACE fila WITH i, columna WITH '2', codemp WITH plmv0200.codemp, coddep WITH plmv0200.coddep, totdev WITH plmv0200.totdev, totdes WITH plmv0200.totdes, salliq WITH plmv0200.salliq, periodo WITH plmv0200.periodo
			comando = 'REPLACE temprec.cantidad WITH '+ EXTSTR(EVALUAR('XPLEGRESOSRECIBO'+ALLTRIM(STR(i)),plmv0200.periodo))+', temprec.posicion WITH ANTESDELSOSTENIDO(FORMATOEGRESOS'+ALLTRIM(STR(i))+")" + ', temprec.titulo WITH UPPER(DESPUESDELSOSTENIDO(FORMATOEGRESOS'+ALLTRIM(STR(i))+"))"	
		 	&comando
		ENDFOR
				
		SELE plmv0200
		SKIP
	ENDDO
	
	DO CREATABLASUMAGRUPOS IN CILIB001 WITH 'temprec','temporal',"cantidad, totdev, totdes, salliq", 'periodo BETWEEN '+ALLTRIM(STR(R_PERINI))+' AND '+ALLTRIM(STR(R_PERFIN)),'codemp, columna, fila', 'coddep, codemp, columna, fila'
	CLOSE DATA ALL
ENDPROC

FUNCTION EVALUAR(ncampo, elperiodo)
	&& Evalua una expresin de ingreso o egreso y devuelve un valor
	LOCAL campo, posdes1, posdes2, valordes
	
	campo = ALLTRIM(&ncampo)
	posdes1 = AT('descuenc[',campo)
	&& Reemplaza todos los descuentos por sus valores
	DO WHILE posdes1 <>0
		posdes2 = AT(']', SUBSTR(campo,posdes1))+posdes1 -1
		posdesm = AT('[', SUBSTR(campo,posdes1))+posdes1 -1
		valordes = VALORDESCUENTO(ALLTRIM(SUBSTR(campo,posdesm+1, posdes2-posdesm-1)), elperiodo)
		campo = SUBSTR(campo, 1, posdes1-1)+ EXTSTR(valordes)+SUBSTR(campo, posdes2+1)
		posdes1 = AT('descuenc[',campo)
	ENDDO
	&& Evalua el resto de la expresin por la sustitucin de macro
	RETURN &campo
ENDFUNC

FUNCTION VALORDESCUENTO(nombrecampo, elperiodo)
	&& Devuelve un descuento de una institucin de retencin
	LOCAL resultado
	PUBLIC quitar
	quitar = .F.
	GUARDAESTADO()
	SELE plmt0600
	comando = 'LOCATE FOR ALLTRIM(codemp) == ALLTRIM(plmv0200.codemp) AND ALLTRIM(codins) == '+CHR(34)+ALLTRIM(nombrecampo)+CHR(34)+'AND empresa = nCodigo AND periodo = elperiodo'
	&comando
	IF FOUND() THEN
		IF plmt0600.fecfin >= W_HASTA OR EMPTY(plmt0600.fecfin) THEN
			IF plmt0600.fredes = 2
				resultado = plmt0600.valdes
			ELSE
				IF plmt0600.fredes = 1 THEN
					resultado = (plmt0600.valdes)/2
				ELSE
					resultado = 0
				ENDIF
			ENDIF	
		ELSE
			resultado = 0
		ENDIF
	ELSE
		resultado = 0
	ENDIF
	RECUPERAESTADO()
	RETURN resultado
ENDFUNC

FUNCTION ANTESDELSOSTENIDO(str)
	RETURN SUBSTR(str,1, AT('#',str)-1)
ENDFUNC

FUNCTION DESPUESDELSOSTENIDO(str)
	RETURN SUBSTR(str,AT('#',str)+1)
ENDFUNC

FUNCTION TRANSFORMARDESCUENTOSENCAMPO(ncampo)
	&& Reemplaza los nombres de las instituciones por sus cdigos en una expresin de ingreso o egreso
	LOCAL campo, posdes1, posdes2, codigo
	
	campo = ALLTRIM(ncampo)
	posdes1 = AT('descuento[',campo)
	DO WHILE posdes1 <>0
		posdes2 = AT(']', SUBSTR(campo,posdes1))+posdes1 -1
		posdesm = AT('[', SUBSTR(campo,posdes1))+posdes1 -1
		codigo = CODIGOINSTITUCION(ALLTRIM(SUBSTR(campo,posdesm+1, posdes2-posdesm-1)))
		campo = SUBSTR(campo, 1, posdes1-1)+ 'descuenc['+ALLTRIM(codigo)+']'+SUBSTR(campo, posdes2+1)
		posdes1 = AT('descuento[',campo)
	ENDDO
	RETURN campo
ENDFUNC

FUNCTION CODIGOINSTITUCION(nombreinst)
	GUARDAESTADO()
	SELE plmt0300
	LOCATE FOR NORMALIZAPALABRA(nomins) == NORMALIZAPALABRA(nombreinst) AND empresa = nCodigo
	IF FOUND() THEN
		RETURN plmt0300.codins
	ELSE
		RETURN "$&$%/$%"
	ENDIF
	RECUPERAESTADO()
ENDFUNC
