*:******************************************************************************
*:
*: Archivo de procedimientoC:\BACKUP\DOCU\SETOBJRF.PRG
*:
*:	
*:	
*:	
*:	
*:	
*:	
*:	
*:	
*:	
*:	
*:	
*:	
*:	
*:
*: Documentado mediante la versin del Asistente para formato de Visual FoxPro  .05
*:******************************************************************************
*:   SetObjRf
* SetObjRf.PRG - Set Object Referece.
* Copyright (c) 1997 Microsoft Corp.
* 1 Microsoft Way
* Redmond, WA 98052
* Description:
* Set an object reference to a specified property based on a specified class.
* Return new instance of specified class if name is an empty string.

Lparameters toObject,tcName,tvClass,tvClassLibrary
Local lcName,lcClass,lcClassLibrary,oObject,lnCount
Local lnObjectRefIndex,lnObjectRefCount,oExistingObject

If TYPE("toObject")#"O" OR ISNULL(toObject)
	Return .NULL.
Endif
lcName=IIF(TYPE("tcName")=="C",ALLTRIM(tcName),LOWER(SYS(2015)))
oExistingObject=.NULL.
oObject=.NULL.
lcClassLibrary=""
Do CASE
Case TYPE("tvClass")=="O"
	oObject=tvClass
	lcClass=LOWER(oObject.Class)
	lcClassLibrary=LOWER(oObject.ClassLibrary)
	If NOT ISNULL(oExistingObject) AND LOWER(oExistingObject.Class)==lcClass AND ;
			LOWER(oExistingObject.ClassLibrary)==lcClassLibrary
		toObject.vresult=oExistingObject
		Return toObject.vresult
	Endif
Case EMPTY(tvClass)
	oObject=toObject
	lcClass=LOWER(oObject.Class)
	lcClassLibrary=LOWER(oObject.ClassLibrary)
	If NOT ISNULL(oExistingObject) AND LOWER(oExistingObject.Class)==lcClass AND ;
			LOWER(oExistingObject.ClassLibrary)==lcClassLibrary
		toObject.vresult=oExistingObject
		Return toObject.vresult
	Endif
Otherwise
	lcClass=LOWER(ALLTRIM(tvClass))
	Do CASE
	Case TYPE("tvClassLibrary")=="O"
		lcClassLibrary=LOWER(tvClassLibrary.ClassLibrary)
	Case TYPE("tvClassLibrary")=="C"
		If EMPTY(tvClassLibrary)
			lcClassLibrary=LOWER(toObject.ClassLibrary)
		Else
			lcClassLibrary=LOWER(ALLTRIM(tvClassLibrary))
			If EMPTY(JUSTEXT(lcClassLibrary))
				lcClassLibrary=LOWER(FORCEEXT(lcClassLibrary,"vcx"))
			Endif
			llClassLib=(JUSTEXT(lcClassLibrary)=="vcx")
			If NOT "\"$lcClassLibrary
				lcClassLibrary=LOWER(FORCEPATH(lcClassLibrary,JUSTPATH(toObject.ClassLibrary)))
				If NOT FILE(lcClassLibrary) AND VERSION(2)#0
					lcClassLibrary=LOWER(FORCEPATH(lcClassLibrary,HOME()+"ffc\"))
					If NOT FILE(lcClassLibrary)
						lcClassLibrary=LOWER(FULLPATH(JUSTFNAME(lcClassLibrary)))
					Endif
				Endif
			Endif
			If NOT FILE(lcClassLibrary)
				toObject.vresult=.NULL.
				Return toObject.vresult
			Endif
		Endif
	Otherwise
		lcClassLibrary=""
	Endcase
	If NOT ISNULL(oExistingObject) AND LOWER(oExistingObject.Class)==lcClass AND ;
			LOWER(oExistingObject.ClassLibrary)==lcClassLibrary
		toObject.vresult=oExistingObject
		Return toObject.vresult
	Endif
	oObject=NEWOBJECT(lcClass,lcClassLibrary)
	If TYPE("oObject")#"O" OR ISNULL(oObject)
		toObject.vresult=.NULL.
		Return toObject.vresult
	Endif
Endcase
Do CASE
Case EMPTY(lcName)
	toObject.vresult=oObject
	Return toObject.vresult
Otherwise
	If NOT toObject.AddProperty(lcName,oObject)
		oObject=.NULL.
	Endif
Endcase
If ISNULL(oObject)
	toObject.vresult=.NULL.
	Return toObject.vresult
Endif
If PEMSTATUS(oObject,"oHost",5)
	oObject.ohost=toObject.ohost
Else
	oObject.AddProperty("oHost",toObject.ohost)
Endif
If EMPTY(lcClassLibrary)
	lcClassLibrary=LOWER(oObject.ClassLibrary)
Endif
lnObjectRefCount=toObject.nobjectrefcount
lnObjectRefIndex=lnObjectRefCount+1
For lnCount = 1 TO lnObjectRefCount
	If toObject.aObjectRefs[lnCount,1]==LOWER(lcName)
		lnObjectRefIndex=lnCount
		Exit
	Endif
Endfor
If lnObjectRefIndex>lnObjectRefCount
	Dimension toObject.aObjectRefs[lnObjectRefIndex,3]
Endif
toObject.aObjectRefs[lnObjectRefIndex,1]=LOWER(lcName)
toObject.aObjectRefs[lnObjectRefIndex,2]=lcClass
toObject.aObjectRefs[lnObjectRefIndex,3]=lcClassLibrary
toObject.vresult=oObject
Return toObject.vresult
